#ifndef IOCTL_H
#define IOCTL_H

#include <stdlib.h>

/* List of status codes					*/
/* Status code for operation.			*/
/* A zero value indicates success,		*/
/* other codes are the extended			*/
/* DOS codes.							*/

typedef enum {                          
	 flOK                      = 0,
	 flBadFunction             = 1,
	 flFileNotFound            = 2,
	 flPathNotFound            = 3,
	 flTooManyOpenFiles        = 4,
	 flNoWriteAccess           = 5,
     flBadFileHandle           = 6,
     flDriveNotAvailable       = 9,
     flNonFATformat            = 10,
     flFormatNotSupported      = 11,
     flNoMoreFiles             = 18,
     flWriteProtect            = 19,
     flBadDriveHandle          = 20,
     flDriveNotReady           = 21,
     flUnknownCmd              = 22,
     flBadFormat               = 23,
     flBadLength               = 24,
     flDataError               = 25,
     flUnknownMedia            = 26,
     flSectorNotFound          = 27,
     flOutOfPaper              = 28,
     flWriteFault              = 29,
     flReadFault               = 30,
     flGeneralFailure          = 31,
     flDiskChange              = 34,
     flVppFailure              = 50,
     flBadParameter            = 51,
     flNoSpaceInVolume         = 52,
     flInvalidFATchain         = 53,
     flRootDirectoryFull       = 54,
     flNotMounted              = 55,
     flPathIsRootDirectory     = 56,
     flNotADirectory           = 57,
     flDirectoryNotEmpty       = 58,
     flFileIsADirectory        = 59,
     flAdapterNotFound         = 60,
     flFormattingError         = 62,
     flNotEnoughMemory         = 63,
     flVolumeTooSmall          = 64,
     flBufferingError          = 65,
	 flFileAlreadyExists       = 80,
	 flIncomplete              = 100,
	 flTimedOut                = 101,
	 flTooManyComponents       = 102,
	 flTooManyDrives           = 103,
	 flTooManyBinaryPartitions = 104,
	 flPartitionNotFound       = 105,
	 flFeatureNotSupported     = 106,
	 flWrongVersion            = 107,
	 flTooManyBadBlocks        = 108,
	 flNotProtected            = 109,
	 flUnchangeableProtection  = 110,
	 flBadDownload             = 111,
	 flBadBBT                  = 112,
	 flInterlreavError         = 113,
	 flWrongKey                = 114,
	 flHWProtection            = 115,
	 flTimeOut                 = 116

	 } FLStatus;


/* List of OpCodes */
#define RESET		       0x00
#define READ_STATUS	       0x70
#define READ_SECTORS	   0x02
#define WRITE_SECTORS	   0x03
#define VERIFY_SECTORS	   0x04
#define FORMAT_TRACK	   0x05
#define BAD_FUNCTION	   0x06
#define DISK_PARMS	       0x08
#define SEEK		       0x0c
#define RESET_FIXED_DISKS  0x0d
#define GET_DRIVE_STATUS   0x10
#define DISK_TYPE	       0x15
#define DISK_CHANGE_STATUS 0x16
#define IOCTL_READ	       0x1b
#define IOCTL_WRITE	       0x1f


/* List of all IOCTL requests ( IOCTL ID ) */

#define GET_INFO_IOCTL				"GETINFO"
#define SW_PROTECTION_IOCTL			"PROTECT"
#define DELETE_SECTORS_IOCTL		"DELSECT"
#define DEFRAG_IOCTL        		"DEFRAG"
#define BDTL_HW_PROTECTION_IOCTL  	"BDTLHW"
#define BIN_HW_PROTECTION_IOCTL		"BINHW"
#define HW_OTP_IOCTL				"HWOTP"
#define CUSTOMER_ID_IOCTL   		"CUSTOMER"
#define UNIQUE_ID_IOCTL     		"UNIQUE"
#define DEEPOWER_MODE_IOCTL 		"DEEPOWER"


typedef unsigned char  byte;        /* 8  bit unsigned variable */
typedef unsigned short word;        /* 16 bit unsigned variable */
typedef unsigned long  dword;       /* 32 bit unsigned variable */


/* General IOCTL request structure */

typedef struct	{
  char		id[16];		
  void far* DiskInput;
  void far* DiskOutput;
} IOCTLRequestPacket;


/* GetInfo Input/Output structure */

typedef struct {
  unsigned long  logicalSectors;    /*  number of logical sectors                  */
  unsigned long  bootAreaSize;      /*  boot area size                             */
  unsigned long  baseAddress;       /*  physical base address                      */
  unsigned short flashType;         /*  JEDEC id of the flash                      */
  unsigned long  physicalSize;      /*  physical size of the media                 */
  unsigned short physicalUnitSize;  /*  Erasable block size                        */
  char DOCType;                     /*  DiskOnChip type (MDoc/Doc2000)             */
  char lifeTime;                    /*  Life time indicator for the media (1-10)   */
                                    /*  1 - the media is fresh,                    */
                                    /*  10 - the media is close to its end of life */
  char driverVer[10];               /*  driver version (NULL terminated string)    */
  char OSAKVer[10];                 /*  OSAK version that driver is based on
                                        (NULL terminated string)                   */
  unsigned long cylinders;          /*  Media.....                                 */
  unsigned long heads;              /*            geometry......                   */
  unsigned long sectors;            /*                            parameters.      */
} VolumeInfoRecordOutput;




typedef struct {
  VolumeInfoRecordOutput info;
  FLStatus status;
} flDiskInfoOutput;

/* Delete Sectors Input/Output structure */
typedef struct {
  long firstSector;                /* First logical sector to delete */
  long numberOfSectors;                /* Number of sectors to delete */
} DeleteSectorsInput;


/* Defrag Input/Output structures */

/* Defragment volume (FL_IOCTL_DEFRAGMENT) */
/* Input record: */
typedef struct {
  long requiredNoOfSectors;   /* Minimum number of sectors to make available.
                                  if -1 then a quick garbage collection operation
                                 is invoked. */
} flDefragInput;

/* Outout record: */
typedef struct {
  long actualNoOfSectors;     /* Actual number of sectors available */
  FLStatus status;
} flDefragOutput;


/* HW-protect Input/OutPut structures and definitions */
/* BDK and BDTL protection operations: (FL_IOCTL_BINARY_HW_PROTECTION) */
/*                                     (FL_IOCTL_BDTL_HW_PROTECTION)   */
/*   insert key \ remove key \ identify \ change key \                 */
/*   change protection type \ change lock status                       */
/* Input record: */
typedef struct {
   byte protectionType; /* see flbase.h for the protection attributes */
   byte key[8];             /* The new key to the change Key call         */
   byte type;                     /* Operation type see list bellow             */
} flProtectionInput;

#define PROTECTION_INSERT_KEY   0
#define PROTECTION_REMOVE_KEY   1
#define PROTECTION_GET_TYPE     2
#define PROTECTION_DISABLE_LOCK 3
#define PROTECTION_ENABLE_LOCK  4
#define PROTECTION_CHANGE_KEY   5
#define PROTECTION_CHANGE_TYPE  6

#define PROTECTABLE			1
#define READ_PROTECTED			2
#define WRITE_PROTECTED			4
#define LOCK_ENABLED			8
#define LOCK_ASSERTED	     		16
#define KEY_INSERTED			32
#define CHANGEABLE_PROTECTION	64


/* HW_OTP Input/output structures and definisions*/

/* One Time Programing operations: (FL_IOCTL_OTP */
/*   OTP size \ OTP read \ OTP write and lock    */
/* Input record: */
typedef struct {
dword       length;           /* Length to read\write\size                  */
dword       usedSize;         /* The written size of the area \ Area offset */
byte        lockedFlag;       /* The area condition LOCKED_OTP (flflash.h)  */
byte        far* buffer;     /* pointer to user buffer                     */
word        type;             /* defined bellow                             */
} flOtpInput;
#define OTP_SIZE			1
#define OTP_READ			2
#define OTP_WRITE_LOCK		        3


/* Customer&Unique ID Output structures */
/* Read customer ID (FL_IOCTL_CUSTOMER_ID) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  byte id[4];
  FLStatus status;
} flCustomerIdOutput;


/* Read unique ID (FL_IOCTL_UNIQUE_ID) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  byte id[16];
  FLStatus status;
} flUniqueIdOutput;


/* PowerDown Input/Output structure */


typedef struct {
FLStatus status;
} OutputStatusRecord;

#define POWER_DOWN_ON 1
#define POWER_DOWN_OFF 0

typedef struct {
byte state;
} PowerDownInput;
#endif