/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/***********************************************************************************/
/*																				   */
/*	Header file containing definitions used by external API						   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/version 7.0/TrueFFS FS/src/mdoc/_common.h-arc  $
 *
 *    Rev 1.1   Aug 09 2006 16:52:44   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef _COMMON_H
#define _COMMON_H

/**************************************************************************/
/* General types definitions                                              */
/*   TrueFFS interface of all packages uses the following types as the    */
/*   variable definision.                                                 */
/**************************************************************************/

typedef int            FLBoolean;
typedef unsigned char  FLByte;           /* 8  bit unsigned variable */
typedef unsigned short FLWord;           /* 16 bit unsigned variable */
typedef unsigned long  FLDword;          /* 32 bit unsigned variable */
typedef unsigned int   FLNative;         /* Native variable at least 16 bits */
typedef signed char    FLSByte;          /* 8  bit signed variable */
typedef signed short   FLSWord;          /* 16 bit signed variable */
typedef signed long    FLSDword;         /* 32 bit signed variable */
typedef int            FLSNative;        /* Signed native variable at least 16 bits */
typedef FLSWord        FLWchar;          /* Unicode type variable */
typedef FLDword        CardAddress ;	 /* Physical offset on card */

/**************************************************************************/
/*                            I O r e q                                 */
/*                                                                      */
/* IOreq is a common structure passed to all TrueFFS functions.         */
/* Refer to the description of individual functions for specific usage  */
/* of fields. Some fields have different names when used by different   */
/* functions, hence the use of unions.                                  */
/*                                                                      */
/**************************************************************************/

typedef unsigned FLHandle;     /* Handle of an open file or drive.     */
                               /* Actually an index to file table or   */
                               /* drive table.                         */


typedef struct {
  FLHandle   irHandle;         /* Handle of file or drive for operation*/
  FLDword    irFlags;          /* function-specific flags              */
  void     * irPath;	       /* path of file for operation 		   */
  void	   * irData;           /* Pointer to user-buffer for operation */
  FLSDword   irLength;         /* No. of bytes, size or position for   */
                               /* operation                            */
  FLSDword   irCount;          /* Count or offset for operaion         */
} IOreq;

/**************************************************************************/
/* Special ioreq field names:                                             */
/* IOReq structure is the basic IO type used for all TrueFFS calls.       */
/* Some of the fields has additional name for more trivial use of the     */
/* function. The duplicate names are defined below.                       */
/**************************************************************************/
#define irSectorCount   irCount
#define irSectorNo      irLength
#define irByteCount     irCount
#define irAddress       irLength

#define FL_GET_SOCKET_FROM_HANDLE(ioreq) (FLByte)((ioreq)->irHandle & 0x0f)
#define FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq) (FLByte)(((ioreq)->irHandle & 0xf0) >> 4)

#endif /*_COMMON_H*/

