/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

/***********************************************************************************/
/*																				   */
/*	Internal header file for doch_api module									   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/version 7.0/TrueFFS FS/src/h3/_dochapi.h-arc  $
 *
 *    Rev 1.12   Aug 09 2006 17:27:42   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.10   Jul 03 2006 22:45:02   polina.marimont
 * version change
 *
 *    Rev 1.9   Jul 03 2006 22:12:32   polina.marimont
 * version changed
 *
 *    Rev 1.8   Jun 22 2006 16:56:32   Polina.Marimont
 * version changed
 *
 *    Rev 1.7   Jun 21 2006 18:23:34   Polina.Marimont
 * 1. version update
 * 2. set power mode function description updated
 *
 *    Rev 1.6   Jun 18 2006 13:01:58   Polina.Marimont
 * 1. version changed
 * 2. power mode save function chaged
 *
 *    Rev 1.5   Jun 14 2006 17:31:52   Polina.Marimont
 * version updated
 *
 *    Rev 1.4   May 30 2006 10:40:24   polina.marimont
 * version change to 1.42 Pre 3
 *
 *    Rev 1.3   May 28 2006 12:48:26   polina.marimont
 * version 1.42 Pre1
 *
 *    Rev 1.2   May 18 2006 14:40:46   polina.marimont
 * PVCS inside
 */

#ifndef _DOCHAPI
#define _DOCHAPI

#include "_common.h"

/***********************/
/*	SDK Version Number */
/***********************/
#define DochSDKVersion     "0150"
#define DochSDKSubVersion  "Pre5"

/********************/
/*	Partitions		*/
/********************/

/*	Pattern to indicate a boolean global variable was set
	(to deal with "naughty" compilers...)*/
#define DOCH_GLOBAL_BOOL_PATTERN 0xCAFE

/*	Max number of paritions	*/
#define DOCH_MAX_PARTITIONS 16

/*IPL partition*/
#define DOCH_IPL_PARTITION				0
#define IPL_PARTITION_SIZE_SECTORS		0x200	/*256KB in sectors*/
#define IPL_PARTITION_SIZE_V_SECTORS	0x10   /* 8K KB sectors*/


/********************/
/*	Various Defines	*/
/********************/

/* On/Off definitions */
#define DOCH_OFF	0
#define DOCH_ON		1

/* size of DOCH data block in FLBytes */
#define DOCH_SECTOR_SIZE		512
#define	DOCH_SECTOR_SIZE_BITS	9

/* Operations on IOreq structure */
#define DOCH_GET_SOCKET_FROM_IOREQ_HANDLE(ioreq)			(FLByte)((ioreq)->irHandle & 0x0f)
#define DOCH_SET_SOCKET_TO_IOREQ_HANDLE(ioreq, socket)		((ioreq)->irHandle |= (socket))

#define DOCH_GET_PARTITION_FROM_IOREQ_HANDLE(ioreq)			(FLByte)(((ioreq)->irHandle & 0xf0) >> 4)
#define DOCH_SET_PARTITION_TO_IOREQ_HANDLE(ioreq, part)		((ioreq)->irHandle = \
															( ((part & 0xF) << 4) | ((ioreq)->irHandle & 0xFFFFFF0F)) )

/*	Operation type (for long operations)	*/
#define DOCH_NORMAL_OPERATION		0x00
#define DOCH_IMMEDIATE_OPERATION	0x80

/*	Data transfer modes	*/
typedef enum { DOCH_DATA_XFER_MODE_SINGLE		= 0x00,
			   DOCH_DATA_XFER_MODE_MULT			= 0x01
} DOCH_DataTransferMode;

typedef enum {
	DOCH_ALERT_LEVEL_CRASH		= 0,	/*Prints only errors that H3 can not recover from*/
	DOCH_ALERT_LEVEL_EMERGENCY	= 1,	/*Prints only important, but not lethal errors*/
	DOCH_ALERT_LEVEL_REPORT		= 2,	/*Prints basic report on H3 operations*/
	DOCH_ALERT_LEVEL_DEBUG		= 3,	/*Prints full report on H3 progress*/
	DOCH_ALERT_LEVEL_BORING		= 4		/*Prints every operation done by H3*/
} DOCH_AlertLevel;

/*	Power mode constants */
typedef enum {
	DOCH_PM_SET_NONE			= 0x00,
	DOCH_PM_SET_WORK_MODE		= 0x01,
	DOCH_PM_SET_INACTIVE_MODE	= 0x02,
	DOCH_PM_SET_BOTH_MODES		= 0x03
} DOCH_SetPowerMode;

typedef enum {
	DOCH_PM_WORK_MODE		= 0x00,
	DOCH_PM_INACTIVE_MODE	= 0x04
} DOCH_SelectedPowerMode;

typedef enum {
	DOCH_WM_NORMAL					= 0x00,	/*Same as ATA ACTIVE Mode*/
	DOCH_WM_LOW_FREQ				= 0x01,	/*Same as ATA IDLE Mode*/
	DOCH_WM_NORMAL_AND_AUTO_STBY	= 0x02,
	DOCH_WM_LOW_FREQ_AND_AUTO_STBY	= 0x03
} DOCH_WorkMode;

typedef enum {
	DOCH_IM_IDLE			= 0x00,			/*Same as ATA STANDBY Mode*/
	DOCH_IM_DPD				= 0x10,			/*Same as ATA SLEEP Mode*/
	DOCH_IM_IDLE_2_DPD      = 0x20			/*No timeout IDLE ==> DPD */
} DOCH_InactiveMode;

#define DOCH_PM_SAVE_DEFAULT	0x10		/*Save power mode settings as device default*/

/*	Custom Parameters Table	*/
typedef enum {
	DOCH_CP_BOOT_MODE		= 0x00,	/*Boot Mode (See DOCH_IPLModes)*/
	DOCH_CP_XIP_TEST_MODE	= 0x01,	/*XIP Test Modes (See DOCH_XIPTestModes)*/
	DOCH_CP_XIP_MAX_SIZE	= 0x02,	/*Max XIP Size*/
	DOCH_CP_XIP_ETFFS_SIZE	= 0x03,	/*Returns the size of the currently saved ETFFS (required for uploading the ETFFS)*/
	DOCH_CP_WORK_MODES		= 0x04,	/*Work Modes (Bit Field, see enum DOCH_CPWorkModes)*/
	DOCH_CP_SLOCK_CTRL		= 0x05,	/*Sticky Lock control (See DOCH_SlockCtrl)*/
	DOCH_CP_BYTE_SWAP_CTRL	= 0x06,	/*Byte Swap control (See DOCH_ByteSwapCtrl)*/
	DOCH_CP_FLASH_TEST_MODE	= 0x07	/*Enable/Disable flash test mode (See DOCH_FlashTestModeCtrl)*/
} DOCH_CustomParams;

#define DOCH_CUSTOM_PARAM_TEMP		1
#define DOCH_CUSTOM_PARAM_DEFAULT	0

/* IPL Modes */
typedef enum {
	DOCH_IPL_MODE_NORMAL_RAM				= 0x0000,
	DOCH_IPL_MODE_PAGED_RAM					= 0x0001,
	DOCH_IPL_MODE_VIRTUAL_RAM				= 0x0002,
	DOCH_IPL_MODE_CS_DELAY					= 0x1000,	/*Should be Or`ed with 0x0XX0, where bits 4-11 indicating delay*/
	DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT	= 0x2000,
	DOCH_IPL_MODE_ACTIVE_SWAP_BYTES			= 0x4000,
	DOCH_IPL_MODE_8KB_WINDOW				= 0x8000
} DOCH_IPLModes;

#define	DOCH_IPL_WRITE_FIRST_CHUNK			0x80000000 /*Defines first chunk when writing IPL in chunks*/

/* XIP Test Modes */ /*No default value, will be cleared upon reset*/
typedef enum {
	DOCH_XIP_NORMAL			= 0x0000,
	DOCH_XIP_WRITEABLE		= 0x0001,
	DOCH_XIP_FILL_PATTERN	= 0x0002,	/*"M-Systems" and the rest with consecutive 16bit numbers*/
	DOCH_XIP_PIPELINE		= 0x0003	/*Places the device in pipeline access mode*/
} DOCH_XIPTestModes;

typedef enum {
	DOCH_WORK_MODES_BLOCK_SPI = 0x0002	/*Block SPI*/
} DOCH_CPWorkModes;

typedef enum {
	DOCH_STICKY_LOCK_UNSET = 0x00,
	DOCH_STICKY_LOCK_SET   = 0x01
} DOCH_SlockCtrl;

typedef enum {
	DOCH_BYTE_SWAP_UNSET = 0x00,
	DOCH_BYTE_SWAP_SET   = 0x01
} DOCH_ByteSwapCtrl;

typedef enum {
	DOCH_DISABLE_FLASH_TEST_MODE	= 0x00,
	DOCH_ENABLE_FLASH_TEST_MODE		= 0x01
} DOCH_FlashTestModeCtrl;


typedef enum {
	DOCH_DLMCODE_DOWNLOAD						= 0x01,	/*Download is for immediate, temporary use*/
	DOCH_DLMCODE_DOWNLOAD_AND_SAVE				= 0x07,	/*Save downloaded code for immediate & future use*/
	DOCH_DLMCODE_DOWNLOAD_AND_LAST_SAVE			= 0x87,	/*Same as code 0x07, but marking this as the last permanent
														  download accepted by the device*/
	DOCH_DLMCODE_UPLOAD							= 0xFF
} DOCH_DLMcodeModes;

/* Set of access options for DOCH_EN_ACCESS_WPWD	*/
typedef enum { DOCH_ACCESS_USER_PASSWORD	= 0x00,
			   DOCH_ACCESS_MASTER_PASSWORD	= 0x01,
			   DOCH_ACCESS_GATE_KEEPER		= 0x02
} DOCH_Access_Op;

/*Defines for DOCHConfigHW*/
/*------------------------*/
typedef enum {
	DOCH_BURST_WRITE_MODE_CTRL	= 0x0,
	DOCH_BURST_READ_MODE_CTRL	= 0x1,
	DOCH_IPL_CTRL				= 0x2,
	DOCH_WARM_BOOT_CTRL			= 0x3,
	DOCH_POWER_DOWN				= 0x4,
	DOCH_DMA_CTRL				= 0x5,
	DOCH_DMA_ENABLE				= 0x6,
	DOCH_DMA_NEGATION_CTRL		= 0x7,
	DOCH_SLOCK					= 0x8,
	DOCH_ENDIAN_CTRL			= 0x9,
	DOCH_OPERATION_MODE_CTRL	= 0xA,
	DOCH_POWER_MODE_CTRL		= 0xB
} DOCH_HwConfigType;

/* DOCH_NUM_OF_DCONFIGHW_ITEMS should be set to number of items in DOCH_HwConfigType*/
#define DOCH_NUM_OF_DCONFIGHW_ITEMS 0xC

/*IPL Control Register*/
#define DOCH_IPL_WRITE_DISABLE       0x0000
#define DOCH_IPL_WRITE_READY         0x0001
#define DOCH_IPL_WRITE_ENABLE        0x0002

#define DOCH_IPL_ALL_CS_ENABLED		 0x0000
#define DOCH_IPL_CLOSE_2LOW_IPLS	 0x0010
#define DOCH_IPL_CLOSE_2HIGH_IPLS	 0x0020
#define DOCH_IPL_CLOSE_ALL_IPLS		 0x0030

/*Warm Boot Register*/
#define DOCH_WARM_RST_POLARITY_LOW   0x0000
#define DOCH_WARM_RST_POLARITY_HIGH  0x0001

#define DOCH_WARM_RST_BURST_ON       0x0000
#define DOCH_WARM_RST_BURST_NO_CHNG  0x0002

/*Deep Power Down Mode Register*/
#define DOCH_DPD_PIN_POL_LOW		 0x0000
#define DOCH_DPD_PIN_POL_HIGH		 0x0001

#define DOCH_DPD_PIN_DISABLED		 0x0000
#define DOCH_DPD_PIN_ENABLED		 0x0002

#define DOCH_DPD_WAKEUP_HOST_CE		 0x0000
#define DOCH_DPD_WAKEUP_ASYNC_CLK	 0x0100

/*DMA Control Register*/
#define DOCH_DMA_REQ_DISABLE         0x0000
#define DOCH_DMA_REQ_ENABLE          0x0001

#define DOCH_DMA_REQ_POL_HIGH        0x0000
#define DOCH_DMA_REQ_POL_LOW         0x0002

#define DOCH_DMA_REQ_LEVEL           0x0000
#define DOCH_DMA_REQ_EDGE            0x0004

/*SLOCK Control Register*/
#define DOCH_SLOCK_ACTIVE			 0x0001
#define DOCH_SLOCK_OFF				 0x0000

/*Burst write/read mode control*/
#define DOCH_BURST_DISABLE           0x0000
#define DOCH_BURST_ENABLE            0x0002

#define DOCH_BURST_HOLD_1_CLK        0x0000
#define DOCH_BURST_HOLD_2_CLK        0x2000

#define DOCH_BURST_LEN_4_CYC         0x0000
#define DOCH_BURST_LEN_8_CYC         0x0800
#define DOCH_BURST_LEN_16_CYC        0x1000
#define DOCH_BURST_LEN_32_CYC        0x1800

/*Endian Control Register*/
#define DOCH_END_SWAP_OFF            0x0000
#define DOCH_END_SWAP_ON	         0x0101

/*Operation Mode Register*/
#define DOCH_NON_PIPE_ACCESS         0x00
#define DOCH_PIPE_ACCESS             0x01

#define DOCH_NO_ADDR_SHIFT           0x00
#define DOCH_ADDR_SHIFT              0x02

/*Power Mode Register*/
#define DOCH_POWER_MODE_DPD          0x0001

/*Environment variables*/
typedef enum {
	DOCH_ENV_VERIFY_WRITE		= 0x01,	/* Verifies every written sector by reading it back from device */
	DOCH_ENV_ATA_DEBUG			= 0x02,	/* Retrieve debug buffer from device after completion of ATA command */
	DOCH_ENV_BLOCK_SPI			= 0x03,	/* Block SPI */
	DOCH_ENV_NO_ATA_TIMEOUT		= 0x04,	/* Disable ATA command timeout */
	DOCH_ENV_AUTO_DPD_BY_HOST	= 0x05  /* Host automatically enters device to DPD after every command*/
} DOCH_EnVars;

/*Flags for read/write operations using DMA/Burst*/
#define DOCH_USE_DMA		0x01
#define DOCH_USE_BURST		0x02

/* Strings lengths */
#define DOCH_PASS_KEY_LEN			0x80
#define DOCH_PASS_KEY_LEN_NO_NULL	(H3_PASS_KEY_LEN-1)
#define DOCH_SER_NO_LEN				0x14
#define DOCH_MODEL_NO_LEN           0x28
#define DOCH_PROG_NAME_LEN          0x10
#define DOCH_PROG_VER_LEN           0x8


/* DOCH error codes */
/*------------------*/
#define DOCH_ATA_ERROR_BASE	0x0
#define DOCH_SDK_ERROR_BASE	0x100
#define DOCH_FS_ERROR_BASE  0x200

#if 0
typedef enum {
                DOCH_OK                  = 0,

				/*ATA Error codes*/

				DOCH_ATA_NO_ERROR                     = DOCH_ATA_ERROR_BASE + 0x00,
				DOCH_ATA_ERROR_MEDIA_ERROR_DETECTED   = DOCH_ATA_ERROR_BASE + 0x01,  /*ATA-4*/
				DOCH_ATA_ERROR_ADDRESS_MARK_NOT_FOUND = DOCH_ATA_ERROR_BASE + 0x01,  /*Repeat last operation*/
				DOCH_ATA_ERROR_TRACK_0_NOT_FOUND      = DOCH_ATA_ERROR_BASE + 0x02,  /*Protection violation*/
				DOCH_ATA_ERROR_NO_MEDIA               = DOCH_ATA_ERROR_BASE + 0x02,  /*ATA-4*/
				DOCH_ATA_ERROR_ABORT                  = DOCH_ATA_ERROR_BASE + 0x04,  /*Always need to be supplied*/
				DOCH_ATA_ERROR_MEDIA_CHANGE_REQUESTED = DOCH_ATA_ERROR_BASE + 0x08,  /*Not to use for now*/
				DOCH_ATA_ERROR_ID_NOT_FOUND           = DOCH_ATA_ERROR_BASE + 0x10,  /*Passing partition boundary*/
				DOCH_ATA_ERROR_MEDIA_CHANGE_DETECTED  = DOCH_ATA_ERROR_BASE + 0x20,  /*Not to use for now*/
				DOCH_ATA_ERROR_WRITE_PROTECTED        = DOCH_ATA_ERROR_BASE + 0x40,  /*on writes       - only if we run out of space*/
				DOCH_ATA_ERROR_UNCORRECTABLE_DATA	  = DOCH_ATA_ERROR_BASE + 0x40,  /*on reads        - possible for unrecoverable ECC - should not be returned by write routines*/
				DOCH_ATA_ERROR_ICRC					  = DOCH_ATA_ERROR_BASE + 0x80,  /*on DMA xfers    - to leave for now*/

				/*SDK Error Codes*/
				DOCH_TimedOut			 = DOCH_SDK_ERROR_BASE,
				DOCH_GeneralFailure      = DOCH_SDK_ERROR_BASE + 5,
				DOCH_AdapterNotFound     = DOCH_SDK_ERROR_BASE + 6,
				DOCH_DeviceTurnedOff     = DOCH_SDK_ERROR_BASE + 7,
				DOCH_BadParameter        = DOCH_SDK_ERROR_BASE + 10,
				DOCH_DriveNotAvailable   = DOCH_SDK_ERROR_BASE + 15,
				DOCH_DriveNotReady       = DOCH_SDK_ERROR_BASE + 20,
				DOCH_NotEnoughMemory     = DOCH_SDK_ERROR_BASE + 25,
				DOCH_ReadFault           = DOCH_SDK_ERROR_BASE + 30,
				DOCH_WriteFault          = DOCH_SDK_ERROR_BASE + 31,
				DOCH_VerifyFault         = DOCH_SDK_ERROR_BASE + 32,
				DOCH_ProtectionFault     = DOCH_SDK_ERROR_BASE + 33,
				DOCH_UnknownCmd          = DOCH_SDK_ERROR_BASE + 35,
				DOCH_DiskNotFound        = DOCH_SDK_ERROR_BASE + 40,
				DOCH_PartitionNotFound	 = DOCH_SDK_ERROR_BASE + 45,
				DOCH_PartitionLimitExceeded = DOCH_SDK_ERROR_BASE + 50,
				DOCH_FeatureNotSupported = DOCH_SDK_ERROR_BASE + 55,
				DOCH_ATABusyNotCleared	 = DOCH_SDK_ERROR_BASE + 60,
				DOCH_ATANotReady		 = DOCH_SDK_ERROR_BASE + 61,
				DOCH_ATAErrorDetected	 = DOCH_SDK_ERROR_BASE + 65

} DOCH_Error;
#endif

/*	IOCTL Codes	*/
typedef enum {
	/*Get Info*/
	SDK_IDENTIFY_DISKONCHIP_DEVICE	= 0x200,
	SDK_GET_RESET_STATUS			= 0x201,
	SDK_NOTIFY_RESET				= 0x202,
	SDK_NOTIFY_PLATFORM_RESUMED		= 0x203,
	SDK_GET_PARTITION_INFO			= 0x204,
	SDK_SET_DISK_USER_ATTR			= 0x205,
	SDK_GET_DISK_USER_ATTR			= 0x206,
	SDK_GET_CONFIG_DATA				= 0x207,
	SDK_SET_CONFIG_DATA				= 0x208,

	/*Media*/
	SDK_SET_DEFAULT_PARTITION	= 0x210,
	SDK_SET_DATA_XFER_MODE		= 0x211,
	SDK_OPTIMIZE_MEDIA			= 0x212,
	SDK_DELETE_PARTITIONS		= 0x213,
	SDK_ADD_PARTITION			= 0x214,
	SDK_UNFORMAT_DEVICE			= 0x215,
	SDK_WRITE_IPL				= 0x216,
	SDK_READ_IPL				= 0x217,

	/*IO*/
	SDK_READ_PARTITION_SECTORS	= 0x220,
	SDK_WRITE_PARTITION_SECTORS	= 0x221,
	SDK_WRITE_AND_LOCK			= 0x222,
	SDK_WIPE_SECTORS			= 0x223,
	SDK_FREE_SECTORS			= 0x224,
	SDK_PREPARE_FOR_WRITE		= 0x225,

	/*Flexi-Flash*/
	SDK_WRITE_FLEXI_FAST		= 0x230,
	SDK_WRITE_FLEXI_NORMAL		= 0x231,
	SDK_REWRITE_FLEXI_NORMAL	= 0x232,

	/*Hash*/
	SDK_READ_WITH_HASH_VERIFY	= 0x240,
	SDK_READ_HASH				= 0x241,
	SDK_WRITE_HASH				= 0x242,

	/*Protection*/
	SDK_ACCESS_PART_WITH_PWD	= 0x250,
	SDK_DISABLE_PART_ACCESS		= 0x251,
	SDK_SET_PART_PROTECTION		= 0x252,
	SDK_SET_PART_USER_ATTR		= 0x253,
	SDK_GET_PART_USER_ATTR		= 0x254,

	/*PKI*/
	SDK_PKI_HOST				= 0x260,
	SDK_PKI_DOCH				= 0x261,
	SDK_PKI_VERIFY_HOST_KEY		= 0x262,

	/*Custom Parameters*/
	SDK_GET_CUSTOM_PARAM		= 0x270,
	SDK_SET_CUSTOM_PARAM		= 0x271,

	/*Atomic Read/Write Sequence*/
	SDK_ATOMIC_WRITE_SEQ		= 0x280,

	/*Algorithms*/
	SDK_REPORT_SUPP_ALG			= 0x290,
	SDK_REPORT_ALG_CAPAB		= 0x291,
	SDK_SET_ALG_MODE			= 0x292,

	/*Hash*/
	SDK_AUTO_HASH_CTRL			= 0x2A0,
	SDK_READ_CALC_HASH			= 0x2A1,
	SDK_WRITE_CALC_HASH			= 0x2A2,
	SDK_READ_ORIG_HASH			= 0x2A3,
	SDK_WRITE_GIVEN_HASH		= 0x2A4,
	SDK_START_HASH_STREAM_CALC	= 0x2A5,
	SDK_READ_HASH_STREAM_CALC	= 0x2A6,
	SDK_RETURN_RAND_NUMS		= 0x2A7,
	SDK_SET_HASH_KEY			= 0x2A8,

	/*General (Control/Configuration)*/
	SDK_SET_POWER_MODE			= 0x2B0,
	SDK_GET_POWER_MODE			= 0x2B1,
	SDK_HW_CONFIG				= 0x2B2,
	SDK_RECOVER_FROM_POWER_LOSS	= 0x2B3,
	SDK_RESET_SOCKET			= 0x2B4,
	SDK_SET_ENV_VAR				= 0x2B5,
	SDK_CLEAR_ATA_INTERRUPT		= 0x2B6,
	SDK_GET_PHYSICAL_ADDRESS	= 0x2B7
} SDKFunctionNo;

/* runtime socket init data */
typedef struct {
	unsigned int nDeviceAddress;
} DOCH_InitSocket;

/* Access layer routines registration structure */
typedef struct {
	unsigned char (*hal_get_ata_reg_user)	(volatile unsigned char *base, int reg);
	void		  (*hal_set_ata_reg_user)	(volatile unsigned char *base, int reg, unsigned int val);
	unsigned short(*hal_get_ctrl_reg_user)	(volatile unsigned char *base, int reg);
	void		  (*hal_set_ctrl_reg_user)	(volatile unsigned char *base, int reg, unsigned int val);
	int			  (*hal_blk_read_user)		(volatile unsigned char *base, unsigned char *buf, int sectors);
	int			  (*hal_blk_write_user)		(volatile unsigned char *base, unsigned char *buf, int sectors);
	int			  (*hal_release_user)		(int socketNo);
} DOCH_BusAccess_routines;

/********************/
/*	API Defines		*/
/********************/
#if 0
/* set of DOCH ATA registers */
typedef enum {
			   DOCH_DATA_REG          = 0x00,
			   DOCH_ERROR_REG         = 0x01,
               DOCH_FEATURES_REG      = 0x01,
               DOCH_SECTOR_CNT_REG    = 0x02,
               DOCH_SECTOR_NO_REG     = 0x03,
               DOCH_CYLINDER_LOW_REG  = 0x04,
               DOCH_CYLINDER_HIGH_REG = 0x05,
               DOCH_DRIVE_HEAD_REG    = 0x06,
               DOCH_STATUS_REG        = 0x07,
               DOCH_COMMAND_REG       = 0x07,
               DOCH_ALT_STATUS_REG    = 0x0E,
               DOCH_CONTROL_REG		  = 0x0E
} DOCH_Reg;
#endif
/* ATA registers structure */
typedef struct {  FLByte bFeaturesError;	/* DOCH_FEATURES_REG or DOCH_ERROR_REG	*/
				  FLByte bSectorCount;		/* DOCH_SECTOR_CNT_REG	*/
				  FLByte bSectorNumber;		/* DOCH_SECTOR_NO_REG	*/
				  FLByte bCylLow;			/* DOCH_CYLINDER_LOW_REG	*/
				  FLByte bCylHigh;			/* DOCH_CYLINDER_HIGH_REG	*/
				  FLByte bDriveHead;		/* DOCH_DRIVE_HEAD_REG	*/
				  FLByte bCommandStatus;	/* DOCH_COMMAND_REG	or DOCH_STATUS_REG*/
				  FLByte bContorlAltStatus;	/* DOCH_CONTROL_REG	or DOCH_ALT_STATUS_REG*/
} DOCH_Registers;

/* Set of operation codes for PassThru */
typedef enum { DOCH_PASSTHRU_NO_DATA		= 0x00,
               DOCH_PASSTHRU_DATA_IN		= 0x01,
               DOCH_PASSTHRU_DATA_OUT		= 0x02
} DOCH_PassThru_Op;

typedef enum { DOCH_PASSTHRU_NO_INT		= 0x00,
               DOCH_PASSTHRU_USE_INT	= 0x04

} DOCH_PassThru_Int;


/*OPTIMIZE_MEDIA*/
#define DOCH_OPTIMIZE_BY_PREPARE_FOR_WRITE	0
#define DOCH_OPTIMIZE_DEFAULT				1

typedef enum {
	SET_DEFAULT_PARTITION_TEMP = 0x0,
	SET_DEFAULT_PARTITION_PERM = 0x1
} DOCH_DefaultPartSet;

typedef enum {
	DOCH_FAST_PARTITOIN_DELETE		= 0x0,
	DOCH_COMPLETE_PARTITION_DELETE	= 0x8
} DOCH_DeletePartitionsMode;


/******************************************************************************/
/*
 *	Partition Info structure, sub-structures and ENUMS
 */
/******************************************************************************/

/*Partition dwCommandFlagsOrStatuses Offsets*/
#define	DOCH_CFSO_FAST_AREA_SIZE_TYPE	8
#define	DOCH_CFSO_USER_AUTHENTICATED	16
#define	DOCH_CFSO_PERM_LOCKED			17
#define	DOCH_CFSO_MASTER_AUTHENTICATED	18
#define	DOCH_CFSO_HW_LOCK_ASSERTED		30
#define	DOCH_CFSO_SW_LOCK_ASSERTED		31

/*Partition dwCommandFlagsOrStatuses Bits*/
#define	DOCH_CFSB_FAST_AREA_SIZE_TYPE	0x00000100
#define	DOCH_CFSB_USER_AUTHENTICATED	0x00010000
#define	DOCH_CFSB_PERM_LOCKED			0x00020000
#define	DOCH_CFSB_MASTER_AUTHENTICATED	0x00040000
#define	DOCH_CFSB_HW_LOCK_ASSERTED		0x40000000
#define	DOCH_CFSB_SW_LOCK_ASSERTED		0x80000000

/*Partition Attribute1 Offsets*/
#define	DOCH_PA1O_PARTITION_TYPE	0
#define	DOCH_PA1O_PERFORMANCE_CTRL	8
#define	DOCH_PA1O_PAGE_SIZE_EXP		16
#define	DOCH_PA1O_HASH_TYPE			24

/*Partition Attribute1 Bits*/
#define	DOCH_PA1B_PARTITION_TYPE	0x000000FF
#define	DOCH_PA1B_PERFORMANCE_CTRL	0x00000F00
#define	DOCH_PA1B_PAGE_SIZE_EXP		0x000F0000
#define	DOCH_PA1B_HASH_TYPE			0x3F000000

/*Partition Attribute2 Offsets*/
#define	DOCH_PA2O_PROTECTION_TYPE	0
#define	DOCH_PA2O_USER_MODE			6
#define	DOCH_PA2O_GUEST_MODE		9
#define	DOCH_PA2O_MASTER_CTRL		12
#define	DOCH_PA2O_ENCRYPT_TYPE		15
#define	DOCH_PA2O_OTP_BIT			21
#define	DOCH_PA2O_LOCK_CTRL			22
#define	DOCH_PA2O_MAX_AUTH_ATTEMPTS 24

/*Partition Attribute2 Bits*/
#define	DOCH_PA2B_PROTECTION_TYPE	0x00000007		/*DOCH_ProtectionType*/
#define	DOCH_PA2B_USER_MODE			0x000001C0		/*DOCH_PartitionAccessMode*/
#define	DOCH_PA2B_GUEST_MODE		0x00000E00		/*DOCH_PartitionAccessMode*/
#define	DOCH_PA2B_MASTER_CTRL		0x00007000		/*DOCH_PartitionAccessMode*/
#define	DOCH_PA2B_ENCRYPT_TYPE		0x00038000		/*DOCH_EncryptType*/
#define	DOCH_PA2B_OTP_BIT			0x00200000
#define	DOCH_PA2B_LOCK_CTRL			0x00C00000		/*DOCH_LockControl*/
#define	DOCH_PA2B_MAX_AUTH_ATTEMPTS	0x0F000000

/*	Structure that holds various partition data*/
typedef struct {
	FLByte  bDevice;		/*On which device (0/1) the partition reside*/
} DOCH_PartitionAttr;

/*Partition formatting info*/

/*API exported for partition preporties*/
typedef struct {
	FLDword		dwProtectionType;		/*DOCH_ProtectionType*/
	FLDword		dwUserAccessMode;		/*DOCH_PartitionAccessMode*/
	FLDword		dwGuestAccessMode;		/*DOCH_PartitionAccessMode*/
	FLDword		dwMasterControl;		/*DOCH_PartitionAccessMode*/
	FLDword		dwEncryptionType;		/*DOCH_EncryptType*/
	FLDword		dwLockControl;			/*DOCH_LockControl*/
	FLDword		dwMaxNumOfAuthAttempts;	/*0 = Unlimited number*/
	FLByte		bPasskey[0x80];			/*ASCII*/
} DOCH_PartitionProtectionAPI;

typedef enum {
	DOCH_PASSKEY_VALID		= 0x01,		/* Passkey in DOCH_PartitionProtectionAPI is valid */
	DOCH_ATTRIBUTES_VALID	= 0x02,		/* All attributes in DOCH_PartitionProtectionAPI besides passkey are valid */
	DOCH_LOCK_AS_OTP		= 0x04		/* Lock the partition for writing */
} DOCH_PartitionProtectioValidity;

/*Partition Info structure*/

typedef struct {
	FLByte			bReserved1[0x4];
	FLDword			dwCommandFlagsOrStatuses;			/*Dynamic info*/
	FLDword			partitionAttributes1;
	FLDword			partitionAttributes2;
	FLDword			nPartitionSize;						/*In Sectors*/
	FLDword			nFastAreaSize;						/*In Sectors or Percent. for IPL partition: size reported in XIP*/
	FLWord			wFastAreaFactor;					/*Exponent*/
	FLByte			bReserved2[0x2];
	FLDword			wPartitionStartSector;
	FLWord			wCurrentSectorsPerTrack;
	FLWord			wDefaultSectorsPerTrack;
	FLWord			wCurrentCylinders;
	FLWord			wDefaultCylinders;
	FLWord			wCurrentHeads;
	FLWord			wDefaultHeads;
	FLByte			bReserved3[0x14];
	FLWord			wFastAreaSectorsInErasableUnit;		/*Exponent*/
	FLWord			wNormalAreaSectorsInErasableUnit;	/*Exponent*/
	FLWord			wRecommendedSectorsPerCluster;
	FLWord			wFastMaxRelatedSectors;
	FLWord			wNormalMaxRelatedSectors;
	FLByte			bReserved4[0xB6];
	FLByte			bPartitionKey[0x80];
	FLByte			bReserved5[0x80];
} DOCH_PartitionInfo;

typedef struct {
	FLDword		dwPartitionType;		/*DCOH_PartitionType*/
	FLDword		dwPerformanceControl;	/*DOCH_PerformanceControl*/
	FLDword		dwPageSizeExp;			/*DOCH_PageSizeExp*/
	FLDword		dwHashType;				/*DOCH_HashType*/
	FLDword		dwFastAreaSizeType;		/*DOCH_FastAreaType*/
	FLDword		dwProtectionType;		/*DOCH_ProtectionType*/
	FLDword		dwUserAccessMode;		/*DOCH_PartitionAccessMode*/
	FLDword		dwGuestAccessMode;		/*DOCH_PartitionAccessMode*/
	FLDword		dwMasterControl;		/*DOCH_PartitionAccessMode*/
	FLDword		dwEncryptionType;		/*DOCH_EncryptType*/
	FLDword		dwLockControl;			/*DOCH_LockControl*/
	FLDword		dwOtpEnabled;			/*DOCH_OTPBit*/
	FLDword		dwMaxNumOfAuthAttempts;	/*0 = Unlimited number*/
	FLNative	nPartitionSize;			/*In Sectors*/
	FLNative	nFastAreaSize;			/*In Sectors or Percent**/
	FLWord		wFastAreaFactor;		/*Exponent*/
	FLByte		bPasskey[0x80];			/*ASCII*/
} DOCH_PartitionFormatInfoAPI;

/*Partition formatting info*/
typedef struct {
	FLByte			bReserved1[0x4];
	FLDword			dwCommandFlagsOrStatuses;
	FLDword			partitionAttributes1;
	FLDword			partitionAttributes2;
	FLDword			nPartitionSize;					/*In Sectors*/
	FLDword			nFastAreaSize;					/*In Sectors or Percent*/
	FLWord			wFastAreaFactor;				/*Exponent*/
	FLByte			bReserved2[0x12];
	FLDword			dwValidity;						/*DOCH_PartitionProtectioValidity*/
	FLByte			bReserved3[0xD0];
	FLByte			bPasskey[0x80];
	FLByte			bReserved4[0x80];
} DOCH_PartitionFormatInfo;

/*Device dwCommandFlagsOrStatuses Offsets*/
#define	DOCH_DCFSO_CURRENT_XFER_MODE	0
#define	DOCH_DCFSO_CURRENT_MULTI_SECTOR	8
#define	DOCH_DCFSO_HW_LOCK_ASSERTED		30
#define	DOCH_DCFSO_SW_LOCK_ASSERTED		31

/*Device dwCommandFlagsOrStatuses Bits*/
#define	DOCH_DCFSB_CURRENT_XFER_MODE	0x00000007
#define	DOCH_DCFSB_CURRENT_MULTI_SECTOR	0x00000F00
#define	DOCH_DCFSB_HW_LOCK_ASSERTED		0x40000000
#define	DOCH_DCFSB_SW_LOCK_ASSERTED		0x80000000

/*Device Attributes1 Offsets*/
#define	DOCH_DA1O_SUPPORTED_XFER_MODES_BMP	0
#define	DOCH_DA1O_MAX_MULTI_SEC_XFER_SIZE	8
#define	DOCH_DA1O_SUPPORT_48_BITS			31

/*Device Attributes1 Bits*/
#define	DOCH_DA1B_SUPPORTED_XFER_MODES_BMP	0x000000FF
#define	DOCH_DA1B_MAX_MULTI_SEC_XFER_SIZE	0x00000F00
#define	DOCH_DA1B_SUPPORT_48_BITS			0x80000000

/*Gate Keeper Attributes Offsets*/
#define	DOCH_DA2O_AUTH_TYPE			0		/*DOCH_DeviceAuthType*/
#define	DOCH_DA2O_GUEST_ACCESS_MODE	9		/*DOCH_DeviceAccessMode*/
#define	DOCH_DA2O_MASTER_CONTROL	12		/*DOCH_DeviceAccessMode*/
#define	DOCH_DA2O_MAX_AUTH_ATTEMPTS	24

/*Gate Keeper Attributes Bits*/
#define	DOCH_DA2B_AUTH_TYPE			0x00000003
#define	DOCH_DA2B_GUEST_ACCESS_MODE	0x00000E00
#define	DOCH_DA2B_MASTER_CONTROL	0x00007000
#define	DOCH_DA2B_MAX_AUTH_ATTEMPTS	0x0F000000

/*Authentication types*/
typedef enum {
	DOCH_DEVICE_AUTH_NONE	= 0,
	DOCH_DEVICE_AUTH_PWD	= 1,
	DOCH_DEVICE_AUTH_RSA	= 2
} DOCH_DeviceAuthType;
/*Access modes*/
typedef enum {
	DOCH_DEVICE_ACCESS_MODE_FULL	= 0,
	DOCH_DEVICE_ACCESS_MODE_RO		= 1,
	DOCH_DEVICE_ACCESS_MODE_NONE	= 2
} DOCH_DeviceAccessMode;

#define DOCH_CONFIGURATION_EXISTS_SIGN	0x1F2E3D4C

typedef struct {
	FLWord		wVersion;
	FLWord		wVersionCompatability;
	FLDword		dwCommandFlagsOrStatuses;
	FLDword		dwDiskAttributes1;
	FLDword		dwRservedGateKeeperAttr;
	FLDword		dwMiscFlags;
	FLByte		bReserved2[0xC];
	FLByte		bUniqueID[0x10];
	FLByte		bReserved3[0x10];
	FLByte		bSerialNumber[0x14];
	FLByte		bModelNumber[0x28];
	FLWord		wTotalNumOfPartitions;			/*0=IPL not present, 1=Only IPL Present, ... 16=IPL partition + 15 user partitions (MAX)*/
	FLWord		wDefaultPartitionNumber;
	FLDword		dwUnformattedCapacity;			/*In Sectors*/
	FLDword		dwConfigurationPartitionExistsSign;
	FLDword		dwETFFSVER;
	FLDword		dwReservedConfigPartitionSize;	/*In Sectors*/
	FLByte		bProgrammerName[0x10];
	FLByte		bProgrammerVersion[0x8];
	FLDword		dwUnitSize;						/* In Sectors */
	FLByte		bReserved5[0x54];				/*In Sectors*/
	FLByte		bReservedGateKeeperKey[0x80];
	FLByte		bReserved6[0x80];
} DOCH_DeviceInfo;

/*Enums*/
/*=====*/
typedef enum { DOCH_PRT_TYPE_NORMAL					= 0,	/*normal*/
			   DOCH_PRT_TYPE_PAGED					= 1,	/*paged*/
			   DOCH_PRT_TYPE_PAGED_DIGEST			= 2,	/*paged + keeps digest information*/
			   DOCH_PRT_TYPE_PAGED_COMPRESSED		= 3,	/*paged + keeps data in compressed form */
			   DOCH_PRT_TYPE_PAGED_DIGEST_COMPRESSED= 4		/*paged + keeps data in compressed form + digest*/
} DCOH_PartitionType;


/*Performance Control*/
typedef enum { DOCH_NORMAL_PERFORMANCE	= 0,	/*MLC*/
			   DOCH_FIRM_FLASH_OPTIMIZE	= 1,	/*Rigid MLC/SLC division, fast area field defines division*/
			   DOCH_FLEXI_FLASH_OPTIMIZE= 2		/*Adaptive MLC/SLC division, fast area field defines size of spare capacity for performance optimization*/
} DOCH_PerformanceControl;

/*Page size exponent (for paged partitions)*/
typedef enum { DOCH_PAGE_SIZE_512B	= 0,
			   DOCH_PAGE_SIZE_1KB	= 1,
			   DOCH_PAGE_SIZE_2KB	= 2,
			   DOCH_PAGE_SIZE_4KB	= 3,
			   DOCH_PAGE_SIZE_8KB	= 4,
			   DOCH_PAGE_SIZE_16KB	= 5,
			   DOCH_PAGE_SIZE_32KB	= 6
} DOCH_PageSizeExp;

/*Page size exponent (for paged partitions)*/
typedef enum { DOCH_HASH_TYPE_SHA1	= 0
} DOCH_HashType;

/*Fast Area Type*/
typedef enum { DOCH_FAST_AREA_TYPE_SECTORS	= 0,
			   DOCH_FAST_AREA_TYPE_PERCENT	= 1
} DOCH_FastAreaType;

/*Protection Type*/
typedef enum { DOCH_PARTITION_NOT_PROTECTED	= 0,
			   DOCH_PARTITION_PWD_PROTECTED	= 1,
			   DOCH_PARTITION_RSA_PROTECTED	= 2
} DOCH_ProtectionType;

#define DOCH_MAX_PWD_ATTEMPTS	5	/*"0" for Unlimited # of attempts*/

/*Partition access mode*/
typedef enum {
	DOCH_PART_ACCESS_MODE_FULL	= 0,
	DOCH_PART_ACCESS_MODE_RO	= 1,
	DOCH_PART_ACCESS_MODE_NONE	= 2
} DOCH_PartitionAccessMode;

/*Encryption Type*/
typedef enum { DOCH_ENCRYPT_NONE	= 0,	/*Partition is not encrypted*/
			   DOCH_ENCRYPT_AES_CTR	= 1,	/*Partition is AES-encrypted, CTR mode*/
			   DOCH_ENCRYPT_RC4		= 2		/*Partition is RC4-encrypted*/
} DOCH_EncryptType;


/*Lock Control*/
typedef enum { DOCH_LOCK_NOT_ACTIVE	= 0,/*LOCK# signal or soft-lock do not affect the access to this partition*/
			   DOCH_LOCK_ACTIVE		= 1 /*After LOCK# signal is active or soft-lock is written, access to partition*/
										/*can not be authenticated. If access has already been authenticated, it remains*/
} DOCH_LockControl;

/*OTP Bit*/
typedef enum { DOCH_OTP_BIT_OFF	= 0,
			   DOCH_OTP_BIT_ON	= 1
} DOCH_OTPBit;

typedef enum {
	PARTITION_TYPE_IPL		= 0x00,
	PARTITION_TYPE_BDTL		= 0x01,
	PARTITION_TYPE_BINARY	= 0x02,
	PARTITION_TYPE_OTP		= 0x03
} DOCH_PartitionType;

/******************************************************************************/
/*
 *	Partition Access structure
 */
/******************************************************************************/

/*Structure for DOCH_VSCMD_EXT_DEVICE_CTRL::DOCH_SET_PARTITION_PROTECTION
  and DOCH_VSCMD_EXT_SECURITY_CTRL::DOCH_EN_ACCESS_WPWD*/
typedef struct {
	FLByte bReserved1[0x100];
	FLByte bPassword[0x80];
	FLByte bReserved2[0x80];
} DOCH_PartitionAcessPassword;

/******************************************************************************/
/*
 *	PKI structures
 */
/******************************************************************************/

#define DOCH_CHLNG_SIZE		0x40
#define DOCH_PKI_KEY_SIZE	0x80

/*Structure for DOCH_VSCMD_EXT_SECURITY_CTRL::DOCH_TX_HOST_PUBLICKEY*/
typedef struct {
	FLWord wVersion;
	FLByte bReserved1[0xBE];
	FLByte bHostRandomChallange[DOCH_CHLNG_SIZE];
	FLByte bHostPublicKey[DOCH_PKI_KEY_SIZE];
	FLByte bReservedForLargerKey[0x80];
} DOCH_HostPublicKey;

/*Structure for DOCH_VSCMD_EXT_SECURITY_CTRL::DOCH_RX_DOCH_PUBLICKEY*/
typedef struct {
	FLWord wVersion;
	FLByte bReserved1[0x3E];
	FLByte bHostRandomChallangeByDochPrivateKey[DOCH_CHLNG_SIZE];
	FLByte bReserved2[0x40];
	FLByte bDochRandomChallange[DOCH_CHLNG_SIZE];
	FLByte bDochPublicKey[DOCH_PKI_KEY_SIZE];
	FLByte bReservedForLargerKey[0x80];
} DOCH_DochPublicKey;

/*Structure for DOCH_VSCMD_EXT_SECURITY_CTRL::DOCH_VERIFY_HOST_KEY*/
typedef struct {
	FLWord	wVersion;
	FLByte	bReserved1[0x3E];
	FLByte	bDochRandomChallangeByHostPrivateKey[DOCH_CHLNG_SIZE];
	FLByte	bReserved2[0x180];
} DOCH_VerifyHostKey;

/******************************************************************************/
/*
 *	Algorithm structures
 */
/******************************************************************************/

/*Supported algorithms retrieval structure*/
/*----------------------------------------*/
typedef struct {
	FLWord	wVersion;
	FLByte	bReserved1[0x2];
	FLDword	wSymmetricAlgorithmsSupported;		/*Bitmap: AES...*/
	FLDword	wAsymmetricAlgorithmsSupported;		/*Bitmap: RSA...*/
	FLDword	wHashSchemesSupported;				/*Bitmap: SHA-1...*/
	FLDword	wRNGSchemesSupported;				/*Bitmap: TrueRandom...*/
	FLDword	wDecompressionSchemesSupported;		/*Bitmap: LZ77...*/
	FLDword	wCompressionSchemesSupported;		/*Bitmap: LZ77...*/
	FLByte	bReserved2[0x1E4];
} DOCH_supportedAlgorithms;

/*Specific algorithm capabilities retrieval structure and sub-structures*/
/*----------------------------------------------------------------------*/
typedef struct {
	FLDword	dwSize;
	FLDword	dwCalcTime;	/*For the key, in nano*/
} KeyAttr;

typedef struct {
	FLByte	bName[8];		/*In ASCII*/
	FLWord	wKeySizes;		/*Bitmap of key sizes supported by this mode*/
	FLByte	bReserved[0x6];
} ModeAttr;

typedef struct {
	FLWord		wVersion;
	FLByte		bReserved1[0x2];
	FLByte		bAlgorithmName[0x10];	/*In ASCII*/
	FLWord		wNumOfKeySizesSupported;
	FLWord		wNumOfModesSupported;
	FLByte		bReserved2[0x8];
	KeyAttr		keysAttributes[0x8];
	ModeAttr	modesAttributes[0x18];
} DOCH_AlgorithmCapabilities;

/*Enums for HASH control*/
/*----------------------*/
typedef enum {
	DOCH_HASH_REINITIALIZE			= 0x00,
	DOCH_HASH_CONTINUE				= 0x01,
	DOCH_HASH_CONTINUE_ACCUM		= 0x00,
	DOCH_HASH_STOP_ACCUM			= 0x01,
	DOCH_HASH_DONT_RETURN_DATA		= 0x00,
	DOCH_HASH_RETURN_ACCUM_DIGEST	= 0x02
} DOCH_HashStartStream;

typedef enum {
	DOCH_HASH_DECRYPTION_KEY		= 0x00,
	DOCH_HASH_ENCRYPTION_KEY		= 0x01,

	/*For Decryption*/
	DOCH_HASH_USE_DOCH_PUBLIC_KEY		= 0x00,
	DOCH_HASH_USE_HOST_PUBLIC_KEY		= 0x01,
	DOCH_HASH_USE_PARTITION_PUBLIC_KEY	= 0x02,

	/*For Encryption*/
	DOCH_HASH_USE_DOCH_PRIVATE_KEY		= 0x00,
	DOCH_HASH_USE_HOST_PRIVATE_KEY		= 0x01
} DOCH_HashSetKey;

/********************/
/*	API Routines	*/
/********************/

/*----------------------------------------------------------------------*/
/*        f l D O C H S e t D e f a u l t P a r t i t i o n				*/
/*                                                                      */
/* Set default partition for Standard-ATA commands                      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                        Partition number (zero based)		            */
/*      irCount			: SET_DEFAULT_PARTITION_TEMP                    */
/*						  SET_DEFAULT_PARTITION_PERM                    */
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_SET_DEFAULT_PARTITION									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHSetDefaultPartition(ioreq) bdCallDOCH(SDK_SET_DEFAULT_PARTITION, ioreq)

/*----------------------------------------------------------------------*/
/*         f l D O C H S e t D a t a T r a n s f e r M o d e			*/
/*                                                                      */
/* Set Data transfer mode						                        */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*		irCount			: Requested data transfer mode:					*/
/*								DOCH_DATA_XFER_MODE_SINGLE				*/
/*								DOCH_DATA_XFER_MODE_MULT				*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_SET_DATA_XFER_MODE										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetDataTransferMode(ioreq) bdCallDOCH(SDK_SET_DATA_XFER_MODE, ioreq)

/*----------------------------------------------------------------------*/
/*       f l D O C H I d e n t i f y D i s k O n C h i p D e v i c e	*/
/*                                                                      */
/* Returns general information about the Device							*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*      irCount         : DOCH_IDENTIFY_FROM_FLASH						*/
/*						  DOCH_IDENTIFY_EXISTANCE						*/
/*      irData          : Address of DOCH_DeviceInfo struct				*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_IDENTIFY_DISKONCHIP_DEVICE								*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHIdentifyDiskOnChipDevice(ioreq) bdCallDOCH(SDK_IDENTIFY_DISKONCHIP_DEVICE, ioreq)
#define DOCH_IDENTIFY_FROM_FLASH	0x0
#define DOCH_IDENTIFY_EXISTANCE		DRIVE_HEAD_OPT1


/*----------------------------------------------------------------------*/
/*          f l  D O C H G e t R e s e t S t a t u s					*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_GET_RESET_STATUS										*/
/*																		*/
/* Returns:                                                             */
/*        irCount	      : 0	=	No reset since last query			*/
/*							1	=	The device has been reset since last*/
/*									query								*/
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHGetResetStatus(ioreq) bdCallDOCH(SDK_GET_RESET_STATUS, ioreq)

/*----------------------------------------------------------------------*/
/*           f l D O C H N o t i f y R e s e t							*/
/*																		*/
/*	Notify the Device on an upcoming reset initiated by the Host.		*/
/*	Host should NOT perform actual reset before this command completes	*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_NOTIFY_RESET											*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHNotifyReset(ioreq) bdCallDOCH(SDK_NOTIFY_RESET, ioreq)

/*----------------------------------------------------------------------*/
/*        f l D O C H N o t i f y P l a t f o r m R e s u m e d			*/
/*																		*/
/*	Notify the Device that there was a reset,							*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_NOTIFY_PLATFORM_RESUMED								*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHNotifyPlatformResumed(ioreq) bdCallDOCH(SDK_NOTIFY_PLATFORM_RESUMED, ioreq)

/*----------------------------------------------------------------------*/
/*             f l D O C H P a r t i t i o n I n f o					*/
/*                                                                      */
/* Get information about a specific partition.                          */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                        Partition number (zero based)		            */
/*      irData			: Address of user buffer to read partition      */
/*                        information into.                             */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_GET_PARTITION_INFO										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHPartitionInfo(ioreq) bdCallDOCH(SDK_GET_PARTITION_INFO, ioreq)

/*----------------------------------------------------------------------*/
/*            f l D O C H D e l e t e P a r t i t i o n s				*/
/*                                                                      */
/* Delete range of partitions											*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*		irFlags			: DOCH_NORMAL_OPERATION                         */
/*						  DOCH_IMMEDIATE_OPERATION						*/
/*      irCount         : First partition to delete                     */
/*      irLength        : Last partition to delete						*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_DELETE_PARTITIONS										*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHDeletePartitions(ioreq) bdCallDOCH(SDK_DELETE_PARTITIONS, ioreq)

/*----------------------------------------------------------------------*/
/*					f l D O C H U n f o r m a t							*/
/*                                                                      */
/* Unformats DOCH device.												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_DELETE_PARTITIONS										*/
/*			DOCH_SET_DISK_USER_ATTR										*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHUnformatDevice(ioreq) bdCallDOCH(SDK_UNFORMAT_DEVICE, ioreq)

/*----------------------------------------------------------------------*/
/*	           f l D O C H A d d P a r t i t i o n						*/
/*                                                                      */
/* Adds a partition														*/
/* The new partition is created on existing un-formatted disk capacity	*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_ADD_PARTITION											*/
/*																		*/
/* Returns:                                                             */
/*        irCount	: Number of the created partition                   */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHAddPartition(ioreq) bdCallDOCH(SDK_ADD_PARTITION, ioreq)

/*----------------------------------------------------------------------*/
/*	           f l D O C H W r i t e I P L								*/
/*                                                                      */
/* Writes IPL partition.												*/
/* Sets IPL mode and size.												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*		irFlags			: DOCH_IPL_MODE_NORMAL_RAM                      */
/*						  DOCH_IPL_MODE_PAGED_RAM						*/
/*						  DOCH_IPL_MODE_VIRTUAL_RAM						*/
/*						  DOCH_IPL_MODE_CS_DELAY						*/
/*						  DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT			*/
/*						  DOCH_IPL_MODE_ACTIVE_SWAP_BYTES				*/
/*						  DOCH_IPL_MODE_8KB_WINDOW						*/
/*						  DOCH_IPL_WRITE_FIRST_CHUNK					*/
/*		irCount			: Max IPL size						            */
/*						  Up to 32KB  for Normal Mode	                */
/*						  Up to 128KB for Virtual Mode	                */
/*						  Up to 256KB	for Paged Mode		            */
/*		irLength		: Current chunk length (in sectors)				*/
/*		irData			: Pointer to user buffer (length defined by		*/
/*						  irLength)										*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/*			DOCH_VSCMD_WRITE_PARTITION									*/
/* ATA sub-command:														*/
/*			DOCH_SET_CUSTOM_PARAM										*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHWriteIPL(ioreq) bdCallDOCH(SDK_WRITE_IPL, ioreq)

/*----------------------------------------------------------------------*/
/*	           f l D O C H R e a d I P L								*/
/*                                                                      */
/* Read specified sectors from IPL partition.							*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)                    */
/*		irCount			: First sector to read	                        */
/*		irLength		: Number of sectors to read						*/
/*		irData			: Pointer to user buffer (length defined by		*/
/*						  irLength)										*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/*			DOCH_VSCMD_WRITE_PARTITION									*/
/* ATA sub-command:														*/
/*			DOCH_SET_CUSTOM_PARAM										*/
/*																		*/
/* Returns:                                                             */
/*		irFlags		: DOCH_IPL_MODE_NORMAL_RAM							*/
/*					  DOCH_IPL_MODE_PAGED_RAM							*/
/*					  DOCH_IPL_MODE_VIRTUAL_RAM							*/
/*					  DOCH_IPL_MODE_CS_DELAY							*/
/*					  DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT				*/
/*					  DOCH_IPL_MODE_ACTIVE_SWAP_BYTES					*/
/*					  DOCH_IPL_MODE_8KB_WINDOW							*/
/*      DOCH_Error  : 0 on success, otherwise failed					*/
/*----------------------------------------------------------------------*/
#define flDOCHReadIPL(ioreq) bdCallDOCH(SDK_READ_IPL, ioreq)

/*----------------------------------------------------------------------*/
/*		 f l D O C H R e a d P a r t i t i o n	S e c t o r s			*/
/*                                                                      */
/* Reads sectors by sector no from a specific partition                 */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)		        */
/*        irData          : Address of user buffer to read into         */
/*        irSectorNo      : First sector no. to read.                   */
/*        irSectorCount   : Number of consecutive sectors to read       */
/*        irFlags	      : DOCH_USE_DMA								*/
/*							DOCH_USE_BURST								*/
/*							Note: 4 methods of data transfer are		*/
/*							available:									*/
/*								Normal transfer							*/
/*								DMA    transfer							*/
/*								Burst  transfer							*/
/*								DMA & Burst transfer					*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_READ_PARTITION									*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors NOT read (in case of an	*/
/*							error - this number may not be accurate)	*/
/*----------------------------------------------------------------------*/
#define flDOCHReadPartitionSectors(ioreq) bdCallDOCH(SDK_READ_PARTITION_SECTORS, ioreq)

/*----------------------------------------------------------------------*/
/*        D O C H W r i t e P a r t i t i o n S e c t o r s				*/
/*                                                                      */
/* Writes sectors by sector no to a specific partition                  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)		        */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write		*/
/*        irFlags	      : DOCH_USE_DMA								*/
/*							DOCH_USE_BURST								*/
/*							Note: 4 methods of data transfer are		*/
/*							available:									*/
/*								Normal transfer							*/
/*								DMA    transfer							*/
/*								Burst  transfer							*/
/*								DMA & Burst transfer					*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_PARTITION									*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors NOT read (in case of an	*/
/*							error - this number may not be accurate)	*/
/*----------------------------------------------------------------------*/
#define flDOCHWritePartitionSectors(ioreq) bdCallDOCH(SDK_WRITE_PARTITION_SECTORS, ioreq)

/*----------------------------------------------------------------------*/
/*          f l D O C H W r i t e A n d L o c k							*/
/*                                                                      */
/* Writes sectors by sector no to a specific partition                  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write      */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_PARTITION									*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*        irSectorCount   : Number of sectors NOT read (in case of an	*/
/*							error - this number may not be accurate)	*/
/*----------------------------------------------------------------------*/
#define flDOCHWriteAndLock(ioreq) bdCallDOCH(SDK_WRITE_AND_LOCK, ioreq)

/*----------------------------------------------------------------------*/
/*           f l D O C H F r e e S e c t o r s							*/
/*                                                                      */
/* Marks absolute sectors by sector no. as free to be written           */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irSectorNo      : First sector no. to delete                  */
/*        irSectorCount   : Number of consecutive sectors to delete     */
/*        irFlags		  : DOCH_NORMAL_OPERATION					    */
/*							DOCH_IMMEDIATE_OPERATION					*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_ERASE_PARTITION_SECTORS							*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually deleted			*/
/*----------------------------------------------------------------------*/
#define flDOCHFreeSectors(ioreq) bdCallDOCH(SDK_FREE_SECTORS, ioreq)

/*----------------------------------------------------------------------*/
/*        f l D O C H W i p e S e c t o r s								*/
/*                                                                      */
/* Securely erase data in sectors										*/
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irSectorCount   : Number of sectors to transfer (1..2).		*/
/*        irData		  : 1..2 sectors with following layout:			*/
/*								- 1st 8bytes - reserved	as zeroes		*/
/*								- (FLDWord) : First sector to delete	*/
/*								  (FLDWord) : # of sectors to delete	*/
/*								- (FLDWord) : Second sector to delete	*/
/*								  (FLDWord) : # of sectors to delete	*/
/*								- ...									*/
/*								- (FLDWord) : Nth sector to delete		*/
/*								  (FLDWord) : # of sectors to delete	*/
/*							* Last transaction should have both start	*/
/*							  and length fields set to 0.				*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_SECURE_ERASE											*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHWipeSectors(ioreq) bdCallDOCH(SDK_WIPE_SECTORS, ioreq)

/*----------------------------------------------------------------------*/
/*         f l D O C H P r e p a r e F o r W r i t e					*/
/*                                                                      */
/*	Signal to DOCH that these sectors are going to be over-written in	*/
/*	following write command												*/
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write      */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_OPTIMIZE_PARTITION_SECTORS						*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHPrepareForWrite(ioreq) bdCallDOCH(SDK_PREPARE_FOR_WRITE, ioreq)

/*	Flexi-Flash	*/

/*----------------------------------------------------------------------*/
/*	        f l D O C H W r i t e F l e x i F a s t						*/
/*                                                                      */
/* Flexi-Flash Write Fast							                    */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write      */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_FLEXI										*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*        irSectorCount   : Number of sectors actually written          */
/*----------------------------------------------------------------------*/
#define flDOCHWriteFlexiFast(ioreq) bdCallDOCH(SDK_WRITE_FLEXI_FAST, ioreq)

/*----------------------------------------------------------------------*/
/*	       f l D O C H W r i t e F l e x i N o r m a l					*/
/*                                                                      */
/* Flexi-Flash Write Normal							                    */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write     */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_FLEXI										*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*        irSectorCount   : Number of sectors actually written          */
/*----------------------------------------------------------------------*/
#define flDOCHWriteFlexiNormal(ioreq) bdCallDOCH(SDK_WRITE_FLEXI_NORMAL, ioreq)

/*----------------------------------------------------------------------*/
/*		      f l D O C H R e W r i t e N o r m a l						*/
/*                                                                      */
/* Flexi-Flash Re-Write Normal							                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*                          Partition number (zero based)	            */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write      */
/*                                                                      */
/* ATA command:															*/
/*																		*/
/* ATA sub-command:														*/
/*			None														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*        irSectorCount   : Number of sectors actually re-written       */
/*----------------------------------------------------------------------*/
#define flDOCHReWriteFlexiNormal(ioreq) bdCallDOCH(SDK_REWRITE_FLEXI_NORMAL, &ioreq)


/*----------------------------------------------------------------------*/
/*       f l D O C H M a n a g e A t o m i c W r i t e S e q			*/
/*                                                                      */
/* Manage atomic write sequence per partition		                    */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                        Partition number (zero based)					*/
/*		irCount			: DOCH_START_ATOMIC_WRITE						*/
/*						  DOCH_FINISH_ATOMIC_WRITE						*/
/*						  DOCH_ABORT_ATOMIC_WRITE						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_ATOMIC_WRITE_SEQUENCE									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHManageAtomicWriteSeq(ioreq) bdCallDOCH(SDK_ATOMIC_WRITE_SEQ, ioreq)

/*----------------------------------------------------------------------*/
/*         f l D O C H A c c e s s P a r t W i t h P w d				*/
/*                                                                      */
/* Insert the protection key in order to remove the protection of the   */
/* specified partition or the entire media								*/
/* Partition could be authenticated both by user and master password	*/
/* the last successful authentication supersedes the previous one.		*/
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*                     Partition number (zero based)					*/
/*						0xF - for authenticating the entire device		*/
/*	irFlags			 : Authentication Type								*/
/*					 : DOCH_ACCESS_USER_PASSWORD						*/
/*					   DOCH_ACCESS_MASTER_PASSWORD						*/
/*					   DOCH_ACCESS_GATE_KEEPER							*/
/*  irData           : pointer to an DOCH_PartitionAcessPassword struct */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_ACCESS_CONTROL									*/
/* ATA sub-command:														*/
/*			DOCH_EN_ACCESS_WPWD											*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHAccessPartWithPwd(ioreq) bdCallDOCH(SDK_ACCESS_PART_WITH_PWD, ioreq)


/*----------------------------------------------------------------------*/
/*         f l D O C H D i s a b l e P a r t A c c e s s				*/
/*                                                                      */
/* Remove the protection key making the partition protected again       */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (zero based)                  */
/*		                    Partition number (zero based)				*/
/*								0xF - for disabling access to the entire*/
/*									  media								*/
/*		  irFlags		 : Authentication to withdraw					*/
/*						   DOCH_ACCESS_USER_PASSWORD					*/
/*						   DOCH_ACCESS_MASTER_PASSWORD					*/
/*						   DOCH_ACCESS_GATE_KEEPER						*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_ACCESS_CONTROL									*/
/* ATA sub-command:														*/
/*			DOCH_DISABLE_ACCESS											*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHDisablePartAccess(ioreq) bdCallDOCH(SDK_DISABLE_PART_ACCESS, ioreq)


/*----------------------------------------------------------------------*/
/*		 	f l D O C H S e n d H o s t P u b l i c K e y				*/
/*                                                                      */
/* Host sends its public key for this partition & random challenge      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*	                      Partition number (zero based)					*/
/*							0xF - for disabling access to the entire	*/
/*								  media									*/
/*		irFlags			: DOCH_ACCESS_USER_PASSWORD						*/
/*						  DOCH_ACCESS_MASTER_PASSWORD					*/
/*						  DOCH_ACCESS_GATE_KEEPER						*/
/*		irData			: Pointer to DOCH_HostPublicKey	structure		*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_ACCESS_CONTROL									*/
/* ATA sub-command:														*/
/*			DOCH_TX_HOST_PUBLICKEY										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSendHostPublicKey(ioreq) bdCallDOCH(SDK_PKI_HOST, ioreq)


/*----------------------------------------------------------------------*/
/*		  f l D O C H R e c e i v e D o c h P u b l i c K e y 			*/
/*                                                                      */
/* DOCH sends its public key, host's random challenge encrypted by DOCH */
/* private key, and DOCH's random challenge to host						*/
/*                                                                      */
/* Parameters:                                                          */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*	                      Partition number (zero based)					*/
/*							0xF - for disabling access to the entire	*/
/*								  media									*/
/*		irFlags			: DOCH_ACCESS_USER_PASSWORD						*/
/*						  DOCH_ACCESS_MASTER_PASSWORD					*/
/*						  DOCH_ACCESS_GATE_KEEPER						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_ACCESS_CONTROL									*/
/* ATA sub-command:														*/
/*			DOCH_RX_DOCH_PUBLICKEY										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReceiveDochPublicKey(ioreq) bdCallDOCH(SDK_PKI_DOCH, ioreq)


/*----------------------------------------------------------------------*/
/*			f l D O C H V e r i f y H o s t K e y						*/
/*                                                                      */
/* Host sends DOCH's random challenge encrypted by host's private key   */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                        Partition number (zero based)					*/
/*		irCount			: DOCH_ACCESS_USER_PASSWORD						*/
/*						  DOCH_ACCESS_MASTER_PASSWORD					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_ACCESS_CONTROL									*/
/* ATA sub-command:														*/
/*			DOCH_VERIFY_HOST_KEY										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHVerifyHostKey(ioreq) bdCallDOCH(SDK_PKI_VERIFY_HOST_KEY, ioreq)


/*----------------------------------------------------------------------*/
/*    f l D O C H S e t P a r i t i o n P r o t e c t i o n				*/
/*                                                                      */
/* Set partition properties (attributes/passkey)	.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*                     Partition number (zero based)					*/
/*  irData           : Pointer to DOCH_PartitionProtectionAPI           */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_SET_PARTITION_PROTECTION								*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHSetParitionProtection(ioreq) bdCallDOCH(SDK_SET_PART_PROTECTION, ioreq)

/*----------------------------------------------------------------------*/
/*    f l D O C H S e t P a r i t i o n U s e r A t t r i b u t e s		*/
/*                                                                      */
/* Set partition user attributes					.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*                     Partition number (zero based)					*/
/*  irData           : Pointer to DOCH_PartitionUserAttr				*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_SET_PARTITION_USER_ATTR								*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetParitionUserAttributes(ioreq) bdCallDOCH(SDK_SET_PART_USER_ATTR, ioreq)

/*----------------------------------------------------------------------*/
/*    f l D O C H G e t P a r i t i o n U s e r A t t r i b u t e s		*/
/*                                                                      */
/* Get partition user attributes					.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*                     Partition number (zero based)					*/
/*  irData           : Pointer to DOCH_PartitionUserAttr		        */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_GET_PARTITION_USER_ATTR								*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHGetParitionUserAttributes(ioreq) bdCallDOCH(SDK_GET_PART_USER_ATTR, ioreq)

/*----------------------------------------------------------------------*/
/*	    f l D O C H S e t D i s k U s e r A t t r i b u t e s			*/
/*                                                                      */
/* Set disk user attributes					.					        */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*  irData           : Pointer to 1 sector of data						*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_SET_DISK_USER_ATTR										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetDiskUserAttributes(ioreq) bdCallDOCH(SDK_SET_DISK_USER_ATTR, ioreq)

/*----------------------------------------------------------------------*/
/*	    f l D O C H G e t D i s k U s e r A t t r i b u t e s			*/
/*                                                                      */
/* Get disk user attributes					.					        */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*  irData           : Pointer to 1 sector of data						*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_PARTITION_MANAGEMENT								*/
/* ATA sub-command:														*/
/*			DOCH_GET_DISK_USER_ATTR										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHGetDiskUserAttributes(ioreq) bdCallDOCH(SDK_GET_DISK_USER_ATTR, ioreq)

/*----------------------------------------------------------------------*/
/*	    f l D O C H G e t C o n f i g u r a t i o n D a t a				*/
/*                                                                      */
/* Read the device configuration data. No authentication is required	*/
/* for calling this command, but the fields containing keys in the		*/
/* configuration data will be masked by ETFFS using zeros. 				*/
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*  irData           : Pointer to 1..3 sector(s) of data.				*/
/*  irCount			 : Sector offset in the configuration data to start	*/
/*					   reading from.									*/
/*  irLength		 : Number of sectors of configuration data to read.	*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_GET_CONFIGURATION_DATA									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHGetConfigurationData(ioreq) bdCallDOCH(SDK_GET_CONFIG_DATA, ioreq)

/*----------------------------------------------------------------------*/
/*	    f l D O C H S e t C o n f i g u r a t i o n D a t a				*/
/*                                                                      */
/* Save the device configuration data. Calling this command will		*/
/* succeed only if there are no partitions present on the media			*/
/* (including partition 0).												*/
/* You should use this command in the process of duplicating DiskOnChip	*/
/* device to make sure all configuration data of the original device	*/
/* have been duplicated to the new device.						        */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number (zero based)						*/
/*  irData           : Pointer to 1..3 sector(s) of data.				*/
/*  irCount			 : Sector offset in the configuration data to start	*/
/*					   reading from.									*/
/*  irLength		 : Number of sectors of configuration data to read.	*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_SET_CONFIGURATION_DATA									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetConfigurationData(ioreq) bdCallDOCH(SDK_SET_CONFIG_DATA, ioreq)

/*----------------------------------------------------------------------*/
/*           f l D O C H O p t i m i z e M e d i a						*/
/*                                                                      */
/* Performs garbage collection.										    */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle  : Socket number (zero based)						*/
/*                    Partition number (zero based)						*/
/*																		*/
/*        irCount	: DOCH_OPTIMIZE_SINGLE_PARTITION					*/
/*					  DOCH_OPTIMIZE_WHOLE_MEDIA							*/
/*																		*/
/*        irLength  : DOCH_OPTIMIZE_BY_PREPARE_FOR_WRITE				*/
/*						based on information collected during previous	*/
/*						PREPARE FOR WRITE commands						*/
/*					  DOCH_OPTIMIZE_DEFAULT								*/
/*						performs default optimization of the whole		*/
/*						partition or media								*/
/*		  irFlags	: DOCH_NORMAL_OPERATION								*/
/*					  DOCH_IMMEDIATE_OPERATION							*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_OPTIMIZE_MEDIA											*/
/*																		*/
/* Returns:                                                             */
/*        irLength  : Actual number of sectors available for writes     */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHOptimizeMedia(ioreq) bdCallDOCH(SDK_OPTIMIZE_MEDIA, ioreq)


/*----------------------------------------------------------------------*/
/*		f l D O C H G e t C u s t o m P a r a m e t e r					*/
/*                                                                      */
/* Returns 16-bit custom DOCH parameter				                    */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                        Partition number (zero based)					*/
/*		irCount			: Parameter# (see DOCH_CustomParams)			*/
/*		irFlags			: DOCH_CUSTOM_PARAM_DEFAULT - default value		*/
/*						  DOCH_CUSTOM_PARAM_TEMP - current (saved) value*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_GET_CUSTOM_PARAM										*/
/*                                                                      */
/* Returns:                                                             */
/*		  irSectorNo	  : Custom parameter value (16-Bit)				*/
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHGetCustomParameter(ioreq) bdCallDOCH(SDK_GET_CUSTOM_PARAM, ioreq)

/*----------------------------------------------------------------------*/
/*		f l D O C H S e t C u s t o m P a r a m e t e r					*/
/*                                                                      */
/* Sets 16-bit custom DOCH parameter				                    */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: Custom Parameter Number (DOCH_CustomParams)	*/
/*		irSectorNo		: Custom Parameter Value (16-Bit)				*/
/*		irFlags			: DOCH_CUSTOM_PARAM_DEFAULT - default value		*/
/*						  DOCH_CUSTOM_PARAM_TEMP - current (saved) value*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_SET_CUSTOM_PARAM										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error      : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flDOCHSetCustomParameter(ioreq) bdCallDOCH(SDK_SET_CUSTOM_PARAM, ioreq)


/*----------------------------------------------------------------------*/
/*			f l D O C H A u t o H a s h C o n t r o l					*/
/*                                                                      */
/* Enable/Disable Auto Hash Read/Write									*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: AUTO_HASH_ENABLE								*/
/*						  AUTO_HASH_DISABLE								*/
/*		irLength		: AUTO_HASH_READ								*/
/*						  AUTO_HASH_WRITE								*/
/*      irFlags			: DOCH_HASH_NO_ENCRYPTION                       */
/*						  DOCH_HASH_ENCRYPT_BY_KEY						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_AUTO_HASH_CONTROL										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHAutoHashControl(ioreq) bdCallDOCH(SDK_AUTO_HASH_CTRL, ioreq)

/*----------------------------------------------------------------------*/
/*			f l D O C H R e a d C a l c u l a t e d H a s h				*/
/*                                                                      */
/* Command for Paged partitions											*/
/* Transfers to host digest(s) calculated from data on the flash.		*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_READ_CALCULATED_HASH								*/
/* ATA sub-command:														*/
/*			None														*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReadCalculatedHash(ioreq) bdCallDOCH(SDK_READ_CALC_HASH, ioreq)

/*----------------------------------------------------------------------*/
/*			f l D O C H W r i t e C a l c u l a t e d H a s h			*/
/*                                                                      */
/* Command for Paged partitions											*/
/* No data is transfered. Digest(s) calculated from data in the flash	*/
/* are stored to the dedicated area on flash.							*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*      irCount			: DOCH_HASH_NO_ENCRYPTION                       */
/*						  DOCH_HASH_ENCRYPT_BY_KEY						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_CALCULATED_HASH							*/
/* ATA sub-command:														*/
/*			None														*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHWriteCalculatedHash(ioreq) bdCallDOCH(SDK_WRITE_CALC_HASH, ioreq)


/*----------------------------------------------------------------------*/
/*			f l D O C H R e a d O r i g i n a l H a s h					*/
/*                                                                      */
/* Command for Paged partitions											*/
/* Transfers to host digest(s) stored previously on dedicated area on	*/
/* flash																*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*      irCount			: DOCH_HASH_NO_ENCRYPTION                       */
/*						  DOCH_HASH_ENCRYPT_BY_KEY						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_READ_ORIGINAL_HASH								*/
/* ATA sub-command:														*/
/*			None														*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReadOriginalHash(ioreq) bdCallDOCH(SDK_READ_ORIG_HASH, ioreq)


/*----------------------------------------------------------------------*/
/*				f l D O C H W r i t e G i v e n H a s h					*/
/*                                                                      */
/* Command for Paged partitions											*/
/* Transfers from host digest(s) and stores them to the dedicated area 	*/
/* on flash																*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*      irCount			: DOCH_HASH_NO_ENCRYPTION                       */
/*						  DOCH_HASH_ENCRYPT_BY_KEY						*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_WRITE_GIVEN_HASH									*/
/* ATA sub-command:														*/
/*			None														*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHWriteGivenHash(ioreq) bdCallDOCH(SDK_WRITE_GIVEN_HASH, ioreq)


/*----------------------------------------------------------------------*/
/*		f l D O C H R e p o r t S u p p o r t e d A l g o r i t h m s	*/
/*                                                                      */
/* Report supported algorithms											*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_REPORT_SUPPORTED_ALGORITHMS							*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReportSupportedAlgorithms(ioreq) bdCallDOCH(SDK_REPORT_SUPP_ALG, ioreq)


/*----------------------------------------------------------------------*/
/*	f l D O C H G e t A l g o r i t h m C a p a b i l i t i e s			*/
/*                                                                      */
/* Get algorithms capabilities											*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_GET_ALGORITHM_CAPABILITIES								*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHGetAlgorithmCapabilities(ioreq) bdCallDOCH(SDK_REPORT_ALG_CAPAB, ioreq)

/*----------------------------------------------------------------------*/
/*			f l D O C H S e t A l g o r i t h m M o d e					*/
/*                                                                      */
/* Set algorithms mode													*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: bits 0..7   - Algorithm Category				*/
/*						  bits 8..15  - Algorithm # in category			*/
/*						  bits 16..24 - Mode index						*/
/*						  bits 24..31 - Key size index					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_SET_ALGORITHM_MODE										*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetAlgorithmMode(ioreq) bdCallDOCH(SDK_SET_ALG_MODE, ioreq)

/*----------------------------------------------------------------------*/
/*		f l D O C H S t a r t H a s h S t r e a m C a l c u l a t i o n	*/
/*                                                                      */
/* Restart/Continue hash stream calculation								*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: bits 0..7   - Algorithm Category				*/
/*						  bits 8..15  - Algorithm # in category			*/
/*		irLength		: HASH_REINITIALIZE								*/
/*						  HASH_CONTINUE									*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_START_HASH_STREAM_CALC									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHStartHashStreamCalculation(ioreq) bdCallDOCH(SDK_START_HASH_STREAM_CALC, ioreq)

/*----------------------------------------------------------------------*/
/*		f l D O C H R e a d S t o p H a s h S t r e a m C a l c			*/
/*                                                                      */
/* Read/Stop hash stream calculation									*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: DOCH_HASH_CONTINUE_ACCUM						*/
/*						  DOCH_HASH_STOP_ACCUM							*/
/*		irLength		: DOCH_HASH_DONT_RETURN_DATA					*/
/*						  DOCH_HASH_RETURN_ACCUM_DIGEST					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_READ_STOP_HASH_STREAM_CALC								*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReadStopHashStreamCalc(ioreq) bdCallDOCH(SDK_READ_HASH_STREAM_CALC, ioreq)


/*----------------------------------------------------------------------*/
/*		f l D O C H R e t u r n R a n d om N u m b e r s				*/
/*                                                                      */
/* Return random numbers												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: bits 0..7   - Algorithm Category				*/
/*						  bits 8..15  - Algorithm # in category			*/
/*		irLength		: # of 32-Bit random numbers to generate		*/
/*						  (max is 64, e.g full sector)					*/
/*		irData			: Pointer to 1 sector of data which will hold	*/
/*						  the number of requested random numbers		*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_RETURN_RANDOM_NUMBERS									*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHReturnRandomNumbers(ioreq) bdCallDOCH(SDK_RETURN_RAND_NUMS, ioreq)


/*----------------------------------------------------------------------*/
/*					f l D O C H S e t H a s h K e y						*/
/*                                                                      */
/* Set hash key															*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*		irCount			: DOCH_HASH_DECRYPTION_KEY						*/
/*						  DOCH_HASH_ENCRYPTION_KEY						*/
/*		irLength		: DOCH_HASH_USE_DOCH_PUBLIC_KEY					*/
/*						  DOCH_HASH_USE_HOST_PUBLIC_KEY					*/
/*																		*/
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_SECURITY_CTRL								*/
/* ATA sub-command:														*/
/*			DOCH_SET_KEYS												*/
/*                                                                      */
/* Returns:                                                             */
/*        DOCH_Error        : 0 on success, otherwise failed            */
/*----------------------------------------------------------------------*/
#define flDOCHSetHashKey(ioreq) bdCallDOCH(SDK_SET_HASH_KEY, ioreq)

/*----------------------------------------------------------------------*/
/*				f l D O C H G e t P o w e r M o d e						*/
/*                                                                      */
/* Retrieve device power mode											*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle		: Socket number (zero based)		            */
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_SET_POWER_MODE											*/
/*																		*/
/* Returns:                                                             */
/*      irFlags			:								                */
/*						  DOCH_PM_WORK_MODE								*/
/*						  DOCH_PM_INACTIVE_MODE							*/
/*      irCount			:												*/
/*			Bits 0..1	: Work Mode										*/
/*						  DOCH_WM_NORMAL				                */
/*						  DOCH_WM_LOW_FREQ				                */
/*						  DOCH_WM_NORMAL_AND_AUTO_STBY	                */
/*						  DOCH_WM_LOW_FREQ_AND_AUTO_STBY	            */
/*			Bit  4		: Inactive Mode									*/
/*						  DOCH_IM_IDLE					                */
/*						  DOCH_IM_DPD									*/
/*						  DOCH_IM_IDLE_2_DPD							*/
/*      irLength		: Timeout for transfer from Standby mode to	DPD */
/*						  mode (in mSec, 100ms resolution)				*/
/*      DOCH_Error		: 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
#define flDOCHGetPowerMode(ioreq) bdCallDOCH(SDK_GET_POWER_MODE, ioreq)

/*----------------------------------------------------------------------*/
/*	            D O C H S e t P o w e r M o d e							*/
/*                                                                      */
/* Set device power mode												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle		: Socket number (zero based)		            */
/*      irFlags			:								                */
/*			Bits 0..1 - which mode(s) should be set						*/
/*						  DOCH_PM_SET_WORK_MODE			                */
/*						  DOCH_PM_SET_INACTIVE_MODE						*/
/*						  DOCH_PM_SET_BOTH_MODES						*/
/*						  DOCH_PM_SET_NONE								*/
/*			Bit  2	- which mode device should pass to after set        */
/*						  DOCH_PM_WORK_MODE				                */
/*						  DOCH_PM_INACTIVE_MODE				            */
/*			Bit  4										                */
/*						  DOCH_PM_SAVE_DEFAULT							*/
/*						  (Save new settings as default settings )      */
/*      irCount			:												*/
/*			Bits 0..1	: Work Mode to be set							*/
/*						  DOCH_WM_NORMAL				                */
/*						  DOCH_WM_LOW_FREQ				                */
/*						  DOCH_WM_NORMAL_AND_AUTO_STBY	                */
/*						  DOCH_WM_LOW_FREQ_AND_AUTO_STBY	            */
/*			Bit  4		: Inactive Mode	 to be set      				*/
/*						  DOCH_IM_IDLE					                */
/*						  DOCH_IM_DPD									*/
/*						  DOCH_IM_IDLE_2_DPD							*/
/*      irLength		: Timeout from Active to Inactive mode          */
/*                        (1 millisecond resolution) or from Idle to DPD*/
/*                        mode (100 milliseconds resolution) -          */
/*                        up to active inactive configuration			*/
/*                                                                      */
/* ATA command:															*/
/*			DOCH_VSCMD_EXT_DEVICE_CTRL									*/
/* ATA sub-command:														*/
/*			DOCH_SET_POWER_MODE											*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHSetPowerMode(ioreq) bdCallDOCH(SDK_SET_POWER_MODE, ioreq)

/*----------------------------------------------------------------------*/
/*		          f l D O C H C o n f i g H W							*/
/*                                                                      */
/* Control HW registers													*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                        Partition number (zero based)					*/
/*      irFlags			: HW Configuration type			                */
/*						  (See DOCH_HwConfigType for values)            */
/*		irLength		: HW configuration type dependant               */
/*                                                                      */
/* ATA command:															*/
/*			NONE														*/
/* ATA sub-command:														*/
/*			NONE														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHConfigHW(ioreq) bdCallDOCH(SDK_HW_CONFIG, ioreq)

/*----------------------------------------------------------------------*/
/*	       f l D O C H R e c o v e r F r o m P o w e r L o s s			*/
/*                                                                      */
/* Set last known values of DOCH control registers back to device after	*/
/* power loss was detected.												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                                                                      */
/* ATA command:															*/
/*			NONE														*/
/* ATA sub-command:														*/
/*			NONE														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHRecoverFromPowerLoss(ioreq) bdCallDOCH(SDK_RECOVER_FROM_POWER_LOSS, ioreq)

/*----------------------------------------------------------------------*/
/*			       f l D O C H S e t E n v V a r						*/
/*                                                                      */
/* Set environment variable.											*/
/* Available environment variables are listed in DOCH_EnVars.			*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*                        Partition number (zero based, if relevant)	*/
/*      irFlags			: Environment variable			                */
/*																		*/
/*		irLength		: Value to set					                */
/*                                                                      */
/* ATA command:															*/
/*			NONE														*/
/* ATA sub-command:														*/
/*			NONE														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif
DOCH_Error flDOCHSetEnvVar(IOreq* ioreq);
#ifdef __cplusplus
}
#endif

/*----------------------------------------------------------------------*/
/*			       f l D O C H C l e a r I R Q							*/
/*                                                                      */
/* Clear the ATA interrupt.												*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*																		*/
/* ATA command:															*/
/*			NONE														*/
/* ATA sub-command:														*/
/*			NONE														*/
/*																		*/
/* Returns:                                                             */
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHClearIRQ(ioreq) bdCallDOCH(SDK_CLEAR_ATA_INTERRUPT, ioreq)

/*----------------------------------------------------------------------*/
/*		   f l D O C H G e t P h y s i c a l A d d r e s s				*/
/*                                                                      */
/* Retrieve physical address of the socket.								*/
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (zero based)					*/
/*																		*/
/* ATA command:															*/
/*			NONE														*/
/* ATA sub-command:														*/
/*			NONE														*/
/*																		*/
/* Returns:                                                             */
/*        irCount	  : Socket Physical Address							*/
/*        DOCH_Error  : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/
#define flDOCHGetPhysicalAddress(ioreq) bdCallDOCH(SDK_GET_PHYSICAL_ADDRESS, ioreq)

#ifndef flFormatFS
/*----------------------------------------------------------------------*/
/*                      f l F o r m a t F S                             */
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 11-8 - Logical partition in Flash partition (zero based)*/
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : First absolute sector of logical partition  */
/*                          (if bit 13 is set)                          */
/*        irSectorCount   : Number of sectors in logical partition		*/
/*                          (if bit 13 is set)                          */
/*        irData          : Address of the FATFormatParams  structure   */
/*        irFlags        : 												*/
/*			  bit 14 - FL_DO_NOT_UPDATE_MBR 							*/
/*                        bit 13 - FL_MEDIA_WITHOUT_MBR                 */
/*                        bit 12 - FL_MOUNT_ON_GIVEN_RANGE              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flFormatFS(ioreq)        formatCall(FL_FORMAT_FS,ioreq)
#endif /*flFormatFS*/

#ifndef flCreateLogicalPartitions
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irCount         : Number of LogicalPartitionParams structures */
/*        irData          : Address of array of LogicalPartitionParams structures */
/*        irFlags         : 0 - reserved                                */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flCreateLogicalPartitions(ioreq)        formatCall(FL_CREATE_LOGICAL_PARTITIONS,ioreq)
#endif /*flCreateLogicalPartitions*/

#ifndef flFindLogicalPartition
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 11-8 - Logical partition in Flash        */
/*                                   partition (zero based)             */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irFlags         : 0 - reserved                                */
/*        irData          : Address of the LogPartitionInfo structure   */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flFindLogicalPartition(ioreq)        formatCall(FL_FIND_LOGICAL_PARTITION,ioreq)
#endif	/* flFindLogicalPartition */


#ifdef __cplusplus
extern "C" {
#endif
/*Pass-Thru routine*/
DOCH_Error DOCHAtaPassThrough(FLSNative		socketNum,
							  FLSNative		passThruOP,
							  DOCH_Registers *in_regs,
							  DOCH_Registers *out_regs,
							  FLNative		secNum,
							  void*			userBuff,
							  FLBoolean		useInterrupt);


DOCH_Error DOCHIdentifyDiskOnChipDeviceSingleFloor(IOreq* ioreq);

/*Flags for format operation*/
#define DOCH_LEAVE_PARTITIONS        0x8


#ifdef __cplusplus
}
#endif

#endif /*_DOCHAPI*/

