/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

/************************************************************************                                                                      *
 *                          I M P O R T A N T                           *
 *                                                                      *
 * The file contains DiskOnChip memory access routines and macros       *
 * defintions.                                                          *
 *                                                                      *
 * In order to use the complete set of TrueFFS memory access routine    *
 * that allows runtime configuration of each socket access type make    *
 * sure the FL_NO_USE_FUNC is not defined in FLCUSTOM.H:                *
 *                                                                      *
 * If you know the exact configuration of your application you can      *
 * uncomment the FL_NO_USE_FUNC definition and set the proper access    *
 * type using the macroe defintion bellow.                              *
 *                                                                      *
 ************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/bddoc/src/_docsys.h-arc  $
 *
 *    Rev 1.2.1.0   Aug 08 2006 15:55:34   Polina.Marimont
 * DOC Driver 1.0 initial
 */


#ifndef _DOCSYS_H
#define _DOCSYS_H

#include "defs.h"

#ifdef FL_NO_USE_FUNC

/*--------------------------------------------------------------------------*/

/* Default access layer for 16 bit configuration */

#ifndef flDirectWrite8BitReg
#ifdef FL_BIG_ENDIAN
#define flDirectWrite8BitReg(flash,offset,val) \
        FLWRITE_IO_WORD((((FLWord)val)<<8),((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1)))
#else
#define flDirectWrite8BitReg(flash,offset,val) \
        FLWRITE_IO_WORD(((FLWord)val),((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1)))
#endif /* FL_BIG_ENDIAN */
#endif /* flDirectWrite8BitReg */

#ifndef flDirectWrite16BitReg
#define flDirectWrite16BitReg(flash,offset,val) \
        FLWRITE_IO_WORD(val,((volatile FLByte FAR0 *)((flash)->win)+(offset)))
#endif /* flDirectWrite16BitReg */

#ifndef flDirectRead8BitReg
#ifdef FL_BIG_ENDIAN
#define flDirectRead8BitReg(flash,offset)                 \
        (Reg8bitType)(((offset & 0x1) == 0) ?             \
		  ((FLREAD_IO_WORD((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1))) >> 8) : \
          ((FLREAD_IO_WORD((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1)))     )   )
#else
#define flDirectRead8BitReg(flash,offset)                 \
        (Reg8bitType)(((offset & 0x1) != 0) ?             \
		  ((FLREAD_IO_WORD((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1))) >> 8) : \
          ((FLREAD_IO_WORD((volatile FLWord FAR0 *)((flash)->win)+((offset)>>1)))     )   )
#endif /* FL_BIG_ENDIAN */
#endif /* flDirectRead8BitReg */

#ifndef flDirectRead16BitReg
#define flDirectRead16BitReg(flash,offset) \
	    FLREAD_IO_WORD((flash)->win+(offset))
#endif

#ifndef flReadEvenNumberOfBytes
#define flReadEvenNumberOfBytes(flash,offset,dest,count) \
	    TFFSCPY_FROM_IO_16_BITS( dest,((flash)->win + (offset)), count)
#endif

#ifndef flWriteEvenNumberOfBytes
#define flWriteEvenNumberOfBytes(flash,offset,src,count) \
	    TFFSCPY_TO_IO_16_BITS(((flash)->win + (offset)),src,count)
#endif

#ifndef flRead512Bytes
#define flRead512Bytes(flash,offset,dest)                flReadEvenNumberOfBytes(flash,offset,dest,512)
#endif

#ifndef flWrite512Bytes
#define flWrite512Bytes(flash,offset,src)                flWriteEvenNumberOfBytes(flash,offset,src,512)
#endif

#ifndef flDocWindow
#define flDocWindow(flash)                               (0x2000)
#endif

/*--------------------------------------------------------------------------*/

#else /* FL_NO_USE_FUNC */

/*--------------------------------------------------------------------------*/

/* Redirect to runtime access layer */

#ifndef flDirectWrite8BitReg
#define flDirectWrite8BitReg(flash,offset,val)           (flash)->memWrite8bit((flash)->win,offset,val)
#endif

#ifndef flDirectWrite16BitReg
#define flDirectWrite16BitReg(flash,offset,val)          (flash)->memWrite16bit((flash)->win,offset,val)
#endif

#ifndef flDirectRead8BitReg
#define flDirectRead8BitReg(flash,offset)                (flash)->memRead8bit((flash)->win,offset)
#endif

#ifndef flDirectRead16BitReg
#define flDirectRead16BitReg(flash,offset)               (flash)->memRead16bit((flash)->win,offset)
#endif

#ifndef flReadEvenNumberOfBytes
#define flReadEvenNumberOfBytes(flash,offset,dest,count) (flash)->memRead((flash)->win,offset,dest,count)
#endif

#ifndef flWriteEvenNumberOfBytes
#define flWriteEvenNumberOfBytes(flash,offset,src,count) (flash)->memWrite((flash)->win,offset,src,count)
#endif

#ifndef flRead512Bytes
#define flRead512Bytes(flash,offset,dest)                flReadEvenNumberOfBytes(flash,offset,dest,512)
#endif

#ifndef flWrite512Bytes
#define flWrite512Bytes(flash,offset,src)                flWriteEvenNumberOfBytes(flash,offset,src,512)
#endif

#ifndef flDocWindow
#define flDocWindow(flash)                               (flash->memWindowSize())
#endif

/*--------------------------------------------------------------------------*/

/* (private) types of DiskOnChip access configurations */

#define FL_8BIT_DOC_ACCESS         0x00000000L /* Has 8 data bits            */
#define FL_16BIT_DOC_ACCESS        0x00000100L /* Has 16 data bits           */
#define FL_XX_DATA_BITS_MASK       0x00000300L /* Mask of the above          */
#define FL_8BIT_FLASH_ACCESS       0x00000400L /* 8 bits of flash per cycle  */
#define FL_16BIT_FLASH_ACCESS      0x00000800L /* 16 bits of flash per cycle */
#define FL_XX_FLASH_ACCESS_MASK    0x00000C00L /* Mask of the above          */

#define FL_ACCESS_USER_DEFINED     0x00001000L /* User defined routines */

/* DiskOnChip routines prototypes */

extern FLStatus FAR1 setBusTypeOfFlash(FLFlash * flash,FLDword access);

#endif /* FL_NO_USE_FUNC */
#endif /* DOCSYS_H */
