/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/_fltl.h-arc  $
 *
 *    Rev 1.5   Aug 09 2006 16:52:46   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef _FLTL_H
#define _FLTL_H

typedef struct {
  SectorNo sectorsInVolume;
  FLDword bootAreaSize;
  FLDword eraseCycles;
  FLDword tlUnitBits;
} TLInfo;


/* Defragment modes types */
#define FL_FAST_SPACE			0
#define FL_NORMAL_SPACE			1



typedef struct tTLrec TLrec;     /* Defined by translation layer */


struct tTL {
  TLrec       *rec;
  FLByte      partitionNo;
  FLByte      socketNo;

  /* information is necessary for hard-disk TL implementation */
  FLWord cylinders;
  FLWord heads;
  FLWord sectorsPerTrack;
  /* they should not be concealed in TL->rec field: when the media is formatted
  it would be best if geometry written in BPB would match actual disk geometry */

  /* information necessary to support fast+normal geometry */
  FLDword fastAreaSectors;
  FLWord  fastArea_SectorsInUnit_Bits;
  FLWord  normalArea_SectorsInUnit_Bits;
  FLWord  riskZoneSectors;			/* largest of fast and normal risk zones */
  FLWord  recommendedSectorsInCluster;		/* or just call it sectorsInPage (also largest) */
  /* there is no need to hide these vars via "recommendedClusterInfo" :
  they are not used by TL itself. BTW, getTLinfo is not necessary for same reason */

  void FAR1* progressCallback;

#ifndef FL_NEW_MAPSECTOR
  const void FAR0 *(*mapSector)(TLrec *, SectorNo sectorNo, CardAddress *physAddr);
#else
  FLStatus	     (*mapSector)(TLrec *, SectorNo sectorNo, void * *retBuffer);
#endif

  FLStatus       (*writeSector)(TLrec *, SectorNo sectorNo, void FAR1 *fromAddress);

  FLStatus       (*writeMultiSector)(TLrec *, SectorNo sectorNo, void FAR1 *fromAddress,SectorNo sectorCount);
  FLStatus       (*readSectors)(TLrec *, SectorNo sectorNo, void FAR1 *dest,SectorNo sectorCount);

  FLStatus       (*deleteSector)(TLrec *, SectorNo sectorNo, SectorNo noOfSectors);
  FLStatus       (*tlSetBusy)(TLrec *, FLBoolean);
  void           (*dismount)(TLrec *);
  FLStatus       (*defragment)(TLrec *, FLSDword FAR2 *sectorsNeeded, FLDword normalSpace);
  FLStatus       (*checkVolume)(TLrec *);
  SectorNo       (*sectorsInVolume)(TLrec *);
  FLStatus       (*getTLInfo)(TLrec *, TLInfo *tlInfo);
  void           (*recommendedClusterInfo)(TLrec *, FLDword *sectorsPerCluster, FLDword *clusterAlignment);

  FLStatus       (*readBBT)(TLrec *, CardAddress FAR1 * buf, FLSDword FAR2 * mediaSize, unsigned FAR2 * noOfBB);

  FLStatus       (*notifyChange)(TLrec *, void FAR1 * reserved, FLEnvVars variableType , FLDword value);
  FLStatus       (*completeOperation)(TLrec *);

  FLDword	     (* getLastMappedSectorAddress)(TLrec *);	/* use after mapSector */
  FLStatus       (* ensureFreeSectorsInUnit)(TLrec *, FLWord wVirtualUnit, FLWord * wFreeSectorsRequired);
  FLStatus       (*secureDeleteSector)(TLrec *, SectorNo sectorNo, SectorNo noOfSectors, FLBoolean secureOperation);
};



/* The address of this, if returned from map, denotes a data error */
#ifndef FL_NEW_MAPSECTOR
/* extern FLStatus dataErrorObject;
#define dataErrorToken ((void FAR0 *) &dataErrorObject) */

#define dataErrorToken ((void FAR0 *) 0xFFFFFFFF)
/* temporary - should not be necessary with new mapSector
old method (address of dataErrorObject) is not translatable across BD-FS split
or translatable with added code/complexity */
#endif /* FL_NEW_MAPSECTOR */

#ifdef FLFLASH_H
/* Translation layer registration information */

extern int noOfTLs;    /* No. of translation layers actually registered */

typedef struct {
  FLStatus (*mountRoutine)   (unsigned volNo, TL *tl, FLFlash *flash, FLFlash **volForCallback);
  FLStatus (*formatRoutine)  (unsigned volNo, TLFormatParams *deviceFormatParams, FLFlash *flash);
  FLStatus (*preMountRoutine)(FLFunctionNo callType, IOreq FAR2* ioreq ,FLFlash* flash,FLStatus* status);
} TLentry;

extern TLentry tlTable[FL_TLS];
extern FLStatus noFormat (unsigned volNo, TLFormatParams *formatParams, FLFlash *flash);
extern FLStatus flMount(unsigned volNo, unsigned socketNo,TL *, FLBoolean useFilters , FLFlash *flash);
extern FLStatus flPreMount(FLFunctionNo callType, IOreq FAR2* ioreq , FLFlash *flash);
extern unsigned noOfDrives;
extern FLByte   flHandleConversionTable[FL_SOCKETS][FL_MAX_TL_PARTITIONS];

#ifdef FL_FORMAT_VOLUME
extern FLStatus flFormat(unsigned volNo, TLFormatParams *formatParams, FLFlash * flash);
#endif /* FL_FORMAT_VOLUME */

#endif /* FLFLASH_H */

#endif /* FLTL_H */


