/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

#ifndef BDCUSTOM_H
#define BDCUSTOM_H

#include "general.h"   // For malloc heap pointer and heap size


/************************************************************************/
/************************************************************************/
/**                                                                    **/
/**    G E N E R A L   P A C K A G E  -  C U S T O M I Z A T I O N S   **/
/**                                                                    **/
/************************************************************************/
/************************************************************************/


/* Defines the package to be compiled.
 *
 * Normally the TrueFFS SDK is compiled, but if you want to compile only the
 * Boot SDK, uncomment the definition bellow.
 *
 * Note: The BDK requires the MTDSA.H and MTDSA.C files.
 */

/* #define MTD_STANDALONE */



/* Driver & TrueFFS Version numbers (Previously named OSAK)
 *
 * The string must not be greater than 10 characters.
 *
 * Note: Other then being returned by the the flVolumeInfo() routine this
 * value has no actual affect on the TrueFFS software.
 */

#define driverVersion   "OS Less"
#define OSAKVersion     "1.0.0.0"

/*	DOCH Specific	*/

#define DOCH_32K_SLIDING_WINDOW

/************************************************************************/
/************************************************************************/
/**                                                                    **/
/**             L I M I T S  -  C U S T O M I Z A T I O N S            **/
/**                                                                    **/
/************************************************************************/
/************************************************************************/

/* Number of sockets
 *
 * Defines the maximum number of supported physical DiskOnChip devices.
 *
 * The actual number of sockets depends on which socket controllers are
 * actually registered and the number of physical devices in the system.
 */

#define FL_SOCKETS MAX_PARA_SOCKETS



/* Number of volumes
 *
 * Defines the maximum number of supported Disk (BDTL) partitions.
 *
 * The actual number of drives depends on which socket controllers are
 * actually registered, the amount of devices in the system and the
 * flash format placed on each device.
 */

#define FL_VOLUMES  (8 * FL_SOCKETS)



 /* Number of Binary partitions on the DiskOnChip.
 *
 * Defines Maximum Number of supported Binary partitions.
 *
 * The actual number of partitions depends on the flash format placed
 * on each device.
 */

#define FL_BINARY_PARTITIONS (3 * FL_SOCKETS)


#define FL_MAX_TL_PARTITIONS 8

/* Maximum MTD's and Translation Layers
 *
 * TrueFFS Heap size.
 *
 * TrueFFS uses the FL_MALLOC and FL_FREE routines to allocate the memory it
 * requires. However if your native system does not have standard libraries,
 * for dynamic memory allocation you can use the TreuFFS implementation for
 * those routines called flMalloc and flFree.
 *
 * In such case you will need to define at compile time the heap size for
 * those routines using the following macro.
 */

//#define FL_TRUEFFS_HEAP_SIZE ((DDR_DKB_IMAGE_DOWNLOAD - DDR_DKB_MDOCH3_HEAP)/2)
#define FL_TRUEFFS_HEAP_SIZE (1024*4)  /* for OBM*/



/* TrueFFS Heap pointer.
 *
 * The TrueFFS implementation of FL_MALLOC and FL_FREE routines allocates it's
 * heap as single large static array.
 *
 * It is also possible to specifically tell TrueFFS your preferred heap
 * location assuming that you are familiar with the physical memory of your
 * platform.
 */

//#define FL_TRUEFFS_HEAP_POINTER DDR_DKB_MDOCH3_HEAP   /* pull-in from general.h */
#define FL_TRUEFFS_HEAP_POINTER (&MDOC_HEAP)


/************************************************************************/
/************************************************************************/
/**                                                                    **/
/**     F E A T U R E S   IN / OUT  -  C U S T O M I Z A T I O N S     **/
/**                                                                    **/
/************************************************************************/
/************************************************************************/

/*
 * Remove all flash write functionalities from the code.
 *
 * When this option is selected, only API functions that do not involve write
 * operations to the media can be called.
 *
 * This option can be used to create read-only applications with low RAM/ROM
 * requirements.
 */

/*#define FL_READ_ONLY */



/* Flash Formatting (Block device format)
 *
 * Uncomment the following line if you need to prepare a virgin DiskOnChip
 * for work or in case you want to re-partition your existing device.
 *
 * This routine compiles the following 3 API routines:
 *    flFlashFormat(), flEraseBD() and flUnformat()
 */

#ifndef FL_READ_ONLY
#define FL_FORMAT_VOLUME
#endif

/* Partitioning to logical partitions (writing MBR)
 *
 * This routine is necessary if your OS does not provide FDISK-like utility.
 *
 * Please note that in DiskOnChip devices it is preferred to use the BDTL
 * partitions mechanism, as it provides better security and better performance.
 *
 * This compilation flag compiles the flCreateLogicalPartitions() routine.
 */
#define FL_CREATE_LOGICAL

/* Reports the location of a specific logical partition.
 *
 * This API is only necessary if you want to use Abs Block I/O
 * (which addresses whole BDTL partition).
 * File access routine and Log Block I/O routines
 * address specific logical partitions automatically.
 *
 * This compilation flag compiles the flFindLogicalPartition() routine.
 */

#define FL_FIND_LOGICAL


/* Places file system format.
 *
 * Includes the routine for placing the FAT file system format on
 * a specific logical partition.
 *
 * Please note that this routine calculates the optimal file system format
 * parameters for your specific flash device in terms of cluster size, and
 * FAT table location. These settings may have drastic impact on the device
 * performance.
 *
 * This compilation flag compiles the flFormatFS() routine.
 */
#define FL_LOGICAL_FORMAT_VOLUME
#define FL_SUPPORT_FAT32_FORMAT

/* Absolute read & write
 *
 * Uncomment the following line if you want to be able to read & write
 * sectors by absolute sector number (i.e. without regard to files and
 * directories).
 */
#define FL_ABS_READ_WRITE



/* Environment Variables
 *
 * Enable environment variables control of the TrueFFS features.
 *
 */
//#define FL_ENVIRONMENT_VARS



/* IO Control Interface
 *
 * Support standard IOCTL interface. Used only by some block device drivers.
 *
 */

/* #define FL_IOCTL_INTERFACE */



 /* Binary Partition
 *
 * Enables Binary partition manipulation.
 *
 */

#define BDK_ACCESS

#ifdef BDK_ACCESS

/* Remove Binary partition erase API */

/*#define BDK_REMOVE_ERASE_BDK_IMAGE*/

/* Remove Binary partition create API */

/*#define BDK_REMOVE_CREATE_BDK_IMAGE*/

/* Remove code used for binary partition partial page access
 *
 * Due to flash limitations, the binary partition requires special handling
 * to access (read and write) partial pages. When set this compilation flag
 * will remove the binary partition code and RAM buffers that handle partial
 * page access.
 */

/*#define FL_NO_BDK_PARTIAL_PAGE_ACCESS*/

/* Compile the Binary partition read and write to file example code
 *
 * This compilation flag is relevant only for the BDK package.
 */

/* #define BDK_IMAGE_TO_FILE */

/* Compiles the code that calculates the checksum on the data read.
 *
 * This compilation flag is relevant only for the BDK package.
 */

/* #define BDK_CHECK_SUM */

#endif /* BDK_ACCESS */



/*
 * This compilation flag has different meanings in TrueFFS SDK and Boot SDK.
 *
 * TrueFFS SDK - Removes the flReadBBT routine.
 *
 * Boot SDK    - Removes the support for none SPL partition handling.
 */

#define NO_READ_BBT_CODE



/* H/W OTP
 *
 * Enable H/W One Time Programming capability including the unique ID feature.
 *
 */

#define HW_OTP



/* H/W Protection
 *
 * Enable H/W protection of the device.
 *
 */

#define HW_PROTECTION



/* Compile the code for reading after write
 *
 * Compiles the code and buffers for reading after every write operation
 * This mode is used for debugging when you are still debugging the platform's
 * H/W.
 */

#define FL_VERIFY_WRITE



/* Verify entire volume
 *
 * Compile the flVerifyVolume() routine - this routine scans the entire disk
 * partition for power failures symptoms and correct them while initializing
 * the TL cache.
 *
 */

/* #define VERIFY_VOLUME */



/* Application exit
 *
 * If the TrueFFS application ever exits, it needs to call flEXit before
 * exiting. Uncomment the following line to enable this.
 */

#define FL_EXIT



/* Compile the extended Disk information routine
 *
 * TrueFFS 6.0 and up provide an extended information routine for internal
 * M-Systems utilities named flGetExtendedDiskInfo().
 * To compile its code define
 */

#define FL_EXTENDED_DISK_INFO



/*
 * Removes the code used for writing and reading the IPL area.
 *
 */

/*#define NO_IPL_CODE*/



/* Disable the automatic argument check
 *
 * You can remove code and even slightly improve the overall performance by
 * allowing TrueFFS to skip its internal argument check by defining
 *
 */

/* #define FL_SKIP_ARGS_CHECK */



/* Fixed or removable media
 *
 * TrueFFS was originally designed for removable flash media.
 *
 * To remove the code dealing with the media removal simply uncomment
 */

#define FL_FIXED_MEDIA



/* Compile the auto DPD code
 *
 * TrueFFS supports a mode, where TrueFFS automatically enters and exit DPD
 * after every operation.
 *
 * The compilation bellow compiles that code. Note that it's operation is
 * also under the affect of the dedicated environment variable.
 */

/* #define FL_BD_AUTO_DPD_MODE */

/*
 * Define CHECK_POWER_ON_EVERY_COMMAND, when power state should be checked after every command
 * mDOC H3 device only
 */
/* #define CHECK_POWER_ON_EVERY_COMMAND */


/*
 * Compile the code for reporting the mount routine (progress call back)
 *
 */

#define FL_REPORT_MOUNT_PROGRESS



/* Prevent the automatic recovery from reset assertion
 *
 * Usually TrueFFS will check if it is in reset mode before and after every
 * MTD operation to make sure no H/W changes were done to the device while
 * TrueFFS was not active.
 *
 * The normal mode of operation is to report this failure only if it occurred
 * in the middle of an MTD operation (found at the end of the operation).
 *
 * In case the failure was detected before the operation TrueFFS will try to
 * recover, assuming that the Platform has been put into some sort of a suspend
 * mode status and the user\driver has not initiated the proper S/W recovery
 * mechanisms.
 *
 * In case you do not trust your platform H/W you might want to remove this
 * protection to better debug it. This can be done by uncommenting the
 * compilation flag bellow.
 *
 * Please note that this mechanism is only a safety net, and the proper support
 * should be done by calling the TrueFFS recovery API's when returning
 * from the suspend mode.
 */

/* #define FL_NEVER_RECOVER_FROM_RST */


#endif /* BDCUSTOM_H */

