/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/bddoc/src/bddefs.h-arc  $
 *
 *    Rev 1.5.1.0   Aug 08 2006 15:55:34   Polina.Marimont
 * DOC Driver 1.0 initial
 */

#ifndef BDDEFS_H
#define BDDEFS_H

#include "defs.h"
#include "fltl.h"
#include "flbuffer.h"
#include "docsys.h"


typedef struct {
  FLSByte       flags;                  /* See description in flreq.h */

  FLDword	sectorsInVolume;
  unsigned	mountCount;		/* can be opened/closed several times */

  FLMutex*      volExecInProgress;
  FLFlash FAR2* flash;                  /* flash structure for low level operations */
  TL            tl;                     /* Translation layer methods */
  FLSocket      *socket;                /* Pointer to socket */

  FLBoolean     globalAttFlag;        /* indication of global attention flag */
} Volume;

#define VOLUME_NOT_OCCUPIED	0
#define VOLUME_LOW_LVL_MOUNTED	1  /* Volume is mounted for low level operations */
#define VOLUME_MOUNTED		2  /* Volume is mounted                          */
#define VOLUME_12BIT_FAT	4  /* Volume uses 12-bit FAT                     */
#define VOLUME_ABS_MOUNTED	8  /* Volume is mounted for abs calls            */
#define VOLUME_OCCUPIED		32 /* Volume record in use                       */
#define VOLUME_MOUNTED_NO_MBR	64
#define VOLUME_MOUNTED_ON_RANGE	128


#define execInProgress (pVol->volExecInProgress)

extern Volume   vols[FL_VOLUMES];

FLStatus lockForIO(FLByte socket, FLByte partition, FLBoolean onOff);
void setTL(FLByte socket, FLByte partition, TL * fsVol);

#endif
