/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/bdkemul.h-arc  $
 *
 *    Rev 1.12   Aug 09 2006 17:34:14   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.11   May 28 2006 12:48:42   polina.marimont
 * comments
 *
 *    Rev 1.10   May 17 2006 12:51:04   polina.marimont
 * 1. DOCH_DiskUserAttrWithBinary - changed to support floors
 * 2. DOCH macros use instead of numerical constants
 *
 *    Rev 1.9   Mar 22 2006 17:35:46   DoronC
 * Bug fix - add signature to disk attributes in order to use only
 * format made by TrueFFS 7.1 and not by host SDK.
 * Other format will force reformating of the media.
 *
 *    Rev 1.8   Feb 16 2006 11:32:36   DoronC
 * Store binary partition flags in the attributes and return then
 * when requested by extendedInfo for compatability with legacy
 * devices.
 *
 *    Rev 1.7   Feb 14 2006 10:50:04   DoronC
 * Remove large variables from stack. use one global buffer for
 * all large buffers needs.
 */
#ifndef BDKEMUL_H
#define BDKEMUL_H

#include "part_inf.h"

/*Unit size*/
#define BDK_SECTORS_IN_UNIT 0x200
#define BDK_UNIT_SIZE (BDK_SECTORS_IN_UNIT<<DOCH_SECTOR_SIZE_BITS)

/*Partition User Attributes*/
#define SUB_PARTITIONS_PER_BINARY	10

/*16Byte overall*/
typedef struct {
	FLByte	bSignature[4];			/*Partition signature*/
	FLDword dwOffset;				/*From start of binary partition in sectors */
	FLDword dwSize;					/*Total sub-partition size in sectors */
	FLDword dwUsedSize;				/*Used size in sectors */
} DOCH_BinarySubPartitionEmulation;

/*164Byte overall*/
typedef struct {
	FLByte	bNumOfSubPartitions;		/*Number of created sub-partitions*/
	FLByte  bReserved[3];
    FLDword dwPartitionFlags;
	DOCH_BinarySubPartitionEmulation subPartitions[SUB_PARTITIONS_PER_BINARY];
} DOCH_BinaryPartitionEmulation;

/*512Byte overall (1 sector)*/
typedef struct {
	FLByte	bReservedSDK[DOCH_PART_INFO_SDK_RESERVED_BYTES];		/*Reserved for SDK use*/
	FLByte	bType;					/*DOCH_PartitionType*/
	FLByte	breserved1[3];
	DOCH_BinaryPartitionEmulation	binPartHeader;	/*Valid only if type = PARTITION_TYPE_BINARY*/
	FLByte  bDPSFwd;				/*Next partition has same passkey (!=0)*/
	FLByte  bDPSBwd;				/*Previous partition has same passkey (!=0)*/
	FLByte	bProtected;				/*Partition was defined with PROTECTABLE flag*/
	FLByte	bChangableProtection;	/*Partition was defined with CHANGEABLE_PROTECTION flag*/
	FLByte  bReserved2[0x110];
} DOCH_PartitionUserAttrWithBinary;

typedef struct {
	FLByte bReservedSDK[DOCH_DEVICE_INFO_SDK_RESERVED_BYTES];		/*Reserved for SDK use*/
	FLByte bIplPresent;				/*Exists in DOCH_DeviceAttributes as well !*/
	FLByte bOtpPresent;				/*OTP partition is present*/
	FLByte bNumOfBinaryPartitions;	/*Number of emulated binary partitions*/
	FLByte bReserved1;
	FLByte bProgrammerName[4];
	FLByte bProgrammerVersion[4];
	FLByte bTFFSVersion[10];
    FLByte bMigrationSignature[10];
	FLByte bReserved[0x19A];
} DOCH_DiskUserAttrWithBinary;

#endif /*BDKEMUL_H*/
