/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/bddoc/src/blockdev.h-arc  $
 *
 *    Rev 1.15   Aug 09 2006 16:52:46   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef BLOCKDEV_H
#define BLOCKDEV_H

#include "flsystem.h"
#include "flstruct.h"



/* this enum is always defined, because TL structure has routine with such parameter;
because for binary compatibility structures should have all fields */


/*----------------------------------------------------------------------*/
/*                   f l S e t E n v V o l u m e                        */
/*                                                                      */
/* Change one of TrueFFS environment variables for a specific partition */
/*                                                                      */
/* Note : This routine is used by all other flSetEnv routines.          */
/*        In order to effect variables that are common to several       */
/*        sockets or volumes use INVALID_VOLUME_NUMBER                  */
/*                                                                      */
/* Parameters:                                                          */
/*      variableType    : variable type to cahnge                       */
/*      socket          : Associated socket                             */
/*      volume          : Associated volume (partition)                 */
/*      value           : varaible value                                */
/*                                                                      */
/* Note: Variables common to all sockets must be addressed using socket */
/*       0 and volume 0.                                                */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*      prevValue       : The previous value of the variable            */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvVolume(FLEnvVars variableType ,
                  FLByte  socket,FLByte  volume ,
                  FLDword value, FLDword FAR2 *prevValue);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/*----------------------------------------------------------------------*/
/*                       f l S e t E n v S o c k e t                    */
/*                                                                      */
/* Change one of TrueFFS environment variables for a specific sockets.  */
/*                                                                      */
/* Parameters:                                                          */
/*      variableType    : variable type to cahnge                       */
/*      socket          : socket number                                 */
/*      value           : varaible value                                */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*      prevValue       : The previous value of the variable            */
/*                        if there are more then 1 partition in that    */
/*                        socket , the first partition value is returned*/
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvSocket(FLEnvVars variableType , FLByte  socket ,
                        FLDword value, FLDword FAR2 *prevValue);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/*----------------------------------------------------------------------*/
/*                       f l S e t E n v All                            */
/*                                                                      */
/* Change one of TrueFFS environment variables for all systems, sockets */
/* and partitions.                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*      variableType    : variable type to cahnge                       */
/*      value           : varaible value                                */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*      prevValue       : The previous value of the variable            */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvAll(FLEnvVars variableType , FLDword value, FLDword FAR2 *prevValue);
#ifdef __cplusplus
}
#endif /* __cplusplus */



/*----------------------------------------------------------------------*/
/*                         b d C a l l                                  */
/*                                                                      */
/* Common entry-point to all file-system functions. Macros are          */
/* to call individual function, which are separately described below.   */
/*                                                                      */
/* Parameters:                                                          */
/*      function        : file-system function code (listed below)      */
/*      ioreq           : IOreq structure                               */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
/* bdCall links either with BD-stub implementation, or with BD directly */
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
typedef TFFS_DLL_API FLStatus (*bdCallType)(FLFunctionNo functionNo, IOreq FAR2 *ioreq);
extern bdCallType bdCall;
#ifdef __cplusplus
}
#endif /* __cplusplus */



/*----------------------------------------------------------------------*/
/*                  f l A b s M o u n t V o l u m e                     */
/*                                                                      */
/* Mounts, verifies or dismounts the Flash medium.                      */
/*                                                                      */
/* The volume automatically becomes unmounted if it is removed or       */
/* changed.                                                             */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 7-4 - Flash Partition # (zero based)     */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Progress call back routines                 */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flAbsMountVolume(ioreq)        bdCall(FL_ABS_MOUNT,ioreq)

/*----------------------------------------------------------------------*/
/*                   f l D i s m o u n t V o l u m e                    */
/*                                                                      */
/* Dismounts the volume.                                                */
/* This call is not normally necessary, unless it is known the volume   */
/* will soon be removed.                                                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus                : 0 on success, otherwise failed      */
/*----------------------------------------------------------------------*/
#define flDismountVolume(ioreq)        bdCall(FL_DISMOUNT_VOLUME,ioreq)

/*----------------------------------------------------------------------*/
/*                     f l C h e c k V o l u m e                        */
/*                                                                      */
/* Verifies that the current volume is mounted.                         */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flCheckVolume(ioreq)        bdCall(FL_CHECK_VOLUME,ioreq)

/*----------------------------------------------------------------------*/
/*             f l V o l u m e I n f o                                  */
/*                                                                      */
/* Get general information about the media.                             */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (0,1,..)                        */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*      irData    : Address of user buffer to read general              */
/*                          information into.                           */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flVolumeInfo(ioreq) bdCall(FL_VOLUME_INFO,ioreq)

/*----------------------------------------------------------------------*/
/*                f l C o u n t V o l u m e s                           */
/*                                                                      */
/* Counts the number of volumes on the Flash device.                    */
/*                                                                      */
/* This routine is applicable only for TL that can accomdate more then  */
/* a single volume on a flash medium. other TL's will simply return 1   */
/* while not even tring to access the medium.                           */
/*                                                                      */
/* Not all the volumes can neccesaryly be mounted. A drive formated     */
/* with a read protection will be registered but can not be accessed.   */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number ( 0,1,2...  )                 */
/*                        : Partition number ( 0,1,2...  )              */
/*        irFlags         : Returns the number of partitions            */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
#define flCountVolumes(ioreq)        bdCall(FL_COUNT_VOLUMES,ioreq)


/*----------------------------------------------------------------------*/
/*                  f l V e r i f y V o l u m e                         */
/*                                                                      */
/* Verifies a mounted volume for partialy written sectors.              */
/*                                                                      */
/* Note: The volume must be mounted first.                              */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Must be set to NULL                         */
/*        irLength        : Must be set to 0                            */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flVerifyVolume(ioreq)        bdCall(FL_VERIFY_VOLUME,ioreq)

/*----------------------------------------------------------------------*/
/*                 f l S e c t o r s I n V o l u m e                    */
/*                                                                      */
/* Returns number of virtual sectors in volume.                         */
/*                                                                      */
/* In case the inserted volume is not mounted, returns current status.  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle  : Drive number (0, 1, ...)                          */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*      irLength        : number of virtual sectors in volume           */
/*----------------------------------------------------------------------*/
#define flSectorsInVolume(ioreq)        bdCall(FL_SECTORS_IN_VOLUME,ioreq)


/*----------------------------------------------------------------------*/
/*            f l F l a s h F o r m a t                                 */
/*                                                                      */
/* Performs formatting of the DiskOnChip.                               */
/* All existing data is destroyed.                                      */
/*                                                                      */
/* Note : This routine is the format routine for OSAK 5.0 and up.       */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irFlags  :                                                    */
/*           TL_NORMAL_FORMAT          : Normal format                  */
/*           TL_LEAVE_BINARY_AREA      : Leave the previous binary area */
/*           TL_LEAVE_SOME_BINARY_AREA : Leave some of the previous     */
/*	         TL_DO_NOT_PERFORM_DOWNLOAD			                		*/
/*                                       binary partitions.             */
/*        irData   : Address of FormatParams3 structure to use          */
/*                              (defined in format.h)                   */
/*        irLength : If the TL_LEAVE_SOME_BINARY_AREA flag is set,      */
/*                   this field will indicate the number of binary      */
/*                   partitions to leave.                               */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
#define flFlashFormat(ioreq) bdCall(BD_FLASH_FORMAT,ioreq)

/*----------------------------------------------------------------------*/
/*                          f l E r a s e B D                           */
/*                                                                      */
/* Erase a single BDTL partition making sure all it's data is           */
/* permanently erased and can not be reconstructed.                     */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irPath   : Pointer to progress call back routine, or NULL     */
/*        irFlags  : reserved ( 0 )                                     */
/*        irData   : reserved (NULL)					                */
/*        irLength : reserved ( 0 )					                    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
#define flEraseBD(ioreq) bdCall(BD_ERASE_BD,ioreq)

/*----------------------------------------------------------------------*/
/*                          f l U n f o r m a t                         */
/*                                                                      */
/* Erase the entire media returning the DiskOnChip to it's virgin state */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irPath   : Pointer to progress call back routine, or NULL     */
/*        irFlags  : reserved ( 0 )                                     */
/*        irData   : reserved (NULL)					                */
/*        irLength : reserved ( 0 )					                    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
#define flUnformat(ioreq) bdCall(BD_UNFORMAT,ioreq)



/*----------------------------------------------------------------------*/
/*                         f l A b s A d d r e s s                      */
/*                                                                      */
/* Returns the current physical media offset of an absolute sector by   */
/* sector no.                                                           */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : Sector no. to address                       */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irCount         : Offset of the sector on the physical media  */
/*----------------------------------------------------------------------*/
#define flAbsAddress(ioreq)                bdCall(FL_ABS_ADDRESS,ioreq)

/*----------------------------------------------------------------------*/
/*                         f l A b s D e l e t e                        */
/*                                                                      */
/* Marks absolute sectors by sector no. as deleted.                     */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : First sector no. to delete                  */
/*        irSectorCount   : Number of consectutive sectors to delete    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount        : Number of sectors actually deleted     */
/*----------------------------------------------------------------------*/
#define flAbsDelete(ioreq)        bdCall(FL_ABS_DELETE,ioreq)

/*----------------------------------------------------------------------*/
/*                 f l A b s S e c u r e D e l e t e                    */
/*                                                                      */
/* Marks absolute sectors by sector no. as deleted making sure no       */
/* previous copy exists.                                                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : First sector no. to delete                  */
/*        irSectorCount   : Number of consecutive sectors to delete    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount        : Number of sectors actually deleted     */
/*----------------------------------------------------------------------*/
#define flAbsSecureDelete(ioreq)        bdCall(FL_ABS_SECURE_DELETE,ioreq)

/*----------------------------------------------------------------------*/
/*                           f l A b s R e a d                          */
/*                                                                      */
/* Reads absolute sectors by sector no.                                 */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Address of user buffer to read into         */
/*        irSectorNo      : First sector no. to read (sector 0 is the   */
/*                          DOS boot sector).                           */
/*        irSectorCount   : Number of consecutive sectors to read      */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount        : Number of sectors actually read        */
/*----------------------------------------------------------------------*/
#define flAbsRead(ioreq)        bdCall(FL_ABS_READ,ioreq)

/*----------------------------------------------------------------------*/
/*                         f l A b s W r i t e                          */
/*                                                                      */
/* Writes absolute sectors by sector no.                                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consectutive sectors to write     */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually written          */
/*----------------------------------------------------------------------*/
#define flAbsWrite(ioreq)        bdCall(FL_ABS_WRITE,ioreq)



/*
 * FAT Filter API
 */
  extern FLStatus     ffCheckBeforeWrite (IOreq FAR2 *ioreq);



/*----------------------------------------------------------------------*/
/*                      f l D e f r a g m e n t V o l u m e             */
/*                                                                      */
/* Performs a general defragmentation and recycling of non-writable     */
/* Flash areas, to achieve optimal write speed.                         */
/*                                                                      */
/* NOTE: The required number of sectors (in irLength) may be changed    */
/* (from another execution thread) while defragmentation is active. In  */
/* particular, the defragmentation may be cut short after it began by   */
/* modifying the irLength field to 0.                                   */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle  : Drive number (0, 1, ...)                          */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irLength  : Minimum number of sectors to make available for   */
/*                    writes.                                           */
/*                                                                      */
/* Returns:                                                             */
/*        irLength  : Actual number of sectors available for writes     */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
#define flDefragmentVolume(ioreq)        bdCall(FL_DEFRAGMENT_VOLUME,ioreq)





 /*-------------------------------------------------------------------
 * bdkReadInit - Init read operations on the DiskOnChip starting
 *       at 'startUnit', with a size of 'areaLen' bytes and 'signature'.
 *
 * Note: Blocks in the DiskOnChip are marked with a 4-character signature
 *       followed by a 4-digit hexadecimal number.
 *
 * Parameters:
 *             'irHandle'      - Drive number (0, 1, ...)
 *                        bits 7-4 - Partition # (zero based)
 *                        bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                startingBlock - unit number of the sub-partition to start reading from
 *                length        - number of bytes to read
 *                oldSign       - signature of the sub-partition
 *                flags         - Should be set to 0
 *
 *  Return :
 *      flOK                - success
 *      flDriveNotAvailable - DiskOnChip ASIC was not found
 *      flUnknownMedia      - failed in Flash chips recognition
 *      flBadFormat         - TL format does not exists
 *      flNoSpaceInVolume   - there are 0 units marked with this signature
 *      flDataError         - MTD read fault.
 *      flHWReadProtect     - HW read protection was triggerd
 *-------------------------------------------------------------------*/
#define bdkReadInit(ioreq) bdCall(FL_BINARY_READ_INIT,ioreq)

/*-------------------------------------------------------------------
 * bdkReadBlock - Read to 'buffer' from the DiskOnChip BDK Image area.
 *
 * Note: Before the first use of this function 'bdkCopyBootAreaInit'
 *       must be called
 *
 * Parameters:
 *             'irHandle'      - Drive number (0, 1, ...)
 *                    bits 7-4 - Partition # (zero based)
 *                    bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                length        - number of bytes to read
 *                bdkBuffer     - buffer to read into
 *
 *  Return :
 *      flOK                - success
 *      flDriveNotAvailable - DiskOnChip ASIC was not found
 *      flUnknownMedia      - failed in Flash chips recognition
 *      flBadFormat         - TL format does not exists
 *      flNoSpaceInVolume   - there are 0 units marked with this signature
 *      flDataError         - MTD read fault.
 *      flHWReadProtect     - HW read protection was triggerd
 *-------------------------------------------------------------------*/
#define bdkReadBlock(ioreq) bdCall(FL_BINARY_READ_BLOCK,ioreq)

/*-------------------------------------------------------------------
 * bdkWriteInit - Init update operations on the DiskOnChip starting
 *       at 'startUnit', with a size of 'areaLen' bytes and 'signature'.
 *
 * Note: Blocks in the DiskOnChip are marked with a 4-character signature
 *       followed by a 4-digit hexadecimal number.
 *
 * Parameters:
 *             'irHandle'       - Drive number (0, 1, ...)
 *                     bits 7-4 - Partition # (zero based)
 *                     bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                startingBlock - unit number of the sub-partition to start writting to
 *                length        - number of bytes to write
 *                oldSign       - signature of the sub-partition
 *                flags         - BDK_COMPLETE_IMAGE_UPDATE
 *
 * Return:     flOK              - success
 *             flGeneralFailure  - DiskOnChip ASIC was not found
 *             flUnknownMedia    - fail in Flash chips recognition
 *             flNoSpaceInVolume - 'areaLen' is bigger than BootImage length
 *-------------------------------------------------------------------*/
#define bdkWriteInit(ioreq) bdCall(FL_BINARY_WRITE_INIT,ioreq)

/*-------------------------------------------------------------------
 * bdkWriteBlock - Write 'buffer' to the DiskOnChip BDK Image area.
 *
 * Note: Before the first use of this function 'bdkUpdateBootAreaInit'
 *       must be called
 *
 * Parameters:
 *             'irHandle'       - Drive number (0, 1, ...)
 *                     bits 7-4 - Partition # (zero based)
 *                     bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                length        - number of bytes to write
 *                bdkBuffer     - buffer to write from
 *                flags         - ERASE_BEFORE_WRITE
 *
 * Return:     flOK              - success
 *             flBadLength       - buffer length > Erasable Block Size
 *             flWriteFault      - fail in buffer writing
 *             flNoSpaceInVolume - end of media was prematurely reached
 *-------------------------------------------------------------------*/
#define bdkWriteBlock(ioreq) bdCall(FL_BINARY_WRITE_BLOCK,ioreq)


/*-------------------------------------------------------------------
 * bdkErase - erase given number of blockdsin the BDK area.
 *
 *  Erase given number of blockds in the binary sub partition.
 *
 * Parameters: ioreq
 *             'irHandle'       - Drive number (0, 1, ...)
 *                     bits 7-4 - Partition # (zero based)
 *                     bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                startingBlock - unit number of the sub-partition to start erasing from
 *                length        - number of blocks to erase
 *                oldSign       - signature of the sub-partition
 *
 * Return:     flOK              - success
 *             flBadLength       - buffer length > Erasable Block Size
 *             flWriteFault      - fail in buffer writing
 *             flNoSpaceInVolume - end of media was prematurely reached
 *-------------------------------------------------------------------*/
#define bdkErase(ioreq) bdCall(FL_BINARY_ERASE,ioreq)



/*-------------------------------------------------------------------
 * bdkCreate - create new BDK partition .
 *
 *  Init create operations on the DiskOnChip starting at 'startUnit', with
 *  a # of 'units' and 'signature'.
 *
 *  Note : Blocks in the DiskOnChip are marked with a 4-character signature
 *         followed by a 4-digit hexadecimal number.
 *
 * Parameters: ioreq
 *             'irHandle'       - Drive number (0, 1, ...)
 *                     bits 7-4 - Partition # (zero based)
 *                     bits 3-0 - Socket # (zero based)
 *             'irData'         - bdkParams record
 *                length        - number of blocks to create
 *                oldSign       - signature of the sub-partition
 *                newSign       - the replacing signature
 *
 * Return:     flOK              - success
 *             flBadLength       - buffer length > Erasable Block Size
 *             flWriteFault      - fail in buffer writing
 *             flNoSpaceInVolume - end of media was prematurely reached
 *-------------------------------------------------------------------*/
#define bdkCreate(ioreq) bdCall(FL_BINARY_CREATE,ioreq)

/*----------------------------------------------------------------------*/
/*                    b d k P a r t i t i o n I n f o                   */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : volume number                               */
/*        irData          : pointer to structure that hold socket       */
/*                          parameters                                  */
/*        irLength        : Physical size of the binary volume          */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus         : 0 on success, otherwise failed.            */
/*----------------------------------------------------------------------*/
#define bdkPartitionInfo(ioreq) bdCall(FL_BINARY_PARTITION_INFO,ioreq)


/* DEEP_POWER_DOWN 1 defined in flflash.h */


/*----------------------------------------------------------------------*/
/*                   f l W r i t e I P L                                */
/*                                                                      */
/* Place a user buffer to both copies of the IPL area                   */
/*                                                                      */
/* Note : This routine is applicable only to docPlus family devices     */
/*        Doc2000 family devices will return flFeatureNotSupported      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle      : Socket number (0,1,..)                          */
/*                      4 LSB - Socket number                           */
/*      irData        : Pointer to user buffer                          */
/*      irLength      : Size of the buffer                              */
/*      irFlags       : See flags bellow                                */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flWriteIPL(ioreq) bdCall(FL_WRITE_IPL,ioreq)

/*----------------------------------------------------------------------*/
/*                           r e a d I P L                              */
/*                                                                      */
/* Read IPL to user buffer.                                             */
/*                                                                      */
/* Note : Read length must be a multiplication of 512 bytes             */
/* Note : Causes DiskOnChip Millennium Plus to download (i,e protection */
/*        key will be removed from all partitions.                      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle      : Socket number (0,1,..)                          */
/*                      4 LSB - Socket number                           */
/*      irData        : Pointer to user buffer                          */
/*      irLength      : Size of the buffer                              */
/*      irCount       : Used IPL size on the media                      */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flReadIPL(ioreq) bdCall(FL_READ_IPL,ioreq)




/*----------------------------------------------------------------------*/
/*                         f l I n i t                                  */
/*                                                                      */
/* Initializes the FLite system.                                        */
/*                                                                      */
/* Calling this function is optional. If it is not called,              */
/* initialization will be done automatically on the first FLite call.   */
/* This function is provided for those applications who want to	        */
/* explicitly initialize the system and get an initialization status.   */
/*                                                                      */
/* Calling flInit after initialization was done has no effect.          */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus      : 0 on success, otherwise failed                  */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flInit(void);
#ifdef __cplusplus
}
#endif /* __cplusplus */


/*----------------------------------------------------------------------*/
/*                            f l E x i t                               */
/*                                                                      */
/* If the application ever exits, flExit should be called before exit.  */
/* flExit flushes all buffers, closes all open files, powers down the   */
/* sockets and removes the interval timer.                              */
/*                                                                      */
/* Parameters:                                                          */
/*        None                                                          */
/*                                                                      */
/* Returns:                                                             */
/*        Nothing                                                       */
/*----------------------------------------------------------------------*/
TFFS_DLL_API void NAMING_CONVENTION flExit(void);


/*----------------------------------------------------------------------*/
/*                         f l G e t P h y s i c a l I n f o            */
/*                                                                      */
/* Get physical information of the media. The information includes      */
/* JEDEC ID, unit size and media size.                                  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0,1,..)                      */
/*        irData          : Address of user buffer to read physical     */
/*                          information into.                           */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irLength        : Window base address. note mast be cast to   */
/*                          unsigned.                                   */
/*----------------------------------------------------------------------*/
#define flGetPhysicalInfo(ioreq)        bdCall(FL_GET_PHYSICAL_INFO, ioreq)


/*----------------------------------------------------------------------*/
/*            f l E x t e n d e d G e t D i s k I n f o                 */
/*                                                                      */
/* Returns general information about the Device and a specific partition */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle      : Drive number (0, 1, ...)                      */
/*                        bits 7-4 - Must be set to 0                   */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irCount       : Partition number                              */
/*        irFlags       : Either FL_BDK_PARTITION or FL_DISK_PARTITION  */
/*        irData        : Address of FLExtendedDiskInfo structure       */
/*        irLength      : Floor number to access - FL_ALL_FLOORS        */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flGetExtendedDiskInfo(ioreq)        bdCall(FL_GET_EXTENDED_DISK_INFO,ioreq)





/*----------------------------------------------------------------------*/
/*              f l I d e n t i f y P r o t e c t i o n                 */
/*              b d k I d e n t i f y P r o t e c t i o n               */
/*                                                                      */
/* Returns the specified partitions protection attributes               */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irFlags    CHANGEABLE_PROTECTION - changeable protection type  */
/*                   PROTECTABLE     - partition can recieve protection */
/*                   READ_PROTECTED  - partition is read protected      */
/*                   WRITE_PROTECTED - partition is write protected     */
/*                   LOCK_ENABLED    - HW lock signal is enabled        */
/*                   LOCK_ASSERTED   - HW lock signal is asserted       */
/*                   KEY_INSERTED    - key is inserted (not currently   */
/*                                     protected.                       */
/*----------------------------------------------------------------------*/
#define flIdentifyProtection(ioreq) bdCall(FL_PROTECTION_GET_TYPE,ioreq)
#define bdkIdentifyProtection(ioreq) bdCall(FL_BINARY_PROTECTION_GET_TYPE,ioreq)

/*----------------------------------------------------------------------*/
/*              f l I n s e r t P r o t e c t i o n K e y               */
/*              b d k I n s e r t P r o t e c t i o n K e y             */
/*                                                                      */
/* Insert the protection key in order to remove the protection of the   */
/* partititon specified by the drive handle                             */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*  irData           : pointer to an 8 bytes key array                  */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flInsertProtectionKey(ioreq) bdCall(FL_PROTECTION_INSERT_KEY,ioreq)
#define bdkInsertProtectionKey(ioreq) bdCall(FL_BINARY_PROTECTION_INSERT_KEY,ioreq)

/*----------------------------------------------------------------------*/
/*              f l R e m o v e P r o t e c t i o n K e y               */
/*              b d k R e m o v e P r o t e c t i o n K e y             */
/*                                                                      */
/* Remove the protection key making the partition protected again       */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flRemoveProtectionKey(ioreq) bdCall(FL_PROTECTION_REMOVE_KEY,ioreq)
#define bdkRemoveProtectionKey(ioreq) bdCall(FL_BINARY_PROTECTION_REMOVE_KEY,ioreq)

/*----------------------------------------------------------------------*/
/*         f l H a r d w a r e P r o t e c t i o n L o c k              */
/*         b d k H a r d w a r e P r o t e c t i o n L o c k            */
/*                                                                      */
/* Enabled or disabled the affect of the hardware LOCK signal           */
/* The hardware lock signal disables the removal of protection through  */
/* the key therefore the partition will remain protected until the       */
/* hardware LOCK signal will be removed                                 */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irFlags    : LOCK_ENABLED locks the partition otherwise       */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flHardwareProtectionLock(ioreq) bdCall(FL_PROTECTION_SET_LOCK,ioreq)
#define bdkHardwareProtectionLock(ioreq) bdCall(FL_BINARY_PROTECTION_CHANGE_LOCK,ioreq)

/*----------------------------------------------------------------------*/
/*          f l C h a n g e P r o t e c t i o n K e y                   */
/*          b d k C h a n g e P r o t e c t i o n K e y                 */
/*                                                                      */
/* Changes the current protection key with a new one.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*  irData           : Pointer to the new 8 bytes key array             */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flChangeProtectionKey(ioreq) bdCall(FL_PROTECTION_CHANGE_KEY,ioreq)
#define bdkChangeProtectionKey(ioreq) bdCall(FL_BINARY_PROTECTION_CHANGE_KEY,ioreq)

/*----------------------------------------------------------------------*/
/*              f l C h a n g e P r o t e c t i o n T y p e             */
/*              b d k C h a n g e P r o t e c t i o n T y p e           */
/*                                                                      */
/* Changes the protection attributes of the partitions.                 */
/* In order for a partition to change its protection type (without      */
/* reformating the media) it must have the CHANGEABLE_PRTOECTION        */
/* attribute.                                                           */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flChangeProtectionType(ioreq) bdCall(FL_PROTECTION_CHANGE_TYPE,ioreq)
#define bdkChangeProtectionType(ioreq) bdCall(FL_BINARY_PROTECTION_SET_TYPE,ioreq)

/*----------------------------------------------------------------------*/
/*              f l A p p l y S t i c k y L o c k                       */
/*                                                                      */
/* Enable the sticky lock mode to all relevant partitions               */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle      : Drive number (0, 1, ...)                      */
/*                        bits 7-4 - Must be set to 0                   */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flApplyStickyLock(ioreq) bdCall(FL_PROTECTION_STICKY_LOCK,ioreq)








/*----------------------------------------------------------------------*/
/*                         f l O T P S i z e                            */
/*                                                                      */
/* Get the OTP size and stated                                          */
/*                                                                      */
/* Parameters:                                                          */
/*  IN:                                                                 */
/*    irHandle       : Socket number ( 0,1,2...  )                      */
/*                      4 LSB - Socket number                           */
/*  OUT:                                                                */
/*    irLength       : The size of the used OTP area in bytes           */
/*    irCount        : The size of the OTP area in bytes                */
/*    irFlags        : LOCKED_OTP for a locked area otherwise unlocked  */
/*                                                                      */
/* Func Returns:                                                        */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flOTPSize(ioreq) bdCall(FL_OTP_SIZE,ioreq)

/*----------------------------------------------------------------------*/
/*                 f l O T P W r i t e A n d L o c k                    */
/*                                                                      */
/* Write to the OTP area while locking it at the end.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer to write from             */
/*  irLength         : number of bytes to write                         */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/
#define flOTPWriteAndLock(ioreq) bdCall(FL_OTP_WRITE,ioreq)

/*----------------------------------------------------------------------*/
/*                         f l O T P R e a d                            */
/*                                                                      */
/* Read from the OTP area                                               */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer to read into              */
/*  irLength         : number of bytes to read                          */
/*  irCount          : offset to read from (starting at the begining of */
/*                     the OTP area                                     */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/
#define flOTPRead(ioreq) bdCall(FL_OTP_READ,ioreq)

/*----------------------------------------------------------------------*/
/*                     f l G e t U n i q u e I D                        */
/*                                                                      */
/* Returns the 16 bytes device unique ID                                */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to a 16 bytes buffer to read into the    */
/*                     unique ID data                                   */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irData          : 16 bytes unique ID buffer                   */
/*----------------------------------------------------------------------*/
#define flGetUniqueID(ioreq) bdCall(FL_UNIQUE_ID,ioreq)

/*----------------------------------------------------------------------*/
/*                f l G e t C u s t o m e r I D                         */
/*                                                                      */
/* Returns the 4 bytes customer ID                                      */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to a 4 bytes buffer to read into the     */
/*                     customer ID                                      */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irData          : 4 bytes unique ID buffer                    */
/*----------------------------------------------------------------------*/
#define flGetCustomerID(ioreq) bdCall(FL_CUSTOMER_ID,ioreq)


/*----------------------------------------------------------------------*/
/*             f l D e e p P o w e r D o w n M o d e                    */
/*                                                                      */
/* Forces the device into and out of the deep power down mode           */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irFlags          : DEEP_POWER_DOWN forces the low power consumption */
/*                     mode. otherwise turning to the regular mode      */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
#define flDeepPowerDownMode(ioreq) bdCall(FL_DEEP_POWER_DOWN_MODE,ioreq)

/*----------------------------------------------------------------------*/
/*              f l R e c o v e r F r o m P o w e r L o s s             */
/*                                                                      */
/* Recover from a power OFF without full TrueFFS initialization.        */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irFlags          : FL_PREPARE_FOR_RESUME forces the device back to  */
/*                     normal mode                                      */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
#define flRecoverFromPowerLoss(ioreq) bdCall(FL_RECOVER_FROM_POWER_LOSS,ioreq)

/*----------------------------------------------------------------------*/
/*                f l C l e a r Q u i c k M o u n t I n f o             */
/*                                                                      */
/* Clear all quick mount informtion.                                    */
/*                                                                      */
/* Must be called before calling mount volume routines.                 */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number ( 0,1,2...  )                 */
/*                        : Partition number ( 0,1,2...  )              */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
#define flClearQuickMountInfo(ioreq) bdCall(FL_CLEAR_QUICK_MOUNT_INFO,ioreq)

/*----------------------------------------------------------------------*/
/*                f l W r i t e Q u i c k M o u n t S t a t u s         */
/*                                                                      */
/* Get the status of the quick mount information.                       */
/*                                                                      */
/* Can NOT be called before calling mount volume routines.              */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle   : Socket number ( 0,1,2...  )                      */
/*                   : Partition number ( 0,1,2...  )                   */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
#define flWriteQuickMountInfo(ioreq) bdCall(FL_WRITE_QUICK_MOUNT_INFO,ioreq)

/*----------------------------------------------------------------------*/
/*                f l G e t Q u i c k M o u n t S t a t u s             */
/*                                                                      */
/* Get the status of the quick mount information.                       */
/*                                                                      */
/* Can be called before calling mount volume routines.                  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle   : Socket number ( 0,1,2...  )                      */
/*                   : Partition number ( 0,1,2...  )                   */
/*        irFlags    : return the quick mount info:                     */
/*                     FL_ON if valid FL_OFF if not                     */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
#define flGetQuickMountStatus(ioreq) bdCall(FL_GET_QUICK_MOUNT_STATUS,ioreq)

/*----------------------------------------------------------------------*/
/*             f l H w C o n f i g                                      */
/*                                                                      */
/* his routine enables to control DiskOnChip H/W features.              */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                     4 LSB - Socket number                            */
/*  irFlags          : Descrbing H/W configuration Type                 */
/*  irLength         : New value to use - Different for each H/W        */
/*                     configuration type chosen.                       */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
#define flHwConfig(ioreq) bdCall(FL_HW_CONFIG,ioreq)

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
/*----------------------------------------------------------------------*/
/*                   f l B u i l d G e o m e t r y                      */
/*                                                                      */
/* Get C/H/S information of the disk according to number of sectors.    */
/*                                                                      */
/* Parameters:                                                          */
/*  capacity    : Number of Sectors in Volume                           */
/*  cylinders   : Pointer to Number of Cylinders                        */
/*  heads       : Pointer to Number of Heads                            */
/*  sectors     : Pointer to Number of Sectors per Track                */
/*  oldFormat   : True for one sector per culoster                      */
/*  wIrHandle   : Disk partition handle to proccess                     */
/*                                                                      */
/*----------------------------------------------------------------------*/
TFFS_DLL_API void NAMING_CONVENTION flBuildGeometry(FLDword capacity, FLDword FAR2 *cylinders,
             FLDword FAR2 *heads,FLDword FAR2 *sectors, FLBoolean oldFormat, FLWord wIrHandle);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/*----------------------------------------------------------------------*/
/*                        r e a d B B T                                 */
/*                                                                      */
/* Read Bad Blocks Table of device to user buffer                       */
/*                                                                      */
/* Note: the buffer is not initialized by the function                  */
/*                                                                      */
/* Parameters:                                                          */
/*      irData          : User buffer.                                  */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*      irLength        : returns the media size                        */
/*      irFlags         : returns the actual number of badBlocks        */
/*----------------------------------------------------------------------*/
#define flReadBBT(ioreq) bdCall(FL_READ_BBT,ioreq)




/*----------------------------------------------------------------------*/
/*                         f l O T P S i z e                            */
/*                                                                      */
/* Get the OTP size and stated                                          */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irLength         : The size of the used OTP area in bytes           */
/*  irCount          : The size of the OTP ara in bytes                 */
/*  irFlags          : LOCKED_OTP for a locked area otherwise unlocked  */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/

#define flMCOTPSize(ioreq) bdCall(FL_MCOTP_SIZE,ioreq)
/* LOCKED_OTP 1  defined in flflash.h */

/*----------------------------------------------------------------------*/
/*                         f l O T P R e a d                            */
/*                                                                      */
/* Read from the OTP area                                               */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer to read into              */
/*  irLength         : number of bytes to read                          */
/*  irCount          : offset to read from (starting at the begining of */
/*                     the OTP area                                     */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/

#define flMCOTPRead(ioreq) bdCall(FL_MCOTP_READ,ioreq)

/*----------------------------------------------------------------------*/
/*                 f l O T P W r i t e A n d L o c k                    */
/*                                                                      */
/* Write to the OTP area while locking it at the end.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer to write from             */
/*  irLength         : number of bytes to write                         */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/

#define flMCOTPWriteAndLock(ioreq) bdCall(FL_MCOTP_WRITE,ioreq)

/*----------------------------------------------------------------------*/
/*                      f l F o r m a t F S                             */
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 11-8 - Logical partition in Flash partition (zero based)*/
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : First absolute sector of logical partition  */
/*                          (if bit 13 is set)                          */
/*        irSectorCount   : Number of sectors in logical partition   */
/*                          (if bit 13 is set)                          */
/*        irData          : Address of the FATFormatParams  structure   */
/*        irFlags        : 				                */
/*			  bit 14 - FL_DO_NOT_UPDATE_MBR 		*/
/*                        bit 13 - FL_MEDIA_WITHOUT_MBR                 */
/*                        bit 12 - FL_MOUNT_ON_GIVEN_RANGE              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flFormatFS(ioreq)        formatCall(FL_FORMAT_FS,ioreq)


/*----------------------------------------------------------------------*/
/*                         f o r m a t C a l l                          */
/*                                                                      */
/* Common entry-point to all file-system format functions. Macros are   */
/* to call individual function, which are separately described below.   */
/*                                                                      */
/* Parameters:                                                          */
/*      function        : file-system function code (listed below)      */
/*      ioreq           : IOreq structure                               */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION formatCall(FLFunctionNo functionNo, IOreq FAR2 *ioreq);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irCount         : Number of LogicalPartitionParams structures */
/*        irData          : Address of array of LogicalPartitionParams structures */
/*        irFlags         : 0 - reserved                                */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flCreateLogicalPartitions(ioreq)        formatCall(FL_CREATE_LOGICAL_PARTITIONS,ioreq)

/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0, 1, ...)                   */
/*                        bits 11-8 - Logical partition in Flash partition (zero based)*/
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irFlags         : 0 - reserved                                */
/*        irData          : Address of the LogPartitionInfo structure   */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
#define flFindLogicalPartition(ioreq)        formatCall(FL_FIND_LOGICAL_PARTITION,ioreq)

#ifndef FL_DO_NOT_SUPPORT_H3
/*----------------------------------------------------------------------*/
/*                 f l D o c h P a s s T h r o u g h                    */
/*                                                                      */
/* Passes ATA command directly to the DOCH device.                      */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer (for DATA IN and DATA out */
/*                     commands)										*/
/*  irLength         : number of sectors in buffer, pointed to by irData*/
/*  irCount          :  bits 0..1 - pass through operation flow, where  */
/*                        0 - No Data(CTRL), 1 - Data IN, 2 - Data OUT	*/
/*                      bit  2 - 1, when interrupt should be used,      */
/*                                  0 - otherwise                       */
/*						bits 4..7 - frame size exponent, should be set  */
/*                                  to 0 for now - 1 sector             */
/*  irPath           : pointer to  buffer from type DOCH_Registers*     */
/*                     IN - input registers, OUT - out registers        */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/
#define flDochPassThrough(ioreq)			bdCall(FL_DOCH_PASS_THROUGH,ioreq)
#endif /*FL_DO_NOT_SUPPORT_H3*/

#endif /* BLOCKDEV_H */
