/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/DocDriver/TrueFFS BD/src/defs.c-arc  $
 *
 *    Rev 1.0   Aug 08 2006 15:47:24   Polina.Marimont
 * Initial revision.
 */

#include "msys.h"
#include "msys_custom.h"
#include "misc.h"

#include "flcustom.h"
#include "flsystem.h"
#include "flchkdef.h"
#include "flsystyp.h"
#include "blockdev.h"
#include "bddefs.h"

#ifdef __cplusplus
extern "C" {
#endif

void flInitGlobalVars(void);

/*============================================================================*/
/*==== from blockdev.c */
/********************* Global variables Start **************************/

Volume    vols[FL_VOLUMES];
FLByte    flHandleConversionTable[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
static    FLBoolean initDone = FALSE;           /* Initialization not done yet   */
static    FLBoolean initGlobalVarsDone = FALSE; /* Initialization of environment */
                                                /* and access type variables not */
                                                /* done yet.                     */
unsigned  noOfDrives;
/*
 * bus configuration
 * DiskOnChip minimal bus width
 */
#ifndef FL_NO_USE_FUNC
FLDword flBusConfig[FL_SOCKETS];
#endif /* FL_NO_USE_FUNC */
/*----------------------------------------------------------------------*/
/*                          f l I n i t                                 */
/*                                                                      */
/* Initializes the FLite system, sockets and timers.                    */
/*                                                                      */
/* Calling this function is optional. If it is not called,              */
/* initialization will be done automatically .                          */
/* This function is provided for those applications who want to         */
/* explicitly initialize the system and get an initialization status.   */
/*                                                                      */
/* Calling flInit after initialization was done has no effect.          */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/

FLStatus _flInit(void)
{
    unsigned volNo;
    Volume * pVol = vols;

	if (initDone)
		return flOK;


	flInitGlobalVars();

#ifdef FL_ENVIRONMENT_VARS

	/* Call users initialization routine for :
	*  flUse8Bit,flUseNFTLCache
	*/
	flSetEnvVar();

#endif /* FL_ENVIRONMENT_VARS */

   /*
    * 1) Mark all the volumes as not used and free to be allocated.
    * 2) Clear password in order to make it invalid.
    */

    tffsset(vols,0,sizeof(vols));

    for (volNo = 0,pVol = vols; volNo < FL_VOLUMES; volNo++,pVol++)
    {
      /* The actual number of sockets is not yet known and will be retrieved by
       * flRegisterComponents routine by the socket components. For now supply
       * each of the possible sockets with its buffer and socket number.
       */
       if ( volNo < FL_SOCKETS)
       {
          pVol->socket = flSocketOf(volNo);
          pVol->flash  = flFlashOf((FLByte)volNo);
          tffsset(pVol->socket,0,sizeof(FLSocket));
          pVol->socket->volNo = volNo;
       }
       else
       {
           pVol->flash = NULL;
       }
       pVol->volExecInProgress = NULL;
    }


#ifdef FL_BACKGROUND
    flCreateBackground();
#endif
    noOfDrives  = 0;
    noOfSockets = 0;
	return flOK;
}/*_flInit*/


/*----------------------------------------------------------------------*/
/*                     f l I n i t G l o b a l V a r s                  */
/*                                                                      */
/* Initializes the FLite system, environment and access type variables. */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*      None                                                            */
/*----------------------------------------------------------------------*/

void flInitGlobalVars(void)
{
   FLFlash * flash;
   int i,j;

   if(initGlobalVarsDone == TRUE)
     return;

   /* Do not initialize variables on next call */
   initGlobalVarsDone     = TRUE;
   initDone               = FALSE;

   /*
    * Set default values to per socket/volume variables
    */

   for(i=0; i< FL_SOCKETS; i++)
   {
      flash = flFlashOf((FLByte)i);
      /* tffsset is not yet initialized */
      for(j=0;j<(int)sizeof(FLFlash);j++)
      {
         ((FLByte  *)flash)[j] = 0;
      }
#ifndef FL_NO_USE_FUNC
      flBusConfig[i] = FL_DEFAULT_BUS_MODE(i);
#endif /* FL_NO_USE_FUNC */

  }
}/*flInitGlobalVars*/

/*============================================================================*/

/*============================================================================*/
/*==== from flflash.c */
static FLFlash flashes[FL_SOCKETS];


/************************************************************************/
/************************************************************************/
/***                                                                  ***/
/***                E X P O R T E D    R O U T I N E S                ***/
/***                                                                  ***/
/************************************************************************/
/************************************************************************/

/*----------------------------------------------------------------------*/
/*                           f l F l a s h O f                          */
/*                                                                      */
/* Gets the flash connected to a volume no.                             */
/*                                                                      */
/* Parameters:                                                          */
/*    volNo        : Volume no. for which to get flash                  */
/*                                                                      */
/* Returns:                                                             */
/*     flash of volume no.                                              */
/*----------------------------------------------------------------------*/
TFFS_DLL_API FLFlash * NAMING_CONVENTION flFlashOf(FLByte volNo)
{
  return &flashes[volNo];
}


/*----------------------------------------------------------------------*/
/*                  f l I d e n t i f y F l a s h                       */
/*                                                                      */
/* Identify the current Flash medium and select an MTD for it           */
/*                                                                      */
/* Parameters:                                                          */
/*    socket     : Socket of flash                                      */
/*    vol        : New volume pointer                                   */
/*                                                                      */
/* Returns:                                                             */
/*    FLStatus    : 0 = Flash was identified                            */
/*              other = identification failed                           */
/*----------------------------------------------------------------------*/
FLStatus flIdentifyFlash(FLSocket *socket, FLFlash * pVol)
{
  /* Prevent re-identifing flash media */
  if(pVol->wasIdentified == TRUE)
     return flOK;

  /* Setup default parameters for old MTD's that do not support new properties */
  pVol->type               = NOT_FLASH;
  pVol->if_cfg             = 8;
  pVol->socket             = socket;

  return flOK;
}/*flIdentifyFlash*/
/*============================================================================*/
#ifdef __cplusplus
}
#endif



/*============================================================================*/
/*=== from bdstub.c */
#include "dochstub.h"
/*----------------------------------------------------------------------*/
/* Function name	: lockForIO*/
/* Description	    : */
/* Return type		: FLStatus */
/* Argument         : FLByte socket*/
/* Argument         : FLByte partition*/
/* Argument         : FLBoolean onOff*/
/*----------------------------------------------------------------------*/
FLStatus lockForIO(FLByte socket, FLByte partition, FLBoolean onOff)
{
    FLByte  volNo;
    Volume * pVol;

#if (FS_SOCKETS < FL_SOCKETS) || (FS_MAX_TL_PARTITIONS < FL_MAX_TL_PARTITIONS)
    /* then caller's check is not good enough */
    if ((socket >= FL_SOCKETS) || (partition >= FL_MAX_TL_PARTITIONS))
        return flBadDriveHandle;
#endif

    volNo = flHandleConversionTable[socket][partition];
    if (volNo == INVALID_VOLUME_NUMBER)
        return flBadDriveHandle;
    pVol = &vols[volNo];

    /* Group 3 - binary partition - has different relation of volNo to socket, but FS does not call them
    some format routines require partition 0 - will be checked in caller */

    checkStatus(dochSetBusy(socket, onOff, partition)); /* take DOCH mutex */
    return flOK;
}/*lockForIO()*/
/*============================================================================*/


/*============================================================================*/
/*=== from flsocket.c */
FLByte noOfSockets;        /* No. of drives actually registered */

static FLSocket sockets[FL_SOCKETS];
static FLBuffer *volBuffers[FL_SOCKETS];

#if (defined(FL_VERIFY_WRITE) || defined(VERIFY_VOLUME))
static FLByte* readBackBuffer[FL_SOCKETS];
#endif /* FL_VERIFY_WRITE || VERIFY_VOLUME */


/*----------------------------------------------------------------------*/
/*                        f l S o c k e t O f                           */
/*                                                                      */
/* Gets the socket connected to a volume no.                            */
/*                                                                      */
/* Parameters:                                                          */
/*        volNo                : Volume no. for which to get socket     */
/*                                                                      */
/* Returns:                                                             */
/*         socket of volume no.                                         */
/*----------------------------------------------------------------------*/

FLSocket *flSocketOf(unsigned volNo)
{
  return &sockets[volNo];
}



#if (defined(FL_VERIFY_WRITE) || defined(VERIFY_VOLUME))
/*----------------------------------------------------------------------*/
/*                        f l R e a d B a c k B u f f e r O f           */
/*                                                                      */
/* Gets the read back buffer connected to a volume no.                  */
/*                                                                      */
/* Parameters:                                                          */
/*        volNo                : Volume no. for which to get socket     */
/*                                                                      */
/* Returns:                                                             */
/*         buffer of volume no.                                         */
/*----------------------------------------------------------------------*/

FLByte * flReadBackBufferOf(unsigned volNo)
{
  return readBackBuffer[volNo];
}
#endif /* FL_VERIFY_WRITE || VERIFY_VOLUME */

#ifndef FL_FIXED_MEDIA



/*----------------------------------------------------------------------*/
/*                   f l G e t M a p p i n g C o n t e x t              */
/*                                                                      */
/* Returns the currently mapped window page (in 4KB units)              */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*                                                                      */
/* Returns:                                                             */
/*        unsigned int        : Current mapped page no.                 */
/*----------------------------------------------------------------------*/

unsigned flGetMappingContext(FLSocket * pVol)
{
  return pVol->window.currentPage;
}


/*----------------------------------------------------------------------*/
/*                              f l M a p                               */
/*                                                                      */
/* Maps the window to a specified card address and returns a pointer to */
/* that location (some offset within the window).                       */
/*                                                                      */
/* NOTE: Addresses over 128M are attribute memory. On PCMCIA adapters,  */
/* subtract 128M from the address and map to attribute memory.          */
/*                                                                      */
/* Parameters:                                                          */
/*      vol         : Pointer identifying drive                         */
/*      address     : Byte-address on card. NOT necessarily on a        */
/*                    full-window boundary.                             */
/*                    If above 128MB, address is in attribute space.    */
/*                                                                      */
/* Returns:                                                             */
/*        Pointer to a location within the window mapping the address.  */
/*----------------------------------------------------------------------*/

void FAR0 *flMap(FLSocket * pVol, CardAddress address)
{
  unsigned pageToMap;

  if (pVol->window.currentPage == UNDEFINED_MAPPING)
    pVol->setWindow(pVol);
  pageToMap = (unsigned) ((address & -pVol->window.size) >> 12);

  if (pVol->window.currentPage != pageToMap) {
    pVol->setMappingContext(pVol, pageToMap);
    pVol->window.currentPage = pageToMap;
    pVol->remapped = TRUE;        /* indicate remapping done */
  }

  return addToFarPointer(pVol->window.base,address & (pVol->window.size - 1));
}


/*----------------------------------------------------------------------*/
/*                    f l S e t W i n d o w B u s W i d t h             */
/*                                                                      */
/* Requests to set the window bus width to 8 or 16 bits.                */
/* Whether the request is filled depends on hardware capabilities.      */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*      width                : Requested bus width                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flSetWindowBusWidth(FLSocket * pVol, unsigned width)
{
  pVol->window.busWidth = width;
  pVol->window.currentPage = UNDEFINED_MAPPING;        /* force remapping */
}


/*----------------------------------------------------------------------*/
/*                   f l S e t W i n d o w S p e e d                    */
/*                                                                      */
/* Requests to set the window speed to a specified value.               */
/* The window speed is set to a speed equal or slower than requested,   */
/* if possible in hardware.                                             */
/*                                                                      */
/* Parameters:                                                          */
/*      vol                : Pointer identifying drive                  */
/*      nsec                : Requested window speed in nanosecond.     */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flSetWindowSpeed(FLSocket * pVol, unsigned nsec)
{
  pVol->window.speed = nsec;
  pVol->window.currentPage = UNDEFINED_MAPPING;        /* force remapping */
}


/*----------------------------------------------------------------------*/
/*                   f l S o c k e t S e t B u s y                      */
/*                                                                      */
/* Notifies the start and end of a file-system operation.               */
/*                                                                      */
/* Parameters:                                                          */
/*        vol      : Pointer identifying drive                          */
/*      state      : FL_ON (1) = operation entry                        */
/*                   FL_OFF(0) = operation exit                         */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flSocketSetBusy(FLSocket * pVol, FLBoolean state)
{
  if (state == FL_OFF)
  {
#if POLLING_INTERVAL == 0
    /* If we are not polling, activate the interval routine before exit */
    flIntervalRoutine(pVol);
#endif
  }
  else  /* FL_ON */
  {
    pVol->window.currentPage = UNDEFINED_MAPPING;        /* don't assume mapping still valid */
#ifdef FL_FIXED_MEDIA
    pVol->remapped = TRUE;
#endif /* FL_FIXED_MEDIA */
  }
}






/*----------------------------------------------------------------------*/
/*                  f l S e t P o w e r O n C a l l b a c k             */
/*                                                                      */
/* Sets a routine address to call when powering on the socket.          */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*      routine                : Routine to call when turning on power  */
/*        flash                : Flash object of routine                */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flSetPowerOnCallback(FLSocket * pVol, void (*routine)(void *flash), void *flash)
{
  pVol->powerOnCallback = routine;
  pVol->flash = flash;
}



/*----------------------------------------------------------------------*/
/*                    f l I n t e r v a l R o u t i n e                 */
/*                                                                      */
/* Performs periodic socket actions: Checks card presence, and handles  */
/* the Vcc & Vpp turn off mechanisms.                                   */
/*                                                                      */
/* The routine may be called from the interval timer or synchronously.  */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flIntervalRoutine(FLSocket * pVol)
{
#ifndef FL_FIXED_MEDIA
  if (pVol->getAndClearCardChangeIndicator == NULL && !pVol->cardChanged)
    if (!pVol->cardDetected(pVol))        /* Check that the card is still there */
      pVol->cardChanged = TRUE;
#endif /* FL_FIXED_MEDIA */

  if (pVol->VppUsers == 0) {
    if (pVol->VppState == PowerOn)
      pVol->VppState = PowerGoingOff;
    else if (pVol->VppState == PowerGoingOff) {
      pVol->VppState = PowerOff;
#ifdef SOCKET_12_VOLTS
      pVol->VppOff(pVol);
#endif
    }
    if (pVol->VccUsers == 0) {
      if (pVol->VccState == PowerOn)
        pVol->VccState = PowerGoingOff;
      else if (pVol->VccState == PowerGoingOff) {
        pVol->VccState = PowerOff;
        pVol->VccOff(pVol);
      }
    }
  }
}

#endif /* FL_FIXED_MEDIA */


/*----------------------------------------------------------------------*/
/*                       u d a t e S o c k e t P a r a m e t e r s      */
/*                                                                      */
/* Pass socket parameters to the socket interface layer.                */
/* This function should be called after the socket parameters (like     */
/* size and base) are known. If these parameters are known at           */
/* registration time then there is no need to use this function, and    */
/* the parameters can be passed to the registration routine.            */
/* The structure passed in irData is specific for each socket interface.*/
/*                                                                      */
/* Note : When using DiskOnChip this routine returns the socekt         */
/*        parameters instead of initializing them.                      */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*  params  : Record returning (or sending) the flsocket record         */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus         : 0 on success                               */
/*----------------------------------------------------------------------*/
FLStatus updateSocketParameters(FLSocket * pVol, void FAR1 *params)
{
  if (pVol->updateSocketParams)
    pVol->updateSocketParams(pVol, params);

  return flOK;
}


#ifdef FL_EXIT
/*----------------------------------------------------------------------*/
/*                    f l E x i t S o c k e t                           */
/*                                                                      */
/* Reset the socket and free resources that were allocated for this     */
/* socket.                                                              */
/* This function is called when FLite exits.                            */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flExitSocket(FLSocket * pVol)
{
#ifndef FL_FIXED_MEDIA
  flMap(pVol, 0);                           /* reset the mapping register */
  flDontNeedVcc(pVol);
  flSocketSetBusy(pVol,FL_OFF);
#endif /* FL_FIXED_MEDIA */
  if(pVol->freeSocket)
     pVol->freeSocket(pVol);                     /* free allocated resources */
  if(volBuffers[pVol->volNo] != NULL)
  {
     FL_FREE(volBuffers[pVol->volNo]);
     volBuffers[pVol->volNo] = NULL;
  }
#if (defined(FL_VERIFY_WRITE) || defined(VERIFY_VOLUME))
  if(readBackBuffer[pVol->volNo] != NULL)
  {
     FL_FREE(readBackBuffer[pVol->volNo]);
     readBackBuffer[pVol->volNo] = NULL;
  }
#endif /* FL_VERIFY_WRITE || VERIFY_VOLUME */
}
#endif /* FL_EXIT */

/*----------------------------------------------------------------------*/
/*                    f l S e t W i n d o w S i z e                     */
/*                                                                      */
/* Requests to set the window size to a specified value (power of 2).   */
/* The window size is set to a size equal or greater than requested,    */
/* if possible in hardware.                                             */
/*                                                                      */
/* Parameters:                                                          */
/*        vol                : Pointer identifying drive                */
/*      sizeIn4KBUnits : Requested window size in 4 KByte units.        */
/*                         MUST be a power of 2.                        */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flSetWindowSize(FLSocket * pVol, unsigned sizeIn4KBunits)
{
  pVol->window.size = (FLDword) (sizeIn4KBunits) * 0x1000L;
        /* Size may not be possible. Actual size will be set by 'setWindow' */
  pVol->window.base = (void *)physicalToPointer((FLDword) pVol->window.baseAddress << 12,
                                      pVol->window.size, pVol->volNo);
  pVol->window.currentPage = UNDEFINED_MAPPING;        /* force remapping */
}

/*-----------------------------------------------------------------------*/
/*                       f l I n i t S o c k e t s                       */
/*                                                                       */
/* First call to this module: Initializes the controller and all sockets */
/*                                                                       */
/* Parameters:                                                           */
/*        vol                : Pointer identifying drive                 */
/*                                                                       */
/* Returns:                                                              */
/*        FLStatus        : 0 on success, failed otherwise               */
/*---_-------------------------------------------------------------------*/

FLStatus flInitSockets(void)
{
  unsigned volNo;
  FLSocket * pVol = sockets;

  for (volNo = 0; volNo < noOfSockets; volNo++, pVol++)
  {
	flSetWindowSize(pVol, 2);                /* make it 8 KBytes */
#ifndef FL_FIXED_MEDIA
    flSetWindowSpeed(pVol, 250);
    flSetWindowBusWidth(pVol, 16);
    pVol->cardChanged = FALSE;
#endif /* FL_FIXED_MEDIA */
    /* allocate buffer for this socket */
    volBuffers[volNo] = (FLBuffer *)FL_MALLOC(sizeof(FLBuffer));
    if (volBuffers[volNo] == NULL)
	{
      DBG_PRINT_ERR(FLZONE_SOCKET,"ERROR - Failed allocating sector buffer for the socket.\r\n");
      return flNotEnoughMemory;
    }
#if (defined(FL_VERIFY_WRITE) || defined(VERIFY_VOLUME))
    /* allocate read back buffer for this socket */
    readBackBuffer[volNo] = (FLByte *)FL_MALLOC(READ_BACK_BUFFER_SIZE);
    if (readBackBuffer[volNo] == NULL) {
       DBG_PRINT_ERR(FLZONE_SOCKET,"ERROR - Failed allocating readBack buffer for the socket.\r\n");
       return flNotEnoughMemory;
    }
#endif /* FL_VERIFY_WRITE || MTD_READ_BBT || VERIFY_VOLUME */

  }

  return flOK;
}
/*============================================================================*/

/*end of file*/



