/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/DocDriver/TrueFFS BD/src/defs.h-arc  $
 *
 *    Rev 1.0   Aug 08 2006 15:47:24   Polina.Marimont
 * Initial revision.
 */

#ifndef _DEFS_H
#define _DEFS_H


void flInitGlobalVars(void);

/*=============================================================*/
/* from flsocket.h */
#include "flbuffer.h"

#define ATTRIBUTE_SPACE_MAPPED   0x8000
#define UNDEFINED_MAPPING        0x7fff


typedef enum {PowerOff, PowerGoingOff, PowerOn} PowerState;

extern FLByte noOfSockets;    /* No. of drives actually registered */

/* The milliseconds counter is active when socket polling is enabled. When
   the socket interval routine is called, the counter is incremented by
   the interval in milliseconds.
   The counter can be used to avoid getting in a loop that is not guaranteed
   to terminate (such as waiting for a flash status register). Save the counter
   at entry to the loop, and check in the loop the amount of time that
   was spent in the loop. */

extern FLDword flMsecCounter;

typedef struct tSocket FLSocket;
/*=============================================================*/

/*=============================================================*/
/* from _flsoc.h */
struct tSocket {
  unsigned        volNo;         /* Volume no. of socket */

  PowerState      DPDState;      /* Actual DPD state */
#ifdef FL_VERIFY_WRITE
  FLByte          verifyWrite;   /* VerifyWrite mode                               */
#endif /* FL_VERIFY_WRITE */
  FLBoolean       remapped;      /* set to TRUE whenever the socket window is moved */

  void            (*powerOnCallback)(void *flash); /* Notification routine for Vcc on */
  void *          flash;         /* Flash object for callback */

  struct {                       /* Window state                     */
    unsigned int  baseAddress;   /* Physical base as a 4K page       */
    unsigned int  currentPage;   /* Our current window page mapping  */
    void FAR0 *   base;          /* Pointer to window base           */
    FLSDword      size;          /* Window size (must by power of 2) */
    unsigned      speed;         /* in nsec.                         */
    unsigned      busWidth;      /* 8 or 16 bits                     */
  } window;
  FLBoolean (*cardDetected)(FLSocket * pVol);
  void (*VccOn)(FLSocket * pVol);
  void (*VccOff)(FLSocket * pVol);
  FLStatus (*initSocket)(FLSocket * pVol);
  void (*setWindow)(FLSocket * pVol);
  void (*setMappingContext)(FLSocket * pVol, unsigned page);
  FLBoolean (*getAndClearCardChangeIndicator)(FLSocket * pVol);
  FLBoolean (*writeProtected)(FLSocket * pVol);
  void (*updateSocketParams)(FLSocket * pVol, void FAR1 *params);
#ifdef FL_EXIT
  void (*freeSocket)(FLSocket * pVol);
#endif
};


/* See interface documentation of functions in socket.c */

extern FLStatus updateSocketParameters(FLSocket *, void FAR1 *);

extern FLStatus      flInitSockets(void);

#ifdef FL_EXIT
extern void      flExitSocket(FLSocket *);
#endif

extern FLSocket* flSocketOf(unsigned volNo);
extern FLBuffer* flBufferOf(unsigned volNo);
#if (defined(FL_VERIFY_WRITE) || defined(VERIFY_VOLUME))
extern FLByte    * flReadBackBufferOf(unsigned volNo);
#endif /* FL_VERIFY_WRITE || VERIFY_VOLUME */
extern void      flNeedVcc(FLSocket *);
extern void      flDontNeedVcc(FLSocket *);
#ifdef SOCKET_12_VOLTS
extern FLStatus  flNeedVpp(FLSocket *);
extern void      flDontNeedVpp(FLSocket *);
#endif
extern void      flSocketSetBusy(FLSocket *, FLBoolean);      /* entry/exit operations */
#ifndef FL_FIXED_MEDIA
extern FLStatus  flMediaCheck(FLSocket *);      /* check for media status change */
#endif /* FL_FIXED_MEDIA */
extern unsigned  flGetMappingContext(FLSocket *);  /* Currently mapped 4KB page */
extern void FAR0*flMap(FLSocket *, CardAddress);      /* map and point at card address */
extern void      flSetWindowBusWidth(FLSocket *, unsigned); /* set window data-path */
extern void      flSetWindowSpeed(FLSocket *, unsigned);      /* set window speed (nsec.) */
extern void      flSetWindowSize(FLSocket *, unsigned);      /* in 4KB units */

extern void      flSetPowerOnCallback(FLSocket *, void (*)(void *), void *);
                  /* Set MTD notification for socket power on */
extern void      flIntervalRoutine(FLSocket *);      /* socket interval routine */

/*=============================================================*/

/*=============================================================*/
/* from flflash.h */

/* Some useful types for mapped Flash locations */

typedef volatile FLByte FAR0 * FlashPTR;
typedef volatile unsigned short int FAR0 * FlashWPTR;
typedef volatile FLDword FAR0 * FlashDPTR;
typedef FLWord FlashType;        /* JEDEC id */
typedef volatile FLByte FAR0* NDOC2window;

typedef FLByte Reg8bitType;
typedef FLWord Reg16bitType;


#define NOT_FLASH          0

/* Media types */
#define NOT_DOC_TYPE              0
#define DOC_TYPE                  1
#define MDOC_TYPE                 2
#define DOC2000TSOP_TYPE          3
#define MDOCP_TYPE                4
#define MDOCP_16_TYPE             5
#define DOC_H1_TYPE               6
#define M512_G3_TYPE              7
#define M256_P3_TYPE              8
#define M256_G3_TYPE              9
#define M128_P3_TYPE              10
#define M1G_G3_TYPE               11
#define M512_P3_TYPE              12
#define M1G_G4_TYPE               13
#define M512_P4_TYPE              14
#define H3_TYPE                   15
#define AMD_NOR_TYPE              100
#define SEIJA_TYPE                200

/* page characteristics flags */
#define  BIG_PAGE    0x0100             /* page size > 100H*/
#define  FULL_PAGE   0x0200                  /* no partial page programming*/
#define  BIG_ADDR    0x0400             /* 4 byte address cycle */

/* MTD write routine mode flags */
#define FL_DATA          0      /* Read/Write data area                */
#define OVERWRITE        1      /* Overwriting non-erased area         */
#define EDC              2      /* Activate ECC/EDC                    */
#define EXTRA            4      /* Read/write spare area               */
#define DELETE_FLAG      0x20   /* Write sector with delete mark on sector flags*/
#define NO_SECOND_TRY    0x8000 /* do not read again on EDC error      */
#define TRANSACTION_BITS 0x0F00 /* bits that are saved for transaction no' */


/* protection specific defintions */
#define PROTECTION_KEY_LENGTH    8 /* Size of protection key in bytes    */
#define MAX_PROTECTED_PARTITIONS 2 /* Max Number of protected partitiosn */
#define DEFAULT_KEY              "00000000"

/* IPL modes */
#define FL_IPL_MODE_SA          2  /* Not used any more, done automatically by */
#define FL_IPL_MODE_XSCALE      4  /* Not used any more, done automatically by */

#define FL_IPL_READ_FROM_START   0
#define FL_IPL_DOWNLOAD_AND_READ 1


/* Bit 5 Quad Redundency of IPL mode                                               */
#define FL_IPL_PAGE_QUAD_RED	32

                                        /*       smaller then IPL size                */
/* OTP specific defintions */
#define CUSTOMER_ID_LEN          4
#define UNIQUE_ID_LEN            16

/* BBT block types */
#define BBT_GOOD_UNIT            0xff
#define BBT_UNMARKED_BAD_UNIT    0xf0
#define BBT_UNAVAIL_UNIT         0x1
#define BBT_BAD_UNIT             0x0

/* Unmarked bad blocks types */
#define FL_BLOCK_IS_MARKED_AS_UNERASABLE 0x55
#define FL_BLOCK_IS_MARKED_AS_UNWRITABLE 0x22
#define FL_BLOCK_IS_MARKED_AS_UNREADABLE 0x88
#define FL_BLOCK_IS_MARKED_AS_GOOD       0xff
#define FL_BLOCK_IS_MARKED_AS_NEED_ERASE 0xfe
#define FL_MAX_BIT_DISTANCE_DBB          0x20

/* Flag bit values */
#define SUSPEND_FOR_WRITE        1        /* MTD provides suspend for write */
#define NFTL_ENABLED             2        /* Flash can run NFTL             */
#define INFTL_ENABLED            4        /* Flash can run INFTL            */
#define EXTERNAL_EPROM           8        /* Can support external eprom     */
#define SAFTL_ENABLED            0x10     /* Flash can run SAFTL            */

/* Flash Technology types */
#define FL_SUPPORT_MLC             0x01
#define FL_SUPPORT_RELIABLE        0x02
#define FL_SUPPORT_FAST            0x04
#define FL_SUPPORT_NO_MATCHING     0x08
#define FL_SUPPORT_WRITE_CACHE     0x10
#define FL_2K_ADDRESS_SPACE        0x20
#define FL_SUPPORT_SEQUENTIAL_READ 0x40

/* Bus types */
#define FL_SRAM_MODE        0   /* Data bus and Address bus are diffrent buses            */
#define FL_MUX_MODE         1   /* Data and Address buses are multiplexed on the same bus */
#define FL_LPC_MODE         2   /* Data and Address buses are both using the LPC bus      */
#define FL_ICP_MODE         3


/* Debugging flags */
#define DEBUG_ERASE_OPERATION_ENTER    0  /* Before start of an erase operation */
#define DEBUG_ERASE_OPERATION_EXIT     3  /* After end of erase operation       */
#define DEBUG_WRITE_OPERATION_ENTER    1  /* Before start of an write operation */
#define DEBUG_WRITE_OPERATION_EXIT     4  /* After end of write operation       */
#define DEBUG_READ_OPERATION           2  /* Before read operation              */
#define DEBUG_INIT_ENDED               5  /* Variables are initialized          */
#define DEBUG_EXIT_CALLED              6  /* Variables are not initialized      */
#define DEBUG_FORMAT_OPERATION_ENTER1  7  /* Before start format - 2 calls are  */
#define DEBUG_FORMAT_OPERATION_ENTER2  8  /* required 2 pass 2 parameters.      */
#define DEBUG_FORMAT_OPERATION_EXIT    9  /* After end format operation         */
#define DEBUG_UNFORMAT_OPERATION_ENTER 10 /* Before start unformat operation    */
#define DEBUG_UNFORMAT_OPERATION_EXIT  11 /* After end unformat operation       */
#define DEBUG_ERASEBD_OPERATION_ENTER  12 /* Before start ERASE BD operation    */
#define DEBUG_ERASEBD_OPERATION_EXIT   13 /* After end ERASE BD operation       */
#define DEBUG_IS_GOOD_BLOCK            255 /* Called by MTD to check block     */

/* prepareForPowerChanges routine flags */
#define FL_PREPARE_FOR_SUSPEND   2

/*************************************/
/* DMA type flags - FL_DMA_CONFIG    */
/*************************************/

/* Note: DMA_Params_S is defined in flsystyp.h */
#define DMA_OPEN_CHANNEL               0
#define DMA_CONFIG_TRANSACTION         1
#define DMA_FREE_CHANNEL               2
#define DMA_WAIT_FOR_TRANSACTION_END   3



/****************************/
/*   Special services API   */
/****************************/


/*** MTD Soecial services values   ***/
#define FL_DMA_WITHOUT_ECC              0x20
#define FL_DMA_WITH_ECC                 0

/* Flash array identification structure */
typedef struct tFlash FLFlash;                /* Forward definition */

/*=============================================================*/


/*=============================================================*/
/* from _flflash.h */

#define M512_SUBTYPE_G3                 0x00
#define M512_SUBTYPE_G3_LP              0x01

#define H1_SUBTYPE_TSB_512MB            0x00
#define H1_SUBTYPE_SAM_256MB            0x01
#define H1_SUBTYPE_H_256MB              0x02
#define H1_SUBTYPE_H_512MB              0x03
#define H1_SUBTYPE_H_1GB                0x04
#define H1_SUBTYPE_H_2GB                0x05

/* The following are flags for the protection set routine */
#define DO_NOT_COMMIT_PROTECTION 0 /* The new values will take affect only after reset  */
#define COMMIT_PROTECTION        1 /* The new values will take affect immediately       */
#define MTD_ON_DPS_ONLY          2 /* The new protection will be placed only on the DPS */
#define MTD_READ_KEY             4 /* Report the key that is being used                 */


struct tFlash {
  FLBoolean		wasIdentified;
  FlashType		type;
  FlashType		subType;
  FLByte		mediaType;
  FLDword		busAccessType;
  FLByte      if_cfg;
  FLByte      bBusType;
  FLWord      flags;
  void *    mtdVars;
  FLSocket * socket;
  NDOC2window win;
  void (*setPowerOnCallback)(FLFlash *);
  FLStatus (*flashRead)(FLFlash *);
  FLStatus (*setCallBack)(FLFlash *);
  FLStatus (*dismount)(FLFlash *);
  FLStatus (*prepareForPowerChanges) (FLFlash *,FLByte) ;
  FLStatus (*clearCallBack)(FLFlash *);
  FLStatus (*enterDeepPowerDownMode)(FLFlash *,FLWord state);

#ifndef FL_NO_USE_FUNC
  FLMemWindowSize FAR1* memWindowSize; /* Doc memory window size          */
  FLMemRead       FAR1* memRead;       /* Doc memory read routine         */
  FLMemWrite      FAR1* memWrite;      /* Doc memory write routine        */
  FLMemSet        FAR1* memSet;        /* Doc memory set routine          */
  FLMemRead8bit   FAR1* memRead8bit;   /* Doc memory 8 bit read routine   */
  FLMemWrite8bit  FAR1* memWrite8bit;  /* Doc memory 8 bit write routine  */
  FLMemRead16bit  FAR1* memRead16bit;  /* Doc memory 16 bit read routine  */
  FLMemWrite16bit FAR1* memWrite16bit; /* Doc memory 16 bit write routine */
  FLMemSetGetMode FAR1* memSetGetMode; /* Interleave change event -       */
                                       /* call back to plant new routines */
#endif /* FL_NO_USE_FUNC */
};

extern void docSocketInit(FLSocket * pVol);

/* Returns specific flash structure of the socket */

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
extern TFFS_DLL_API FLFlash * NAMING_CONVENTION flFlashOf(FLByte volNo);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/* See interface documentation of functions in flflash.c        */

extern FLStatus flIdentifyFlash(FLSocket *socket, FLFlash *flash);

extern FLByte    flHandleConversionTable[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
/*=============================================================*/


/*=============================================================*/
/*=== from nandefs.h */
    /* Flash IDs*/

#define KM29N16000_FLASH    0xec64
#define KM29N32000_FLASH    0xece5
#define KM29V64000_FLASH    0xece6
#define KM29V128000_FLASH   0xec73
#define KM29V256000_FLASH   0xec75
#define KM29V512000_FLASH   0xec76
#define KM29V1024000_FLASH  0xec79
#define K9F1G08U0M_FLASH    0xecc1
#define K9F2G08U0M_FLASH    0xecda
#define K9F4G08U0M_FLASH    0xecdc

#define NM29N16_FLASH       0x8f64
#define NM29N32_FLASH       0x8fe5
#define NM29N64_FLASH       0x8fe6
#define TC5816_FLASH        0x9864
#define TC5832_FLASH        0x98e5
#define TC5864_FLASH        0x98e6
#define TC58128_FLASH       0x9873
#define TC58256_FLASH       0x9875
#define TC58512_FLASH       0x9876
#define TC581024_FLASH      0x9877

#define TC58100FT           0x9879
#define TC58010FT           0x9879
#define KF2816U0C           0xEC53
#define KF2832U0C           0xEC55
#define TC58020FT           0x98DA

#define TC58NVG0S3AFT05     0x98F1
#define TC58NVG1S3AFT05     0x98DA
#define TC58NVG2D4BFT00     0x98DC
#define HY27UF162G2M        0xADCA
#define HY27UT084G2M        0xADDC


/*=============================================================*/

FLStatus _flInit(void);

#endif /*_DEFS_H*/


