/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/DocDriver/TrueFFS BD/src/docdrv.c-arc  $
 *
 *    Rev 1.2   Aug 10 2006 10:39:48   Polina.Marimont
 * reinit fix
 *
 *    Rev 1.1   Aug 10 2006 10:37:14   Polina.Marimont
 * bug fix - avoid initializing twice
 *
 *    Rev 1.0   Aug 08 2006 15:47:22   Polina.Marimont
 * Initial revision.
 */

#include "msys.h"
#include "msys_custom.h"


#include "flchkdef.h"
#include "flcommon.h"
#include "flstdcmp.h"
#include "blockdev.h"
#include "tffs_api.h"
#include "doch_api.h"
#include "bddefs.h"


#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

FLStatus bdSetBusy(Volume * pVol, FLBoolean state, FLByte  partition);

extern FLBoolean dochBdCallWasCalled;
#ifndef DOCH_USE_FUNC
FLFlash * DOCHFlash;
#endif /* DOCH_USE_FUNC */


bdCallType bdCall = bdCallTFFSToDOCH;
static FLBoolean fDocDriverInitDone = FALSE;



/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flInit */
/* Description	    : */
/* Return type		: TFFS_DLL_API FLStatus */
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flInit()
{
#if (!defined(DOCH_USE_FUNC)) && (!defined (FL_NO_USE_FUNC))
    FLStatus flStatus;
	FLDword dwBusConfig = flBusConfig[0];
#endif /*!DOCH_USE_FUNC && !FL_NO_USE_FUNC*/
	DOCH_Error status_HDOC = DOCH_OK;


	if( fDocDriverInitDone == TRUE )
		return flOK;

	_flInit();

	flSysfunInit();

    DBG_PRINT_FLOW(FLZONE_ABS, "Searching for H3 device... \r\n");

#ifndef DOCH_USE_FUNC
	/* Initialize DOCHFlash and redirect to regular MTD access layer */
	DOCHFlash = flFlashOf(0);
#ifndef FL_NO_USE_FUNC
	dwBusConfig |= FL_16BIT_DOC_ACCESS ;
	dwBusConfig |= FL_16BIT_FLASH_ACCESS ;
	dwBusConfig |= FL_BUS_HAS_16BIT_ACCESS;
    flStatus = setBusTypeOfFlash(DOCHFlash,dwBusConfig);
	if(flStatus != flOK)
		return flStatus;
#endif /* FL_NO_USE_FUNC */
#endif /* DOCH_USE_FUNC */

	status_HDOC = DochSDKInit();
	if(status_HDOC == DOCH_OK) /*DOCH Device*/
	{
		DBG_PRINT_FLOW(FLZONE_ABS, "H3 Device found !!! \r\n\n");
		bdCall = bdCallTFFSToDOCH;
#ifdef FL_DMA_INIT
		{
			IOreq myIoreq;
			FLByte bDmaInit = FL_DMA_INIT(0);
			if( bDmaInit == FL_DMA_HW_ENABLED ) /*if DMA enabled by default -> set this to SA SDK*/
			{
				tffsset(&myIoreq, 0, sizeof(myIoreq));
				myIoreq.irFlags = DOCH_DMA_ENABLE;
				myIoreq.irLength = TRUE;
				status_HDOC = flDOCHConfigHW(&myIoreq);
				if( status_HDOC!=DOCH_OK )
				{
					DBG_PRINT_FLOW_PRM(FLZONE_ABS, (FLTXT("Fail to enable DMA with status %d \r\n"),status_HDOC));
				}
			}
		}
#endif /*FL_DMA_INIT*/
		if( status_HDOC==DOCH_OK )
			fDocDriverInitDone = TRUE;

		return (status_HDOC==DOCH_OK)?flOK:((status_HDOC==DOCH_DiskNotFound)?flAdapterNotFound:flGeneralFailure);
    }

	DBG_PRINT_FLOW(FLZONE_ABS, "\r\n*** Exiting flInit() ***\r\n\n\n");

	return flAdapterNotFound;
}/* flInit() */

#ifdef FL_EXIT

/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flExit*/
/* Description	    : */
/* Return type		: TFFS_DLL_API void */
/***********************************************************************************/
TFFS_DLL_API void NAMING_CONVENTION flExit()
{
	tffsApiExit();
	dochBdCallWasCalled = FALSE;
	fDocDriverInitDone = FALSE;
}/*flExit()*/
#endif /*FL_EXIT*/

#ifdef FL_ENVIRONMENT_VARS

/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flSetEnvVolume */
/* Description	    :  */
/* Return type		: TFFS_DLL_API FLStatus  */
/* Argument         : FLEnvVars variableType */
/* Argument         : FLByte  socket */
/* Argument         : FLByte  volume */
/* Argument         : FLDword value */
/* Argument         : FLDword FAR2 *prevValue */
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvVolume(FLEnvVars variableType, FLByte  socket, FLByte  volume,
													    FLDword value, FLDword FAR2 *prevValue)
{
    IOreq ioreq;

    ioreq.irHandle = socket + (volume << 4);
    /*For utilities which uses env vars on legacy devices and not needed for H3*/
    if ((variableType == FL_DEBUG_MODES) ||
        (variableType == FL_SUSPEND_MODE) ||
        (variableType == FL_DIMAGE_CFG))
        return flOK;

    if (variableType == FL_ENV_ATA_DEBUG)
        ioreq.irFlags = DOCH_ENV_ATA_DEBUG;
    else
	{
		switch(variableType)
		{
		case FL_VERIFY_WRITE_BDTL:
		case FL_VERIFY_WRITE_BINARY:
		case FL_VERIFY_WRITE_OTHER:
			ioreq.irFlags = DOCH_ENV_VERIFY_WRITE;
			break;
#if (defined(FL_VERIFY_WRITE) || !defined(FL_NO_USE_FUNC) | defined(FL_BD_AUTO_DPD_MODE))
		case FL_SET_AUTO_DPD_MODE:
#ifndef DOCH_AUTO_DPD_BY_HOST
		case FL_SET_ACTIVE_DPD_MODE:
		case FL_SET_INACTIVE_DPD_MODE:
		case FL_SET_TIMEOUT_DPD:
#endif /*DOCH_AUTO_DPD_BY_HOST*/
			return tffsApiSetAutoDpd(variableType, (FLSDword)socket, value, prevValue);
#endif /*(defined(FL_VERIFY_WRITE) || !defined(FL_NO_USE_FUNC) | defined (FL_BD_AUTO_DPD_MODE))*/
		default:
			ioreq.irFlags = 0;
		}/*switch*/
	}
    ioreq.irLength = value;
	if (flDOCHSetEnvVar(&ioreq) == DOCH_OK)
        return flOK;
    return flFeatureNotSupported;
}/*flSetEnvVolume()*/


/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flSetEnvSocket*/
/* Description	    : */
/* Return type		: TFFS_DLL_API FLStatus */
/* Argument         : FLEnvVars variableType*/
/* Argument         : FLByte  socket*/
/* Argument         : LDword value*/
/* Argument         : FLDword FAR2 *prevValue*/
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvSocket(FLEnvVars variableType, FLByte  socket,
													   FLDword value, FLDword FAR2 *prevValue)
{
	return flSetEnvVolume(variableType, socket, 0, value, prevValue);
}/*flSetEnvSocket()*/


/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flSetEnvAll */
/* Description	    : */
/* Return type		: TFFS_DLL_API FLStatus */
/* Argument         : FLEnvVars variableType */
/* Argument         : FLDword value */
/* Argument         : FLDword FAR2 *prevValue */
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetEnvAll( FLEnvVars variableType,FLDword value,
													 FLDword FAR2 *prevValue)
{
    return flSetEnvVolume(variableType, 0, 0, value, prevValue);
}/*flSetEnvAll*/
#endif /*FL_ENVIRONMENT_VARS*/

#ifndef FL_NO_USE_FUNC


/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flGetDocBusRoutine*/
/* Description	    : */
/* Return type		: TFFS_DLL_API FLStatus */
/* Argument         : FLByte  socket */
/* Argument         : FLAccessStruct FAR1 * structPtr */
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flGetDocBusRoutine(FLByte  socket, FLAccessStruct FAR1 * structPtr)
{
	FLFlash* flash;

	/* Arg sanity check */
#ifndef FL_SKIP_ARGS_CHECK
	if (socket >= FL_SOCKETS)
	{
		DBG_PRINT_ERR(FLZONE_BLKDEV,"ERROR - Change FL_SOCKETS definition in flcustom.h to support that many sockets.\r\n");
		return flFeatureNotSupported;
	}
	if(structPtr == NULL)
	{
		DBG_PRINT_ERR(FLZONE_BLKDEV,"ERROR - structPtr argument is NULL.\r\n");
		return flBadParameter;
	}
#endif /* FL_SKIP_ARGS_CHECK */

	/* Make sure global variables are initialized to their default values */
	flInitGlobalVars();

	flash = flFlashOf(socket);

	structPtr->memWindowSize = flash->memWindowSize;
	structPtr->memRead       = flash->memRead;
	structPtr->memWrite      = flash->memWrite;
	structPtr->memSet        = flash->memSet;
	structPtr->memRead8bit   = flash->memRead8bit;
	structPtr->memRead16bit  = flash->memRead16bit;
	structPtr->memWrite8bit  = flash->memWrite8bit;
	structPtr->memWrite16bit = flash->memWrite16bit;
	structPtr->memSetGetMode = flash->memSetGetMode;
	structPtr->access        = flBusConfig[socket];

	return flOK;
}/*flGetDocBusRoutine()*/


/***********************************************************************************/
/* Function name	: NAMING_CONVENTION flSetDocBusRoutine*/
/* Description	    : */
/* Return type		: TFFS_DLL_API FLStatus */
/* Argument         : FLByte  socket*/
/* Argument         : FLAccessStruct FAR1 * structPtr*/
/***********************************************************************************/
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetDocBusRoutine(FLByte  socket,FLAccessStruct FAR1 * structPtr)
{
   FLFlash* flash;

   /* Arg sanity check */
#ifndef FL_SKIP_ARGS_CHECK
   if (socket >= FL_SOCKETS)
   {
      DBG_PRINT_ERR(FLZONE_BLKDEV,"ERROR - Change FL_SOCKETS definition in flcustom.h to support that many sockets.\r\n");
      return flFeatureNotSupported;
   }
   if(structPtr == NULL)
   {
      DBG_PRINT_ERR(FLZONE_BLKDEV,"ERROR - structPtr argument is NULL.\r\n");
      return flBadParameter;
   }
#endif /* FL_SKIP_ARGS_CHECK */

   /* Make sure global variables are initialized to their default values */
   flInitGlobalVars();

   flash = flFlashOf(socket);

   flash->memWindowSize = structPtr->memWindowSize;
   flash->memRead       = structPtr->memRead;
   flash->memWrite      = structPtr->memWrite;
   flash->memSet        = structPtr->memSet;
   flash->memRead8bit   = structPtr->memRead8bit;
   flash->memRead16bit  = structPtr->memRead16bit;
   flash->memWrite8bit  = structPtr->memWrite8bit;
   flash->memWrite16bit = structPtr->memWrite16bit;
   flash->memSetGetMode = structPtr->memSetGetMode;
   flBusConfig[socket]  = FL_ACCESS_USER_DEFINED;
   return flOK;
}/*flSetDocBusRoutine*/

#endif /*FL_NO_USE_FUNC*/

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* ----------------------------------------------------------------------------------- */


