/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/***********************************************************************************/
/*																				   */
/*	Header file for doch_api module												   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/doch_api.h-arc  $
 *
 *    Rev 1.30   Aug 09 2006 17:26:52   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 */

#ifndef _DOCH_API
#define _DOCH_API

#include "flcommon.h"
#include "flchkdef.h"
#include "_dochapi.h"
#include "blockdev.h"


/************************/
/*	Exported routines	*/
/************************/

#ifdef __cplusplus
extern "C" {
#endif

extern FLBoolean gDochIrqEnabled[];

DOCH_Error bdCallDOCH(int functionNo, IOreq *ioreq);
extern DOCH_Error doch_init_socket (int socketNo, DOCH_InitSocket);
extern DOCH_Error  doch_release_socket( int socketNo );

extern FLDword gDochAccessNanosec;


/*----------------------------------------------------------------------*/
/*                   f l B u i l d G e o m e t r y                      */
/*                                                                      */
/* Get C/H/S information of the disk according to number of sectors.    */
/*                                                                      */
/* Parameters:                                                          */
/*  capacity    : Number of Sectors in Volume                           */
/*  cylinders   : Pointer to Number of Cylinders                        */
/*  heads       : Pointer to Number of Heads                            */
/*  sectors     : Pointer to Number of Sectors per Track                */
/*  oldFormat   : True for one sector per culoster                      */
/*  wIrHandle   : Handle of the disk partition to check                 */
/*                                                                      */
/*----------------------------------------------------------------------*/
TFFS_DLL_API void NAMING_CONVENTION flBuildGeometry(FLDword capacity, FLDword FAR2 *cylinders,
         FLDword FAR2 *heads, FLDword FAR2 *sectors, FLBoolean oldFormat, FLWord wIrHandle);

/* Management routines */
DOCH_Error flDOCHAtaReset(FLByte socketNum);
DOCH_Error DochSDKInit(void);
void DochSDKExit(void);
DOCH_Error DochRegisterSocket(FLDword dwAddress);

/* User define component registration routine */
DOCH_Error flRegisterDochComponents(void);
/* Access layer registration routines */
DOCH_Error hal_init_nor (FLSNative  socketNo);
DOCH_Error hal_init_spi (FLSNative  socketNo);
DOCH_Error hal_init_sim (FLSNative  socketNo);
DOCH_Error hal_init_nor_noFunc (FLSNative  socketNo);
DOCH_Error hal_init_spi_noFunc (FLSNative  socketNo);
DOCH_Error hal_init_sim_noFunc (FLSNative  socketNo);
DOCH_Error hal_init_user_routines(FLSNative  socketNo, DOCH_BusAccess_routines accessPointerStruct);

void DOCH_SetBits(FLDword* var, FLDword mask, FLByte offset, FLDword val);

#ifdef __cplusplus
}
#endif

#endif /*_DOCH_API*/

