/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/doch_ata.c-arc  $
 *
 *    Rev 1.51   Aug 10 2006 10:23:02   Polina.Marimont
 * bug fix - identifying in 128K window failure
 *
 *    Rev 1.50   Aug 09 2006 17:26:52   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 */

/*
 * includes
 */
#include "msys.h"
#include "msys_custom.h"
#include "misc.h"

#include "flsystem.h"
#include "flchkdef.h"
#include "flcustom.h"
#include "flsystyp.h"
#include "flcommon.h"
#include "flsysfun.h"
#include "doch_func.h"
#include "doch_ata.h"
//#include "hib.h"

#define DOCH_CHECK_CHIP_ID  /* Enable CHIP ID checking. Will not work if A0 is connected to '1'*/

#ifdef FL_MIGRATION_VERSION
  #include "docsys.h"
#endif /*FL_MIGRATION_VERSION*/

//FLWord  gMemWindowType          = 0;
//FLDword gDochMemWinSize         = 0;
//FLWord  gHibCoreAddress         = 0;
//FLWord  gHibContRegAreaOffset   = 0;
//FLWord  gHibDataPortAreaOffset  = 0;
//FLWord  gHibConfigRegAreaOffset = 0;

#ifdef CHECK_POWER_ON_EVERY_COMMAND
  FLBoolean gDeviceTurnedOff = FALSE;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/

/*
 * types
 */

/*
 * Global Variables
 */

#ifdef __cplusplus
extern "C" {
#endif

FLDword gAccessLayerType    = 0;
FLDword gATANoTimeout       = 0;
FLDword gUseShortWaitOnBusy = 0;
FLDword gDochAccessNanosec  = 0;

#ifdef DOCH_DMA_CONFIG
  FLDword gDMAChannelOpen = 0;
#endif /*DOCH_DMA_CONFIG*/

DOCH_DpdSettings gDpdSettings;

/* all DOCH sockets */
DOCH_Socket sockets [DOCH_MAX_SOCKETS];

#ifdef __cplusplus
}
#endif


/*
 * static vars
 */
static DOCH_DeviceUserAttr  devUserAttr;
static DOCH_ConfigRegsValue configRegValue;
static DOCH_ConfigRegsSet   configRegValueSet;
static FLByte               ataDBG[DOCH_SECTOR_SIZE];
static DOCH_DeviceInfo      gDiskOnChipDeviceInfo;


#ifdef __cplusplus
  extern "C" {
#endif

/*
 * static routines
 */
static void	        clear_socket( DOCH_Socket *pdev);
/*static void       doch_pause(DOCH_Socket *pdev, FLSNative  devNum, FLDword  nanosecs);*/
static DOCH_Error   ready( DOCH_Socket *pdev, FLSNative  devNum, DOCH_Reg reg, FLByte mask, FLByte on_bits, FLDword millisec);
static DOCH_Error   doch_find_base_address( FLSNative socketNo, FLDword Address);

#ifdef DOCH_CHECK_CHIP_ID
  static DOCH_Error   doch_check_chipID(FLSNative socketNo);
#endif /*DOCH_CHECK_CHIP_ID*/

/*
 * Internal routines
 */
DOCH_Error io_input(DOCH_Socket *pdev, FLSNative  devNum, DOCH_Registers* regs, void *buf, FLNative secNum);
DOCH_Error io_output(DOCH_Socket *pdev, FLSNative  devNum, DOCH_Registers* regs, void *buf, FLNative secNum);
DOCH_Error io_ctrl(DOCH_Socket *pdev, FLSNative  devNum, DOCH_Registers* regs);

/*
 * externals
 */

DOCH_Error get_out_registers(DOCH_Socket* pdev, FLSNative  devNum, DOCH_Registers* out_regs);

extern DOCH_Error flUnRegisterDochParams(FLSNative socketNo);

extern FLDword gSdkDOCAddressObtained;
extern FLDword gConfigHWDefaults[DOCH_NUM_OF_DCONFIGHW_ITEMS];

extern FLDword gDochAtaDebug;

extern FLDword gSdkInitDone;


#ifdef DOCH_FORCE_USING_8KB
/******************************************************************************
 *                                                                            *
 *                s e t M e m W i n d o w S i z e  8 K B                      *
 *                                                                            *
 *  Set device memory window size to 8KB									  *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                : device to act on                                *
 *                                                                            *
 ******************************************************************************/
static DOCH_Error dochSetMemWindowSize8KB( DOCH_Socket *pdev )
{
	register int i = 0;

	/*Step 0 - In case of PCI/PortaDoc EVB, set window offset to "0"*/
	/*==============================================================*/
	if(gAccessLayerType == DOCH_AL_NOR)
	{
		DOCH_SET_WINDOW_OFFSET(TRUE, pdev->bRegBase);
	}

	/* Exit virtual RAM mode */
	DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_CHIPID2_REG, 0);

    /*Step 1 - Enable paged registers
            (Write 0x71 into Paged RAM Command register)*/
    /*==================================================*/
    DOCHWRITE_CTRL_REG (pdev->bRegBase, DOCH_PAGED_RAM_CMD_REG, 0x71);

	/*Step 2 - Set window to 8KB mode with pull downs.
			(Write 0x8 into Paged RAM COTP Select register)*/
	/*======================================================*/
	DOCHWRITE_CTRL_REG (pdev->bRegBase, DOCH_PAGED_RAM_COTP_SELECT_REG, 0x8);

	/*Step 3 - Poll Paged RAM busy*/
	/*============================*/
    /* Perform a fixed delay before starting polling */
    for (i=0; i<DOCH_READ_PAGED_RAM_DELAY; i++)
		DOCHREAD_CTRL_REG(pdev->bRegBase, 0x400);

	/* Loop until 2 consecutive reads produce the same value or until timeout */
    for (i=0; i<DOCH_PAGED_RAM_TIMEOUT; i++)
    {
		FLByte bReadX,bReadY ;

		bReadX = (FLByte)DOCHREAD_CTRL_REG(pdev->bRegBase, 0x400);
		bReadY = (FLByte)DOCHREAD_CTRL_REG(pdev->bRegBase, 0x400);

		if ((bReadX & 1)==(bReadY & 1))
			break ;

	}
    if (i == DOCH_PAGED_RAM_TIMEOUT)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "\r\nSetting Memory Window size timed out! \r\n");
		return DOCH_TimedOut ;
	}

	DBG_PRINT_ERR(FLZONE_ATA, "\r\nMemory window set to 8KB \r\n");

	return DOCH_OK;

}
#endif /*DOCH_FORCE_USING_8KB*/

/******************************************************************************
 *                                                                            *
 *                        c l e a r _ s o c k e t                             *
 *                                                                            *
 *  Clears socket structure                                                   *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                : device to act on                                *
 *                                                                            *
 ******************************************************************************/
static void clear_socket( DOCH_Socket *pdev )
{

#if((DOCH_MULTI_DISABLED == 0) && (DOCH_DATA_MODE_SINGLE == 0) && (NULL ==0) )
    // reduce code size ...
    memset( (void *)pdev, 0, sizeof(DOCH_Socket));

#else

	register FLSNative i = 0;

	pdev->wSocketNo				= 0;
	pdev->wNumOfDevices			= 0;
	pdev->nTotalCapacity		= 0;
	pdev->wTotalNumOfPartitions	= 0;
	pdev->wLastPartitionSpanned	= 0;
	pdev->bUseDMA				= 0;
	pdev->bUseInterrupt			= 0;
	pdev->bUseBurst				= 0;
	pdev->bAtaDevNum			= 0;
	pdev->bRegBase				= NULL;

	for(i = 0; i<ATA_MAX_NUM_OF_DEVICES; i++)
	{
		pdev->device[i].wNumOfPartitions		= 0;

		/* we assume that multiple sector read/writes aren't supported */
		pdev->device[i].dwMulti_read  = DOCH_MULTI_DISABLED;
		pdev->device[i].dwMulti_write = DOCH_MULTI_DISABLED;

		pdev->device[i].dataTransferMode = DOCH_DATA_MODE_SINGLE;
	}

#endif

}

/******************************************************************************
 *                                                                            *
 *                        d o c h _ p a u s e                                 *
 *                                                                            *
 *  Pause for specified number of nanoseconds.                                *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : pointer to DOCH device                         *
 *      nanosecs             : nanoseconds to busy wait                       *
 *                                                                            *
 ******************************************************************************/
/*static
void doch_pause( DOCH_Socket   * pdev,
				 FLSNative 		 devNum,
				 FLDword		 nanosecs )
{
    register FLDword  cycles;

    for (cycles = (nanosecs / DOCH_ACCESS_NANOSEC); cycles > 0; cycles--)
    {
        DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_ALT_STATUS_REG);
    }
}
*/

#ifdef CHECK_POWER_ON_EVERY_COMMAND
/******************************************************************************
 *                                                                            *
 *                  d o c h C h e c k P F S y m p t o m		                  *
 *                                                                            *
 *  Wait until particular bit pattern appears in specified DOCH register      *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to act on                               *
 *      reg                  : DOCH register offset from base address         *
 *      mask                 : bits we are interested in                      *
 *      on_bits              : bits we are waiting to become '1'              *
 *      millisec             : timeout value in milliseconds                  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error dochCheckPFSymptom(FLSNative socketNo, FLByte devNum, FLBoolean beforeCommand /* Used for debug prints */)
{
	DOCH_Error rc;
	DOCH_Socket* pdev = NULL;
	DOCH_Registers in_regs;
	FLByte resetOccured = 0;

	if(!gSdkInitDone)
		return DOCH_OK;

    /* Sanity Check*/
	/*=============*/
	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

	/*Set Device Head register to appropriate device*/
	DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_DRIVE_HEAD_REG, pdev->bAtaDevNum);

	#ifdef DOCH_CHECK_CHIP_ID
	/*Check ChipID to detect power failure ("Device Off") */
	if(doch_check_chipID(socketNo) == DOCH_OK)
	{
		return DOCH_OK;
	}
	#endif /*DOCH_CHECK_CHIP_ID*/

	/* Check reset status
	   Note: We DO NOT call DOCHGetResetStatus() to avoid recursion */

	/*Update ATA register values*/
	/*--------------------------*/
	in_regs.bFeaturesError = DOCH_GET_RESET_STATUS;
	in_regs.bSectorCount = 0;
	in_regs.bSectorNumber = 0;
	in_regs.bCylLow = 0;
	in_regs.bCylHigh = 0;
	in_regs.bDriveHead = (pdev->bAtaDevNum * DOCH_DEVICE);
	in_regs.bCommandStatus = DOCH_VSCMD_EXT_DEVICE_CTRL;

	gUseShortWaitOnBusy = DOCH_LONG_IDENTIFY_TIMEOUT;
	rc = io_ctrl (pdev, devNum, &in_regs);
	gUseShortWaitOnBusy = 0;

	resetOccured = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_SECTOR_CNT_REG);

	if(rc != DOCH_OK)
	{
		if(beforeCommand)
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): DOCHGetResetStatus FAILED (Before Command)\r\n");
		else
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): DOCHGetResetStatus FAILED (After Command)\r\n");

		gDeviceTurnedOff = TRUE;
		return DOCH_DeviceTurnedOff;
	}
	else if(resetOccured)
	{
		if(beforeCommand)
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): Suspend mode detected (Before Command)\r\n");
		else
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): Suspend mode detected (After Command)\r\n");

		gDeviceTurnedOff = TRUE;
		return DOCH_DeviceTurnedOff;
	}
	#ifdef DOCH_CHECK_CHIP_ID
	else
	{
		if(beforeCommand)
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): Suspend mode not detected but failed to read chip id (Before Command)\r\n");
		else
			DBG_PRINT_ERR(FLZONE_ATA, "\r\ndoch_command(): Suspend mode not detected but failed to read chip id (After Command)\r\n");

		gDeviceTurnedOff = TRUE;
		return DOCH_DeviceTurnedOff;
	}
	#else /*DOCH_CHECK_CHIP_ID*/
	return DOCH_OK;
	#endif /*DOCH_CHECK_CHIP_ID*/
}
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/

/******************************************************************************
 *                                                                            *
 *                             r e a d y		                              *
 *                                                                            *
 *  Wait until particular bit pattern appears in specified DOCH register      *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to act on                               *
 *      reg                  : DOCH register offset from base address         *
 *      mask                 : bits we are interested in                      *
 *      on_bits              : bits we are waiting to become '1'              *
 *      millisec             : timeout value in milliseconds                  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
static
DOCH_Error ready ( DOCH_Socket   * pdev,
				   FLSNative 	   devNum,
                   DOCH_Reg        reg,
                   FLByte		   mask,
                   FLByte		   on_bits,
                   FLDword		   millisec )
{
	DOCH_Error error = DOCH_OK;
    register FLDword tries;
	FLByte status = 0;

	FLDword use_interrupt =
		( ((pdev->device[devNum].flags & DOCH_FLAGSB_USE_INTERRUPT) == DOCH_FLAGSB_USE_INTERRUPT) &&
		  (pdev->bUseInterrupt) );

	/*Protect against access time set to 0*/
	if(gDochAccessNanosec == 0)
		return DOCH_BadParameter;
	tries = millisec * (1000000UL / gDochAccessNanosec);

	/*If proper environment variable was set - set timeout to max*/
	if(gATANoTimeout == DOCH_GLOBAL_BOOL_PATTERN)
	{
		tries = DOCH_ATA_MAX_TIMEOUT;
	}

    /*If gUseShortWaitOnBusy is set, use its value*/
    if(gUseShortWaitOnBusy != 0)
    {
        tries = gUseShortWaitOnBusy;
    }

	/*Protect tries from being set to "0"
	  (in conjunction with tries-- might cause a very long delay...)*/
	if(tries == 0)
		tries = 1;

    /*Wait for BUSY bit to clear*/
    while (tries-- > 0)
    {
		if ((millisec >= DOCH_LONG_WAIT) && (use_interrupt))
		{
			/* wait for device's interrupt */
			DOCH_SLEEP(pdev->wSocketNo, devNum, DOCH_DEFAULT_SLEEP_PERIOD);
		}

		status = DOCHREAD_ATA_REG(pdev->bRegBase, reg);
        if ((status & mask) == on_bits)
        {
            /* read status once again, just to be sure .. */
            /*if ((DOCHREAD_ATA_REG(pdev->device[devNum].bRegBase, reg) & mask) == on_bits)*/
            return DOCH_OK;
        }
		/*If an error was detected - return the error code*/
		else if( ((status & DOCH_ERROR) == DOCH_ERROR) &&
				 ((status & DOCH_BUSY)  != DOCH_BUSY))
		{
			error = (DOCH_Error)DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_ERROR_REG);

			/*Special Case - Device returned "0" in the error register.
			 This DOES NOT mean that everything is OK, since the error bit was raised.
			 Hence, we will return "DOCH_ATA_ERROR_ABORT"*/
			if(error == DOCH_OK)
				error = DOCH_ATA_ERROR_ABORT;

			if(pdev->bUseInterrupt && (millisec == DOCH_SHORT_WAIT))
				DOCH_UNSERVICED_INTERRUPT(pdev->wSocketNo, devNum);

			DBG_PRINT_ERR(FLZONE_ATA, "ready(): ATA Error: ");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x "), error));
			DBG_PRINT_ERR(FLZONE_ATA, "\r\n");

			return error;
		}
    }

	DBG_PRINT_ERR(FLZONE_ATA, "\r\nready(): Timed Out\r\n");

	/* If timeout had occurred, and not whilst looking for a device,
	   reset ATA and poll for ready */
	if(gUseShortWaitOnBusy == 0)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "ready(): Resetting device... ");
		error = doch_reset (pdev->wSocketNo, devNum);
		if(error == DOCH_OK)
			DBG_PRINT_ERR(FLZONE_ATA, "Passed! \r\n");
		else
		{
			DBG_PRINT_ERR(FLZONE_ATA, "Failed! \r\n");
			return error;
		}
	}

    return DOCH_TimedOut;
}

/******************************************************************************
 *                                                                            *
 *                             i o _ i n p u t                                *
 *                                                                            *
 *  Read sectors from DOCH device.                                            *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to act on                               *
 *		regs				 : DOCH_Registers								  *
 *      buf                  : user buffer to read to                         *
 *		secNum				 : # of sectors to read							  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error io_input  ( DOCH_Socket     *pdev,
					   FLSNative        devNum,
					   DOCH_Registers  *regs,
                       void            *buf,
					   FLNative         secNum)
{
    FLNative    sectors_to_read;
	FLNative	secPerformed;
	FLNative	offset = 0;
    DOCH_Error  rc;
	FLSNative 	status;
	FLByte		multCount = 0;
	FLByte		multSecToRead = 0;

	/* Calculate how many sectors are to be read */
	/* Note: "0" - 256 Sectors to read */
	sectors_to_read = (secNum ? secNum : 256);

	/* First we write the device head register to ensure we are communicating
	   with the right device...*/
	DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_DRIVE_HEAD_REG, regs->bDriveHead);

	/*Wait for busy bit to clear*/
	status = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
	if((status & DOCH_BUSY) == DOCH_BUSY)
	{
	    if ((rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, DOCH_BUSY, 0, DOCH_SHORT_WAIT)) != DOCH_OK)
	    {
	        DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready (before command) \r\n");
	        DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
	        return rc;
	    }
	}

	/*Write ATA registers, without ATA command register*/
	/*Note: if DMA was requested, registers will be written inside DMA context*/
	if(!pdev->bUseDMA)
	{
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_CNT_REG,    regs->bSectorCount);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_NO_REG,     regs->bSectorNumber);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_LOW_REG,  regs->bCylLow);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_HIGH_REG, regs->bCylHigh);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_FEATURES_REG,	   regs->bFeaturesError);
	}

/*BURST transfer was requested*/
#ifdef DOCH_USE_BURST_MODE_READ
	if((pdev->bUseBurst) && (!pdev->bUseDMA))
	{
	   FLByte drqSize = 0;
	   FLByte burstSizeInBytes;
	   FLByte i;

		if(pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_SINGLE)
		{
			drqSize = 1;
		}
		else if(pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_MULT)
		{
			drqSize = (FLByte)pdev->device[devNum].dwMulti_Current;
		}

		switch(DOCH_BURST_LENGTH)
		{
		case DOCH_BURST_LEN_4_CYC:
			burstSizeInBytes = 8;
		break;

		case DOCH_BURST_LEN_8_CYC:
			burstSizeInBytes = 16;
		break;

		case DOCH_BURST_LEN_16_CYC:
			burstSizeInBytes = 32;
		break;

		case DOCH_BURST_LEN_32_CYC:
			burstSizeInBytes = 64;
		break;

		default:
			return DOCH_BadParameter;
		}


	   /*Set DOCH BURST READ Control Register*/
       DOCHWRITE_CTRL_REG(pdev->bRegBase, HIB_BURST_READ_MODE_CTRL_REG,
                            (DOCH_BURST_ENABLE | DOCH_BURST_HOLD | DOCH_BURST_LENGTH | (DOCH_BURST_LATENCY<<8) | (DOCH_BURST_WAIT_STATE<<4)));

		/*Enter BURST Mode*/
		DOCH_HOST_ENTER_READ_BURST_MODE

	   	/*Initiate ATA Command*/
       	DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
        Delay_us(10);   // this delay seems to ensure reliable results...

		for(i=0; i<sectors_to_read; i += drqSize)
		{

	  	    /* Check DRQ ready and not BSY before data xfer */
/*			(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
														DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
			if(rc != DOCH_OK)
			{
				DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready (before BURST) \r\n");
				DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
				return rc;
			}
*/

	        if(i == 0)
			{
				FLDword tempBuf[4];
				FLWord temp;
				volatile FLWord* vPtr = (volatile FLWord*)addToFarPointer(pdev->bRegBase, (DOCH_ALT_STATUS_REG<<1) + DOCH_CONT_REG_AREA);

				do
				{
					tffscpy(tempBuf, (FLByte*)vPtr, burstSizeInBytes);
					/*OMAP1610_Read512Bytes_SW_DMA_BURST((FLByte*)pdev->bRegBase,
														((DOCH_ALT_STATUS_REG<<1) + DOCH_CONT_REG_AREA),
														tempBuf,
														burstSizeInBytes);*/
					temp = (tempBuf[3] >> 16);
				}
				while((temp & (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR)) !=
					  (DOCH_READY | DOCH_DRQ));
			}

			/*Perform Read using burst*/
			DOCHREAD_BURST((FLByte*)pdev->bRegBase,
							DOCH_DATA_PORT_AREA_OFFSET,
							(FLByte*)buf + (i<<DOCH_SECTOR_SIZE_BITS),
							drqSize);
		}

		/*Exit BURST Mode*/
		DOCH_HOST_EXIT_READ_BURST_MODE

	   /*Set DOCH BURST READ Control Register*/
		DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_BURST_READ_MODE_CTRL_REG , DOCH_BURST_DISABLE);
	}
	else
#endif /*DOCH_USE_BURST_MODE_READ*/

#ifdef DOCH_DMA_CONFIG
 	/*DMA transfer was requested*/
	if(pdev->bUseDMA)
	{
		DMA_Params_S dmaParams;
		FLDword dmaRemainderSectors, dmaBlocks;
		FLDword dmaFrameSize;
		FLWord wDmaRegValue = DOCHREAD_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG);

		if(pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_SINGLE)
		{
			dmaRemainderSectors = 0;
			dmaFrameSize		= 1;
			dmaBlocks			= sectors_to_read;
		}
		else if (pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_MULT)
		{
			dmaRemainderSectors = (sectors_to_read % pdev->device[devNum].dwMulti_Current);

			/*Set initial parameters (will be altered afterwards to transfer "remainder" sectors*/
			dmaBlocks		    = (sectors_to_read / pdev->device[devNum].dwMulti_Current);
			dmaFrameSize		= pdev->device[devNum].dwMulti_Current;
		}
		else
		{
			DBG_PRINT_ERR(FLZONE_ATA, "io_input(): DMA Transfer Mode ");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x "), pdev->device[devNum].dataTransferMode));
			DBG_PRINT_ERR(FLZONE_ATA, "not supported\r\n");

			return DOCH_FeatureNotSupported;
		}	/* End of if/else on pdev->device[devNum].dataTransferMode */

dochIoInputDmaSequence:
		if(dmaBlocks > 0)
		{
			/*Set up the DMA transfer - Platfrom*/
			dmaParams.bOpType			  = DOCH_DMA_CONFIG_TRANSACTION_DEVICE_TO_HOST;

			dmaParams.bDiskOnChip_BasePtr = (FLByte*)pdev->bRegBase;
			dmaParams.wDiskOnChip_Offset  = (FLWord)DOCH_DATA_PORT_AREA;
			dmaParams.bDestAddrPtr		  = (FLByte*)buf;

			dmaParams.wFrameSize		  = (FLWord)(dmaFrameSize*DOCH_SECTOR_SIZE);
			dmaParams.wFramesInBlock	  = (FLWord)(dmaBlocks);

			dmaParams.wFramesXferred	  = 0;

			DOCH_DMA_CONFIG(&dmaParams);
			if(dmaParams.fDmaStatus != 0)
			{
				DBG_PRINT_ERR(FLZONE_API, "io_input(): DOCH_DMA_CONFIG_TRANSACTION_DEVICE_TO_HOST Failed\r\n");
				return DOCH_GeneralFailure;
			}

    #ifdef DOCH_USE_BURST_MODE_READ
			if(pdev->bUseBurst)
			{
			    /*Set DOCH BURST READ Control Register*/
				DOCHWRITE_CTRL_REG (pdev->bRegBase,
									HIB_BURST_READ_MODE_CTRL_REG,
									(DOCH_BURST_ENABLE | DOCH_BURST_HOLD | DOCH_BURST_LENGTH | DOCH_BURST_LATENCY | DOCH_BURST_WAIT_STATE) );

				/*Set up the DMA transfer - Device*/
				wDmaRegValue &= ~(DOCH_DMA_REQ_EDGE);
			}
    #endif /*DOCH_USE_BURST_MODE_READ*/

			/*Set up the DMA transfer - Device*/
			DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG, (wDmaRegValue | DOCH_DMA_REQ_ENABLE));

			/*Write ATA registers*/
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_CNT_REG,    regs->bSectorCount);
			DOCHWRITE_ATA_REG (pdev->bRegBase,*/ DOCH_SECTOR_NO_REG,     regs->bSectorNumber);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_LOW_REG,  regs->bCylLow);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_HIGH_REG, regs->bCylHigh);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_FEATURES_REG,	   regs->bFeaturesError);

			/*Write ATA command*/
			/*This will also start DMA transfer*/
	        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
            Delay_us(10);   // this delay seems to ensure reliable results...

	#ifdef DOCH_USE_BURST_MODE_READ
			if(pdev->bUseBurst)
			{
				/*Enter BURST Mode*/
				DOCH_HOST_ENTER_READ_BURST_MODE
			}
	#endif /*DOCH_USE_BURST_MODE_READ*/

			/*Wait for DMA transfer to complete*/
			dmaParams.bOpType = DOCH_DMA_WAIT_FOR_READ_TRANSACTION_END;
			DOCH_DMA_CONFIG(&dmaParams);

	#ifdef DOCH_USE_BURST_MODE_READ
			if(pdev->bUseBurst)
			{
				/*Exit BURST Mode*/
				DOCH_HOST_EXIT_READ_BURST_MODE

			   /*Set DOCH BURST READ Control Register*/
				DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_BURST_READ_MODE_CTRL_REG , DOCH_BURST_DISABLE);
			}
	#endif /*DOCH_USE_BURST_MODE_READ*/

			/*Disable DMA in Device*/
			DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG, (wDmaRegValue &= ~DOCH_DMA_REQ_ENABLE));

			/*Check status of DMA operation*/
			if(dmaParams.fDmaStatus != 0)
			{
				DBG_PRINT_ERR(FLZONE_API, "io_input(): DOCH_DMA_WAIT_FOR_READ_TRANSACTION_END Failed\r\n");

				DBG_PRINT_ERR(FLZONE_ATA, "ready(): Resetting device... ");
				rc = doch_reset (pdev->wSocketNo, devNum);
				if(rc == DOCH_OK)
					DBG_PRINT_ERR(FLZONE_ATA, "Passed! \r\n");
				else
				{
					DBG_PRINT_ERR(FLZONE_ATA, "Failed! \r\n");
					return rc;
				}

				return DOCH_GeneralFailure;
			}

		}

		/*If DRQ is larger the 1 and some sectors are left to be transfered,
		  perform another DMA transaction with altered frame/block sizes*/
		if(dmaRemainderSectors > 0)
		{
			dmaBlocks  = 1;
			dmaFrameSize = dmaRemainderSectors;

			dmaRemainderSectors = 0;

			goto dochIoInputDmaSequence;
		}

	}
	else
	#endif /*DOCH_DMA_CONFIG*/

	/*PIO transfer was requested*/
	{
		/*Write ATA command register*/
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
        Delay_us(10);   // this delay seems to ensure reliable results...

		/* Check DRQ ready and not BSY before data xfer */
		(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
													DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready (before data XFER) \r\n");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
			return rc;
		}

		/*Perform per-sector
		1. Wait until device is ready to receive data
		2. Xfer 1 sector*/
		if((pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_SINGLE) || /*Single Sector was requested*/
			  (!(regs->bCommandStatus == DOCH_VSCMD_READ_PARTITION)) )			/*Command is OTHER than Read Partition*/
		{
            for(secPerformed=1; secPerformed <= sectors_to_read; secPerformed++)
            {
				/*Perform data xfer*/
				if( (DOCHBLK_READ(pdev->bRegBase,
								 ((FLByte*)buf + offset),
								 1)) != 0)
				{
					return DOCH_ReadFault;
				}

				/* Check DRQ ready and not BSY before next data xfer */
				/* (don`t perform after LAST sector was transfered) */
				if(secPerformed != sectors_to_read)
				{
					(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
																DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
					if(rc != DOCH_OK)
					{
						DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready (before data XFER) \r\n");
						DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
						return rc;
					}
				}

				offset += DOCH_SECTOR_SIZE;
			}

		}
		else if(pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_MULT)
		{
			multCount = (FLByte)pdev->device[devNum].dwMulti_Current;

			for(secPerformed=0;	secPerformed<sectors_to_read;)
			{
				/*Determine how many sectors to read this cycle*/
				if((secPerformed + multCount) > sectors_to_read)
					multSecToRead = (sectors_to_read - secPerformed);
				else
					multSecToRead = multCount;

				/*Perform data xfer*/
				if( (DOCHBLK_READ(pdev->bRegBase,
								  (FLByte*)buf + offset,
								  (multSecToRead))) != 0)
				{
					return DOCH_ReadFault;
				}

				/* Check DRQ ready and not BSY before next data xfer */
				/* (don`t perform after LAST sector was transfered) */
				if((secPerformed + multSecToRead) != sectors_to_read)
				{
					(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
																DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
					if(rc != DOCH_OK)
					{
						DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready (before data XFER) \r\n");
						DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
						return rc;
					}
				}

				/*Advance number of written sectors and update pointer to buffer*/
				secPerformed +=  multSecToRead;
				offset		 += (multSecToRead * DOCH_SECTOR_SIZE);
			}
		}
		else
		{
			DBG_PRINT_ERR(FLZONE_ATA, "io_input(): Transfer Mode ");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x "), pdev->device[devNum].dataTransferMode));
			DBG_PRINT_ERR(FLZONE_ATA, "not supported\r\n");

			return DOCH_FeatureNotSupported;

		}	/* End of if/else on pdev->device[devNum].dataTransferMode */

	}	/* End of else on if(pdev->bUseDMA) */

	/* wait until device is ready */
	rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_BUSY),
											   DOCH_READY, DOCH_SHORT_WAIT);
	if (rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_input(): ATA not Ready\r\n");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
		return rc;
	}

	/* check operation's status; this also clears IRQ */
	status = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
	if((status & (DOCH_BUSY | DOCH_READY | DOCH_ERROR)) != DOCH_READY)
	{
		if((status & DOCH_BUSY) == DOCH_BUSY)
			return DOCH_ATABusyNotCleared;
		else if((status & DOCH_READY) != DOCH_READY)
			return DOCH_ATANotReady;
		else if((status & DOCH_ERROR) == DOCH_ERROR)
			return DOCH_ATAErrorDetected;
	}

    return rc;
}

/******************************************************************************
 *                                                                            *
 *                             i o _ o u t p u t                              *
 *                                                                            *
 *  Write sectors to DOCH device.                                             *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to act on                               *
 *		regs				 : DOCH_Registers								  *
 *      buf                  : user buffer to write from                      *
 *		secNum				 : # of sectors to write						  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error io_output ( DOCH_Socket     * pdev,
					   FLSNative 		 devNum,
					   DOCH_Registers  * regs,
                       void            * buf,
					   FLNative			 secNum)
{
    FLNative    sectors_to_write;
	FLNative	secPerformed;
	FLNative	offset = 0;
    DOCH_Error  rc;
	FLSNative 	status;
	FLByte		multCount = 0;

	/*Calculate how many sectors are to be written*/
	/*Note: "0" - 256 Sectors to write*/
	sectors_to_write = (secNum ? secNum : 256);

	/* First we write the device head register to ensure we are communicating
	   with the right device...*/
	DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_DRIVE_HEAD_REG, regs->bDriveHead);

	/*Wait for BUSY bit to clear*/
	status = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
	if((status & DOCH_BUSY) == DOCH_BUSY)
	{
	    if ((rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, DOCH_BUSY, 0, DOCH_SHORT_WAIT)) != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_output(): ATA not Ready\r\n");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
	        return rc;
		}
	}

	/*Write ATA registers, without ATA command register*/
	/*Note: if DMA was requested, registers will be written inside DMA context*/
	if(!pdev->bUseDMA)
	{
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_CNT_REG,		regs->bSectorCount);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_NO_REG,		regs->bSectorNumber);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_LOW_REG,	regs->bCylLow);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_HIGH_REG,	regs->bCylHigh);
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_FEATURES_REG,		regs->bFeaturesError);
	}

	#ifdef DOCH_USE_BURST_MODE_WRITE
 	/*BURST transfer was requested*/
	if(pdev->bUseBurst)
	{
	   /*Initiate ATA Command*/
       DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
       Delay_us(10);   // this delay seems to ensure reliable results...

  	    /* Check DRQ ready and not BSY before data xfer */
		(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
													DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_output(): ATA not Ready (before BURST) \r\n");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
			return rc;
		}

	   /*Set DOCH BURST WRITE Control Register*/
		DOCHWRITE_CTRL_REG (pdev->bRegBase,
							HIB_BURST_WRITE_MODE_CTRL_REG,
							(DOCH_BURST_ENABLE | DOCH_BURST_HOLD | DOCH_BURST_LENGTH | DOCH_BURST_LATENCY | DOCH_BURST_WAIT_STATE)
							);

		/*Enter BURST Mode*/
		DOCH_HOST_ENTER_WRITE_BURST_MODE

		/*Perform Write using burst*/
		DOCHWRITE_BURST((FLByte*)pdev->bRegBase,
						DOCH_DATA_PORT_AREA_OFFSET,
						buf,
						sectors_to_write);

		/*Exit BURST Mode*/
		DOCH_HOST_EXIT_WRITE_BURST_MODE

	   /*Set DOCH BURST WRITE Control Register*/
		DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_BURST_WRITE_MODE_CTRL_REG, DOCH_BURST_DISABLE);

		/* Wait until device is ready. This SHOULD NOT involve yielding the
		 * CPU and waiting for device interrupt, so we use DOCH_SHORT_WAIT.
		 */
		rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, (DOCH_READY | DOCH_BUSY | DOCH_DRQ),
													   DOCH_READY, DOCH_SHORT_WAIT);

	}
 	else
	#endif /*DOCH_USE_BURST_MODE_WRITE*/

	#ifdef DOCH_DMA_CONFIG
	/*DMA transfer was requested*/
	if(pdev->bUseDMA)
	{
		DMA_Params_S dmaParams;
		FLDword dmaRemainderSectors, dmaBlocks;
		FLDword dmaFrameSize;
		FLWord wDmaRegValue = DOCHREAD_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG);

		if(pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_SINGLE)
		{
			dmaRemainderSectors = 0;
			dmaFrameSize		= 1;
			dmaBlocks			= sectors_to_write;
		}
		else if (pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_MULT)
		{
			dmaRemainderSectors = (sectors_to_write % pdev->device[devNum].dwMulti_Current);

			/*Set initial parameters (will be altered afterwards to transfer "remainder" sectors*/
			dmaBlocks		    = (sectors_to_write / pdev->device[devNum].dwMulti_Current);
			dmaFrameSize		= pdev->device[devNum].dwMulti_Current;
		}
		else
		{
			DBG_PRINT_ERR(FLZONE_ATA, "io_input(): DMA Transfer Mode ");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x "), pdev->device[devNum].dataTransferMode));
			DBG_PRINT_ERR(FLZONE_ATA, "not supported\r\n");

			return DOCH_FeatureNotSupported;
		}	/* End of if/else on pdev->device[devNum].dataTransferMode */

dochIoOutputDmaSequence:
		if(dmaBlocks > 0)
		{
			/*Set up the DMA transfer - Platfrom*/
			dmaParams.bOpType			  = DOCH_DMA_CONFIG_TRANSACTION_HOST_TO_DEVICE;

			dmaParams.bDiskOnChip_BasePtr = ((FLByte*)pdev->bRegBase);
			dmaParams.wDiskOnChip_Offset  = DOCH_DATA_PORT_AREA;
			dmaParams.bDestAddrPtr		  = (FLByte*)buf;

			dmaParams.wFrameSize		  = (FLWord)(dmaFrameSize * DOCH_SECTOR_SIZE);
			dmaParams.wFramesInBlock	  = (FLWord)(dmaBlocks);

			dmaParams.wFramesXferred	  = 0;

			DOCH_DMA_CONFIG(&dmaParams);
			if(dmaParams.fDmaStatus != 0)
			{
				DBG_PRINT_ERR(FLZONE_API, "io_output(): DOCH_DMA_CONFIG_TRANSACTION_HOST_TO_DEVICE Failed\r\n");
				return DOCH_GeneralFailure;
			}

			/*Set up the DMA transfer - Device*/
			DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG, (wDmaRegValue | DOCH_DMA_REQ_ENABLE));

			/*Write ATA registers*/
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_CNT_REG,    regs->bSectorCount);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_NO_REG,     regs->bSectorNumber);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_LOW_REG,  regs->bCylLow);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_HIGH_REG, regs->bCylHigh);
			DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_FEATURES_REG,	   regs->bFeaturesError);

			/*Write ATA command*/
			/*This will also start DMA transfer*/
	        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
            Delay_us(10);   // this delay seems to ensure reliable results...

			/*Wait for DMA transfer to complete*/
			dmaParams.bOpType = DOCH_DMA_WAIT_FOR_WRITE_TRANSACTION_END;
			DOCH_DMA_CONFIG(&dmaParams);

			/*Disable DMA in Device*/
			DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_DMA_CTRL_REG, (wDmaRegValue &= ~DOCH_DMA_REQ_ENABLE));

			/*Check status of DMA operation*/
			if(dmaParams.fDmaStatus != 0)
			{
				DBG_PRINT_ERR(FLZONE_API, "io_output(): DOCH_DMA_WAIT_FOR_WRITE_TRANSACTION_END Failed\r\n");

				DBG_PRINT_ERR(FLZONE_ATA, "ready(): Resetting device... ");
				rc = doch_reset (pdev->wSocketNo, devNum);
				if(rc == DOCH_OK)
					DBG_PRINT_ERR(FLZONE_ATA, "Passed! \r\n");
				else
				{
					DBG_PRINT_ERR(FLZONE_ATA, "Failed! \r\n");
					return rc;
				}

				return DOCH_GeneralFailure;
			}

		}

		/*If DRQ is larger the 1 and some sectors are left to be transfered,
		  perform another DMA transaction with altered frame/block sizes*/
		if(dmaRemainderSectors > 0)
		{
			dmaBlocks  = 1;
			dmaFrameSize = dmaRemainderSectors;

			dmaRemainderSectors = 0;

			goto dochIoOutputDmaSequence;
		}

		/* Wait until device is ready. This SHOULD NOT involve yielding the
		 * CPU and waiting for device interrupt, so we use DOCH_SHORT_WAIT.
		 */
		rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, (DOCH_READY | DOCH_BUSY | DOCH_DRQ),
													   DOCH_READY, DOCH_SHORT_WAIT);

	}
	else
	#endif /*DOCH_DMA_CONFIG*/

	/*PIO transfer was requested*/
	{
		/*Write ATA command*/
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG, regs->bCommandStatus);
        Delay_us(10);   // this delay seems to ensure reliable results...

		/* Check DRQ ready and not BSY before data xfer */
		(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
															DOCH_READY | DOCH_DRQ, DOCH_SHORT_WAIT));
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_output(): ATA not Ready\r\n");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
			return rc;
		}

		/*Perform per-sector
		1. Wait until device is ready to receive data
		2. Xfer 1 sector*/

		if((pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_SINGLE) || /*Single Sector was requested*/
			  (!(regs->bCommandStatus == DOCH_VSCMD_WRITE_PARTITION)) )			/*Command is OTHER than Write Partition*/
		{
			for(secPerformed=1; secPerformed<=sectors_to_write; secPerformed++)
			{
				/*Perform data xfer*/
				if( (DOCHBLK_WRITE(pdev->bRegBase,
								   (FLByte*)buf + offset,
								   1)) != 0)
				{
					return DOCH_WriteFault;
				}

				/* Check DRQ ready and not BSY before next data xfer */
				/* (don`t perform after LAST sector was transfered) */
				if(secPerformed != sectors_to_write)
				{
					(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
																DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
					if(rc != DOCH_OK)
					{
						DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_output(): ATA not Ready\r\n");
						DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
						return rc;
					}
				}

				offset += DOCH_SECTOR_SIZE;
			}
		}
		else if (pdev->device[devNum].dataTransferMode == DOCH_DATA_MODE_MULT)
		{
			multCount = (FLByte)pdev->device[devNum].dwMulti_Current;

			for(secPerformed=0;	secPerformed<sectors_to_write;)
			{
            	FLByte		multSecToWrite;

				/*Determine how many sectors to write this cycle*/
				if((secPerformed + multCount) > sectors_to_write)
					multSecToWrite = (sectors_to_write - secPerformed);
				else
					multSecToWrite = multCount;

				/*Perform data xfer*/
				if( (DOCHBLK_WRITE(pdev->bRegBase,
								   (FLByte*)buf + offset,
								   (multSecToWrite))) != 0)
				{
					return DOCH_WriteFault;
				}

				/* Check DRQ ready and not BSY before next data xfer */
				/* (don`t perform after LAST sector was transfered) */
				if((secPerformed + multSecToWrite) != sectors_to_write)
				{
					(rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY | DOCH_DRQ | DOCH_BUSY | DOCH_ERROR),
																DOCH_READY | DOCH_DRQ, DOCH_LONG_WAIT));
					if(rc != DOCH_OK)
					{
						DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_output(): ATA not Ready\r\n");
						DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
						return rc;
					}
				}

				/*Advance number of written sectors and update pointer to buffer*/
				secPerformed +=  multSecToWrite;
				offset		 += (multSecToWrite * DOCH_SECTOR_SIZE);
			}
		}
		else
		{
			DBG_PRINT_ERR(FLZONE_ATA, "io_input(): Transfer Mode ");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x "), pdev->device[devNum].dataTransferMode));
			DBG_PRINT_ERR(FLZONE_ATA, "not supported\r\n");

			return DOCH_FeatureNotSupported;
		}	/* End of if/else on pdev->device[devNum].dataTransferMode */

		/* Wait until device is ready. This might involve yielding the
		 * CPU and waiting for device interrupt, so we use DOCH_LONG_WAIT.
		 */
		rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, (DOCH_READY | DOCH_BUSY | DOCH_DRQ),
													   DOCH_READY, DOCH_LONG_WAIT);

	}	/* End of else on if(pdev->bUseDMA) */

	/* check operation's status; this also clear IRQ */
	status = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
	if((status & (DOCH_BUSY | DOCH_READY | DOCH_ERROR)) != DOCH_READY)
	{
		if((status & DOCH_BUSY) == DOCH_BUSY)
			return DOCH_ATABusyNotCleared;
		else if((status & DOCH_READY) != DOCH_READY)
			return DOCH_ATANotReady;
		else if((status & DOCH_ERROR) == DOCH_ERROR)
			return DOCH_ATAErrorDetected;
	}

    return rc;
}

/******************************************************************************
 *                                                                            *
 *                              i o _ c t r l                                 *
 *                                                                            *
 *  Pass command 'cmd' to DOCH device.                                        *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to act on                               *
 *		regs				 : DOCH_Registers								  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error io_ctrl ( DOCH_Socket     * pdev,
					 FLSNative 		   devNum,
				     DOCH_Registers	 * regs)
{
    DOCH_Error  rc;
	FLSNative 	status;

	/* First we write the device head register to ensure we are communicating
	   with the right device...*/
	DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_DRIVE_HEAD_REG, regs->bDriveHead);

	/*Wait for DOCH BUSY flag to clear*/
    if ((rc = ready(pdev, devNum, DOCH_ALT_STATUS_REG, DOCH_BUSY, 0, DOCH_SHORT_WAIT)) != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_ctrl(): ATA not Ready\r\n");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
        return rc;
	}

	/*If DOCH is ready, write registers*/
    if (rc == DOCH_OK)
    {
		/*Write ATA registers*/
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_FEATURES_REG,		regs->bFeaturesError);
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_CNT_REG,		regs->bSectorCount);
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_SECTOR_NO_REG,		regs->bSectorNumber);
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_LOW_REG,	regs->bCylLow);
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CYLINDER_HIGH_REG,	regs->bCylHigh);
        DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_COMMAND_REG,		regs->bCommandStatus);
        Delay_us(10);   // this delay seems to ensure reliable results...

		/* wait until device is ready */
		rc = ready(pdev, devNum, DOCH_STATUS_REG, (DOCH_READY |  DOCH_BUSY),
												   DOCH_READY, DOCH_LONG_WAIT);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_ATA, "\r\nio_ctrl(): ATA not Ready\r\n");
			DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("rc = 0x%x \r\n"),rc));
			return rc;
		}

		/* check operation's status; this also clear IRQ */
		status = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
		if((status & (DOCH_BUSY | DOCH_READY | DOCH_ERROR)) != DOCH_READY)
		{
			if((status & DOCH_BUSY) == DOCH_BUSY)
				return DOCH_ATABusyNotCleared;
			else if((status & DOCH_READY) != DOCH_READY)
				return DOCH_ATANotReady;
			else if((status & DOCH_ERROR) == DOCH_ERROR)
				return DOCH_ATAErrorDetected;
		}
    }

    return rc;
}

DOCH_Error retrieveAndPrintAtaDebug(DOCH_Socket* pdev)
{
    DOCH_Error rc = DOCH_OK;
	DOCH_Registers in_regs;
	DOCH_Registers out_regs;
	/*FLWord numOfDataBytes;*/
	FLWord currentINTEnabled, currentDMAEnabled, currentBurstEnabled;

	tffsset(&in_regs, 0, sizeof(in_regs));
	in_regs.bFeaturesError = DOCH_RETRIEVE_DBG_MSG;
	in_regs.bCommandStatus = DOCH_VSCMD_EXT_DEVICE_CTRL;
	in_regs.bSectorCount   = 1;
	in_regs.bDriveHead = (pdev->bAtaDevNum * DOCH_DEVICE);

	/* Disable interrupts */
	/* Disable DMA/Burst */
	/* (retain original values)*/
	currentINTEnabled = pdev->bUseInterrupt;
	currentDMAEnabled = pdev->bUseDMA;
	currentBurstEnabled = pdev->bUseBurst;
	pdev->bUseInterrupt = FALSE;
	pdev->bUseDMA		= FALSE;
	pdev->bUseBurst		= FALSE;
	dochEnableATAInterrupt(pdev->wSocketNo, FALSE, 0);


	/*Perform debug ocommand*/
	rc = io_input(pdev, 0, &in_regs, ataDBG, 1);

	/*Revert interrupts/DMA/Burst to original state*/
	pdev->bUseInterrupt = currentINTEnabled;
	pdev->bUseDMA		= currentDMAEnabled;
	pdev->bUseBurst		= currentBurstEnabled;
	dochEnableATAInterrupt(pdev->wSocketNo,
						   (DOCH_IRQ_RB_INIT(pdev->wSocketNo) && currentINTEnabled),
						   0);


	/*Retrieve ATA out registers*/
	rc = get_out_registers(pdev, 0, &out_regs);
	if(rc != DOCH_OK)
		return rc;

	/*numOfDataBytes = (out_regs.bSectorNumber + (out_regs.bCylLow<<8));*/

	if(ataDBG[0] != '\0')
	{
		DBG_PRINT_ERR(FLZONE_ATA, "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~");
		DBG_PRINT_ERR(FLZONE_ATA, "\r\n*** ETFFS Debug string: ");
		DBG_PRINT_ATA(FLZONE_ATA, (ataDBG));
		DBG_PRINT_ERR(FLZONE_ATA, " ***");
		DBG_PRINT_ERR(FLZONE_ATA, "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~\r\n");
	}

	return rc;
}

/******************************************************************************
 *                                                                            *
 *                    d o c h _ c o m m a n d                                 *
 *                                                                            *
 *  Sends 'cmd' command to DOCH device.                                       *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *		in_regs				 : DOCH input registers values					  *
 *		out_regs			 : DOCH output registers values					  *
 *      buf                  : user buffer                                    *
 *		secNum				 : # of sectors (for data transfer commands)	  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/

DOCH_Error doch_command ( FLSNative       socketNo,
						  FLSNative 	  devNum,
						  DOCH_Registers* in_regs,
						  DOCH_Registers* out_regs,
						  void          * buf,
						  FLNative		  secNum)
{
    DOCH_Socket* pdev;
    DOCH_Error   rc;
    DOCH_Error   rc2;

    /* Sanity Check*/
	/*=============*/
	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

#ifdef CHECK_POWER_ON_EVERY_COMMAND
	/* Check if device was reset */
	rc = dochCheckPFSymptom(socketNo, pdev->bAtaDevNum, TRUE);
	if(rc != DOCH_OK)
		return rc;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/

#ifdef DOCH_DMA_CONFIG
	{
		DMA_Params_S dmaParams;

		if(pdev->bUseDMA && (gDMAChannelOpen == 0))
		{
			dmaParams.bOpType = DOCH_DMA_OPEN_CHANNEL;
			DOCH_DMA_CONFIG(&dmaParams);
			if(dmaParams.fDmaStatus != 0)
			{
				DBG_PRINT_ERR(FLZONE_API, "doch_command(): DOCH_DMA_OPEN_CHANNEL Failed\r\n");
				return DOCH_GeneralFailure;
			}

			gDMAChannelOpen = DOCH_GLOBAL_BOOL_PATTERN;

			DBG_PRINT_FLOW(FLZONE_ATA, "\r\nDMA Channel opened\r\n");
		}

	}
#endif /*DOCH_DMA_CONFIG*/

	/*Branch to proper IO routine according to ATA command*/
    switch ((DOCH_Command)(in_regs->bCommandStatus))
    {
		/* Vendor-Specific ATA commands */

		case DOCH_VSCMD_READ_PARTITION:
		case DOCH_VSCMD_READ_CALCULATED_HASH:
		case DOCH_VSCMD_READ_ORIGINAL_HASH:
			rc = io_input (pdev, devNum, in_regs, buf, secNum);
			break;

		case DOCH_VSCMD_WRITE_PARTITION:
		case DOCH_VSCMD_WRITE_FLEXI:
		case DOCH_VSCMD_WRITE_GIVEN_HASH:
			rc = io_output (pdev, devNum, in_regs, buf, secNum);
			break;

		case DOCH_VSCMD_OPTIMIZE_PARTITION_SECTORS:
		case DOCH_VSCMD_ERASE_PARTITION_SECTORS:
		case DOCH_VSCMD_WRITE_CALCULATED_HASH:
			rc = io_ctrl (pdev, devNum, in_regs);
			break;

		case DOCH_VSCMD_PARTITION_MANAGEMENT:
			switch((DOCH_DeviceCtrlOp)(in_regs->bFeaturesError))
			{

			case DOCH_SET_DEFAULT_PARTITION:
			case DOCH_DELETE_PARTITIONS:
				rc = io_ctrl (pdev, devNum, in_regs);
				break;

			case DOCH_GET_PARTITION_INFO:
			case DOCH_GET_PARTITION_USER_ATTR:
				rc = io_input (pdev, devNum, in_regs, buf, secNum);
				break;

			case DOCH_SET_PARTITION_PROTECTION:
			case DOCH_SET_PARTITION_USER_ATTR:
			case DOCH_ADD_PARTITION:
			case DOCH_SECURE_ERASE:
				rc = io_output (pdev, devNum, in_regs, buf, secNum);
				break;

			default:
				return DOCH_UnknownCmd;
			}
			break;

		case DOCH_VSCMD_ACCESS_CONTROL:
			switch((DOCH_SecurityCtrlOp)(in_regs->bFeaturesError))
			{
			case DOCH_DISABLE_ACCESS:
				rc = io_ctrl (pdev, devNum, in_regs);
				break;

			case DOCH_RX_DOCH_PUBLICKEY:
			case DOCH_VERIFY_HOST_KEY:
				rc = io_input (pdev, devNum, in_regs, buf, secNum);
				break;

			case DOCH_EN_ACCESS_WPWD:
			case DOCH_TX_HOST_PUBLICKEY:
				rc = io_output (pdev, devNum, in_regs, buf, secNum);
				break;

			default:
				return DOCH_UnknownCmd;
			}
			break;

		case DOCH_VSCMD_EXT_DEVICE_CTRL:
			switch((DOCH_DeviceCtrlOp)(in_regs->bFeaturesError))
			{

			case DOCH_SET_DATA_XFER_MODE:
			case DOCH_ATOMIC_WRITE_SEQUENCE:
			case DOCH_OPTIMIZE_MEDIA:
			case DOCH_GET_RESET_STATUS:
			case DOCH_NOTIFY_RESET:
			case DOCH_NOTIFY_PLATFORM_RESUMED:
			case DOCH_GET_CUSTOM_PARAM:
			case DOCH_SET_CUSTOM_PARAM:
			case DOCH_SET_POWER_MODE:
			case DOCH_GET_POWER_MODE:
			case DOCH_ACTIVATE_DEBUG_MODE:
			case DOCH_SET_ALERT_LEVEL:
				rc = io_ctrl (pdev, devNum, in_regs);
				break;

			case DOCH_IDENTIFY_DISKONCHIP_DEVICE:
			case DOCH_GET_EXTENDED_DEVICE_INFO:
			case DOCH_GET_DISK_USER_ATTR:
			case DOCH_GET_CONFIGURATION_DATA:
				rc = io_input (pdev, devNum, in_regs, buf, secNum);
				break;

			case DOCH_SET_DISK_USER_ATTR:
			case DOCH_SET_CONFIGURATION_DATA:
				rc = io_output (pdev, devNum, in_regs, buf, secNum);
				break;

			default:
				return DOCH_UnknownCmd;
			}
			break;

		case DOCH_VSCMD_EXT_SECURITY_CTRL:
			switch((DOCH_SecurityCtrlOp)(in_regs->bFeaturesError))
			{

			case DOCH_SET_ALGORITHM_MODE:
			case DOCH_AUTO_HASH_CONTROL:
			case DOCH_SET_KEYS:
			case DOCH_START_HASH_STREAM_CALC:
			case DOCH_READ_STOP_HASH_STREAM_CALC:
				rc = io_ctrl (pdev, devNum, in_regs);
				break;

			case DOCH_REPORT_SUPPORTED_ALGORITHMS:
			case DOCH_GET_ALGORITHM_CAPABILITIES:
			case DOCH_RETURN_RANDOM_NUMBERS:
				rc = io_input (pdev, devNum, in_regs, buf, secNum);
				break;

			default:
				return DOCH_UnknownCmd;
			}
			break;

        default:
            return DOCH_UnknownCmd;
    }

	/*If IO operation succeeded, retrieve device response from ATA registers
	  (calling routine might need some data back from the device)
	  Common IO Read/Write routines are excluded */
	switch( rc )
	{
	case DOCH_OK:
		if((in_regs->bCommandStatus != DOCH_VSCMD_READ_PARTITION) &&
		   (in_regs->bCommandStatus != DOCH_VSCMD_WRITE_PARTITION) &&
		   (in_regs->bCommandStatus != DOCH_VSCMD_WRITE_FLEXI))
			rc = get_out_registers(pdev, devNum, out_regs);
		break;

	case DOCH_ATAErrorDetected:
		rc = get_out_registers(pdev, devNum, out_regs);
		break;
	default:
		break;
	}

#ifdef CHECK_POWER_ON_EVERY_COMMAND
	/* Check if device was reset */
	rc2 = dochCheckPFSymptom(socketNo, pdev->bAtaDevNum, FALSE);
	if(rc2 != DOCH_OK)
		return rc2;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/

	/* If ATA debug was requested - retrieve and print buffer from Device */
	if(gDochAtaDebug == DOCH_GLOBAL_BOOL_PATTERN)
	{
		rc2 = retrieveAndPrintAtaDebug(pdev);
		if(rc2 != DOCH_OK)
			return rc2;
	}

	return rc;
}

/******************************************************************************
 *                                                                            *
 *              d o c h _ a t a _ p a s s t h r u                             *
 *                                                                            *
 *  Pass-thru routine for ATA commands                                        *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo            : Socket # (0...DOCH_MAX_SOCKETS-1)               *
 *		ptOP				: Data transfer type (In/Out/No)				  *
 *		in_regs				: DOCH input registers values					  *
 *		out_regs			: DOCH output registers values					  *
 *      buf					: user buffer                                     *
 *      secNum				: Number of sectors (in case of data transfer)    *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/

DOCH_Error doch_ata_passthru ( FLSNative        socketNo,
							   FLSNative 		devNum,
							   DOCH_PassThru_Op ptOP,
							   DOCH_Registers * in_regs,
						       DOCH_Registers * out_regs,
						       void           * buf,
						       FLNative			secNum)
{
    DOCH_Socket* pdev;
    DOCH_Error   rc = DOCH_OK;
	DOCH_Error	 rc2;

    /* Sanity Check*/
	/*=============*/
	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

	switch(ptOP)
	{
	case DOCH_PASSTHRU_NO_DATA:
		rc = io_ctrl (pdev, devNum, in_regs);
		break;

	case DOCH_PASSTHRU_DATA_IN:
		rc = io_input (pdev, devNum, in_regs, buf, secNum);
		break;

	case DOCH_PASSTHRU_DATA_OUT:
		rc = io_output (pdev, devNum, in_regs, buf, secNum);
		break;

	default:
		return DOCH_UnknownCmd;
	}

	/* If ATA debug was requested - retrieve and print buffer from Device */
	if(gDochAtaDebug == DOCH_GLOBAL_BOOL_PATTERN)
	{
		rc2 = retrieveAndPrintAtaDebug(pdev);
		if(rc2 != DOCH_OK)
			return rc2;
	}

	/*If IO operation succeeded, retrieve device response from ATA registers
	(calling routine might need some data back from the device)*/
	if(rc == DOCH_OK)
		return get_out_registers(pdev, devNum, out_regs);
	else
		return rc;
}

/******************************************************************************
 *                                                                            *
 *                c l e a r A T A I n t e r r u p t							  *
 *                                                                            *
 *  Clear ATA interrupt by simply reading the ATA status register			  *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to perform operation on                 *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error clearATAInterrupt(FLSNative socketNo)
{
#ifdef DOCH_USE_FUNC
	DOCH_Socket* pdev;
	FLByte dummy;

	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

	dummy = DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);

#else /*DOCH_USE_FUNC*/

	FLByte dummy = DOCHREAD_ATA_REG((&sockets[socketNo])->bRegBase, DOCH_STATUS_REG);

#endif /*DOCH_USE_FUNC*/

	dummy = 0; /*Simply to avoid compilation warning...*/


	return DOCH_OK;
}


/******************************************************************************
 *                                                                            *
 *                 g e t _ o u t _ r e g i s t e r s                          *
 *                                                                            *
 *  Retrieve ATA output registers values                                      *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev                 : device to perform operation on                 *
 *		out_regs			 : DOCH output registers values					  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error get_out_registers(DOCH_Socket* pdev, FLSNative  devNum, DOCH_Registers* out_regs)
{
	DOCH_Error error = DOCH_OK;

	out_regs->bFeaturesError	= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_ERROR_REG);
	out_regs->bSectorCount		= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_SECTOR_CNT_REG);
	out_regs->bSectorNumber		= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_SECTOR_NO_REG);
	out_regs->bCylLow			= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_CYLINDER_LOW_REG);
	out_regs->bCylHigh			= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_CYLINDER_HIGH_REG);
	out_regs->bDriveHead		= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_DRIVE_HEAD_REG);
	out_regs->bCommandStatus	= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_STATUS_REG);
	out_regs->bContorlAltStatus	= DOCHREAD_ATA_REG(pdev->bRegBase, DOCH_ALT_STATUS_REG);

	/*If an error was detected - return the error code*/
	if((out_regs->bCommandStatus & DOCH_ERROR) == DOCH_ERROR)
	{
		error = (DOCH_Error)out_regs->bFeaturesError;

		DBG_PRINT_ERR(FLZONE_ATA, "\r\nget_out_registers(): ATA Error\r\n");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("error = 0x%x \r\n"),error));
	}

    return (error);
}

/******************************************************************************
 *                                                                            *
 *                   d o c h _ g e t _ f l a g s                              *
 *                                                                            *
 *  Returns all device's flags (DOCH_USE_XXX)              .                  *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *      flags                : device's flags will be stored there            *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/

DOCH_Error  doch_get_flags (FLSNative  socketNo, FLSNative  devNum, FLDword * flags)
{
    /* Sanity check */
    if ((socketNo < 0) || (socketNo >= DOCH_MAX_SOCKETS) || (flags == NULL))
        return DOCH_BadParameter;

	*flags = sockets[socketNo].device[devNum].flags;

    return DOCH_OK;
}


/******************************************************************************
 *                                                                            *
 *                   d o c h _ s e t _ f l a g s                              *
 *                                                                            *
 *  Add various DOCH_USE_... flags to existing device's flags.                *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *      flags                : collection of DOCH_USE_... flags to add        *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/

DOCH_Error  doch_set_flags (FLSNative  socketNo, FLSNative  devNum, FLDword flags)
{
    /* args sanity check */
    if ((socketNo < 0) || (socketNo >= DOCH_MAX_SOCKETS))
        return DOCH_BadParameter;

	sockets[socketNo].device[devNum].flags = flags;

    return DOCH_OK;
}

/******************************************************************************
 *                                                                            *
 *                       d o c h _ s t a t u s                                *
 *                                                                            *
 *  Read DOCH's status register (which also clears DOCH interrupt). This routine *
 *  is supposed to be called from DOCH interrupt handler.                     *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *                                                                            *
 *  Returns :                                                                 *
 *      value of DOCH's status register                                       *
 *                                                                            *
 ******************************************************************************/

FLByte  doch_status (FLSNative  socketNo, FLSNative  devNum)
{
#ifdef DOCH_USE_FUNC
	DOCH_Socket* pdev;

	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return 1;

    pdev = &sockets[socketNo];

#endif /*DOCH_USE_FUNC*/

    return  DOCHREAD_ATA_REG(sockets[socketNo].bRegBase, DOCH_STATUS_REG);
}

/******************************************************************************
 *                                                                            *
 *                       d o c h _ r e s e t                                  *
 *                                                                            *
 *  Reset ATA Protocol .													  *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/

DOCH_Error doch_reset (FLSNative  socketNo, FLSNative  devNum)
{
	FLDword tries;
	FLDword i = 0;
	FLByte status;
#ifdef DOCH_USE_FUNC
    DOCH_Socket* pdev;
#endif /*DOCH_USE_FUNC*/

    /* args sanity check */
    if ((socketNo < 0) || (socketNo >= DOCH_MAX_SOCKETS))
        return DOCH_BadParameter;

	/*Protect against access time set to 0*/
	if(gDochAccessNanosec == 0)
		return DOCH_BadParameter;
	tries = (DOCH_SHORT_WAIT* (1000000UL / gDochAccessNanosec));

#ifdef DOCH_USE_FUNC
    pdev = &sockets[socketNo];
#endif /*DOCH_USE_FUNC*/


    /* reset DOCH; DOCH_ATA_NIEN bit disables DOCH interrupts */
    DOCHWRITE_ATA_REG (sockets[socketNo].bRegBase, DOCH_CONTROL_REG, DOCH_ATA_SRST);

    /* cancel DOCH reset; DOCH_ATA_NIEN bit disables DOCH interrupts */
    DOCHWRITE_ATA_REG (sockets[socketNo].bRegBase, DOCH_CONTROL_REG, 0);

    /* wait for DOCH to become ready */

	for(i=0; i<tries; i++)
	{
		status = DOCHREAD_ATA_REG(sockets[socketNo].bRegBase, DOCH_STATUS_REG);
		if( (status & (DOCH_READY | DOCH_BUSY | DOCH_DRQ)) == DOCH_READY)
			goto doch_reset_returnOK;
	}

	return DOCH_TimedOut;

doch_reset_returnOK:
    return DOCH_OK;
}

/******************************************************************************
 *                                                                            *
 *              u p d a t e _ d e v i c e _ i n f o                           *
 *                                                                            *
 *  Update device structure based on diskOnChip device info structure		  *
 *                                                                            *
 *  Parameters :                                                              *
 *      pdev					: DOCH_Socket							      *
 *      diskOnChipDeviceInfo    : DOCH_DeviceInfo					          *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error update_device_info(DOCH_Socket* pdev,
							  DOCH_DeviceInfo* diskOnChipDeviceInfo,
							  FLSNative  devNum)
{
	IOreq ioreq;

	/*TBD - BYTE???*/
	FLByte drqSize = 1<<((FLByte)((diskOnChipDeviceInfo->dwCommandFlagsOrStatuses & DOCH_DCFSB_CURRENT_MULTI_SECTOR) >> DOCH_DCFSO_CURRENT_MULTI_SECTOR));

	if((pdev == NULL) || (diskOnChipDeviceInfo == NULL))
		return DOCH_BadParameter;

	/*Update device structure*/
	/*=======================*/
	pdev->device[devNum].wNumOfPartitions = diskOnChipDeviceInfo->wTotalNumOfPartitions;

	pdev->device[devNum].dataTransferMode  =
		(DOCH_TransferMode)((diskOnChipDeviceInfo->dwCommandFlagsOrStatuses & DOCH_DCFSB_CURRENT_XFER_MODE) >> DOCH_DCFSO_CURRENT_XFER_MODE);

	/*Set XFER mode*/
	/*-------------*/
	doch_setTransferMode(pdev->wSocketNo, devNum, pdev->device[devNum].dataTransferMode, drqSize);

	if(pdev->wNumOfDevices == 0)
	{
		/*Retrieve device user attributes*/
		tffsset(&ioreq, 0, sizeof(ioreq));
		DOCH_SET_SOCKET_TO_IOREQ_HANDLE(&ioreq, pdev->wSocketNo);
		ioreq.irData = &devUserAttr;
		DOCHGetDiskUserAttributes(&ioreq);

		/*Extract span information from device attributes*/
		tffscpy(&pdev->sSpanData, &devUserAttr.sdkAttributes.sSpanInfo, sizeof(pdev->sSpanData));
	}

	return DOCH_OK;
}

/*----------------------------------------------------------------------*/
/*                   d o c h S e t M u t e x                            */
/*                                                                      */
/* Notifies the start and end of a file-system operation.               */
/*                                                                      */
/* Parameters:                                                          */
/*      socketNum       : Socket number				                    */
/*      state           : DOCH_ON (1) = operation entry                 */
/*                        DOCH_OFF(0) = operation exit                  */
/*      partition       : Partition number of the drive                 */
/*                                                                      */
/*----------------------------------------------------------------------*/
DOCH_Error dochSetMutex(FLByte socketNum, FLBoolean state, FLByte  partition)
{
  DOCH_Socket* pdev;

  if(socketNum > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

  pdev = &sockets[socketNum];

  if (state == DOCH_ON) /* Set busy to ON */
  {
    if (!flTakeMutex(&pdev->mutex))
	{
	   DBG_PRINT_ERR(FLZONE_ATA, "\r\ndochSetMutex Failed to set mutex\r\n");
       return DOCH_DriveNotAvailable;
	}
  }
  else  /* Set busy to OFF */
  {
	flFreeMutex(&pdev->mutex);
  }

  return DOCH_OK;
}

/******************************************************************************
 *                                                                            *
 *              d o c h _ f i n d _ b a s e _ a d d r e s s				      *
 *                                                                            *
 *  Calculate base address, try getting CHIP_ID from the device				  *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *      dwAddress            : Device address					              *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
static DOCH_Error doch_find_base_address( FLSNative socketNo, FLDword dwAddress )
{
	void* win;

	/*Retreive socket pointer from devices array*/
	DOCH_Socket* pdev;

	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

	/* Save the physical address */
	pdev->dwPhysicalAddress = dwAddress;

	/* Get pointer to base of DOCH register set */
	win = (void*)(dwAddress);

	//pdev->bRegBase = (volatile FLByte FAR0*)physicalToPointer((FLDword)win,DOCH_MEM_WIN_SIZE,0);
    pdev->bRegBase = (volatile FLByte FAR0*)win;

	return DOCH_OK;
}

#ifdef DOCH_CHECK_CHIP_ID
/******************************************************************************
 *                                                                            *
 *              d o c h _ f i n d _ b a s e _ a d d r e s s				      *
 *                                                                            *
 *  Calculate base address, try getting CHIP_ID from the device				  *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *      dwAddress            : Device address					              *
 *      fResetAll            : Device address					              *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
static DOCH_Error doch_check_chipID(FLSNative socketNo)
{
	IOreq   ioreq;
	FLWord  chipID1 = 0;
	FLWord  chipID2 = 0;

	/*Retreive socket pointer from devices array*/
	DOCH_Socket *pdev;

	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

	/*Check ChipID*/
	/*============*/
	/*Read Chip ID #1*/
	tffsset(&ioreq, 0, sizeof(ioreq));
	DOCH_SET_SOCKET_TO_IOREQ_HANDLE(&ioreq, (FLByte)(pdev->wSocketNo));
	chipID1 = doch_getConfigReg16(&ioreq, HIB_CHIPID1_REG);
	/*Read Chip ID #2*/
	chipID2 = doch_getConfigReg16(&ioreq, HIB_CHIPID2_REG);
	/*Check that Chip IDs match*/
	if((chipID1 + chipID2) == 0xFFFF)
	{
		if((chipID1 != DOCH_CHIP_ID_H3) && (chipID1 != DOCH_CHIP_ID_H4) && (chipID1 != DOCH_CHIP_ID_H5))
		{
			//DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\r\nUnknown ChipID: #%d \r\n"), chipID1));
		}
/*		else
		{
			DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\r\nSocket #%d - ChipID OK"), socketNo));
			DBG_PRINT_FLOW(FLZONE_ATA, "\r\nDevice Found: ");
			if(chipID1 == DOCH_CHIP_ID_H3)
				DBG_PRINT_FLOW(FLZONE_ATA, "H3");
			if(chipID1 == DOCH_CHIP_ID_H4)
				DBG_PRINT_FLOW(FLZONE_ATA, "H4");
			if(chipID1 == DOCH_CHIP_ID_H5)
				DBG_PRINT_FLOW(FLZONE_ATA, "H5");
		}
*/
		return DOCH_OK;
	}
	else
	{
		//DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\r\nSocket #%d - ChipID Not Found\r\n"), socketNo));
	}

	return DOCH_AdapterNotFound;
}
#endif /* DOCH_CHECK_CHIP_ID */

DOCH_Error setConfigHWItem(DOCH_HwConfigType configHWItem)
{
	DOCH_Error rc;
	IOreq ioreq;

	tffsset(&ioreq, 0, sizeof(ioreq));

	ioreq.irFlags = configHWItem;
	ioreq.irLength = gConfigHWDefaults[configHWItem];
	rc = DOCHConfigHW(&ioreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "\r\nsetConfigHWItem(): Failed setting config Item ");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("#%d "),configHWItem));
		DBG_PRINT_ERR(FLZONE_ATA, "\r\nwith status: ");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("0x%x \r\n"),rc));

		return rc;
	}

	return DOCH_OK;
}

static DOCH_Error doch_configAndID(DOCH_Socket* pdev, FLSNative socketNo, DOCH_InitSocket initSocket)
{
	DOCH_Error rc;
	IOreq ioreq;

	/*Try finding a DOCH device on the requested address*/
	/*==================================================*/
	gSdkDOCAddressObtained = 0;

	rc = doch_find_base_address(socketNo, initSocket.nDeviceAddress);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "Socket ");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("#%d "), socketNo));
		DBG_PRINT_ERR(FLZONE_ATA, "NOT found !\r\n");

		return rc;
	}

	/* Global indication that the DOC address was obtained */
	gSdkDOCAddressObtained = DOCH_GLOBAL_BOOL_PATTERN;

#if 0  //this code set's special data for PCI bus and/or PortaDoc library
       //which is not used for XScale

	/*Set PCI/PortaDoc window offset register*/
	/*=======================================*/
	if(gAccessLayerType == DOCH_AL_NOR)
	{
		if(gMemWindowType == MEM_WIN_8KB)
		{
		#ifdef DOCH_FORCE_USING_8KB
			/*Set memory window size to 8KB*/
			rc = dochSetMemWindowSize8KB(pdev);
			if(rc != DOCH_OK)
				return rc;
		#endif /* DOCH_FORCE_USING_8KB */

			DOCH_SET_WINDOW_OFFSET(TRUE, pdev->bRegBase);
		}
		else
			DOCH_SET_WINDOW_OFFSET(FALSE, pdev->bRegBase);
	}
#endif

	/*Dummy write to exit virtual mode*/
	/*(Dont worry about the value it is later updated by calling setConfigHWItem(DOCH_IPL_CTRL))*/
	/*----------------------------------------------------------------------------------------*/
    DOCHWRITE_CTRL_REG (pdev->bRegBase, HIB_CHIPID2_REG, 0);

	/*Set some register according to user customization*/
	/*=================================================*/
	tffsset(&ioreq, 0, sizeof(ioreq));
	DOCH_SET_SOCKET_TO_IOREQ_HANDLE(&ioreq, (FLByte)(pdev->wSocketNo));

	/* Set HW Config Items */
	/*=====================*/

    /*Set Endian Control Register */
    setConfigHWItem(DOCH_ENDIAN_CTRL);

	/*Set IPL control register */
	setConfigHWItem(DOCH_IPL_CTRL);

	/*Set Power down register */
	setConfigHWItem(DOCH_POWER_DOWN);

	/*Set DMA Control register */
	setConfigHWItem(DOCH_DMA_CTRL);

	/*Set DMA Negation register */
	setConfigHWItem(DOCH_DMA_NEGATION_CTRL);

	/*Set S/W Lock Control register
	  (This will perform SW lock as needed) */
	setConfigHWItem(DOCH_SLOCK);

	/*Set Operation Mode Register */
	setConfigHWItem(DOCH_OPERATION_MODE_CTRL);

    /*Set device to master before checking CHIP ID*/
    DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_DRIVE_HEAD_REG, 0);

#ifdef DOCH_CHECK_CHIP_ID

	/*Check ChipID*/
	/*============*/
	rc = doch_check_chipID(socketNo);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_ATA, "Socket ");
		DBG_PRINT_ERR_PRM(FLZONE_ATA, (FLTXT("#%d "), socketNo));
		DBG_PRINT_ERR(FLZONE_ATA, " - ChipID FAILED !\r\n");

		return rc;
	}

#endif /* DOCH_CHECK_CHIP_ID */

	return DOCH_OK;
}

static DOCH_Error doch_init_8kb(DOCH_Socket *pdev, FLSNative socketNo, DOCH_InitSocket initSocket)
{
	DOCH_Error rc;

	/*Set mem window type and size*/
	//gMemWindowType =  MEM_WIN_8KB;
	//gDochMemWinSize = DOCH_MEM_WIN_SIZE_8KB;

	/*Set gHibCoreAddress to 8KB memory window value*/
	//gHibCoreAddress = HIB_CORE_ADDRESS_8KB;

	/*Set offsets from cire address*/
	//gHibContRegAreaOffset	= DOCH_CONT_REG_AREA_8KB_OFFSET;
	//gHibDataPortAreaOffset	= DOCH_DATA_PORT_AREA_8KB_OFFSET;
	//gHibConfigRegAreaOffset = DOCH_CONFIG_REG_AREA_8KB_OFFSET;

	/*Config HW and check ChipID*/
	rc = doch_configAndID(pdev, socketNo, initSocket);

	if(rc == DOCH_OK)
		DBG_PRINT_FLOW(FLZONE_ATA, "Memory window is 8KB");

	return rc;
}

static DOCH_Error doch_init_128kb(DOCH_Socket* pdev, FLSNative socketNo, DOCH_InitSocket initSocket)
{
	DOCH_Error rc;

	/*Set mem window type*/
	//gMemWindowType = MEM_WIN_128KB;
	//gDochMemWinSize = DOCH_MEM_WIN_SIZE_128KB;

	/*Set gHibCoreAddress to 8KB memory window value*/
	//gHibCoreAddress = HIB_CORE_ADDRESS_128KB;

	/*Set offsets from cire address*/
	//gHibContRegAreaOffset	= DOCH_CONT_REG_AREA_128KB_OFFSET;
	//gHibDataPortAreaOffset	= DOCH_DATA_PORT_AREA_128KB_OFFSET;
	//gHibConfigRegAreaOffset = DOCH_CONFIG_REG_AREA_128KB_OFFSET;

	/*Config HW and check ChipID*/
	rc = doch_configAndID(pdev, socketNo, initSocket);

	if(rc == DOCH_OK)
		DBG_PRINT_FLOW(FLZONE_ATA, "Memory window is 128KB");

	return rc;
}

/******************************************************************************
 *                                                                            *
 *                     d o c h _ i n i t _ s o c k e t						  *
 *                                                                            *
 *  Initialize DOCH socket.                                                   *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo             : Socket # (0...DOCH_MAX_SOCKETS-1)              *
 *      DOCH_InitSocket      : runtime socket init data						  *
 *                                                                            *
 *  Returns :                                                                 *
 *      DOCH_OK in success, otherwise respective error code.                  *
 *                                                                            *
 ******************************************************************************/
DOCH_Error doch_init_socket( FLSNative socketNo, DOCH_InitSocket initSocket)
{
	DOCH_Error			rc = DOCH_OK;
    DOCH_Socket			*pdev;
	IOreq			    ioreq;
    register FLSNative  i,j;

    /* args sanity check */
    if( (socketNo < 0) || (socketNo >= DOCH_MAX_SOCKETS) )
        return DOCH_BadParameter;

	/*Retreive socket pointer from devices array*/
    pdev = &sockets[socketNo];

    /*Clear socket structure*/
    clear_socket(pdev);

	flCreateMutex( &(pdev->mutex) );

	/*Set socket# and flags*/
    pdev->wSocketNo = socketNo;

    /*If no devices found - return failure
      If 2 devices - check last partition of device #0 for partition span indication
      ============================================================================*/
    //DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\nSearching devices on socket #%d...\r\n\n"), socketNo));

    //redundant, taken care of in clear_socket
    //pdev->wTotalNumOfPartitions = 0;
    //pdev->nTotalCapacity = 0;

    for(j=0; j < 2 ; j++)
    {
        /*Try identifying device on both 8KB and 128KB memory windows*/
        /*===========================================================*/

		#ifdef DOCH_ASSUME_128KB_WINDOW
		/*If 128KB window is assumed, skip checking 8KB window*/
		j = 1;
		#endif /*DOCH_ASSUME_128KB_WINDOW*/

		#ifdef DOCH_ASSUME_8KB_WINDOW
		/*If 8KB window is assumed, do not continue checking 128KB window*/
		if(j == 1)
			return DOCH_AdapterNotFound;
		#endif /*DOCH_ASSUME_8KB_WINDOW*/

        if(j==0)    /*Try 8KB window*/
		{
            rc = doch_init_8kb(pdev, socketNo, initSocket);
			#ifdef DOCH_CHECK_CHIP_ID
			if(rc != DOCH_OK)
				continue;
			#endif /*DOCH_CHECK_CHIP_ID*/
		}
        else        /*Try 128KB window*/
		{
            rc = doch_init_128kb(pdev, socketNo, initSocket);
		}
        if(rc != DOCH_OK)
            return rc;

		/*Disable interrupts (will be enabled later per API decision)*/
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CONTROL_REG, DOCH_ATA_NIEN);

        for(i=0; i<ATA_MAX_NUM_OF_DEVICES; i++)
        {
			/* Reset ATA protocol to ensure device is ready for the next ATA command*/
            #if 1
			rc = doch_reset (socketNo, i);
			if(rc != DOCH_OK)
			{
				if((pdev->wNumOfDevices == 0) && (j>0))
                    return DOCH_DiskNotFound;
				break;
			}
            #endif

            tffsset(&ioreq, 0, sizeof(ioreq));
            DOCH_SET_SOCKET_TO_IOREQ_HANDLE(&ioreq, socketNo);
            pdev->bAtaDevNum = i;
            ioreq.irData = &gDiskOnChipDeviceInfo;

			/*Identify command with very short timeout, and "option1" on"
			(just check if the device responds, not all fields are valid!)*/
			ioreq.irCount = DOCH_IDENTIFY_EXISTANCE;
			if(i == 0) /*Perform existence test on Dev0 with LONG timeout*/
				gUseShortWaitOnBusy = DOCH_LONG_IDENTIFY_TIMEOUT;
			else
				gUseShortWaitOnBusy = DOCH_SHORT_IDENTIFY_TIMEOUT;
            rc = DOCHIdentifyDiskOnChipDeviceSingleFloor(&ioreq);
            gUseShortWaitOnBusy = 0;

			/*If the device was NOT identified (e.g. not existing) - return error*/
			if(rc != DOCH_OK)
			{
				if((pdev->wNumOfDevices == 0) && (j>0))
                    return DOCH_DiskNotFound;

				break;
			}

			/*If the device was WAS identified (e.g. exists) - perform full retrieval of device info data
			  without "option1" and with a longer timeout*/
			ioreq.irCount = DOCH_IDENTIFY_FROM_FLASH;
            gUseShortWaitOnBusy = DOCH_LONG_IDENTIFY_TIMEOUT;
            rc = DOCHIdentifyDiskOnChipDeviceSingleFloor(&ioreq);
            gUseShortWaitOnBusy = 0;

            if(rc == DOCH_OK)
            {
                pdev->wNumOfDevices++;
            }
            else
            {
                if((pdev->wNumOfDevices == 0) && (j>0))
                    return DOCH_DiskNotFound;

                break;
            }

            pdev->wTotalNumOfPartitions += pdev->device[i].wNumOfPartitions;
            pdev->nTotalCapacity        += gDiskOnChipDeviceInfo.dwUnformattedCapacity;
        } /* End loop search for number of floors */
        if(pdev->wNumOfDevices > 0)
            break; /* Found a device in 8KB - no need to try 128KB */
    } /* End loop try both 8KB and 128KB */
    /*Set ata Device Number back to 0...*/
    pdev->bAtaDevNum = 0;

	//DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\r\nFound #%d device(s)...\r\n\n"), pdev->wNumOfDevices));

    /*Set DPD mode as requested*/
    /*=========================*/
    tffsset(&ioreq, 0, sizeof(ioreq));

	/*If registered HAL is SPI, disable DPD*/
	if(gAccessLayerType == DOCH_AL_SPI)
	{
		gDpdSettings.activeMode = DOCH_WM_NORMAL;
		gDpdSettings.inActiveMode = DOCH_IM_IDLE;
	}

	/*1. Set both modes
	  2. If DOCH_IM_IDLE_2_DPD configured as Incative mode, force ETFFS
	     to enter Inactive mode after the command completes*/
    ioreq.irFlags  = DOCH_PM_SET_BOTH_MODES;
	if(gDpdSettings.inActiveMode == DOCH_IM_IDLE_2_DPD)
		ioreq.irFlags |= DOCH_PM_INACTIVE_MODE;

	/*3. Set Active/Inactive modes*/
    ioreq.irCount  = (gDpdSettings.activeMode | gDpdSettings.inActiveMode);
	/*4. Set Timeout*/
	ioreq.irLength = gDpdSettings.timeOut;

	for(i=0; i<pdev->wNumOfDevices; i++)
	{
		pdev->bAtaDevNum = i;
		rc = flDOCHSetPowerMode(&ioreq);
		if(rc != DOCH_OK)
			return rc;
	}
	/*Set ata Device Number back to 0...*/
	pdev->bAtaDevNum = 0;

    return DOCH_OK;
}



/*********************************************************/
/* Function name	: doch_release_socket*/
/* Description	    : calls to appropriated function     */
/*      to release all allocated memory / devices etc    */
/* Return type		: DOCH_Error  */
/* Argument         : int socketNo*/
/*********************************************************/
DOCH_Error  doch_release_socket( int socketNo )
{
#ifdef DOCH_USE_FUNC
	DOCH_Error status;
	DOCH_Socket* pdev;

	if(socketNo > DOCH_MAX_SOCKETS - 1)
		return DOCH_BadParameter;

    pdev = &sockets[socketNo];

    /* Un-register the socket */
	status = (DOCH_Error)(pdev->halRoutines.hal_doch_release(socketNo));

	/*Delete the mutex*/
	flDeleteMutex(&pdev->mutex);

	if(status != DOCH_OK)
		return DOCH_GeneralFailure;
#endif /*DOCH_USE_FUNC*/

	return DOCH_OK;
}/*doch_release_socket()*/

/******************************************************************************
 *                                                                            *
 *             D O C H _ i n i t _ c o n f i g _ r e g s                      *
 *                                                                            *
 *  Initialize configuration register in case of power loss                   *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo            : Socket # (0...DOCH_MAX_SOCKETS-1)               *
 *      devNum	            : Device # (0,1)					              *
 *                                                                            *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
DOCH_Error DOCH_init_config_regs(IOreq *ioreq)
{
	DOCH_Error rc;

	if(configRegValueSet.wEndianCtrlSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_ENDIAN_CTRL_REG, configRegValue.wEndianCtrl);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wIPLCtrlSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_IPL_CONTROL_REG, configRegValue.wIPLCtrl);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wPowerDownSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_POWER_DOWN_REG, configRegValue.wPowerDown);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wDMACtrlSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_DMA_CTRL_REG, configRegValue.wDMACtrl);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wSWLockSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_SW_LOCK_REG, configRegValue.wSWLock);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wOperationModeSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_OPERATION_MODE_REG, configRegValue.wOperationMode);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wBurstWriteModeCtrlSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_BURST_WRITE_MODE_CTRL_REG, configRegValue.wBurstWriteModeCtrl);
		if(rc != DOCH_OK)
			return rc;
	}

	if(configRegValueSet.wBurstReadModeCtrlSet)
	{
		rc = doch_setConfigReg16(ioreq, HIB_BURST_READ_MODE_CTRL_REG, configRegValue.wBurstReadModeCtrl);
		if(rc != DOCH_OK)
			return rc;
	}

	return DOCH_OK;
}


/******************************************************************************
 *                                                                            *
 *                      d o c h _ g e t _ d i s k                             *
 *                                                                            *
 *  Return pointer to device, by device number.			                      *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo            : Socket # (0...DOCH_MAX_SOCKETS-1)               *
 *      devNum	            : Device # (0,1)					              *
 *                                                                            *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
DOCH* DOCH_get_disk(FLSNative  socketNo, FLSNative  devNum)
{
	if(socketNo > (DOCH_MAX_SOCKETS-1))
		return NULL;
	else
		return &sockets[socketNo].device[devNum];
}

/******************************************************************************
 *                                                                            *
 *           d o c h _ s e t T r a n s f e r M o d e                          *
 *                                                                            *
 *  Sets data transfer mode								                      *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo            : Socket # (0...DOCH_MAX_SOCKETS-1)               *
 *		devNum				: ATA Device [0..1]								  *
 *		tm					: required data transfer mode:					  *
 *                             DOCH_DATA_MODE_SINGLE                          *
 *                             DOCH_DATA_MODE_MULT                            *
 *			                                                                  *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
DOCH_Error doch_setTransferMode (FLSNative  socketNo, FLSNative  devNum, DOCH_TransferMode tm, FLDword drqSize)
{
	if(socketNo > (DOCH_MAX_SOCKETS-1))
		return DOCH_BadParameter;
	else
	{
		sockets[socketNo].device[devNum].dataTransferMode	= tm;
		sockets[socketNo].device[devNum].dwMulti_Current	= drqSize;

	}

	return DOCH_OK;
}

/******************************************************************************
 *                                                                            *
 *           d o c h _ g e t T r a n s f e r M o d e                          *
 *                                                                            *
 *  Returns data transfer mode								                  *
 *                                                                            *
 *  Parameters :                                                              *
 *      socketNo            : Socket # (0...DOCH_MAX_SOCKETS-1)               *
 *                                                                            *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
DOCH_TransferMode doch_getTransferMode (FLSNative  socketNo, FLSNative  devNum)
{
	return sockets[socketNo].device[devNum].dataTransferMode;
}

/******************************************************************************
 *                                                                            *
 *		           d o c h _ s e t C o n f i g R e g 1 6					  *
 *                                                                            *
 *  Set DOCH 16Bit configuration register							          *
 *  Register values are maintained by a global structure of type			  *
 *	DOCH_ConfigRegsValue in order to alow recovery after power loss.		  *
 *                                                                            *
 *  Parameters :                                                              *
 *      base		  :		Registers base address							  *
 *      registerOffset:		Register offset					                  *
 *      registerValue :		Register Value			 						  *
 *                                                                            *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
DOCH_Error doch_setConfigReg16(IOreq* ioreq, FLDword registerOffset, FLNative registerValue)
{
	DOCH_Socket* pdev;

	DOCH_get_socket(pdev, DOCH_GET_SOCKET_FROM_IOREQ_HANDLE(ioreq));

	if(pdev == NULL)
		return DOCH_DiskNotFound;

	if(registerOffset == (FLDword)HIB_BURST_WRITE_MODE_CTRL_REG)
	{
		configRegValue.wBurstWriteModeCtrl		|= registerValue;
		configRegValueSet.wBurstWriteModeCtrlSet = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_BURST_READ_MODE_CTRL_REG)
	{
		configRegValue.wBurstReadModeCtrl		|= registerValue;
		configRegValueSet.wBurstReadModeCtrlSet  = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_IPL_CONTROL_REG)
	{
		configRegValue.wIPLCtrl			|= (registerValue | DOCH_IPL_WRITE_READY);
		configRegValueSet.wIPLCtrlSet	 = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_POWER_DOWN_REG)
	{
		configRegValue.wPowerDown		|= registerValue;
		configRegValueSet.wPowerDownSet  = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_DMA_CTRL_REG)
	{
		configRegValue.wDMACtrl			|= registerValue;
		configRegValueSet.wDMACtrlSet	 = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_SW_LOCK_REG)
	{
		configRegValue.wSWLock		|= registerValue;
		configRegValueSet.wSWLockSet = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_ENDIAN_CTRL_REG)
	{
		configRegValue.wEndianCtrl		|= registerValue;
		configRegValueSet.wEndianCtrlSet = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_DMA_NEGATION_REG)
	{
		configRegValue.wEndianNegation	|= registerValue;
		configRegValueSet.wEndianNegationSet = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_OPERATION_MODE_REG)
	{
		configRegValue.wOperationMode		|= registerValue;
		configRegValueSet.wOperationModeSet  = TRUE;
	}
	else if(registerOffset == (FLDword)HIB_POWER_MODE_REG)
	{
		/*Do nothing*/
	}
	else
	{
		return DOCH_BadParameter;
	}

	DOCHWRITE_CTRL_REG (pdev->bRegBase, registerOffset, registerValue);

	return DOCH_OK;
}

/******************************************************************************
 *                                                                            *
 *		           d o c h _ g e t C o n f i g R e g 1 6					  *
 *                                                                            *
 *  Returns DOCH 16Bit configuration register value							  *
 *                                                                            *
 *  Parameters :                                                              *
 *      registerOffset:		Register offset					                  *
 *                                                                            *
 *  Returns :                                                                 *
 *      Pointer to DOCH structure.						                      *
 *                                                                            *
 ******************************************************************************/
FLWord  doch_getConfigReg16(IOreq *ioreq, FLSNative  registerOffset)
{
    DOCH_Socket* pdev;

    DOCH_get_socket(pdev, DOCH_GET_SOCKET_FROM_IOREQ_HANDLE(ioreq));
    if(pdev == NULL)
      return 0;

    /*Read 16Bit register*/
    return DOCHREAD_CTRL_REG(pdev->bRegBase, registerOffset);
}

/******************************************************************************
 *                                                                            *
 *	          d o c h E n a b l e A T A I n t e r r u p t					  *
 *                                                                            *
 *  Enable/Disable ATA interrupt											  *
 *                                                                            *
 *  Parameters :                                                              *
 *      enable:		Enable ATA interrupt (TRUE/FALSE)		                  *
 *                                                                            *
 *  Returns :                                                                 *
 *      0 on success, otherwise error number.			                      *
 *                                                                            *
 ******************************************************************************/
DOCH_Error dochEnableATAInterrupt (FLDword socketNum, FLBoolean enable, FLByte type)
{
	FLNative     deviceNo;
	DOCH_Socket* pdev;
	DOCH_get_socket(pdev, socketNum);

	if(pdev == NULL)
		return DOCH_DiskNotFound;


    for(deviceNo = 0 ; deviceNo < pdev->wNumOfDevices ; deviceNo++)
	{
		if(enable && (gAccessLayerType != DOCH_AL_SIM))
		{
			pdev->device[deviceNo].flags |= DOCH_FLAGSB_USE_INTERRUPT;
		}
		else
		{
			pdev->device[deviceNo].flags &= ~DOCH_FLAGSB_USE_INTERRUPT;
		}
		DOCHWRITE_ATA_REG (pdev->bRegBase, DOCH_CONTROL_REG, ((enable) ? 0 : DOCH_ATA_NIEN ));
	}
	return DOCH_OK;
}

#ifdef __cplusplus
}
#endif
