/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/***********************************************************************************/
/*																				   */
/*	Header file for doch_ata module												   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/doch_ata.h-arc  $
 *
 *    Rev 1.28   Aug 09 2006 17:26:54   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 */

#ifndef DOCH_ATA_H
#define DOCH_ATA_H

#include "doch_sys.h"
//#include "doch_api.h"

#include "part_inf.h"

/*
 * macros
 * (also customizable for internal purpose)
 *
 */

/* 'long'  DOCH operations can take up to DOCH_LONG_WAIT milliseconds  */
#ifndef DOCH_LONG_WAIT
	#define DOCH_LONG_WAIT   500
#endif /*DOCH_LONG_WAIT*/

/* 'short' DOCH operations can take up to DOCH_SHORT_WAIT milliseconds */
#ifndef DOCH_SHORT_WAIT
	#define DOCH_SHORT_WAIT  450
#endif /*DOCH_SHORT_WAIT*/

/* "Very short wait" used for identifying device = 50ms */
#ifndef DOCH_SHORT_IDENTIFY_TIMEOUT
	#define DOCH_SHORT_IDENTIFY_TIMEOUT   (10L*1000000L/gDochAccessNanosec)
#endif /*DOCH_SHORT_IDENTIFY_TIMEOUT*/

/* "Longer" wait used for identifying device = 500ms */
#ifndef DOCH_LONG_IDENTIFY_TIMEOUT
	#define DOCH_LONG_IDENTIFY_TIMEOUT   (500L*1000000L/gDochAccessNanosec)
#endif /*DOCH_LONG_IDENTIFY_TIMEOUT*/

#ifndef DOCH_DEFAULT_SLEEP_PERIOD
	#define DOCH_DEFAULT_SLEEP_PERIOD		3000
#endif /* DOCH_DEFAULT_SLEEP_PERIOD */

/*#define ONE_SEC_IN_NANO_SEC	(1000000000 / gDochAccessNanosec)*/

/* maximum number of sectors which could be read from / written to DOCH at once */
#define DOCH_MAX_SECTORS  256

/*ATA device definitions*/
#define DOCH_ATA_MASTER_DEV 0		/* master device only */
#define DOCH_ATA_SLAVE_DEV	1		/* slave device only */
#define DOCH_ATA_ALL_DEVS   0xff	/* all devices */

#define ATA_NO_ERR			0 /* no error on ATA command */

#define DOCH_ATA_MAX_TIMEOUT 0xFFFFFFFF

/* Access Layer Types */
typedef enum {
	DOCH_AL_NONE	= 0xCAF0,
	DOCH_AL_NOR		= 0xCAF1,
	DOCH_AL_SPI		= 0xCAF2,
	DOCH_AL_USER	= 0xCAF3,
	DOCH_AL_SIM		= 0xCAF4
} DOCH_AccessLayerType;

/*	Optional bits in DOCH_DRIVE_HEAD_REG	*/
#define DRIVE_HEAD_OPT1 0x80
#define DRIVE_HEAD_OPT2 0x20

/*	Pattern to add to DOCH_DRIVE_HEAD_REG to 	*/
/*Option1*/
#define CUSTOM_PARAM_TEMP		DRIVE_HEAD_OPT1	/*Temporary value*/
#define CUSTOM_PARAM_DEFAULT	0				/*DEFAULT value*/
#define PERM_DEFAULT_PART_OP	DRIVE_HEAD_OPT1	/*Permanently set default partition number*/
#define PREPARE_FOR_WRITE_OP	0
#define REWRITE_NORMAL_OP		DRIVE_HEAD_OPT1
#define WRITE_NORMAL_OP			DRIVE_HEAD_OPT1
#define HASH_AS_IS				0
#define HASH_BY_KEY				DRIVE_HEAD_OPT1
#define DELETE_PARTITIONS_FAST  0
#define DELETE_PARTITIONS_COMPLETE DRIVE_HEAD_OPT1
/*Option2*/
#define ERASE_NORMAL			0
#define ERASE_IMMEDIATE			DRIVE_HEAD_OPT2


typedef enum { DOCH_4BITS		= 0,	/*TBD*/
			   DOCH_ATA_NIEN	= 2,
			   DOCH_ATA_SRST	= 4
} DOCH_control_reg;

/*	Data transfer modes	*/
typedef enum { DOCH_DATA_MODE_SINGLE			= 0x00,
			   DOCH_DATA_MODE_MULT				= 0x01
} DOCH_TransferMode;

/*	Atomic write sequence control	*/
typedef enum { DOCH_START_ATOMIC_WRITE		= 0x00,
			   DOCH_FINISH_ATOMIC_WRITE		= 0x01,
			   DOCH_ABORT_ATOMIC_WRITE		= 0x02
} DOCH_AtomicSeqCtrl;

#if 0
/* set of DOCH Vendor-Specific ATA Commands */
typedef enum {
			   /*I/O*/
			   DOCH_VSCMD_READ_PARTITION		= 0x82,
               DOCH_VSCMD_WRITE_PARTITION		= 0x83,
			   DOCH_VSCMD_WRITE_FLEXI			= 0x84,

			   /*Sectors Operations*/
			   DOCH_VSCMD_OPTIMIZE_PARTITION_SECTORS	= 0x86,
			   DOCH_VSCMD_ERASE_PARTITION_SECTORS		= 0x88,

			   /*Hash*/
			   DOCH_VSCMD_READ_CALCULATED_HASH	= 0x8A,
			   DOCH_VSCMD_WRITE_CALCULATED_HASH	= 0x8B,
			   DOCH_VSCMD_READ_ORIGINAL_HASH	= 0x8C,
			   DOCH_VSCMD_WRITE_GIVEN_HASH		= 0x8D,

			   /*Sub-commanded commands*/
			   DOCH_VSCMD_PARTITION_MANAGEMENT	= 0xFA,
			   DOCH_VSCMD_ACCESS_CONTROL		= 0xFB,
               DOCH_VSCMD_EXT_DEVICE_CTRL		= 0xFC,
               DOCH_VSCMD_EXT_SECURITY_CTRL		= 0xFD,

			   /*Supported standard ATA commands*/
			   DOCH_CMD_IDENTIFY_DEV            = 0xEC,
			   DOCH_DOWNLOAD_MICROCODE			= 0x92

} DOCH_Command;
#endif

/* set of operation codes for DOCH_VSCMD_PARTITION_MANAGEMENT command */
typedef enum {
			   DOCH_GET_PARTITION_INFO			= 0x00,
			   DOCH_SET_DEFAULT_PARTITION		= 0x11,
			   DOCH_SET_PARTITION_PROTECTION	= 0x18,
			   DOCH_GET_PARTITION_USER_ATTR		= 0x70,
			   DOCH_SET_PARTITION_USER_ATTR		= 0x71,
			   DOCH_DELETE_PARTITIONS			= 0xB0,
			   DOCH_ADD_PARTITION				= 0xB4,
			   DOCH_SECURE_ERASE				= 0xB8
} DOCH_PartitionManageOp;

/* set of operation codes for DOCH_VSCMD_ACCESS_CONTROL command */
typedef enum {
			   DOCH_EN_ACCESS_WPWD				= 0x30,
			   DOCH_DISABLE_ACCESS				= 0x31,

			   /*Enable access with challange/response protocol*/
			   DOCH_TX_HOST_PUBLICKEY			= 0x32,
			   DOCH_RX_DOCH_PUBLICKEY			= 0x33,
			   DOCH_VERIFY_HOST_KEY				= 0x34
} DOCH_AccessCtrlOp;

/* set of operation codes for DOCH_VSCMD_EXT_DEVICE_CTRL command */
typedef enum {
			   DOCH_IDENTIFY_DISKONCHIP_DEVICE	= 0x00,
			   DOCH_GET_EXTENDED_DEVICE_INFO	= 0x01,
			   DOCH_SET_DATA_XFER_MODE			= 0x10,
			   DOCH_ATOMIC_WRITE_SEQUENCE		= 0x20,
			   DOCH_OPTIMIZE_MEDIA				= 0x30,
			   DOCH_GET_CUSTOM_PARAM			= 0x40,
			   DOCH_SET_CUSTOM_PARAM			= 0x41,
			   DOCH_CALIBRATE_CLOCK				= 0x50,
			   DOCH_GET_POWER_MODE				= 0x60,
			   DOCH_SET_POWER_MODE				= 0x61,
			   DOCH_GET_DISK_USER_ATTR			= 0x70,
			   DOCH_SET_DISK_USER_ATTR			= 0x71,
			   DOCH_GET_CONFIGURATION_DATA		= 0x72,
			   DOCH_SET_CONFIGURATION_DATA		= 0x73,
			   DOCH_ACTIVATE_DEBUG_MODE			= 0x7C,
			   DOCH_RETRIEVE_DBG_MSG			= 0x7E,
			   DOCH_SET_ALERT_LEVEL				= 0x7F,
   			   DOCH_GET_RESET_STATUS			= 0x80,
			   DOCH_NOTIFY_PLATFORM_RESUMED		= 0x8E,
			   DOCH_NOTIFY_RESET				= 0x8F
} DOCH_DeviceCtrlOp;

/* set of operation codes for DOCH_VSCMD_EXT_SECURITY_CTRL command */
typedef enum {
			   DOCH_REPORT_SUPPORTED_ALGORITHMS	= 0x00,
			   DOCH_GET_ALGORITHM_CAPABILITIES	= 0x01,
			   DOCH_SET_ALGORITHM_MODE			= 0x02,
			   DOCH_RETURN_RANDOM_NUMBERS		= 0x10,
			   DOCH_AUTO_HASH_CONTROL			= 0x40,
			   DOCH_SET_KEYS					= 0x48,
			   DOCH_START_HASH_STREAM_CALC		= 0x50,
			   DOCH_READ_STOP_HASH_STREAM_CALC	= 0x51
} DOCH_SecurityCtrlOp;

/* set of operation codes for DOCH_VSCMD_CRYPTO_CONTROL command */
typedef enum { DOCH_HASH_NO_ENCRYPTION	= 0x00,
               DOCH_HASH_ENCRYPT_BY_KEY	= 0x01
} DOCH_HashEncrypt_Op;

/* bits in DOCH_STATUS_REG and DOCH_ALT_STATUS_REG registers */
#define DOCH_ERROR      0x01
#define DOCH_DRQ        0x08
#define DOCH_DSC        0x10
#define DOCH_READY      0x40
#define DOCH_BUSY       0x80

/* bits in DOCH_STATUS_REG and DOCH_ALT_STATUS_REG registers */
#define DOCH_ERR_REG_BIT0	0x01;
#define DOCH_ERR_REG_BIT1	0x02;
#define DOCH_ERR_REG_ABRT	0x04;
#define DOCH_ERR_REG_BIT3	0x08;
#define DOCH_ERR_REG_BIT4	0x10;
#define DOCH_ERR_REG_BIT5	0x20;
#define DOCH_ERR_REG_BIT6	0x40;
#define DOCH_ERR_REG_BIT7	0x80;

/* bits for DOCH_DRIVE_HEAD_REG register */
#define DOCH_DEVICE     0x10
#define DOCH_LBA        0x40
#define DOCH_DRIVE_HEAD 0xA0

/* DOCH configuration bits (IDENTIFY_DEVICE Word#0)	*/
#define DOCH_ATAPI      0x8000
#define DOCH_REMOVABLE  0x0080
#define DOCH_FIXED      0x0040

/*	IDENTIFY DEVICE data	*/
/*==========================*/
typedef struct {
	FLWord	wGeneralConfiguration;
	FLWord	wDefaultNumberOfCylinders;	/*1*/
	FLWord	wSpecificConfiguration;		/*ATA-5*/
	FLWord	wDefaultNumberOfHeads;		/*3*/
	FLDword	dwReserved2;
	FLWord	wDefaultSectorsPerTrack;	/*6*/
	FLWord	wReserved1[3];
	FLByte	bSerialNumber[20];			/*10*/
	FLWord	wReserved4[2];
	FLWord	wVsFLBytesInReadWriteLONG;	/*obsolete in ata-5*/
	FLByte	bFirmwareRevision[8];		/*23*/
	FLByte	bModelNumber[40];			/*27*/

	FLByte	bReserved3;					/*47	ata-4+ : must be 0x80*/
	FLByte	bMaxSectorsPerMulti;

	FLWord	wReserved5;
	FLWord	wCapabilities;				/*49*/
	FLWord	wCapabilities2;				/*ata-4*/

	FLByte	bPIOTransferTiming;			/*51	obsolete in ATA-5*/
	FLByte	bReserved6a;

	FLWord	wReserved7;					/*was (single-word?) DMA Timing in ATA-2*/
	FLWord	wWordSupported;				/*53*/
	FLWord	wCurrentNumberOfCylinders;	/*54*/
	FLWord	wCurrentNumberOfHeads;		/*55*/
	FLWord	wCurrentSectorPerTrack;		/*56*/

	FLWord	wCurrentCapacityInSectorsLow;	/*57*/
	FLWord	wCurrentCapacityInSectorsHigh;	/*58*/

	FLByte	bMultipleSectorSettingValid;	/*59*/
	FLByte	bMultipleSectorCurrentNumber;

	FLWord	wTotalNumberOfSectorsLow;	/*60*/
	FLWord	wTotalNumberOfSectorsHigh;	/*61*/

	FLWord	wReserved8;	/*was singlewordDMASelect+Support in ATA-2*/

	FLByte	bMultiwordDMASelected;		/*63*/
	FLByte	bMultiwordDMASupported;

	FLByte	bReserved9;					/*64*/
	FLByte	bAdvancedPIOsupported;

	FLWord	wMinDMACycleTimePerWord;
	FLWord	wRecommndedMinDMACycleTimePerWord;
	FLWord	wMinPIOCycleTimeWithoutFlowControl;
	FLWord	wMinPIOCycleTimeWithIORDY;
	FLWord	wReserved10[6];

	FLWord	wQueueDepth;				/*75	ata-4*/
	FLWord	wReserved11[4];

	FLWord	wMajorVersionNumber;		/*80*/
	FLWord	wMinorVersionNumber;
	FLWord	wCommandSetsupported1;		/*82*/
	FLWord	wCommandSetsupported2;

	FLWord	wCommandSetFeatureExtension;	/*84	ata-4*/
	FLWord	wCommandSetFeatureEnabled1;		/*ata-4*/
	FLWord	wCommandSetFeatureEnabled2;		/*86	ata-4*/
	FLWord	wCommandSetFeatureDefault;		/*ata-4*/

	FLByte	bUltraDMASelected;				/*88	ata-4*/
	FLByte	bUltraDMASupported;

	FLWord	wTimeForSecurityEraseCompletion;			/*ata-4*/
	FLWord	wTimeForEnhancedSecurityEraseCompletion;	/*90	ata-4*/

	FLWord	wCurrentAdvancedPowerManagementValue;		/*ata-4*/

	FLWord	wMasterPasswordRevision;					/*92	ata-5*/
	FLWord	wHardwareResetResult;						/*ata-5*/

	FLWord	wReserved12[33];

	FLWord	wRemovableMediaNotificationSupport;	/*127	ata-4*/

	FLWord	wSecurityStatus;					/*128, i.e. 127 words left*/
	FLWord	wVendorSpecific[31];				/*129-159*/
	FLWord	wCFApowermode1;
	FLWord	wCFAreserved[15];
	FLWord	wCurrentMediaSerialNumber[30];

	FLWord	wReserved13[49];

	FLWord	wIntegrityWord;
} DOCH_DriveParameters;

typedef struct {
	FLSDword activeMode;
	FLSDword inActiveMode;
	FLSDword timeOut;
} DOCH_DpdSettings;


/*IDENTIFY DEVICE information bits*/
/*================================*/

/*for generalConfiguration*/
#define GENERAL_CONFIG_ATAPI				0x8000	/*otherwise ATA*/
#define GENERAL_CONFIG_REMOVABLE_MEDIA		0x80	/*otherwise not*/
#define GENERAL_CONFIG_NON_REMOVABLE_DRIVE	0x40	/*and/or device*/
#define GENERAL_CONFIG_RESPONSE_INCOMPLETE	0x04	/*ATA-5*/

/*for specificConfiguration*/
#define	DEVICE_REQUIRES_SET_FEATURES_ID_INCOMPLETE		0x37C8
#define	DEVICE_REQUIRES_SET_FEATURES_ID_COMPLETE		0x738C
#define	DEVICE_NOT_REQUIRE_SET_FEATURES_ID_INCOMPLETE	0x8C73
#define	DEVICE_NOT_REQUIRE_SET_FEATURES_ID_COMPLETE		0xC837

/*for capabilities*/
#define CAPABILITY_STANDBY_TIMER_AS_IN_STANDARD	0x2000	/*1<<13*/
#define CAPABILITY_IORDY_SUPPORTED				0x0800	/*1<<11*/
#define CAPABILITY_IORDY_CAN_BE_DISABLED		0x0400	/*1<<10*/
#define CAPABILITY_MUST							0x0300	/*just must be*/

/*for capabilities2*/
#define CAPABILITY2_MUST								0x4000
#define CAPABILITY2_DEVICE_HAS_STANDBY_TIMER_MINIMUM	0x0001

/*for wordSupported*/
#define FIELDS54_58_VALID			1	/*geometry*/
#define FIELDS64_70_VALID			2	/*timing*/
#define FIELD88_VALID				4	/*ATA-4: Ultra-DMA modes*/

/*for multipleSectorSetting*/
/*#define MULTI_SECTOR_SETTING_CORRECT		0x100*/

/*for multiwordDma*/
#define MULTI_WORD_DMA_0			1
#define MULTI_WORD_DMA_1			2
#define MULTI_WORD_DMA_2			4	/*ATA-4*/
/*dma 'selected' - one bit*/
/*dma 'supported' - also one bit, but with ATA-4/5 it MUST support*/
/*all modes below. AND must have their bits in 1 too.*/

/*for advancedPIOsupported; 1 for pio3 3 for pio4*/
#define ADVANCED_PIO_3_SUPPORTED		1
#define ADVANCED_PIO_4_SUPPORTED		2


/*for majorVersionNumber*/
#define SUPPORTS_ATA_1			2
#define SUPPORTS_ATA_2			4
#define SUPPORTS_ATA_3			8
#define SUPPORTS_ATA_4			0x10
#define SUPPORTS_ATA_5			0x20

/*for minorVersionNumber*/
#define ATA3_PUBLISHED			0x0A
#define ATA_ATAPI4_PUBLISHED	0x12
#define ATA_ATAPI5_PUBLISHED	0x18
/*#error download last draft & find out!*/

/*for commandSetsupported1, commandSetFeatureEnabled1*/
#define SUPPORTS1_SMART					0x01
#define SUPPORTS1_SECURITY				0x02
#define SUPPORTS1_REMOVABLE				0x04
#define SUPPORTS1_POWER_MANAGEMENT		0x08
#define SUPPORTS1_PACKET_COMMAND		0x10			/*ATA-4. ATA-5: must be zero*/
#define SUPPORTS1_WRITE_CACHE			0x20			/*ATA-4*/
#define SUPPORTS1_LOOK_AHEAD			0x40			/*ATA-4*/
#define SUPPORTS1_RELEASE_INTERRUPT		0x80			/*ATA-4*/
#define SUPPORTS1_SERVICE_INTERRUPT		0x100			/*ATA-4*/
#define SUPPORTS1_DEVICE_RESET_CMD		0x200			/*ATA-4*/
#define SUPPORTS1_HOST_PROTECTED_AREA_FEATURE	0x400	/*ATA-4*/
#define SUPPORTS1_WRITE_BUFFER			0x1000			/*ATA-4*/
#define SUPPORTS1_READ_BUFFER			0x2000			/*ATA-4*/
#define SUPPORTS1_NOP					0x4000			/*ATA-4*/
/*1<<11	obsolete*/
/*1<<15	obsolete*/

/*for commandSetsupported2, commandSetFeatureEnabled2*/
#define SUPPORTS2_MUST							0x4000
#define SUPPORTS2_DOWNLOAD_MICROCODE			0x01	/*ATA-4*/
#define SUPPORTS2_READ_WRITE_DMA_QUEUED			0x02	/*ATA-4*/
#define SUPPORTS2_CFA_FEATURE					0x04	/*ATA-4*/
#define SUPPORTS2_ADVANCED_POWER_MANAGEMENT		0x08	/*ATA-4*/
#define SUPPORTS2_REMOVABLE_MEDIA_NOTIFICATION	0x10	/*ATA-4*/
#define SUPPORTS2_POWERUP_IN_STANDBY			0x20	/*ATA-5*/
#define SUPPORTS2_NEEDS_SET_FEATURES_TO_SPIN	0x40	/*ATA-5*/
#define SUPPORTS2_ADDRESS_OFFSET_RESERVED_BOOT	0x80	/*ATA-5*/
#define SUPPORTS2_SET_MAX_SECURITY_EXTENSION	0x100	/*ATA-5*/

/*for commandSetFeatureExtension, commandSetFeatureDefault*/
#define CMDSET_EXTENSION_MUST			0x4000

/*for ultraDma*/
#define ULTRA_DMA_0			1
#define ULTRA_DMA_1			2
#define ULTRA_DMA_2			4
#define ULTRA_DMA_3			8		/*ATA-5*/
#define ULTRA_DMA_4			0x10	/*ATA-5*/
/*selected: one, supported: one and below*/

/*for hardwareResetResult (ATA-5)*/
#define HARDRESET_RESULT_MUST			0x4101

#define HARDRESET_CBLID_ABOVE_VIH		0x2000

#define HARDRESET_DEVICE_0_JUMPER		0x02
#define HARDRESET_DEVICE_0_CSEL			0x04
#define HARDRESET_DEVICE_0_OTHER		0x06

#define HARDRESET_DEVICE_0_PASSED_DIAGNOSTICS	0x08
#define HARDRESET_DEVICE_0_DETECTED_PDIAG		0x10
#define HARDRESET_DEVICE_0_DETECTED_DASP		0x20
#define HARDRESET_DEVICE_0_RESPONDS_FOR_1		0x40

#define HARDRESET_DEVICE_1_JUMPER		0x200
#define HARDRESET_DEVICE_1_CSEL			0x400
#define HARDRESET_DEVICE_1_OTHER		0x600

#define HARDRESET_DEVICE_1_ASSERTED_PDIAG	0x800

/*for removableMediaNotificationSupport*/
#define REMOVABLE_MEDIA_STATUS_NOTIFICATION_SUPPORTED		1

/*for securityStatus*/
#define SECURITY_MAXIMUM					0x100	/*otherwise HIGH*/
#define SECURITY_ENCHANCED_ERASE_SUPPORTED	0x20	/*ATA-4*/
#define SECURITY_COUNT_EXPIRED				0x10
#define SECURITY_FROZEN						0x08
#define SECURITY_LOCKED						0x04
#define SECURITY_ENABLED					0x02
#define SECURITY_SUPPORTED					0x01

typedef struct {
	FLByte bReserved[0x200];
} DOCH_DeviceAttributes;

/* long-word-aligned buffer */
typedef union { unsigned char  cbuf [DOCH_SECTOR_SIZE];
                unsigned short sbuf [DOCH_SECTOR_SIZE / sizeof(short)];
                unsigned long  lbuf [DOCH_SECTOR_SIZE / sizeof(long)];
} DOCH_Buf;

#define DOCH_CHIP_ID_H3	0x4833
#define DOCH_CHIP_ID_H4	0x4834
#define DOCH_CHIP_ID_H5	0x4835

/* Runtime configuration flags*/
/*DOCH Flags Offsets*/
#define	DOCH_FLAGSO_USE_CHS			0
#define	DOCH_FLAGSO_USE_DMA_READ	1
#define	DOCH_FLAGSO_USE_DMA_WRITE	2
#define	DOCH_FLAGSO_USE_INTERRUPT	3

/*DOCH Flags Bits*/
#define	DOCH_FLAGSB_USE_CHS			0x00000001	/* use Cyl/Head/Sector block addressing */
#define	DOCH_FLAGSB_USE_DMA_READ	0x00000002	/* use h/w DMA when reading sectors     */
#define	DOCH_FLAGSB_USE_DMA_WRITE	0x00000004	/* use h/w DMA when writing sectors     */
#define	DOCH_FLAGSB_USE_INTERRUPT	0x00000008	/* use DOCH interrupt                   */

/* single DOCH device */
typedef struct {
				 DOCH_DriveParameters	  driveParameters;		/* ATA::IDENTIFY DEVICE data	*/
				 FLWord					  wNumOfPartitions;
				 FLWord					  wOtpToParition[DOCH_MAX_PARTITIONS];	/*Conversion table*/
                 FLDword				  flags;
                 FLDword				  dwMulti_read;
                 FLDword				  dwMulti_write;
                 FLDword				  dwMulti_Current;
                 DOCH_TransferMode        dataTransferMode;
} DOCH;

typedef struct
{
  volatile FLByte        *bRegBase;
  FLByte                 bAtaDevNum;                         /* Indicates which ATA device to send command to (0..1)      */
  FLDword                dwPhysicalAddress;                  /* NOT USED, returned by the SDK by a specific API           */
  FLWord                 wSocketNo;                          /* [0.. DOCH_MAX_SOCKETS-1]                                  */
  FLMutex                mutex;                              /* Mutex for the socket                                      */
  FLBoolean              bUseInterrupt;                      /* Wait on interrupt                                         */
  FLBoolean              bUseDMA;                            /* Use DMA for current data xfer                             */
  FLBoolean              bUseBurst;                          /* Use Burst for current data xfer                           */
  FLWord                 wNumOfDevices;                      /* 2 if device #1 exist                                      */
  FLNative               nTotalCapacity;
  FLWord                 wTotalNumOfPartitions;              /* In both devices                                           */
  DOCH_PartitionAttr     partitionAttr[DOCH_MAX_PARTITIONS]; /* Partitions attributes                                     */
  FLWord                 wLastPartitionSpanned;              /* Last partition of device #0 spans to device #1            */
  DOCH                   device[ATA_MAX_NUM_OF_DEVICES];     /* ATA device #0, #1                                         */
  DOCH_HALRoutnies       halRoutines;                        /* HAL routines structure                                    */
  DOCH_PartitionSpanData sSpanData;                          /* Span data as retrieved from Device User Attributes sector */
} DOCH_Socket;

/*	structure that holds addressing data (CHS/LBA)	*/
typedef struct {
				 FLByte  bSecNum;
				 FLByte  bCylLow;
				 FLByte  bCylHi;
				 FLByte  bDevHead;
} Addressing_Values_s;

typedef enum {
				DOCH_MULTI_DISABLED = 0,
				DOCH_MULTI_ENABLED	= 1
} DOCH_multReadOp;

extern DOCH_Socket sockets [DOCH_MAX_SOCKETS];

#define DOCH_get_socket(pdev, socketNo) \
	if(socketNo > (DOCH_MAX_SOCKETS-1))	\
		pdev = NULL;					\
	else								\
		pdev = &sockets[socketNo];


#ifdef __cplusplus
extern "C" {
#endif
/* API routines */
extern DOCH* DOCH_get_disk(FLSNative  socketNo, FLSNative  devNum);
extern DOCH_Error doch_init_socket (FLSNative  socketNo, DOCH_InitSocket);
extern DOCH_Error doch_get_flags (FLSNative  socketNo, FLSNative  devNum, FLDword* flags);
extern DOCH_Error doch_set_flags (FLSNative  socketNo, FLSNative  devNum, FLDword  flags);
extern DOCH_Error doch_command   (FLSNative  socketNo, FLSNative  devNum, DOCH_Registers* in_regs, DOCH_Registers* out_regs, void* buf, FLNative secNum);
extern DOCH_Error doch_reset (FLSNative  socketNo, FLSNative  devNum);
extern DOCH_Error doch_setTransferMode (FLSNative  socketNo, FLSNative  devNum, DOCH_TransferMode tm, FLDword drqSize);
extern DOCH_TransferMode doch_getTransferMode (FLSNative  socketNo, FLSNative  devNum);
extern DOCH_Error doch_setConfigReg16(IOreq* ioreq, FLDword  registerOffset, FLNative registerValue);
extern FLWord  doch_getConfigReg16(IOreq *ioreq, FLSNative  registerOffset);
extern DOCH_Error DOCH_init_config_regs(IOreq *ioreq);
extern DOCH_Error clearATAInterrupt(FLSNative socketNo);


extern DOCH_Error doch_ata_passthru ( FLSNative               socketNo,
									  FLSNative 			   devNum,
									  DOCH_PassThru_Op ptOP,
									  DOCH_Registers * in_regs,
									  DOCH_Registers * out_regs,
									  void           * buf,
									  FLNative	    secNum
									);

extern DOCH_Error update_device_info(DOCH_Socket* pdev,
									 DOCH_DeviceInfo* diskOnChipDeviceInfo,
									 int devNum);

extern DOCH_Error dochEnableATAInterrupt (FLDword socketNum, FLBoolean enable, FLByte type);

DOCH_Error dochCheckPFSymptom(FLSNative socketNo, FLByte devNum, FLBoolean beforOrAfterCommand /* Used for debug prints */);

#define WAIT_FOR_UPLOAD_MAX_CYCLES	100

#ifdef __cplusplus
}
#endif

#endif /* DOCH_ATA_H */
