/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/doch_func.h-arc  $
 *
 *    Rev 1.18   Aug 09 2006 17:26:54   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 */

#ifndef DOCH_FUNC_H
#define DOCH_FUNC_H

#include "flcommon.h"
#include "doch_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/*Get Info*/
DOCH_Error DOCHIdentifyDiskOnChipDevice(IOreq* ioreq);
DOCH_Error DOCHGetResetStatus(IOreq* ioreq);
DOCH_Error DOCHNotifyReset(IOreq* ioreq);
DOCH_Error DOCHNotifyPlatformResumed(IOreq* ioreq);
DOCH_Error DOCHPartitionInfo(IOreq* ioreq);
DOCH_Error DOCHSetDiskUserAttributes(IOreq* ioreq);
DOCH_Error DOCHGetDiskUserAttributes(IOreq* ioreq);
DOCH_Error DOCHGetConfigurationData(IOreq* ioreq);
DOCH_Error DOCHSetConfigurationData(IOreq* ioreq);

/*Media*/
DOCH_Error DOCHSetDefaultPartition(IOreq* ioreq);
DOCH_Error DOCHSetDataTransferMode(IOreq* ioreq);
DOCH_Error DOCHOptimizeMedia(IOreq* ioreq);
DOCH_Error DOCHDeletePartitions(IOreq* ioreq);
DOCH_Error DOCHAddPartition(IOreq* ioreq);
DOCH_Error DOCHUnformatDevice(IOreq* ioreq);
DOCH_Error DOCHWriteIPL(IOreq* ioreq);
DOCH_Error DOCHReadIPL(IOreq* ioreq);

/*IO*/
DOCH_Error DOCHReadPartitionSectors(IOreq* ioreq);
DOCH_Error DOCHWritePartitionSectors(IOreq* ioreq);
DOCH_Error DOCHWriteAndLock(IOreq* ioreq);
DOCH_Error DOCHWipeSectors(IOreq* ioreq);
DOCH_Error DOCHFreeSectors(IOreq* ioreq);
DOCH_Error DOCHPrepareForWrite(IOreq* ioreq);

/*Flexi-Flash*/
DOCH_Error DOCHWriteFlexiFast(IOreq* ioreq);
DOCH_Error DOCHWriteFlexiNormal(IOreq* ioreq);
DOCH_Error DOCHReWriteFlexiNormal(IOreq* ioreq);

/*Protection*/
DOCH_Error DOCHAccessPartWithPwd(IOreq* ioreq);
DOCH_Error DOCHDisablePartAccess(IOreq* ioreq);
DOCH_Error DOCHSetParitionProtection(IOreq* ioreq);

/*PKI*/
DOCH_Error DOCHSendHostPublicKey(IOreq* ioreq);
DOCH_Error DOCHReceiveDochPublicKey(IOreq* ioreq);
DOCH_Error DOCHVerifyHostKey(IOreq* ioreq);

/*Custom Parameters*/
DOCH_Error DOCHGetCustomParameter(IOreq* ioreq);
DOCH_Error DOCHSetCustomParameter(IOreq* ioreq);

/*Atomic Read/Write Sequence*/
DOCH_Error DOCHManageAtomicWriteSeq(IOreq* ioreq);

/*Algorithms*/
DOCH_Error DOCHReportSupportedAlgorithms(IOreq* ioreq);
DOCH_Error DOCHGetAlgorithmCapabilities(IOreq* ioreq);
DOCH_Error DOCHSetAlgorithmMode(IOreq* ioreq);

/*Hash*/
DOCH_Error DOCHAutoHashControl(IOreq* ioreq);
DOCH_Error DOCHReadCalculatedHash(IOreq* ioreq);
DOCH_Error DOCHWriteCalculatedHash(IOreq* ioreq);
DOCH_Error DOCHReadOriginalHash(IOreq* ioreq);
DOCH_Error DOCHWriteGivenHash(IOreq* ioreq);
DOCH_Error DOCHStartHashStreamCalculation(IOreq* ioreq);
DOCH_Error DOCHReadStopHashStreamCalc(IOreq* ioreq);
DOCH_Error DOCHReturnRandomNumbers(IOreq* ioreq);
DOCH_Error DOCHSetHashKey(IOreq* ioreq);

/*General*/
DOCH_Error DOCHSetParitionUserAttributes(IOreq* ioreq);
DOCH_Error DOCHGetParitionUserAttributes(IOreq* ioreq);
DOCH_Error DOCHSetPowerMode(IOreq* ioreq);
DOCH_Error DOCHGetPowerMode(IOreq* ioreq);
DOCH_Error DOCHConfigHW(IOreq* ioreq);
DOCH_Error DOCHRecoverFromPowerLoss(IOreq* ioreq);
DOCH_Error DOCHClearIRQ(IOreq* ioreq);
DOCH_Error DOCHGetPhysicalAddress(IOreq* ioreq);

#ifdef __cplusplus
}
#endif

#endif /*DOCH_FUNC_H*/

