/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/***********************************************************************************/
/*																				   */
/*	Header file for doch_sys module												   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/doch_sys.h-arc  $
 *
 *    Rev 1.14   Aug 09 2006 17:26:54   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.13.1.0   Aug 08 2006 15:55:26   Polina.Marimont
 * DOC Driver 1.0 initial
 *
 *    Rev 1.13   May 18 2006 14:41:20   polina.marimont
 * v1.40Fin1, PVCS log inside
 */

#ifndef DOCH_SYS_H
#define DOCH_SYS_H

#include "flcustom.h"


/*
 * Access Layer API
 */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	unsigned char	(*hal_get_ata_reg)	(volatile unsigned char *base, int reg);
	void			(*hal_set_ata_reg)	(volatile unsigned char *base, int reg, unsigned int val);
	unsigned short	(*hal_get_ctrl_reg)	(volatile unsigned char *base, int reg);
	void			(*hal_set_ctrl_reg)	(volatile unsigned char *base, int reg, unsigned int val);
	int				(*hal_blk_read)		(volatile unsigned char *base, unsigned char *buf, int sectors);
	int				(*hal_blk_write)	(volatile unsigned char *base, unsigned char *buf, int sectors);
	int				(*hal_doch_release)	(int socketNo);
} DOCH_HALRoutnies;

#ifdef __cplusplus
}
#endif
#ifdef FL_MIGRATION_VERSION

#ifndef DOCH_USE_FUNC
#include "defs.h"
extern FLFlash * DOCHFlash;
#endif /* DOCH_USE_FUNC */

#endif /*FL_MIGRATION_VERSION*/

#endif /* DOCH_SYS_H */




