/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

/*This file holds necessary routines for integrating sureFS over DOCH SDK*/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/version 7.0/TrueFFS FS/src/h3/dochstub.c-arc  $
 *
 *    Rev 1.10   Aug 09 2006 17:26:54   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.9.1.0   Aug 08 2006 15:55:26   Polina.Marimont
 * DOC Driver 1.0 initial
 */

#include "msys.h"
#include "msys_custom.h"

#include "flbase.h"
#include "flstruct.h"
#ifdef FL_MIGRATION_VERSION
#include "bddefs.h"
#else /*FL_MIGRATION_VERSION*/
#include "fsdefs.h"
#endif /*FL_MIGRATION_VERSION*/
#include "dochtl.h"
#include "doch_sys.h"
#include "doch_api.h"


FLMutex busy[DOCH_MAX_SOCKETS];
FLBoolean dochStubInitialized = 0;
/*===========================*/

FLStatus dochSetBusy(FLByte socket, FLBoolean state, FLByte  partition)
{
	FLStatus status = flOK;

	if (state == FL_ON) /* Set busy to ON */
	{
		if (!flTakeMutex(&busy[socket]))
		{
		  // DBG_PRINT_FLOW_PRM(FLZONE_ATA, (FLTXT("\r\ndochSetMutex Failed to set mutex\r\n")));
		   return flDriveNotAvailable;
		}
	}
	else  /* Set busy to OFF */
	{
		flFreeMutex(&busy[socket]);
	}

	return status;
}

// this routine appears to be un-needed for now, and causes more code to be pulled in...
//------------------------------------------------------------------------------------------
#if 0
void setTL(FLByte socket, FLByte partition, TL * tl)
{
    FLNative i;
    if (dochStubInitialized != TRUE)
    {
        dochStubInitialized = TRUE;
        for (i = 0; i < DOCH_MAX_SOCKETS ; i ++)
            flCreateMutex(&busy[i]);
    }
	getDochTL(tl, partition);
}
#endif

#ifndef FL_MIGRATION_VERSION

/* ----------------------------------------------------------------------------------- */
FLStatus lockForIO(FLByte socket, FLByte partition, FLBoolean onOff)  {

checkStatus(dochSetBusy(socket, onOff, partition)); /* take BD mutex */

return flOK;
}
#endif /*FL_MIGRATION_VERSION*/
/* ----------------------------------------------------------------------------------- */

