/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/dochtl.h-arc  $
 *
 *    Rev 1.13   Aug 09 2006 17:26:56   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 */

#ifndef DOCHTL_H
#define DOCHTL_H

#include "fltl.h"


struct tTLrec{
   FLByte       socketNo;            /* Socket number of the volume	*/
   FLByte       partitionNo;         /* Partition number of the volume	*/
   FLDword		virtualSectors;		 /* No of sectors exported by the TL	*/
   FLByte       maxRelatedSectors;   /* Max number of sectors that might be written together */
   FLWord       sectorsInUnit;       /* No of sectors in a logical unit      */

   void FAR0  * mappedSector;
};

typedef TLrec DocTLRec;

FLStatus getDochTL(TL* tl, FLByte partition);
FLStatus dochMountTL(FLNative partition, FLNative socket);

#ifndef FL_MIGRATION_VERSION
TFFS_DLL_API FLStatus bdCallSureFS(FLFunctionNo functionNo, IOreq FAR2 *ioreq);
#else /*FL_MIGRATION_VERSION*/
FLStatus dochDismountTL(FLNative partition);
#endif /*FL_MIGRATION_VERSION*/
#endif /*DOCHTL_H*/

