/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

#ifndef __EXCUSTOM__H__
#define __EXCUSTOM__H__



/* use read/write file device */
#define EX_USE_SERIAL_DEVICE
/* use read/write ram file */
/* #define EX_USE_RAM_FILE */

#if (defined(EX_USE_SERIAL_DEVICE) && defined(EX_USE_RAM_FILE))
#error "Error - EX_USE_SERIAL_DEVICE and EX_USE_RAM_FILE can not both be defined"
#endif

/* use command line device */
#define EX_USE_COMMAND_LINE_DEVICE
/* use messages device */
//#define EX_USE_MSG_DEVICE
/* use error messages device */
#define EX_USE_ERROR_MSG_DEVICE
/* use progress bar device */
#define EX_USE_PROGRESS_BAR_DEVICE

/* use device for fgets() */
#define EX_USE_STD_INPUT_PARAMS_DEVICE

/* use 'close all devices' function */
#define EX_USE_CLOSE_ALL_DEVICES
/* maximum number of devices, if CloseAll used */
#define MAX_DEVICES	20
/* use device of input from user - keyboard, etc */
#define EX_USE_USER_INPUT


/*---------------------------------------------------------------------------------*/
/* use other */

/* use Date Time and Random API's */
#define EX_USE_RANDOM
/* use string manipulation API's */
/*#define EX_USE_STRING_API */
/* use conversion from command line to CommandLineStruct */
#define EX_GET_COMMAND_LINE_STRUCT
/* use translation from error # to string */
#define EX_USE_ERRORS
/* use the stdlib library api's */
#define EX_USE_STDLIB_API
/* use the direct library api's */
/*#define EX_USE_DIRECT_API*/

/*---------------------------------------------------------------------------------*/
/* use TrueFFS constants */

/* use TFFS DOC types */
#define EX_USE_TFFS_DOC_TYPES

/* use translation of FLStatus */
#define EX_TRANSLATE_FLSTATUS


/* FLCLIB_FUNC enables the usage of 'standard' function flclib.c implementation */
#define FLCLIB_FUNC /* disable this flag when non-flclib functions should be used */

#ifndef EX_USE_COMMAND_LINE_DEVICE
#error "Error - EX_USE_COMMAND_LINE_DEVICE cannot be undefined without code change"
#endif

#ifndef EX_GET_COMMAND_LINE_STRUCT
#error "Error - EX_GET_COMMAND_LINE_STRUCT cannot be undefined without code change"
#endif

#ifndef EX_USE_STDLIB_API
#error "Error - EX_USE_STDLIB_API cannot be undefined without supplying alternative to stdlib API"
#endif

#endif /* __EXCUSTOM__H__ */
