/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/


/***********************************************************************************/
/*                       Utilities project                                         */
/***********************************************************************************/
/************************************************************************
 * Name    : exparser.h                                                 *
 *                                                                      *
 * Written : Ronen Golan                                                *
 * Updated : Marimont Polina                                            *
 * Abstract: This file contains the prototypes of the exparser          *
 ************************************************************************/

#ifndef __EXPARSER__
#define __EXPARSER__

/*****************************   #include     ***************************/
//#include "excustom.h"
//#include "exd_defs.h"

//#include "exd_stat.h"
//#include "exos.h"
//#include "exd_dev.h"
#include "flsystem.h"
#ifdef DOCH_FILE_SIMULATION
#include "sim_ram.h"
#endif /* DOCH_FILE_SIMULATION*/

#define EXAPI

/*****************************      STRUCTS    **************************/
/* CommandLineStruct is out of the #ifdef becuase otherwize its impossible to undefine  */
/* EX_GET_COMMAND_LINE_STRUCT .															*/
typedef struct
{
	FLBoolean		fSlash;         /*** True => '/','-' appears in this command ***/
	FLByte			bCommandNumber; /*** Command line index in command list arr  ***/
	FLSByte*			pCommand;       /*** Pointer to the command                  ***/
	FLSByte*			pCommandUpper;  /*** NULL always                             ***/
	FLByte			bCommandLen;    /*** Command length in bytes                 ***/
	FLBoolean			fSuffix;        /*** Flag if there is a suffix or not        ***/
	FLByte			bSuffix;        /*** The number of the suffix                ***/
	FLSByte*			pArg;           /*** Pointer to the argumnet                 ***/
	FLByte			bArgLen;        /*** Length of the argument                  ***/
}CommandLineStruct;

#define UT_UNKNOWN_COMMAND ((FLByte)0xFF)

extern void     EXAPI ExGetCommandLineStruct( FLSByte* curArgv, CommandLineStruct* cmdLine, FLSByte** pCommandList );
//extern ExStatus EXAPI ParseCommandLine( CommandLineStruct* cmdLineRecord, FLByte commandNumber,FLSByte **exUtilCommands );
extern FLBoolean EXAPI IsDigitStr(FLSByte*pStr,FLWord wLen);
extern FLBoolean EXAPI IsHexStr(FLSByte*pStr,FLWord wLen);


#ifdef EX_GET_COMMAND_LINE_STRUCT

/*****************************  Definitions    **************************/
#define	EX_SLASH_PREFIX			'/'
#define	EX_SLASH_MINUS			'-'
#define	COLON					':'
#define END_LIST			    '0'
#define END_STR					'\0'
#define EXCLAMATION_MARK		'!'
#define EX_SAMI_COLON_DELIM		';' /* for systems, where ';' allowed as delimiter */
#define EX_PLUS_DELIM			'+' /* for systems, where ';' NOT allowed as delimiter, use '+' */

/* macro, that checks whether the delimiter is valid */
#define EX_IS_DELIM(c) ( ((c)==EX_SAMI_COLON_DELIM) || ((c)==EX_PLUS_DELIM) )


/*****************************  Prototypes    ***************************/

#endif	/* EX_GET_COMMAND_LINE_STRUCT */

/**************************************************************/
/* command line parameters attributes check */

/*CHECK_NO_PARAM macro checks if no ':' exists after command and that there is no argument */
#define EX_CHECK_PARAM(f)				if(f) return EX_CMDLINE_PARAM_ERROR;

#define EX_CHECK_NO_PARAM(cml) EX_CHECK_PARAM( ((cml.bArgLen!=0) || (cml.fSuffix)) )
#define EX_CHECK_PART_NO(no) ((no)>=DOCH_MAX_PARTITIONS)
/**************************************************************/



/*command line enum for common commands to all utilities*/
typedef enum __eExUtsComLineParam{
	/* common flags for DOC related and other utilities */
	CO_QUES=0,
	CO_H,
	CO_LEVEL,
	CO_CLFILE,
	/* common flags for DOC related ONLY utiliites */
	CO_WIDTH,
	CO_FAST,
    CO_SHIFT,
	CO_SPI,
#ifndef FL_NO_RAMMTD_SUPPORT
	CO_RAMDEVFILE,
#endif /*FL_NO_RAMMTD_SUPPORT*/

	CO_EXUTS_LAST /*MUST be last*/
}eExUtsComLineParam;


typedef void (*FuncPrintHelpMessage) (FLBoolean bWholeHelp);


/* NUM_CMD_LINE_PARAMS should be increased if EX_NO_ROOM_FOR_CMD occured */
#define NUM_CMD_LINE_PARAMS 64
/* EX_CHECK_PARAMS_NUMBER check MUST be done before command name initializations! */
#define EX_CHECK_PARAMS_NUMBER(last) (NUM_CMD_LINE_PARAMS <= last)


extern const FLSByte* pCmdNamesStrings[]; /*command line parameters strings holders*/
#ifdef FL_ENVIRONMENT_VARS
extern FLByte ut_flUse8Bit;

#endif/*FL_ENVIRONMENT_VARS*/

//extern FLBoolean EXAPI ExUtsParseCmdLineParams(ExStatus * bRet, CommandLineStruct * curParam, FuncPrintHelpMessage pPrintHelpFunc);
extern void	  EXAPI	ExUtsInitCmdLineCommons(void);
extern FLBoolean EXAPI ExFreeCmdLineFileBuffs(void);
extern void   EXAPI	ExParseCommandsFromString(FLSByte * pCmdString, FLWord wCmdStrLen, FLSByte ** pCommands);
extern void   EXAPI	ExPrintCommonFlagsHelp( FLSByte * pUtilName, FLSByte * p_MainUsageStr );
extern FLBoolean ExStrNCmpNonCase( FLSByte * str1, FLSByte * str2, FLDword dwLen );

extern FLByte		bPrintLevel;
extern FLDword		ext_busConfig;
extern FLByte		bExNoSockets;
extern FLByte		bDbgPrints; /* print ETFFS messages after each operation */
extern FLByte		bEtffsDebugLevel; /* ETFFS debug level */


#define MAX_USER_MSG_SIZE	0xff
#define MAX_USER_ERR_SIZE	0xff
#define MAX_CMD_LINE_FILE	512

extern FLBoolean ExAllocateMsgBuffs(void);
extern FLBoolean ExFreeMsgBuffs(void);
extern FLSByte *pMsg;
extern FLSByte *pError;


/* some utilities uses some options for DOC win address */
typedef struct __DOC_ADDRESS
{
  FLDword     DocWindow;            /* DISKONCHIP WINDOW ADDRESS    */
  FLDword     DocLowLimit;			/* DISKONCHIP LOW WINDOW ADDRESS    */
  FLDword     DocHighLimit;			/* DISKONCHIP HIGH WINDOW ADDRESS    */
  /* H3 additions */
  FLByte	  bDeviceNo;			/* device number inside the socket */
}DOC_ADDRESS, *pDOC_ADDRESS;

extern DOC_ADDRESS DocAddresses;

/* type of current access */
typedef enum __EX_DOCH_ACCESS
{
	EX_ACCESS_UNKNOWN = 0,
	EX_ACCESS_NOR = 1,
	EX_ACCESS_SPI = 2,
#ifdef DOCH_FILE_SIMULATION
	EX_ACCESS_SIMULATOR
#endif /*DOCH_FILE_SIMULATION*/
}EX_DOCH_ACCESS;

extern EX_DOCH_ACCESS  DocHwAccess;



extern void ExInitDocAddresses(void);
//ExStatus ExCheckDocAddresses(FLBoolean bUseSearchRange);
//extern ExStatus ExParseDocAddress(FLDword * pAddr, CommandLineStruct * pCls);

#define EX_IS_ADDR_SET(addr) (addr!=UT_DEF_DOC_ADDR)
#define EX_IS_DOCH_SET EX_IS_ADDR_SET(DocAddresses.DocHighLimit)
#define EX_IS_DOCL_SET EX_IS_ADDR_SET(DocAddresses.DocLowLimit)
#define EX_IS_DOCW_SET EX_IS_ADDR_SET(DocAddresses.DocWindow)



/**************************************************************/
/* Function name	: ExParseFailFormat                       */
/* Description	    : parses the FAIL_FORMAT command line flag*/
/* Return type		: ExStatus                                */
/* Argument         : CommandLineStruct* pCml                 */
/* Argument         : FLBoolean * bFailFormat                    */
/**************************************************************/
//extern ExStatus ExParseFailFormat(CommandLineStruct* pCml, FLBoolean * bFailFormat, FLDword * pdwFormatFlag);


/**************************************************************/
/* definition for command, used by more, than one utility */
#define CO_LOGD_NAME		"LOGD"
#define CO_WIN_NAME			"WIN"
#define CO_KEY_NAME			"KEY"
#define CO_IPL_NAME			"IPL"
#define CO_WINL_NAME		"WINL"
#define CO_WINH_NAME		"WINH"
#define CO_FAIL_FORMAT_NAME "FAIL_FORMAT"
#define CO_NOFORMAT_NAME	"NOFORMAT"
#define CO_READ_NAME		"READ"
/**************************************************************/

/**************************************************************/
/* definition for flags help, used by more, than one utility */
#define CO_WINL_HELP		ExPrint( FLTXT("    /WINL:address  - DOC low limit window address\n"));
#define CO_WINH_HELP		ExPrint( FLTXT("    /WINH:address  - DOC high limit window address\n"));
/**************************************************************/

/**************************************************************/
/* suffix treatment definitions */

/* possible suffixes MUST NOT be digit!  */
#define EX_SUFF_MEGABYTES  'M'
#define EX_SUFF_KILOBYTES  'K'
#define EX_SUFF_UNITS	   'U'
#define EX_SUFF_SECTORS    'S'
#define EX_SUFF_PERCENTS   'P'
#define EX_SUFF_CYLINDERS  'C'
#define EX_SUFF_FREE_CHUNK 'F'


/* defice length definions if they not defined */
#ifndef FL_LENGTH_IN_BYTES
#define FL_LENGTH_IN_BYTES          0
#endif /*FL_LENGTH_IN_BYTES*/

#ifndef FL_LENGTH_IN_SECTORS
#define FL_LENGTH_IN_SECTORS        1
#endif /*FL_LENGTH_IN_SECTORS*/

#ifndef FL_LENGTH_IN_UNITS
#define FL_LENGTH_IN_UNITS          2
#endif /*FL_LENGTH_IN_UNITS*/

#ifndef FL_LENGTH_IN_PERCENTS
#define FL_LENGTH_IN_PERCENTS       3
#endif /*FL_LENGTH_IN_PERCENTS*/

#ifndef FL_LENGTH_IN_CYLINDERS
#define FL_LENGTH_IN_CYLINDERS		10
#endif /*FL_LENGTH_IN_CYLINDERS*/


/* suffixes bitmaps */
#define EX_SUFF_MEGABYTES_ON  0x00000001
#define EX_SUFF_KILOBYTES_ON  0x00000002
#define EX_SUFF_UNITS_ON	  0x00000004
#define EX_SUFF_SECTORS_ON    0x00000008
#define EX_SUFF_PERCENTS_ON   0x00000010
#define EX_SUFF_CYLINDERS_ON  0x00000020
#define EX_SUFF_FREE_CHUNK_ON 0x00000040

#define EX_ALL_SUFF_ON        0xffffffff
#define EX_NO_SUFF_ON         0x00000000


FLBoolean EXAPI ExParseUp2Suffix( FLSByte * pStr, FLWord wStrLen, FLDword * dwNum, FLDword dwAllowedSuffixes, void * pOptParam, FLByte bBase);

/**************************************************************/


/**************************************************************/
/* DFORMAT and DFS utilities may work in following operation modes */
typedef enum _eExOperMode
{
	EX_OPER_MODE_UNKNOWN = 0,
	EX_OPER_MODE_READ,		/*read*/
	EX_OPER_MODE_NOFORMAT,	/*update*/
	EX_OPER_MODE_FORMAT,	/*format*/
	EX_OPER_MODE_UNFORMAT,  /*this mode used by dformat only*/
	EX_OPER_MODE_UPDATE     /*this is temporary mode, which should be set when flag,
								which required for format or update ONLY detected */
}eExOperMode;

#define EX_INIT_EX_OPER_MODE(mode)	 (mode)=EX_OPER_MODE_UNKNOWN;

#define EX_OPER_MODE_SET(mode)	 EX_CHECK_PARAM((mode)!=EX_OPER_MODE_UNKNOWN)

#define EX_SET_UPDATE_MODE(mode) if(mode==EX_OPER_MODE_UNKNOWN) mode=EX_OPER_MODE_UPDATE;

#define EX_NON_UPDATE_MODE(operMode) ((operMode==EX_OPER_MODE_UNFORMAT) || \
									 (operMode==EX_OPER_MODE_READ))

/*EX_STR_SIZE returns string size, without NULL char */
#define EX_STR_SIZE(str) (sizeof((str))-1)


/* DINFO_PRINT_INFO_BANNER prints and underlines the banner for string str */
/* str should not include /n or/and  /r characters */
#define EX_PRINT_BANNER(str)\
ExPrint( FLTXT("\n\r%s\n\r"), str );\
ExPrintLine( EX_STR_SIZE(str) );


#ifndef FL_NO_RAMMTD_SUPPORT

	#define EX_IS_RAMMTD_FILE_SET (pSimFileName!=NULL)

	/*RAM MTD Virtual DOC supported*/
	#define EX_PRINT_RAM_MTD \
	  if( pSimFileName )  {\
		ExPrint( EX_TEXT("\n\r*** Simulating DOC from file: %s\n\r"), pSimFileName );  }

	#define EX_CHECK_RAM_MTD_REQUESTED \
	 ( (pSimFileName!=NULL) || \
		 (pSimFileName!=RAM_MTD_UNKNOWN) )

	extern void EXAPI ExUtsDontConvertDump(void);

#else /*FL_NO_RAMMTD_SUPPORT*/

	#define EX_IS_RAMMTD_FILE_SET 0
	#define EX_PRINT_RAM_MTD

#endif /*FL_NO_RAMMTD_SUPPORT*/

#ifdef DOCH_FILE_SIMULATION
	#define EX_IS_SIMULATION_FILE_SET (pSimFileName!=NULL)

#else /*DOCH_FILE_SIMULATION*/

	#define EX_IS_SIMULATION_FILE_SET 0

#endif /*DOCH_FILE_SIMULATION*/


/* H3 partitions and device keys should be supplied in file */
/* useful  for utilities applications */
typedef enum __DOCH_UT_KEY_TYPE
{
	DOCH_UT_KEY_TYPE_UNKNOWN = 0,
	DOCH_UT_KEY_PLAIN_TXT = 1,	/* password specified as text in command line  */
	DOCH_UT_KEY_FILE_TXT = 2,	/* plain text password from file */
	DOCH_UT_KEY_RSA = 3			/* binary key */
}DOCH_UT_KEY_TYPE, *pDOCH_UT_KEY_TYPE;

typedef struct __DOCH_UT_KEY
{
	DOCH_UT_KEY_TYPE keyType;
	FLByte * bKey; /* holds pointer to key or pointer to filename */
	FLByte	 bKeyLen; /* length of key or password */
}DOCH_UT_KEY, *pDOCH_UT_KEY;

/* UT_IS_KEY_FROM_FILE determines whether pointer is filename or key itself */
#define UT_IS_KEY_FROM_FILE(ut_key) ( ((ut_key)->keyType==DOCH_UT_KEY_FILE_TXT) || ((ut_key)->keyType==DOCH_UT_KEY_RSA) )
/* password protection required */
#define UT_IS_KEY_PWD(ut_key) ( ((ut_key)->keyType==DOCH_UT_KEY_FILE_TXT) || ((ut_key)->keyType==DOCH_UT_KEY_PLAIN_TXT) )
/* check whether there is a key */
#define UT_IS_KEY_VALID(ut_key) ( ((ut_key)->keyType!=DOCH_UT_KEY_TYPE_UNKNOWN) || ((ut_key)->bKeyLen!=0) )


#define EX_IS_PART_NOT_VALID(part)( ((part)>DOCH_MAX_PARTITIONS) || ((part)<0) ) /*partitions numerated from 0 to 14 */
#endif	/* __EXPARSER__ */





