/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

/***********************************************************************************/
/*                       Utilities project                                         */
/***********************************************************************************/


#ifndef __EXSTATUS__H__
#define __EXSTATUS__H__

/*---------------------------------------------------------------------------------*/

#define EXE_LAST_TFFS	        0x100  /* assume TFFS has no more than FF error codes */
#define EXE_LAST_UTILS	        0x200  /* assume Utilities have no more than FF error codes (0x100 till 0x200)*/


/* device operation errors */
typedef enum
{

	EX_OK = 0,					  /* no error - must be equal flOK */
	/*EX_DEV_ERROR,*/             /* wrong/unsupported device type passed to ext function */
	EX_COMMAND_ERROR = (EXE_LAST_TFFS+1), /* wrong command passed to ext function */
	EX_COMMAND_LINE_ERROR,		  /* wrong command line passed to ext function */
	EX_MALLOC_ERROR,			  /* no enough memory */
	EX_OPEN_ERROR,				  /* open device error */
	EX_CLOSE_ERROR,				  /* close device error */
	EX_WRITE_ERROR,				  /* write error */
	EX_READ_ERROR,				  /* read error */
	EX_EOF_ERROR,				  /* No more data, as 'end of file' */
	EX_CMDLINE_PARAM_ERROR,		  /* Wrong command line param */
	EX_USER_CUSTOM_ERROR,		  /* user custom error */
	EX_TRUEFFS_ERROR,
	EX_HELP_SCREEN_ERROR,
	EX_BINARY_SDK_ERROR,
	EX_SOCKET_DOES_NOT_EXIST,
	EX_WIN_ERROR,				  /* window wrong - access violation error detected */
	EX_LOW_LIMIT_BIGGER_THAN_HIGH_LIMIT_ERROR, /* start window great than end of window */
	EX_BAD_LENGTH,
	EX_BAD_RAM_MTD_DOC_TYPE,	 /* bad type number defined in command line */
	EX_NO_ROOM_FOR_CMD,			 /* commands names buffer is too small to save all commands */
	EX_NO_CMD_LINE_PARAM,		 /* utility MUST receive parameters, but user not specified even one */
	EX_DOC_TYPE_NOT_COMPATIBLE,  /* DOC, that found cannot be used with the utility */
	EX_MBR_EMPTY_SLOT,           /* empty MBR slot found */
	EX_OTW_PROT_FORMAT,          /* format DOC includes OTW protected area */
	/*H3 - image tools errors*/
	EX_IMG_FILTER,
	EX_BAD_IMG_FILE,
  EX_EXTRA_ERROR = EXE_LAST_UTILS

}ExStatus;


#define STATUS_ERROR   Status != flOK
/****************************************************************************/
#define STATUS_OK   Status == flOK
/****************************************************************************/
#define EX_NO_PARAMS(arg_count, print_help) \
if( arg_count == 0 ) {\
PrintErrorMessage(EX_NO_CMD_LINE_PARAM, NULL);\
print_help(TRUE);\
return EX_NO_CMD_LINE_PARAM;}
#ifdef EX_USE_ERRORS
FLSByte* /*EXAPI*/ TranslateExError( ExStatus wErr );
#endif /* EX_USE_ERRORS */
#endif /*__EXSTATUS__H__*/


