/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:
 */

#ifndef FLBASE_H
#define FLBASE_H

#include "flcustom.h"
#include "flsystem.h"
#include "flsystyp.h"
#include "flchkdef.h"
#include "flcommon.h"

#ifndef MTD_STANDALONE
#include "flsysfun.h"
#endif /* MTD_STANDALONE */

 /* Number of floors supported by the S/W
 *
 * Define Maximum Number of floors in a physical device
 *
 * The actual number of floors depends on the physical device placed
 * on the socket.
 */

#define FL_MAX_NO_OF_FLOORS  4



/* General purpose macros */

#define BYTE_ADD_FAR(x,y) ((FLByte FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))
#define WORD_ADD_FAR(x,y) ((FLWord FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))
#define DWORD_ADD_FAR(x,y) ((FLDword FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))
#define SBYTE_ADD_FAR(x,y) ((FLSByte FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))
#define SWORD_ADD_FAR(x,y) ((FLSWord FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))
#define SDWORD_ADD_FAR(x,y) ((FLSDword FAR1 *)addToFarPointer((FLByte FAR1 *)x,y))

/* Drive handle masks */

#define FL_GET_LOGICAL_PARTITION_FROM_HANDLE(ioreq) 	(FLByte)(((ioreq)->irHandle & 0xf00) >> 8)
#define FL_GET_DISK_HANDLE_FROM_S_P_LP(s,p, lp) 	((s) | ((p) << 4) | ((FLHandle)(lp) << 8))

#define FL_SOCKET_AND_FLASH_PARTITION_BITS	0xFF

#define FL_DO_NOT_UPDATE_MBR			(1 << 14)	/* used by formatFS only */

#define INVALID_VOLUME_NUMBER 0xff
#define TL_SIGNATURE          6

#define FL_SECTOR_MASK     (FL_SECTOR_SIZE - 1)
#define BITS_PER_BITE          8


/* General purpose macros adjusted according to the above customization files. */


/* Call a procedure returning status and fail if it fails. This works only in */
/* routines that return Status: */
#define checkStatus(exp)      {    FLStatus fl__status = (exp);if (fl__status != flOK) return fl__status; }
#define updateStatus(cur__stat, exp)      {    FLStatus fl__status = (exp);if (cur__stat == flOK) cur__stat = fl__status; }

#define TFFSMIN(a,b) (((a)>(b)) ? (b):(a))
#define TFFSMAX(a,b) (((a)<(b)) ? (b):(a))

/***************************************************************************/
/* Big \ Little endien architecture conversion macros.                     */
/***************************************************************************/

#ifndef FL_NO_PACKED_STRUCTS_SUPPORTED
#define COPY2(to,arg)		*((FLWord *)(&to)) = *((FLWord *)(&arg))
#define COPY4(to,arg)		*((FLDword *)(&to)) = *((FLDword *)(&arg))
#else
#define COPY2(to, offs, arg)		FL_REF_2(to, offs) = FL_REF_2(arg, offs)
#define COPY4(to, offs, arg)		FL_REF_4(to, offs) = FL_REF_4(arg, offs)
#endif /* FL_NO_PACKED_STRUCTS_SUPPORTED */


#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#define UNAL2(arg)       fromUNAL(arg)
#define toUNAL2(to,arg)  toUNAL(to,arg)

#define UNAL4(arg)       fromUNALLONG((FLByte const FAR0 *)(arg))
#define toUNAL4(to,arg)  toUNALLONG((FLByte FAR0 *)to,arg)

/* for both LE and BE */

#define FL_GET_UNAL2(arg, offs)		fromUNAL(((FLByte *)(arg)) + (offs))
#define FL_SET_UNAL2(to, offs, arg)	toUNAL(((FLByte *)(to)) + (offs), (arg))
#define FL_GET_UNAL4(arg, offs)		fromUNALLONG(((FLByte *)(arg)) + (offs))
#define FL_SET_UNAL4(to, offs, arg)	toUNALLONG(((FLByte *)(to)) + (offs), (arg))


typedef LEulong LEmin;

/*************************************************/
/* Use routines instead of 'c' standard librarys */
/*************************************************/

#ifdef FL_VERIFY_WRITE
extern FLByte  flVerifyWrite[FL_SOCKETS][FL_MAX_TL_PARTITIONS<<1];
#endif /* FL_VERIFY_WRITE */

/**********************************************/
/* Declare the TrueFFS environment variables  */
/**********************************************/

#ifdef FL_NO_USE_FUNC
/* The code bellow allows you to customize your own routine for multi bytes */
/*  transfers. Once FL_NO_USE_FUNC is defined, you can define the multi byte */
/* macros to these routines, and code them yourself in flsystem.c */
extern void FAR1 fl16bitDocReadNoShift (volatile  FLByte FAR0 * win, FLWord offset, FLByte FAR1 * dest, FLWord count );
extern void FAR1 fl16bitDocWriteNoShift ( volatile  FLByte FAR0 * win , FLWord offset , FLByte FAR1 * src, FLWord count );
#endif /* FL_NO_USE_FUNC */

#ifdef FL_ENVIRONMENT_VARS

extern void flSetEnvVar(void);

/**********************************************/
/* Declare the TrueFFS environment variables  */
/**********************************************/

extern FLByte   flUse8Bit;
extern FLByte   flDimageCfg;

#ifndef MTD_STANDALONE

extern FLByte   flUseMultiDoc;
extern FLByte   flMTLdefragMode;
extern FLByte   flMaxUnitChain;
#ifdef FL_TFFS_OLD_ENV_VARS
extern FLByte   flMarkDeleteOnFlash;
extern FLByte   flPolicy[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
#endif /* FL_TFFS_OLD_ENV_VARS */
extern FLWord   flCacheSize[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
extern FLByte   flSkipStaticFilesWearLeveling[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
extern FLByte   flSuspendMode[FL_SOCKETS];
extern FLDword  flTFFSBDDebugMode[FL_SOCKETS][FL_MAX_TL_PARTITIONS];
#ifdef FL_BD_AUTO_DPD_MODE
extern FLDword  flBDAutoDPDMode[FL_SOCKETS];
#endif /* FL_BD_AUTO_DPD_MODE */

#endif /* MTD_STANDALONE */

/* Policies definitions (FL_SET_POLICY) */
#define FL_DEFAULT_POLICY                               0
#define FL_COMPLETE_ASAP                                1
#define FL_SECURED_DELETE                               2
/* Mtl policies definitions (FL_MTL_POLICY) */
#define FL_MTL_DEFRAGMENT_ALL_DEVICES                   0
#define FL_MTL_DEFRAGMENT_SEQUANTIAL                    1
/* Suspend mode other then FL_OFF */
#define FL_SUSPEND_WRITE                                1
#define FL_SUSPEND_IO                                   3
#define FL_IGNORE_WRITE                                 4
#define FL_IGNORE_ERASE                                 8
#define FL_PREVENT_IO     (FL_IGNORE_ERASE | FL_IGNORE_WRITE | FL_SUSPEND_IO | FL_SUSPEND_WRITE)
/* Runtime replacement for compilation flags */
#define FL_DIMAGE				                        0x01
#define FL_PUTIMAGE			      	                    0x02
#define FL_PUTIMAGE_PARALLEL	                        0x04
#define FL_DIMAGE_ALL			(FL_DIMAGE | FL_PUTIMAGE | FL_PUTIMAGE_PARALLEL)
/* Cache full media */
#define FL_MAX_ALLOWED_TL_CACHE_SIZE                    0xFFF


#ifndef FL_DEFAULT_POLICY_MODE
#define FL_DEFAULT_POLICY_MODE(socket,partition)        FL_OFF
#endif /* FL_DEFAULT_POLICY_MODE */
#ifndef FL_DEFAULT_BD_DPD_MODE
#define FL_DEFAULT_BD_DPD_MODE(socket)			        FL_OFF
#endif /* FL_DEFAULT_BD_DPD_MODE */
#ifndef FL_DEFAULT_BD_SUSPEND_MODE
#define FL_DEFAULT_BD_SUSPEND_MODE(socket)     			FL_OFF
#endif /* FL_DEFAULT_BD_SUSPEND_MODE */
#ifndef FL_DEFAULT_BD_DEBUG_MODE
#define FL_DEFAULT_BD_DEBUG_MODE(socket,partition)      FL_OFF
#endif /* FL_DEFAULT_BD_DEBUG_MODE */
/* Either per partition or for all (backward compatible) */
#ifndef FL_DEFAULT_CACHE_SIZE_FOR_MINIMAL_CACHE
#define FL_DEFAULT_CACHE_SIZE_FOR_MINIMAL_CACHE 0x40
#endif  /* FL_DEFAULT_CACHE_SIZE_FOR_MINIMAL_CACHE */
#ifndef FL_DEFAULT_TL_CACHE_SIZE
#define FL_DEFAULT_TL_CACHE_SIZE(socket,partition)      FL_DEFAULT_CACHE_SIZE_FOR_MINIMAL_CACHE
#endif  /* FL_DEFAULT_TL_CACHE_SIZE */
#ifndef FL_DEFAULT_WEARLEVELING_MODE
#define FL_DEFAULT_WEARLEVELING_MODE(socket,partition)  FL_OFF
#endif /* FL_DEFAULT_WEARLEVELING_MODE */
#ifndef FL_DEFAULT_VERIFY_WRITE_MODE
#define FL_DEFAULT_VERIFY_WRITE_MODE(socket,partition)  FL_OFF
#endif /* FL_DEFAULT_VERIFY_WRITE_MODE */
#ifndef FL_DEFAULT_TOOLS_MODE
#define FL_DEFAULT_TOOLS_MODE					        FL_OFF
#endif /* FL_DEFAULT_TOOLS_MODE */

#endif /* FL_ENVIRONMENT_VARS */

/* Set default to bus configuration (unless specified differently in flsystem.h */
#ifndef FL_DEFAULT_BUS_CONFIGURATION
#if (!defined(CHARSIZE) || (CHARSIZE != 16))
#define FL_DEFAULT_BUS_CONFIGURATION (FL_NO_ADDR_SHIFT | FL_BUS_HAS_8BIT_ACCESS  | \
                                      FL_BUS_HAS_16BIT_ACCESS | FL_BUS_HAS_32BIT_ACCESS)
#else
#define FL_DEFAULT_BUS_CONFIGURATION (FL_NO_ADDR_SHIFT | FL_BUS_HAS_16BIT_ACCESS)
#endif /* CHARSIZE */
#endif /* FL_DEFAULT_BUS_CONFIGURATION */

#ifndef FL_DEFAULT_BUS_MODE
#define FL_DEFAULT_BUS_MODE(socket) FL_DEFAULT_BUS_CONFIGURATION
#endif /* FL_DEFAULT_BUS_MODE */


#endif /* FLBASE_H */


