/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/flchkdef.h-arc  $
 *
 *    Rev 1.78.1.0   Aug 08 2006 15:55:30   Polina.Marimont
 * DOC Driver 1.0 initial
 */

/************************/
/* TrueFFS source files */
/* -------------------- */
/************************/

/*****************************************************************************
* File Header                                                                *
* -----------                                                                *
* Name : flchkdef.h                                                          *
*                                                                            *
* Description : Sanity check for flcustom.h files.                           *
*                                                                            *
*****************************************************************************/

#ifndef _FL_CHK_DEFS_H_
  #define _FL_CHK_DEFS_H_

  #include "flcustom.h"
  #include "flsystem.h"

  #define FL_MIGRATION_VERSION

  #ifdef FL_MIGRATION_VERSION /* enable floors support for migration version */
    #ifndef FL_DOCH_DONT_SUPPORT_FLOORS
      #define DOCH_FLOORS
    #endif /*FL_DOCH_DONT_SUPPORT_FLOORS*/
  #endif /*FL_MIGRATION_VERSION*/

/* #define FL_622_MTD_CODE */

#define FL_NEW_MAPSECTOR

#ifndef MTD_STANDALONE

/* TrueFFS version
 *
 * Number written on the flash by INFTL format specifying the TrueFFS version
 * The media was formated with. the number bellow specifies version
 * 7.0.0.0
 */

#define TrueFFSVersion "1000"

/* Tracking number for TrueFFS configuration managment
 *
 * Number for configuration mangment of special purpose versions
 */

#define TrueFFS_EQA_Version   1
#define TrueFFS_RC_Version    0
#define TrueFFS_PATCH_Version 0
#define TrueFFS_Alpha_Version 1
#define TrueFFS_Beta_Version  0


/* Programmer type version
 *
 * This string is placed in the media header indicating the programmer
 * Name and version used to format the media
 */

#ifndef FL_PROGRAMMER_NAME
#define FL_PROGRAMMER_NAME    "CORE"
#endif /* FL_PROGRAMMER_NAME */

#ifndef FL_PROGRAMMER_VERSION
#define FL_PROGRAMMER_VERSION "0000"
#endif /* FL_PROGRAMMER_VERSION */


/*******************************************/
/* Validity check and overlapping defines  */
/*******************************************/

#if !defined(FL_READ_ONLY) && !defined(FS_READ_ONLY) && defined(READ_ONLY)
#define FL_READ_ONLY
#define FS_READ_ONLY
#endif

/* The format option needs some internal defintions */
#if !defined(FL_FORMAT_VOLUME) && defined(FORMAT_VOLUME)
#define FL_FORMAT_VOLUME
#endif

#if (defined(FL_FORMAT_VOLUME) && defined(FL_READ_ONLY))
#error "You can not define FL_READ_ONLY and FL_FORMAT_VOLUME at the same time"
#endif /* (defined(FL_FORMAT_VOLUME) && defined(FL_READ_ONLY)) */

#if (defined(FS_FORMAT_VOLUME) && defined(FS_READ_ONLY))
#error "You can not define FS_READ_ONLY and FS_FORMAT_VOLUME at the same time"
#endif /* (defined(FS_FORMAT_VOLUME) && defined(FS_READ_ONLY)) */

#if (defined(FS_CREATE_LOGICAL_PARTITIONS) && defined(FS_READ_ONLY))
#error "You can not define FS_READ_ONLY and FS_CREATE_LOGICAL_PARTITIONS"
#endif

/* VERIFY_ERASED_SECTOR should always come together with FL_VERIFY_WRITE */

#if !defined(FL_VERIFY_WRITE) && defined(VERIFY_WRITE)
#define FL_VERIFY_WRITE
#endif

#if defined (FL_VERIFY_WRITE) && !defined (VERIFY_ERASED_SECTOR)
#define VERIFY_ERASED_SECTOR
#endif
#if !defined (FL_VERIFY_WRITE) && defined (VERIFY_ERASED_SECTOR)
#define FL_VERIFY_WRITE
#endif

/* In case FL_READ_ONLY is defined FS_READ_ONLY needs to be defined as well */
#ifdef FL_READ_ONLY
#ifndef FS_READ_ONLY
#define FS_RED_ONLY
#endif /* FS_READ_ONLY */
#endif /* FL_READ_ONLY */

/* Validity check for system files MACROES */
#ifndef FL_FOPEN
#define FL_FOPEN
#endif /* FL_FOPEN */
#ifndef FL_FCLOSE
#define FL_FCLOSE
#endif /* FL_FCLOSE */
#ifndef FL_FPRINTF
#define FL_FPRINTF
#endif /* FL_FPRINTF */


/* Number of file system - logical partitions
 *
 * Defines Maximum Number of logical partitons on a BDTL partition
 *
 * The actual number of partitions depends on the format placed on each device.
 */

#ifndef FS_MAX_LOGICAL_PARTITIONS
#define FS_MAX_LOGICAL_PARTITIONS	4	/* per TL partition. There is no hard limit */
#endif /* FS_MAX_LOGICAL_PARTITIONS */


/* Validity check of FL_VOLUMES and FL_SOCKETS parameters. */

#if !defined(FL_VOLUMES) && defined(VOLUMES)
#define FL_VOLUMES VOLUMES
#endif

#if !defined(FS_VOLUMES) && defined(FL_VOLUMES)
#define FS_VOLUMES FL_VOLUMES
#endif

#if !defined(FL_SOCKETS) && defined(SOCKETS)
#define FL_SOCKETS SOCKETS
#endif

#if !defined(FS_SOCKETS) && defined(FL_SOCKETS)
#define FS_SOCKETS FL_SOCKETS
#endif


#if !defined(FL_VOLUMES) && defined(FL_SOCKETS)
#define FL_VOLUMES FL_SOCKETS
#endif /* SOCKETS && ! VOLUMES */

#if !defined(FS_VOLUMES) && defined(FS_SOCKETS)
#define FS_VOLUMES FS_SOCKETS
#endif /* SOCKETS && ! VOLUMES */

#if !defined(FL_SOCKETS) && defined(FL_VOLUMES)
#define FL_SOCKETS FL_VOLUMES
#endif /* ! SOCKETS && VOLUMES */

#if !defined(FS_SOCKETS) && defined(FS_VOLUMES)
#define FS_SOCKETS FS_VOLUMES
#endif /* ! SOCKETS && VOLUMES */

#if (FL_SOCKETS > FL_VOLUMES) || (FS_SOCKETS > FS_VOLUMES)
#error "SOCKETS should not be bigger then VOLUMES"
#endif /* SOCKETS > VOLUMES */

#if !defined(FL_FIXED_MEDIA) && defined(FIXED_MEDIA)
#define FL_FIXED_MEDIA
#endif

/* The POLLING_INTERVAL definition is not really relevant to DiskOnChip
 * Starting from TrueFFS 6.1 it was removed from flcustom.h, but TrueFFS
 * still support this functionality.
 */
#ifndef POLLING_INTERVAL
#define POLLING_INTERVAL 0
#endif /* POLLING_INTERVAL */

/* TrueFFS 5.2 used the FL_QUICK_MOUNT_INFO_EXIST defintion. TrueFFS 6.1
 * uses simple FL_ON and FL_OFF instead.
 */

#define FL_QUICK_MOUNT_INFO_EXIST				FL_ON

/* Starting from TrueFFS 6.1 this flag does not reduce code and therfore was
 * added as a default.
 *
 */

#define FL_LOW_LEVEL

/* Some S/W modules like boot SDK do not need the read bad blocks tables routine.
 * However for TrueFFS these defintion is vital
 */

/* 12-bit FAT support
 *
 * Comment the following line if you do not need support for DOS media with
 * 12-bit FAT (typically media of 8 MBytes or less).
 */

#define FS_FAT_12BIT


#define MTD_READ_BBT        /* Compile the read BBT routine code         */

#else  /* MTD_STANDALONE */

#ifndef FL_FIXED_MEDIA
#define FL_FIXED_MEDIA
#endif

#ifndef NO_READ_BBT_CODE

/* When compiled in the BDK mode, the read BBT code will be compiled unless
 * NO_READ_BBT_CODE was defined.
 */
#define MTD_READ_BBT        /* Compile the read BBT routine code         */

#endif /* NO_READ_BBT_CODE */

#ifndef FL_SOCKETS
#define FL_SOCKETS            1 /* The only available number */
#endif
#define FIXED_MEDIA
#define DO_NOT_YIELD_CPU

#endif /* MTD_STANDALONE */


/* Number of translation layer partitions
 *
 * Defines Maximum Number of Translation layer partitions on a physical device
 *
 * The actual number of partitions depends on the format placed on each device.
 */

#ifndef FL_MAX_TL_PARTITIONS
#define FL_MAX_TL_PARTITIONS 6
#endif /* FL_MAX_TL_PARTITIONS */

/* The Maximum number of partitions is limited to 8 due to SAFTL buffers  */

#if (FL_MAX_TL_PARTITIONS > 8)
#error "Can not define more then 8 partitions\r\n"
#endif /* (FL_MAX_TL_PARTITIONS > 8) */


/* Max Number of binary partitions */
#ifndef MAX_BINARY_PARTITIONS_PER_DRIVE
#define MAX_BINARY_PARTITIONS_PER_DRIVE 3
#endif /* MAX_BINARY_PARTITIONS_PER_DRIVE */

/* There can not be more binary partition, then total supported partitions */
#if (MAX_BINARY_PARTITIONS_PER_DRIVE >= FL_MAX_TL_PARTITIONS)
#error "MAX_BINARY_PARTITIONS_PER_DRIVE must be smaller then FL_MAX_TL_PARTITIONS\r\n"
#endif /* (MAX_BINARY_PARTITIONS_PER_DRIVE >= FL_MAX_TL_PARTITIONS) */

/* Default file system TL partitions */
#if !defined(FS_MAX_TL_PARTITIONS) && defined(FL_MAX_TL_PARTITIONS)
#define FS_MAX_TL_PARTITIONS	FL_MAX_TL_PARTITIONS
#endif

/* The TLS and MTDS constants where changed in TrueFFS 6.2 to a
 * more generic name : FL_TLS and FL_MTDS
 */

#ifndef FL_TLS
#define FL_TLS TLS
#endif /* FL_TLS */
#ifndef FL_MTDS
#define FL_MTDS MTDS
#endif /* FL_MTDS */

/* Make sure that the CHARSIZE is well defined */
#ifndef CHARSIZE
#define CHARSIZE        8  /*The default char size is 8*/
#endif

/* Make sure flPack and flspread are well defined */
#if (CHARSIZE == 8)
#ifndef flspread
#define flspread(source,length)
#endif /* flspread */

#ifndef flpack
#define flpack(source,length)
#endif /* flpack */
#endif /* (CHARSIZE == 8) */

/* Make sure FL2BYTE is well defined */
#ifndef FL2BYTE
#if (CHARSIZE == 8)
#define FL2BYTE(var) ((FLByte)(var))
#else
#define FL2BYTE(var) ((FLByte)((var) & 0x00FF))
#endif /* (CHARSIZE == 8) */
#endif /* FL2BYTE */


#ifndef FL_PACKED_STRUCTURES_BEFORE
#define FL_PACKED_STRUCTURES_BEFORE
#endif /* FL_PACKED_STRUCTURES_BEFORE */

#ifndef FL_PACKED_STRUCTURES_AFTER
#ifdef FL_PACKED_STRUCTURES
#define FL_PACKED_STRUCTURES_AFTER FL_PACKED_STRUCTURES
#else
#define FL_PACKED_STRUCTURES_AFTER
#endif /* FL_PACKED_STRUCTURES */
#endif /* FL_PACKED_STRUCTURES_AFTER */

/* Starting from TrueFFS version 6.x the ASSUMED_NFTL_UNIT_SIZE was changed to
 * FL_ASSUMED_MIN_UNIT_SIZE.
 */

#ifndef FL_ASSUMED_MIN_UNIT_SIZE
#define FL_ASSUMED_MIN_UNIT_SIZE        ASSUMED_NFTL_UNIT_SIZE
#endif /* FL_ASSUMED_MIN_UNIT_SIZE */

/* Starting from TrueFFS version 6.x the MAX_VOLUME_MBYTES was changed to
 * FL_ASSUMED_MAX_VOLUME_MBYTES.
 */

#ifndef FL_ASSUMED_MAX_VOLUME_MBYTES
#ifdef MAX_VOLUME_MBYTES
#define FL_ASSUMED_MAX_VOLUME_MBYTES        MAX_VOLUME_MBYTES
#else

/* TrueFFS sets the sector size according to this definitions. As a result customers
   that do not customize this definition will be limited to a very small media (32MB)
   without even knowing it.
 */

#define FL_ASSUMED_MAX_VOLUME_MBYTES        64
#endif /* MAX_VOLUME_MBYTES */
#endif /* FL_ASSUMED_MAX_VOLUME_MBYTES */

/* When using static allocation , SAFTL may requires the number of sectors
 * in a logical unit. This value can normally be deduced from the unit size.
 * However if you need to support several DiskOnChip devices with different
 * unit sizes, you may need to define the smallest unit size, while defining
 * the largest number of logical sectors in a logical unit
 */

#ifndef FL_ASSUMED_MAX_SECTORS_PER_UNIT
#define FL_ASSUMED_MAX_SECTORS_PER_UNIT (FL_ASSUMED_MIN_UNIT_SIZE>>FL_SECTOR_SIZE_BITS)
#endif /* FL_ASSUMED_MAX_SECTORS_PER_UNIT */

/* Validity check for FL_LOW_LEVEL compilation flag.
 *
 * Starting from TrueFFS 5.1 the LOW_LEVEL was changed to FL_LOW_LEVEL
 * The reason was that it clashed with Windows NT LOW_LEVEL macro.
 */

#ifndef FL_LOW_LEVEL
#ifdef LOW_LEVEL
#define FL_LOW_LEVEL
#endif /* LOW_LEVEL */
#endif /* FL_LOW_LEVEL */


#if !defined(FL_ABS_READ_WRITE) && !defined(FS_ABS_READ_WRITE) && defined(ABS_READ_WRITE)
#define FL_ABS_READ_WRITE
#define FS_ABS_READ_WRITE
#endif

/* Validity check for FL_SYS_FUNC_RELEASE
 *
 * Starting from TrueFFS 6.0 the flExit routine calls this macro in
 * order to inform the OS/FS that it is about to leave.
 */

#ifndef FL_SYS_FUNC_RELEASE
#define FL_SYS_FUNC_RELEASE
#endif /* FL_SYS_FUNC_RELEASE */

#if !defined(FL_EXIT) && !defined(FS_EXIT) && defined(EXIT)
#define FL_EXIT
#define FS_EXIT
#endif

/* Validity check for FL_LOWER_PRIORITY_THREAD and FL_RAISE_PRIORITY_THREAD
 *
 * Starting from TrueFFS 6.0-6.2.2 the MTD waitForReady routine calls the
 * FL_LowerPriorityThread and FL_RaisePriorityThread macros allowing the OS
 * to lower the driver's priority during the long wait.
 *
 * After 6.2.2 the name of the macros was changed to all upper case.
 */

#ifndef FL_LOWER_PRIORITY_THREAD
#ifdef FL_LowerPriorityThread
/*** Add support for older flsystem that use FL_Raise/LowerPriorityThread macros      ***/
#define FL_LOWER_PRIORITY_THREAD FL_LowerPriorityThread
#else
#define FL_LOWER_PRIORITY_THREAD(myFlash)
#endif /* FL_LowerPriorityThread */
#endif /* FL_LOWER_PRIORITY_THREAD */

#ifndef FL_RAISE_PRIORITY_THREAD
#ifdef FL_RaisePriorityThread
/*** Add support for older flsystem that use FL_Raise/LowerPriorityThread macros      ***/
#define FL_RAISE_PRIORITY_THREAD FL_RaisePriorityThread
#else
#define FL_RAISE_PRIORITY_THREAD(myFlash)
#endif /* FL_RaisePriorityThread */
#endif /* FL_RAISE_PRIORITY_THREAD */

#ifndef FL_LowerPriorityThread
#define FL_LowerPriorityThread(myFlash)
#endif /* FL_LowerPriorityThread */

#ifndef FL_RaisePriorityThread
#define FL_RaisePriorityThread(myFlash)
#endif /* FL_RaisePriorityThread */


/* Validity check for FL_TFFS_SLEEP
 *
 * Note that this routine used to be called flsleep, but it's name was
 * greater resolution was required.
 */

#ifndef FL_TFFS_SLEEP
#define FL_TFFS_SLEEP(flash,microseconds)
#endif /* FL_TFFS_SLEEP */


/* Validity check for FL_READ_ONLY
 *
 * When Block device does not support write operations, also file system
 * cannot write. Therefore, if BD read only is set - also FS read only must be set.
 */
#ifdef FL_READ_ONLY
#define FS_READ_ONLY
#endif /*FS_READ_ONLY*/

/* Validity check for FL_MALLOC and FL_FREE macros
 *
 * Starting from TrueFFS 5.0 the FREE and MALLOC macroes were
 * changed to FL_MALLOC and FL_FREE in order to avoid name clashes.
 * In order to keep backwards compatibility with previous flsystem.h
 * files the following new defintions checks were added.
 * if your system uses the FREE and MALLOC defintion simply comment
 * them out and customized the FL_MALLOC and FL_FREE macroes in your
 * flsystem.h file.
 */

#if (defined(MALLOC) && !defined(FL_MALLOC))
  #define FL_MALLOC MALLOC
#endif /* MALLOC && ! FL_MALLOC */

#if (defined(FREE) && !defined(FL_FREE))
  #define FL_FREE   FREE
#endif /* FREE && ! FL_FREE */


/* Validity check for "subFromFarPointer" and "distanceBetweenFarPointers"
 *
 * Starting from TrueFFS 6.3.0 2 new memory manipulation macro's were
 * introduced for none flat memory architecture. They should be used when
 * memory pointers are being subtracted or a difference between 2 pointers
 * is needed
 */

#ifndef subFromFarPointer
#define subFromFarPointer(base,increment)		\
       addToFarPointer(base,(-(FLSDword)(increment)))
#endif /* subFromFarPointer */

#ifndef distanceBetweenFarPointers
#define distanceBetweenFarPointers(ptr1, ptr2)		\
	(((FLDword)(ptr1)) - ((FLDword)(ptr2)))
#endif /* distanceBetweenFarPointers */


/* Validity check for FL_FAR_MALLOC and FL_FAR_FREE
 *
 * Due to the BIOS driver memory limitations a dedicated routine
 * is used for allocating the large ram arrays.
 */

#if (defined(FL_MALLOC) && !defined(FL_FAR_MALLOC))
#define FL_FAR_MALLOC FL_MALLOC
#endif /* FL_MALLOC && ! FL_FAR_MALLOC */

#if (defined(FL_FREE) && !defined(FL_FAR_FREE))
#define FL_FAR_FREE FL_FREE
#endif /* FL_MALLOC && ! FL_FAR_MALLOC */


#ifndef FL_MALLOC_DMA_BUFFER
#define FL_MALLOC_DMA_BUFFER FL_FAR_MALLOC
#endif

#ifndef FL_FREE_DMA_BUFFER
#define FL_FREE_DMA_BUFFER FL_FAR_FREE
#endif


/* Validity check for debug printing
 *
 * Starting from TrueFFS 6.0 there are 6 types of debug print
 * In case they were not customized in flsystem.h they are defined here
 * as NULL.
 */

#ifndef DBG_PRINT_FLOW
#define DBG_PRINT_FLOW(zone,str)    /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
#endif
#ifndef DBG_PRINT_ERR
#define DBG_PRINT_ERR(zone,str)     /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
#endif
#ifndef DBG_PRINT_WRN
#define DBG_PRINT_WRN(zone,str)     /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
#endif
#ifndef DBG_PRINT_FLOW_PRM
#define DBG_PRINT_FLOW_PRM(zone,str) /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#define DBG_PRINT_FLOW_PRM(zone,dummy,str) /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#endif
#ifndef DBG_PRINT_ERR_PRM
#define DBG_PRINT_ERR_PRM(zone,str)  /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#endif
#ifndef DBG_PRINT_WRN_PRM
#define DBG_PRINT_WRN_PRM(zone,str)  /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#endif

#ifndef DBG_PRINT_ATA
	#define DBG_PRINT_ATA DBG_PRINT_ERR_PRM
#endif /*DBG_PRINT_ATA*/


#ifndef DFORMAT_PRINT
#define DFORMAT_PRINT(a)             DBG_PRINT_WRN_PRM(FLZONE_FORMAT,a)
#endif
#ifndef DEBUG_PRINT
#define DEBUG_PRINT(a)               DBG_PRINT_WRN(FLZONE_FULL,a)
#endif



/* For backwards compatibility we make sure tffsxxx is defined as flxxx
 *
 * Versions prior to 6.1 (when ENVIRONMENT_VARS was defined) the user was
 * required to customize 2 sets of DiskOnChip memory access routines.
 * (flxxx and flmemxxx). One set was for fast memory access and one
 * implemented a simple for loop for maximum platform portability. Newer
 * versions automatically implement the simple for loop allowing easier
 * customization. The new customization model allows the user to customize
 * only the tffsxxx routines regardless of the compilation flag
 */


#if !defined(FL_ENVIRONMENT_VARS) && defined(ENVIRONMENT_VARS)
  #define FL_ENVIRONMENT_VARS
#endif

#ifdef FL_ENVIRONMENT_VARS
  #ifndef tffscpy
    #define tffscpy flcpy
  #endif /* tffscpy */
  #ifndef tffscmp
    #define tffscmp flcmp
  #endif /* tffscmp */
  #ifndef tffsset
    #define tffsset flset
  #endif /* tffsset */
#endif /* FL_ENVIRONMENT_VARS */


/* Macro for converting text to string */
#ifndef FLTXT
  #define FLTXT
#endif /* FLTXT */

/*****************************/
/* M-Systems forced defaults */
/*****************************/

/*  define IO memory access macros - must be defined in flsystem.h */
#ifndef FLWRITE_IO_BYTE
  #define FLWRITE_IO_BYTE(val,address)      *((volatile FLByte FAR0*)(address))=(FLByte)(val)
#endif

#ifndef FLWRITE_IO_WORD
  #define FLWRITE_IO_WORD(val,address)      *((volatile FLWord FAR0*)(address))=(FLWord)(val)
#endif

#ifndef FLWRITE_IO_DWORD
  #define FLWRITE_IO_DWORD(val,address)     *((volatile FLDword FAR0*)(address))=(FLDword)(val)
#endif

#ifndef TFFSCPY_FROM_IO_8_BITS
  #ifdef  TFFSCPY_FROM_IO
    #define TFFSCPY_FROM_IO_8_BITS                    TFFSCPY_FROM_IO
  #else
    #define TFFSCPY_FROM_IO_8_BITS(dest,src,count)    tffscpy(dest,(void FAR0*)(src),count)
  #endif
#endif /* TFFSCPY_FROM_IO_8_BITS */

#ifndef TFFSCPY_FROM_IO_16_BITS
  #ifdef TFFSCPY_FROM_IO
    #define TFFSCPY_FROM_IO_16_BITS                   TFFSCPY_FROM_IO
  #else
    #define TFFSCPY_FROM_IO_16_BITS(dest,src,count)   tffscpy(dest,(void FAR0*)(src),count)
  #endif
#endif /* TFFSCPY_FROM_IO_16_BITS */

#ifndef FLREAD_IO_BYTE
  #define FLREAD_IO_BYTE(address)           (*((volatile FLByte FAR0*)(address)))
#endif

#ifndef FLREAD_IO_WORD
  #define FLREAD_IO_WORD(address)           (*((volatile FLWord FAR0*)(address)))
#endif

#ifndef FLREAD_IO_DWORD
  #define FLREAD_IO_DWORD(address)          (*((volatile FLDword FAR0*)(address)))
#endif

#ifndef TFFSCPY_TO_IO_8_BITS
  #ifdef TFFSCPY_TO_IO
    #define TFFSCPY_TO_IO_8_BITS                     TFFSCPY_TO_IO
  #else
    #define TFFSCPY_TO_IO_8_BITS(dest,src,count)     tffscpy((void FAR0*)(dest),src,count)
  #endif
#endif /* TFFSCPY_TO_IO_8_BITS */

#ifndef TFFSCPY_TO_IO_16_BITS
  #ifdef TFFSCPY_TO_IO
    #define TFFSCPY_TO_IO_16_BITS                     TFFSCPY_TO_IO
  #else
    #define TFFSCPY_TO_IO_16_BITS(dest,src,count)     tffscpy((void FAR0*)(dest),src,count)
  #endif
#endif /* TFFSCPY_TO_IO_16_BITS */

#ifndef TFFSSET_IO_8_BITS
  #ifdef TFFSSET_IO
    #define TFFSSET_IO_8_BITS                         TFFSSET_IO
  #else
    #define TFFSSET_IO_8_BITS(dest,val,count)         tffsset((void FAR0*)(dest),val,count)
  #endif
#endif /* TFFSSET_IO_8_BITS */

#ifndef TFFSSET_IO_16_BITS
  #ifdef TFFSSET_IO
    #define TFFSSET_IO_16_BITS                        TFFSSET_IO
  #else
    #define TFFSSET_IO_16_BITS(dest,val,count)        tffsset((void FAR0*)(dest),val,count)
  #endif
#endif /* TFFSSET_IO_16_BITS */

/* The FAT-LITE/SURE-FS API definitions were added the FL_ prefix.
 *
 * Starting from TrueFFS 6.2
 */


#ifndef FS_FILES
  #ifdef FILES
    #define FS_FILES               FILES
  #endif /* FILES         */
  #ifdef FL_FILES
    #define FS_FILES               FL_FILES
  #endif /* FL_FILES         */
#endif /* FS_FILES */

#if defined(FS_FILES) && (FS_FILES <= 0)
  #undef FS_FILES
#endif

#if defined(FS_MAX_FSOS) && ((FS_MAX_FSOS <= 0) || !defined(FS_FILES))
#undef FS_MAX_FSOS
#endif

#if defined(FS_SUPPORT_FILE_CACHE) && !defined(FS_MAX_FSOS)
#undef FS_SUPPORT_FILE_CACHE
/* you need FSOs to define the cache size per file type */
#endif

#if defined(FS_SUPPORT_FILE_CACHE) && !defined(FL_EXTENDED_SECTOR_CACHE)
#define FL_EXTENDED_SECTOR_CACHE
#endif

#if defined(FS_MAX_FSOS) && !defined(FS_MM_PERFORMANCE_TUNEUPS)
#define FS_MM_PERFORMANCE_TUNEUPS
#endif

#if defined(FS_MAX_FSOS) && !defined(STATIC_FS_DB)
#if FS_MAX_FSOS >= 2
#define STATIC_FS_DB	= { DEFAULT_FILE(0, 0), DEFINE_FSO(NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0) }
#else
#define STATIC_FS_DB	= { DEFAULT_FILE(0, 0) }
#endif
#endif

#if defined(SUB_DIRECTORY) && !defined(FS_SUB_DIRECTORY)
#define FS_SUB_DIRECTORY
#endif

#if defined(RENAME_FILE) && !defined(FS_RENAME_FILE)
#define FS_RENAME_FILE
#endif

#ifndef FILE_IS_ROOT_DIR
#define FILE_IS_ROOT_DIR		FL_FILE_IS_ROOT_DIR
#endif

#ifndef FILE_MODIFIED
#define FILE_MODIFIED			FL_FILE_MODIFIED
#endif

#ifndef FILE_IS_OPEN
#define FILE_IS_OPEN			FL_FILE_IS_OPEN
#endif

#ifndef FILE_IS_DIRECTORY
#define FILE_IS_DIRECTORY		FL_FILE_IS_DIRECTORY
#endif

#ifndef FILE_READ_ONLY
#define FILE_READ_ONLY			FL_FILE_READ_ONLY
#endif

#ifndef FILE_MUST_OPEN
#define FILE_MUST_OPEN			FL_FILE_MUST_OPEN
#endif


#if defined(FL_TRANSLATE_FROM_UNICODE) && defined(FL_TRANSLATE_TO_UNICODE)
#define FILENAMES_INTERNAL_UNICODE_CONVERSION		/* user-defined functions */

#elif defined(FL_LONG_FILENAMES_ASCII_SUPPORT)
#define FL_TRANSLATE_FROM_UNICODE	unicodeToAscii
#define FL_TRANSLATE_TO_UNICODE		asciiToUnicode

#define FILENAMES_INTERNAL_UNICODE_CONVERSION

#elif defined(FL_LONG_FILENAMES_UTF8_SUPPORT)
#define FL_TRANSLATE_FROM_UNICODE	unicodeToUTF8
#define FL_TRANSLATE_TO_UNICODE		UTF8ToUnicode

#define FILENAMES_INTERNAL_UNICODE_CONVERSION

#endif

#if defined(FL_EXTENDED_SECTOR_CACHE) && (!defined(FS_FILES) || (FS_FILES == 0))
#undef FL_EXTENDED_SECTOR_CACHE
#endif

#if defined(FL_EXTENDED_SECTOR_CACHE) && !defined(FS_DATA_CACHE_SIZE)
#define FS_DATA_CACHE_SIZE(socket, partition, logPartition)		200
#endif

#if defined(FAT_12BIT) && !defined(FS_FAT_12BIT)
#define FS_FAT_12BIT
#endif

/******************************** MTD Macros ********************************************/

#ifndef FL_CHANGE_READ_ACCESS_TIME
#define FL_CHANGE_READ_ACCESS_TIME(wTimeNanoSec,socket)
#endif /* FL_CHANGE_READ_ACCESS_TIME */

/****************************************************************************************/
/******************************* M I G R A T I O N    M A C R O S ***********************/
/****************************************************************************************/

/* Maximum number of supported DOCHs */
/*===================================*/
#ifndef DOCH_MAX_SOCKETS
	#ifdef FL_SOCKETS
		#define DOCH_MAX_SOCKETS  FL_SOCKETS
	#else /*FL_SOCKETS*/
		#define DOCH_MAX_SOCKETS  1
	#endif /*FL_SOCKETS*/
#endif /*DOCH_MAX_SOCKETS*/

/*
 * Length of DOCH register 'read' cycle in nanoseconds (default value should
 * do for most systems).
 */
#ifndef DOCH_ACCESS_NANOSEC
	#define DOCH_ACCESS_NANOSEC  15
#endif /*DOCH_ACCESS_NANOSEC*/

#ifndef DOCH_SPI_ACCESS_NANOSEC
	#define DOCH_SPI_ACCESS_NANOSEC 150000
#endif /*DOCH_SPI_ACCESS_NANOSEC*/

/* Host CPU ENDIANESS */
/*====================*/
#ifndef DOCH_BIG_ENDIAN
	#ifdef FL_BIG_ENDIAN
		#define DOCH_BIG_ENDIAN
	#endif /*FL_BIG_ENDIAN*/
#endif /*DOCH_BIG_ENDIAN*/

/* */
/*=*/
#ifndef DOCH_NO_INIT_MMU_PAGES
	#ifdef FL_NO_INIT_MMU_PAGES
		#define DOCH_NO_INIT_MMU_PAGES
	#endif /*FL_NO_INIT_MMU_PAGES*/
#endif /*DOCH_NO_INIT_MMU_PAGES*/



/*DOCH specific power mode defaults */
/*================================= */
/* by default DPD configured to:
   active mode is NORMAL,
   after command execution, device passes immediatly to
   IDLE mode and after timeout (100msec) to DPD mode*/
#ifndef DOCH_DPD_DEFAULT_ACTIVE_MODE
	#define DOCH_DPD_DEFAULT_ACTIVE_MODE	DOCH_WM_NORMAL_AND_AUTO_STBY		/*DOCH_WorkMode*/
#endif /*DOCH_DPD_DEFAULT_ACTIVE_MODE*/

#ifndef DOCH_DPD_DEFAULT_INACTIVE_MODE
	#define DOCH_DPD_DEFAULT_INACTIVE_MODE	DOCH_IM_IDLE_2_DPD			/*DOCH_InactiveMode*/
#endif /*DOCH_DPD_DEFAULT_INACTIVE_MODE*/

#ifndef DOCH_DPD_DEFAULT_DPD_TIMEOUT
	#define DOCH_DPD_DEFAULT_DPD_TIMEOUT	1
#endif /*DOCH_DPD_DEFAULT_DPD_TIMEOUT*/
/*================================= */
/* end of DOCH power mode settings */


/* Memory allocation */
/*===================*/
#ifndef DOCH_MALLOC
	#ifdef FL_MALLOC
		#define DOCH_MALLOC FL_MALLOC
	#endif /*FL_MALLOC*/
#endif /*DOCH_MALLOC*/

#ifndef DOCH_FREE
	#ifdef FL_FREE
		#define DOCH_FREE FL_FREE
	#endif /*FL_FREE*/
#endif /*DOCH_FREE*/

/* System init/release functions */
/*===============================*/
#ifndef DOCH_SYS_FUNC_INIT
#define DOCH_SYS_FUNC_INIT
#endif /* DOCH_SYS_FUNC_INIT */

#ifndef DOCH_SYS_FUNC_RELEASE
	#ifdef FL_SYS_FUNC_RELEASE
		#define DOCH_SYS_FUNC_RELEASE FL_SYS_FUNC_RELEASE
	#else /*FL_SYS_FUNC_RELEASE*/
		#define DOCH_SYS_FUNC_RELEASE()
	#endif /*FL_SYS_FUNC_RELEASE*/
#endif /*DOCH_SYS_FUNC_RELEASE*/

/* DMA transfer */
/*==============*/
#ifndef DOCH_DMA_CONFIG
	#ifdef FL_DMA_CONFIG
		#define DOCH_DMA_CONFIG FL_DMA_CONFIG
	#endif /*FL_DMA_CONFIG*/
#endif

#define DOCH_DMA_OPEN_CHANNEL								0
#define DOCH_DMA_CONFIG_TRANSACTION_DEVICE_TO_HOST			1
#define DOCH_DMA_FREE_CHANNEL								2
#define DOCH_DMA_WAIT_FOR_READ_TRANSACTION_END				3
#define DOCH_DMA_WAIT_FOR_WRITE_TRANSACTION_END				4
#define DOCH_DMA_CONFIG_TRANSACTION_HOST_TO_DEVICE			5

#ifndef DOCH_DMA_PULSE_WIDTH
	#define DOCH_DMA_PULSE_WIDTH 0x001F
#endif /*DOCH_DMA_PULSE_WIDTH*/

/* DOCH_DMA_CHECK_BUFFER checks if buffer is suitable for DMA transfer*/
#ifndef DOCH_DMA_CHECK_BUFFER
	#define DOCH_DMA_CHECK_BUFFER(bufAddress, sectors)		(((FLDword)bufAddress & 0x3) == 0)
#endif /*DOCH_DMA_CHECK_BUFFER*/

/* Burst Mode */
/*============*/

#ifndef DOCH_USE_BURST_MODE_READ
	#ifdef FL_USE_BURST_MODE_READ
		#define DOCH_USE_BURST_MODE_READ
	#endif /*FL_USE_BURST_MODE_READ*/
#endif  /*DOCH_USE_BURST_MODE_READ*/

#ifdef DOCH_USE_BURST_MODE_READ

	#ifndef DOCH_HOST_ENTER_READ_BURST_MODE
		#ifdef FL_HOST_ENTER_BURST_MODE
			#define DOCH_HOST_ENTER_READ_BURST_MODE FL_HOST_ENTER_BURST_MODE();
		#else /*FL_HOST_ENTER_BURST_MODE*/
			#define DOCH_HOST_ENTER_READ_BURST_MODE
		#endif /*FL_HOST_ENTER_BURST_MODE*/
	#endif /*DOCH_HOST_ENTER_READ_BURST_MODE*/

	#ifndef DOCH_HOST_EXIT_READ_BURST_MODE
		#ifdef FL_HOST_EXIT_BURST_MODE
			#define DOCH_HOST_EXIT_READ_BURST_MODE	FL_HOST_EXIT_BURST_MODE();
		#else /*FL_HOST_EXIT_BURST_MODE*/
			#define DOCH_HOST_EXIT_READ_BURST_MODE
		#endif /*FL_HOST_EXIT_BURST_MODE*/
	#endif /*DOCH_HOST_EXIT_READ_BURST_MODE*/

#endif /*DOCH_USE_BURST_MODE_READ*/

#ifdef DOCH_USE_BURST_MODE_WRITE

	#ifndef DOCH_HOST_ENTER_WRITE_BURST_MODE
		#define DOCH_HOST_ENTER_WRITE_BURST_MODE
	#endif /*DOCH_HOST_ENTER_WRITE_BURST_MODE*/

	#ifndef DOCH_HOST_EXIT_WRITE_BURST_MODE
		#define DOCH_HOST_EXIT_WRITE_BURST_MODE
	#endif /*DOCH_HOST_EXIT_WRITE_BURST_MODE*/

#endif /*DOCH_USE_BURST_MODE_WRITE*/

#ifndef DOCH_BURST_LENGTH
	#ifdef BURST_LENGTH
		#define DOCH_BURST_LENGTH ( (((BURST_LENGTH)-2)& 0x03 ) <<11)
	#else
		#ifdef FL_USE_BURST_MODE_READ
			#ifdef FL_MIGRATION_VERSION
				#error BURST_LENGTH must be defined, when FL_USE_BURST_MODE_READ defined
			#else
				#error DOCH_BURST_LENGTH must be defined, when DOCH_USE_BURST_MODE_READ defined
			#endif /* migration*/
		#endif /*FL_USE_BURST_MODE_READ*/
	#endif /* BURST_LENGTH */
#endif /*DOCH_BURST_LENGTH*/

#ifndef DOCH_BURST_LATENCY
	#ifdef BURST_LATENCY
		#define DOCH_BURST_LATENCY ( ((BURST_LATENCY)& 0x07 )<<8)
	#else
		#ifdef FL_USE_BURST_MODE_READ
			#ifdef FL_MIGRATION_VERSION
				#error BURST_LATENCY must be defined, when FL_USE_BURST_MODE_READ defined
			#else
				#error DOCH_BURST_LATENCY must be defined, when DOCH_USE_BURST_MODE_READ defined
			#endif /* migration*/
		#endif /*FL_USE_BURST_MODE_READ*/
	#endif /* BURST_LENGTH */
#endif /*DOCH_BURST_LATENCY*/

#ifndef DOCH_BURST_HOLD
	#ifdef BURST_HOLD
		#define DOCH_BURST_HOLD ((BURST_HOLD)<<13)
	#else
		#ifdef FL_USE_BURST_MODE_READ
			#ifdef FL_MIGRATION_VERSION
				#error BURST_HOLD must be defined, when FL_USE_BURST_MODE_READ defined
			#else
				#error DOCH_BURST_HOLD must be defined, when DOCH_USE_BURST_MODE_READ defined
			#endif /* migration*/
		#endif /*FL_USE_BURST_MODE_READ*/
	#endif /* BURST_HOLD */
#endif /*DOCH_BURST_HOLD*/

#ifndef DOCH_BURST_WAIT_STATE
	#ifdef BURST_WAIT_STATE
		#define DOCH_BURST_WAIT_STATE	( ((BURST_WAIT_STATE)&0x03 )<<4)
	#else
		#ifdef FL_USE_BURST_MODE_READ
			#ifdef FL_MIGRATION_VERSION
				#error BURST_WAIT_STATE must be defined, when FL_USE_BURST_MODE_READ defined
			#else
				#error DOCH_BURST_WAIT_STATE must be defined, when DOCH_USE_BURST_MODE_READ defined
			#endif /* migration*/
		#endif /*FL_USE_BURST_MODE_READ*/
	#endif
#endif /*DOCH_BURST_WAIT_STATE*/

/* end of BURST definitions for H3 */
/*=================================*/



/* Interrupt enabling */
/*====================*/

#define DOCH_INT_RB_DISABLED	0x00
#define DOCH_INT_RB_ENABLED		0x01

#ifndef DOCH_IRQ_RB_INIT
	#ifdef FL_IRQ_RB_INIT
		#define DOCH_IRQ_RB_INIT(wSockeNo) FL_IRQ_RB_INIT((wSockeNo))
	#else /*FL_IRQ_RB_INIT*/
		#define DOCH_IRQ_RB_INIT(wSockeNo) gDochIrqEnabled[(wSockeNo)]
	#endif /*FL_IRQ_RB_INIT*/
#endif /*DOCH_IRQ_RB_INIT*/

/* MACRO for "Wait on Interrupt" */
/*===============================*/
#ifndef DOCH_SLEEP
	#ifdef FL_TFFS_SLEEP
		#define DOCH_SLEEP(socket, device, microseconds) FL_TFFS_SLEEP(socket, microseconds)
	#else
		#define DOCH_SLEEP(socket, device, microseconds)
	#endif /*FL_TFFS_SLEEP*/
#endif /*DOCH_SLEEP*/

/* MACRO for notifying application that an interrupt had occurred
   and was NOT yet serviced */
/*==========================*/
#ifndef DOCH_UNSERVICED_INTERRUPT
	#define DOCH_UNSERVICED_INTERRUPT(socket, device) 	DOCH_SLEEP(socket, device, 0)
#endif /*DOCH_UNSERVICED_INTERRUPT*/


/* DOCH HW Configuration defaults */
/*================================*/

#ifndef DOCH_BURST_WRITE_MODE_DEFAULT
	#define DOCH_BURST_WRITE_MODE_DEFAULT		(DOCH_BURST_DISABLE | DOCH_BURST_HOLD_1_CLK | DOCH_BURST_LEN_4_CYC)
#endif /*DOCH_BURST_WRITE_MODE_DEFAULT*/

#ifndef DOCH_BURST_READ_MODE_DEFAULT
	#define DOCH_BURST_READ_MODE_DEFAULT		(DOCH_BURST_DISABLE | DOCH_BURST_HOLD_1_CLK | DOCH_BURST_LEN_4_CYC)
#endif /*DOCH_BURST_READ_MODE_DEFAULT*/

#ifndef DOCH_IPL_CTRL_DEFAULT
    #define DOCH_IPL_CTRL_DEFAULT               (DOCH_IPL_WRITE_ENABLE | DOCH_IPL_ALL_CS_ENABLED)
#endif /*DOCH_IPL_CTRL_DEFAULT*/

#ifndef DOCH_WARM_BOOT_CTRL_DEFAULT
	#define DOCH_WARM_BOOT_CTRL_DEFAULT			(DOCH_WARM_RST_POLARITY_HIGH | DOCH_WARM_RST_BURST_ON)
#endif /*DOCH_WARM_BOOT_CTRL_DEFAULT*/

#ifndef DOCH_POWER_DOWN_DEFAULT
	#define DOCH_POWER_DOWN_DEFAULT				(DOCH_DPD_PIN_POL_HIGH | DOCH_DPD_PIN_ENABLED | DOCH_DPD_WAKEUP_HOST_CE)
#endif /*DOCH_POWER_DOWN_DEFAULT*/

#ifndef DOCH_DMA_CTRL_DEFAULT
	#define DOCH_DMA_CTRL_DEFAULT				(DOCH_DMA_REQ_POL_LOW | DOCH_DMA_REQ_EDGE | ((DOCH_DMA_PULSE_WIDTH)<<4))
#endif /*DOCH_DMA_CTRL_DEFAULT*/

#ifndef DOCH_DMA_NEGATION_CTRL_DEFAULT
	#define DOCH_DMA_NEGATION_CTRL_DEFAULT		1
#endif /*DOCH_DMA_NEGATION_CTRL_DEFAULT*/

#ifndef DOCH_SLOCK_DEFAULT
	#define DOCH_SLOCK_DEFAULT					DOCH_SLOCK_OFF
#endif /*DOCH_SLOCK_DEFAULT*/

#ifndef DOCH_ENDIAN_CTRL_DEFAULT
	#ifdef FL_SWAP_BYTES
		#define DOCH_ENDIAN_CTRL_DEFAULT		(HIB_END_SWAP_ON)
	#else /*FL_SWAP_BYTES*/
		#define DOCH_ENDIAN_CTRL_DEFAULT		(HIB_END_SWAP_OFF)
	#endif /*FL_SWAP_BYTES*/
#endif /*DOCH_ENDIAN_CTRL_DEFAULT*/

#ifndef DOCH_OPERATION_MODE_CTRL_DEFAULT
	#define DOCH_OPERATION_MODE_CTRL_DEFAULT	(HIB_ADDR_SHIFT | HIB_NON_PIPE_ACCESS)
#endif /*DOCH_OPERATION_MODE_CTRL_DEFAULT*/


/*Max number of devices per ATA socket (defined by ATA standard)*/
#ifndef ATA_MAX_NUM_OF_DEVICES /* for mDOC H3 devices only */
	#define ATA_MAX_NUM_OF_DEVICES	1 /* should be 1 or 2 */
#endif /* ATA_MAX_NUM_OF_DEVICES */


#if 0
/*===========================*/
/* Access Layer Customization*/
/* --------------------------*/
/* 2 Sections:				 */
/*	- Run-Time				 */
/*	- Compile Time			 */
/*===========================*/
#ifdef DOCH_BIG_ENDIAN
  #define C_16_8(a)	((FLByte)((a)>>8))
  #define C_8_16(a)	(((FLWord)(a))<<8)
  #define C_16_16(a)  ((FLWord)((a)<<8) | ((a)>>8))
#else
  #define C_16_8(a)	((FLByte)(a))
  #define C_8_16(a)	((FLWord)(a))
  #define C_16_16(a)  ((FLWord)(a))
#endif /* DOCH_BIG_ENDIAN */

#endif  /* #if 0 */

#ifdef DOCH_USE_FUNC	/*Run-time*/

  /* DOCH Access Layer macros */
  /*==========================*/
  #ifndef DOCHREAD_ATA_REG
    #define DOCHREAD_ATA_REG(base, regNum)			C_16_8(pdev->halRoutines.hal_get_ata_reg(base, regNum))
    //#define DOCHREAD_ATA_REG(regNum)          C_16_8(*(((PVUINT16)pMdocAtaReg) + regNum))
  #endif /*DOCHREAD_ATA_REG*/
  #ifndef DOCHWRITE_ATA_REG
    #define DOCHWRITE_ATA_REG(base, regNum, val)	(pdev->halRoutines.hal_set_ata_reg(base, regNum, C_8_16(val)))
    //#define DOCHWRITE_ATA_REG(regNum, val)    (*(((PVUINT16)pMdocAtaReg) + regNum) =  C_8_16(val))
  #endif /*DOCHWRITE_ATA_REG*/
  #ifndef DOCHREAD_CTRL_REG
    #define DOCHREAD_CTRL_REG(base, regNum)			C_16_16(pdev->halRoutines.hal_get_ctrl_reg(base, regNum))
    //#define DOCHREAD_CTRL_REG(regNum)         C_16_16(*(((PVUINT16)pMdocCfgReg) + regNum))
  #endif /*DOCHREAD_CTRL_REG*/
  #ifndef DOCHWRITE_CTRL_REG
    #define DOCHWRITE_CTRL_REG(base, regNum, val)	(pdev->halRoutines.hal_set_ctrl_reg(base, regNum, C_16_16(val)))
    //#define DOCHWRITE_CTRL_REG(regNum, val)   (*(((PVUINT16)pMdocCfgReg) + regNum) = C_16_16(val))
  #endif /*DOCHWRITE_CTRL_REG*/
  #ifndef DOCHBLK_READ
    #define DOCHBLK_READ(address, buf, sectors)		(pdev->halRoutines.hal_blk_read(address, buf, sectors))
  #endif /*DOCHBLK_READ*/
  #ifndef DOCHBLK_WRITE
    #define DOCHBLK_WRITE(address, buf, sectors)	(pdev->halRoutines.hal_blk_write(address, buf, sectors))
  #endif /*DOCHBLK_WRITE*/

  #ifndef DOCHREAD_BURST
	#define DOCHREAD_BURST(base, offset, dest, sectors)
  #endif /*DOCHREAD_BURST*/

  #ifndef DOCHWRITE_BURST
  	#define DOCHWRITE_BURST(base, offset, dest, sectors)
  #endif /*DOCHWRITE_BURST*/

	/* DOCH IO Access macros */
	/*=======================*/
	#ifndef DOCHREAD_IO_WORD
		#define DOCHREAD_IO_WORD(address)					(FLREAD_IO_WORD(address))
	#endif /*DOCHREAD_IO_WORD*/

	#ifndef DOCHWRITE_IO_WORD
		#define DOCHWRITE_IO_WORD(val, address)				(FLWRITE_IO_WORD(val, address))
	#endif /*DOCHWRITE_IO_WORD*/

	#ifndef DOCHCPY_TO_IO_16_BITS
		#define DOCHCPY_TO_IO_16_BITS(win,buf,sectors)		(blk_write_using_data_reg(win, buf, sectors))
	#endif /*DOCHCPY_TO_IO_16_BITS*/

	#ifndef DOCHCPY_FROM_IO_16_BITS
		#define DOCHCPY_FROM_IO_16_BITS(win,buf,sectors)	(blk_read_using_data_reg(win, buf, sectors))
	#endif /*DOCHCPY_FROM_IO_16_BITS*/

#else  /*DOCH_USE_FUNC*/	/*Compile-Time*/

  #ifdef FL_MIGRATION_VERSION
  /* DOCH Access Layer macros */
  /*==========================*/
  #ifndef DOCHREAD_ATA_REG
    #define DOCHREAD_ATA_REG(base, regNum)	C_16_8(flDirectRead16BitReg((DOCHFlash),(FLWord)(((regNum)<<1) + DOCH_CONT_REG_AREA)))
  #endif /*DOCHREAD_ATA_REG*/
  #ifndef DOCHWRITE_ATA_REG
    #define DOCHWRITE_ATA_REG(base, regNum, val) 	flDirectWrite16BitReg((DOCHFlash),(FLWord)(((regNum)<<1) + DOCH_CONT_REG_AREA),(FLWord)(C_8_16(val)))
  #endif /*DOCHWRITE_ATA_REG*/
  #ifndef DOCHREAD_CTRL_REG
   #define DOCHREAD_CTRL_REG(base, regNum) C_16_16(flDirectRead16BitReg((DOCHFlash),(FLWord)(regNum)))
  #endif /*DOCHREAD_CTRL_REG*/
  #ifndef DOCHWRITE_CTRL_REG
    #define DOCHWRITE_CTRL_REG(base, regNum, val) 	flDirectWrite16BitReg((DOCHFlash),(FLWord)(regNum),(FLWord)(C_16_16(val)))
  #endif /*DOCHWRITE_CTRL_REG*/
  #ifndef DOCHBLK_READ
    #define DOCHBLK_READ(address, buf, sectors) 	(flRead512Bytes((DOCHFlash),(FLWord)DOCH_DATA_PORT_AREA,(buf)),0)
  #endif /*DOCHBLK_READ*/
  #ifndef DOCHBLK_WRITE
    #define DOCHBLK_WRITE(address, buf, sectors) 	(flWrite512Bytes((DOCHFlash),(FLWord)DOCH_DATA_PORT_AREA,(buf)),0)
  #endif /*DOCHBLK_WRITE*/

#ifndef DOCHREAD_BURST
#define DOCHREAD_BURST(base, offset, dest, sectors) DOCHBLK_READ( (base)+(offset), dest, sectors)
#endif /*DOCHREAD_BURST*/

#ifndef DOCHWRITE_BURST
#define DOCHWRITE_BURST(base, offset, dest, sectors) DOCHBLK_READ( (base)+(offset), dest, sectors)
#endif /*DOCHWRITE_BURST*/


/* DOCH IO Access macros */
/*=======================*/
/* Not defined as we use legacy code */

#else /* FL_MIGRATION_VERSION */

	#ifndef DOCHREAD_ATA_REG
		#define DOCHREAD_ATA_REG(base, regNum)	\
			(FLByte)(DOCHREAD_IO_WORD((((volatile FLWord FAR0 *)base)+regNum + (DOCH_CONT_REG_AREA/2))));
                    //(*(((PVUINT16)pMdocAtaReg) + regNum))
	#endif /*DOCHREAD_ATA_REG*/

	#ifndef DOCHWRITE_ATA_REG
		#define DOCHWRITE_ATA_REG(base, regNum, val) \
		  DOCHWRITE_IO_WORD((FLWord)val,(((volatile FLWord FAR0 *)base)+regNum + (DOCH_CONT_REG_AREA/2)));
        //#define DOCHWRITE_ATA_REG(regNum, val)    (*(((PVUINT16)pMdocAtaReg) + regNum) =  C_8_16(val))
	#endif /*DOCHWRITE_ATA_REG*/

	#ifndef DOCHREAD_CTRL_REG
		#define DOCHREAD_CTRL_REG(base, regNum)	\
			DOCHREAD_IO_WORD(base + regNum);
          //#define DOCHREAD_CTRL_REG(regNum)         C_16_16(*(((PVUINT16)pMdocCfgReg) + regNum))
	#endif /*DOCHREAD_CTRL_REG*/

	#ifndef DOCHWRITE_CTRL_REG
		#define DOCHWRITE_CTRL_REG(base, regNum, val) \
			DOCHWRITE_IO_WORD((FLWord)val, (base + regNum));
        //#define DOCHWRITE_CTRL_REG(regNum, val)   (*(((PVUINT16)pMdocCfgReg) + regNum) = C_16_16(val))

	#endif /*DOCHWRITE_CTRL_REG*/

	#ifndef DOCHBLK_READ
		#define DOCHBLK_READ(address, buf, sectors) \
			DOCHCPY_FROM_IO_16_BITS(address, buf, sectors)
	#endif /*DOCHBLK_READ*/

	#ifndef DOCHBLK_WRITE
		#define DOCHBLK_WRITE(address, buf, sectors) \
			DOCHCPY_TO_IO_16_BITS(address, buf, sectors)
	#endif /*DOCHBLK_WRITE*/

	/* DOCH IO Access macros */
	/*=======================*/
	#ifndef DOCHREAD_IO_WORD
		#define DOCHREAD_IO_WORD(address)					(FLREAD_IO_WORD(address))
	#endif /*DOCHREAD_IO_WORD*/

	#ifndef DOCHWRITE_IO_WORD
		#define DOCHWRITE_IO_WORD(val, address)				(FLWRITE_IO_WORD(val, address))
	#endif /*DOCHWRITE_IO_WORD*/

	#ifndef DOCHCPY_TO_IO_16_BITS
		#define DOCHCPY_TO_IO_16_BITS(win,buf,sectors)		TFFSCPY_TO_IO_16_BITS(win,buf,(sectors<<DOCH_SECTOR_SIZE_BITS))
	#endif /*DOCHCPY_TO_IO_16_BITS*/

	#ifndef DOCHCPY_FROM_IO_16_BITS
		#define DOCHCPY_FROM_IO_16_BITS(win,buf,sectors)	TFFSCPY_FROM_IO_16_BITS(win,buf,(sectors<<DOCH_SECTOR_SIZE_BITS))
	#endif /*DOCHCPY_FROM_IO_16_BITS*/

#endif /* FL_MIGRATION_VERSION */

#endif /*DOCH_USE_FUNC*/

#ifndef DOCH_SET_WINDOW_OFFSET
	#define DOCH_SET_WINDOW_OFFSET(using8KB, baseAddr)
#endif /*DOCH_SET_WINDOW_OFFSET*/

#endif /* _FL_CHK_DEFS_H_ */
