/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/common/flcommon.h-arc  $
 *
 *    Rev 1.13.1.0   Aug 09 2006 17:36:54   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef FLCOMMON_H
#define FLCOMMON_H

#include "_common.h"
#include "flsystem.h"
#include "flcustom.h"

/**************************************************************************/
/* Status code for operation:                                             */
/*   A zero value indicates success, other codes are various error codes. */
/*   if IFLITE_ERROR_CODES is defined at flsystem.h, DOS codes will be     */
/*   used instead of legacy TrueFFS codes.                                */
/**************************************************************************/
#ifndef IFLITE_ERROR_CODES
typedef enum {
         flOK                      = 0,
         flBadFunction             = 1,
         flFileNotFound            = 2,
         flPathNotFound            = 3,
         flTooManyOpenFiles        = 4,
         flNoWriteAccess           = 5,
         flBadFileHandle           = 6,
         flDriveNotAvailable       = 9,
         flNonFATformat            = 10,
         flFormatNotSupported      = 11,
         flNoMoreFiles             = 18,
         flWriteProtect            = 19,
         flBadDriveHandle          = 20,
         flDriveNotReady           = 21,
         flUnknownCmd              = 22,
         flBadFormat               = 23,
         flBadLength               = 24,
         flDataError               = 25,
         flUnknownMedia            = 26,
         flSectorNotFound          = 27,
         flOutOfPaper              = 28,
         flWriteFault              = 29,
         flReadFault               = 30,
         flGeneralFailure          = 31,
         flDiskChange              = 34,
         flVppFailure              = 50,
         flBadParameter            = 51,
         flNoSpaceInVolume         = 52,
         flInvalidFATchain         = 53,
         flRootDirectoryFull       = 54,
         flNotMounted              = 55,
         flPathIsRootDirectory     = 56,
         flNotADirectory           = 57,
         flDirectoryNotEmpty       = 58,
         flFileIsADirectory        = 59,
         flAdapterNotFound         = 60,
         flFormattingError         = 62,
         flNotEnoughMemory         = 63,
         flVolumeTooSmall          = 64,
         flBufferingError          = 65,
         flFileAlreadyExists       = 80,
         flForceDismount           = 85,
         flIncomplete              = 100,
         flTimedOut                = 101,
         flTooManyComponents       = 102,
         flTooManyDrives           = 103,
         flTooManyBinaryPartitions = 104,
         flPartitionNotFound       = 105,
         flFeatureNotSupported     = 106,
         flWrongVersion            = 107,
         flTooManyBadBlocks        = 108,
         flNotProtected            = 109,
         flUnchangeableProtection  = 110,
         flBadDownload             = 111,
         flBadBBT                  = 112,
         flInterleaveError         = 113,
         flWrongKey                = 114,
         flHWProtection            = 115,
         flLeftForCompetability    = 116,
         flMultiDocContradiction   = 117,
         flCanNotFold              = 118,
         flBadIPLBlock             = 119,
         flIOCommandBlocked        = 120,
         flBadTransaction          = 121,
         flTooManyTransactions     = 122,
         flUnitIsNotErased         = 123,
         flSequenceError           = 124,
         flFIFOTimeOut             = 125,
         flUnitIsBad               = 126,
         flFlashIsVirgin           = 127,
         flQuickMountNotValid      = 128,

         flSuspendModeDetected     = 129,
         flDmaFailed     		   = 130,
		 flSuspendDueToHWFailure   = 131,

         flCannotCreateShortName   = 150,
         flInvalidCharSet	       = 151,
         flOverwriteExistingEntry  = 152,
         flBufferTooShort	       = 153,
         flPathTooLong		       = 154,
         flBadPartitionSize        = 155,
         flTooManyPartitions       = 156,
         flFSO_IDnotFound	       = 157,
         flFSO_IDisBusy	     	   = 158

#else

#include "type.h"

typedef enum {      /* Status code for operation.
                       A zero value indicates success,
                       other codes are the extended
                       DOS codes. */
             flOK                  = ERR_NONE,
             flBadFunction         = ERR_SW_HW,
             flFileNotFound        = ERR_NOTEXISTS,
             flPathNotFound        = ERR_NOTEXISTS,
             flTooManyOpenFiles    = ERR_MAX_FILES,
             flNoWriteAccess       = ERR_WRITE,
             flBadFileHandle       = ERR_NOTOPEN,
             flDriveNotAvailable   = ERR_SW_HW,
             flNonFATformat        = ERR_PARTITION,
             flFormatNotSupported  = ERR_PARTITION,
             flNoMoreFiles         = ERR_NOTEXISTS,
             flWriteProtect        = ERR_WRITE,
             flBadDriveHandle      = ERR_SW_HW,
             flDriveNotReady       = ERR_PARTITION,
             flUnknownCmd          = ERR_PARAM,
             flBadFormat           = ERR_PARTITION,
             flBadLength           = ERR_SW_HW,
             flDataError           = ERR_READ,
             flUnknownMedia        = ERR_PARTITION,
             flSectorNotFound      = ERR_READ,
             flOutOfPaper          = ERR_SW_HW,
             flWriteFault          = ERR_WRITE,
             flReadFault           = ERR_READ,
             flGeneralFailure      = ERR_SW_HW,
             flDiskChange          = ERR_PARTITION,
             flVppFailure          = ERR_WRITE,
             flBadParameter        = ERR_PARAM,
             flNoSpaceInVolume     = ERR_SPACE,
             flInvalidFATchain     = ERR_PARTITION,
             flRootDirectoryFull   = ERR_DIRECTORY,
             flNotMounted          = ERR_PARTITION,
             flPathIsRootDirectory = ERR_DIRECTORY,
             flNotADirectory       = ERR_DIRECTORY,
             flDirectoryNotEmpty   = ERR_NOT_EMPTY,
             flFileIsADirectory    = ERR_DIRECTORY,
             flAdapterNotFound     = ERR_DETECT,
             flFormattingError     = ERR_FORMAT,
             flNotEnoughMemory     = ERR_SW_HW,
             flVolumeTooSmall      = ERR_FORMAT,
             flBufferingError      = ERR_SW_HW,
             flFileAlreadyExists   = ERR_EXISTS,
             flIncomplete          = ERR_DETECT,
             flTimedOut            = ERR_SW_HW,
             flTooManyComponents   = ERR_PARAM
#endif
} FLStatus;


#ifndef FL_DISABLE_OLD_TRUEFFS_TYPES
/**************************************************************************/
/* TrueFFS used to export several basic types. These type were changed in */
/* TrueFFS 6.0 , but to allows old application based on these type to     */
/* function we keep exporting them.                                       */
/**************************************************************************/
typedef unsigned char  byte;        /* 8  bit unsigned variable */
typedef unsigned short word;        /* 16 bit unsigned variable */
typedef unsigned long  dword;       /* 32 bit unsigned variable */

typedef signed char  Sbyte;         /* 8  bit signed variable */
typedef signed short Sword;         /* 16 bit signed variable */
typedef signed long  Sdword;        /* 32 bit signed variable */
#endif /* FL_DISABLE_OLD_TRUEFFS_TYPES */


/**************************************************************************/
/*  Various defines:                                                      */
/*    The following types are used by various TrueFFS packages and        */
/*    also exported as an external API.                                   */
/**************************************************************************/

/* define SectorNo range according to media maximum size */
typedef FLDword SectorNo;
#define    UNASSIGNED_SECTOR 0xffffffffl

/* On / Off definitions of various commands*/
#define FL_ON    1
#define FL_OFF   0

#define DEEP_POWER_DOWN          1 /* must be the same as in blockdev.h */
#define EXIT_DEEP_POWER_DOWN     0 /* must be the same as in blockdev.h */

#define LOCKED_OTP               1

/*Definition of a sector size*/
#define FL_SECTOR_SIZE_BITS 9
#define FL_SECTOR_SIZE        (1 << FL_SECTOR_SIZE_BITS)

/* IPL modes settings*/
#define FL_IPL_MODE_NORMAL          0   /* IPL - Written as usual                     */
#define FL_IPL_DOWNLOAD             1   /* IPL - Force download of new IPL            */
#define FL_DOC_IPL_PAGED_RAM_MODE   4   /* IPL - Written in paged RAM mode.  */
#define FL_IPL_VIRTUAL_RAM_MODE     8   /* IPL - Written in Virtual RAM mode          */
#define FL_IPL_ALERNATE_MAP         16  /* IPL - Written with X-Scale mode enabled    */
#define FL_IPL_128K_WINDOW_MODE     32  /* IPL - Set DOC device to 128K window mode.  */
#define FL_IPL_NO_ADDRESS_SHIFT_MODE 64  /*IPL - Set DOC device in address shift mode. */
#define FL_IPL_SWAP_BYTES_MODE      128 /*IPL - Set DOC device in swap bytes mode. */

/* Bit 3 Virtual/Paged# mode bit                                                */
#define FL_IPL_PAGED_RAM_MODE   0  /* IPL - Written in Paged   RAM mode          */

 /* Bit 15 Write data in buffers */
#define FL_USING_BUFFERS        0x8000  /* IPL - Allow accessing the IPL using buffers */

/*** MTD Special services types foe HW config commands    ***/
#define FL_IRQ_RB_TYPE                  0x0
#define FL_DPD_TYPE                     0x1
#define FL_PAGE_MODE_TYPE               0x2
#define FL_TURBO_MODE_TYPE              0x3
#define FL_DPS_2_COPIES_TYPE            0x4
#define FL_DMA_TYPE                     0x5
#define FL_NONTURBO_MODE                0
#define FL_TURBO_MODE                   1
#define FL_DMA_HW_ENABLED               1
#define FL_DMA_HW_DISABLED              0
#define FL_DMA_REQ_EDGE                 2
#define FL_DMA_REQ_LEVEL                0
#define FL_NEGATED_1_ASSERTED_0         0
#define FL_NEGATED_0_ASSERTED_1         4
#define FL_DMA_IRQ_ENABLED              8
#define FL_DMA_IRQ_DISABLED             0
#define FL_DMA_IRQ_EDGE                 0x10
#define FL_DMA_IRQ_LEVEL                0
#define FL_IRQ_LEVEL_TYPE               0x0
#define FL_IRQ_EDGE_TYPE                0x2
#define FL_INT_RB_DISABLED              0x0
#define FL_INT_RB_ENABLED               0x1
#define FL_DPD_DISABLED                 0
#define FL_DPD_EXIT_RISE_EDGE           1
#define FL_DPD_EXIT_FALL_EDGE           2
#define FL_DPD_ENTER_1_EXIT_0           4
#define FL_DPD_ENTER_0_EXIT_1           8
#define FL_ENABLED                      0x1
#define FL_DISABLED                     0x0

/* Protection attributes */
#define PROTECTABLE           1   /* partition can recieve protection */
#define READ_PROTECTED        2   /* partition is read protected      */
#define WRITE_PROTECTED       4   /* partition is write protected     */
#define LOCK_ENABLED          8   /* HW lock signal is enabled        */
#define LOCK_ASSERTED         16  /* HW lock signal is asserted       */
#define KEY_INSERTED          32  /* key is inserted (not currently   */
#define CHANGEABLE_PROTECTION 64  /* changeable protection area type  */
#define OTW_PROTECTED         128 /* partition is locked forever      */
#define STICKY_LOCK_ASSERTED  256 /* Sticky lock is activated         */


/*BDK API defines */
#define BDK_COMPLETE_IMAGE_UPDATE       16
#define BDK_PARTIAL_IMAGE_UPDATE        0
#define BDK_SIGNATURE_NAME              4

/* BUS setting interface */
#define FL_BUS_HAS_8BIT_ACCESS     0x00000001L /* Bus can access 8-bit  */
#define FL_BUS_HAS_16BIT_ACCESS    0x00000002L /* Bus can access 16-bit */
#define FL_BUS_HAS_32BIT_ACCESS    0x00000004L /* Bus can access 32-bit */

#define FL_NO_ADDR_SHIFT           0x00000000L /* No address shift     */
#define FL_SINGLE_ADDR_SHIFT       0x00000010L /* Single address shift */
#define FL_DOUBLE_ADDR_SHIFT       0x00000020L /* Double address shift */

/* TrueFFS Debug modes */
#define FL_QUICK_MOUNT_DO_NOT_READ    0x01 /* Do not use the quick mount when mounting */
#define FL_QUICK_MOUNT_DO_NOT_WRITE   0x02 /* Do not write the quick mount on dismount */
#define FL_QUICK_MOUNT_DISABLED       0x03 /* Mask for the above 2 flags               */

/*power management commands*/
#define FL_PREPARE_FOR_RESUME    1

/*defined for logical format*/
#define FL_MEDIA_WITHOUT_MBR			(1 << 12)	/* used by LogMount & formatFS */
#define FL_MOUNT_ON_GIVEN_RANGE			(1 << 13)	/* used by LogMount & formatFS */
#define FL_MOUNT_FOR_BLOCK_IO			(1 << 14)	/* used by LogMount only */

#define FL_MARK_PARTITION_BOOTABLE	0x80

#define VOLUME_12BIT_FAT	4  /* Volume uses 12-bit FAT                     */

/**************************************************************************/
/*  DMA Interface:                                                        */
/*    The following types are used for interfacing the DMA handling       */
/*    module and TrueFFS module                                           */
/**************************************************************************/
typedef struct __DMA_Params_S
{
  FLWord wDiskOnChip_Offset ;
  FLWord wFrameSize ;
  FLWord wFramesInBlock ;
  FLWord wFramesXferred ;
  FLByte *bDiskOnChip_BasePtr ;
  FLByte *bDestAddrPtr ;
  FLByte bOpType ;
  FLByte bIrHandle ;
  FLBoolean fDmaStatus ;
  void *DrvParamsPtr ;
} DMA_Params_S  ;


/**************************************************************************/
/*  trueFFS environment variables definitions:                            */
/*    The following type defines all the TrueFFS environment variables    */
/*    Which can ce controlled by the SetEnv commands.                     */
/**************************************************************************/
typedef enum {        /* Variable type code for flSetEnv routine */
      FL_ENV_VARS_PER_SYSTEM           = 0,
      FL_IS_RAM_CHECK_ENABLED          = 1, /* No longer supported from 6.1 */
      FL_TL_CACHE_ENABLED              = 2, /* No longer supported from 6.1 */
      FL_DOC_8BIT_ACCESS               = 3,
      FL_MULTI_DOC_ENABLED             = 4, /* No longer supported from 6.1 */
      FL_SET_MAX_CHAIN                 = 5, /* For internal use only        */
      FL_MARK_DELETE_ON_FLASH          = 6, /* No longer supported from 6.1 */
      FL_MTL_POLICY                    = 7, /* No longer supported from 6.1 */
      FL_SECTORS_VERIFIED_PER_FOLDING  = 8, /* No longer supported from 6.1 */

      FL_ENV_VARS_PER_SOCKET           = 100,
      FL_VERIFY_WRITE_OTHER            = 101,
      FL_MTD_BUS_ACCESS_TYPE           = 102,
      FL_SUSPEND_MODE                  = 103,
	  FL_SET_AUTO_DPD_MODE             = 104, /* Added in TrueFFS 6.3.0     */
      FL_ENV_ATA_DEBUG                 = 105,
	  FL_SET_ACTIVE_DPD_MODE		   = 106,
	  FL_SET_INACTIVE_DPD_MODE		   = 107,
	  FL_SET_TIMEOUT_DPD			   = 108,

      FL_ENV_VARS_PER_VOLUME           = 200,

      FL_SET_POLICY                    = 201, /* No longer supported from 6.1 */
      FL_VERIFY_WRITE_BDTL             = 202,
      FL_VERIFY_WRITE_BINARY           = 203,
      FL_MAX_CACHE_SIZE                = 204,
      FL_DO_NOT_WAIT_FOR_READY         = 205, /* No longer supported from 6.1 */
      FL_NO_STATIC_FILES_WEAR_LEVELING = 206,
	  FL_DEBUG_MODES                   = 207, /* Added in TrueFFS 6.3 alpha 1 */
	  FL_HW_STATUS                     = 208, /* Added in TrueFFS 6.3 alpha 2 */

	  FL_ENV_VARS_PER_COMPILATION_FLAG = 300, /* Compilation flag replacement */
	  FL_DIMAGE_CFG                    = 301
} FLEnvVars;





/* These defines allow the user to add a prefix to the exported API */
#ifndef NAMING_CONVENTION
#define NAMING_CONVENTION
#endif /* NAMING_CONVENTION */
#ifndef TFFS_DLL_API
#define TFFS_DLL_API
#endif /* TFFS_DLL_API */


/**************************************************************************/
/*  Memory access routine interface:                                      */
/*    The following types and defines sets the API for the TrueFFS memory */
/*    access routines control.                                            */
/**************************************************************************/

/* Backward competible x86 pointer definitions (far and huge) */
#ifndef HUGE
#define HUGE
#endif /* HUGE */
#ifndef FAR0
#define FAR0
#endif /* FAR0 */

#ifndef FAR1
#define FAR1
#endif /* FAR1 */

#ifndef FAR2
#define FAR2
#endif /* FAR2 */


/* Doc memory read routine         */
typedef  void (FAR1 FLMemRead)(volatile FLByte FAR1* win,FLWord regOffset,FLByte FAR1* dest,FLWord count);
/* Doc memory write routine        */
typedef  void (FAR1 FLMemWrite)(volatile FLByte FAR1* win,FLWord regOffset,FLByte FAR1* src,FLWord count);
/* Doc memory set routine          */
typedef  void (FAR1 FLMemSet)(volatile FLByte FAR1* win,FLWord regOffset,FLWord count, FLByte val);
/* Doc memory 8 bit read routine   */
typedef  FLByte (FAR1 FLMemRead8bit)(volatile FLByte FAR1* win,FLWord offset);
/* Doc memory 8 bit write routine  */
typedef  void (FAR1 FLMemWrite8bit)(volatile FLByte FAR1* win,FLWord offset,FLByte Data);
/* Doc memory 16 bit read routine  */
typedef  FLWord (FAR1 FLMemRead16bit)(volatile FLByte FAR1* win,FLWord offset);
/* Doc memory 16 bit write routine */
typedef  void (FAR1 FLMemWrite16bit)(volatile FLByte FAR1* win,FLWord offset,FLWord Data);
/* Doc memory window size */
typedef  FLDword (FAR1 FLMemWindowSize)(void);
/* Interleave change event Call back routine */
typedef  FLStatus (FAR1 FLMemSetGetMode)(FLByte interleave, FLByte socketNo , FLDword flag);

typedef struct {        /* DiskOnChip memory access routines */
  FLDword               access; /* Output only */
  FLMemRead       * memRead;
  FLMemWrite      * memWrite;
  FLMemSet        * memSet;
  FLMemRead8bit   * memRead8bit;
  FLMemWrite8bit  * memWrite8bit;
  FLMemRead16bit  * memRead16bit;
  FLMemWrite16bit * memWrite16bit;
  FLMemWindowSize * memWindowSize;
  FLMemSetGetMode * memSetGetMode;
}FLAccessStruct;

/*----------------------------------------------------------------------*/
/*                  f l S e t D o c B u s R o u t i n e                 */
/*                                                                      */
/* Set user defined memory access routines for DiskOnChip.               */
/*                                                                      */
/* Parameters:                                                          */
/*      socket      : Socket number to install routine for.             */
/*      structPtr   : Pointer to function structure.                    */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flSetDocBusRoutine(FLByte  socket, FLAccessStruct FAR1 * structPtr);
#ifdef __cplusplus
}
#endif /* __cplusplus */

/*----------------------------------------------------------------------*/
/*                  f l G e t D o c B u s R o u t i n e                 */
/*                                                                      */
/* Get currently installed memory access routines for DiskOnChip.       */
/*                                                                      */
/* Parameters:                                                          */
/*      socket      : Socket number to install routine for.             */
/*      structPtr   : Pointer to function structure.                    */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */
TFFS_DLL_API FLStatus NAMING_CONVENTION flGetDocBusRoutine(FLByte  socket, FLAccessStruct FAR1 * structPtr);
#ifdef __cplusplus
}
#endif /* __cplusplus */

extern FLDword  flBusConfig[FL_SOCKETS];

/**************************************************************************/
/*  Endian conversion support :                                           */
/*    The following types and defines sets the endian dependant types.    */
/*    TrueFFS interface has some endian dependant API which contain data  */
/*    written on the flash. To support compatability between various      */
/*    systems, thses interfaces contain types which are not dependant in  */
/*    the endianess of the systems. This types and translation macroes   */
/*    are defined in this section.                                        */
/**************************************************************************/
extern void toUNAL(FLByte FAR0 *unal, FLWord n);
extern FLWord fromUNAL(FLByte const FAR0 *unal);
extern void toUNALLONG(FLByte FAR0 *unal, FLDword n);
extern FLDword fromUNALLONG(FLByte const FAR0 *unal);

#ifndef FL_BIG_ENDIAN

typedef FLWord   LEushort;
typedef FLDword  LEulong;

#define LE2(arg)         	arg
#define toLE2(to,arg)    	(to) = (arg)
#define LE4(arg)         	arg
#define toLE4(to,arg)    	(to) = (arg)

typedef FLByte        Unaligned[2];
typedef Unaligned     Unaligned4[2];

#define FL_REF_1(arg, offs)		(((FLByte *)(arg))[offs])
#define FL_REF_2(arg, offs)	 	(*((FLWord *)(((FLByte *)(arg)) + (offs))))
#define FL_REF_4(arg, offs)	 	(*((FLDword *)(((FLByte *)(arg)) + (offs))))

#define FL_GET_LE2(arg, offs)	 	FL_REF_2(arg, offs)
#define FL_GET_LE4(arg, offs)	 	FL_REF_4(arg, offs)
#define FL_SET_LE2(to, offs, arg)	FL_REF_2(to, offs) = (arg)
#define FL_SET_LE4(to, offs, arg)	FL_REF_4(to, offs) = (arg)

#else	/* FL_BIG_ENDIAN */

typedef FLByte LEushort[2];
typedef FLByte LEulong[4];

#define FL_REF_1(arg, offs)		(((FLByte *)(arg))[offs])
#define FL_REF_2(arg, offs)	 	(LE2((FLWord *)(((FLByte *)(arg)) + (offs))))
#define FL_REF_4(arg, offs)	 	(LE4((FLDword *)(((FLByte *)(arg)) + (offs))))

#define LE2(arg)		fromUNAL(arg)
#define toLE2(to,arg)		toUNAL(to, (FLWord)(arg))
#define LE4(arg)		fromUNALLONG((FLByte const FAR0 *)(arg))
#define toLE4(to,arg)		toUNALLONG((FLByte FAR0 *)(to), (arg))

#define Unaligned     LEushort
#define Unaligned4    LEulong

#define FL_GET_LE2(arg, offs)		LE2((((FLByte *)(arg)) + (offs)))
#define FL_GET_LE4(arg, offs)		LE4((((FLByte *)(arg)) + (offs)))
#define FL_SET_LE2(to, offs, arg)	toLE2((((FLByte *)(to)) + (offs)), arg)
#define FL_SET_LE4(to, offs, arg)	toLE4((((FLByte *)(to)) + (offs)), arg)
#endif /* FL_BIG_ENDIAN */



#endif /* FLCOMMON_H */
