/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

#include "msys.h"
#include "msys_custom.h"

#include "flsystem.h"
#include "exd_pars.h"
#include "blockdev.h"
#include "flstdcmp.h"
#include "doch_ata.h"
#include "doch_api.h"
//#include "hib.h"

#define SDK_MDOC_START_ADDRESS  MDOC_START_ADDRESS   /* Monahans address for mDOC H3 */

#ifdef DOCH_FILE_SIMULATION
  #include "sim_ram.h"
  FLWord          wRamSimulateDevice; /*device type to simulate*/
  extern FLByte   *pSimFileName;      /* one file for master and slave devices */
  extern FLDword  dwSimLength[];      /* lengths for each master and slave devices */
#endif /* DOCH_FILE_SIMULATION*/

extern FLByte noOfSockets;
unsigned long GetDocWinLAddress(void);
unsigned long GetDocWinHAddress(void);
FLStatus flSearchDocHWin( FLDword DocLowLimit,FLDword DocHighLimit );

//Re-located these vars here
//---------------------------------------
FLDword         Sockets_Address[MAX_PARA_SOCKETS];
DOC_ADDRESS     DocAddresses;
EX_DOCH_ACCESS  DocHwAccess = EX_ACCESS_NOR;
extern FLDword  gAccessLayerType;

/* environment variables */
#ifdef FL_ENVIRONMENT_VARS
  unsigned char  flUseNFTLCache;
  unsigned char  flUse8Bit;

  /*-----------------------------------------------------------------------*/
  /*                 f l s e t E n v V a r                                 */
  /*  Sets the value of all environment variables                          */
  /*  Parameters : None                                                    */
  /*-----------------------------------------------------------------------*/

  void flSetEnvVar(void)
  {
    flUse8Bit = ut_flUse8Bit;
  }
#endif /* FL_ENVIRONMENT_VARS */

//=======================================
// relocated next two functions here
//=======================================

/* exports dwDocWinLAddress & dwDocWinHAddress to flcustom.c & flsystem.c */
/*********************************************************/
/* Function name    : GetDocWinLAddress*/
/* Description      : */
/* Return type      : FLDword */
/* Argument         : void*/
/*********************************************************/
FLDword GetDocWinLAddress(void)
{
    if( EX_IS_DOCL_SET )
        return DocAddresses.DocLowLimit;

    return DocAddresses.DocWindow;
}/*GetDocWinLAddress()*/



/*********************************************************/
/* Function name    : GetDocWinHAddress*/
/* Description      : */
/* Return type      : FLDword */
/* Argument         : void*/
/*********************************************************/
FLDword GetDocWinHAddress(void)
{
    if( EX_IS_DOCH_SET )
        return DocAddresses.DocHighLimit;

    return DocAddresses.DocWindow;

}/*GetDocWinHAddress()*/


/*-----------------------------------------------------------------------*/
/*           f l R e g i s t e r D o c h P a r a m s		             */
/*                                                                       */
/* DOCH socket registration routine.							         */
/*                                                                       */
/* This function is called by DochSDKInit per socket at initialization.  */
/*                                                                       */
/* Parameters:                                                           */
/*      None															 */
/*-----------------------------------------------------------------------*/
FLStatus flRegisterDochParams( void )
{
    FLStatus status       = flOK;
	DOCH_Error typeStatus = DOCH_OK;
    FLStatus   rc         = flAdapterNotFound;
    FLDword    i;

    // this is the default location where we expect the mDOC to reside
    //--------------------------------------------------------------------
    DocAddresses.DocWindow    = SDK_MDOC_START_ADDRESS;
    DocAddresses.DocLowLimit  = SDK_MDOC_START_ADDRESS;
    DocAddresses.DocHighLimit = SDK_MDOC_START_ADDRESS;

    //Assume 8k mDOC H3 device windows
    //---------------------------------
    for( i=0; i<MAX_PARA_SOCKETS; i++ )
      Sockets_Address[i] = SDK_MDOC_START_ADDRESS+((8*1024)*i);

	/* Initialize socket */
	/*===================*/
	/*Step 1*/
	/*======*/
	/* Register access layer routines */
	/*================================*/

#ifdef DOCH_USE_FUNC   //  DOCH_USE_FUNC should always be undefined...
	/* Step 0 - Register HAL    */
	/*==========================*/
	if( /*EX_IS_DOCW_SET &&*/ (DocHwAccess == EX_ACCESS_NOR) )
	{
		rc = flRegisterDOCH_Hal_NOR();
		if(rc != flOK)
		{
			DBG_PRINT_WRN(FLZONE_API,"DOCH NOR registration failed.\r\n");
			return rc;
		}
		status=(FLStatus)rc;
	}
	else
	{
		/* /SPI set */
        #if 0   //  NO SPI interface to mDOC
		if( DocHwAccess == EX_ACCESS_SPI )
		{
			rc = flRegisterDOCH_Hal_SPI();
			if(rc != flOK)
			{
				DBG_PRINT_WRN(FLZONE_API,"DOCH SPI registration failed.\r\n");
				return (FLStatus)rc;
			}
			rc = (FLStatus)DochRegisterSocket(DocAddresses.DocWindow);
            if(rc != flOK)
			{
				DBG_PRINT_WRN(FLZONE_FULL,"DOCH registration failed.\r\n");
			}
			status=(FLStatus)rc;
		}
		/* nothing define default is nor*/

		else
        #endif
		{
            //gAccessLayerType = DOCH_AL_NOR;
            //rc = flOK;

			//rc = flRegisterDOCH_Hal_NOR();
			if(rc != flOK)
			{
				DBG_PRINT_WRN(FLZONE_API,"DOCH NOR registration failed.\r\n");
				return (FLStatus)rc;
			}
			status=(FLStatus)rc;
		}

	}

#endif /*DOCH_USE_FUNC*/


#ifdef DOCH_FILE_SIMULATION
	if (wRamSimulateDevice!=RAM_MTD_UNKNOWN)
	{
		typeStatus=sim_setSizeByType(wRamSimulateDevice);
		if ((typeStatus==DOCH_OK)&&(pSimFileName==NULL))
		{
			typeStatus=sim_FileNameByType(wRamSimulateDevice);
		}
	}
	if( EX_IS_SIMULATION_FILE_SET &&((wRamSimulateDevice==RAM_MTD_UNKNOWN)||(typeStatus==DOCH_OK)) )
	{
		typeStatus = flRegisterDOCH_Hal_SIM();
		DocAddresses.DocWindow=DocAddresses.DocLowLimit=DocAddresses.DocHighLimit=0x0;
	}
#endif /*DOCH_FILE_SIMULATION*/



    // adaptation for Monahans platform BEGIN
    //------------------------------------------

    {
      gAccessLayerType = DOCH_AL_NOR;
      rc = flOK;
      status=(FLStatus)rc;
    }


	if( status != flOK )
    {
		DBG_PRINT_ERR(FLZONE_FULL,"DOCH: HAL registration failed.\r\n");
		return status;
    }



	/* Step 2 - Register Socket */
	/*==========================*/
	//if( (!EX_IS_DOCW_SET) && (!EX_IS_DOCL_SET) && (!EX_IS_DOCH_SET) )
	{
	  status = flSearchDocHWin( Sockets_Address[0], Sockets_Address[0] );
	}
	//else
	//{
	//  status = flSearchDocHWin( GetDocWinLAddress(), GetDocWinHAddress() );
	//}

    // adaptation for Monahans platform END
    //------------------------------------------


	if(status != flOK)
    {
		DBG_PRINT_ERR(FLZONE_FULL,"DOCH registration failed.\r\n");
    }

	return status;
}

//=======================================================================
//                      f l S e a r c h D o c H W i n
//
//        This function searches for mDOC H3 devices
//       It expects that the first address should have a device, and if
//       there are additional devices, they will be at 8K increments
//       along the memory map
//
//       Successive calls should start at the next "predicted"
//       "socket address"  a socket here meaning a physically present
//       H3 device
//
// This function is called by DochSDKInit per socket at initialization.
//
// Parameters:
//             None
//
//=========================================================================
FLStatus flSearchDocHWin(FLDword DocLowLimit, FLDword DocHighLimit)
{
  FLDword    currentAddress;
  FLDword    dwWinSize = (8 * 1024); /*8k*/

  if( (DocHighLimit == DocLowLimit) && (DocLowLimit == UT_DEF_DOC_ADDR) )
    return flAdapterNotFound;

  for( currentAddress = DocLowLimit; currentAddress <= DocHighLimit; currentAddress += dwWinSize)
  {
    if( DOCH_OK == (flRegisterDOCH3SOC(currentAddress)) )
      return flOK;
  }

  return flAdapterNotFound;
}
/* end of flcustom.c file */
