/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/



#ifndef FLCUSTOM_H
#define FLCUSTOM_H

#define MAX_PARA_SOCKETS    4
/* Include the block device customization file */
#include "bdcustom.h"
/* Include the file systen customization file */
#include "fscustom.h"

/******* supported DOC - comment appropriated define to support MTD ************/
/*#define FL_DO_NOT_SUPPORT_H3*/	/*enable , when DOC H3 not supported*/
/*******************************************************************************/

/* We only support mDoc H3 devices in Monahans */
//==============================================
#define FL_NO_H1T_SUPPORT
#define FL_NO_H1H_SUPPORT
#define FL_NO_H1H1G_SUPPORT

/******* support RAMMTD ********************************************************/
#define FL_NO_RAMMTD_SUPPORT /*enable when file simulation is not supported*/
/*******************************************************************************/


#define NAME_UTILITY				"DOCSHELL"
#define VER_UTILITY					1
#define FL_PROGRAMMER_VERSION		"0001"  /* saved on flash should be equal to DIMAGE version */
#define FL_PROGRAMMER_NAME			"_xp_"
#define FL_PROGRAMMER_STRING		"xp Programmer"

#define MIGRATION_IMAGE_TOOLS

// we want to use our own interface macros,
// NOT the functions supplied by Msystems, so
// don't define DOCH_USE_FUNC
//----------------------------------------------
//#define DOCH_USE_FUNC


/* parallel socket base address */
#define UT_PARA_BASE_ADDR MDOC_START_ADDRESS
#define UT_DEF_DOC_ADDR 0xffffffff

#define  ACTIVE_DEBUG_ZONE FLZONE_FULL /* FLZONE_NONE */



#define DOCH_CHECK_CHIP_ID
#define FL_PACKED_STRUCTS_SUPPORTED
#ifdef WIN32
#define FL_WINDOWS_PACKING
#endif /*WIN32*/

#if (!defined(FL_NO_RAMMTD_SUPPORT) && !defined (FL_DO_NOT_SUPPORT_H3))
#define DOCH_FILE_SIMULATION
#endif /*(!defined(FL_NO_RAMMTD_SUPPORT) && !defined (FL_DO_NOT_SUPPORT_H3))*/

#ifdef DOCH_FILE_SIMULATION
#define DOCH_MEMMAP_FILE
#endif /*DOCH_FILE_SIMULATION*/

#define DOCH_FLOORS
#define ATA_MAX_NUM_OF_DEVICES	1

/* define UT_GETIMAGE if get image should be enabled */
#define UT_GETIMAGE
/* define UT_PUTIMAGE if put image should be enabled */
#define UT_PUTIMAGE

/*#define UT_NO_FS_INFO*/ /* define this flag, when no LOGD flag defined and used */

#endif /* FLCUSTOM_H */

