/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/flmalloc.h-arc  $
 *
 *    Rev 1.8   Aug 09 2006 16:52:50   Polina.Marimont
 * initial for DOC Driver 1.0
 */
#ifndef _FL_MALLOC
#define _FL_MALLOC

#include "_common.h" /* For basic function types */

/* ------------------------------------------------------------------------- */
typedef struct {
FLDword flBackOffset;
FLDword flSize;
FLDword flFree;		/* these two could be bytes, or ints */
FLDword flLastBlock;	/* but we want the returned memory to be aligned to dword */
} flMemChunk;
/* ------------------------------------------------------------------------- */

void flInitTFFSMalloc(void);
void * flMalloc(FLDword Length);
FLBoolean flFree(void * ChunkToDelete);
FLDword flTotalMemoryLeft(void);

#ifdef FL_DISPLAY_HEAP
#ifndef FL_HEAP_WALK
#define FL_HEAP_WALK
#endif	/* FL_HEAP_WALK */
FLBoolean flDisplayHeap(void);
#endif	/* FL_DISPLAY_HEAP */

#ifdef FL_REPORT_BIGGEST_MEMCHUNK
#ifndef FL_HEAP_WALK
#define FL_HEAP_WALK
#endif	/* FL_HEAP_WALK */
FLDword flBiggestFreeMemoryChunk(void);
#endif	/* FL_REPORT_BIGGEST_flMemChunk */

#ifdef FL_HEAP_WALK
typedef void (*flInpectHeapFunction)(flMemChunk *, void * extraInfo);
FLBoolean flHeapWalk(flInpectHeapFunction, void * extraInfo);
#define flHeapChk() flHeapWalk(NULL, NULL)
#endif	/* FL_HEAP_WALK */

/* ------------------------------------------------------------------------- */
#endif /*_FL_MALLOC*/


