/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/version 6.3-up/TrueFFS/src/flstdcmp.h-arc  $
 *
 *    Rev 1.20   Aug 09 2006 16:52:50   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef FLSTDCOMP_H
#define FLSTDCOMP_H

#ifndef FL_DO_NOT_SUPPORT_H3
  #include "doch_api.h"
#endif /*FL_DO_NOT_SUPPORT_H3*/

/************************************************************************/
/* Registration routines for MTDs supplied with TrueFFS			*/
/************************************************************************/

/* Currently supported     */
FLStatus    flRegisterDOCH1T(void);                   /* see H1_LGC.C   */
FLStatus    flRegisterDOCH1H(void);                   /* see H1H_LGC.C  */
FLStatus    flRegisterDOCH1H1G(void);                   /* see H1H_LGC.C  */
FLStatus    flRegisterDOCM512(void);                  /* see N512_LGC.C */
FLStatus    flRegisterDOCG4(void);                   /* see M1G_LGC.C */
FLStatus    flRegisterDOCRAM( void );                 /* see RAMMTD.C   */

/* Not currently supported */
FLStatus    flRegisterI28F008(void);                  /* see I28F008.C  */
FLStatus    flRegisterI28F016(void);                  /* see I28F016.C  */
FLStatus    flRegisterAMDMTD(void);                   /* see AMDMTD.C   */
FLStatus    flRegisterWAMDMTD(void);                  /* see WAMDMTD.C  */
FLStatus    flRegisterCDSN(void);                     /* see NFDC2048.C */
FLStatus    flRegisterCFISCS(void);                   /* see CFISCS.C   */
FLStatus    flRegisterDOC2000(void); 	              /* see DISKONC.C  */
FLStatus    flRegisterDOCPLUS(void); 	              /* see MDOCPLUS.C */
FLStatus    flRegisterDOCH1S(void);					  /* see H1S_LGC.c  */



#ifdef FL_NO_H1T_SUPPORT
  #define REGISTER_DOCH1T 0
#else
  #define REGISTER_DOCH1T flRegisterDOCH1T()
#endif

#ifdef FL_NO_H1H_SUPPORT
  #define REGISTER_DOCH1H 0
#else
  #define REGISTER_DOCH1H flRegisterDOCH1H()
#endif

#ifdef FL_NO_H1H1G_SUPPORT
  #define REGISTER_DOCH1H1G 0
#else
  #define REGISTER_DOCH1H1G flRegisterDOCH1H1G()
#endif

#define flRegisterDOCH1() (REGISTER_DOCH1T | REGISTER_DOCH1H | REGISTER_DOCH1H1G)


/************************************************************************/
/* Registration routines for socket I/F supplied with TrueFFS		*/
/************************************************************************/

/* Currently supported     */
#if (!defined(FL_NO_H1T_SUPPORT))
  #define flRegisterDOCH1SOC  flRegisterDOCH1TSOC
#elif (!defined(FL_NO_H1H_SUPPORT))
  #define flRegisterDOCH1SOC flRegisterDOCH1HSOC
#elif (!defined(FL_NO_H1H1G_SUPPORT))
  #define flRegisterDOCH1SOC flRegisterDOCH1H1GSOC
#else
  #define flRegisterDOCH1SOC(startAddr, endAddr) flAdapterNotFound
#endif

FLStatus    flRegisterDOCH1TSOC(FLDword dwLowAddress,
							   FLDword dwHighAddress);   /* see H1_MTD.C   */
FLStatus    flRegisterDOCH1HSOC(FLDword dwLowAddress,
							   FLDword dwHighAddress);   /* see H1H_MTD.C   */
FLStatus    flRegisterDOCH1H1GSOC(FLDword dwLowAddress,
							   FLDword dwHighAddress);   /* see H1H_MTD.C   */
FLStatus    flRegisterDOCH1SSOC(FLDword dwLowAddress,
							   FLDword dwHighAddress);   /* see H1S_MTD.C  */
FLStatus    flRegisterDOCM512SOC(FLDword dwLowAddress,
								 FLDword dwHighAddress); /* see M512_MTD.C */
FLStatus    flRegisterDOCG4SOC(FLDword dwLowAddress,
								 FLDword dwHighAddress); /* see M1G_MTD.C */
FLStatus    flRegisterDOCRamSOC(void);                   /* see RAMSOC.C   */
#ifndef FL_DO_NOT_SUPPORT_H3
DOCH_Error    flRegisterDOCH3SOC(FLDword dwAddress);	 /* see TFFS_API.C */
#endif /*FL_DO_NOT_SUPPORT_H3*/


/* Not currently supported */

FLStatus    flRegisterPCIC(unsigned int,                 /* see PCIC.C     */
						   unsigned int, FLByte);
FLStatus    flRegisterElanPCIC(unsigned int,             /* see PCICELAN.C */
							   unsigned int, FLByte);
FLStatus    flRegisterLFDC(FLBoolean);                   /* see LFDC.C     */

FLStatus    flRegisterElanRFASocket(int,                 /* see ELRFASOC.C */
									int);
FLStatus    flRegisterElanDocSocket(FLSDword,            /* see ELDOCSOC.C */
									FLSDword, int);
FLStatus    flRegisterVME177rfaSocket(FLDword,           /* see FLVME177.C */
									  FLDword);
FLStatus    flRegisterCobuxSocket(void);                 /* see COBUXSOC.C */
FLStatus    flRegisterCEDOCSOC(void);                    /* see CEDOCSOC.C */
FLStatus    flRegisterCS(void);                          /* see CSwinCE.C */
FLStatus    flRegisterDOCSOC(FLDword, FLDword);          /* see DOCSOC.C */
FLStatus    flRegisterDOCPLUSSOC(FLDword, FLDword);      /* see DOCSOC.C */

/************************************************************************/
/* Registration routines for translation layers supplied with TrueFFS	*/
/************************************************************************/

/* Currently supported     */

FLStatus    flRegisterSAFTL(void);                    /* see SAFTL.C    */

/* Not currently supported */

FLStatus    flRegisterFTL(void);                      /* see FTLLITE.C  */
FLStatus    flRegisterNFTL(void);                     /* see NFTLLITE.C */
FLStatus    flRegisterINFTL(void);                    /* see INFTL.C    */
FLStatus    flRegisterSSFDC(void);                    /* see SSFDC.C    */
FLStatus    flRegisterATAtl(void);                    /* see ATAL.C     */
FLStatus    flRegisterZIP(void);		              /* see ZIP.C	    */
FLStatus    flRegisterCACHETL(void);                  /* see CACHETL.C  */

/************************************************************************/
/* Multi-TL also known as Multi-DOC: Combine different devices into a   */
/* single big device allowing each of the devices to be formatted with  */
/* any kind of the TL mentioned above                                   */
/************************************************************************/

FLStatus    flRegisterMTL(void);                      /* see FLMTL.C    */

/************************************************************************/
/* Component registration routine in FLCUSTOM.C                         */
/************************************************************************/
/* DiskOnChip G3/G4/H1 Register Routine */
FLStatus    flRegisterComponents(void);

#ifndef FL_DO_NOT_SUPPORT_H3
/* DiskOnChip H3 Register Routine */
//DOCH_Error  flRegisterDochParams(void);
FLStatus flRegisterDochParams(void);

/* DiskOnChip H3 Access layer routine - not used in 7.x version */
#ifdef DOCH_USE_FUNC
  //#define flRegisterDOCH_Hal_SPI()    ((hal_init_spi(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  //#define flRegisterDOCH_Hal_SIM()    ((hal_init_sim(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  //#define flRegisterDOCH_Hal_NOR() 	((hal_init_nor(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  #define flRegisterDOCH_Hal_SPI()    ((hal_init_spi(0) == 0) ? flOK : flGeneralFailure)
  #define flRegisterDOCH_Hal_SIM()    ((hal_init_sim(0) == 0) ? flOK : flGeneralFailure)
  #define flRegisterDOCH_Hal_NOR()    ((hal_init_nor(0) == 0) ? flOK : flGeneralFailure)
#else /*DOCH_USE_FUNC*/
  //#define flRegisterDOCH_Hal_SPI()    ((hal_init_spi_noFunc(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  //#define flRegisterDOCH_Hal_SIM()    ((hal_init_sim_noFunc(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  //#define flRegisterDOCH_Hal_NOR() 	((hal_init_nor_noFunc(0) == 0) ? DOCH_OK : DOCH_GeneralFailure)
  #define flRegisterDOCH_Hal_SPI()    ((hal_init_spi_noFunc(0) == 0) ? flOK : flGeneralFailure)
  #define flRegisterDOCH_Hal_SIM()    ((hal_init_sim_noFunc(0) == 0) ? flOK : flGeneralFailure)
  #define flRegisterDOCH_Hal_NOR()    ((hal_init_nor_noFunc(0) == 0) ? flOK : flGeneralFailure)
#endif /*DOCH_USE_FUNC*/

#endif /*FL_DO_NOT_SUPPORT_H3*/


#endif /* FLSTDCOMP_H */
