/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/common/flstruct.h-arc  $
 *
 *    Rev 1.7.1.0   Aug 08 2006 15:55:30   Polina.Marimont
 * DOC Driver 1.0 initial
 */

#ifndef FLSTRUCT_H
#define FLSTRUCT_H

#include "flcommon.h"

//#include "msys.h"


/**************************************************************************/
/* Function opcode definitions:                                           */
/*   All TrueFFS functions has a uniques opcodes. The following enum      */
/*  defines all the function calls used by the TrueFFS SDK API.           */
/* Note:                                                                  */
/* The order of the enum bellow should be strictly kept since the bdcall  */
/* function utilizes the index values to simplify the function search     */
/**************************************************************************/
typedef enum {
/* The following routines are files related routines */

        /*********/
        /* FILES */
        /*********/

  FL_READ_FILE                  = 0,
  FL_WRITE_FILE,
  FL_SPLIT_FILE,
  FL_JOIN_FILE,
  FL_SEEK_FILE,
  FL_FIND_NEXT_FILE,
  FL_FIND_FILE,
  FL_TRUNCATE_FILE,
  INDEX_WRITE_FILE_START        = 100,
  FL_CLOSE_FILE,
  FL_FLUSH_FILE,
  INDEX_OPENFILES_END           = 200,
  FL_OPEN_FILE,
  FL_DELETE_FILE,
  FL_FIND_FIRST_FILE,
  FL_GET_DISK_INFO,
  FL_RENAME_FILE,
  FL_MAKE_DIR,
  FL_REMOVE_DIR,
  FL_FLUSH_BUFFER,
  FL_CLOSE_ALL_FILES,
  FL_FLUSH_ALL_FILES,
  FL_OPEN_DIRECTORY,
  FL_OPEN_MM_FILE,
  FL_LAST_FAT_FUNCTION          = 300,

  /* The following routines will not perform valid partition check */
       /**********/
       /* BINARY */
       /**********/
  INDEX_BINARY_START            = 400,
  FL_BINARY_WRITE_INIT,
  FL_BINARY_WRITE_BLOCK,
  FL_BINARY_CREATE,
  FL_BINARY_ERASE,
  FL_BINARY_PROTECTION_CHANGE_KEY,
  FL_BINARY_PROTECTION_CHANGE_LOCK,
  FL_BINARY_PROTECTION_SET_TYPE,
  INDEX_BINARY_WRITE_END        = 500,
  FL_BINARY_READ_INIT,
  FL_BINARY_READ_BLOCK,
  FL_BINARY_PARTITION_INFO,
  FL_BINARY_PROTECTION_GET_TYPE,
  FL_BINARY_PROTECTION_INSERT_KEY,
  FL_BINARY_PROTECTION_REMOVE_KEY,
  INDEX_BINARY_END              = 600,

/* The following routines must be called with partition number 0 */
  INDEX_NEED_PARTITION_0_START  = 700,
      /* OTP */
  FL_OTP_SIZE,
  FL_OTP_READ,
  FL_OTP_WRITE,
  FL_WRITE_IPL,
  FL_READ_IPL,
      /* PHYSICAL */
  FL_DEEP_POWER_DOWN_MODE,
  FL_GET_PHYSICAL_INFO,
  FL_PHYSICAL_READ,
  FL_PHYSICAL_WRITE,
  FL_PHYSICAL_ERASE,
  FL_UPDATE_SOCKET_PARAMS,
  FL_UNIQUE_ID,
  FL_CUSTOMER_ID,
  BD_FORMAT_VOLUME,
  BD_FORMAT_PHYSICAL_DRIVE,
  FL_PLACE_EXB,
  FL_READ_BBT,
  FL_WRITE_BBT,
  FL_GET_EXTENDED_DISK_INFO,
  FL_PROTECTION_STICKY_LOCK,
  BD_FLASH_FORMAT,
  BD_UNFORMAT,
  FL_HW_CONFIG,
  FL_RECOVER_FROM_POWER_LOSS,

  INDEX_NEED_PARTITION_0_END    = 800,
/* The following routines will go through the volume validity check */
      /* PROTECTION */
  FL_PROTECTION_GET_TYPE,
  FL_PROTECTION_REMOVE_KEY,
  FL_PROTECTION_INSERT_KEY,
  FL_PROTECTION_SET_LOCK,
  FL_PROTECTION_CHANGE_KEY,
  FL_PROTECTION_CHANGE_TYPE,
  FL_COUNT_VOLUMES,
  FL_INQUIRE_CAPABILITIES,
     /* BDTL */
  FL_MOUNT_VOLUME,
  FL_ABS_MOUNT,
  BD_FORMAT_LOGICAL_DRIVE,
  FL_WRITE_PROTECTION,
  FL_DISMOUNT_VOLUME,
  FL_CHECK_VOLUME,
  FL_DEFRAGMENT_VOLUME,
  FL_ABS_WRITE,
  FL_ABS_DELETE,
  FL_ABS_READ,
  FL_ABS_ADDRESS,
  FL_GET_BPB,
  FL_SECTORS_IN_VOLUME,
  FL_VOLUME_INFO,
  FL_VERIFY_VOLUME,
  FL_CLEAR_QUICK_MOUNT_INFO,
  FL_RUGGEDIZE_OPERATION,	/* not used */
  FL_ABS_WRITE_UNCOMMITED,	/* not used */
  FL_ABS_DELETE_UNCOMMITED,	/* not used */
  FL_ABS_READ_RUGGEDIZED,	/* not used */
  FL_GET_QUICK_MOUNT_STATUS,
  FL_WRITE_QUICK_MOUNT_INFO,
  FL_LOAD_VOLUMES_CACHE,
  FL_COMPLETE_OPERATION,
  FL_FIND_LOGICAL_PARTITION,
  FL_CREATE_LOGICAL_PARTITIONS,
  FL_FORMAT_FS,
  FL_GET_BD_VERSION,
  FL_GET_FS_VERSION,
  BD_ERASE_BD,
  FL_ABS_SECURE_DELETE,
  FL_MCOTP_SIZE,/* not used - must gone */
  FL_MCOTP_READ,/* not used - must gone */
  FL_MCOTP_WRITE,/* not used - must gone */
  FL_DOCH_PASS_THROUGH /* DOCH only */
} FLFunctionNo;



/**************************************************************************/
/*  Structures and defines for GetInfo routines:                          */
/*  GetInfo routines are used by several TrueFFS packages.                */
/*  The output structures and values are defined below                    */
/**************************************************************************/

/*---------------------------------------------------------*/
/*                     V o l u m e I n f o R e c o r d     */
/*                                                         */
/* A structure that holds general information about the    */
/* media. The information includes Physical Info (see      */
/* flGetPhysicalInfo), Logical partition (number of sectors*/
/* and CHS), boot area size, S/W versions Media life-time  */
/* etc.                                                    */
/* A pointer to this structure is passed to the function   */
/* flVolumeInfo where it receives the relevant data.       */
/*---------------------------------------------------------*/

typedef struct {
  FLDword  logicalSectors;    /*  number of logical sectors                  */
  FLDword  bootAreaSize;      /*  boot area size                             */
  FLDword  baseAddress;       /*  physical base address                      */
  FLWord   flashType;         /*  JEDEC id of the flash                      */
  FLDword  dwPhysicalSize;    /*  physical size of the media                 */
  FLDword  dwPhysicalUnitSize;/*  Erasable block size                        */
  FLByte   DOCType;           /*  DiskOnChip type (MDoc/Doc2000)             */
  FLSByte  lifeTime;          /*  Life time indicator for the media (1-10)   */
                              /*  1 - the media is fresh,                    */
                              /*  10 - the media is close to its end of life */
  FLSByte  driverVer[10];     /*  driver version (NULL terminated string)    */
  FLSByte  OSAKVer[10];       /*  TrueFFS version that driver is based on    */
                              /*  (NULL terminated string)                   */
  FLDword  cylinders;         /*  Media.....                                 */
  FLDword  heads;             /*            geometry......                   */
  FLDword  sectors;           /*                            parameters.      */
} VolumeInfoRecord;


/*---------------------------------------------------------*/
/*                          P h y s i c a l I n f o        */
/*                                                         */
/* A structure that holds physical information about the   */
/* media. The information includes JEDEC ID, unit size and */
/* media size. Pointer to this structure is passed to the  */
/* function flGetPhysicalInfo where it receives the        */
/* relevant data.                                          */
/*---------------------------------------------------------*/

typedef struct {
  FLWord type;                 /* Flash device type (JEDEC id)                 */
  FLByte         mediaType;    /* type of media see below                      */
  FLDword        dwUnitSize;   /* Smallest physically erasable size in sectors */
  FLDword        dwMediaSize;  /* media size in sectors                        */
  FLDword        dwChipSize;   /* individual chip size in sectors              */
  FLDword        interleaving; /* device interleaving                          */
} PhysicalInfo;



/*--------------------------------------------------------- */
/*                  f l E x t e n d e d D i s k I n f o     */
/*                                                          */
/* This structure supplies very low-level information on    */
/* the device                                               */
/*                                                          */
/* Note: This structure is used for M-Systems low level     */
/*      utilities. It is subject to chages from one TrueFFS */
/*      version to the other.                               */
/*                                                          */
/*--------------------------------------------------------- */

typedef struct {

  /******************************************/
  /* Fields that belong to the entire media */
  /******************************************/
  FLDword  dwStructSize;          /* INPUT - Size of the given structure      */
  FLDword  dwTLType;              /* See definitions in flflash.h             */
  FLDword  dwFormatFlags;         /* Format attributes for the entire media   */
  FLDword  dwTrueFFSVersion;      /* Version of OSAK used to format the media */
  FLDword  dwFlashTechnology;     /* Flash technology supported properties    */

  FLDword  dwType;                /* Flash type                               */
  FLDword  dwSubType;             /* Sub Flash type                           */
  FLByte   bMediaType;            /* Controller family                        */
  FLByte   bNoOfFloors;           /* Number of floors in the device           */
  FLByte   bNoOfPlanes;           /* Number of flash planes                   */
  FLByte   bNoOfBanks;            /* Number of flash banks                    */
  FLByte   bDataBusWidth;         /* Value of the IF_CFG (either 8 or 16 bits)*/
  FLByte   bSectorsPerPage;       /* Number of sectors in a flash page        */
  FLByte   bSharedSectors;        /* The minimal number of logical sectors    */
                                  /* that might be affected by one another    */
                                  /* write operation.                         */
  FLByte   bFastAreaSharedSectors; /* Minimal number of sectors that can affect */
                                   /* one another when written in fast mode.    */
  FLByte   bMaxRelatedSectors;    /* Max number of sectors that might share   */
                                  /* the same write operation or might be     */
                                  /* affected by each other write operation.  */
  FLDword  dwIPLSize;             /* Number of bytes of SRAM in the device    */
  FLByte   bChangeableProtectedAreas; /* Number of protection areas capable   */
                                      /* of changing.                         */
  FLByte   btotalProtectedAreas;  /* Total number of protection areas         */
  FLDword  dwUnitsInFirstFloor;   /* Number of units in the first floor       */
  FLDword  dwUnitSize;            /* Size of logical erasable unit            */
  FLDword  dwMaxBadPercentage; /* Flash guaranteed  worst bad blocks percentage */
  FLByte   bNoOfBinaryPartitions; /* Number of binary partition on the media  */
  FLByte   bNoOfDiskPartitions;   /* Number of disk partition on the media    */
  FLByte   bBlockMultiplierBits;  /* no of bits used to represent the time a  */
                                  /* flash logical unit fits inside in a TL   */
                                  /* erasable unit.                           */
  FLByte   dwPercentUsed;         /* Percent of the media to be exported      */
  FLByte   bHeaderUnits;          /* Number of units reserved in the begining */
                                  /* of each floor for the media header       */
  FLWord   wHeaderLocation;       /* Unit number where the header of the      */
                                  /* current floor resides. In case all floors*/
                                  /* are requested, the value should indicate */
                                  /* the location of the header in the first  */
                                  /* floor.                                   */

  FLByte   bProgrammerNamePtr[4];    /* Programmer name                       */
  FLByte   bProgrammerVersionPtr[4]; /* Programmer version                    */

  /************************************************/
  /* Fields that belong to the specific partition */
  /************************************************/

  FLDword    dwVirtualUnits;  /* Virtual size exported by the translation layer */
                              /* Note some units are smaller then others        */
  FLDword    dwFastUnits;     /* Number of virtual units that are fast units    */
  FLDword    dwFirstQuickMountUnit; /* First unit used for the quick mount data */
  FLDword    dwFirstUnit;     /* First unit of the partition                    */
  FLDword    dwLastUnit;      /* Last unit of the partition                     */
  FLDword    dwSpareUnits;    /* Number of spare units requested by the user    */
  FLDword    dwTransferUnits; /* Number of transfer units used for chaining     */
  FLDword    dwPartitionFlags;/* See list above "Partition flags"               */
  FLDword    dwNormalAreaUnitSize;         /* Logical size of a TL normal unit */
  FLDword    dwFastAreaLogicalUnitSize;    /* Logical size of a TL fast   unit */
  FLDword    dwFastAreaVirtualFactor;      /* Virtual unit factor between fast */
                                           /* and normal area (power of 2)     */

  FLByte     bMinSectorsForFolding;        /* Number of sectors to be copied   */
                                           /* together in a folding operation  */
  FLByte     bMinSectorsForNextWrite;      /* For performance reasons the TL   */
                                           /* decide to reduce the above value */
  FLByte     bfastAreaMinSectorsForNextWrite; /* For performance reasons the TL   */
                                              /* decide to reduce the above value */

  /******************************************/
  /* Fields that are valid only after mount */
  /******************************************/

  FLDword    dwUsedUnits;                  /* Number of used virtual chains    */
  FLDword    dwFreeUnits;                  /* Number of currently free units   */
  FLByte     bNeededFreeUnits;             /* Minimal number of free units     */
                                           /* before folding                   */
  FLDword    dwUMDBBTSector;               /* Location of latest UMDBBT sector */
} FLExtendedDiskInfo;

/* media types */
#define FL_NOT_DOC      0
#define FL_DOC          1
#define FL_MDOC         2
#define FL_DOC2000TSOP  3
#define FL_MDOCP_16     4
#define FL_MDOCP        5
#define FL_DOC_H1       6
#define FL_MDOC512_G3   7
#define FL_MDOC256_P3   8
#define FL_MDOC256_G3   9
#define FL_MDOC128_P3   10
#define FL_AMD_NOR      11
#define FL_SEIJA        12
#define FL_MDOC_G4      13
#define FL_MDOC_P4      14
#define FL_H3           15

/*Defines for flExtendedDiskInfo*/
#define SAFTL_ADVANCED_MATCHING     0x00100000L
#define SAFTL_QUICK_MOUNT           0x10000000L

#define FL_BDK_PARTITION  1
#define FL_DISK_PARTITION 0
#define FL_ALL_FLOORS     0xff
#define BINARY_SPARE_BLOCKS_SIGN "S4BB" /* Must be the same as BINARY_SPARE_BLOCKS_SIGN (FLFORMAT.H) */


/**************************************************************************/
/*  Structures and defines for Format routines:                           */
/**************************************************************************/

typedef FLStatus (*FLProgressCallback)(FLWord totalUnitsToFormat, FLWord totalUnitsFormattedSoFar);

/*----------------------------------------------*/
/* User BDTL Partition Format Parameters record */
/*----------------------------------------------*/

typedef struct
{
  FLDword  length;  /* The size in bytes of the usable storage space. The size
                       rounded upwards to a multiplication of a block size.
                       The size of the last partition will calculated automatically,
                       but if the requested size is greater then the remaining space
                       an error code will be returned,. Requesting zero size for any
                       partition but the last will generate an flBadParameters status. */

  FLDword  fastAreaLength;
  FLWord   lengthType;
  FLWord   fastAreaLengthType;
  FLWord   fastAreaVirtualFactor; /* Should be set to FL_NORMAL_SPACING */
  FLWord   noOfSpareUnits;        /* BDTL needs at least one spare erase unit in order to function
                                     as a read/write media. It is possible to specify more than one
                                     spare unit, which takes more media space. The advantage of
                                     specifying more than one spare unit is that if one of the flash
                                     erase units becomes bad and un-erasable in the future, then one
                                     of the spare units can replace it. In that case, a second spare
                                     unit enables TrueFFS to continue its read/write functionality,
                                     whereas if no second spare unit is available the media goes into
                                     read-only mode. The standard value used is 3 */

  FLDword  BDTLFP_0_RFU_0;         /* Reserved 0  */
  FLDword  BDTLFP_1_RFU_0;         /* Reserved 0  */
  FLDword  BDTLFP_2_RFU_0;         /* Reserved 0  */
  FLDword  BDTLFP_3_RFU_0;         /* Reserved 0  */
  FLByte   protectionKey[8];       /* The key for the protection*/
  FLByte   protectionType;         /* PROTECTABLE          - Can receive protection           */
                                   /* READ_PROTECTED       - Protect against read operations  */
                                   /* WRITE_PROTECTED      - Protect against write operations */
                                   /* LOCK_ENABLED         - Enables the hardware lock signal */
                                   /* PROTECTABLE          - This partition can be protected  */
                                   /* CHANGEABLE_PROTECTION - protection type can be changed  */
                                   /* The ratio between the real media size and the virtual size
                                      reported to the file system when compression is active. */
} BDTLPartitionFormatParams3;

/*------------------------------------------------*/
/* User binary Partition Format Parameters record */
/*------------------------------------------------*/
typedef struct
{
  FLDword  length;       /* Required number of usable bytes (rounded to units) */
                        /* in the  partition.                                 */

  FLWord   lengthType;  /* Must be FL_LENGTH_IN_BYTES                        */
  FLByte   sign[4];     /* signature of the binary  partition to format.
                         The signature 0xFFFF FFFF is not a valid signature  */

  FLDword  flags;        /* TL_NORMAL_FORMAT / TL_SPL_FORMAT                 */
  FLWord   spareBlocks;  /* Spare blocks for DBB support                     */
  FLDword  BDKFP_0_RFU_0; /* Reserved 0  */
  FLDword  BDKFP_1_RFU_0; /* Reserved 0  */
  FLDword  BDKFP_2_RFU_0; /* Reserved 0  */
  FLDword  BDKFP_3_RFU_0; /* Reserved 0  */

  /* TL_NORMAL_FORMAT / TL_SPL_FORMAT */

  FLByte   protectionKey[8];   /* The key for the protection*/
  FLByte   protectionType;     /* PROTECTABLE          - Can receive protection           */
                               /* READ_PROTECTED       - Protect against read operations  */
                               /* WRITE_PROTECTED      - Protect against write operations */
                               /* LOCK_ENABLED         - Enables the hardware lock signal */
                               /* PROTECTABLE          - This partition can be protected  */
                               /* CHANGEABLE_PROTECTION - protection type can be changed  */

}BinaryPartitionFormatParams3;


/*---------------------------------------------------------*/
/* User Format Parameters record for flFlashFormat routine */
/*---------------------------------------------------------*/

/*****************************/
/* Device formatting section */
/*****************************/
typedef struct
{
  FLByte  percentUse;            /* NAND flash inherently contains some bad blocks. TrueFFS handles
                                  * those blocks by managing a pool of spare blocks also called transfer
                                  * units. This format parameter specifies the percentage of the media
                                  * to use.  Starting from TrueFFS 6.3.0 alpha 4 this field is no longer a
                                  * configurable formatting argument. You must set this field to
                                  * TL_DEFAULT_PERCENTAGE, letting TrueFFS to choose this value for you. */

  FLByte  noOfBDTLPartitions;     /* Indicates the number of Disk partition (1 to 4). */
  FLByte  noOfBinaryPartitions;   /* Indicates the number of binary partitions (up to 3). 0 will
                                   * cause formatting with no binary partition. This value is ignored
                                   * if TL_LEAVE_BINARY_AREA flag is set in the irFlags field the ioreq */

  BDTLPartitionFormatParams3   FAR2 *BDTLPartitionInfo;   /* BDTL partition information array  */
  BinaryPartitionFormatParams3 FAR2 *binaryPartitionInfo; /* Binary partition information array*/

  /***********************************/
  /* Special format features section */
  /***********************************/

  FLByte             cascadedDeviceNo;     /* Not used */
  FLByte             noOfCascadedDevices;  /* Not used */
  FLProgressCallback progressCallback;  /* Progress callback routine, will be called if not NULL.
                                           The callback routine is called after erasing each unit,
                                           and its parameters are the total number of erase units
                                           to format and the number erased so far.
                                           The callback routine returns a Status value. A value of
                                           OK (0) allows formatting to continue. Any other value
                                           will abort the formatting with the returned status code. */
                                        /* In case the FL_REPORT_MOUNT_PROGRESS compilation flag is set the
                                           routine will also report the mount progress of the mount routine
                                           for each of the Disk partitions. A 0,0 return values will report
                                           the end of a format status and of a mount operation */

  FLDword  FP_0_RFU_0;       /* Reserved 0 */
  FLDword  FP_1_RFU_0;       /* Reserved 0 */

  /* Note the following section is not used by for DiskOnChips */
  /*************************************************************/

  FLSDword bootImageLen;          /* Reserved 0     */
  FLDword  vmAddressingLimit;     /* Reserved 0     */
  FLWord   embeddedCISlength;     /* Reserved 0     */
  FLByte   FAR1 *embeddedCIS;     /* Reserved NULL  */
} FormatParams3;

/*--------------------------------------------------*/
/* Flags for format routine (non partition related) */
/*--------------------------------------------------*/
#define TL_LEAVE_BINARY_AREA       0x8  /* Is assumed to be a single bit */
#define TL_LEAVE_SOME_BINARY_AREA  0x9  /* Must include TL_LEAVE_BINARY_AREA bits */
#define TL_SINGLE_FLOOR            0x10 /* Format only a selection of the floors  */
#define TL_DO_NOT_PERFORM_DOWNLOAD 0x20 /* Do not issue a download operation at   */
                                        /* end of the format routine.             */
#define TL_FAIL_ON_UNMARKED_BB     0x80 /* Fail in case an unmarked bad block is  */
                                        /* Found.                                 */


/*--------------------------------------------------*/
/* Formatting parameter structure definition        */
/*--------------------------------------------------*/
#define FL_LENGTH_IN_BYTES          0
#define FL_LENGTH_IN_SECTORS        1
#define FL_LENGTH_IN_UNITS          2
#define FL_LENGTH_IN_PERCENTS       3
#define FL_LENGTH_IN_CYLINDERS		10

/*--------------------------------------------------*/
/* Internal Partition flags - N O T   F O R   U S E */
/*--------------------------------------------------*/
#define TL_SIMPLE_MATCHING         0x10 /* Use simple matching for partition */
#define TL_FORCE_REL               0x20 /* Use RELIABLE mode                 */
#define TL_FAST_MODE               0x40 /* Use FAST mode                     */
#define TL_NO_PLANES               0x80 /* Do not match blocks for planes    */

/*--------------------------------------------------*/
/* External Disk Partition Flags (TL_NORMAL_FORMAT):*/
/*--------------------------------------------------*/
#define TL_NORMAL_FORMAT       0

/*--------------------------------------------------*/
/* External Binary Partition Flags                  */
/* (TL_NORMAL_FORMAT / TL_SPL_FORMAT)               */
/*--------------------------------------------------*/
#define TL_SPL_FORMAT          (TL_SIMPLE_MATCHING | TL_NO_PLANES | TL_FORCE_REL) /* SPL partition */

/*--------------------------------------------------*/
/* External spacing factors - only 1 value          */
/*--------------------------------------------------*/
#define FL_NORMAL_SPACING      1

/*--------------------------------------------------*/
/* Standard initializer for                         */
/* BDTLPartitionFormatParams3 structure             */
/*--------------------------------------------------*/

#define TL_DEFAULT_PERCENTAGE     0 /* Use default percentage of the media      */
#define TL_NO_BOOST               0 /* Do not use any performance boost         */
#define TL_BASIC_BOOST            1 /* Use basic 1% performance boost           */
#define TL_ENHANCED_PERFORMANCE 100 /* Define as enhanced performance partition */

#define TL_BDTL_STD_SPACE_FACTOR	FL_NORMAL_SPACING
#define TL_BDTL_STD_SPARE_UNITS_NO	3
#define STD_BDTL_PARAMS3 {0,                       /* Total  Length       */ \
                          0,                      /* Fast   Length       */ \
                          FL_LENGTH_IN_BYTES,      /* Total  Length type  */ \
                          FL_LENGTH_IN_PERCENTS,   /* Fast   Length type  */ \
                          TL_BDTL_STD_SPACE_FACTOR,/* Spaced Factor       */ \
                          TL_BDTL_STD_SPARE_UNITS_NO,/* No of spare units   */ \
                          0,0,0,0,                 /* Reserved 0          */ \
                          {0,0,0,0,0,0,0,0},0}     /* No H/W protection   */

/*--------------------------------------------------*/
/* Standard initializer for                         */
/* BinaryPartitionFormatParams3 structure           */
/*--------------------------------------------------*/
#define TL_BDK_STD_SPARE_BLOCKS_NO	1
#define STD_BINARY_PARAMS3 {0,                  /* Partition length       */ \
                            FL_LENGTH_IN_BYTES, /* Partition length type  */ \
                            {'B','I','P','O'},  /* Signature              */ \
				            0,					/* 0 -normal partition , TL_SPL_FORMAT for SPL Partition */ \
							TL_BDK_STD_SPARE_BLOCKS_NO,/* Number of spare blocks */ \
                            0,0,0,0,            /* Reserved 0             */ \
							{0,0,0,0,0,0,0,0},  /* Protection key         */ \
							0}                  /* Protection type        */ \

/*--------------------------------------------------*/
/* Standard initializer for FormatParams3 structure */
/*--------------------------------------------------*/
#define STD_FORMAT_PARAMS3 {TL_DEFAULT_PERCENTAGE, /* Percent used               */ \
                            1,                     /* No of Disk Partitions      */ \
							0,                     /* No of Binary Partitions    */ \
							NULL,                  /* Disk partition structure   */ \
							NULL,                  /* Binary partition structure */ \
							0,                     /* This cascaded device       */ \
							0,                     /* Total cascaded devices     */ \
							NULL,                  /* Progress call back         */ \
							0, 0,                  /* Reserved 0                 */ \
							0, 0, 0, NULL}         /* Reserved 0                 */




/**************************************************************************/
/*  Structures and defines for BDK routines:                              */
/**************************************************************************/
#define BDK_SIGNATURE_NAME              4

typedef struct {
    FLByte       oldSign[BDK_SIGNATURE_NAME];
    FLByte       newSign[BDK_SIGNATURE_NAME];
    FLByte       signOffset;
    FLDword      startingBlock;
    FLDword      length;
    FLByte       flags;
    FLByte FAR1 *bdkBuffer;
} BDKStruct;

#define ERASE_BEFORE_WRITE              8


/**************************************************************************/
/*  Defines for Defrag routines:                                          */
/**************************************************************************/
#define FL_MINIMAL_DEFRAGMENTATION	    -1
#define FL_MAXIMUM_DEFRAGMENTATION	    -20
#define FL_STATIC_WEAR_LEVELING_DELAYED -2
#define FL_STATIC_WEAR_LEVELING_NOW     -3
#define FL_STATIC_WEAR_LEVELING_ON      -4
#define FL_STATIC_WEAR_LEVELING_OFF     -5

#ifndef FL_NO_PACKED_STRUCTS_SUPPORTED
typedef  struct {
  FLByte	jumpInstruction[3];
  FLSByte	OEMname[8];
  Unaligned	bytesPerSector;
  FLByte	sectorsPerCluster;
  LEushort	reservedSectors;
  FLByte	noOfFATS;
  Unaligned	rootDirectoryEntries;
  Unaligned	totalSectorsInVolumeDOS3;
  FLByte	mediaDescriptor;
  LEushort	sectorsPerFAT;
  LEushort	sectorsPerTrack;
  LEushort	noOfHeads;
  LEulong	noOfHiddenSectors;
  LEulong	totalSectorsInVolume;
} BPB;
#else /*FL_NO_PACKED_STRUCTS_SUPPORTED*/
#define FL_BPB_JUMP_INSTRUCTION_OFFSET		0	/* size 3, array */
#define FL_BPB_OEM_NAME_OFFSET			3	/* size 8, array */
#define FL_BPB_BYTES_PER_SECTOR_OFFSET		11	/* size 2, unaligned */
#define FL_BPB_SECTORS_PER_CLUSTER_OFFSET	13	/* size 1 */
#define FL_BPB_RESERVED_SECTORS_OFFSET		14	/* size 2 */
#define FL_BPB_NO_OF_FATS_OFFSET		16	/* size 1 */
#define FL_BPB_ROOT_DIR_ENTRIES_OFFSET		17	/* size 2, unaligned */
#define FL_BPB_TOTAL_SECTORS_IN_VOL_DOS3_OFFSET	19	/* size 2, unaligned */
#define FL_BPB_MEDIA_DESCRIPTOR_OFFSET		21	/* size 1 */
#define FL_BPB_SECTORS_PER_FAT_OFFSET		22	/* size 2 */
#define FL_BPB_SECTORS_PER_TRACK_OFFSET		24	/* size 2 */
#define FL_BPB_NO_OF_HEADS_OFFSET		26	/* size 2 */
#define FL_BPB_NO_OF_HIDDEN_SECTORS_OFFSET	28	/* size 4 */
#define FL_BPB_TOTAL_SECTORS_IN_VOL_OFFSET	32	/* size 4 */
#define FL_BPB_SIZE				36
typedef FLByte BPB[FL_BPB_SIZE];
#endif /*FL_NO_PACKED_STRUCTS_SUPPORTED*/
typedef struct {
FLDword length;
FLWord lengthType;
FLByte pType;
FLByte flags;
}LogicalPartitionParams;

#define STD_LOG_PARTITION_PARAMS	{0,                         /* Partition length       */ \
                                     FL_LENGTH_IN_BYTES,        /* Bytes, Sectors ...     */ \
									 DOS4_PARTIT,               /* Partition type         */ \
									 FL_MARK_PARTITION_BOOTABLE}/* Either bootable or not */ \

typedef struct {
SectorNo bootSectorNo;
SectorNo sectorsInVolume;
SectorNo MBR;
int MBRslot;
} LogPartitionInfo;

#ifndef FL_NO_PACKED_STRUCTS_SUPPORTED
typedef  struct  {
  FLSByte   name[11];
  FLByte    attributes;		/* mapped below */
  FLByte    lowerCaseFlags;
  FLByte    createTimeMilisec;
  LEushort  createTimeHourMin;
  LEushort  createDate;
  LEushort  lastAccessedDate;
  LEushort  reserved1;
  LEushort	updateTime;
	/* The date field is encoded as follows:     */
	/* 	bit 0-4:	Day of month (1-31)	         */
	/* 	bit 5-8:	Month (1-12)                 */
	/*	bit 9-15:	Year relative to 1980        */
  LEushort	updateDate;
	/* The DOS time field is encoded as follows: */
	/*	bit 0-4:	seconds divided by 2 (0-29)  */
	/*      bit 5-10:	minutes (0-59)           */
	/*	bit 11-15:	hours (0-23)                 */
  LEushort	startingCluster;
  LEulong	fileSize;
} DirectoryEntry;
#else /*FL_NO_PACKED_STRUCTS_SUPPORTED*/
#define FL_DIRECTORY_ENTRY_NAME_OFFSET			0	/* size 11, array */
#define FL_DIRECTORY_ENTRY_ATTRIBUTES_OFFSET		11	/* size 1 */
#define FL_DIRECTORY_ENTRY_LOWERCASE_FLAGS_OFFSET	12	/* size 1 */
#define FL_DIRECTORY_ENTRY_CREATE_TIME_MILLISEC_OFFSET	13	/* size 1 */
#define FL_DIRECTORY_ENTRY_CREATE_TIME_HOURMIN_OFFSET	14	/* size 2 */
#define FL_DIRECTORY_ENTRY_CREATE_DATE_OFFSET		16	/* size 2 */
#define FL_DIRECTORY_ENTRY_LAST_ACCESS_DATE_OFFSET	18	/* size 2 */
#define FL_DIRECTORY_ENTRY_RESERVED1_OFFSET		20	/* size 2 */
#define FL_DIRECTORY_ENTRY_UPDATE_TIME_OFFSET		22	/* size 2 */
#define FL_DIRECTORY_ENTRY_UPDATE_DATE_OFFSET		24	/* size 2 */
#define FL_DIRECTORY_ENTRY_STARTING_CLUSTER_OFFSET	26	/* size 2 */
#define FL_DIRECTORY_ENTRY_FILESIZE_OFFSET		28	/* size 4 */
#define FL_DIRECTORY_ENTRY_SIZE				32
typedef FLByte DirectoryEntry[FL_DIRECTORY_ENTRY_SIZE];
#endif /*FL_NO_PACKED_STRUCTS_SUPPORTED*/
/* FAT Format Parameters record - given to flFormatFS */

typedef struct {
FLWord		noOfRootEntries;
FLWord		noOfSectorsPerCluster;
FLByte		noOfFATs;
FLByte		pType;
FLByte		reserved1;
FLByte		flags;
FLByte      volumeId[4];  /* FAT partition identification number */
FLByte*     volumeLabel;  /* FAT partition label string. If NULL, no label */
} FATFormatParams;


#define FAT12_PARTIT                     0x01
#define FAT16_PARTIT                     0x04
#define EX_PARTIT                        0x05
#define DOS4_PARTIT                      0x06
#define FAT32_PARTIT                     0x0b

#define FL_TFAT_MODE                     0x1

#define FS_USE_DEFAULT_CLUSTER_SIZE	0

#define STD_FAT_FORMAT_PARAMS	{512,                         /* No of entries in the rood directory */ \
                                 FS_USE_DEFAULT_CLUSTER_SIZE, /* No of sectors per cluster           */ \
								 1,                           /* No of FAT copies                    */ \
								 0,                           /* Partition type                      */ \
								 0, 0,                        /* Reseved 0                           */ \
								 {0, 0, 0, 0},                /* FAT Volume ID                       */ \
								 NULL}                        /* FAT Lable               */


#endif /* FLSTRUCT_H */
