/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/flsysfun.h-arc  $
 *
 *    Rev 1.6   Aug 09 2006 16:52:52   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef FLSYSFUN_H
#define FLSYSFUN_H


/*----------------------------------------------------------------------*/
/*                       f l S y s f u n I n i t                        */
/*                                                                      */
/* Do any necessary initialization for routines in this module.         */
/*                                                                      */
/* Called from fatlite.c (flInit)                                       */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/*----------------------------------------------------------------------*/

extern void flSysfunInit(void);


/*----------------------------------------------------------------------*/
/*                         f l R a n d B y t e                          */
/*                                                                      */
/* Returns a random number between 0 and 255                            */
/*                                                                      */
/* Called from FTLLITE.C                                                */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*        A random number between 0 and 255                             */
/*----------------------------------------------------------------------*/

extern unsigned flRandByte(void);


/*----------------------------------------------------------------------*/
/*                      f l I n s t a l l T i m e r                     */
/*                                                                      */
/* Installs an interval timer.                                          */
/* The implementation of this routine usually means hooking a clock     */
/* interrupt. The polling interval is specified as a parameter. If the  */
/* clock frequency is faster, the interval timer should count several   */
/* clock ticks before calling the interval routine.                     */
/*                                                                      */
/* This routine is necessary if POLLING_INTERVAL (custom.h) is greater  */
/* than 0. In this case this routine will be called from socket.c       */
/* (init). It will be called to install 'socketIntervalRoutine' with a  */
/* period specified by POLLING_INTERVAL.                                */
/*                                                                      */
/* Parameters:                                                          */
/*      routine                : Routine to call at each interval       */
/*        interval        : Milliseconds per polling interval           */
/*                                                                      */
/* Returns:                                                             */
/*         FLStatus        : 0 on success, otherwise failure            */
/*----------------------------------------------------------------------*/

extern FLStatus flInstallTimer(void (*routine)(void), unsigned interval);


#ifdef FL_EXIT

/*----------------------------------------------------------------------*/
/*                      f l R e m o v e T i m e r                       */
/*                                                                      */
/* Removes the active interval timer.                                   */
/* This routine removes the active interval timer set by 'removeTimer'. */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/*----------------------------------------------------------------------*/

extern void flRemoveTimer(void);

#endif


/*----------------------------------------------------------------------*/
/*                       f l C u r r e n t D a t e                      */
/*                                                                      */
/* Returns the current DOS-format date                                  */
/*                                                                      */
/* The DOS date format is documented in dosformt.h.                     */
/*                                                                      */
/* If a TOD clock is not available, return the value of 1/1/80.         */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*        Current date                                                  */
/*----------------------------------------------------------------------*/

extern unsigned flCurrentDate(void);


/*----------------------------------------------------------------------*/
/*                      f l C u r r e n t T i m e                       */
/*                                                                      */
/* Returns the current DOS-format time                                  */
/*                                                                      */
/* The DOS time format is documented in dosformt.h.                     */
/*                                                                      */
/* If a TOD clock is not available, return the value of 0:00 AM.        */
/*                                                                      */
/* Parameters:                                                          */
/*      None                                                            */
/*                                                                      */
/* Returns:                                                             */
/*        Current time                                                  */
/*----------------------------------------------------------------------*/

extern unsigned flCurrentTime(void);


/*----------------------------------------------------------------------*/
/*                      f l C r e a t e M u t e x                       */
/*                                                                      */
/* Creates and initializes a mutex object                               */
/*                                                                      */
/* The mutex is initializes as not owned by anyone.                     */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex                : Pointer to mutex object                  */
/*                                                                      */
/* Returns:                                                             */
/*         FLStatus        : 0 on success, otherwise failure            */
/*----------------------------------------------------------------------*/

extern FLStatus flCreateMutex(FLMutex *mutex);


/*----------------------------------------------------------------------*/
/*                      f l D e l e t e M u t e x                       */
/*                                                                      */
/* Destroys a mutex object                                              */
/*                                                                      */
/* This function frees any resources taken by flCreateMutex.            */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex                : Pointer to mutex object                  */
/*                                                                      */
/* Returns:                                                             */
/*         None                                                         */
/*----------------------------------------------------------------------*/

extern void flDeleteMutex(FLMutex *mutex);


/*----------------------------------------------------------------------*/
/*                        f l T a k e M u t e x                         */
/*                                                                      */
/* Attempts to take ownership of a mutex. If the mutex is currently not */
/* owned, TRUE is returned and the mutex becomes owned. If the mutex is */
/* currently owned, FALSE is returned and ownership is not taken.       */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex                : Pointer to mutex object                  */
/*                                                                      */
/* Returns:                                                             */
/*         FLBoolean        : TRUE if ownership taken, FALSE otherwise  */
/*----------------------------------------------------------------------*/

extern FLBoolean flTakeMutex(FLMutex *mutex);


/*----------------------------------------------------------------------*/
/*                        f l F r e e M u t e x                         */
/*                                                                      */
/* Frees ownership of a mutex                                           */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex                : Pointer to mutex object                  */
/*                                                                      */
/* Returns:                                                             */
/*         None                                                         */
/*----------------------------------------------------------------------*/

extern void flFreeMutex(FLMutex *mutex);


#endif /* FLSYSFUN_H */
