/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/


#include "msys.h"
#include "msys_custom.h"
#include "misc.h"

#include "flbase.h"
#include "flsystem.h"
#include "doch_api.h"
//#include "hib.h"


/* #define FL_CREATE_THREAD */ /* Mutex implemntation with OS help */
unsigned long dbgZone = 0xffffffff;
static FLBoolean fPortaDocInUse = FALSE;
extern void setMDOCWindow(int offset);
//extern BOOL IsPortaDOCFound(void);


/*----------------------------------------------------------------------*/
/*                    f l S y s f u n I n i t                           */
/*                                                                      */
/* Perform system initialization.                                       */
/*                                                                      */
/* Note : This example file did not support a valid implementation.     */
/*----------------------------------------------------------------------*/

void flSysfunInit(void)
{
	/* Initialize system resource */
	DBG_PRINT_WRN(FLZONE_BLKDEV,"\r\nTrueFFS says hello.\r\n");
}

void flDocHSysfunInit(void)
{
	/* Initialize system resource */
	DBG_PRINT_WRN(FLZONE_BLKDEV,"\r\nTrueFFS says hello.\r\n");

	fPortaDocInUse = FALSE;

	//if(IsPortaDOCFound())
		//fPortaDocInUse = TRUE;
}


/*----------------------------------------------------------------------*/
/*                    f l S y s f u n E x i t                           */
/*                                                                      */
/* Free any system resources taken by TrueFFS.                          */
/*                                                                      */
/* This routine was added in TtueFFS 6.0 and is prorotyped in           */
/* flsystems.h using the FL_SYS_FUNC_RELEASE macro.                     */
/*                                                                      */
/* Note : This example file did not support a valid implementation.     */
/*----------------------------------------------------------------------*/

void flSysfunExit(void)
{
#ifdef WIN32
	ExUnmapMemory();
#endif /*WIN32*/
	/* Free system resource */
	DBG_PRINT_WRN(FLZONE_BLKDEV,"\r\nTrueFFS says goodbye.\r\n");
}



/*----------------------------------------------------------------------*/
/*                     f l C r e a t e M u t e x                        */
/*                                                                      */
/* Creates or initializes a mutex                                       */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex           : Pointer to mutex                              */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failure               */
/*----------------------------------------------------------------------*/

FLStatus flCreateMutex(FLMutex *mutex)
{
#ifdef FL_CREATE_THREAD

	HANDLE mtx = CreateMutex(NULL, FALSE, NULL); /*FALSE means no immediate ownership*/
	if (!mtx)
      return flGeneralFailure;

	*mutex = (FLMutex)mtx;

#else /* FL_CREATE_THREAD */

	*mutex = 0;

#endif /* FL_CREATE_THREAD */

	return flOK;
}

/*----------------------------------------------------------------------*/
/*                     f l D e l e t e M u t e x                        */
/*                                                                      */
/* Deletes a mutex.                                                     */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex           : Pointer to mutex                              */
/*                                                                      */
/*----------------------------------------------------------------------*/

void flDeleteMutex(FLMutex *mutex)
{
#ifdef FL_CREATE_THREAD
	CloseHandle((HANDLE)*mutex);
#endif /* FL_CREATE_THREAD */
}

/*----------------------------------------------------------------------*/
/*                      f l T a k e M u t e x                           */
/*                                                                      */
/* wait for mutex                                                       */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex           : Pointer to mutex                              */
/*                                                                      */
/* Returns:                                                             */
/*      int             : TRUE = Mutex taken, FALSE = failure           */
/*----------------------------------------------------------------------*/
FLBoolean flTakeMutex(FLMutex *mutex)
{
#ifdef FL_CREATE_THREAD
	return (WaitForSingleObject((HANDLE)*mutex, INFINITE) == WAIT_OBJECT_0);
#else /* FL_CREATE_THREAD */
	(*mutex)++;
	if (*mutex > 1) {
		(*mutex)--;
		return FALSE;
	}

	return TRUE;
#endif /* FL_CREATE_THREAD */
}

/*----------------------------------------------------------------------*/
/*                        f l F r e e M u t e x                         */
/*                                                                      */
/* Free mutex.                                                          */
/*                                                                      */
/* Parameters:                                                          */
/*      mutex           : Pointer to mutex                              */
/*                                                                      */
/*----------------------------------------------------------------------*/
void flFreeMutex(FLMutex *mutex)
{
#ifdef FL_CREATE_THREAD
	ReleaseMutex((HANDLE)*mutex);
#else
	(*mutex)--;
#endif /* FL_CREATE_THREAD */
}


/*----------------------------------------------------------------------*/
/*                        f l R a n d B y t e                           */
/*                                                                      */
/* Return a random number from 0 to 255.                                */
/*                                                                      */
/* Note : This example file did not support a valid implementation.     */
/*----------------------------------------------------------------------*/
unsigned flRandByte(void)
{
	return 0;
}

#if 0
/*----------------------------------------------------------------------*/
/*                        f l c p y                                     */
/*                                                                      */
/* 32-bit 'memcopy' routine.                                            */
/*                                                                      */
/* Parameters:                                                          */
/*      dest            : pointer to the destination buffer             */
/*      src             : pointer to the source buffer                  */
/*      size            : number of bytes to copy                       */
/*                                                                      */
/* Returns:                                                          	*/
/*	void                                                                */
/*                                                                      */
/*----------------------------------------------------------------------*/
void *  flcpy (void *dest, const void *src, size_t count)
{
  register size_t  i;

 for (i = 0;  i < (count >> 2);  i++)
 {
    /* printf("read 0x%ux,0x%ux,0x%ux,0x%ux\n",((byte *)dest)[i*4],((byte *)dest)[i*4+1],((byte *)dest)[i*4+2],((byte *)dest)[i*4+3]);*/
    *((unsigned long *)dest + i) = *((const unsigned long *)src + i);
 }
 /* handle remaining bytes */
 count &= 3;
 if (count) {
    register size_t  j;

    (unsigned char *) dest += (i << 2);
    (unsigned char *) src  += (i << 2);
    for (j = 0; j < count; j++)
      *((unsigned char *)dest + j) = *((const unsigned char *)src + j);
 }

 return dest;
}
#endif
/*----------------------------------------------------------------------*/
/*                         f l C u r r e n t T i m e                    */
/*                                                                      */
/* Return current DOS time.                                             */
/*                                                                      */
/* The DOS time field is encoded as follows:                            */
/*    bit 0-4   : Seconds divided by 2 (0-29)                           */
/*    bit 5-10  : Minutes (0-59)                                        */
/*    bit 11-15 : Hours (0-23)                                          */
/*                                                                      */
/* Note : This example file did not support a valid implementation.     */
/*----------------------------------------------------------------------*/
unsigned flCurrentTime(void)
{
	return 0;
}

/*----------------------------------------------------------------------*/
/*                         f l C u r r e n t D a t e                    */
/*                                                                      */
/* Return current DOS date.                                             */
/*                                                                      */
/* The DOS date field is encoded as follows:                            */
/*    bit 0-4   : Day of month (1-31)                                   */
/*    bit 5-8  : Month (1-12)                                           */
/*    bit 9-15 : Year relative to 1980                                  */
/*                                                                      */
/* Note : This example file did not support a valid implementation.     */
/*----------------------------------------------------------------------*/
unsigned flCurrentDate(void)
{
	return 0;
}

// this function cut for now!!!!
#if 1
void setWindowOffset(FLBoolean using8KB, volatile FLByte * baseAddress)
{
#if 0
	FLDword pciValueToSet;
	volatile FLByte	* pciRegAddress = baseAddress + HIB_PCI_CONTROL_REGISTER;

	/* PortaDoc EVB is Used*/
	if(fPortaDocInUse)
	{
		if(using8KB)
            setMDOCWindow(0);   // setMDOCWindow is UNDEFINED ANYWHERE
		else
            setMDOCWindow(0x8000);  // setMDOCWindow is UNDEFINED ANYWHERE
	}
	/* PCI EVB is Used*/
	else
	{
		if(using8KB)
			pciValueToSet = (PCI_MEM_WIN_0 | BUS_ACESS_16_BIT | PCI_WIN_SIZE_32K);
		else
			pciValueToSet = (PCI_MEM_WIN_1 | BUS_ACESS_16_BIT | PCI_WIN_SIZE_32K);

		*((volatile FLWord FAR0*)( pciRegAddress))=(FLWord)(pciValueToSet);
	}
#endif
}
#endif
