/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/



#ifndef FLSYSTEM_H
#define FLSYSTEM_H

#include "flcustom.h" /* Application compilation flags */
#include "flsystyp.h" /* Basic system types            */

//#include <memory.h>
//#include <windows.h>
//#include <winbase.h>
//#include <string.h>
//#include <stdlib.h>
//#include <stdio.h>
#include "flmalloc.h"
//#include "exD_help.h" /* for ExPrint*/
//extern BOOL IsPortaDOCFound(void);

extern FLWord wUtDebugZone;

/* CPU target
 *
 * Use compiler switches or insert a #pragma here to select the CPU type
 * you are targeting.
 *
 */
struct __DMA_Params_S;



/* DiskOnChip window base address
 *
 * Defines the possible location of the DiskOnChip device. You should specify
 * the lowest and highest addresses for the search.
 *
 * The use of those definition, should be done in your own FLCUSTOM.C file.
 * Those definitions are for your convenient and are not used by TrueFFS itself.
 *
 * Note: The range in this example is for M-Systems x86 EVB's.
 */

#define FL_LOW_DOC_ADDRESS  0xC8000L
#define FL_HIGH_DOC_ADDRESS 0xdFFFFL



/* NULL constant
 *
 * Some compilers require a different definition for the NULL pointer.
 */

/* #include <_null.h> */
#ifndef NULL
  //#ifdef  __cplusplus
    #define NULL    0
 // #else
  //  #define NULL    ((void *)0)
  //#endif
#endif
/*
 * First IOCTL function number
 *
 * When using TrueFFS' IOCTL functions you have to define the code of the first
 * TrueFFS IOCTL function (after that the functions get consecutive increasing numbers).
 * This number should be out of the range of the standard IOCTL codes used by your
 * operating system.
 *
 */

#define FL_IOCTL_START  0

/* Naming convention for functions that uses non-default convention.
 *
 * In case the calling application uses a different convention then the one
 * used to compile TrueFFS you can use the NAMING_CONVENTION definition.
 * The NAMING_CONVENTION definition is added as a qualifier to all TrueFFS
 * exported API. A good example is a c++ application that uses TrueFFS,
 * which was compiled using standard C.If this is not the case simply leave
 * the NAMING_CONVENTION defined as empty macro.
 */

//#define NAMING_CONVENTION cdecl

/* Little-endian/big-endian
 *
 * If your machine uses the big-endian (Motorola) format, uncomment the
 * following line.
 *
 * This compilation flag makes sure that FAT and translation layer structures
 * will be written in little-endian (Intel) format for integers. It also
 * affects the way DiskOnChip 16 bits registers are analyzed.
 */

/* #define FL_BIG_ENDIAN */


/* Far pointers
 *
 * Specify here which pointers may be far, if any.
 * Far pointers are usually relevant only to 80x86 architectures.
 *
 * Specify FAR_LEVEL:
 *   0 - If using a flat memory model or having no far pointers.
 *   1 - If only the socket window may be far
 *   2 - If only the socket window and caller's read/write buffers
 *       may be far.
 *   3 - If socket window, caller's read/write buffers and the
 *       caller's I/O request packet may be far.
 */

/* #define FL_SWAP_BYTES */
#define FAR_LEVEL       0


/* Memory routines for RAM buffers
 *
 * The library routines memcpy, memset, and memcmp are standard for ANSI-C
 * compilers. However, there may be variations in which a #include defines
 * them, and variations such as the Borland's _fmemcpy, _fmemset, and _fmemcmp
 * routines also exist. To overcome such nuances, the TrueFFS code uses memory
 * handling macros called tffscpy, tffsset, and tffscmp, with prototypes
 * identical to the standard memcpy, memset, memcmp. Provide the correct
 * #include directive, and incorporate C macros that define the tffsxxx
 * routines to the names of your library routines (or user-supplied routines
 * to manually code these routines).
 */

#ifndef FLCLIB_FUNC
  #if FAR_LEVEL > 0
   #define tffscpy _fmemcpy
   #define tffscmp _fmemcmp
   #define tffsset _fmemset
  #else /* FAR_LEVEL > 0 */
   #define tffscpy memcpy
   #define tffscmp memcmp
   #define tffsset memset
  #endif /* FAR_LEVEL > 0 */
#else/*FLCLIB_FUNC*/
  #include "misc.h"
  #define tffscpy memcpy
  #define tffscmp memcmp
  #define tffsset memset
#endif /*FLCLIB_FUNC*/

/* Pointer arithmetic
 *
 * The following macros define machine and compiler-dependent macros for
 * handling pointers to physical window addresses. The definitions below are
 * for x86 using Windows XP on an M-Systems EVB.
 *
 * 'physicalToPointer' translates a physical flat address to a pointer.
 * Note that if your processor uses virtual memory, the code should
 * map the physical address to virtual memory, and return a pointer to that
 * memory (the size parameter tells how much memory should be mapped).
 *
 */

#if FAR_LEVEL > 0
#include <dos.h>

#define physicalToPointer(physical,size,drive)          \
	MK_FP( ((int)((physical) >> 4)) , ((int) (physical) & 0xF) )

#define addToFarPointer(base,increment)         \
	MK_FP(FP_SEG(base) + (unsigned short)((FP_OFF(base) + (long)(increment)) >> 4), \
	      (FP_OFF(base) + (int)(increment)) & 0xF)

#define subFromFarPointer(base,increment)		\
	MK_FP(FP_SEG(base) + (unsigned short)((FP_OFF(base) - (long)(increment)) >> 4),	\
	      (FP_OFF(base) - (int)(increment)) & 0xF)

#define distanceBetweenFarPointers(ptr1, ptr2)		\
	(((unsigned long)(FP_SEG(ptr1) - FP_SEG(ptr2)) << 4) + (FP_OFF(ptr1) - FP_OFF(ptr2)))

#define pointerToPhysical(ptr)                  \
	(((unsigned long) FP_SEG(ptr) << 4) + FP_OFF(ptr))

#define freePointer(ptr,size)

#else /* FAR_LEVEL > 0 */
/* The include file and pragma bellows are used for opening a memory window to
 * the DiskOnChip device in Windows 2000 and up.
 */
//#include "MapMemAPI.h"
#pragma comment(lib, "MapMemory.lib")
//#define physicalToPointer(physical,size,drive) (pfn_Map_Memory(physical, size))
  #define physicalToPointer(physical,size,drive) (physical)

/* The rest of the arithmetics are trivial addition and subtractions. */
#define addToFarPointer(base,increment)			\
	((void *) ( ( (unsigned char *)(base) )+(increment)) )

#define subFromFarPointer(base,increment)		\
       addToFarPointer(base,(-(long)(increment)))

#define distanceBetweenFarPointers(ptr1, ptr2)		\
	(((unsigned long)(ptr1)) - ((unsigned long)(ptr2)))

#define pointerToPhysical(ptr)  ((unsigned long)(ptr))

#define freePointer(ptr,size)

#endif  /* #if FAR_LEVEL > 0 */


/*
 * Signed/unsigned char
 *
 * It is assumed that 'char' is signed. If this is not your compiler
 * default, use compiler switches, or insert a #pragma here to define this.
 *
 */



/* Mutex type
 *
 * If you intend to access the TrueFFS API in a multi-tasking environment,
 * you may need to implement some resource management and mutual-exclusion
 * of TrueFFS with mutex & semaphore services that are available to you. In
 * this case, define here the Mutex type you will use, and provide your own
 * implementation of the Mutex functions in flcustom.c
 *
 * By default, a Mutex is defined as a simple counter, and the Mutex
 * functions in flcustom.c implement locking and unlocking by incrementing
 * and decrementing the counter. This will work well on all single-tasking
 * environments, as well as on many multi-tasking environments.
 */

typedef int FLMutex;



/* Memory allocation
 *
 * Some modules in TrueFFS initialization routines need to allocate
 * memory to handle the Flash media. The required size depends on the media
 * being handled.
 *
 * You may choose to use the standard 'malloc' and 'free' to handle such
 * memory allocations, provide your own equivalent routines, or you may
 * choose not to define any memory allocation routine. In this case, the
 * memory will be allocated statically at compile-time on the assumption of
 * the largest media configuration you need to support. This is the simplest
 * choice, but may cause your RAM requirements to be larger than you
 * actually need.
 *
 * If you define routines other than malloc & free, they should have the
 * same parameters and return types as malloc & free. You should either code
 * these routines in flcustom.c or include them when you link your application.
 *
 * In case you do not have dynamic allocation resources, then you can use the
 * TrueFFS implementation. You will need to set the FL_TRUEFFS_HEAP_SIZE
 * definition in FLCUSTOM.H and add FLMALLOC.C to your application or driver.
 */

#if FL_TRUEFFS_HEAP_SIZE > 0
#include "flmalloc.h"
#define FL_MALLOC    flMalloc
#define FL_FREE(a)   flFree((void *)a)
#else /* FL_TRUEFFS_HEAP_SIZE > 0*/
#define FL_MALLOC    malloc
#define FL_FREE(a)   free((void *)a)
#endif /* FL_TRUEFFS_HEAP_SIZE > 0*/

#ifdef DOCH_FILE_SIMULATION
#define DOCH_MALLOC malloc
#define DOCH_FREE(a) free((void *)a)
#endif /*DOCH_FILE_SIMULATION*/



/*
 * The type of printed massages and the way they will be printed can
 * be customized using the 6 macros bellow:
 */

#define FLTXT(str) ((const FLSByte*)(str))
unsigned char GetPrintLevel(void);

//#define DBG_PRINT_FLOW(zone,str)      if((GetPrintLevel() & 1)&&(zone&(wUtDebugZone))) ExPrint(FLTXT(str))
//#define DBG_PRINT_ERR(zone,str)       if((GetPrintLevel() & 2)&&(zone&(wUtDebugZone))) ExPrint(FLTXT(str))
//#define DBG_PRINT_WRN(zone,str)       if((GetPrintLevel() & 4)&&(zone&(wUtDebugZone))) ExPrint(FLTXT(str))
#define DBG_PRINT_FLOW_PRM(zone,str)  if((GetPrintLevel() & 8)&&(zone&(wUtDebugZone))) ExPrint str
//#define DBG_PRINT_ERR_PRM(zone,str)   if((GetPrintLevel() & 16)&&(zone&(wUtDebugZone))) ExPrint str
//#define DBG_PRINT_WRN_PRM(zone,str)   if((GetPrintLevel() & 32)&&(zone&(wUtDebugZone))) ExPrint str
#define DBG_PRINT_UT(zone,str)        if((GetPrintLevel() & EX_UT_PRINT)&&(zone&(wUtDebugZone))) ExPrint(FLTXT(str))
#define DBG_PRINT_UT_PRM(zone,str)    if((GetPrintLevel() & EX_UT_PRINT_PRM)&&(zone&(wUtDebugZone))) ExPrint str

/*
 * First IOCTL function number
 *
 * When using TrueFFS' IOCTL functions you have to define the code of the first
 * TrueFFS IOCTL function (after that the functions get consecutive increasing numbers).
 * This number should be out of the range of the standard IOCTL codes used by your
 * operating system.
 *
 */

#ifdef FL_IOCTL_INTERFACE
  #define FL_IOCTL_START  0
#endif



/* Default calling convention
 *
 * C compilers usually use the C calling convention to routines (cdecl), but
 * often can also use the pascal calling convention, which is somewhat more
 * economical in code size. Some compilers also have specialized calling
 * conventions which may be suitable. Use compiler switches or insert a
 * #pragma here to select your favorite calling convention.
 */



/* Naming convention for functions that uses non-default convention.
 *
 * In case the calling application uses a different convention then the one
 * used to compile TrueFFS you can use the NAMING_CONVENTION definition.
 * The NAMING_CONVENTION definition is added as a qualifier to all TrueFFS
 * exported API. A good example is a c++ application that uses TrueFFS,
 * which was compiled using standard C.If this is not the case simply leave
 * the NAMING_CONVENTION defined as empty macro.
 */

//#define NAMING_CONVENTION cdecl



/* System clean up routine
 *
 * This routine will be called every time TrueFFS exists.
 * The implementation is found in flsystem.c
 */

extern void flSysfunExit(void);

#define FL_SYS_FUNC_RELEASE flSysfunExit()



/* Control over the priority of the TrueFFS thread
 *
 * Some of TrueFFS time is spend on polling the flash ready\busy signal.
 * TrueFFS supplies a verity of ways to utilize this time, one of which is
 * to inform the OS that TrueFFS priority can be lowered for the time being.
 */

#define FL_LowerPriorityThread(flashPtr)
#define FL_RaisePriorityThread(flashPtr)



/* TrueFFS Yield CPU routine
 *
 * Allows the CPU to process other tasks while TrueFFS is waiting for the
 * flash/DiskOnChip to complete an operation. The estimated amount of time,
 * is supplied as an argument.
 * The amount of time spend in the routine can be longer or shorted then
 * the given argument.
 *
 * Note: This routine can be used in conjunction with the interrupt mechanism.
 */

#define FL_TFFS_SLEEP(handle,microseconds) /* Do nothing - simply pole the R/B */





/* Improving performance by using native code.
 *
 * You can improve the way TrueFFS utilizes 32bit (or larger) native variables
 * by uncommenting the definition bellow.
 */

/* #define FL_ASSUME_NATIVE_IS_32BITS */



/* Removing backward compatibility basic type definitions.
 *
 * TrueFFS 5.x used the byte, word, dword, Sbyte, Sword and Sdword basic types.
 * Since these names are used by several major OSs, such as Windows and
 * VxWorks, it was decided to rename these types with less general names
 * (See the FLxxx types below). As many TrueFFS-based applications already
 * use these types, TrueFFS still automatically defines them. If these
 * definitions cause your compiler to report redefinition errors, simple
 * define FL_DISABLE_OLD_TRUEFFS_TYPES and TrueFFS will automatically remove
 * the definition. */

#define FL_DISABLE_OLD_TRUEFFS_TYPES



/* Optionally you can define TrueFFS basic types:
 *
 * FLByte, FLWord, FLDword, FLSByte, FLSWord, FLSDword,
 */



/* Initialization for H/W configuration routine
 *
 * Some of the DiskOnChip H/W properties can be configured using the
 * flHWConfig() routine.
 *
 * However it is usually more convenient to just code the TrueFFS defaults here
 * and save the trouble of calling the actual routine.
 *
 * #define FL_IRQ_RB_INIT(wSockeNo)             FL_INT_RB_DISABLED
 * #define FL_DPD_INIT(wSockeNo)				FL_DPD_DISABLED
 * #define FL_PAGE_MODE_INIT(wSockeNo)			FL_DISABLED
 * #define FL_TURBO_MODE_INIT(wSockeNo)			FL_NONTURBO_MODE
 * #define FL_DMA_INIT(wSockeNo)				FL_DMA_HW_DISABLED
 * #define FL_DPS_2_COPIES_INIT(wSockeNo)       FL_DISABLED
 */



/************************************************************************************/
/*************************   Access Layer Customization   ***************************/
/************************************************************************************/

/*********************************/
/* Runtime customization options */
/*********************************/


/*
 * Uncomment the FL_NO_INIT_MMU_PAGES definition for:
 *
 * In order to skip initialization of first and last byte of the given buffer.
 * When the user buffer resides on separated memory pages the read
 * operation may cause a page fault. Some CPU's return from a page
 * fault (after loading the new page) and reread the bytes that caused
 * the page fault from the new loaded page. In order to prevent such a
 * case the first and last bytes of the buffer are written.
 *
 */

/* #define FL_NO_INIT_MMU_PAGES */



/**************************************/
/* Compile time customization options */
/**************************************/

/* Remove runtime control over memory access routines
 *
 * When defined , TrueFFS will use your own macros , for accessing the DiskOnChip memory window
 * This implementation will provide better performance, at the expense of automatic detection
 * and ease of integration.
 *
 * Default macros can be found in _DOCSYS.H
 *
 * #define flDirectWrite8BitReg(flash,offset,val)           : Write 8  bit val to flash->win+offset
 * #define flDirectWrite16BitReg(flash,offset,val)          : Write 16  bit val to flash->win+offset
 * #define flDirectRead8BitReg(flash,offset)                : Read 8  bit val from flash->win+offset
 * #define flDirectRead16BitReg(flash,offset)               : Read 8  bit val from flash->win+offset
 * #define flReadEvenNumberOfBytes(flash,offset,dest,count) : Read count bytes from flash->win+offset to dest
 * #define flRead512Bytes(flash,offset,dest) <= (S/W DMA)   : Same as above only 512 bytes
 * #define flWriteEvenNumberOfBytes(flash,offset,src,count) : Write count bytes to flash->win+offset from dest
 * #define flWrite512Bytes(flash,offset,src) <= (S/W DMA)   : Same as above only 512 bytes
 * #define flDocWindow(flash)                               : DiskOnChip memory window (usually 2KB)
 */

#define FL_NO_USE_FUNC



/* Physical access to the device.
 *
 * While the routines above return either actual data to the higher layer S/W
 * the routines bellow provides the means for those accesses.
 *
 * Note: Default macros can be found in FLCHKDEFS.H
 *
 * FLWRITE_IO_BYTE        , FLREAD_IO_BYTE
 * FLWRITE_IO_WORD        , FLREAD_IO_WORD
 * FLWRITE_IO_DWORD       , FLREAD_IO_DWORD
 * TFFSCPY_FROM_IO_8_BITS , TFFSCPY_FROM_IO_16_BITS
 * TFFSCPY_TO_IO_8_BITS   , TFFSCPY_TO_IO_16_BITS
 * TFFSSET_IO_8_BITS      , TFFSSET_IO_16_BITS
 */

/******************************************************************************/
/* utilities used predefined macros, allows user routines installation
extern void * flset(void * dest,int c,size_t count);
extern void * flcpy(void * dest,const void *src,size_t count);
extern int    flcmp(const void * dest,const void *src,size_t count);

#define TFFSCPY_TO_IO_16_BITS(dest,src,count)   flcpy((void *)(dest),src,count)
#define TFFSCPY_TO_IO_8_BITS(dest,src,count)    flcpy((void *)(dest),src,count)

#define TFFSCPY_FROM_IO_16_BITS(dest,src,count) flcpy(dest,(void *)(src),count)
#define TFFSCPY_FROM_IO_8_BITS(dest,src,count)  flcpy(dest,(void *)(src),count)
*/


/******************************************************************************/


/* The G3 DiskOnChip supports the following access times:
 * - SRAM     access time (slowest)
 * - NonTurbo access time (faster)
 * - Turbo    access time (fastest)
 * Costumer has the following options:
 * - The access time to DiskOnChip is always SRAM access time
 * 1. Configure DOC to work at access time equal or slower than SRAM access time
 *    in that case do not define the following macro.
 * 2. Provide routine that enables TFFS to change the access time in run-time
 *    and hence to provide fast access time to registers
 */

/* #define FL_CHANGE_READ_ACCESS_TIME(wTimeNanoSec,bSocket) */



/* Burst mode configuration
 *
 * The following configurations are required for activating the burst support
 * of the DiskOnChip.
 */
/* #define FL_USE_BURST_MODE_READ */

#ifdef DOCH_USE_BURST_MODE_READ
 #define DOCH_BURST_LENGTH		         DOCH_BURST_LEN_8_CYC
 #define DOCH_BURST_LATENCY		         0
 #define DOCH_BURST_HOLD		         DOCH_BURST_HOLD_1_CLK
 #define DOCH_BURST_WAIT_STATE	         0
 #define DOCH_HOST_ENTER_READ_BURST_MODE dochHostEnterReadBurstMode
 #define FL_HOST_ENTER_BURST_MODE        flHostEnterBurstMode
 #define FL_HOST_EXIT_BURST_MODE         flHostExitBurstMode
#endif /* FL_USE_BURST_MODE_READ */


/************************/
/* HW DMA Configuration */
/************************/

/* #define FL_DMA_CONFIG(bDMA_ParamsPtr) */


/************************/
/* DOCH Specific		*/
/************************/

/*PCI EVB specific*/
#define HIB_PCI_INTERRUPT_COUNTER   0x7FFC  /*Constant, No offset*/
#define HIB_PCI_CONTROL_REGISTER    0x7FFE  /*Constant, No offset*/

/*	PCI Memory windows	*/
typedef enum {
	PCI_MEM_WIN_0	=	0x0,	/*0..32KB*/
	PCI_MEM_WIN_1	=	0x1,	/*32.64KB*/
	PCI_MEM_WIN_2	=	0x2,	/*64..96KB*/
	PCI_MEM_WIN_3	=	0x3		/*96.1282KB*/
} DOCH_PCIMemoryWindow;

/*	PCI Window Size */
typedef enum {
	PCI_WIN_SIZE_8K		=	0x00,	/*Generate CS only for first 8KB*/
	PCI_WIN_SIZE_32K	=	0x40
} DOCH_PCIWinSize;

#define PCI_HW_RST			0x10

/*	PCI Master/Slave */
typedef enum {
	PCI_MASTER			=	0x00,
	PCI_SLAVE			=	0x20
} DOCH_PCIMasterSlave;

/*	PCI Bus Access	*/
typedef enum {
	BUS_ACESS_8_BIT		=	0x80,
	BUS_ACESS_16_BIT	=	0x00,
} DOCH_PCIBusAccess;

#define PCI_LOCK_SIGNAL		0x1000
#define PCI_IRQ_SIGNAL		0x2000
#define PCI_DMA_SIGNAL		0x4000
#define PCI_BUSY_SIGNAL		0x8000


#define DOCH_SLEEP(socket, device, microseconds)
void flDocHSysfunInit(void);
#define DOCH_SYS_FUNC_INIT flDocHSysfunInit()

void setWindowOffset(FLBoolean using8KB,volatile FLByte	* baseAddress);
#define DOCH_SET_WINDOW_OFFSET(using8KB,baseAddress)	(setWindowOffset(using8KB,baseAddress))

#endif /* FLSYSTEM_H */

