/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/fltl.h-arc  $
 *
 *    Rev 1.7   Aug 09 2006 16:52:52   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#ifndef FLTL_H
#define FLTL_H

#include "flbase.h"
#include "flstruct.h"


typedef struct tTL TL;

/*----------------------------------------------------------*/
/* Format Parameters record passed to the translation layer */
/*----------------------------------------------------------*/

typedef struct {

  /* Global device info */

  FLByte             percentUse;

  FLByte             noOfBDTLPartitions;

  FLByte             noOfBinaryPartitions;

  BDTLPartitionFormatParams3   FAR2* BDTLPartitionInfo;

  BinaryPartitionFormatParams3 FAR2* binaryPartitionInfo;

  FLDword            flags;

  /* First volume info */

  FLByte             protectionKey[8];

  FLByte             protectionType;

  FLByte             noOfSpareUnits;

  /* Special features */

  FLByte             cascadedDeviceNo;

  FLByte             noOfCascadedDevices;

  FLProgressCallback progressCallback;

  FLDword            osakVersion;

  /* None DiskOnChip parameters */

  FLSDword           bootImageLen;

  FLSDword           dataPartitionLen;

  FLDword            vmAddressingLimit;

  FLWord             embeddedCISlength;

  FLByte FAR1 *      embeddedCIS;

} TLFormatParams;

#include "_fltl.h"

#endif /* FLTL_H */


