/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************
**  COPYRIGHT 2007 Marvell Inernational Ltd.
**  All Rights Reserved
**
**  COPYRIGHT (C) 2006 Intel Corporation.
**
**  This software as well as the software described in it is furnished under
**  license and may only be used or copied in accordance with the terms of the
**  license. The information in this file is furnished for informational use
**  only, is subject to change without notice, and should not be construed as
**  a commitment by Intel Corporation. Intel Corporation assumes no
**  responsibility or liability for any errors or inaccuracies that may appear
**  in this document or any software that may be provided in association with
**  this document.
**  Except as permitted by such license, no part of this document may be
**  reproduced, stored in a retrieval system, or transmitted in any form or by
**  any means without the express written consent of Intel Corporation.
**
**  FILENAME:	formatdata.c
**
**  PURPOSE: 	Two available methods for providing format data to the
**              mDOC SDK formating function
**
******************************************************************************/
/*------------------------------------------------------------------------------
These are tested examples for formatting the mDOC H3 device
--------------------------------------------------------------------------------*/

#include "typedef.h"
#include "msys.h"
#include "flstruct.h"
#include "misc.h"
#include "tim.h"

#define MDOC_NUM_BDTL_PARTITIONS   2    // application dependent
#define MDOC_NUM_BINARY_PARTITIONS 2    // application dependent

// formatting data for mDOC
//==============================
FormatParams3                formatData;
BDTLPartitionFormatParams3   bdtlPartitionArray[MDOC_NUM_BDTL_PARTITIONS];      // set this array length appropriately
BinaryPartitionFormatParams3 binPartitionArray[MDOC_NUM_BINARY_PARTITIONS];     // set this array length appropriately

//---------------------------------------------
// setup_mDocFormatData
//
// This code should be altered to fit the
// application.  Note that you must specify at
// least one binary partition into which the
// TIM and images will be stored.
//
// This should be replaced by a reserved package
// method during protocol download
//---------------------------------------------
FormatParams3 *mDOC_GetFormatData( void )
{
  int i;
  FormatParams3 *pFormat = &formatData;

  //clear the data structure areas
  //------------------------------
  memset( &formatData,0,sizeof(formatData));
  memset( &bdtlPartitionArray,0,sizeof(bdtlPartitionArray));
  memset( &binPartitionArray,0,sizeof(binPartitionArray));

  //set-up the head of the format data
  //----------------------------------
  pFormat->percentUse           = 0;                             /* MUST always be 0 */
  pFormat->noOfBDTLPartitions   = MDOC_NUM_BDTL_PARTITIONS;      /* application dependent - user specified */
  pFormat->noOfBinaryPartitions = MDOC_NUM_BINARY_PARTITIONS;    /* application dependent - user specified */

  //setup pointers to format descriptors
  //----------------------------------------
  pFormat->BDTLPartitionInfo   = bdtlPartitionArray;
  pFormat->binaryPartitionInfo = binPartitionArray;

  pFormat->cascadedDeviceNo    = 0;         /* not used always set as zero */
  pFormat->noOfCascadedDevices = 0;         /* not used always set as zero */
  pFormat->progressCallback    = NULL;      /* functionality not implemented, set to NULL */
  pFormat->FP_0_RFU_0          = 0;         /* FP_0_RFU_0;  Reserved 0 */
  pFormat->FP_1_RFU_0          = 0;         /* FP_1_RFU_0;  Reserved 0 */
  pFormat->bootImageLen        = 0;         /* FLSDword bootImageLen;           Reserved 0     */
  pFormat->vmAddressingLimit   = 0;         /* FLDword  vmAddressingLimit;      Reserved 0     */
  pFormat->embeddedCISlength   = 0;         /* FLWord   embeddedCISlength;      Reserved 0     */
  pFormat->embeddedCIS         = NULL;      /* FLByte   FAR1 *embeddedCIS;      Reserved NULL  */

  // setup the user (BDTL) partitions
  //---------------------------------
  for( i=0; i<pFormat->noOfBDTLPartitions; i++ )
  {
    (pFormat->BDTLPartitionInfo)[i].length                = 16*1024*1024;  /* 16 MBytes example - application/user defined */
    (pFormat->BDTLPartitionInfo)[i].fastAreaLength        = 10*1024;       /* 10 kbyte example - application/user defined */
    (pFormat->BDTLPartitionInfo)[i].lengthType            = 0;             /* application/user defined */
    (pFormat->BDTLPartitionInfo)[i].fastAreaLengthType    = 0;             /* application/user defined */
    (pFormat->BDTLPartitionInfo)[i].fastAreaVirtualFactor = 1;             /* application/user defined */
    (pFormat->BDTLPartitionInfo)[i].noOfSpareUnits        = 3;             /* 3 is the standard value, cannot be < 1 */
    (pFormat->BDTLPartitionInfo)[i].BDTLFP_0_RFU_0        = 0;             /* FLDword  BDTLFP_0_RFU_0: Reserved 0  */
    (pFormat->BDTLPartitionInfo)[i].BDTLFP_1_RFU_0        = 0;             /* FLDword  BDTLFP_1_RFU_0: Reserved 0  */
    (pFormat->BDTLPartitionInfo)[i].BDTLFP_2_RFU_0        = 0;             /* FLDword  BDTLFP_2_RFU_0: Reserved 0  */
    (pFormat->BDTLPartitionInfo)[i].BDTLFP_3_RFU_0        = 0;             /* FLDword  BDTLFP_3_RFU_0: Reserved 0  */
    memset( &(pFormat->BDTLPartitionInfo)[i].protectionKey[0], 0, 8);      /* FLByte   protectionKey[8]; The key for the protection */
    (pFormat->BDTLPartitionInfo)[i].protectionType        = 0;             /* FLByte   protectionType  Protection attributes  - backward compatibility */
  }                                                                        /* #define PROTECTABLE           1   /* partition can receive protection */
                                                                           /* #define READ_PROTECTED        2   /* partition is read protected      */
                                                                           /* #define WRITE_PROTECTED       4   /* partition is write protected     */
                                                                           /* #define LOCK_ENABLED          8   /* HW lock signal is enabled        */
                                                                           /* #define LOCK_ASSERTED         16  /* HW lock signal is asserted       */
                                                                           /* #define KEY_INSERTED          32  /* key is inserted (not currently   */
                                                                           /* #define CHANGEABLE_PROTECTION 64  /* changeable protection area type  */
                                                                           /* #define OTW_PROTECTED         128 /* partition is locked forever      */
                                                                           /* #define STICKY_LOCK_ASSERTED  256 /* Sticky lock is activated         */

  // setup the binary partitions
  //----------------------------
  for( i=0; i<pFormat->noOfBinaryPartitions; i++ )
  {
    (pFormat->binaryPartitionInfo)[i].length         = 4 *1024 * 1024;         /* 4Mbytes - example */
    (pFormat->binaryPartitionInfo)[i].lengthType     = FL_LENGTH_IN_BYTES; /* must be FL_LENGTH_IN_BYTES */
    memcpy( &(pFormat->binaryPartitionInfo)[i].sign[0], "BIPO", 4);        /* default signature, must be 4 bytes, can be other than "BIPO" */
    (pFormat->binaryPartitionInfo)[i].flags          = TL_NORMAL_FORMAT;   /* FLDword  flags;  TL_NORMAL_FORMAT == 0  / TL_SPL_FORMAT      */
    (pFormat->binaryPartitionInfo)[i].spareBlocks    = 1;                  /* user defined  Spare blocks for DBB support */
    (pFormat->binaryPartitionInfo)[i].BDKFP_0_RFU_0  = 0;                  /* FLDword  BDKFP_0_RFU_0; /* Reserved 0  */
    (pFormat->binaryPartitionInfo)[i].BDKFP_1_RFU_0  = 0;                  /* FLDword  BDKFP_1_RFU_0; /* Reserved 0  */
    (pFormat->binaryPartitionInfo)[i].BDKFP_2_RFU_0  = 0;                  /* FLDword  BDKFP_2_RFU_0; /* Reserved 0  */
    (pFormat->binaryPartitionInfo)[i].BDKFP_3_RFU_0  = 0;                  /* FLDword  BDKFP_3_RFU_0; /* Reserved 0  */
    memset( &(pFormat->binaryPartitionInfo)[i].protectionKey[0], 0, 8);    /* FLByte   protectionKey[8]; The key for the protection */
    (pFormat->binaryPartitionInfo)[i].protectionType = 0;                  /* FLByte   protectionType  Protection attributes  - backward compatibility */
  }                                                                        /* #define PROTECTABLE           1   /* partition can receive protection */
                                                                           /* #define READ_PROTECTED        2   /* partition is read protected      */
                                                                           /* #define WRITE_PROTECTED       4   /* partition is write protected     */
                                                                           /* #define LOCK_ENABLED          8   /* HW lock signal is enabled        */
                                                                           /* #define LOCK_ASSERTED         16  /* HW lock signal is asserted       */
                                                                           /* #define KEY_INSERTED          32  /* key is inserted (not currently   */
                                                                           /* #define CHANGEABLE_PROTECTION 64  /* changeable protection area type  */
                                                                           /* #define OTW_PROTECTED         128 /* partition is locked forever      */
                                                                           /* #define STICKY_LOCK_ASSERTED  256 /* Sticky lock is activated         */
  return pFormat;
}




//---------------------------------------------------------------------------------------
// Extract the mDoc formatting data from the reserved packages in the TIM.
//
// We are massaging the TIM data which are all stored as 32 bit UINTS into the proper
// format for the call into the mDOC SDK formatting function.
//
// If we encounter a problem, return a NULL pointer
//---------------------------------------------------------------------------------------
FormatParams3 *mDOC_GetFormatDataFromTim( pTIM pTIM_h )
{
  UINT_T retVal; UINT_T nBDTL, nBIN, i, j;
  int count;

  pWTP_RESERVED_AREA_HEADER pResArea;
  pMDOCFORMAT_INFO          pMdocFormat;
  pMDOC_BDTL_PARTITION      pBDTL;
  pMDOC_BINARY_PARTITION    pBIN;

  // Retrieve the main package which describes the quantities
  // of each of the binary and BDTL packages.
  //---------------------------------------------------------
  pResArea = FindPackageInReserved( &retVal, pTIM_h, MDOCFORMATID );
  if( retVal != NoError )
    return (FormatParams3 *)NULL;

  // init data items
  memset(&formatData, 0, sizeof(FormatParams3) );
  nBDTL = 0;
  nBIN  = 0;

  pMdocFormat = (pMDOCFORMAT_INFO)pResArea;


  // Now, convert the data to the appropriate sizes for the
  // FormatParams sturcture, since all data
  // in the TIM are stored as 32 bit items
  //----------------------------------------------------------------
  formatData.percentUse           = (FLByte)pMdocFormat->percentUse;
  formatData.noOfBDTLPartitions   = (FLByte)pMdocFormat->noOfBDTLPartitions;
  formatData.noOfBinaryPartitions = (FLByte)pMdocFormat->noOfBinaryPartitions;
  formatData.BDTLPartitionInfo    = bdtlPartitionArray;
  formatData.binaryPartitionInfo  = binPartitionArray;

  // Total number of partitions cannot exceed 16,
  // also sanity check
  //--------------------------------------------
  i = formatData.noOfBDTLPartitions + formatData.noOfBinaryPartitions;
  if( (i > 16) || (i <= 0) )
    return (FormatParams3 *)NULL;


  // Now search for the first and subsequent BDTL partition descriptors
  // Copy each descriptor into the correct format
  //--------------------------------------------------------------------
  i=0;
  pResArea = FindFirstPackageTypeInReserved( &retVal, pTIM_h, MDOCBDTLID );
  if (retVal == NoError )
  {
    do
    {
      nBDTL++;
      pBDTL = (pMDOC_BDTL_PARTITION)pResArea;
      bdtlPartitionArray[i].length                = pBDTL->length;
      bdtlPartitionArray[i].fastAreaLength        = pBDTL->fastAreaLength;
      bdtlPartitionArray[i].lengthType            = (FLWord)pBDTL->lengthType;
      bdtlPartitionArray[i].fastAreaLengthType    = (FLWord)pBDTL->fastAreaLengthType;
      bdtlPartitionArray[i].fastAreaVirtualFactor = (FLWord)pBDTL->fastAreaVirtualFactor;
      bdtlPartitionArray[i].noOfSpareUnits        = (FLWord)pBDTL->noOfSpareUnits;
      bdtlPartitionArray[i].BDTLFP_0_RFU_0        = pBDTL->BDTLFP_0_RFU_0;
      bdtlPartitionArray[i].BDTLFP_1_RFU_0        = pBDTL->BDTLFP_1_RFU_0;
      bdtlPartitionArray[i].BDTLFP_2_RFU_0        = pBDTL->BDTLFP_2_RFU_0;
      bdtlPartitionArray[i].BDTLFP_3_RFU_0        = pBDTL->BDTLFP_3_RFU_0;

      for( j=0; j < sizeof(bdtlPartitionArray[i].protectionKey); j++ )
      {
          bdtlPartitionArray[i].protectionKey[j]  = (FLByte)(pBDTL->protectionKey[j]);
      }

      bdtlPartitionArray[i].protectionType        = (FLByte)pBDTL->protectionType;
      i++;

      pResArea = FindNextPackageTypeInReserved( &retVal );
      if( retVal != NoError )
        break;
    }while( i < formatData.noOfBDTLPartitions );
  }

  if( i != formatData.noOfBDTLPartitions )
    return (FormatParams3 *)NULL;

  // Now search for the first and subsequent binary partition descriptors
  // Copy each descriptor into the correct format
  //---------------------------------------------------------------------
  i=0;
  pResArea = FindFirstPackageTypeInReserved( &retVal, pTIM_h, MDOCBINID );
  if (retVal == NoError )
  {
    do
    {
      nBIN++;
      pBIN = (pMDOC_BINARY_PARTITION)pResArea;
      binPartitionArray[i].length                = pBIN->length;
      binPartitionArray[i].lengthType            = (FLWord)pBIN->lengthType;

      for( j=0; j < sizeof( binPartitionArray[i].sign ); j++ )
      {
         binPartitionArray[i].sign[j]  = (FLByte)pBIN->sign[j];
      }

      binPartitionArray[i].flags                 = pBIN->flags;
      binPartitionArray[i].spareBlocks           = (FLWord)pBIN->spareBlocks;
      binPartitionArray[i].BDKFP_0_RFU_0         = pBIN->BDKFP_0_RFU_0;
      binPartitionArray[i].BDKFP_1_RFU_0         = pBIN->BDKFP_1_RFU_0;
      binPartitionArray[i].BDKFP_2_RFU_0         = pBIN->BDKFP_2_RFU_0;
      binPartitionArray[i].BDKFP_3_RFU_0         = pBIN->BDKFP_3_RFU_0;

      for( j=0; j < sizeof(binPartitionArray[i].protectionKey); j++ )
      {
          binPartitionArray[i].protectionKey[j]  = (FLByte)(pBIN->protectionKey[j]);
      }

      binPartitionArray[i].protectionType        = (FLByte)pBIN->protectionType;
      i++;

      pResArea = FindNextPackageTypeInReserved( &retVal );
      if( retVal != NoError )
        break;
    }while( i < formatData.noOfBinaryPartitions );
  }

  if( i != formatData.noOfBinaryPartitions )
    return (FormatParams3 *)NULL;

  //ok, we're done without errors
  //Return the master pointer for use by the mDOC SDK function
  //----------------------------------------------------------
  return &formatData;

}




//---------------------------------------------------------------------------------------
//
//  mDOC Driver Test Code - Disabled
//
//---------------------------------------------------------------------------------------
#if 0
#define OTP_DATA_SIZE 512
UINT8 otpData[OTP_DATA_SIZE];

#define MDOC_TEST_ARRAY_SIZE 10
UINT8 mDOCtestStatus[MDOC_TEST_ARRAY_SIZE];
//----------------------------------------------------------------------------
// mDOCSmokeTest
//
//
//
//
//----------------------------------------------------------------------------
UINT32 mDOCSmokeTest( void )
{
   UINT8_T TIM_Area[4*1024];
   // UINT32 mDOCtestStatus = 0;
   UINT_T i=0;
   UINT_T dcount;           /*  10        20        30                            60*/
   UINT8_T mdoc_msg[]="Do you know the way to San Hose    789012345678901234567890123?";
   FormatParams3 *pFdata;


   memset( mDOCtestStatus,0,sizeof(mDOCtestStatus));

   //for( i=0; i< MDOC_TEST_ARRAY_SIZE; i++ )
   //{
     // TESTING mDOC Functions
     //---------------------------------
     if( mDOC_Initialize() == M_SYS_TRUE )
     {
       mDOCtestStatus[i] |= 0x01;
#if 1
       if( mDOC_Unformat() == NoError )                     // tested & works
         mDOCtestStatus[i] |= 0x02;

       Delay_ms(10000);

       //calculate pointers inside formatData
       //------------------------------------
       pFdata = mDOC_GetFormatData();                     // tested & works

       // Now test the formatting routine
       //--------------------------------
       if( mDOC_Format( pFdata ) == NoError )               // tested & works
         mDOCtestStatus[i] |= 0x04;

       Delay_ms(10000);

    #if 0
       // Put together some data to write to the mDOC
       //-------------------------------------------
       for( dcount = 0; (dcount + sizeof(mdoc_msg)) < sizeof(TIM_Area);  )
       {
         memcpy( ((char *)TIM_Area) + dcount, mdoc_msg, sizeof(mdoc_msg) );
         dcount += sizeof(mdoc_msg);
       }

       if( mDOC_WriteImage( TIM_Area, 2, sizeof(TIM_Area),2 ) == NoError)  // tested & works
         mDOCtestStatus[i] |= 0x08;

       memset( TIM_Area, 0, sizeof(TIM_Area));
       if( mDOC_GetImage(TIM_Area, 2, sizeof(TIM_Area), 2) == NoError )     // tested & works
         mDOCtestStatus[i] |= 0x10;
    #endif
       Delay_ms(500);
#endif
     }
   //    // end for


  // mDOC_WriteOTPArea( (void *)otpData, OTP_DATA_SIZE );  // Untested ...

  // while( 1 )  // stop here...
  // {};

   return mDOCtestStatus[i];
}
#endif
