/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/


#ifndef FSCUSTOM_H
#define FSCUSTOM_H

/************************************************************************/
/************************************************************************/
/**                                                                    **/
/**   P A C K A G E   L I M I T S  -  C U S T O M I Z A T I O N S      **/
/**                                                                    **/
/************************************************************************/
/************************************************************************/

/* Number of sockets
 *
 * Defines the maximum number of supported physical devices.
 *
 * If SureFS operates only on DiskOnChip device(s), then this number should be
 * identical to FL_SOCKETS. in principal this number can be higher or lower
 * than it (if additional block devices are supported or some sockets are not
 * supported).
 *
 * The actual number of sockets depends on which socket controllers are
 * actually registered and the number of physical devices in the system.
 */

#define FS_SOCKETS		(FL_SOCKETS)



/* Number of volumes
 *
 * Defines the maximum number of supported logical partitions.
 *
 * The actual number of logical partitions depends on number of socket,
 * number of disk partitions, and the file system format required on each
 * logical partition.
 */

#define FS_VOLUMES		(FL_VOLUMES)

/* maximum number of logical partitions per BDTL partiton */
#define FS_MAX_LOGICAL_PARTITIONS 11

/************************************************************************/
/************************************************************************/
/**                                                                    **/
/**       F I L E   S Y S T E M  -  C U S T O M I Z A T I O N S        **/
/**                                                                    **/
/************************************************************************/
/************************************************************************/

/* Number of open files
 *
 * Defines the maximum number of files and directories
 * that can be opened simultaneously.
 *
 * Defining this value to 0, will not compile the SureFS file system API's
 */

#define FS_FILES   0

#if FS_FILES > 0

/* Enable the file system cache (immune to power failures)
 *
 * Cache size used by this example is 200 sectors for the first partition,
 * and 3 sectors for all other partitions.
 */

#define FL_EXTENDED_SECTOR_CACHE

#define FS_DATA_CACHE_SIZE(socket, partition, logPartition)	\
	(	((socket == 0) && (partition == 0)) ? 50 :	3   )


/* Number of FSO's
 *
 * Defines the maximum number of FSO's you can define simultaneously.
 *
 * If your application or driver does not use the FSO functionalities,
 * simply define FS_MAX_FSOS as 0.
 */

/* #define FS_MAX_FSOS 10 */


/* Enable the MultiMedia functionalities.
 *
 * Includes the code which allows automatic defragmentation on delete and close,
 * separate allocation for FAST and NORMAL flash spaces, and prepare for write
 * functionality.
 *
 * Please note that this flag is automatically included if FS_MAX_FSOS is
 * defined. However, it can be included even if FS_MAX_FSOS is not defined in
 * order to use the flOpenMMFile() routine to access these features.
 */

/* #define FS_MM_PERFORMANCE_TUNEUPS */



/*
 * Enable the file-specific write-back cache
 * (as opposed to partition-wide write-through cache enabled by FL_EXTENDED_SECTOR_CACHE)
 *
 * Certain types of files will have dedicated write cache allocated
 * Size of the cache buffer is set in FSO database
 */

/* #define FS_SUPPORT_FILE_CACHE */



/* 12-bit FAT support
 *
 * Comment the following line if you do not need support for DOS media with
 * 12-bit FAT (typically media of 8 MBytes or less).
 */

#define FS_FAT_12BIT



/* Rename file
 *
 * Uncomment the following line if you need to rename files with
 * flRenameFile().
 */

/*#define FS_RENAME_FILE*/



/* Sub-directories
 *
 * Uncomment the following line if you need support for sub-directories
 * using the SureFS file system.
 */

/*#define FS_SUB_DIRECTORY*/

#endif /* FS_FILES > 0 */


/****************************************************************************/
/****************************************************************************/
/**                                                                        **/
/** O T H E R   F E A T U R E S   IN / OUT  -  C U S T O M I Z A T I O N S **/
/**                                                                        **/
/****************************************************************************/
/****************************************************************************/

/*
 * Remove all flash write functionalities from the source.
 *
 * When this option is selected, only API functions that do not involve write
 * operations to the media can be called.
 *
 * This option can be used to create read-only applications with low RAM/ROM
 * requirements.
 *
 * Note that BD write APIs may still be available.
 */

/* #define FS_READ_ONLY */



/* Places file system format.
 *
 * Includes the routine for placing the FAT file system format on
 * a specific logical partition.
 *
 * Please note that this routine calculates the optimal file system format
 * parameters for your specific flash device in terms of cluster size, and
 * FAT table location. These settings may have drastic impact on the device
 * performance.
 *
 * This compilation flag compiles the flFormatFS() routine.
 */

#define FS_FORMAT_VOLUME


/* Partitioning to logical partitions (writing MBR)
 *
 * This routine is necessary if your OS does not provide FDISK-like utility.
 *
 * Please note that in DiskOnChip devices it is preferred to use the BDTL
 * partitions mechanism, as it provides better security and better performance.
 *
 * This compilation flag compiles the flCreateLogicalPartitions() routine.
 */

#define FS_CREATE_LOGICAL_PARTITIONS



/* Reports the location of a specific logical partition.
 *
 * This API is only necessary if you want to use Abs Block I/O
 * (which addresses whole BDTL partition).
 * File access routine and Log Block I/O routines
 * address specific logical partitions automatically.
 *
 * This compilation flag compiles the flFindLogicalPartition() routine.
 */

#define FS_FIND_LOGICAL_PARTITION



/* Block device functionalities over a logical partition (Log Block I/O)
 *
 * This flag compiles a set of APIs that support sector access to a specific
 * logical partition. Those APIs export the sectors of that specific partition
 * as if they where the only sectors on the media.
 *
 * In other words, sector 0 will be mapped to sector 0 of that logical partition
 * regardless of the real sector it resides on.
 *
 * This API is useful for synchronization with a host PC as it allows the host
 * file system to manage a specific partition as a removable block device media.
 */

#define FS_ABS_READ_WRITE



/* Application exit.
 *
 * Selects whether or not the fsExit() function is to be included.
 *
 * If your application exits, that is, if it does not run indefinitely, call
 * the fsExit() routine before exiting from the application.
 */

#define FS_EXIT



/* Read while write (file sharing)
 *
 * Enables a file to be opened for read and write at the same time.
 *
 * This feature is required in order to support reading from a file that
 * is currently being downloaded and was not fully written yet.
 */

/* #define FS_FILE_SHARING_SUPPORT */



/* Split long IO requests.
 *
 * With this support, a long read or write request will not block other
 * threads.
 *
 * If FS_MAX_FSOS is defined, the size of sub-divided requests is regulated by
 * FSO type. If FS_MAX_FSOS is not defined, it is fixed to 16K.
 */

/* #define FL_LIMIT_UNINTERRUPTED_FILE_ACCESS */



/* File name parsing
 *
 * Uncomment the following line to enable your preferred file name interface.
 *
 * SureFS usually accepts file name as Unicode string format.
 * However it can also accept several other formats using the following
 * compilation flags:
 *
 * Use ASCII strings conversion :
 *     FL_LONG_FILENAMES_ASCII_SUPPORT
 * Your own customized conversions using the 2 macro's below :
 *     FL_TRANSLATE_FROM_UNICODE(String)
 *     FL_TRANSLATE_TO_UNICODE(String)
 * An example of a customized conversion for UTF8 standard :
 *     FL_LONG_FILENAMES_UTF8_SUPPORT
 *
 * The code for these routines is located in FLPARSE.C and ENC_UTF.C
 */

/* #define FL_LONG_FILENAMES_ASCII_SUPPORT   */
/* #define FL_LONG_FILENAMES_UTF8_SUPPORT    */
/* #define FL_TRANSLATE_FROM_UNICODE(String) */
/* #define FL_TRANSLATE_TO_UNICODE(String)   */

#endif /* FSCUSTOM_H */

