/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Testing/TrueFFS 6.3/Drop 2.5/3/common/geometry.c-arc  $
 *
 *    Rev 1.4   Aug 09 2006 16:52:52   Polina.Marimont
 * initial for DOC Driver 1.0
 */

#include "flbase.h"

/*----------------------------------------------------------------------*/
/*                   f l B u i l d G e o m e t r y                      */
/*                                                                      */
/* Get C/H/S information of the disk according to number of sectors.    */
/*                                                                      */
/* Parameters:                                                          */
/*  capacity    : Number of Sectors in Volume                           */
/*  cylinders   : Pointer to Number of Cylinders                        */
/*  heads       : Pointer to Number of Heads                            */
/*  sectors     : Pointer to Number of Sectors per Track                */
/*  oldFormat   : True for one sector per culoster                      */
/*  wIrHandle   : Handle of the disk partition to check                 */
/*                                                                      */
/*----------------------------------------------------------------------*/


TFFS_DLL_API void NAMING_CONVENTION flBuildGeometry(FLDword capacity, FLDword FAR2 *cylinders,
         FLDword FAR2 *heads, FLDword FAR2 *sectors, FLBoolean oldFormat, FLWord wIrHandle)
{
  FLDword temp;
  FLDword orgCapacity = capacity;

START_BUILD_GEOMETRY_ROUTINE:

  *cylinders = 1024;                 /* Set number of cylinders to max value */

  if (oldFormat == TRUE)
  {
    *sectors = 62L;                     /* Max out number of sectors per track */
    temp = (*cylinders) * (*sectors);   /* Compute divisor for heads           */
    (*heads) = capacity / temp;         /* Compute value for number of heads   */
    if (capacity % temp) {              /* If no remainder, done!              */
      (*heads)++;                       /* Else, increment number of heads     */
      temp = (*cylinders) * (*heads);   /* Compute divisor for sectors         */
      (*sectors) = capacity / temp;     /* Compute value for sectors per track */
      if (capacity % temp) {            /* If no remainder, done!              */
        (*sectors)++;                   /* Else, increment number of sectors   */
	temp = (*heads) * (*sectors);   /* Compute divisor for cylinders       */
        (*cylinders) = capacity / temp; /* Compute number of cylinders         */
      }
    }
  }
  else
  {
     *heads = 16L;                              /* Max out number of heads             */
     temp = (*cylinders) * (*heads);            /* Compute divisor for heads           */
     *sectors = capacity / temp;                /* Compute value for sectors per track */
     while (*sectors > 0x3f ){                  /* While number of sectors too big     */
       *heads *= 2;                             /* use one more head                   */
       temp = (*cylinders) * (*heads);          /* Recompute divisor for heads         */
       *sectors = capacity / temp;              /* Recompute sectors per track         */
     }
     if (capacity % temp) {                     /* If no remainder, done!              */
       (*sectors)++;                            /* Else, increment number of sectors   */
       temp = (*cylinders) * (*sectors);        /* Compute divisor for heads           */
       *heads = capacity / temp;                /* Compute value for heads             */
       if (capacity % temp) {                   /* If no remainder, done!              */
         (*heads)++;                            /* Else, increment number of heads     */
         temp = (*heads) * (*sectors);          /* Compute divisor for cylinders       */
         *cylinders = (FLDword)(capacity / temp); /* Compute number of cylinders         */
       }
     }
  }
  /* Make sure some free sectors are left between C*H*S and TL sectors */
  if(orgCapacity == (*sectors) * (*heads) * (*cylinders))
  {
	  capacity--;
	  goto START_BUILD_GEOMETRY_ROUTINE;
  }
}

/*----------------------------------------------------------------------*/
