/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************
**  COPYRIGHT Jan 22, 2007 Marvell Inernational Ltd.
**  All Rights Reserved
**
**  COPYRIGHT (C) 2006, Intel Corporation.
**
**  This software as well as the software described in it is furnished under
**  license and may only be used or copied in accordance with the terms of the
**  license. The information in this file is furnished for informational use
**  only, is subject to change without notice, and should not be construed as
**  a commitment by Intel Corporation. Intel Corporation assumes no
**  responsibility or liability for any errors or inaccuracies that may appear
**  in this document or any software that may be provided in association with
**  this document.
**  Except as permitted by such license, no part of this document may be
**  reproduced, stored in a retrieval system, or transmitted in any form or by
**  any means without the express written consent of Intel Corporation.
**
**  FILENAME:   msys.h
**  PURPOSE:   definitions and prototypes for mDOC devices
**
******************************************************************************/
#ifndef M_SYS_BOOT_H
#define M_SYS_BOOT_H

#include "xllp_defs.h"
#include "typedef.h"
#include "xllp_dfc.h"
#include "flstruct.h"
#include "tim.h"
#include "_common.h"

/**************************************************************************/
/* General types definitions                                              */
/**************************************************************************/
typedef enum M_SYS_BOOL_E
{
  M_SYS_FALSE = 0,
  M_SYS_TRUE  = 1
}Boolean, BOOL;

typedef unsigned int   size_t;

/**************************************************************************/
/* Memory window size and type                                            */
/**************************************************************************/
/*Type*/
#define MEM_WIN_8KB		0
#define MEM_WIN_128KB	1

/*Size*/
#define DOCH_MEM_WIN_SIZE_8KB            0x2000 /*8KB*/
#define DOCH_MEM_WIN_SIZE_128KB         0x20000	/*128KB*/

/*Register Areas*/
/*--------------*/

/*Core Address*/
//#define HIB_CORE_ADDRESS					(gHibCoreAddress)
#define HIB_CORE_ADDRESS_8KB				0x0000
#define HIB_CORE_ADDRESS_128KB				0x8000

//#define DOCH_CONT_REG_AREA_OFFSET			(gHibContRegAreaOffset)
//#define DOCH_DATA_PORT_AREA_OFFSET			(gHibDataPortAreaOffset)
//#define DOCH_CONFIG_REG_AREA_OFFSET			(gHibConfigRegAreaOffset)

/*8KB Offsets*/
#define DOCH_CONT_REG_AREA_8KB_OFFSET		0x0800
#define DOCH_DATA_PORT_AREA_8KB_OFFSET		0x1000
#define DOCH_CONFIG_REG_AREA_8KB_OFFSET		0x1400

/*128KB Offsets*/
#define DOCH_CONT_REG_AREA_128KB_OFFSET		          0
#define DOCH_DATA_PORT_AREA_128KB_OFFSET	     0x0800
#define DOCH_CONFIG_REG_AREA_128KB_OFFSET	     0x1400
#define DOCH_PRIMARY_SECONDARY_AREA_128KB_OFFSET 0x1800

/*Area Address*/
#define DOCH_CONT_REG_AREA          (HIB_CORE_ADDRESS + DOCH_CONT_REG_AREA_OFFSET)
#define DOCH_DATA_PORT_AREA         (HIB_CORE_ADDRESS + DOCH_DATA_PORT_AREA_OFFSET)
#define DOCH_CONFIG_REG_AREA        (HIB_CORE_ADDRESS + DOCH_CONFIG_REG_AREA_OFFSET)
#define DOCH_PRIMARY_SECONDARY_AREA (HIB_CORE_ADDRESS + DOCH_PRIMARY_SECONDARY_AREA_128KB_OFFSET)

/**************************************************************************/
/* Registers configuration                                                */
/**************************************************************************/
/*Specific per-register values*/
/*============================*/
/*Burst Read/Write Mode Control Register*/
#define HIB_BURST_HOLD_1_CLK        0x0000
#define HIB_BURST_HOLD_2_CLK        0x2000

#define HIB_BURST_LEN_4_CYC         0x0000
#define HIB_BURST_LEN_8_CYC         0x0800
#define HIB_BURST_LEN_16_CYC        0x1000
#define HIB_BURST_LEN_32_CYC        0x1800

#define HIB_BURST_DISABLE           0x0000
#define HIB_BURST_ENABLE            0x0001

/*Download Control Register*/
#define HIB_DOWNLOAD_COMPLETED      0x0000
#define HIB_DOWNLOAD_IN_PROCESS     0x0001

/*IPL Control Register*/
#define HIB_IPL_WRITE_DISABLE       0x0000
#define HIB_IPL_WRITE_ENABLE        0x0001

#define HIB_IPL_NOT_READY_FOR_WRITE 0x0000
#define HIB_IPL_READY_FOR_WRITE     0x0002

/*Warm Boot Register*/
#define HIB_WARM_RST_POLARITY_LOW   0x0000
#define HIB_WARM_RST_POLARITY_HIGH  0x0001

#define HIB_WARM_RST_BURST_ON       0x0000
#define HIB_WARM_RST_BURST_NO_CHNG  0x0002

/*Power Down Register*/
#define HIB_DPD_PIN_POLARITY_LOW    0x0000
#define HIB_DPD_PIN_POLARITY_LOW    0x0000

#define HIB_DPD_PIN_DISABLE         0x0000
#define HIB_DPD_PIN_ENABLE          0x0002

/*DMA Control Register*/
#define HIB_DMA_REQ_DISABLE         0x0000
#define HIB_DMA_REQ_ENABLE          0x0001

#define HIB_DMA_REQ_POL_HIGH        0x0000
#define HIB_DMA_REQ_POL_LOW         0x0002

#define HIB_DMA_REQ_LEVEL           0x0000
#define HIB_DMA_REQ_EDGE            0x0004

/*S/W Lock Register*/
#define HIB_SW_LOCK_ON              0x0001

/*Endian Control Register*/
#define HIB_END_SWAP_OFF            0x0000
#define HIB_END_SWAP_ON             0x0101

/*Operation Mode Register*/
#define HIB_NON_PIPE_ACCESS         0x00
#define HIB_PIPE_ACCESS             0x01

#define HIB_NO_ADDR_SHIFT           0x00
#define HIB_ADDR_SHIFT              0x02

/*Power Mode Register*/
#define HIB_POWER_DOWN              0x0001

/*Paged RAM Command Register*/
#define HIB_PAGED_RAM_ENABLE_SELECT 0x71

/*Paged RAM Select Register*/
#define HIB_PAGED_RAM_SEQ           0x0080


/*Folloing array is used to conserve every write to a configuration register.
The purpose is to enable reseting the device registers in case of power loss*/
typedef struct {
    FLWord wBurstWriteModeCtrl;
    FLWord wIPLCtrl;
    FLWord wPowerDown;
    FLWord wDMACtrl;
    FLWord wSWLock;
    FLWord wEndianCtrl;
    FLWord wEndianNegation;
    FLWord wOperationMode;
    FLWord wBurstReadModeCtrl;
} DOCH_ConfigRegsValue;

typedef struct {
    FLWord wBurstWriteModeCtrlSet;
    FLWord wIPLCtrlSet;
    FLWord wPowerDownSet;
    FLWord wDMACtrlSet;
    FLWord wSWLockSet;
    FLWord wEndianCtrlSet;
    FLWord wEndianNegationSet;
    FLWord wOperationModeSet;
    FLWord wBurstReadModeCtrlSet;
} DOCH_ConfigRegsSet;

/* Changing device memory window size (8/128 KB)*/
#define DOCH_PAGED_RAM_TIMEOUT      300000L
#define DOCH_READ_PAGED_RAM_DELAY   20

typedef enum {
    DOCH_MEM_WIN_SIZE_8K            = 0,
    DOCH_MEM_WIN_SIZE_128K          = 1,    /*Regular, with no pull-downs on high address bits*/
    DOCH_MEM_WIN_SIZE_128K_SPECIAL  = 2     /*Special, with pull-downs on high address bits*/
} DOCH_MemWinSize;

/* Host Configuration register offstes - offset is from DOCH_CONFIG_REG_AREA*/
/*--------------------------------------------------------------------------*/
#if 0
#define HIB_CHIPID1_REG                 (DOCH_CONFIG_REG_AREA)
#define HIB_BURST_WRITE_MODE_CTRL_REG   (DOCH_CONFIG_REG_AREA + 0x02)
#define HIB_BURST_WRITE_MODE_EXIT_REG   (DOCH_CONFIG_REG_AREA + 0x04)
#define HIB_DOWNLOAD_CONTROL_REG        (DOCH_CONFIG_REG_AREA + 0x06)
#define HIB_IPL_CONTROL_REG             (DOCH_CONFIG_REG_AREA + 0x08)
#define HIB_WARM_BOOT_REG               (DOCH_CONFIG_REG_AREA + 0x0A)
#define HIB_POWER_DOWN_REG              (DOCH_CONFIG_REG_AREA + 0x0C)
#define HIB_DMA_CTRL_REG                (DOCH_CONFIG_REG_AREA + 0x0E)
#define HIB_SW_LOCK_REG                 (DOCH_CONFIG_REG_AREA + 0x10)
#define HIB_ENDIAN_CTRL_REG             (DOCH_CONFIG_REG_AREA + 0x12)
#define HIB_OPERATION_MODE_REG          (DOCH_CONFIG_REG_AREA + 0x14)
#define HIB_POWER_MODE_REG              (DOCH_CONFIG_REG_AREA + 0x16)
#define HIB_DMA_NEGATION_REG            (DOCH_CONFIG_REG_AREA + 0x18)
#define HIB_VERSION_REG                 (DOCH_CONFIG_REG_AREA + 0x1A)
#define HIB_CHIPID2_REG                 (DOCH_CONFIG_REG_AREA + 0x22)
#define HIB_BURST_READ_MODE_CTRL_REG    (DOCH_CONFIG_REG_AREA + 0x24)
#endif

//------------------------------------------
//Register offsets into Control register set
//------------------------------------------
#define HIB_CHIPID1_REG                   0x0
#define HIB_BURST_WRITE_MODE_CTRL_REG     0x1
#define HIB_BURST_WRITE_MODE_EXIT_REG     0x2
#define HIB_DOWNLOAD_CONTROL_REG          0x3
#define HIB_IPL_CONTROL_REG               0x4
#define HIB_WARM_BOOT_REG                 0x5
#define HIB_POWER_DOWN_REG                0x6
#define HIB_DMA_CTRL_REG                  0x7
#define HIB_SW_LOCK_REG                   0x8
#define HIB_ENDIAN_CTRL_REG               0x9
#define HIB_OPERATION_MODE_REG            0xA
#define HIB_POWER_MODE_REG                0xB
#define HIB_DMA_NEGATION_REG              0xC
#define HIB_VERSION_REG                   0xD
#define HIB_CHIPID2_REG                  0x11
#define HIB_BURST_READ_MODE_CTRL_REG     0x12


typedef struct MDOC_CONFIG_REG_S
{
   VUINT16_T CHIPID1_REG;
   VUINT16_T BURST_WRITE_REG;
   VUINT16_T BURST_MODE_EXIT_REG;
   VUINT16_T DOWNLOAD_CONTROL_REG;
   VUINT16_T IPL_CONTROL_REG;
   VUINT16_T WARM_BOOT_REG;
   VUINT16_T POWER_DOWN_REG;
   VUINT16_T DMA_CONTROL_REG;
   VUINT16_T SOFTWARE_LOCK_REG;
   VUINT16_T ENDIAN_CONTROL_REG;
   VUINT16_T OPERATION_MODE_REG;
   VUINT16_T POWER_MODE_REG;
   VUINT16_T DMA_NEGATE_REG;
   VUINT16_T VERSION_REG;
   VUINT16_T reserved[3];
   VUINT16_T CHIPID2_REG;
   VUINT16_T BURST_READ_REG;
} MDOC_CONFIG_REG_T, *P_MDOC_CONFIG_REG_T;



/* bits in DOCH_STATUS_REG and DOCH_ALT_STATUS_REG registers */
#define DOCH_ERROR      0x01
#define DOCH_DRQ        0x08
#define DOCH_DSC        0x10
#define DOCH_READY      0x40
#define DOCH_BUSY       0x80

/*Operation Mode Register*/
#define HIB_NON_PIPE_ACCESS   0x00
#define HIB_ADDR_SHIFT        0x02

/* Devices' chip ID's */
#define DOCH_CHIP_ID	0x4833

/**************************************************************************/
/* DOCH error codes                                               		  */
/**************************************************************************/
#define DOCH_ATA_ERROR_BASE 0x0
#define DOCH_SDK_ERROR_BASE 0x100
#define DOCH_FS_ERROR_BASE  0x200

typedef enum
{

   DOCH_OK                               = 0,

   /*ATA Error codes*/
   //===========================================================================================
   DOCH_ATA_NO_ERROR                     = DOCH_ATA_ERROR_BASE + 0x00,
   DOCH_ATA_ERROR_MEDIA_ERROR_DETECTED   = DOCH_ATA_ERROR_BASE + 0x01,  /*ATA-4*/
   DOCH_ATA_ERROR_ADDRESS_MARK_NOT_FOUND = DOCH_ATA_ERROR_BASE + 0x01,  /*Repeat last operation*/
   DOCH_ATA_ERROR_TRACK_0_NOT_FOUND      = DOCH_ATA_ERROR_BASE + 0x02,  /*Protection violation*/
   DOCH_ATA_ERROR_NO_MEDIA               = DOCH_ATA_ERROR_BASE + 0x02,  /*ATA-4*/
   DOCH_ATA_ERROR_ABORT                  = DOCH_ATA_ERROR_BASE + 0x04,  /*Always need to be supplied*/
   DOCH_ATA_ERROR_MEDIA_CHANGE_REQUESTED = DOCH_ATA_ERROR_BASE + 0x08,  /*Not to use for now*/
   DOCH_ATA_ERROR_ID_NOT_FOUND           = DOCH_ATA_ERROR_BASE + 0x10,  /*Passing partition boundary*/
   DOCH_ATA_ERROR_MEDIA_CHANGE_DETECTED  = DOCH_ATA_ERROR_BASE + 0x20,  /*Not to use for now*/
   DOCH_ATA_ERROR_WRITE_PROTECTED        = DOCH_ATA_ERROR_BASE + 0x40,  /*on writes - only if we run out of space*/
   DOCH_ATA_ERROR_UNCORRECTABLE_DATA     = DOCH_ATA_ERROR_BASE + 0x40,  /*on reads - possible for unrecoverable ECC - should not be returned by write routines*/
   DOCH_ATA_ERROR_ICRC                   = DOCH_ATA_ERROR_BASE + 0x80,  /*on DMA xfers - leave for now*/

   /*SDK Error Codes*/
   //=============================================================================================
   DOCH_TimedOut                         = DOCH_SDK_ERROR_BASE,
   DOCH_GeneralFailure                   = DOCH_SDK_ERROR_BASE + 5,
   DOCH_AdapterNotFound                  = DOCH_SDK_ERROR_BASE + 6,
   DOCH_DeviceTurnedOff                  = DOCH_SDK_ERROR_BASE + 7,
   DOCH_BadParameter                     = DOCH_SDK_ERROR_BASE + 10,
   DOCH_DriveNotAvailable                = DOCH_SDK_ERROR_BASE + 15,
   DOCH_DriveNotReady                    = DOCH_SDK_ERROR_BASE + 20,
   DOCH_NotEnoughMemory                  = DOCH_SDK_ERROR_BASE + 25,
   DOCH_ReadFault                        = DOCH_SDK_ERROR_BASE + 30,
   DOCH_WriteFault                       = DOCH_SDK_ERROR_BASE + 31,
   DOCH_VerifyFault                      = DOCH_SDK_ERROR_BASE + 32,
   DOCH_ProtectionFault                  = DOCH_SDK_ERROR_BASE + 33,
   DOCH_UnknownCmd                       = DOCH_SDK_ERROR_BASE + 35,
   DOCH_DiskNotFound                     = DOCH_SDK_ERROR_BASE + 40,
   DOCH_PartitionNotFound                = DOCH_SDK_ERROR_BASE + 45,
   DOCH_PartitionLimitExceeded           = DOCH_SDK_ERROR_BASE + 50,
   DOCH_FeatureNotSupported              = DOCH_SDK_ERROR_BASE + 55,
   DOCH_ATABusyNotCleared                = DOCH_SDK_ERROR_BASE + 60,
   DOCH_ATANotReady                      = DOCH_SDK_ERROR_BASE + 61,
   DOCH_ATAErrorDetected                 = DOCH_SDK_ERROR_BASE + 65
}DOCH_Error;

/* set of DOCH ATA register offsets */
typedef enum
{
    DOCH_DATA_REG          = 0x00,
    DOCH_ERROR_REG         = 0x01,
    DOCH_FEATURES_REG      = 0x01,
    DOCH_SECTOR_CNT_REG    = 0x02,
    DOCH_SECTOR_NO_REG     = 0x03,
    DOCH_CYLINDER_LOW_REG  = 0x04,
    DOCH_CYLINDER_HIGH_REG = 0x05,
    DOCH_DRIVE_HEAD_REG    = 0x06,
    DOCH_STATUS_REG        = 0x07,
    DOCH_COMMAND_REG       = 0x07,
    DOCH_ALT_STATUS_REG    = 0x0E,
    DOCH_CONTROL_REG	   = 0x0E
} DOCH_Reg;


typedef struct MDOC_ATA_REG_S
{
   VUINT16_T  DATA_REG;                 // byte offset 0
   VUINT16_T  ERROR_FEATURES_REG;       // byte offset 2
   VUINT16_T  SECTOR_COUNT_REG;         //
   VUINT16_T  SECTOR_OFFSET_REG;
   VUINT16_T  CYLINDER_LOW_REG;
   VUINT16_T  CYLINDER_HIGH_REG;
   VUINT16_T  DRIVE_HEAD_REG;
   VUINT16_T  COMMAND_STATUS_REG;
   VUINT16_T  reserved[6];
   VUINT16_T  ALT_CONTROL_STATUS_REG;
} MDOC_ATA_REG_T, *P_MDOC_ATA_REG_T;



/**************************************************************************/
/* ATA support                                               		      */
/**************************************************************************/
/* set of DOCH Vendor-Specific ATA Commands */
typedef enum
{
  /*I/O*/
  DOCH_VSCMD_READ_PARTITION             = 0x82,
  DOCH_VSCMD_WRITE_PARTITION            = 0x83,
  DOCH_VSCMD_WRITE_FLEXI                = 0x84,

  /*Sectors Operations*/
  DOCH_VSCMD_OPTIMIZE_PARTITION_SECTORS = 0x86,
  DOCH_VSCMD_ERASE_PARTITION_SECTORS    = 0x88,

  /*Hash*/
  DOCH_VSCMD_READ_CALCULATED_HASH       = 0x8A,
  DOCH_VSCMD_WRITE_CALCULATED_HASH      = 0x8B,
  DOCH_VSCMD_READ_ORIGINAL_HASH         = 0x8C,
  DOCH_VSCMD_WRITE_GIVEN_HASH           = 0x8D,

  /*Sub-commanded commands*/
  DOCH_VSCMD_PARTITION_MANAGEMENT       = 0xFA,
  DOCH_VSCMD_ACCESS_CONTROL             = 0xFB,
  DOCH_VSCMD_EXT_DEVICE_CTRL            = 0xFC,
  DOCH_VSCMD_EXT_SECURITY_CTRL          = 0xFD,

  /*Supported standard ATA commands*/
  DOCH_CMD_READ_SECTORS                 = 0x20,
  DOCH_CMD_IDENTIFY_DEV                 = 0xEC,
  DOCH_DOWNLOAD_MICROCODE               = 0x92

} DOCH_Command;

/* Size of DOCH data block in FLBytes */
#define DOCH_SECTOR_SIZE		512
#define	DOCH_SECTOR_SIZE_BITS	9

/* maximum number of sectors which could be read from / written to DOCH at once */
#define DOCH_MAX_SECTORS  256

/* Optional bits in DOCH_DRIVE_HEAD_REG	*/
/* Bits for DOCH_DRIVE_HEAD_REG register */
#define DOCH_DEVICE     0x10
#define DOCH_LBA        0x40
#define DOCH_DRIVE_HEAD 0xA0

#define DRIVE_HEAD_OPT1 0x80
#define DRIVE_HEAD_OPT2 0x20

/**************************************************************************/
/* Access layer                                              		      */
/**************************************************************************/
#if 0
//#define DOCHWRITE_ATA_REG(base, regNum, val) \
//		 FLWRITE_IO_WORD((FLWord)val,((( FLWord *)base) + regNum + (DOCH_CONT_REG_AREA>>1)))
//#define DOCHWRITE_CTRL_REG(base, regNum, val) \
//          FLWRITE_IO_WORD((FLWord)val, (base + regNum))

//#define DOCHREAD_CTRL_REG(base, regNum)   \
//          FLREAD_IO_WORD(base + regNum)
#endif

//
// THE Msys DOC can have a max of 15 partitions, hence 4 bits for partition number
// we encode the sector offset and partition number into a single 32 bit item
//---------------------------------------------------------------------------------
#define MDOC_PARTITION_MASK ((UINT32_T) 0x0000000F)  /* low order 4 bits */
#define MDOC_PARTITION_SHIFT 0
#define MDOC_SECTOR_MASK ((UINT32_T)0xFFFFFFF0)      /* high order 28 bits */
#define MDOC_SECTOR_SHIFT 4

// We put these externs here so that mDOC SDK source files using the
// macros in msys_custom.h do not need to declare them, leaving things
// less "glued"
//-------------------------------------------------------------------
extern P_MDOC_ATA_REG_T    pMdocAtaReg;
extern P_MDOC_CONFIG_REG_T pMdocCfgReg;

/*****************************************************************************
*   Secure boot API functions prototypes
******************************************************************************/
void ChipSelectMsys(void);
Boolean mDOC_Initialize(void);
Boolean mDOC_ReadSectors (unsigned int  SectorOffset,
                           unsigned int  NumBytesToCopy,
                            unsigned char *TargetBuffer,
                             unsigned char partitionNum );
UINT_T mDOC_GetTIM( UINT8_T *Addr, UINT_T max_size );
UINT_T mDOC_GetImage( UINT8_T *pTargetAddress, UINT_T sectorOffset,
                      UINT_T   byteCount,      UINT8_T partition );
UINT_T mDOCDrvComputeSectorCount( UINT_T byteCount );
Boolean mDOC_WriteSectors( unsigned int sectorOffset,
                           unsigned int numBytesToWrite,
                            unsigned char *pSourceAddress,
                             unsigned char partition );
UINT_T mDOC_WriteImage( UINT8_T *pSourceAddress, UINT_T sectorOffset,
                        UINT_T byteCount,        UINT8_T partition );
UINT_T mDOC_Unformat( void );
FormatParams3 *mDOC_GetFormatData( void );
FormatParams3 *mDOC_GetFormatDataFromTim( pTIM pTIM_h);
UINT_T mDOC_Format( FormatParams3 *pFormatData );
UINT_T mDOC_WriteOTPArea( void *pSrcData, UINT_T byteCount );
UINT_T mDOC_ReadOtp( UINT8_T *pTargetBuffer, UINT_T otpAddress, UINT_T byteCount );
#endif /* BOOT_H */


