/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/


#ifndef BOOT_CUSTOM_H
#define BOOT_CUSTOM_H

/**************************************************************************/
/* mDOC device physical address window location                           */
/**************************************************************************/
#define MDOC_START_ADDRESS	0x10000000   /* Used for P2Sample platform */

/**************************************************************************/
/* ATA timeout's support                                               	  */
/**************************************************************************/

/* 'long'  DOCH operations can take up to DOCH_LONG_WAIT milliseconds  */
#define DOCH_LONG_WAIT   500
/* 'short' DOCH operations can take up to DOCH_SHORT_WAIT milliseconds */
#define DOCH_SHORT_WAIT  450

/*
 * Length of DOCH register 'read' cycle in nanoseconds (default value should
 * do for most systems).
 */
#define DOCH_ACCESS_NANOSEC  15

/**************************************************************************/
/* Access layer                                              		      */
/**************************************************************************/

//#define FLREAD_IO_WORD(address) (*((volatile FLWord *)(address)))
//#define FLWRITE_IO_WORD(val,address) ((*((volatile FLWord *)(address))) = (FLWord)(val))
//#define DOCHBLK_READ(address, buf, sectors) hal_blk_read_nor(address, buf, sectors)

/*===========================*/
/* Access Layer Customization*/
/* --------------------------*/
/* 2 Sections:               */
/*  - Run-Time               */
/*  - Compile Time           */
/*===========================*/
#ifdef DOCH_BIG_ENDIAN
  #define C_16_8(a) ((FLByte)((a)>>8))
  #define C_8_16(a) (((FLWord)(a))<<8)
  #define C_16_16(a) ((FLWord)((a)<<8) | ((a)>>8))
#else
  #define C_16_8(a) ((FLByte)(a))
  #define C_8_16(a) ((FLWord)(a))
  #define C_16_16(a) ((FLWord)(a))
#endif /* DOCH_BIG_ENDIAN */


FLSNative hal_blk_read_nor( FLByte *pDest, FLSNative sectors );
FLSNative hal_blk_write_nor( FLByte *pSrc, FLSNative numSectors );

#define DOCHREAD_ATA_REG(base, regNum)         C_16_8( *(((PVUINT16)pMdocAtaReg) + regNum) )
#define DOCHWRITE_ATA_REG(base, regNum, val)   (*(((PVUINT16)pMdocAtaReg) + regNum) =  C_8_16(val))
#define DOCHREAD_CTRL_REG(base, regNum)        C_16_16(*(((PVUINT16)pMdocCfgReg) + regNum))
#define DOCHWRITE_CTRL_REG(base, regNum, val)  (*(((PVUINT16)pMdocCfgReg) + regNum) = C_16_16(val))
#define DOCHBLK_READ_MDOC( buf, sectors)       hal_blk_read_nor( buf, sectors)
#define DOCHBLK_WRITE_MDOC( buf, sectors )     hal_blk_write_nor( buf, sectors)
#define DOCHBLK_READ( address, buf, sectors )  hal_blk_read_nor( buf, sectors)
#define DOCHBLK_WRITE( address, buf, sectors ) hal_blk_write_nor( buf, sectors)

/**************************************************************************/
/* Debug printing                                             		      */
/**************************************************************************/

#define M_SYS_DEBUG_PRINT_ON 0

#ifndef DBG_PRINT_FLOW
#define DBG_PRINT_FLOW(zone,str)    /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
#endif


#ifndef DBG_PRINT_ERR
  #if M_SYS_DEBUG_PRINT_ON
    #define DBG_PRINT_ERR(zone,str) mSysDebug( zone, str ) /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
  #else
    #define DBG_PRINT_ERR(zone,str)
#endif
#endif

#ifndef DBG_PRINT_WRN
#define DBG_PRINT_WRN(zone,str)     /* if (zone & (ACTIVE_DEBUG_ZONE)) printf (str) */
#endif
#ifndef DBG_PRINT_ERR_PRM
#define DBG_PRINT_ERR_PRM(zone,str)  /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#endif
#ifndef DBG_PRINT_WRN_PRM
#define DBG_PRINT_WRN_PRM(zone,str)  /* if (zone & (ACTIVE_DEBUG_ZONE)) printf str */
#endif

/* Zones for debug printing */

#define FLZONE_ATA        0x2000
#define FLZONE_API        0x4000
#define FLZONE_FULL       0xffff

void mSysDebug( unsigned int zone, char *msg );

#endif /* BOOT_CUSTOM_H */


