/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
**
**  COPYRIGHT (C) 2006, Intel Corporation.
**
**  This software as well as the software described in it is furnished under
**  license and may only be used or copied in accordance with the terms of the
**  license. The information in this file is furnished for informational use
**  only, is subject to change without notice, and should not be construed as
**  a commitment by Intel Corporation. Intel Corporation assumes no
**  responsibility or liability for any errors or inaccuracies that may appear
**  in this document or any software that may be provided in association with
**  this document.
**  Except as permitted by such license, no part of this document may be
**  reproduced, stored in a retrieval system, or transmitted in any form or by
**  any means without the express written consent of Intel Corporation.
**
**  FILENAME:	MSYS_DKB_INTERFACE.c
**
**  PURPOSE: 	Interface layer between bootrom/DKB/OBM and m-sys DOC devices
**
******************************************************************************/

/* additional interfaces to mDOC SDK for DKB
   These are compiled seperately so definition
   clashes do not occur between the OBM & BOOTROM
   code for read access to the mDOC H3 device     */


#include "typedef.h"
#include "errors.h"
#include "misc.h"
#include "msys.h"
#include "msys_custom.h"
#include "protocolmanager.h"

// INCLUDES FOR mDOC SDK INTERFACE FOR DKB
//========================================
#include "_common.h"
#include "_dochapi.h"
#include "flstruct.h"
#include "blockdev.h"   // This file has the mDOC SDK API, look in it to find API functions
#include "tffs_api.h"

#define MONAHANS_MDOC_SOCKET_NUMBER 0 /* Socket number always == 0 */


extern FLStatus TFFSOTPWriteAndLock(IOreq *ioreq);

//================== DKB INTERFACE FUNCS ======================================
//================== DKB INTERFACE FUNCS ======================================
//================== DKB INTERFACE FUNCS ======================================

// Add new interface funcs to mDOC SDK API in this file

/*=============================================================================
  mDOC_Unformat

  Returns the mDOC device to factory virgin state provided
  there are no protected/locked sectors, and the OTP area
  was not previously written to

==============================================================================*/
UINT_T mDOC_Unformat( void )
{
  IOreq localIoReq;

  AddMessageError(PlatformBusy);
  memset(&localIoReq, 0, sizeof( IOreq));

  // set-up the io request packet
  //-----------------------------
  localIoReq.irHandle = MONAHANS_MDOC_SOCKET_NUMBER;

  // send off the request
  //--------------------
  if( flUnformat( &localIoReq ) != 0 )
  {
    AddMessageError(PlatformReady);
    return MDOCFormatFailed;
  }

  AddMessageError(PlatformReady);
  return NoError;
}

/*=============================================================================
  mDOC_Format

  Formats the mDOC device provided there are no protected/locked
  sectors, and the OTP area was not previously written to

==============================================================================*/
UINT_T mDOC_Format( FormatParams3 *pFormatData )
{
  IOreq localIoReq;

  AddMessageError(PlatformBusy);
  memset(&localIoReq, 0, sizeof( IOreq));

  // set-up the io request packet
  //-----------------------------
  localIoReq.irHandle = MONAHANS_MDOC_SOCKET_NUMBER;
  localIoReq.irFlags  = TL_NORMAL_FORMAT;
  localIoReq.irData   = (void *)pFormatData;
  localIoReq.irLength = 0;

  //Send off the request
  //--------------------
  if( flFlashFormat( &localIoReq ) != 0 )
  {
    AddMessageError(PlatformReady);
    return MDOCFormatFailed;
  }

  AddMessageError(PlatformReady);
  return NoError;
}

/*=============================================================================
  mDOC_WriteOTPArea

  Writes to the mDoc OTP area, provided the area has not been locked/written
  to and the device is formatted.

==============================================================================*/
UINT_T mDOC_WriteOTPArea( void *pOtpData, UINT_T numBytes )
{

  IOreq localIoReq;

  if( numBytes == 0 )
    return WriteError;

  memset(&localIoReq, 0, sizeof( IOreq));
  localIoReq.irHandle = MONAHANS_MDOC_SOCKET_NUMBER;
  flOTPSize(&localIoReq);

  // See if we have room in the OTP area for the requested
  // write size
  //------------------------------------------------------
  if( (localIoReq.irCount - localIoReq.irLength) < numBytes )
    return WriteError;

  // round up to sector size -> mDOC SDK API
  // only writes in multiples of sector size
  //----------------------------------------
  numBytes += (numBytes % DOCH_SECTOR_SIZE);

  // set-up the io request packet
  //-----------------------------
  localIoReq.irHandle = MONAHANS_MDOC_SOCKET_NUMBER;
  localIoReq.irData   = (void *)pOtpData;
  localIoReq.irLength = numBytes;

  //Send off the request
  //-----------------------------------------------
  if( flOTPWriteAndLock( &localIoReq ) != 0 )
    return WriteError;

  return NoError;
}
