/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/

/***********************************************************************************/
/*																				   */
/*	This file contains various structure and defines concerning Partition info and */
/*	access																		   */
/*																				   */
/***********************************************************************************/

/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/part_inf.h-arc  $
 *
 *    Rev 1.17   Aug 09 2006 17:26:58   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.16.1.0   Aug 08 2006 15:55:32   Polina.Marimont
 * DOC Driver 1.0 initial
 *
 *    Rev 1.16   May 28 2006 13:02:34   polina.marimont
 * 1. IDENTIFY DEVICE interface update
 * 2. floors fix for format, where partition ended at the end of floor 0
 *
 *    Rev 1.15   May 18 2006 14:41:24   polina.marimont
 * v1.40Fin1, PVCS log inside
 */

#ifndef _PARTITION_INFO_H
#define _PARTITION_INFO_H

#include "doch_api.h"

/* Extended device info structure*/
typedef struct {
	FLWord	wFlashType;
	FLWord	wPhysicalPageSize;		/*In Sectors*/
	FLWord	wNumOfPhysicalPagesInPhysicalErasableBlockSize;
	FLWord	wNumOfErasableBlocksPerPhysicalChip;
	FLWord	wPhysicalChipBusWidth;	/*8/16*/
	FLWord	wNumOfChipsOnDataBus;	/*1..2*/
	FLWord	wFlashChipNumOfPlanes;	/*1..4*/
	FLWord	wFlashChipNumOfBanks;	/*Independently accessible parts of flash array*/
	FLWord	wLogicalPageSize;		/*In Sectors*/
	FLWord	wNumOfLogicalPagesInLogicalErasableBlockSize;
	FLWord	wTotalNumOfLogicalErasableUnits;
	FLWord	wMapinfoUnitsUsed;
	FLWord	wLUNCurrentlyUsed;
	FLWord	wFreeUnitsOnMedia;
	FLByte  bReserved1[0x1E4];
} DOCH_ExtendedDeviceInfo;

/*Partition user attributes
512Byte overall (1 sector)
First DOCH_PART_INFO_SDK_RESERVED_BYTES bytes are reserved for SDK*/
#define DOCH_PART_INFO_SDK_RESERVED_BYTES	0x40
typedef struct {
	FLByte	bReserved1[DOCH_PART_INFO_SDK_RESERVED_BYTES];						/*For SDK use*/
	FLByte  bReserved2[DOCH_SECTOR_SIZE - DOCH_PART_INFO_SDK_RESERVED_BYTES];	/*For application use*/
} DOCH_PartitionUserAttr;

/*Device user attributes
512Byte overall (1 sector)
First DOCH_DEVICE_INFO_SDK_RESERVED_BYTES bytes are reserved for SDK*/
#define DOCH_DEVICE_INFO_SDK_RESERVED_BYTES	0x40

typedef struct {
	FLByte  bLastDev0PartSpanned;
	FLByte  numOfSpannedPartitionOnDev0;
	FLByte  secondFloorActive;		/*At least 1 user partition resides on Dev1*/
	FLByte  bLastPartitionOnDev0;	/*Number of last partition that resides on Dev0*/
	FLDword dwSpanSector;			/*Which sector in the spanned partition is the last that resides on dev0*/
	FLDword dwSpanSizeOnDev0;		/*How many sectors on Dev0*/
	FLByte  spare[4];
} DOCH_PartitionSpanData;

typedef struct {
	DOCH_PartitionSpanData sSpanInfo;
	FLByte  spare[0x30];		/*Rest of 0x40 bytes that are resrved for SDK use*/
} DOCH_SDKDeviceAttr;

typedef struct {
	DOCH_SDKDeviceAttr sdkAttributes;
	FLByte  bReserved2[DOCH_SECTOR_SIZE - DOCH_DEVICE_INFO_SDK_RESERVED_BYTES];			/*For application use*/
} DOCH_DeviceUserAttr;


/******************************************************************************/
/*
 * Configuration Partition structure, sub-structures and ENUMS
 */
/******************************************************************************/

/*Configuration Partition Layout*/

/*Sector #0*/
typedef struct {
	FLWord		wVersion;
	FLWord		wCompatabilityVersion;
	FLDword		dwCommandFlagsOrStatuses;
	FLDword		dwDiskAttributes1;
	FLDword		dwGateKeeperAttr;	/*FLDword dwDiskAttributes2;*/
	FLByte		bReserved2[0x10];
	FLByte		bUniqueID[0x10];
	FLByte		bReserved3[0x10];
	FLByte		bSerialNumber[0x14];
	FLByte		bModelNumber[0x28];
	FLByte		breserved4[2];
	FLWord		wDefaultPartitionNumber;
	FLDword		dwUnformattedCapacity;	/*In Sectors*/
	FLDword		dwConfigurationPartitionExistsSign;
	FLDword		dwETFFSVER;
	FLDword		dwConfigPartitionSize;	/*In Bytes*/
	FLByte		bProgrammerName[0x10];
	FLByte		bProgrammerVersion[0x8];
	FLByte		bReserved6[0x58];
	FLByte		bGateKeeperKey[0x80];
	FLByte		bGateKeeperKeyReservedLargerKey[0x80];
} DOCH_ConfigPartitionSector0;

/*Sector #1*/
typedef enum {
	DOCH_MP_AUTH_TYPE_NONE = 0,	/*No master password*/
	DOCH_MP_AUTH_TYPE_PWD  = 1,	/*Password protection (Null terminated)*/
	DOCH_MP_AUTH_TYPE_RSA  = 2	/*RSA Protection (All 128Bytes are significant*/
} DOCH_MasterPwdAuthType;

typedef enum {
	DOCH_MAO_MASTER_PWD_AUTH_TYPE	= 0
} DOCH_MasterAttributes_Offset;

typedef enum {
	DOCH_MAB_MASTER_PWD_AUTH_TYPE	= 0x0000003F
} DOCH_MasterAttributes_Bits;

typedef struct {
	FLByte						bReserved1[0xC];
	FLDword						masterAttributes;
	FLByte						bReserved2[0xF0];
	FLByte						bMasterPasskey[0x80];
	FLByte						bReservedLargeMasterPasskey[0x80];
} DOCH_ConfigPartitionSector1;

/*Sector #2*/
typedef struct {
	FLByte		bDochPublicKey[0x80];
	FLByte		bReserved1[0x80];
	FLByte		bDochPrivateKey[0x80];
	FLByte		bReserved2[0x80];
} DOCH_ConfigPartitionSector2;

/*Sector #3*/
/*Identical to DOCH_DriveParameters structure (ATA IDENTIFY_DEVICE structure)*/

/*Sectors #4..#14 are reserved*/

/*Sector #15 - OTP sector for tester*/
typedef struct {
	FLByte		bUniqueID[0x10];
	FLByte		bReserved1[0x10];
	FLByte		bSerialNumber[0x14];
	FLByte		bModelNumber[0x28];
	FLByte		bReserved2[0x1A4];
} DOCH_ConfigPartitionSector15;


#endif	/*_PARTITION_INFO_H*/
