/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/tffs_api.c-arc  $
 *
 *    Rev 1.67   Aug 09 2006 17:27:40   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.66   Aug 09 2006 17:20:28   Polina.Marimont
 * initial for DOC Driver 1.0, DPD fixes from branch  1.64... applied
 *
 *    Rev 1.63   Jul 03 2006 22:13:56   polina.marimont
 * 1. bug fix - protection with leave failed to format
 * 2. bug fix - flags returned by identifyProtection on OTW protected partition
 *
 *    Rev 1.62   Jun 28 2006 11:34:56   Polina.Marimont
 * bug fix - TFFSGetUniqueID() shoudl be enabled / disabled by HW_OTP flag and not by FL_EXTENDED_DISK_INFO
 *
 *    Rev 1.61   Jun 28 2006 10:36:00   Polina.Marimont
 * bug fix - writeIPL() on non-first data chunk caused to wrong data to be written
 *
 *    Rev 1.60   Jun 27 2006 15:53:26   Polina.Marimont
 * bug fix flVolumeInfo() API return base address
 *
 *    Rev 1.59   Jun 26 2006 11:05:22   Polina.Marimont
 * added include to hib.h file
 *
 *    Rev 1.58   Jun 22 2006 17:55:38   Polina.Marimont
 * compilation warnings fixes
 *
 *    Rev 1.57   Jun 22 2006 13:18:40   Polina.Marimont
 * updated comments
 *
 *    Rev 1.56   Jun 22 2006 09:36:46   Polina.Marimont
 * error codes compatibility for extendedDiskInfo()
 *
 *    Rev 1.55   Jun 22 2006 09:06:06   Polina.Marimont
 * TFFSRemoveProtectionKey() error code compatibily fix
 *
 *    Rev 1.54   Jun 21 2006 18:25:42   Polina.Marimont
 * 1. enter/exit DPD function fix
 * 2. change protection to OTW updated
 * 3. identify prrotection updated
 *
 *    Rev 1.53   Jun 20 2006 12:40:28   Polina.Marimont
 * error codes for insert key and authenticate partition fixed to be compatible to non mDOC h3 devices
 *
 *    Rev 1.52   Jun 18 2006 13:09:00   Polina.Marimont
 * 1. error codes changed to be compatible to non mDOC H3 devices
 * 2. macros definition usage update
 * 3. AutoDPD and DPD parameters set changed, storage moved to SA SDK
 *
 *    Rev 1.51   Jun 14 2006 17:59:48   Polina.Marimont
 * 1. structure definitions moved to header file
 * 2. special function added for set IOreq structure parameters
 * 3. printing fixes
 * 4. bug fix - flash lifetime indication fix
 * 5. bug fix - number of volume on unformatted device (returns 1)
 * 6. check BDTL size should not be equal to 0, while formatting
 * 7. unformat - remove all, including OTP and IPL partitions from the device
 * 8. wipe sectors usage restored
 * 9. bdkWriteInit() added check for requested size exceeded subpartition size
 * 10. bug fix - used unit on BDK subparition rounded to the low boundary
 * 11. When EDGE interrupt configured - print warning and configure to LEVEL interrupt.
 *
 *    Rev 1.50   May 31 2006 15:41:44   polina.marimont
 * TrueFFS 7.1.0 EQA16
 *
 *    Rev 1.49   May 28 2006 14:50:30   polina.marimont
 * fix for IDENTIFY DEVICE
 *
 *    Rev 1.48   May 28 2006 13:03:10   polina.marimont
 * update for IDENTIFY DEVICE change
 *
 *    Rev 1.47   May 24 2006 14:57:26   polina.marimont
 * bugfix - erase BDK subpartition always erases first unit of subpartition 0
 *
 *    Rev 1.46   May 24 2006 08:17:06   polina.marimont
 * dochVol.intermediateBuf - free added to tffsApiExit() function
 *
 *    Rev 1.45   May 24 2006 08:13:30   polina.marimont
 * TFFSbdkPartitionInfo() - wrong handle received from ioreq.
 *
 *    Rev 1.44   May 21 2006 18:06:44   polina.marimont
 * compilation errors fix, when CHECK_BEFORE_EVERY_COMMAND defined
 *
 *    Rev 1.43   May 18 2006 14:29:56   polina.marimont
 * TFFSBdkPartitionInfo() fixed to return flBadDriveHandle, when wrong number of partition specified, using migration variable
 *
 *    Rev 1.42   May 18 2006 09:47:06   polina.marimont
 * 1. IOCTL fixed
 * 2. used size set back to 0
 *
 *    Rev 1.41   May 17 2006 15:42:28   polina.marimont
 * 1. Error codes are fixed up to Legacy + SA package
 * 2. LOCK and CHANGABLE protection support
 * 3. Format fixed - common functions used to add IPL and OTP partitions, also to set partition protection attributes
 * 4. PassThrough implemented
 * 5. bug fixes
 *
 *    Rev 1.40   Apr 11 2006 13:21:34   tal.heller
 * enable EraseBD API.
 * Bug Fix - Last Partition size wasn't initialized.
 * Fix CC compilation
 * adapt SecureDelete ioreq implementation to DOCH
 * Bug Fix - StickLock API
 * Comments syntax errors.
 *
 *    Rev 1.39   Mar 29 2006 16:39:50   DoronC
 * Bug fix - compilation warnings ove various compilers.
 *
 *    Rev 1.38   Mar 27 2006 16:21:58   DoronC
 * Add DMA support.
 *
 *    Rev 1.37   Mar 22 2006 17:35:46   DoronC
 * Bug fix - add signature to disk attributes in order to use only
 * format made by TrueFFS 7.1 and not by host SDK.
 * Other format will force reformatting of the media.
 *
 *    Rev 1.36   Mar 20 2006 17:21:58   DoronC
 * Bug fix - read IPL using buffers failed.
 *
 *    Rev 1.35   Mar 20 2006 10:41:16   DoronC
 * Bug fix - protection change was not working.
 *
 *    Rev 1.34   Mar 15 2006 16:17:54   DoronC
 * Bug fix - wrong flag was checked when reading IPL.
 *
 *    Rev 1.33   Mar 15 2006 15:58:04   DoronC
 * Bug fix - change protection key caused an exception.
 *
 *    Rev 1.32   Mar 15 2006 14:14:46   DoronC
 * Bug fix - formating protected partition with no active protection failed.
 * Bug fix - IPL flags were not checked.
 *
 *    Rev 1.31   Mar 15 2006 11:28:16   DoronC
 * Bug fix - IPL write was not working properly.
 * Bug fix - BDK used size was faulty.
 *
 *    Rev 1.30   Mar 14 2006 09:53:52   DoronC
 * Bug fix - DOCFlash win field was not initialized by the init routine
 *  causing exception on some conditions.
 *
 *    Rev 1.29   Mar 06 2006 08:40:52   DoronC
 * Bug fix - protection identify was reported wrong.
 *
 *    Rev 1.28   Mar 05 2006 15:52:24   DoronC
 * Protection structure of H3 changed to contain dwords instead
 *  of words.
 *
 *    Rev 1.27   Mar 02 2006 12:02:30   DoronC
 * Bug fix - mount was checked for wrong number of partitions.
 *
 *    Rev 1.26   Mar 02 2006 08:30:26   DoronC
 * Host SDK API changed from IOreq2 to IOreq.
 *
 *    Rev 1.25   Feb 16 2006 11:32:38   DoronC
 * Store binary partition flags in the attributes and return then
 * when requested by extendedInfo for computability with legacy
 * devices.
 *
 *    Rev 1.24   Feb 16 2006 10:02:40   DoronC
 * Bug fix - Compilation warnings removed.
 * Bug fix - Combining DPS between BDK and BDTL was not
 * working properly during format.
 * Bug fix - change protection key&type of combined DPS was not
 * working.
 *
 *    Rev 1.23   Feb 14 2006 10:50:02   DoronC
 * Remove large variables from stack. use one global buffer for
 * all large buffers needs.
 */

#include "msys.h"
#include "msys_custom.h"
#include "misc.h"

#include "flsystem.h"
#include "flchkdef.h"
#include "flcustom.h"
#include "defs.h"
#include "flbase.h"
#include "flstdcmp.h"

#include "flsystyp.h"

#include "blockdev.h"
#include "_docsys.h"

//#include "hib.h"
#include "doch_ata.h"
#include "doch_api.h"
#include "bdkemul.h"
#include "tffs_api.h"
#include "doch_func.h"
#include "dochtl.h"


#define MAX_MOUNT_COUNT	100	/*100 Times...*/
#define DOCH_NUM_OF_PLANES		1
#define DOCH_NUM_OF_BANKS		1
#define DOCH_SECTORS_PER_PAGE	4
#define DOCH_SHARED_SECTORS		32

#define DOCH_CAPACITY_128MB		0x40000		/*In Sectors*/
#define DOCH_CAPACITY_256MB		0x80000		/*In Sectors*/
#define DOCH_CAPACITY_512MB		0x100000	/*In Sectors*/
#define DOCH_CAPACITY_1GB		0x200000	/*In Sectors*/
#define DOCH_CAPACITY_2GB		0x400000	/*In Sectors*/
#define DOCH_CAPACITY_4GB		0x800000	/*In Sectors*/
#define DOCH_CAPACITY_8GB		0x1000000	/*In Sectors*/

#define DOCH_UNIT_SIZE_256KB	0x40000		/*In Bytes*/
#define DOCH_UNIT_SIZE_512KB	0x80000		/*In Bytes*/
#define DOCH_UNIT_SIZE_1MB		0x100000	/*In Bytes*/
#define DOCH_UNIT_SIZE_2MB		0x200000	/*In Bytes*/
#define DOCH_UNIT_SIZE_4MB		0x400000	/*In Bytes*/

#define createIrHandle(socket, partition) ((socket) + ((partition) << 4));


/********************/
/*	Externs         */
/********************/

extern FLDword gIsDMAEnabled;				/*DMA is Enabled/Disabled*/
extern DOCH_DpdSettings gDpdSettings;

#ifdef CHECK_POWER_ON_EVERY_COMMAND
extern FLBoolean gDeviceTurnedOff;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/


/********************/
/*	Global Vars		*/
/********************/

DocHVolume dochVol;
FLBoolean dochBdCallWasCalled = FALSE;
FLBoolean dochDpdInitialized = FALSE;

#ifdef CHECK_POWER_ON_EVERY_COMMAND
#define TFFS_API_RET(rc)((rc==DOCH_DeviceTurnedOff) ? flSuspendModeDetected : flGeneralFailure)
#else /*CHECK_POWER_ON_EVERY_COMMAND*/
#define TFFS_API_RET(rc) flGeneralFailure
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/

#define TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, dochStatus, flStatus){\
	    DOCH_DeviceInfo * pDevInfo = (DOCH_DeviceInfo*)dochVol.intermediateBuf;\
		dochStatus = flDOCHIdentifyDiskOnChipDevice(tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0,dochVol.intermediateBuf, 0,0));\
		if(dochStatus != DOCH_OK){\
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("flDOCHIdentifyDiskOnChipDevice failed with status: 0x%x "),dochStatus));\
			return (dochStatus==DOCH_DiskNotFound)? flUnknownMedia:TFFS_API_RET(dochStatus);}\
		dochVol.dwUnformattedCapacity = pDevInfo->dwUnformattedCapacity;\
		dochVol.dwVirtualUnitSizeInSectors = (pDevInfo->dwUnitSize!=0) ? pDevInfo->dwUnitSize : (dochVol.dwUnformattedCapacity>>9);\
		dochVol.dwVirtualUnitSize = ((dochVol.dwVirtualUnitSizeInSectors)<<DOCH_SECTOR_SIZE_BITS);\
		dochVol.dwNumOfUnits = (dochVol.dwUnformattedCapacity / dochVol.dwVirtualUnitSizeInSectors);}

#define TFFS_API_RET_PART_FLSTATUS(rc, flDefaultStatus)\
switch(rc){\
case DOCH_ProtectionFault:			return flHWProtection;\
case DOCH_PartitionLimitExceeded:	return flSectorNotFound;\
case DOCH_PartitionNotFound:		return flPartitionNotFound;\
case DOCH_BadParameter:				return flBadParameter;\
default:							return flDefaultStatus;}


#define TFFS_API_SET_MIG_STD_PART_PRMS(pPartitionFormatInfoAPI, protectionType)\
		pPartitionFormatInfoAPI->dwOtpEnabled = (protectionType & CHANGEABLE_PROTECTION) ? TRUE : FALSE;\
		pPartitionFormatInfoAPI->dwPartitionType		= DOCH_PRT_TYPE_NORMAL;\
		pPartitionFormatInfoAPI->dwPerformanceControl	= DOCH_NORMAL_PERFORMANCE;\
		pPartitionFormatInfoAPI->dwPageSizeExp			= DOCH_PAGE_SIZE_512B;\
		pPartitionFormatInfoAPI->dwHashType				= DOCH_HASH_TYPE_SHA1;\
		pPartitionFormatInfoAPI->dwEncryptionType		= DOCH_ENCRYPT_NONE;\
		pPartitionFormatInfoAPI->dwMasterControl		= DOCH_PART_ACCESS_MODE_FULL;\
		pPartitionFormatInfoAPI->dwMaxNumOfAuthAttempts = DOCH_MAX_PWD_ATTEMPTS;


#define TFFS_API_BDCALL_GET_PART_USER_ATTR( rioreq, socket_no, part_no, retc)\
	retc = flDOCHGetParitionUserAttributes( tffsAPISetIoreq(&rioreq,socket_no + (part_no << 4),0,0,dochVol.intermediateBuf,0,0));\
	if(retc != DOCH_OK){\
		rc = TFFS_API_RET(rcDoch);\
		break;}

/*********************/
/*	Static functions */
/*********************/
FLStatus tffsApiAuthPartition(IOreq * myIoreq, IOreq * ioreq, FLByte bPartNo, FLByte * pKey, FLWord wKeyLen);
FLStatus tffsApiAddOtpIPL(FLBoolean bIPL, IOreq * myIoreq, IOreq * ioreq);
FLStatus tffsFormatSetProtectionAttribs(FLByte bProtType, DOCH_PartitionFormatInfoAPI* pPartitionFormatInfoAPI, FLByte * bKey, FLWord wKeyLen);
IOreq   *tffsAPISetIoreq(IOreq * pIoreq, FLHandle irHandle, FLDword irFlags, void* irPath, void * irData, FLSDword irLength, FLSDword irCount);



/*----------------------------------------------------------------------*/
/* Function name   : actualPartitionNum*/
/* Description     : */
/* Return type     : FLStatus */
/* Argument        : FLByte* partNum*/
/* Argument        : FLByte partitionType*/
/*----------------------------------------------------------------------*/
FLStatus actualPartitionNum(FLByte* partNum, FLByte partitionType, FLSDword sdwSocketNo)
{
	DOCH_Socket *pDev;

	DOCH_get_socket(pDev, sdwSocketNo);
	if( pDev==NULL )
		return flBadParameter;

	if( pDev==NULL )
		return flBadParameter;

	switch(partitionType)
	{
	case PARTITION_TYPE_IPL:
		break;

	case PARTITION_TYPE_BDTL:
		*partNum += (dochVol.numOfBinaryPartitions + (dochVol.iplExists + dochVol.otpExists));
		break;

	case PARTITION_TYPE_BINARY:
		*partNum += (dochVol.iplExists + dochVol.otpExists);
		break;

	case PARTITION_TYPE_OTP:
		break;

	default:
		break;
	}

	if( (*partNum) == 0 )
		return flOK;

	if( ((*partNum) >= DOCH_MAX_PARTITIONS) || ((*partNum) >=pDev->wTotalNumOfPartitions) )
		return flPartitionNotFound;

	return flOK;
}/*actualPartitionNum()*/


#ifdef FL_EXTENDED_DISK_INFO
/*----------------------------------------------------------------------*/
/*            T F F S E x t e n d e d G e t D i s k I n f o             */
/*                                                                      */
/* Returns general information about the Device and a specific partition */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle      : Drive number (0, 1, ...)                      */
/*                        bits 7-4 - Must be set to 0                   */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irCount       : Partition number                              */
/*        irFlags       : Either FL_BDK_PARTITION or FL_DISK_PARTITION  */
/*        irData        : Address of FLExtendedDiskInfo structure       */
/*        irLength      : Floor number to access - FL_ALL_FLOORS        */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSGetExtendedDiskInfo(IOreq* ioreq)
{
	DOCH_Error         rc;
	FLStatus           flStatus;
	DOCH_Error         specificPartRC = DOCH_PartitionNotFound;
	DOCH_Error         iplRC = DOCH_PartitionNotFound;
	IOreq              myIoreq;
	FLExtendedDiskInfo FAR1 *info = (FLExtendedDiskInfo FAR1 *)ioreq->irData;
	FLDword            dwIPLSize;
    FLByte             bNumOfBinaryPartitions, partition;
    FLWord             wTotalNumOfPartitions;
    FLDword            dwPartitionFlags = 0;
	DOCH_DeviceInfo                   *pDochDevInfo = (DOCH_DeviceInfo*)dochVol.intermediateBuf;
	DOCH_DiskUserAttrWithBinary       *pDiskUserAttrWithBinary = (DOCH_DiskUserAttrWithBinary*)dochVol.intermediateBuf;
	DOCH_PartitionUserAttrWithBinary  *pPartUserAttrWithBinary = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	DOCH_Socket                       *pDev;

	DOCH_get_socket(pDev, FL_GET_SOCKET_FROM_HANDLE(ioreq));


	/*Retrieve DOCH extended info structure*/
	/*-------------------------------------*/
	rc = flDOCHIdentifyDiskOnChipDevice(tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetExtendedDiskInfo(): flDOCHIdentifyDiskOnChipDevice failed with status: %d "), rc));
		return (rc==DOCH_DiskNotFound)? flUnknownMedia:TFFS_API_RET(rc);
	}

	TFFS_API_GET_UNIT_SIZE(myIoreq,ioreq, rc, flStatus);

    wTotalNumOfPartitions = pDochDevInfo->wTotalNumOfPartitions;

	/* Retrieve Disk User Attributes */
	/*-------------------------------*/
	rc = flDOCHGetDiskUserAttributes(tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetExtendedDiskInfo(): flDOCHGetDiskUserAttributes failed with status: 0x%x "),rc));
		return (rc==DOCH_ProtectionFault)?flHWProtection:flBadFormat;  /* if not protected -> like media header not found */
	}

	/* Check if device is not formatted */
	if( (! pDiskUserAttrWithBinary->bIplPresent) && (! pDiskUserAttrWithBinary->bOtpPresent) )
	{
		/*Fill only relevant fields*/
		info->dwTLType          = 0;
		info->dwFormatFlags     = 0;
		info->dwTrueFFSVersion	= 0;
		info->dwFlashTechnology         = 0;
		info->dwType                    = FL_H3;
		info->dwSubType                 = 0;
		info->bMediaType                = 0;
		info->bNoOfFloors               = (FLByte)pDev->wNumOfDevices;
		info->bNoOfPlanes               = DOCH_NUM_OF_PLANES;
		info->bNoOfBanks                = DOCH_NUM_OF_BANKS;
		info->bDataBusWidth             = 16;	/*DOCH always uses 16bit*/
		info->bSectorsPerPage           = DOCH_SECTORS_PER_PAGE;
		info->bSharedSectors            = DOCH_SHARED_SECTORS;
		info->bFastAreaSharedSectors    = 0;
		info->bMaxRelatedSectors        = 0;
		info->dwIPLSize					= 0;
		info->bChangeableProtectedAreas = 0;
		info->btotalProtectedAreas      = 0;
		info->dwUnitsInFirstFloor       = 0;
		info->dwUnitSize                = dochVol.dwVirtualUnitSize;
		info->dwMaxBadPercentage        = 0;

		info->bNoOfBinaryPartitions  = 0;
		info->bNoOfDiskPartitions    = 0;
		info->bBlockMultiplierBits   = 0;
		info->dwPercentUsed          = 0;
		info->bHeaderUnits           = 0;
		info->wHeaderLocation        = 0;

		/* Programmer name and version strings */
		/* Retrieve from disk attributes*/
		tffscpy(info->bProgrammerNamePtr, pDiskUserAttrWithBinary->bProgrammerName, sizeof(FLDword));
		tffscpy(info->bProgrammerVersionPtr, pDiskUserAttrWithBinary->bProgrammerVersion, sizeof(FLDword));
		tffscpy(&info->dwTrueFFSVersion, pDiskUserAttrWithBinary->bTFFSVersion, sizeof(FLDword));
		DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): device NOT formatted \r\n");
		return flBadFormat/*flFeatureNotSupported*/;
	}
    wTotalNumOfPartitions = wTotalNumOfPartitions - pDiskUserAttrWithBinary->bIplPresent -
                                                    pDiskUserAttrWithBinary->bOtpPresent;
    bNumOfBinaryPartitions = pDiskUserAttrWithBinary->bNumOfBinaryPartitions;

    /* Programmer name and version strings */
	tffscpy(&info->bProgrammerNamePtr[0], pDiskUserAttrWithBinary->bProgrammerName,
            sizeof(pDiskUserAttrWithBinary->bProgrammerName));
	tffscpy(&info->bProgrammerVersionPtr[0], pDiskUserAttrWithBinary->bProgrammerVersion,
            sizeof(pDiskUserAttrWithBinary->bProgrammerVersion));
    tffscpy(&info->dwTrueFFSVersion, pDiskUserAttrWithBinary->bTFFSVersion,
            sizeof(pDiskUserAttrWithBinary->bTFFSVersion));

	/*Retrieve IPL partition size*/
	/*---------------------------*/
	iplRC = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq) + (DOCH_IPL_PARTITION_NUM << 4),
		0,0,dochVol.intermediateBuf,0,0));
	if(iplRC != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetExtendedDiskInfo(): flDOCHPartitionInfo of IPL partition failed with status: 0x%x "), rc));
		return (iplRC==DOCH_ProtectionFault)?flHWProtection:flBadFormat;  /* if not protected, but fails -> like bad format */
	}
    dwIPLSize = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->nPartitionSize << DOCH_SECTOR_SIZE_BITS;

	/*	Fill FLExtendedDiskInfo structure	*/
	/*--------------------------------------*/

    /******************************************/
    /* Fields that belong to the entire media */
    /******************************************/
    info->dwTLType          = 0;
    info->dwFormatFlags     = 0;
	info->dwTrueFFSVersion	= 0;

    info->dwFlashTechnology         = 0;
    info->dwType                    = FL_H3;
    info->dwSubType                 = 0;
    info->bMediaType                = 0;
    info->bNoOfFloors               = (FLByte)pDev->wNumOfDevices;
    info->bNoOfPlanes               = DOCH_NUM_OF_PLANES;
    info->bNoOfBanks                = DOCH_NUM_OF_BANKS;
    info->bDataBusWidth             = 16;	/*DOCH always uses 16bit*/
    info->bSectorsPerPage           = DOCH_SECTORS_PER_PAGE;
    info->bSharedSectors            = DOCH_SHARED_SECTORS;
    info->bFastAreaSharedSectors    = 0;
    info->bMaxRelatedSectors        = 0;
    info->dwIPLSize                 = dwIPLSize;
    info->bChangeableProtectedAreas = 2;
    info->btotalProtectedAreas      = 2;
    info->dwUnitsInFirstFloor       = 0;
    info->dwUnitSize                = dochVol.dwVirtualUnitSize;
    info->dwMaxBadPercentage        = 0;

    info->bNoOfBinaryPartitions  = bNumOfBinaryPartitions;
    info->bNoOfDiskPartitions    = wTotalNumOfPartitions - bNumOfBinaryPartitions;
    info->bBlockMultiplierBits   = 0;
    info->dwPercentUsed          = 0;
    info->bHeaderUnits           = 0;
    info->wHeaderLocation        = 0;


	/*Retrieve specific partition info
	  Note that the specific partition is always a BDTL partition
	  Hence jumping over IPL/OTP/Binary Partition
	  -------------------------------------------*/
    partition = (FLByte)ioreq->irCount;
	if(ioreq->irFlags == FL_DISK_PARTITION)
        flStatus = actualPartitionNum(&partition, PARTITION_TYPE_BDTL, FL_GET_SOCKET_FROM_HANDLE(ioreq));
    else if(ioreq->irFlags == FL_BDK_PARTITION)
        flStatus = actualPartitionNum(&partition, PARTITION_TYPE_BINARY, FL_GET_SOCKET_FROM_HANDLE(ioreq));
	if( flStatus!=flOK )
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): specific partition NOT FOUND \r\n");
		return flStatus;
	}

    specificPartRC = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (partition << 4),
		0,0,dochVol.intermediateBuf,0,0));
	if(specificPartRC != DOCH_OK)
	{
	    DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): specific partition NOT FOUND \r\n");
		return (iplRC==DOCH_ProtectionFault)? flHWProtection : flBadDriveHandle;
	}
    if ((ioreq->irFlags == FL_DISK_PARTITION) && (pPartUserAttrWithBinary->bType != PARTITION_TYPE_BDTL))
    {
	    DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): Partition is not BDTL partition. \r\n");
	    return flGeneralFailure;
    }
    if ((ioreq->irFlags == FL_BDK_PARTITION) && (pPartUserAttrWithBinary->bType != PARTITION_TYPE_BINARY))
    {
	    DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): Partition is not BDK partition. \r\n");
	    return flGeneralFailure;
    }
    if( pPartUserAttrWithBinary->bType == PARTITION_TYPE_BINARY )
        dwPartitionFlags = pPartUserAttrWithBinary->binPartHeader.dwPartitionFlags;

	specificPartRC = flDOCHPartitionInfo(tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (partition << 4),
															0, 0, dochVol.intermediateBuf, 0, 0));
	/* Check if partition exists */
	if(specificPartRC == DOCH_PartitionNotFound)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSGetExtendedDiskInfo(): specific partition NOT FOUND \r\n");
		return flBadDriveHandle;
	}
    /************************************************/
    /* Fields that belong to the specific partition */
    /************************************************/
	if(specificPartRC == DOCH_OK)
	{
		DOCH_PartitionInfo* pPartInfo = (DOCH_PartitionInfo*)dochVol.intermediateBuf;
		info->wHeaderLocation = 0;
        info->dwVirtualUnits          = pPartInfo->nPartitionSize/dochVol.dwVirtualUnitSizeInSectors;
		info->dwNormalAreaUnitSize    = dochVol.dwVirtualUnitSize;
		if(ioreq->irFlags == FL_DISK_PARTITION)
		{
			info->dwFastAreaVirtualFactor   = pPartInfo->wFastAreaFactor;
			info->dwFastAreaLogicalUnitSize = dochVol.dwVirtualUnitSize / (1<<pPartInfo->wFastAreaFactor);
			info->dwFastUnits               = pPartInfo->nFastAreaSize / (info->dwFastAreaLogicalUnitSize>>DOCH_SECTOR_SIZE_BITS);
		}
		else
		{/* binary partition */
			info->dwFastAreaVirtualFactor   = 0;
			info->dwFastAreaLogicalUnitSize = 0;
			info->dwFastUnits               = 0;
		}
		info->dwFirstUnit             = 0;
		info->dwLastUnit              = info->dwVirtualUnits;
		info->dwPartitionFlags        = dwPartitionFlags;
		info->dwFirstQuickMountUnit   = 0;
		info->dwSpareUnits            = 0;
		info->dwTransferUnits         = 0;


		info->bMinSectorsForFolding           = 0;
		info->bMinSectorsForNextWrite         = 0;
		info->bfastAreaMinSectorsForNextWrite = 0;

		/******************************************/
		/* Fields that are valid only after mount */
		/******************************************/
		info->dwUsedUnits             = 0;
		info->dwFreeUnits             = 0;
		info->bNeededFreeUnits        = 0;
		info->dwUMDBBTSector          = 0;
	}
	else
		return TFFS_API_RET(specificPartRC);

	return flOK;
}/*TFFSGetExtendedDiskInfo()*/

#endif	/* FL_EXTENDED_DISK_INFO */


/*----------------------------------------------------------------------*/
/*             T F F S V o l u m e I n f o                              */
/*                                                                      */
/* Get general information about the media.                             */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle        : Socket number (0,1,..)                        */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*      irData			: Address of user buffer to read general        */
/*                        information into.                             */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSVolumeInfo(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	VolumeInfoRecord FAR1 * volumeInfo = (VolumeInfoRecord FAR1 *)ioreq->irData;
    FLDword dwPartitionSize;

    /*Retrieve specific partition info*/
	/*--------------------------------*/
	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSVolumeInfo(): flDOCHPartitionInfo failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flBadDriveHandle : TFFS_API_RET(rc));
	}
    dwPartitionSize = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->nPartitionSize;

	/*Retrieve DOCH extended info structure and calculate unit number if required */
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	/*	Fill VolumeInfoRecord structure	*/
	/*----------------------------------*/
	/*Media Geometry*/
    flBuildGeometry( dwPartitionSize, &volumeInfo->cylinders,
                    &volumeInfo->heads, &volumeInfo->sectors,
                    FALSE, (FLWord)ioreq->irHandle);

    volumeInfo->logicalSectors = dwPartitionSize;
	volumeInfo->bootAreaSize = 0;
	/* Return window base reg */
	/*------------------------*/
	tffsAPISetIoreq( &myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,0,0,0);
	rc=flDOCHGetPhysicalAddress(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetPhysicalInfo(): DOCHGetPhysicalAddress failed with status: 0x%x "), rc));
		return (DOCH_DiskNotFound==rc) ? flAdapterNotFound : TFFS_API_RET(rc);
	}
	volumeInfo->baseAddress = myIoreq.irCount;

#ifdef FL_LOW_LEVEL
	volumeInfo->flashType = FL_H3;
	volumeInfo->dwPhysicalUnitSize = dochVol.dwVirtualUnitSizeInSectors;
	volumeInfo->dwPhysicalSize =  dochVol.dwUnformattedCapacity;
	volumeInfo->DOCType = FL_H3;
	volumeInfo->lifeTime= 1; /*1 - indicates fresh media*/
#endif /*FL_LOW_LEVEL*/

	tffsset(volumeInfo->driverVer,0,sizeof(volumeInfo->driverVer));
    tffscpy(volumeInfo->driverVer,driverVersion,
		    TFFSMIN(sizeof(volumeInfo->driverVer),sizeof(driverVersion)));

	tffsset(volumeInfo->OSAKVer,0,sizeof(volumeInfo->OSAKVer));
	tffscpy(volumeInfo->OSAKVer, OSAKVersion,
		    TFFSMIN(sizeof(volumeInfo->OSAKVer),sizeof(OSAKVersion)));

	return flOK;
}/*TFFSVolumeInfo()*/

/*----------------------------------------------------------------------*/
/*                T F F S C o u n t V o l u m e s                       */
/*                                                                      */
/* Counts the number of volumes on the Flash device.                    */
/*                                                                      */
/* Not all the volumes necessarily need to be mounted. A drive formated */
/* with a read protection will be registered but can not be accessed.   */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number ( 0,1,2...  )                 */
/*                        : Partition number ( 0,1,2...  )              */
/*																		*/
/* Returns:                                                             */
/*      irFlags         : Number of partitions							*/
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
FLStatus TFFSCountVolumes(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_GeneralFailure;

	IOreq myIoreq;
    FLByte bNumOfPartition;
	DOCH_DiskUserAttrWithBinary * pDiskUserAttrWithBinary = (DOCH_DiskUserAttrWithBinary *)(dochVol.intermediateBuf);

	/*Retrieve DOCH global info structure*/
	/*-------------------------------------*/
	rc = flDOCHIdentifyDiskOnChipDevice(tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq),
												0,0,dochVol.intermediateBuf, 0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSCountVolumes(): flDOCHIdentifyDiskOnChipDevice failed with status: 0x%x "), rc));
		return (rc==DOCH_DiskNotFound)? flUnknownMedia : TFFS_API_RET(rc);
	}
    bNumOfPartition = (FLByte)((DOCH_DeviceInfo*)dochVol.intermediateBuf)->wTotalNumOfPartitions;

	/*Retrieve disk attributes*/
	rc = flDOCHGetDiskUserAttributes(tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0,
														dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSCountVolumes(): flDOCHGetDiskUserAttributes failed with status: 0x%x"), rc));
		return (rc==DOCH_ProtectionFault)?flHWProtection:TFFS_API_RET(rc);
	}
    bNumOfPartition = bNumOfPartition - pDiskUserAttrWithBinary->bIplPresent -
                      pDiskUserAttrWithBinary->bOtpPresent - pDiskUserAttrWithBinary->bNumOfBinaryPartitions;

	/*Extract # of partitions from Extended Info*/
	/*------------------------------------------*/
	ioreq->irFlags = bNumOfPartition;

	/* fix number of partitions - unformatted device should return 1*/
	if( (pDiskUserAttrWithBinary->bNumOfBinaryPartitions==0) &&
		(bNumOfPartition==0) )
	{
		ioreq->irFlags = 1;
	}
	return flOK;
}/* TFFSCountVolumes() */


/*----------------------------------------------------------------------*/
/*                 f l S e c t o r s I n V o l u m e                    */
/*                                                                      */
/* Returns number of virtual sectors in volume.                         */
/*                                                                      */
/* In case the inserted volume is not mounted, returns current status.  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle  : Drive number (0, 1, ...)                          */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*      irLength        : number of virtual sectors in volume           */
/*----------------------------------------------------------------------*/
static FLStatus TFFSSectorsInVolume(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;


	/*Retrieve specific partition info*/
	/*--------------------------------*/
    myIoreq.irHandle = ioreq->irHandle;
	myIoreq.irData = dochVol.intermediateBuf;

	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSSectorsInVolume(): flDOCHPartitionInfo failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flBadDriveHandle : TFFS_API_RET(rc));
	}

    ioreq->irLength = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->nPartitionSize;
	return flOK;
}/* TFFSSectorsInVolume */

#ifndef FL_NO_QUICK_MOUNT_FEATURE
/*----------------------------------------------------------------------*/
/*																		*/
/* Quick mount routines are Obsoleted for DOCH					        */
/*																		*/
/*----------------------------------------------------------------------*/
FLStatus TFFSClearQuickMountInfo(IOreq* ioreq)
{
	return flOK;
}/*TFFSClearQuickMountInfo*/

static FLStatus TFFSWriteQuickMountInfo(IOreq* ioreq)
{
	return flOK;
}/*TFFSWriteQuickMountInfo*/

static FLStatus TFFSGetQuickMountStatus(IOreq* ioreq)
{
	ioreq->irFlags = FL_ON;
	return flOK;
}/*TFFSGetQuickMountStatus*/

#endif	/* FL_NO_QUICK_MOUNT_FEATURE */

/********************************************************/
/*														*/
/*	Mount related routines are obsolete for DOCH		*/
/*	Maintained in API only for backward compatibility	*/
/*														*/
/********************************************************/
#if 0 //def FL_MIGRATION_VERSION

FLStatus TFFSAbsMountVolume(IOreq* ioreq)
{
    FLByte partition;
    FLStatus  flStatus;
    IOreq myIoreq;
    DOCH_Error rc;

	tffsset(&myIoreq, 0, sizeof(myIoreq));
    myIoreq.irHandle = ioreq->irHandle;
    myIoreq.irData = dochVol.intermediateBuf;
	rc = flDOCHGetDiskUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsMountVolume(): flDOCHGetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
	}
	/*Get some data from disk attributes sector*/
    if (tffscmp(((DOCH_DiskUserAttrWithBinary*)dochVol.intermediateBuf)->bMigrationSignature,
                    TFFS_API_MIGRATION_SIGNATURE,
                    sizeof(((DOCH_DiskUserAttrWithBinary*)dochVol.intermediateBuf)->bMigrationSignature)) != 0)
    {
        DBG_PRINT_ERR(FLZONE_API, "TFFSAbsMountVolume(): Device is not formated with TrueFFS 7.1. Either reformat the device or run upgrade utility.\n");
        return flBadFormat;
    }

    partition = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
	flStatus = dochMountTL(partition, FL_GET_SOCKET_FROM_HANDLE(ioreq));
    if (flStatus == flOK)
    {
        if(dochVol.mountCount[partition] < 0x64)
            dochVol.mountCount[partition]++;
    }
	return flStatus;
}/*TFFSAbsMountVolume*/

FLStatus TFFSAbsDismountVolume(IOreq* ioreq)
{
    FLByte partition;
	FLStatus rc;
    partition = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
    if(dochVol.mountCount[partition] == 0)
    {
		return flNotMounted;
    }

	if(dochVol.mountCount[partition] > 0)
    {
        rc = dochDismountTL(partition);
        if (rc == flOK)
        {
		    dochVol.mountCount[partition]--;
        }
    }
    else
        rc = flNotMounted;
	return rc;
}/*TFFSAbsDismountVolume*/

#endif // FL_MIGRATION_VERSION

/*----------------------------------------------------------------------*/
/* Function name   : TFFSCheckVolume*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSCheckVolume(IOreq* ioreq)
{
    FLStatus flStatus;
    if(dochVol.mountCount[FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq)] > 0)
        flStatus = flOK;
    else
        flStatus = flNotMounted;
    return flStatus;
}/*TFFSCheckVolume*/

#ifndef FL_READ_ONLY
/*----------------------------------------------------------------------*/
/*			  T F F S D e f r a g m e n t V o l u m e		    		*/
/*                                                                      */
/* Performs a general defragmentation and recycling of non-writable     */
/* Flash areas, to achieve optimal write speed.                         */
/*                                                                      */
/* NOTE: The required number of sectors (in irLength) may be changed    */
/* (from another execution thread) while defragmentation is active. In  */
/* particular, the defragmentation may be cut short after it began by   */
/* modifying the irLength field to 0.                                   */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle  : Drive number (0, 1, ...)                          */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irLength  : Minimum number of sectors to make available for   */
/*                    writes.                                           */
/*                                                                      */
/* Returns:                                                             */
/*        irLength  : Actual number of sectors available for writes     */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
FLStatus TFFSDefragmentVolume(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	FLSDword request = ioreq->irLength;

	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);
	/*Return values*/
	/*=============*/
	switch(request)
	{
	case FL_MINIMAL_DEFRAGMENTATION:
	case FL_MAXIMUM_DEFRAGMENTATION:
		ioreq->irLength = dochVol.dwVirtualUnitSizeInSectors;
		return flNotEnoughMemory;

	case FL_STATIC_WEAR_LEVELING_DELAYED:
	case FL_STATIC_WEAR_LEVELING_NOW:
	case FL_STATIC_WEAR_LEVELING_ON:
	case FL_STATIC_WEAR_LEVELING_OFF:
		ioreq->irLength = dochVol.dwVirtualUnitSizeInSectors;
		break;

	default:
		if(request > 0)
			ioreq->irLength = dochVol.dwVirtualUnitSizeInSectors;
		else
		{
			if(request == 0)
				ioreq->irLength = 0;
			else
				return flBadParameter;
		}
		return flNotEnoughMemory;
	}
	return flOK;
}/*TFFSDefragmentVolume()*/





/*********************************************************/
/* Function name	: tffsFormatSetProtectionAttribs*/
/* Description	    : */
/* Return type		: FLStatus */
/* Argument         : FLByte bProtType*/
/* Argument         : DOCH_PartitionFormatInfoAPI* pPartitionFormatInfoAPI*/
/* Argument         : FLByte * bKey*/
/* Argument         : FLWord wKeyLen*/
/*********************************************************/
FLStatus tffsFormatSetProtectionAttribs( FLByte bProtType, DOCH_PartitionFormatInfoAPI* pPartitionFormatInfoAPI,
											    FLByte * pKey, FLWord wKeyLen)
{
	FLBoolean read_protect, write_protect, change_protect, locked;

	read_protect = write_protect = change_protect = locked =FALSE;
	/*Enabled Protections*/
	if( (bProtType & READ_PROTECTED) == READ_PROTECTED)
		read_protect = TRUE;
	if( (bProtType & WRITE_PROTECTED) == WRITE_PROTECTED)
		write_protect = TRUE;
	if( (bProtType & CHANGEABLE_PROTECTION) == CHANGEABLE_PROTECTION)
		change_protect = TRUE;
	if( (bProtType & LOCK_ENABLED) == LOCK_ENABLED)
		locked = TRUE;

	/*Protection requested*/
	if(read_protect || write_protect)
	{
		pPartitionFormatInfoAPI->dwProtectionType = DOCH_PARTITION_PWD_PROTECTED;
		/*Specific protection*/
		if(read_protect)
		{ /* TEMPORARY - till the device will support write protection */
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): read protection NOT supported\r\n ");
			return flBadParameter;
		}
		if (write_protect)
		{
			pPartitionFormatInfoAPI->dwUserAccessMode = DOCH_PART_ACCESS_MODE_FULL;
			pPartitionFormatInfoAPI->dwGuestAccessMode = DOCH_PART_ACCESS_MODE_RO;
		}
	}
	else
	{/*No protection requested or changeable protection only requested */
		pPartitionFormatInfoAPI->dwProtectionType = (change_protect!=FALSE)?DOCH_PARTITION_PWD_PROTECTED:DOCH_PARTITION_NOT_PROTECTED;
		pPartitionFormatInfoAPI->dwUserAccessMode = DOCH_PART_ACCESS_MODE_FULL;
		pPartitionFormatInfoAPI->dwGuestAccessMode = DOCH_PART_ACCESS_MODE_FULL;
	}

	/* lock notification */
	pPartitionFormatInfoAPI->dwLockControl = (locked==TRUE) ? DOCH_LOCK_ACTIVE : DOCH_LOCK_NOT_ACTIVE;

	/*Passkey*/
	if(read_protect || write_protect || change_protect)
	{
		tffscpy(pPartitionFormatInfoAPI->bPasskey, pKey, wKeyLen);
	}

	return flOK;
}/*tffsFormatSetProtectionAttribs*/

#ifdef FL_FORMAT_VOLUME
/*----------------------------------------------------------------------*/
/*            T F F S F l a s h  F o r m a t							*/
/*                                                                      */
/* Performs formatting of the DiskOnChip.                               */
/* All existing data is destroyed.                                      */
/*                                                                      */
/* Note : This routine is the format routine for OSAK 5.0 and up.       */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irFlags  :                                                    */
/*           TL_NORMAL_FORMAT          : Normal format                  */
/*           TL_LEAVE_BINARY_AREA      : Leave the previous binary area */
/*           TL_LEAVE_SOME_BINARY_AREA : Leave some of the previous     */
/*	         TL_DO_NOT_PERFORM_DOWNLOAD			                		*/
/*                                       binary partitions.             */
/*        irData   : Address of FormatParams3 structure to use          */
/*                              (defined in format.h)                   */
/*        irLength : If the TL_LEAVE_SOME_BINARY_AREA flag is set,      */
/*                   this field will indicate the number of binary      */
/*                   partitions to leave.                               */
/*																		*/
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
FLStatus TFFSflashFormat(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq      myIoreq;
    FLStatus   flStatus;
	FLSNative  i=0;
	FLByte     partNum=0, numOfBinaryPartitions;

	FormatParams3 FAR1					*FP3 = (FormatParams3 FAR1 *)ioreq->irData;
	BDTLPartitionFormatParams3 FAR2		*bdtlUserParams;
	BinaryPartitionFormatParams3 FAR2	*binUserParams;

	FLSNative  total_num_of_partitions = (FP3->noOfBinaryPartitions + FP3->noOfBDTLPartitions);
	FLSNative  binParToLeave = 0;
	FLByte     bOtpPresent, bIplPresent;
	FLWord     lastRemainingPartition, wNumOfOriginalPartitions;
	FLByte     dpsFwd[DOCH_MAX_USED_PARTITIONS];
	FLByte     dpsBwd[DOCH_MAX_USED_PARTITIONS];

#ifdef HW_PROTECTION
	FLByte noPasskey[] = {0,0,0,0,0,0,0,0};
#endif /* HW_PROTECTION */

    FLBoolean                        combinedDPS;
    FLByte                           *intBuf = dochVol.intermediateBuf;
	DOCH_DiskUserAttrWithBinary      *pDiskUserAttrWithBinary = (DOCH_DiskUserAttrWithBinary*)intBuf;
	DOCH_PartitionUserAttrWithBinary *pPartitionUserAttrWithBinary = (DOCH_PartitionUserAttrWithBinary*)intBuf;
	DOCH_PartitionFormatInfoAPI      *pPartitionFormatInfoAPI = (DOCH_PartitionFormatInfoAPI*)intBuf;
	FLDword                          dwPartitionTotalSize;
	DOCH_Socket                      *pDev;

	DOCH_get_socket(pDev, FL_GET_SOCKET_FROM_HANDLE(ioreq));
	if( pDev==NULL )
		return flBadParameter;

	/*Initialize some variables*/
	tffsset(&dpsFwd, 0, sizeof(dpsFwd));
	tffsset(&dpsBwd, 0, sizeof(dpsBwd));

    /*Retrieve disk attributes*/
	tffsset(&myIoreq, 0, sizeof(myIoreq));
    myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
    myIoreq.irData = intBuf;
	rc = flDOCHGetDiskUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
	}

	/* Get some data from disk attributes sector */
	numOfBinaryPartitions = pDiskUserAttrWithBinary->bNumOfBinaryPartitions;
	bIplPresent = pDiskUserAttrWithBinary->bIplPresent;
	bOtpPresent = pDiskUserAttrWithBinary->bOtpPresent;

	/* check for corruption during format or wrong format */
		/* wrong signature */
    if( (tffscmp(pDiskUserAttrWithBinary->bMigrationSignature, TFFS_API_MIGRATION_SIGNATURE,
                   sizeof(pDiskUserAttrWithBinary->bMigrationSignature)) != 0)
		/* disk attributes not match no. of partitions */
		|| (pDev->wTotalNumOfPartitions<2 && bIplPresent && bOtpPresent)
		/* there are enough partitions but IPL or/and OTP indication corrupted */
		|| (pDev->wTotalNumOfPartitions>2 && (bIplPresent!=1 || bOtpPresent!=1)) )
    {
        bIplPresent = 0;
        bOtpPresent = 0;
        numOfBinaryPartitions = 0;
    }

	/*Calculate how many binary partition to LEAVE*/
	if(ioreq->irFlags == TL_LEAVE_BINARY_AREA)
		binParToLeave = numOfBinaryPartitions;
	else
	{
		if(ioreq->irFlags == TL_LEAVE_SOME_BINARY_AREA)
			binParToLeave = ioreq->irLength;
	}

	if(binParToLeave > numOfBinaryPartitions)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): binParToLeave > numOfBinaryPartitions \r\n ");
		return flBadParameter;
	}

	if(binParToLeave + FP3->noOfBinaryPartitions > MAX_BINARY_PARTITIONS_PER_DRIVE)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Number of binary partitions exceed maximum allowed.\r\n ");
		return flBadParameter;
	}

	/*Calculate number of remaining partitions*/
	lastRemainingPartition = (binParToLeave + bOtpPresent + bIplPresent);

	/*Retrieve DOCH extended info structure*/
	/*-------------------------------------*/
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);
	wNumOfOriginalPartitions = ((DOCH_DeviceInfo*)intBuf)->wTotalNumOfPartitions;

	/*Clear partition attributes for partitions to be deleted */
	if(lastRemainingPartition > 0)
	{
		tffsset(intBuf, 0, DOCH_SECTOR_SIZE);
		tffsset(&myIoreq, 0, sizeof(myIoreq));
		myIoreq.irData = intBuf;
		for(i=lastRemainingPartition; i < wNumOfOriginalPartitions; i++)
		{
			myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq) + (i << 4);
			rc = flDOCHSetParitionUserAttributes(&myIoreq);
			if( rc!=DOCH_OK )
			{
				return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
			}
		}
	}

	/*Set numOfBinaryPartitions*/
	/*Set programmer name, programmer version and TFFS version*/
	numOfBinaryPartitions = binParToLeave;
    tffsset(intBuf, 0, DOCH_SECTOR_SIZE);
 	pDiskUserAttrWithBinary->bNumOfBinaryPartitions = numOfBinaryPartitions;
    pDiskUserAttrWithBinary->bIplPresent = bIplPresent;
    pDiskUserAttrWithBinary->bOtpPresent = bOtpPresent;
	tffscpy(&pDiskUserAttrWithBinary->bProgrammerName, FL_PROGRAMMER_NAME, 4);
	tffscpy(&pDiskUserAttrWithBinary->bProgrammerVersion, FL_PROGRAMMER_VERSION, 4);
	tffscpy(&pDiskUserAttrWithBinary->bTFFSVersion, DochSDKVersion, 4);
    tffscpy(pDiskUserAttrWithBinary->bMigrationSignature, TFFS_API_MIGRATION_SIGNATURE,
                        sizeof(pDiskUserAttrWithBinary->bMigrationSignature));
	tffsset(&myIoreq, 0, sizeof(myIoreq));
    myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
	myIoreq.irData = intBuf;
	rc = flDOCHSetDiskUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
	}
    dochVol.numOfBinaryPartitions = numOfBinaryPartitions;

    if (binParToLeave > 0)
    { /*Check if needed to deal with leaving protected partition which had a joined DPS*/
		tffsset(&myIoreq, 0, sizeof(myIoreq));
        myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq) + ((binParToLeave+bIplPresent+bOtpPresent-1)<<4);
		myIoreq.irData = intBuf;
		rc = flDOCHGetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
        {
            DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
        }
        if( pPartitionUserAttrWithBinary->bDPSFwd )
        { /*If the last binary to be left has combined DPS with old partition which is about to be removed....*/
            /*First - remove the combined DPS flag if possible.*/
            pPartitionUserAttrWithBinary->bDPSFwd = FALSE;
            rc = flDOCHSetParitionUserAttributes(&myIoreq);
            if (rc != DOCH_OK)
            {
                DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Removing protection from left binary protection which uses same DPS as deleted one failed.\n");
				return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
            }
            combinedDPS = FALSE;
            if (FP3->noOfBinaryPartitions > 0)
            {
                if (FP3->binaryPartitionInfo->protectionType | PROTECTABLE)
                {
					flStatus = tffsApiAuthPartition( &myIoreq, ioreq, (FLByte)(binParToLeave - 1 + bOtpPresent + bIplPresent),
						FP3->binaryPartitionInfo->protectionKey, sizeof(FP3->binaryPartitionInfo->protectionKey));
					switch(flStatus)
					{
					case flOK:
						combinedDPS = TRUE;
						dpsBwd[binParToLeave - 1 + bOtpPresent + bIplPresent] = 1;
						break;
					case flWrongKey:
					case flNotProtected:
						break;
					default:
						return flStatus;
					}
                }
            }
            else
			{
				if (FP3->BDTLPartitionInfo->protectionType | PROTECTABLE)
				{
					flStatus = tffsApiAuthPartition( &myIoreq, ioreq, (FLByte)(bOtpPresent + bIplPresent),
						FP3->BDTLPartitionInfo->protectionKey, sizeof(FP3->BDTLPartitionInfo->protectionKey));
					switch(flStatus)
					{
					case flOK:
						combinedDPS = TRUE;
						dpsBwd[bOtpPresent + bIplPresent] = 1;
						break;
					case flWrongKey:
					case flNotProtected:
						break;
					default:
						return flStatus;
					}
				}
			}

            if (combinedDPS == TRUE)
            {
				tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + ((binParToLeave - 1)<<4),0,0,intBuf,0,0);
		        rc = flDOCHGetParitionUserAttributes(&myIoreq);
		        if(rc != DOCH_OK)
                {
                    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
                    return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
                }
                pPartitionUserAttrWithBinary->bDPSFwd = TRUE;
				tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + ((binParToLeave - 1)<<4),0,0,intBuf,0,0);
                rc = flDOCHSetParitionUserAttributes(&myIoreq);
                if (rc != DOCH_OK)
                {
                    DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Removing protection from left binary protection which uses same DPS as deleted one failed.\n");
					return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
                }
            }
        }
    }/*there are binary partitions to leave */

    if (bOtpPresent == 0)
        total_num_of_partitions++;
    if (bIplPresent == 0)
        total_num_of_partitions++;

	if( (wNumOfOriginalPartitions > 2) ||/* more, than IPL and OTP present */
		(bIplPresent==0 && bOtpPresent == 0 && numOfBinaryPartitions == 0) )/* or not 7.1.x format */
	{
		/*Delete partitions not marked to "leave" (if such exists)*/
		tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0,0,0xFF,
			binParToLeave + bIplPresent + bOtpPresent);
		rc = flDOCHDeletePartitions(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHDeletePartitions failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault)? flHWProtection:TFFS_API_RET(rc);
		}
	}

	/*Set IPL partition*/
	if(bIplPresent == 0)
	{
		/* add IPL partition, update it's attributes and disk attributes */
		checkStatus( tffsApiAddOtpIPL(TRUE, &myIoreq, ioreq) );
		memset (intBuf, 0xff, DOCH_SECTOR_SIZE);
		for (i = 0; i < TFFS_API_8K_NORMAL_IPL_SIZE ; i++)
		{
			tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq),
				(DOCH_IPL_MODE_8KB_WINDOW|DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT),
				0, dochVol.intermediateBuf, 1, TFFS_API_8K_NORMAL_IPL_SIZE);
			if (i == 0)
				myIoreq.irFlags |= DOCH_IPL_WRITE_FIRST_CHUNK;
			rc = flDOCHWriteIPL(&myIoreq);
			if (rc != DOCH_OK)
			{
				DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Failed writing default IPL. status: ");
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x \n"), rc));
				TFFS_API_RET_PART_FLSTATUS(rc,flWriteFault);
			}
		}
		dochVol.iplExists = 1;
		bIplPresent = 1;
	}/* IPL should be added */

	/*Set OTP partition*/
	if(bOtpPresent == 0)
	{
		checkStatus( tffsApiAddOtpIPL(FALSE, &myIoreq, ioreq) );
		dochVol.otpExists = 1;
		bOtpPresent = 1;
	}/*OTP partition should be added */

    binUserParams = FP3->binaryPartitionInfo;
    partNum = bOtpPresent + bIplPresent + binParToLeave;

	/*Perform for every binary partition*/
	/*----------------------------------*/
	for(i=0; i< FP3->noOfBinaryPartitions; i++)
	{
#ifdef HW_PROTECTION
		/*DPS Emulation
		  -----------*/
		/*Check if passkey is identical to next partition*/
        if (binUserParams->protectionType & PROTECTABLE)
        {
            if (i < (FP3->noOfBinaryPartitions-1))
            {
                if((tffscmp(binUserParams->protectionKey, binUserParams[1].protectionKey, TFFS_PROTECTION_KEY_LENGTH) == 0) &&
                    (binUserParams->protectionType == binUserParams[1].protectionType))
                {
                    dpsFwd[partNum] = TRUE;
                    dpsBwd[partNum + 1] = TRUE;
                }
            }
            else
            {
                if ((tffscmp(binUserParams->protectionKey, FP3->BDTLPartitionInfo->protectionKey,
                                sizeof(binUserParams->protectionKey))==0) &&
                                (binUserParams->protectionType == FP3->BDTLPartitionInfo->protectionType))
                {
                    dpsFwd[partNum] = TRUE;
                    dpsBwd[partNum + 1] = TRUE;
                }
            }
            /*Special case, check if 1st binary has the same passkey as previously last
            formatted partition*/
            if((lastRemainingPartition > 2) && (i == 0))
            {
				FLStatus tmpStatus = tffsApiAuthPartition(&myIoreq, ioreq, (FLByte)(lastRemainingPartition-1),
					binUserParams->protectionKey, sizeof(binUserParams->protectionKey));
				switch(tmpStatus)
				{
				case flOK:
					dpsFwd[partNum-1] = TRUE;
					dpsBwd[partNum] = TRUE;
					break;
				case flWrongKey:
				case flNotProtected:
					break;
				default:
					return tmpStatus;
				}
			}
        }

#endif /*HW_PROTECTION*/

		/*	Fill DOCH_PartitionFormatInfoAPI structure from FormatParams3 structure */
		/*==========================================================================*/
		tffsset(intBuf, 0, sizeof(DOCH_PartitionFormatInfoAPI));

		/* standard migration format params */
		TFFS_API_SET_MIG_STD_PART_PRMS(pPartitionFormatInfoAPI, binUserParams->protectionType);

		/* protection features */
		checkStatus( tffsFormatSetProtectionAttribs(binUserParams->protectionType, pPartitionFormatInfoAPI,
			binUserParams->protectionKey, sizeof(binUserParams->protectionKey)) );


		/*Partition size (must be FL_LENGTH_IN_BYTES)*/
		pPartitionFormatInfoAPI->nPartitionSize = (binUserParams->length & 0x1FF) ?
              ((binUserParams->length)>>DOCH_SECTOR_SIZE_BITS)+1 : ((binUserParams->length)>>DOCH_SECTOR_SIZE_BITS);

		/*Round partition size to Unit Size*/
		pPartitionFormatInfoAPI->nPartitionSize =
            (pPartitionFormatInfoAPI->nPartitionSize+dochVol.dwVirtualUnitSizeInSectors-1) & (~(dochVol.dwVirtualUnitSizeInSectors-1));

		if( pPartitionFormatInfoAPI->nPartitionSize == 0 )
		{
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): cannot add zero length binary partition ");
			return flBadParameter;
		}

		/*Add partition*/
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf,0,0);
		rc = flDOCHAddPartition(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHAddPartition (Binary) failed with status: 0x%x "), rc));
			return TFFS_API_RET(rc);
		}
#ifdef HW_PROTECTION
		/*Authenticate partition*/
		if(((binUserParams->protectionType & PROTECTABLE) == PROTECTABLE) &&
           ((binUserParams->protectionType & (READ_PROTECTED | WRITE_PROTECTED)) != 0))
		{
			checkStatus( tffsApiAuthPartition(&myIoreq, ioreq, partNum, binUserParams->protectionKey,
											sizeof(binUserParams->protectionKey)));
		}
#endif /*HW_PROTECTION*/

		/*Retrieve partition info*/
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (partNum << 4), 0,0, intBuf,0,0);
		rc = flDOCHPartitionInfo(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHPartitionInfo failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
		}
        dwPartitionTotalSize = ((DOCH_PartitionInfo*)intBuf)->nPartitionSize;

        /*Retrieve current atttributes*/
		rc = flDOCHGetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
		}

		/* Update the partition attributes and write them back to device */
		/*-------------*/
		/*Set type to binary*/
		pPartitionUserAttrWithBinary->bType = PARTITION_TYPE_BINARY;
        pPartitionUserAttrWithBinary->binPartHeader.dwPartitionFlags = binUserParams->flags;
		/*Set signature*/
		tffscpy( pPartitionUserAttrWithBinary->binPartHeader.subPartitions[0].bSignature,
			binUserParams->sign, BDK_SIGNATURE_NAME);
		/*Set length*/
		pPartitionUserAttrWithBinary->binPartHeader.subPartitions[0].dwSize = dwPartitionTotalSize;
		/*Set # of sub-partitions to 1*/
		pPartitionUserAttrWithBinary->binPartHeader.bNumOfSubPartitions = 1;
		/*Set DPS attribute*/
		pPartitionUserAttrWithBinary->bDPSFwd = dpsFwd[partNum];
		pPartitionUserAttrWithBinary->bDPSBwd = dpsBwd[partNum];
		/*Set protection attribute*/
		pPartitionUserAttrWithBinary->bChangableProtection = ((binUserParams->protectionType & CHANGEABLE_PROTECTION) == CHANGEABLE_PROTECTION);
		pPartitionUserAttrWithBinary->bProtected = ((binUserParams->protectionType & PROTECTABLE) == PROTECTABLE);
		/*Set attributes back to device*/
		rc = flDOCHSetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
		}

		/* Update the disk attributes and write them back to device */
		/*-------------*/
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf,0,0);
        rc = flDOCHGetDiskUserAttributes(&myIoreq);
        if(rc != DOCH_OK)
        {
		    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetDiskUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
	    }
        pDiskUserAttrWithBinary->bNumOfBinaryPartitions = numOfBinaryPartitions + 1;
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf,0,0);
        rc = flDOCHSetDiskUserAttributes(&myIoreq);
        if(rc != DOCH_OK)
        {
		    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetDiskUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
	    }

#ifdef HW_PROTECTION
		/*Authenticate partition*/
		if((((binUserParams->protectionType & PROTECTABLE) == PROTECTABLE) &&
			(binUserParams->protectionType & (READ_PROTECTED | WRITE_PROTECTED)) != 0) &&
            (ioreq->irFlags & TL_DO_NOT_PERFORM_DOWNLOAD) == 0)
		{
			tffsset(&myIoreq, 0, sizeof(myIoreq));
            myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
			DOCH_SET_PARTITION_TO_IOREQ_HANDLE(&myIoreq, partNum);
            myIoreq.irFlags = DOCH_ACCESS_USER_PASSWORD;
			rc = flDOCHDisablePartAccess(&myIoreq);
		    if(rc != DOCH_OK)
		    {
			    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHDisablePartAccess failed with status: 0x%x "), rc));
			    return TFFS_API_RET(rc);
		    }
		}
#endif /*HW_PROTECTION*/

        numOfBinaryPartitions++;
        partNum++;
        dochVol.numOfBinaryPartitions = numOfBinaryPartitions;
        binUserParams++;
	}

	/* fix the partition size to be zero - spend on the reminder of the disk
	   required for last partition */
	FP3->BDTLPartitionInfo[FP3->noOfBDTLPartitions-1].length = 0;

	/*Perform for every bdtl partition*/
	/*--------------------------------*/
	bdtlUserParams = FP3->BDTLPartitionInfo;
	for(i=0; i< FP3->noOfBDTLPartitions; i++)
	{
#ifdef HW_PROTECTION
		/*DPS Emulation
		  -----------*/
		if( (bdtlUserParams->protectionType & PROTECTABLE) &&
			(tffscmp(bdtlUserParams->protectionKey, noPasskey, TFFS_PROTECTION_KEY_LENGTH) != 0) )
		{
			/*Check if passkey is identical to next partition*/
            if (i < (FP3->noOfBDTLPartitions-1))
            {
                if((tffscmp(bdtlUserParams->protectionKey, bdtlUserParams[1].protectionKey,
                                                         sizeof(bdtlUserParams->protectionKey))== 0) &&
                    (bdtlUserParams->protectionType == bdtlUserParams[1].protectionType))
                {
                    dpsFwd[partNum] = TRUE;
                    dpsBwd[partNum + 1] = TRUE;
                }
            }
			/*Special case, check if 1st bdtl has the same passkey as previously last
			  formatted partition*/
			if(i == 0)
			{
				if((FP3->noOfBinaryPartitions == 0) && (binParToLeave > 0))
				{
					FLStatus tmpStatus = tffsApiAuthPartition(&myIoreq, ioreq, (FLByte)(lastRemainingPartition-1),
											bdtlUserParams->protectionKey, sizeof(bdtlUserParams->protectionKey));
					switch(tmpStatus)
					{
					case flOK:
						dpsFwd[partNum-1] = TRUE;
						dpsBwd[partNum] = TRUE;
						break;
					case flWrongKey:
					case flNotProtected:
						break;
					default:
						return tmpStatus;
					}
				}
			}
		}
#endif /*HW_PROTECTION*/

        /*	Fill DOCH_PartitionFormatInfoAPI structure from FormatParams3 structure */
		/*==========================================================================*/
		tffsset(intBuf, 0, sizeof(DOCH_PartitionFormatInfoAPI));

		/* standard migration format params */
		TFFS_API_SET_MIG_STD_PART_PRMS(pPartitionFormatInfoAPI, bdtlUserParams->protectionType);

		/* protection features */
		checkStatus( tffsFormatSetProtectionAttribs(bdtlUserParams->protectionType, pPartitionFormatInfoAPI,
			bdtlUserParams->protectionKey, sizeof(bdtlUserParams->protectionKey)) );

		/*Partition size*/
		/*--------------*/
		switch(bdtlUserParams->lengthType)
		{
		case FL_LENGTH_IN_BYTES:
			/*Convert to Sectors*/
			pPartitionFormatInfoAPI->nPartitionSize =
                (bdtlUserParams->length & 0x1FF) ?
                ((bdtlUserParams->length)>>DOCH_SECTOR_SIZE_BITS)+1 : ((bdtlUserParams->length)>>DOCH_SECTOR_SIZE_BITS);
			break;

		case FL_LENGTH_IN_SECTORS:
			/*Already in sectors*/
			pPartitionFormatInfoAPI->nPartitionSize = bdtlUserParams->length;
			break;

		case FL_LENGTH_IN_UNITS:
			pPartitionFormatInfoAPI->nPartitionSize = (bdtlUserParams->length << DOCH_SECTORS_IN_UNIT_BITS);
			break;

		case FL_LENGTH_IN_PERCENTS:
			/*Not supported*/
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): FL_LENGTH_IN_PERCENTS Not supported\r\n ");
			return flBadParameter;

		case FL_LENGTH_IN_CYLINDERS:
			/*Not supported*/
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): FL_LENGTH_IN_CYLINDERS Not supported\r\n ");
			return flBadParameter;

		default:
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Unsupported Normal area length type\r\n ");
			return flBadParameter;
		}

		/*Round partition size to Unit Size*/
		/*---------------------------------*/
		pPartitionFormatInfoAPI->nPartitionSize =
                    ((pPartitionFormatInfoAPI->nPartitionSize +
                    dochVol.dwVirtualUnitSizeInSectors - 1) & (~(dochVol.dwVirtualUnitSizeInSectors-1)));

		/*Fast area size*/
		/*--------------*/
		switch(bdtlUserParams->fastAreaLengthType)
		{
		case FL_LENGTH_IN_BYTES:
			pPartitionFormatInfoAPI->nFastAreaSize = (bdtlUserParams->fastAreaLength >> DOCH_SECTOR_SIZE_BITS);
			pPartitionFormatInfoAPI->dwFastAreaSizeType = DOCH_FAST_AREA_TYPE_SECTORS;
			break;

		case FL_LENGTH_IN_SECTORS:
			pPartitionFormatInfoAPI->nFastAreaSize = bdtlUserParams->fastAreaLength;
			pPartitionFormatInfoAPI->dwFastAreaSizeType = DOCH_FAST_AREA_TYPE_SECTORS;
			break;

		case FL_LENGTH_IN_UNITS:
			/*Not supported*/
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): FL_LENGTH_IN_UNITS Not supported\r\n ");
			return flBadParameter;
			/*break;*/

		case FL_LENGTH_IN_PERCENTS:
			pPartitionFormatInfoAPI->nFastAreaSize = bdtlUserParams->fastAreaLength;
			pPartitionFormatInfoAPI->dwFastAreaSizeType = DOCH_FAST_AREA_TYPE_PERCENT;
			break;

		case FL_LENGTH_IN_CYLINDERS:
			/*Not supported*/
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): FL_LENGTH_IN_CYLINDERS Not supported\r\n ");
			return flBadParameter;
			/*break;*/

		default:
			DBG_PRINT_ERR(FLZONE_API, "TFFSflashFormat(): Unsupported Fast area length type\r\n ");
			return flBadParameter;
			/*break;*/
		}
		pPartitionFormatInfoAPI->wFastAreaFactor = bdtlUserParams->fastAreaVirtualFactor;

		/*Add partition*/
		/*-------------*/
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf,0,0);
		rc = flDOCHAddPartition(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHAddPartition (Bdtl) failed with status: 0x%x "), rc));
			return TFFS_API_RET(rc);
		}

		/*Authenticate partition*/
		if(((bdtlUserParams->protectionType & PROTECTABLE) ==	PROTECTABLE) &&
			(bdtlUserParams->protectionType & (READ_PROTECTED | WRITE_PROTECTED)) != 0)
		{
			checkStatus( tffsApiAuthPartition(&myIoreq, ioreq, partNum,
				bdtlUserParams->protectionKey, sizeof(bdtlUserParams->protectionKey)) );
		}

		/*Retrieve current atttributes*/
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (partNum << 4), 0,0, intBuf,0,0);
		rc = flDOCHGetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
		}

		/*Set type to BDTL*/
        pPartitionUserAttrWithBinary->bType = PARTITION_TYPE_BDTL;
		/*Set DPS attribute*/
		pPartitionUserAttrWithBinary->bDPSFwd = dpsFwd[partNum];
		pPartitionUserAttrWithBinary->bDPSBwd = dpsBwd[partNum];
		/*Set protection attribute*/
		pPartitionUserAttrWithBinary->bChangableProtection = ((bdtlUserParams->protectionType & CHANGEABLE_PROTECTION) == CHANGEABLE_PROTECTION);
		pPartitionUserAttrWithBinary->bProtected			= ((bdtlUserParams->protectionType & PROTECTABLE) == PROTECTABLE);
		/*Set attributes back to device*/
		rc = flDOCHSetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
		}

		/*Authenticate partition*/
		if (((bdtlUserParams->protectionType & PROTECTABLE) ==	PROTECTABLE) &&
            ((ioreq->irFlags & TL_DO_NOT_PERFORM_DOWNLOAD) == 0))
		{
			tffsset(&myIoreq, 0, sizeof(myIoreq));
            myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
			DOCH_SET_PARTITION_TO_IOREQ_HANDLE(&myIoreq, partNum);
            myIoreq.irFlags = DOCH_ACCESS_USER_PASSWORD;
			rc = flDOCHDisablePartAccess(&myIoreq);
		    if(rc != DOCH_OK)
		    {
			    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHDisablePartAccess failed with status: 0x%x "), rc));
			    return TFFS_API_RET(rc);
		    }
		}
        partNum++;
		bdtlUserParams++;
	}
	return flOK;
}/* TFFSFlashFormat() */


/*----------------------------------------------------------------------*/
/*                          T F F S U n f o r m a t                     */
/*                                                                      */
/* Erase the entire media returning the DiskOnChip to it's virgin state */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irPath   : Pointer to progress call back routine, or NULL     */
/*        irFlags  : reserved ( 0 )                                     */
/*        irData   : reserved (NULL)					                */
/*        irLength : reserved ( 0 )					                    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
FLStatus TFFSUnFormat(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	rc = flDOCHUnformatDevice(tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,0,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSUnFormat(): flDOCHUnformatDevice failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
	}
	return flOK;
}/*TFFSUnFormat()*/



/*----------------------------------------------------------------------*/
/*                          T F F S E r a s e B D                       */
/*                                                                      */
/* Erase a single partition making sure all it's data is				*/
/* permanently erased and can not be reconstructed.                     */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle : Socket number (0, 1, ...)                          */
/*                   Partition number must be 0                         */
/*        irPath   : Pointer to progress call back routine, or NULL     */
/*        irFlags  : reserved ( 0 )                                     */
/*        irData   : reserved (NULL)					                */
/*        irLength : reserved ( 0 )					                    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus  : 0 on success, otherwise failed                    */
/*----------------------------------------------------------------------*/
FLStatus TFFSEraseBD(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
    FLDword numOfSectors;
	LEulong * secureDeleteBuf = (LEulong *)(dochVol.intermediateBuf + DOCH_SECURE_DELETE_DATA_OFFSET);

	/*Retrieve partition size*/
	/*-----------------------*/
	tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0, dochVol.intermediateBuf,0,0);
    rc = flDOCHPartitionInfo(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSEraseBD(): flDOCHPartitionInfo failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc);
	}
    numOfSectors = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->nPartitionSize;

	/*Erase the entire partition*/
	/*--------------------------*/
    tffsset(dochVol.intermediateBuf, 0, DOCH_SECTOR_SIZE);
	toLE4( (*secureDeleteBuf), (FLDword)0);
	toLE4( (*(secureDeleteBuf+1)), (FLDword)numOfSectors);
	tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0, dochVol.intermediateBuf,0,1);
	rc = flDOCHWipeSectors(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSEraseBD(): flDOCHErasePartition failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, TFFS_API_RET(rc));
	}
    return flOK;
}/*TFFSEraseBD()*/
#endif /*FL_FORMAT_VOLUME*/
#endif /*FL_READ_ONLY*/

#ifdef FL_ABS_READ_WRITE
/*----------------------------------------------------------------------*/
/*                           f l A b s R e a d                          */
/*                                                                      */
/* Reads absolute sectors by sector no.                                 */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Address of user buffer to read into         */
/*        irSectorNo      : First sector no. to read (sector 0 is the   */
/*                          DOS boot sector).                           */
/*        irSectorCount   : Number of consecutive sectors to read       */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually read				*/
/*----------------------------------------------------------------------*/
FLStatus TFFSAbsRead(IOreq* ioreq, FLSDword * pIrCount)
{
	DOCH_Error rc;
	FLSDword dwsOrigIrCount=ioreq->irCount; /*einat*/

	/*Read required sectors*/
	/*---------------------*/
#ifdef FL_DMA_CONFIG
	if( (((FLDword)ioreq->irData & 3) == 0) && (gIsDMAEnabled == DOCH_GLOBAL_BOOL_PATTERN) )
	{
        ioreq->irFlags |= DOCH_USE_DMA;
#ifdef FL_USE_BURST_MODE_READ
		ioreq->irFlags |= DOCH_USE_BURST;
#endif /* FL_USE_BURST_MODE_READ */
	}
#endif /* FL_DMA_CONFIG */

	rc = flDOCHReadPartitionSectors(ioreq);
	if(rc != DOCH_OK)
	{
		(*pIrCount) = dwsOrigIrCount - ioreq->irCount; /*update number of sectors which is read */
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsRead(): flDOCHReadPartitionSectors failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, flReadFault);
	}

	(*pIrCount) = dwsOrigIrCount;
	return flOK;
}/*TFFSAbsRead()*/


/*----------------------------------------------------------------------*/
/* Function name   : TFFSAbsAddress*/
/* Description     : dummy function */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSAbsAddress(IOreq* ioreq)
{
    return flFeatureNotSupported;
}/*TFFSAbsAddress()*/


#ifndef FL_READ_ONLY
/*----------------------------------------------------------------------*/
/*                         f l A b s W r i t e                          */
/*                                                                      */
/* Writes absolute sectors by sector no.                                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irData          : Address of user buffer to write from        */
/*        irSectorNo      : First sector no. to write                   */
/*        irSectorCount   : Number of consecutive sectors to write     */
/*																		*/
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually written          */
/*----------------------------------------------------------------------*/
FLStatus TFFSAbsWrite(IOreq* ioreq)
{
	DOCH_Error rc;
	FLSDword dwOrigIrCount = ioreq->irCount;

#ifdef FL_VERIFY_WRITE
	FLDword i = 0;
	FLDword firstSectorToVerify = ioreq->irSectorNo;
	FLDword NumOfSectorsToVerify = ioreq->irSectorCount;
	FLByte* buf = (FLByte*)ioreq->irData;
    FLBoolean verify = dochVol.verifyWrite;
    IOreq myIoreq;
#endif /*FL_VERIFY_WRITE*/

	/*Write required sectors*/
#ifdef FL_USE_DMA_ON_WRITE /* should be changed to FL_DMA_CONFIG */
   if( (((FLDword)ioreq->irData & 3) == 0) && (gIsDMAEnabled == DOCH_GLOBAL_BOOL_PATTERN) )
        ioreq->irFlags |= DOCH_USE_DMA;
#endif /*FL_USE_DMA_ON_WRITE*/
    rc = flDOCHWritePartitionSectors(ioreq);
	if(rc != DOCH_OK)
	{
#ifdef FL_VERIFY_WRITE
		ioreq->irCount = 0; /*update number of sectors which is written */
#else/*FL_VERIFY_WRITE*/
		ioreq->irCount = dwOrigIrCount - ioreq->irCount; /*update number of sectors which is written */
#endif /*FL_VERIFY_WRITE*/
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsWrite(): flDOCHWritePartitionSectors failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
	}

#ifdef FL_VERIFY_WRITE
	if(verify)
	{
		tffsset( &myIoreq, 0, sizeof(myIoreq) );
        myIoreq.irHandle = ioreq->irHandle;
		while(i < NumOfSectorsToVerify)
		{ /* sector by sector verification -> burst and/or DMA modes dont matter */
			myIoreq.irSectorNo = firstSectorToVerify + i;
			myIoreq.irSectorCount = 1;
			myIoreq.irData = &dochVol.intermediateBuf;
            myIoreq.irFlags = 0;
			rc = flDOCHReadPartitionSectors(&myIoreq);
			if(rc != DOCH_OK)
			{
				ioreq->irCount = i-1; /*update number of sectors which is written and verified*/
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsWrite(): flDOCHReadPartitionSectors (VERIFY) failed with status: 0x%x "), rc));
				return flWriteFault;
			}
			if(tffscmp(buf, dochVol.intermediateBuf, DOCH_SECTOR_SIZE) != 0)
			{
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsWrite(): VERIFY failed with status: 0x%x "), rc));
				return flWriteFault;
			}
			buf += DOCH_SECTOR_SIZE;
			i++;
		}/* while */
	}/* verify on */
#endif /*FL_VERIFY_WRITE*/

	ioreq->irCount = dwOrigIrCount;
	return flOK;
}/*TFFSAbsWrite()*/

/*----------------------------------------------------------------------*/
/*                         f l A b s D e l e t e                        */
/*                                                                      */
/* Marks absolute sectors by sector no. as deleted.                     */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                            bits 7-4 - Partition # (zero based)       */
/*                            bits 3-0 - Socket # (zero based)          */
/*        irSectorNo      : First sector no. to delete                  */
/*        irSectorCount   : Number of consecutive sectors to delete     */
/*																		*/
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually deleted			*/
/*----------------------------------------------------------------------*/
FLStatus TFFSAbsDelete(IOreq* ioreq)
{
	DOCH_Error rc;

	/*Free required sectors*/
	/*---------------------*/
	rc = flDOCHFreeSectors(ioreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsDelete(): flDOCHFreeSectors failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, TFFS_API_RET(rc));
	}
	return flOK;
}/*TFFSAbsDelete*/

/*----------------------------------------------------------------------*/
/*                 f l A b s S e c u r e D e l e t e                    */
/*                                                                      */
/* Marks absolute sectors by sector no. as deleted making sure no       */
/* previous copy exists.                                                */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irSectorNo      : First sector no. to delete                  */
/*        irSectorCount   : Number of consecutive sectors to delete    */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irSectorCount   : Number of sectors actually deleted			*/
/*----------------------------------------------------------------------*/
FLStatus TFFSAbsSecureDelete(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	LEulong * secureDeleteBuf = (LEulong *)(dochVol.intermediateBuf + DOCH_SECURE_DELETE_DATA_OFFSET);

	/* Convert standard ioreq to DOCH ioreq parameters */
	/*------------------------------*/
	tffsset( dochVol.intermediateBuf, 0, FL_SECTOR_SIZE );
	toLE4( (*secureDeleteBuf), (FLDword)ioreq->irSectorNo);
	toLE4( (*(secureDeleteBuf+1)), (FLDword)ioreq->irSectorCount);
	/*Erase(delete) required sectors*/
	/*------------------------------*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,1);
	rc = flDOCHWipeSectors(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSAbsSecureDelete(): flDOCHEraseSectors failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, TFFS_API_RET(rc));
	}
	return flOK;
}/*TFFSAbsSecureDelete()*/

#endif /*FL_READ_ONLY*/
#endif /*FL_ABS_READ_WRITE*/

/*----------------------------------------------------------------------*/
/*            f l G e t P h y s i c a l I n f o							*/
/*                                                                      */
/* Get physical information of the media. The information includes      */
/* JEDEC ID, unit size and media size.                                  */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Socket number (0,1,..)                      */
/*        irData          : Address of user buffer to read physical     */
/*                          information into.                           */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irLength        : Window base address. note mast be cast to   */
/*                          unsigned.                                   */
/*----------------------------------------------------------------------*/
FLStatus TFFSGetPhysicalInfo(IOreq* ioreq)
{
	IOreq myIoreq;
	DOCH_Error rc = DOCH_OK;
	PhysicalInfo FAR1 * physicalInfo = (PhysicalInfo FAR1 *)ioreq->irData;

	/*Retrieve extended disk info*/
	/*---------------------------*/
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	/*Fill PhysicalInfo structure*/
	/*---------------------------*/
	physicalInfo->type = 0;/*docDeviceInfo.wFlashType;*/
	physicalInfo->mediaType = FL_H3;
	physicalInfo->dwUnitSize = dochVol.dwVirtualUnitSizeInSectors;
	physicalInfo->dwMediaSize = ((DOCH_DeviceInfo*)dochVol.intermediateBuf)->dwUnformattedCapacity;
	physicalInfo->dwChipSize = physicalInfo->dwMediaSize;
	physicalInfo->interleaving = 0;

	/* Return window base reg */
	/*------------------------*/
	tffsAPISetIoreq( &myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,0,0,0);
	rc=flDOCHGetPhysicalAddress(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetPhysicalInfo(): DOCHGetPhysicalAddress failed with status: 0x%x "), rc));
		return (DOCH_DiskNotFound==rc) ? flAdapterNotFound : TFFS_API_RET(rc);
	}
	ioreq->irLength = myIoreq.irCount;
	return flOK;
}/*TFFSGetPhysicalInfo()*/



#ifdef BDK_ACCESS


/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkReadInit*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkReadInit(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
    FLByte subPart;
	IOreq myIoreq;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
	DOCH_PartitionUserAttrWithBinary* pPartitionUserAttrWithBinary = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;

	/* retrieve device information */
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

    /*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadInit(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

	for(subPart=0;
        subPart < pPartitionUserAttrWithBinary->binPartHeader.bNumOfSubPartitions;
        subPart++)
	{
		if (tffscmp(pPartitionUserAttrWithBinary->binPartHeader.subPartitions[subPart].bSignature,
            bdkStrct->oldSign, BDK_SIGNATURE_NAME) == 0)
            break;
	}
	if(subPart >= pPartitionUserAttrWithBinary->binPartHeader.bNumOfSubPartitions)
	{ /*If oldSign was not found on the partition - return error*/
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadInit(): findSubPartBySignature failed with status: 0x%x "), rc));
		return flPartitionNotFound;
	}
    if( ((bdkStrct->length >>DOCH_SECTOR_SIZE_BITS) + (bdkStrct->startingBlock * dochVol.dwVirtualUnitSizeInSectors)) >
        pPartitionUserAttrWithBinary->binPartHeader.subPartitions[subPart].dwSize )
    {
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkReadInit(): recieved length exceeds partition size.\r\n");
		return flBadParameter;
    }
	/*Save operation init values for actual read operation*/
    dochVol.bdkInitValues.dwStartReadSector = bdkStrct->startingBlock * dochVol.dwVirtualUnitSizeInSectors +
        pPartitionUserAttrWithBinary->binPartHeader.subPartitions[subPart].dwOffset;
    dochVol.bdkInitValues.dwCurrentReadByte = 0;
    dochVol.bdkInitValues.dwReadLength = bdkStrct->length;
	return flOK;
}/*TFFSbdkReadInit()*/


/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkReadBlock*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkReadBlock(IOreq* ioreq)
{
#ifndef FL_ABS_READ_WRITE
	return flFeatureNotSupported;
#else /*FL_ABS_READ_WRITE*/
	DOCH_Error dochErr = DOCH_FeatureNotSupported;
	IOreq myIoreq;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
	FLByte* buf = bdkStrct->bdkBuffer;
    FLDword byteOffsetInSector = (dochVol.bdkInitValues.dwCurrentReadByte % DOCH_SECTOR_SIZE);
    FLDword currentSector = dochVol.bdkInitValues.dwStartReadSector +
                            (dochVol.bdkInitValues.dwCurrentReadByte >> DOCH_SECTOR_SIZE_BITS);
	FLDword fullSectorsToRead, bytesToPad;
    FLWord wBytesToCopy;

    if (byteOffsetInSector != 0)
    {
        wBytesToCopy = (FLWord)TFFSMIN(DOCH_SECTOR_SIZE - byteOffsetInSector, bdkStrct->length);
        fullSectorsToRead = (bdkStrct->length - wBytesToCopy)>>DOCH_SECTOR_SIZE_BITS;
        bytesToPad = bdkStrct->length -  wBytesToCopy - (fullSectorsToRead << DOCH_SECTOR_SIZE_BITS);
    }
    else
    {
        fullSectorsToRead = bdkStrct->length >>DOCH_SECTOR_SIZE_BITS;
        bytesToPad = bdkStrct->length - (fullSectorsToRead << DOCH_SECTOR_SIZE_BITS);
    }

    if (dochVol.bdkInitValues.dwCurrentReadByte + bdkStrct->length > dochVol.bdkInitValues.dwReadLength)
    {
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkReadBlock(): Attempted reading out of readInit aread.\r\n");
		return flBadParameter;
    }
	/*Read NOT from start of sector*/
	if(byteOffsetInSector != 0)
	{
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
		dochErr = flDOCHReadPartitionSectors(&myIoreq);
		if(dochErr != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadBlock(): TFFSAbsRead failed with status: 0x%x "), dochErr));
			TFFS_API_RET_PART_FLSTATUS(dochErr, flReadFault);
		}
        wBytesToCopy = (FLWord)TFFSMIN(DOCH_SECTOR_SIZE - byteOffsetInSector, bdkStrct->length);
		tffscpy(buf, &dochVol.intermediateBuf[byteOffsetInSector], wBytesToCopy);
        dochVol.bdkInitValues.dwCurrentReadByte += wBytesToCopy;
        byteOffsetInSector  = (byteOffsetInSector + wBytesToCopy)% DOCH_SECTOR_SIZE;
		buf += wBytesToCopy;
        if ((byteOffsetInSector % DOCH_SECTOR_SIZE) == 0)
            currentSector++;
	}

	/*Read requested sectors, use init values from TFFSbdkReadInit*/
	if(fullSectorsToRead > 0)
	{
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,buf,currentSector,fullSectorsToRead);
#ifdef FL_DMA_CONFIG
		if( (((FLDword)myIoreq.irData & 3) == 0) && (gIsDMAEnabled == DOCH_GLOBAL_BOOL_PATTERN) )
		{
			myIoreq.irFlags |= DOCH_USE_DMA;
#ifdef FL_USE_BURST_MODE_READ
			myIoreq.irFlags |= DOCH_USE_BURST;
#endif /* FL_USE_BURST_MODE_READ */
		}
#endif /* FL_DMA_CONFIG */
		dochErr = flDOCHReadPartitionSectors(&myIoreq);
		if(dochErr != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadBlock(): TFFSAbsRead failed with status: 0x%x "), dochErr));
			TFFS_API_RET_PART_FLSTATUS(dochErr, flReadFault);
		}
		buf += (fullSectorsToRead<<DOCH_SECTOR_SIZE_BITS);
        dochVol.bdkInitValues.dwCurrentReadByte += (fullSectorsToRead<<DOCH_SECTOR_SIZE_BITS);
        currentSector += fullSectorsToRead;
	}

	/*Complete last sector*/
	if(bytesToPad != 0)
	{
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
		dochErr = flDOCHReadPartitionSectors(&myIoreq);
		if(dochErr != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadBlock(): TFFSAbsRead failed with status: 0x%x "), dochErr));
			TFFS_API_RET_PART_FLSTATUS(dochErr, flReadFault);
		}
        tffscpy(buf, dochVol.intermediateBuf, bytesToPad);
        dochVol.bdkInitValues.dwCurrentReadByte += bytesToPad;
	}

	if(dochErr != flOK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadBlock(): TFFSAbsRead failed with status: 0x%x "), dochErr));
		TFFS_API_RET_PART_FLSTATUS(dochErr, flReadFault);
	}
	return flOK;
#endif /*FL_ABS_READ_WRITE*/
}/*TFFSbdkReadBlock()*/

#ifndef FL_READ_ONLY
/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkWriteInit*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkWriteInit(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;
    FLByte subPart;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
    DOCH_PartitionUserAttrWithBinary* attrSectorPtr = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;;

	/* retrieve the unit size and other information */
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	/*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadInit(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

	for(subPart=0;
        subPart < attrSectorPtr->binPartHeader.bNumOfSubPartitions;
        subPart++)
	{
		if (tffscmp(attrSectorPtr->binPartHeader.subPartitions[subPart].bSignature,
            bdkStrct->oldSign, BDK_SIGNATURE_NAME) == 0)
            break;
	}
	if(subPart >= attrSectorPtr->binPartHeader.bNumOfSubPartitions)
	{ /*If oldSign was not found on the partition - return error*/
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkReadInit(): findSubPartBySignature failed with status: 0x%x "), rc));
		return flPartitionNotFound;
	}

	if( ((bdkStrct->length >>DOCH_SECTOR_SIZE_BITS) + (bdkStrct->startingBlock * dochVol.dwVirtualUnitSizeInSectors)) >
			attrSectorPtr->binPartHeader.subPartitions[subPart].dwSize )
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkWriteInit(): requested size exceeds subpartition size");
		return flBadParameter;
	}

	/*Save operation init values for actual write operation*/
    dochVol.bdkInitValues.dwStartWriteSector = bdkStrct->startingBlock * dochVol.dwVirtualUnitSizeInSectors +
        attrSectorPtr->binPartHeader.subPartitions[subPart].dwOffset;
    dochVol.bdkInitValues.dwCurrentWriteByte = 0;
    dochVol.bdkInitValues.dwWriteLength = bdkStrct->length;
    dochVol.bdkInitValues.bWriteSubPartitionNum = subPart;
	return flOK;
}/*TFFSbdkWriteInit()*/

/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkWriteBlock*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkWriteBlock(IOreq* ioreq)
{
#ifndef FL_ABS_READ_WRITE
	return flFeatureNotSupported;
#else /*FL_ABS_READ_WRITE*/
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
    DOCH_PartitionUserAttrWithBinary* attrSectorPtr;
    FLByte* userBuf;
    FLWord wBytesToCopy, wBytesToPad;
    FLDword currentSector, byteOffsetInSector;
    FLDword fullSectorsToWrite;
    FLDword dwUsedSize;

    byteOffsetInSector = (dochVol.bdkInitValues.dwCurrentWriteByte % DOCH_SECTOR_SIZE);
    currentSector = dochVol.bdkInitValues.dwStartWriteSector +
                            (dochVol.bdkInitValues.dwCurrentWriteByte >> DOCH_SECTOR_SIZE_BITS);
    wBytesToCopy = (FLWord)TFFSMIN(DOCH_SECTOR_SIZE - byteOffsetInSector, bdkStrct->length);
    userBuf = bdkStrct->bdkBuffer;
    if (byteOffsetInSector)
    {
        fullSectorsToWrite = (bdkStrct->length - wBytesToCopy)>>DOCH_SECTOR_SIZE_BITS;
        wBytesToPad =   (FLWord)(bdkStrct->length -  wBytesToCopy - (fullSectorsToWrite << DOCH_SECTOR_SIZE_BITS));
    }
    else
    {
        fullSectorsToWrite = bdkStrct->length >>DOCH_SECTOR_SIZE_BITS;
        wBytesToPad = (FLWord)(bdkStrct->length - (fullSectorsToWrite << DOCH_SECTOR_SIZE_BITS));
    }


    /*If first sector is NOT aligned:
	- Read it
	- Copy contiguous data
	- Write sector
	==============*/
	if(byteOffsetInSector != 0)
	{
		/*Read*/
	   tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
#ifdef FL_USE_BURST_MODE_READ
       /* TODO - update myIoreq.irFlags */
#endif /*FL_USE_BURST_MODE_READ*/
		rc = flDOCHReadPartitionSectors(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Reading sector for padding failed with status: 0x%x "), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
		}

		/*Copy*/
        wBytesToCopy = (FLWord)TFFSMIN(DOCH_SECTOR_SIZE - byteOffsetInSector, bdkStrct->length);
		tffscpy(dochVol.intermediateBuf + byteOffsetInSector, userBuf, wBytesToCopy);

		/*Write*/
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
		rc = flDOCHWritePartitionSectors(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Writing sector after padding failed with status: 0x%x \r\n"), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
		}
		userBuf += wBytesToCopy;
        dochVol.bdkInitValues.dwCurrentWriteByte += wBytesToCopy;

        byteOffsetInSector  = (byteOffsetInSector + wBytesToCopy)% DOCH_SECTOR_SIZE;
        if (byteOffsetInSector == 0)
            currentSector++;

	}

	/*Write requested sectors, use init values from TFFSbdkWriteInit*/
	if(fullSectorsToWrite > 0)
	{
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,userBuf,currentSector,fullSectorsToWrite);
#ifdef FL_USE_DMA_ON_WRITE /*should be changed to #ifdef FL_DMA_CONFIG*/
		if( (((FLDword)userBuf & 3) == 0) && (gIsDMAEnabled == DOCH_GLOBAL_BOOL_PATTERN) )
		{
			myIoreq.irFlags |= DOCH_USE_DMA;
		}
#endif /*FL_USE_DMA_ON_WRITE*/
		rc = flDOCHWritePartitionSectors(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Writing contiguous sectors failed with status:0x%x \r\n"), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
		}

		userBuf += (fullSectorsToWrite<<DOCH_SECTOR_SIZE_BITS);
        currentSector += fullSectorsToWrite;
        dochVol.bdkInitValues.dwCurrentWriteByte += (fullSectorsToWrite<<DOCH_SECTOR_SIZE_BITS);
	}

	/*Complete last sector*/
	if(wBytesToPad != 0)
	{
		/*Read*/
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
		rc = flDOCHReadPartitionSectors(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Reading sector for padding failed with status: 0x%x "), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
		}

		/*Copy*/
		tffscpy(dochVol.intermediateBuf, userBuf, wBytesToPad);

		/*Write*/
		tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,currentSector,1);
		rc = flDOCHWritePartitionSectors(&myIoreq);
		if(rc != DOCH_OK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Writing sector after padding failed with status: 0x%x \r\n"), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
		}
		userBuf += wBytesToPad;
        dochVol.bdkInitValues.dwCurrentWriteByte += wBytesToPad;
        byteOffsetInSector  = (byteOffsetInSector + wBytesToPad)% DOCH_SECTOR_SIZE;
        if (byteOffsetInSector == 0)
            currentSector++;
	}

	/*write operation was successful, update usesize*/
	/*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
    {
        DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Getting partition attributes failed with status: 0x%x \r\n"), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
    }
    attrSectorPtr = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
    dwUsedSize = attrSectorPtr->binPartHeader.subPartitions[dochVol.bdkInitValues.bWriteSubPartitionNum].dwUsedSize;
    if ((dwUsedSize << DOCH_SECTOR_SIZE_BITS) < (FLDword)(dochVol.bdkInitValues.dwCurrentWriteByte))
    {
        dwUsedSize = attrSectorPtr->binPartHeader.subPartitions[dochVol.bdkInitValues.bWriteSubPartitionNum].dwUsedSize;
        dwUsedSize += fullSectorsToWrite + (wBytesToPad ? 1:0);
        attrSectorPtr->binPartHeader.subPartitions[dochVol.bdkInitValues.bWriteSubPartitionNum].dwUsedSize = dwUsedSize;

        rc = flDOCHSetParitionUserAttributes(&myIoreq);
		if(rc != DOCH_OK)
        {
            DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkWriteBlock(): Getting partition attributes failed with status: 0x%x \r\n"), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
        }
    }
	return flOK;
#endif /*FL_ABS_READ_WRITE*/
}/*TFFSbdkWriteBlock()*/


/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkErase*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkErase(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
	FLSNative binPartNum = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
	FLSNative unitsToDelete = bdkStrct->length;/*((bdkStrct->length / BDK_UNIT_SIZE) + 1);*/
	FLDword lastDeletedSector, dwSubPartOffset;
    DOCH_PartitionUserAttrWithBinary* attrSectorPtr;
    FLByte bSubPart;
	LEulong * secureDeleteBuf = (LEulong *)(dochVol.intermediateBuf + DOCH_SECURE_DELETE_DATA_OFFSET);

	/*get unit size etc*/
	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	/*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkErase(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

    attrSectorPtr = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	for(bSubPart=0;
        bSubPart < attrSectorPtr->binPartHeader.bNumOfSubPartitions;
        bSubPart++)
	{
		if (tffscmp(attrSectorPtr->binPartHeader.subPartitions[bSubPart].bSignature,
            bdkStrct->oldSign, BDK_SIGNATURE_NAME) == 0)
            break;
	}
	if(bSubPart >= attrSectorPtr->binPartHeader.bNumOfSubPartitions)
	{ /*If oldSign was not found on the partition - return error*/
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkErase(): findSubPartBySignature failed with status: 0x%x "), rc));
		return flPartitionNotFound;
	}

    if (((bdkStrct->startingBlock + unitsToDelete) * dochVol.dwVirtualUnitSize) >
            (attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize << DOCH_SECTOR_SIZE_BITS))
    {
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkErase(): Erase requested for more than partition size. ");
		return flNoSpaceInVolume;
    }

	/* save the offset */
	dwSubPartOffset = attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwOffset;
	/*  update used size */
	lastDeletedSector = ((bdkStrct->startingBlock + unitsToDelete) * dochVol.dwVirtualUnitSizeInSectors);
	if(lastDeletedSector >= attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwUsedSize )
    {	/*Update used size only if exceeds current used size*/
        attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwUsedSize =
            (bdkStrct->startingBlock + dochVol.dwVirtualUnitSizeInSectors - 1) & (~(dochVol.dwVirtualUnitSizeInSectors - 1));

       /*Set modified atttributes*/
		tffsAPISetIoreq( &myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq) + (binPartNum << 4),0,0,dochVol.intermediateBuf,0,0);
        rc = flDOCHSetParitionUserAttributes(&myIoreq);
        if(rc != DOCH_OK)
        {
            DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkErase(): flDOCHSetParitionUserAttributes failed with status: 0x%x "), rc));
			return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
        }
    }


	/* Delete sectors as unit size - 1 unit always deleted */
	tffsset(dochVol.intermediateBuf, 0, DOCH_SECTOR_SIZE);
	toLE4( (*secureDeleteBuf), (FLDword)(bdkStrct->startingBlock * dochVol.dwVirtualUnitSizeInSectors) + dwSubPartOffset);
	toLE4( (*(secureDeleteBuf+1)), (FLDword)dochVol.dwVirtualUnitSizeInSectors);
	tffsAPISetIoreq( &myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq) + (binPartNum << 4),0,0,dochVol.intermediateBuf,0,1);
	rc = flDOCHWipeSectors(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkErase(): flDOCHWipeSectors failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, TFFS_API_RET(rc));
	}

	return flOK;
}/*TFFSbdkErase()*/

/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkCreate*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkCreate(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;
    FLByte bSubPart;
	DOCH_PartitionUserAttrWithBinary* attrSectorPtr;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
	FLDword reqLength;
	FLByte newSPIndex;

	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	/*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkCreate(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

    attrSectorPtr = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	/*Check that this is actually a binary partition*/
	if(attrSectorPtr->bType != PARTITION_TYPE_BINARY)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkCreate(): Partition is NOT Binary \r\n");
		return flBadParameter;
	}

	for(bSubPart=0;
        bSubPart < attrSectorPtr->binPartHeader.bNumOfSubPartitions;
        bSubPart++)
	{
		if (tffscmp(attrSectorPtr->binPartHeader.subPartitions[bSubPart].bSignature,
            bdkStrct->oldSign, BDK_SIGNATURE_NAME) == 0)
            break;
	}
	if(bSubPart >= attrSectorPtr->binPartHeader.bNumOfSubPartitions)
	{ /*If oldSign was not found on the partition - return error*/
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkCreate(): findSubPartBySignature failed with status:0x%x "), rc));
		return flPartitionNotFound;
	}

	/*If new SP size equals in size - simply replace signature and return*/
    reqLength = bdkStrct->length * dochVol.dwVirtualUnitSizeInSectors;
	if( reqLength == 0 )
	{
		DBG_PRINT_WRN(FLZONE_API, "TFFSbdkCreate(): zero size subpartition requested ");
		return flNoSpaceInVolume;/*strange errors up to legacy devices*/
	}

	/* size match exactly -> replace signature */
	if(reqLength == attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize)
	{
		tffscpy(attrSectorPtr->binPartHeader.subPartitions[bSubPart].bSignature,
				bdkStrct->newSign, BDK_SIGNATURE_NAME);
    }
    else
    {
        /*Check that there is enough space in the current SP*/
        /*Check that max number of SP was not exceeded*/
        if(reqLength > (attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize << DOCH_SECTOR_SIZE_BITS))
        {
            DBG_PRINT_ERR(FLZONE_API, "TFFSbdkCreate(): No Space In Volume \r\n");
            return flNoSpaceInVolume;
        }
        else
		{
			if(attrSectorPtr->binPartHeader.bNumOfSubPartitions >= (SUB_PARTITIONS_PER_BINARY-1))
			{
				DBG_PRINT_ERR(FLZONE_API, "TFFSbdkCreate(): Too Many Binary Partitions \r\n");
				return flTooManyBinaryPartitions;
			}
		}
        /*Assign new SP number*/
        newSPIndex = attrSectorPtr->binPartHeader.bNumOfSubPartitions;

		/*Set current and new SP atttributes*/
        attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize -= reqLength;
        /*Set new SP atttributes*/
		attrSectorPtr->binPartHeader.subPartitions[newSPIndex].dwOffset =
			attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwOffset +
			attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize;
		attrSectorPtr->binPartHeader.subPartitions[newSPIndex].dwSize = reqLength;

        tffscpy(attrSectorPtr->binPartHeader.subPartitions[newSPIndex].bSignature,
                                                                bdkStrct->newSign,
                                                                BDK_SIGNATURE_NAME);
        /*Increment number of SP by 1*/
        attrSectorPtr->binPartHeader.bNumOfSubPartitions++;
    }

	/*Set modified atttributes*/
	tffsAPISetIoreq( &myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHSetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkCreate(): flDOCHSetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
	return flOK;
}/*TFFSbdkCreate()*/


#endif /*FL_READ_ONLY*/

/*----------------------------------------------------------------------*/
/* Function name   : TFFSbdkPartitionInfo*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*----------------------------------------------------------------------*/
FLStatus TFFSbdkPartitionInfo(IOreq* ioreq)
{
	DOCH_Error rc = DOCH_OK;
	IOreq myIoreq;
	DOCH_PartitionUserAttrWithBinary* attrSectorPtr;
	BDKStruct* bdkStrct = (BDKStruct*)(ioreq->irData);
    FLDword dwPartititonSize, dwUsedUnits;
	/*If oldSign was not found on the partition - return error*/
    FLByte bSubPart;

	TFFS_API_GET_UNIT_SIZE(myIoreq, ioreq, rc, flStatus);

	if( FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq) >= (dochVol.numOfBinaryPartitions+dochVol.otpExists+dochVol.iplExists) )
	{
		return flBadDriveHandle;
	}

    bdkStrct->flags         = dochVol.numOfBinaryPartitions; /*total number of BDK on the media*/

	tffsAPISetIoreq( &myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHPartitionInfo(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkPartitionInfo(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
    dwPartititonSize = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->nPartitionSize << DOCH_SECTOR_SIZE_BITS;

	/*Retrieve current atttributes*/
	tffsAPISetIoreq( &myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHGetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSbdkPartitionInfo(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

    attrSectorPtr = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	/*Check that this is actually a binary partition*/
	 if(attrSectorPtr->bType != PARTITION_TYPE_BINARY)
	 {
         DBG_PRINT_ERR(FLZONE_API, "TFFSbdkPartitionInfo(): Partition is NOT Binary \r\n");
		 return flBadParameter;
	 }

	for(bSubPart=0;
        bSubPart < attrSectorPtr->binPartHeader.bNumOfSubPartitions;
        bSubPart++)
	{
		if (tffscmp(attrSectorPtr->binPartHeader.subPartitions[bSubPart].bSignature,
            bdkStrct->oldSign, BDK_SIGNATURE_NAME) == 0)
            break;
	}
	if(bSubPart >= attrSectorPtr->binPartHeader.bNumOfSubPartitions)
	{ /*If oldSign was not found on the partition - return error*/
		DBG_PRINT_ERR(FLZONE_API, "TFFSbdkPartitionInfo(): Sub partition not found.");
		return flNoSpaceInVolume ; /* for compatibility with legacy devices */
	}

	/*Returned values*/
    dwUsedUnits = ((attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwUsedSize + dochVol.dwVirtualUnitSizeInSectors - 1)/ dochVol.dwVirtualUnitSizeInSectors);
	bdkStrct->length = dwUsedUnits * dochVol.dwVirtualUnitSize;
	if(bdkStrct->length == 0) /*Used size must be at least 1 unit*/
		bdkStrct->length = dochVol.dwVirtualUnitSizeInSectors << DOCH_SECTOR_SIZE_BITS;

	bdkStrct->startingBlock	= attrSectorPtr->binPartHeader.subPartitions[bSubPart].dwSize << DOCH_SECTOR_SIZE_BITS;
	ioreq->irLength			= dwPartititonSize;

	return flOK;
}/*TFFSbdkPartitionInfo()*/
#endif /*BDK_ACCESS*/

#ifdef HW_PROTECTION
/*----------------------------------------------------------------------*/
/*              f l I n s e r t P r o t e c t i o n K e y               */
/*              b d k I n s e r t P r o t e c t i o n K e y             */
/*                                                                      */
/* Insert the protection key in order to remove the protection of the   */
/* partition specified by the drive handle                             */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based), doch count  */
/*                        bits 3-0 - Socket # (zero based)              */
/*  irData           : pointer to an 8 bytes key array                  */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSInsertProtectionKey(IOreq* ioreq)
{
	IOreq myIoreq;
	FLByte bPartNum;
	FLStatus flStatus;

	/* Format DOCH_PartitionAcessPassword structure */
	/* Note that legacy devices has only 8 bytes passkey */
	/*-----------------------------------------------*/
	bPartNum = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
	flStatus = tffsApiAuthPartition(&myIoreq, ioreq, bPartNum, (FLByte *)ioreq->irData, PROTECTION_KEY_LENGTH );
	if( flStatus == flNotProtected )
		flStatus = flOK;

	return flStatus;
}/*TFFSInsertProtectionKey()*/
#endif /*HW_PROTECTION*/

#ifdef BDK_ACCESS

#endif /* BDK_ACCESS */

#ifdef HW_OTP
/*----------------------------------------------------------------------*/
/*                         f l O T P S i z e                            */
/*                                                                      */
/* Get the OTP size and state                                           */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        bits 3-0 - Socket # (zero based)              */
/*  irLength         : The size of the used OTP area in bytes           */
/*  irCount          : The size of the OTP area in bytes                */
/*  irFlags          : LOCKED_OTP for a locked area otherwise unlocked  */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSOTPSize(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	/*Get partition (OTP) info*/
	/*----------------------*/
	tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4),
						0,0,dochVol.intermediateBuf,0,0);
	rc = flDOCHPartitionInfo(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSOTPSize(): flDOCHPartitionInfo failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
	/*Returned values*/
	ioreq->irCount = TFFS_API_OTP_PART_SIZE;
    ioreq->irFlags = ((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->dwCommandFlagsOrStatuses & DOCH_CFSB_PERM_LOCKED) == DOCH_CFSB_PERM_LOCKED);
    if (ioreq->irFlags)
        ioreq->irLength = TFFS_API_OTP_PART_SIZE;
    else
        ioreq->irLength = 0;
	return flOK;
}/*TFFSOTPSize()*/

/*----------------------------------------------------------------------*/
/*                         f l O T P R e a d                            */
/*                                                                      */
/* Read OTP Partition		                                            */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*							bits 7-4 - Partition # (zero based)         */
/*							bits 3-0 - Socket # (zero based)            */
/*        irData          : Address of user buffer to read into         */
/*        irCount         : First byte to read.                         */
/*        irLength		  : Number of consecutive bytes to read	        */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSOTPRead(IOreq* ioreq)
{
#ifndef FL_ABS_READ_WRITE
	return flFeatureNotSupported;
#else /*FL_ABS_READ_WRITE*/
	FLStatus status = flReadFault;
	IOreq myIoreq;
	/*FLByte padSector[DOCH_SECTOR_SIZE];*/
	FLByte * padSector = dochVol.intermediateBuf;
	FLByte* buf = (FLByte*)ioreq->irData;
	FLDword firstByteInFirstSector = (ioreq->irCount % DOCH_SECTOR_SIZE);
	FLDword firstSector = (ioreq->irCount >> DOCH_SECTOR_SIZE_BITS);
	FLDword bytesToRead = ioreq->irLength;
	/* FLBoolean lessThenOneSector = FALSE; */
	FLDword padBytesInFirstSector, bytesInUnfullSector,fullSectorsToRead,bytesToPad;

	if((firstByteInFirstSector + bytesToRead) < DOCH_SECTOR_SIZE)
	{
		/* lessThenOneSector = TRUE; */
		padBytesInFirstSector = (DOCH_SECTOR_SIZE - (firstByteInFirstSector + bytesToRead));
		if(firstByteInFirstSector == 0)
			bytesInUnfullSector = bytesToRead;
		else
			bytesInUnfullSector = 0;
		fullSectorsToRead = 0;
		bytesToPad = padBytesInFirstSector;
	}
	else
	{
		padBytesInFirstSector = (firstByteInFirstSector == 0) ? 0 : (DOCH_SECTOR_SIZE - firstByteInFirstSector);
		bytesInUnfullSector = ((ioreq->irLength - padBytesInFirstSector) % DOCH_SECTOR_SIZE);
		fullSectorsToRead = ((ioreq->irLength - (padBytesInFirstSector + bytesInUnfullSector))>>DOCH_SECTOR_SIZE_BITS);
		bytesToPad = (bytesInUnfullSector == 0) ? 0 : (DOCH_SECTOR_SIZE - bytesInUnfullSector);
	}

	/*Read NOT from start of sector*/
	if(firstByteInFirstSector != 0)
	{
		tffsset(padSector, 0, sizeof(padSector));
		tffsAPISetIoreq( &myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4),
							0,0,padSector,firstSector,1);
		status = TFFSAbsRead(&myIoreq, &(ioreq->irSectorCount));
		if(status != flOK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSOTPRead(): TFFSAbsRead failed with status: 0x%x "), status));
			return status;
		}
		tffscpy(buf, &padSector[firstByteInFirstSector], (DOCH_SECTOR_SIZE - firstByteInFirstSector));
		buf += (DOCH_SECTOR_SIZE - firstByteInFirstSector);
		firstSector++;
	}

	if(fullSectorsToRead > 0)
	{
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4),
			0,0,buf,firstSector,fullSectorsToRead);
		status = TFFSAbsRead(&myIoreq, &(ioreq->irSectorCount));
		if(status != flOK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSOTPRead(): TFFSAbsRead failed with status: 0x%x "), status));
			return status;
		}
		buf += (fullSectorsToRead<<DOCH_SECTOR_SIZE_BITS);
	}

	/*Complete last sector*/
	if(bytesToPad != 0)
	{
		tffsset(padSector, 0, sizeof(padSector));
		tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4),
			0,0,padSector,(fullSectorsToRead + firstSector),1);
		status = TFFSAbsRead(&myIoreq, &(ioreq->irSectorCount));
		if(status != flOK)
		{
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSOTPRead(): TFFSAbsRead failed with status: 0x%x "), status));
			return status;
		}
		tffscpy(buf, padSector, bytesInUnfullSector);
	}
	return flOK;
#endif	/*FL_ABS_READ_WRITE*/
}/*TFFSOTPRead()*/

/*----------------------------------------------------------------------*/
/*                f l O T P W r i t e A n d L o c k                     */
/*                                                                      */
/* Write data to OTP partition and lock the partition					*/
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user data						        */
/*  irLength         : size of user data in bytes                       */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
/*static*/ FLStatus TFFSOTPWriteAndLock(IOreq *ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4),0,
		0,ioreq->irData,0,(ioreq->irLength>>DOCH_SECTOR_SIZE_BITS));

	/*1. Perform last write
	  2. Lock the partition for writing (OTP)
	  ---------------------------------------*/
	rc = flDOCHWriteAndLock(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSOTPWriteAndLock(): flDOCHWriteAndLock failed with status: 0x%x "), rc));
		TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
	}
	return flOK;
}/*TFFSOTPWriteAndLock()*/


/*----------------------------------------------------------------------*/
/*                     f l G e t U n i q u e I D                        */
/*                                                                      */
/* Returns the 16 bytes device unique ID                                */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to a 16 bytes buffer to read into the    */
/*                     unique ID data                                   */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irData          : 16 bytes unique ID buffer                   */
/*----------------------------------------------------------------------*/
FLStatus TFFSGetUniqueID(IOreq* ioreq)
{
#ifdef HW_OTP
	DOCH_Error rc = DOCH_GeneralFailure;
	IOreq myIoreq;

	tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,dochVol.intermediateBuf,0,0);

	/*Get extended disk info*/
	/*----------------------*/
	rc = flDOCHIdentifyDiskOnChipDevice(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetUniqueID(): flDOCHIdentifyDiskOnChipDevice failed with status: 0x%x "), rc));
		return (rc==DOCH_DiskNotFound)? flUnknownMedia : TFFS_API_RET(rc);
	}

	tffscpy(ioreq->irData, ((DOCH_DeviceInfo*)dochVol.intermediateBuf)->bUniqueID,
                        sizeof(((DOCH_DeviceInfo*)dochVol.intermediateBuf)->bUniqueID));
	return flOK;
#else /*HW_OTP*/
	return flBadFunction;
#endif /*HW_OTP*/


}/*TFFSGetUniqueID()*/

/*----------------------------------------------------------------------*/
/*                f l G e t C u s t o m e r I D                         */
/*                                                                      */
/* Returns the 4 bytes customer ID                                      */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to a 4 bytes buffer to read into the     */
/*                     customer ID                                      */
/*																		*/
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irData          : 4 bytes unique ID buffer                    */
/*----------------------------------------------------------------------*/
FLStatus TFFSGetCustomerID(IOreq* ioreq)
{
	FLStatus status;
	IOreq tmpIoreq;
	FLByte uniqueID[16];

	/*Use local copy of ioreq*/
	/*-----------------------*/
	tffsAPISetIoreq(&tmpIoreq,ioreq->irHandle,0,0,uniqueID,0,0);

	/*Retrieve UniqueID*/
	/*-----------------*/
	status = TFFSGetUniqueID(&tmpIoreq);
	if(status != flOK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSGetCustomerID(): TFFSGetUniqueID failed with status: 0x%x "), status));
		return status;
	}

	/*Extract 1st 4 bytes (CustomerID)*/
	/*--------------------------------*/
	tffscpy(ioreq->irData, uniqueID, 8);
	return flOK;
}/*TFFSGetCustomerID()*/

#endif /* HW_OTP */



/*----------------------------------------------------------------------*/
/*              f l R e c o v e r F r o m P o w e r L o s s             */
/*                                                                      */
/* Recover from a power OFF without full TrueFFS initialization.        */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irFlags          : FL_PREPARE_FOR_RESUME forces the device back to  */
/*                     normal mode                                      */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
FLStatus TFFSRecoverFromPowerLoss(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	tffsAPISetIoreq(&myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,0,0,0);
    rc = flDOCHRecoverFromPowerLoss(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSRecoverFromPowerLoss(): flDOCHRecoverFromPowerLoss failed with status: 0x%x "), rc));
		return flBadParameter;
	}
	return flOK;
}/*TFFSRecoverFromPowerLoss()*/


/*----------------------------------------------------------------------*/
/*             f l D e e p P o w e r D o w n M o d e                    */
/*                                                                      */
/* Forces the device into and out of the deep power down mode           */
/* To set the Auto-DPD, ACTIVE/INACTIVE modes and timeout MUST be reset,*/
/* by other API!                                                        */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irFlags          : DEEP_POWER_DOWN forces the low power consumption */
/*                     mode. otherwise turning to the regular mode      */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
FLStatus TFFSDeepPowerDownMode(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	tffsAPISetIoreq( &myIoreq,FL_GET_SOCKET_FROM_HANDLE(ioreq),0,0,0,gDpdSettings.timeOut,
					 (gDpdSettings.activeMode | gDpdSettings.inActiveMode) );
    if (ioreq->irFlags == DEEP_POWER_DOWN) /* enter DPD */
	{
		/* reset modes + leave in inactive mode */
        myIoreq.irFlags = DOCH_PM_INACTIVE_MODE | DOCH_PM_SET_BOTH_MODES;
	}
    else/* exit DPD*/
	{
		if( TFFS_API_IS_AUTO_DPD_ON(FL_GET_SOCKET_FROM_HANDLE(ioreq)) ) /* AutoDPD on */
		{
			myIoreq.irFlags = DOCH_PM_INACTIVE_MODE | DOCH_PM_SET_BOTH_MODES; /* MUST be in inactive to allow all AutoDPDs*/
		}
		else /* AutoDPD off*/
		{
			myIoreq.irFlags = DOCH_PM_WORK_MODE | DOCH_PM_SET_BOTH_MODES;/* just put in active mode */
		}
	}

	rc = DOCHSetPowerMode(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSDeepPowerDownMode(): DOCHSetPowerMode failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return TFFS_API_RET(rc);
	}
	return flOK;
}/*TFFSDeepPowerDownMode()*/

/*----------------------------------------------------------------------*/
/*             f l H w C o n f i g                                      */
/*                                                                      */
/* his routine enables to control DiskOnChip H/W features.              */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                     4 LSB - Socket number                            */
/*  irFlags          : Describing H/W configuration Type                */
/*  irLength         : New value to use - Different for each H/W        */
/*                     configuration type chosen.                       */
/*                                                                      */
/* Returns: None                                                        */
/*----------------------------------------------------------------------*/
FLStatus TFFSHwConfig(IOreq* ioreq)
{
	IOreq myIoreq;
	DOCH_Error dochRC;
    FLDword ctrl;

	switch(ioreq->irFlags)
	{
	case FL_DPD_TYPE:/*Configures the behavior of DiskOnChip DPD input pin*/
		tffsAPISetIoreq(&myIoreq,ioreq->irHandle,DOCH_POWER_DOWN,0,0,0,0);
		switch(ioreq->irLength)
		{
		case FL_DPD_DISABLED:
			myIoreq.irLength |= DOCH_DPD_PIN_DISABLED;
			break;

		case FL_DPD_EXIT_RISE_EDGE:
			myIoreq.irLength |= (DOCH_DPD_PIN_ENABLED | DOCH_DPD_PIN_POL_HIGH);
			break;

		case FL_DPD_EXIT_FALL_EDGE:
			myIoreq.irLength  |= (DOCH_DPD_PIN_ENABLED | DOCH_DPD_PIN_POL_LOW);
			break;

		case FL_DPD_ENTER_1_EXIT_0:
		case FL_DPD_ENTER_0_EXIT_1:
		default:
			return flFeatureNotSupported;
		}

		dochRC = DOCHConfigHW(&myIoreq);
		if(dochRC != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_API, "TFFSHwConfig(): flDOCHDPDMode failed...\r\n");
			return flBadFunction;
		}

		break;

	case FL_PAGE_MODE_TYPE:
	case FL_TURBO_MODE_TYPE:
	case FL_DPS_2_COPIES_TYPE:
		return flOK;

	case FL_IRQ_RB_TYPE :
		/* Enable interrupts (if requested) */
		if(ioreq->irLength & FL_IRQ_EDGE_TYPE)/* Not supported in H3 */
		{
			DBG_PRINT_WRN(FLZONE_API, "TFFSHwConfig(): EDGE interrupts not supported by mDOC H3 devices, LEVEL interrupt enabled.\r\n");
		}
		/* save set configuration */
		gDochIrqEnabled[ioreq->irHandle] = (ioreq->irLength & FL_INT_RB_ENABLED);
		break;

	case FL_DMA_TYPE:
		tffsAPISetIoreq(&myIoreq,ioreq->irHandle,DOCH_DMA_ENABLE,0,0,0,0);
        if (ioreq->irLength & FL_DMA_HW_ENABLED)
        {
            myIoreq.irLength = TRUE;
        }
        else
        {
            myIoreq.irLength = FALSE;
        }
        dochRC = DOCHConfigHW(&myIoreq);
        if(dochRC != DOCH_OK)
        {
            DBG_PRINT_ERR(FLZONE_API, "TFFSHwConfig(): Setting DMA enable status failed.\r\n");
			return (dochRC==DOCH_BadParameter) ? flBadParameter : flFeatureNotSupported;
        }
        ctrl = ((DOCH_DMA_PULSE_WIDTH)<<4) | DOCH_DMA_REQ_POL_LOW;
        if (ioreq->irLength & FL_DMA_REQ_EDGE)
            ctrl |= DOCH_DMA_REQ_EDGE;
        if (ioreq->irLength & FL_NEGATED_0_ASSERTED_1)
            ctrl &= ~DOCH_DMA_REQ_POL_LOW;
		tffsAPISetIoreq(&myIoreq,ioreq->irHandle,DOCH_DMA_CTRL,0,0,ctrl, 0);
        dochRC = DOCHConfigHW(&myIoreq);
        if(dochRC != DOCH_OK)
        {
            DBG_PRINT_ERR(FLZONE_API, "TFFSHwConfig(): Setting DMA enable status failed.\r\n");
			return (dochRC==DOCH_BadParameter) ? flBadParameter : flFeatureNotSupported;
        }
        break;
	default:
		DBG_PRINT_ERR(FLZONE_API, "TFFSHwConfig(): Not Supported \r\n");
		return flFeatureNotSupported;
	}

	return flOK;
}/*TFFSHwConfig*/

#ifndef NO_IPL_CODE
/*----------------------------------------------------------------------*/
/*                   f l W r i t e I P L                                */
/*                                                                      */
/* Place a user buffer to both copies of the IPL area                   */
/*                                                                      */
/* Note :                                                               */
/*                                                                      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle      : Socket number (0,1,..)                          */
/*                      4 LSB - Socket number                           */
/*      irData        : Pointer to user buffer                          */
/*      irLength      : Size of the buffer                              */
/*      irFlags       : See flags bellow                                */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSWriteIPL(IOreq* ioreq)
{
#ifdef FL_READ_ONLY
	return flFeatureNotSupported;
#else /*FL_READ_ONLY*/
	DOCH_Error rc = DOCH_GeneralFailure;
	IOreq ioreq_WriteIpl;
	IOreq ioreq_ReadIpl;
    FLDword iplFlags, totalIPLSize, i;

    if ((ioreq->irLength & (DOCH_SECTOR_SIZE - 1)) != 0)
    {
        DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): writeIPL must be done in buffers with N x 512B size (while n is a positive integer.\r\n");
        return flBadParameter;
    }
    if ((ioreq->irFlags & FL_IPL_128K_WINDOW_MODE) == 0)
    {
        iplFlags = DOCH_IPL_MODE_8KB_WINDOW | DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT;
        if (ioreq->irFlags & FL_IPL_VIRTUAL_RAM_MODE)
        {
            iplFlags |= DOCH_IPL_MODE_VIRTUAL_RAM;
            totalIPLSize = TFFS_API_VIRTUAL_RAM_8K_IPL_SIZE;
        }
        else
        {
            iplFlags |= DOCH_IPL_MODE_PAGED_RAM;
            totalIPLSize = TFFS_API_PAGED_IPL_SIZE;
        }
    }
    else
    {
        iplFlags = DOCH_IPL_MODE_NORMAL_RAM | DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT;
        if (ioreq->irFlags & FL_IPL_VIRTUAL_RAM_MODE)
        {
            iplFlags |= DOCH_IPL_MODE_VIRTUAL_RAM;
            totalIPLSize = TFFS_API_VIRTUAL_RAM_128K_IPL_SIZE;
        }
        else if (ioreq->irFlags & FL_DOC_IPL_PAGED_RAM_MODE)
        {
            iplFlags |= DOCH_IPL_MODE_PAGED_RAM;
            totalIPLSize = TFFS_API_PAGED_IPL_SIZE;
        }
        else
        {
            totalIPLSize = TFFS_API_128K_NORMAL_IPL_SIZE;
        }
    }
    if (ioreq->irFlags & FL_IPL_NO_ADDRESS_SHIFT_MODE)
    {
        iplFlags &= ~DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT;
    }
    if (ioreq->irFlags & FL_IPL_SWAP_BYTES_MODE)
    {
        iplFlags &= ~DOCH_IPL_MODE_ACTIVE_SWAP_BYTES;
    }
    if ((FLDword)((ioreq->irCount + ioreq->irLength) >> DOCH_SECTOR_SIZE_BITS) > totalIPLSize)
    {
		DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): IPL size exceed current IPL mode allowed size.");
        return flBadParameter;
    }

    if (ioreq->irCount != 0)
    {
        for (i = 0; i < (FLDword)(ioreq->irCount);i++)
        {
			tffsAPISetIoreq(&ioreq_ReadIpl, FL_GET_SOCKET_FROM_HANDLE(ioreq),iplFlags,0,dochVol.intermediateBuf,1,i);
            rc = flDOCHReadIPL(&ioreq_ReadIpl);
		    if(rc != DOCH_OK)
		    {
			    DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): Failed reading previous IPL copy. status: ");
			    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
                TFFS_API_RET_PART_FLSTATUS(rc, flReadFault);
            }

			tffsAPISetIoreq(&ioreq_WriteIpl, FL_GET_SOCKET_FROM_HANDLE(ioreq),iplFlags,0,dochVol.intermediateBuf,
				1, totalIPLSize);
			if (i == 0)
                ioreq_WriteIpl.irFlags |= DOCH_IPL_WRITE_FIRST_CHUNK;
            rc = flDOCHWriteIPL(&ioreq_WriteIpl);
            if (rc != DOCH_OK)
		    {
			    DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): Failed writing previous IPL copy. status: ");
			    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
				TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
            }
        }
    }

	tffsAPISetIoreq(&ioreq_WriteIpl, FL_GET_SOCKET_FROM_HANDLE(ioreq),iplFlags,0,ioreq->irData,
		ioreq->irLength >> DOCH_SECTOR_SIZE_BITS, totalIPLSize);
    if (ioreq->irCount == 0)
        ioreq_WriteIpl.irFlags |= DOCH_IPL_WRITE_FIRST_CHUNK;
	rc = flDOCHWriteIPL(&ioreq_WriteIpl);
	if(rc != DOCH_OK)
	{
        DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): Failed writing new IPL data. status: ");
        DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): TFFSAbsWrite failed with status: ");
		TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
    }

    /*Write remainder*/
    tffsset(dochVol.intermediateBuf, 0, DOCH_SECTOR_SIZE);
    for (i = ((ioreq->irLength  >> DOCH_SECTOR_SIZE_BITS)+ ioreq->irCount); i < totalIPLSize ; i++)
	{
        rc = flDOCHWriteIPL(tffsAPISetIoreq( &ioreq_WriteIpl,FL_GET_SOCKET_FROM_HANDLE(ioreq),iplFlags,
												0,dochVol.intermediateBuf,1,totalIPLSize));
        if (rc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_API, "TFFSWriteIPL(): Failed writing previous IPL copy. status: ");
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
			TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
        }
	}
	return flOK;
#endif	/*FL_READ_ONLY*/
}/*TFFSWriteIPL*/

/*----------------------------------------------------------------------*/
/*                           r e a d I P L                              */
/*                                                                      */
/* Read IPL to user buffer.                                             */
/*                                                                      */
/* Note : Read length must be a multiplication of 512 bytes             */
/* Note : Causes DiskOnChip Millennium Plus to download (i,e protection */
/*        key will be removed from all partitions.                      */
/*                                                                      */
/* Parameters:                                                          */
/*      irHandle      : Socket number (0,1,..)                          */
/*                      4 LSB - Socket number                           */
/*      irData        : Pointer to user buffer                          */
/*      irLength      : Size of the buffer                              */
/*      irCount       : Used IPL size on the media                      */
/*																		*/
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSReadIPL(IOreq* ioreq)
{
	FLStatus rc = flReadFault;
	DOCH_Error dochErr = DOCH_ReadFault;
	FLDword fullSectorsToRead, bytesToPad = 0;
	/*FLByte padBuffer[DOCH_SECTOR_SIZE];*/
	FLByte * padBuffer=dochVol.intermediateBuf;
	IOreq ioreq_ipl;

    fullSectorsToRead = ioreq->irLength >> DOCH_SECTOR_SIZE_BITS;
    bytesToPad = ioreq->irLength % DOCH_SECTOR_SIZE;
	tffsset(&ioreq_ipl, 0, sizeof(ioreq_ipl));
    ioreq_ipl.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
    ioreq_ipl.irCount = ioreq->irCount;

    if (fullSectorsToRead > 0)
    {
        ioreq_ipl.irLength = fullSectorsToRead;
        ioreq_ipl.irData = ioreq->irData;
        dochErr = flDOCHReadIPL(&ioreq_ipl);
        if(dochErr != DOCH_OK)
        {
            DBG_PRINT_ERR(FLZONE_API, "TFFSReadIPL(): TFFSAbsRead failed with status: ");
            DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), dochErr));
			TFFS_API_RET_PART_FLSTATUS(rc, flReadFault);
        }
    }

    if ((bytesToPad > 0) || (ioreq->irLength == 0))
    {
        ioreq_ipl.irLength = 1;
        ioreq_ipl.irData = padBuffer;
        dochErr = flDOCHReadIPL(&ioreq_ipl);
        if(dochErr != DOCH_OK)
        {
            DBG_PRINT_ERR(FLZONE_API, "TFFSReadIPL(): TFFSAbsRead failed with status: ");
            DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), dochErr));
			TFFS_API_RET_PART_FLSTATUS(rc, flReadFault);
        }
        tffscpy((void*)(((FLByte*)ioreq->irData) + (fullSectorsToRead<<DOCH_SECTOR_SIZE_BITS)), (void*)padBuffer, bytesToPad);
    }

    ioreq->irFlags = DOCH_IPL_MODE_NORMAL_RAM;
    if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_PAGED_RAM) != 0)
        ioreq->irFlags |= FL_DOC_IPL_PAGED_RAM_MODE;
    if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_VIRTUAL_RAM) != 0)
        ioreq->irFlags |= FL_IPL_VIRTUAL_RAM_MODE;
    if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_ADDRESS_SHIFT_IN_AFFECT) == 0)
        ioreq->irFlags |= FL_IPL_NO_ADDRESS_SHIFT_MODE;
    if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_ACTIVE_SWAP_BYTES) != 0)
        ioreq->irFlags |= FL_IPL_SWAP_BYTES_MODE;
    if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_8KB_WINDOW) == 0)
    {
        ioreq->irFlags |= FL_IPL_128K_WINDOW_MODE;
        if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_VIRTUAL_RAM) != 0)
            ioreq->irCount = TFFS_API_VIRTUAL_RAM_128K_IPL_SIZE << DOCH_SECTOR_SIZE_BITS;
        else if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_PAGED_RAM) != 0)
            ioreq->irCount = (TFFS_API_PAGED_IPL_SIZE << DOCH_SECTOR_SIZE_BITS);
        else
            ioreq->irCount = (TFFS_API_128K_NORMAL_IPL_SIZE << DOCH_SECTOR_SIZE_BITS);
    }
    else
    {
        if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_VIRTUAL_RAM) != 0)
            ioreq->irCount = TFFS_API_VIRTUAL_RAM_8K_IPL_SIZE << DOCH_SECTOR_SIZE_BITS;
        else if ((ioreq_ipl.irFlags & DOCH_IPL_MODE_PAGED_RAM) != 0)
            ioreq->irCount = (TFFS_API_PAGED_IPL_SIZE << DOCH_SECTOR_SIZE_BITS);
        else
            ioreq->irCount = (TFFS_API_8K_NORMAL_IPL_SIZE << DOCH_SECTOR_SIZE_BITS);
    }
	return flOK;
}/*TFFSReadIPL()*/

#endif	/*NO_IPL_CODE*/

#ifdef HW_PROTECTION

/*----------------------------------------------------------------------*/
/*              f l I d e n t i f y P r o t e c t i o n                 */
/*              b d k I d e n t i f y P r o t e c t i o n               */
/*                                                                      */
/* Returns the specified partitions protection attributes               */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle        : Drive number (0, 1, ...)                    */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*        irFlags    CHANGEABLE_PROTECTION - changeable protection type */
/*                   PROTECTABLE     - partition can receive protection */
/*                   READ_PROTECTED  - partition is read protected      */
/*                   WRITE_PROTECTED - partition is write protected     */
/*                   LOCK_ENABLED    - HW lock signal is enabled        */
/*                   LOCK_ASSERTED   - HW lock signal is asserted       */
/*                   KEY_INSERTED    - key is inserted (not currently   */
/*                                     protected.                       */
/*----------------------------------------------------------------------*/
FLStatus TFFSIdentifyProtection(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	FLByte protectionType,guestAccessMode,lockControl,otpBit,hwLockSignal,sLockSignal,authenticated;

	/*Retrieve partition info*/
	/*-----------------------*/
	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSIdentifyProtection(): flDOCHPartitionInfo failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

	protectionType = (FLByte)(((DOCH_PartitionInfo*)dochVol.intermediateBuf)->partitionAttributes2 & DOCH_PA2B_PROTECTION_TYPE);
	guestAccessMode = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->partitionAttributes2 & DOCH_PA2B_GUEST_MODE)
						>> DOCH_PA2O_GUEST_MODE);
	lockControl	   = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->partitionAttributes2 & DOCH_PA2B_LOCK_CTRL)
						>> DOCH_PA2O_LOCK_CTRL);
	otpBit		   = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->dwCommandFlagsOrStatuses & DOCH_CFSB_PERM_LOCKED)
						>> DOCH_CFSO_PERM_LOCKED);

	hwLockSignal   = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->dwCommandFlagsOrStatuses & DOCH_CFSB_HW_LOCK_ASSERTED)
						>> DOCH_CFSO_HW_LOCK_ASSERTED);
	sLockSignal   = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->dwCommandFlagsOrStatuses & DOCH_CFSB_SW_LOCK_ASSERTED)
						>> DOCH_CFSO_SW_LOCK_ASSERTED);

	authenticated = (FLByte)((((DOCH_PartitionInfo*)dochVol.intermediateBuf)->dwCommandFlagsOrStatuses & DOCH_CFSB_USER_AUTHENTICATED)
						>> DOCH_CFSO_USER_AUTHENTICATED);


	/*Retrieve partition attributes*/
	/*-----------------------------*/
    tffsset(dochVol.intermediateBuf, 0, sizeof(DOCH_PartitionUserAttrWithBinary));
	rc = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq,ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0 ));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSIdentifyProtection(): flDOCHGetParitionUserAttributes failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
	/*Set popper bits in irFlags according to partition attributes*/
	/*------------------------------------------------------------*/
	ioreq->irFlags=0;

	/*Set PROTECTABLE and CHANGEABLE_PROTECTION to user attributes*/
	/*------------------------------------------------------------*/
	ioreq->irFlags |= (((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bProtected * PROTECTABLE);
	ioreq->irFlags |= (((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bChangableProtection * CHANGEABLE_PROTECTION);

	if(protectionType != DOCH_PARTITION_NOT_PROTECTED)
	{
		/*Default access mode (without authentication)*/
		/*--------------------------------------------*/
		if(guestAccessMode == DOCH_PART_ACCESS_MODE_NONE)
			ioreq->irFlags |= (READ_PROTECTED /*| WRITE_PROTECTED*/);
		else if(guestAccessMode == DOCH_PART_ACCESS_MODE_RO)
			ioreq->irFlags |= WRITE_PROTECTED;
	}

	/*Lock signal enabled/disabled*/
	/*----------------------------*/
	if(lockControl == DOCH_LOCK_ACTIVE)
		ioreq->irFlags |= LOCK_ENABLED;

	/*Lock signal asserted*/
	/*--------------------*/
	if(hwLockSignal)
		ioreq->irFlags |= LOCK_ENABLED;

	/*Key inserted*/
	/*------------*/
	if(authenticated && protectionType != DOCH_PARTITION_NOT_PROTECTED)
		ioreq->irFlags |= KEY_INSERTED;


	/* SLOCK signal */
	/*--------------------------*/
	if(sLockSignal)
		ioreq->irFlags |= STICKY_LOCK_ASSERTED;

	if( ((ioreq->irFlags & (WRITE_PROTECTED | READ_PROTECTED)) == 0) &&
		(protectionType != DOCH_PARTITION_NOT_PROTECTED) && (otpBit==0) )
	{
		ioreq->irFlags |= KEY_INSERTED;
	}

	/*OTW (Indicated by OTP Bit)*/
	/*--------------------------*/
	if(otpBit == 1)
	{   /* WRITE_PROTECTED and CHANGEABLE_PROTECTION added for compatibility with non-mDOC H3 devices */
		ioreq->irFlags |= (OTW_PROTECTED|WRITE_PROTECTED|CHANGEABLE_PROTECTION);
	}
	/* check that no protection applied at all */
	if( (protectionType == DOCH_PARTITION_NOT_PROTECTED) && (ioreq->irFlags==0))
        return flNotProtected;

	return flOK;
}/*TFFSIdentifyProtection()*/


/*----------------------------------------------------------------------*/
/*              f l R e m o v e P r o t e c t i o n K e y               */
/*              b d k R e m o v e P r o t e c t i o n K e y             */
/*                                                                      */
/* Remove the protection key making the partition protected again       */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSRemoveProtectionKey(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	FLByte bPartNum;
	DOCH_PartitionInfo * pDOCH_PartitionInfo = (DOCH_PartitionInfo*)dochVol.intermediateBuf;

	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0, dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSRemoveProtectionKey(): flDOCHPartitionInfo Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return TFFS_API_RET(rc);
	}
	if( (pDOCH_PartitionInfo->partitionAttributes2&DOCH_PA2B_PROTECTION_TYPE) == DOCH_PARTITION_NOT_PROTECTED)
	{
		if( (pDOCH_PartitionInfo->partitionAttributes2&DOCH_PA2B_LOCK_CTRL)!=0 )
		{
			if( ((pDOCH_PartitionInfo->partitionAttributes2&DOCH_PA2B_GUEST_MODE)==DOCH_PART_ACCESS_MODE_FULL ) &&
				((pDOCH_PartitionInfo->partitionAttributes2&DOCH_PA2B_USER_MODE) ==DOCH_PART_ACCESS_MODE_FULL ) )
			{/* both user and guest have full protection -> write protection not applied */
				return flOK; /* return OK for backward compatibility */
			}
		}
		else
		{
			return flNotProtected; /* trying to remove key from not-protected partition */
		}
	}/* not protected partition */


	tffsset(&myIoreq,0,sizeof(myIoreq));
    myIoreq.irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq);
	bPartNum = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
	DOCH_SET_PARTITION_TO_IOREQ_HANDLE(&myIoreq, bPartNum);
    myIoreq.irFlags = DOCH_ACCESS_USER_PASSWORD;
	/*Disable partition authentication*/
	/*--------------------------------*/
	rc = flDOCHDisablePartAccess(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSRemoveProtectionKey(): flDOCHDisablePartAccess Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));

		return TFFS_API_RET(rc);
	}
	return flOK;
}/*TFFSRemoveProtectionKey()*/

/*----------------------------------------------------------------------*/
/*          f l C h a n g e P r o t e c t i o n K e y                   */
/*          b d k C h a n g e P r o t e c t i o n K e y                 */
/*                                                                      */
/* Changes the current protection key with a new one.                   */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*  irData           : Pointer to the new 8 bytes key array             */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSChangeProtectionKey(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	DOCH_PartitionUserAttrWithBinary* pPartitionUserAttrWithBinary = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	DOCH_PartitionProtectionAPI * pPartitionProtectionAPI = (DOCH_PartitionProtectionAPI *)dochVol.intermediateBuf;

	/*Retrieve partition info*/
	/*-----------------------*/
	rc = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq, ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionKey(): flDOCHGetParitionUserAttributes failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
    if( pPartitionUserAttrWithBinary->bChangableProtection == FALSE )
    {
        DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionKey(): Can't change protection of unchangeable protection partition.\n");
        return flUnchangeableProtection;
    }

    /*-----------------------*/
	/*Change passkey to new one*/
	/*-------------------------*/
	tffsset(dochVol.intermediateBuf, 0, sizeof(DOCH_PartitionProtectionAPI));
	tffscpy(pPartitionProtectionAPI->bPasskey, ioreq->irData, PROTECTION_KEY_LENGTH);

	/*Set new partition info (with new passkey) back to DOCH*/
	/*------------------------------------------------------*/
	rc = flDOCHSetParitionProtection(tffsAPISetIoreq(&myIoreq, ioreq->irHandle,DOCH_PASSKEY_VALID,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionKey(): flDOCHSetParitionProtection Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flWrongKey : TFFS_API_RET(rc) ; /* flWrongKey returned in this case by non-mDOC H3 devices */
	}
	return flOK;
}/*TFFSChangeProtectionKey()*/


/*----------------------------------------------------------------------*/
/*              f l C h a n g e P r o t e c t i o n T y p e             */
/*              b d k C h a n g e P r o t e c t i o n T y p e           */
/*                                                                      */
/* Changes the protection attributes of the partitions.                 */
/* In order for a partition to change its protection type (without      */
/* reformatting the media) it must have the CHANGEABLE_PRTOECTION       */
/* attribute.                                                           */
/*                                                                      */
/* Parameters:                                                          */
/*  irHandle         : Drive number (0, 1, ...)                         */
/*                        bits 7-4 - Partition # (zero based)           */
/*                        bits 3-0 - Socket # (zero based)              */
/*        irFlags    : CHANGEABLE_PROTECTION - changeable protection type */
/*                     PROTECTABLE     - partition can receive protection */
/*                     READ_PROTECTED  - partition is read protected    */
/*                     WRITE_PROTECTED - partition is write protected   */
/*                     LOCK_ENABLED    - HW lock signal is enabled      */
/*                     KEY_INSERTED    - key is inserted (not currently */
/*                                       protected.                     */
/*  irData           : Pointer to the new 8 bytes key array             */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSChangeProtectionType(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
	IOreq  ioreq3;
	FLBoolean read_protect, write_protect, locked;
	FLDword guestAccessMode;
    FLDword partitionAttr;
	FLByte otwAsserted = ((ioreq->irFlags & OTW_PROTECTED) == OTW_PROTECTED);
	DOCH_PartitionUserAttrWithBinary* pPartitionUserAttrWithBinary = (DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf;
	DOCH_PartitionProtectionAPI * pPartitionProtectionAPI = (DOCH_PartitionProtectionAPI *)dochVol.intermediateBuf;

	/*Retrieve partition info*/
	/*-----------------------*/
	rc = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq,ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0) );
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHgetParitionUserAttributes failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
    if (pPartitionUserAttrWithBinary->bChangableProtection == FALSE)
    {
        DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): Can't change protection of unchangeable protection partition.\n");
        return flUnchangeableProtection;
    }

    /*If OTW_PROTECTED was asserted - lock the partition from further writing*/
	/*-----------------------------------------------------------------------*/
	if(otwAsserted)
	{
		if(ioreq->irFlags == (OTW_PROTECTED | PROTECTABLE | WRITE_PROTECTED))
		{

			/*Retrieve partition user attributes*/
			/*----------------------------------*/
			rc = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0));
			if(rc != DOCH_OK)
			{
				DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHGetParitionUserAttributes failed with status: ");
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
				return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
			}

			/* change partition protection to non-changable */
			pPartitionUserAttrWithBinary->bChangableProtection = 0;

			/*Set attributes back to device*/
			/*----------------------------------*/
			rc = flDOCHSetParitionUserAttributes(&myIoreq);
			if(rc != DOCH_OK)
			{
				DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHSetParitionUserAttributes Failed with status : ");
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
				return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
			}

			/*Write 0 length buffer, with LOCK*/
			/*----------------------------------*/
			tffsAPISetIoreq(&myIoreq, ioreq->irHandle,0,0,0,0,0);
			rc = flDOCHWriteAndLock(&myIoreq);
			if(rc != DOCH_OK)
			{
				DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHWriteAndLock Failed with status : ");
				DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
				TFFS_API_RET_PART_FLSTATUS(rc, flWriteFault);
			}

			return flOK;
		}
		else
		{
			return flBadParameter;
		}
	}/*OTW parotection*/

	/*Retrieve current partition info from DOCH*/
	/*-----------------------------------------*/
	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHPartitionInfo Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
    partitionAttr = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->partitionAttributes2;

	/*Retrieve partition user attributes*/
	/*----------------------------------*/
	rc = flDOCHGetParitionUserAttributes(tffsAPISetIoreq(&myIoreq, ioreq->irHandle, 0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHGetParitionUserAttributes failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
	/*Change protection type
	  (only relevant fields are changed from the retrieved values!)
	  =============================================================*/
	pPartitionUserAttrWithBinary->bChangableProtection =
             (((ioreq->irFlags & CHANGEABLE_PROTECTION) == CHANGEABLE_PROTECTION) ||
             (pPartitionUserAttrWithBinary->bChangableProtection == 1));

	pPartitionUserAttrWithBinary->bProtected = ((ioreq->irFlags & PROTECTABLE) == PROTECTABLE);

    /*Set attributes back to device*/
	rc = flDOCHSetParitionUserAttributes(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHSetParitionUserAttributes Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

    tffsset(dochVol.intermediateBuf, 0, (DOCH_SECTOR_SIZE));

	/*Default access mode*/
	/*-------------------*/
	read_protect  = ((ioreq->irFlags & READ_PROTECTED)  == READ_PROTECTED);
	write_protect = ((ioreq->irFlags & WRITE_PROTECTED) == WRITE_PROTECTED);
	locked = ((ioreq->irFlags & LOCK_ENABLED) == LOCK_ENABLED);
	if(read_protect && write_protect)
	{
	/*	guestAccessMode = DOCH_PART_ACCESS_MODE_NONE;*/
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): read_protect && write_protect NOT supported\r\n ");
		return flBadParameter;
	}
	else if(read_protect)
	{
	/*	guestAccessMode = DOCH_PART_ACCESS_MODE_NONE;*/
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): read_protect NOT supported\r\n ");
		return flBadParameter;
	}
	else if(write_protect)
		guestAccessMode = DOCH_PART_ACCESS_MODE_RO;
	else
		guestAccessMode = DOCH_PART_ACCESS_MODE_FULL;

	DOCH_SetBits(&partitionAttr, DOCH_PA2B_GUEST_MODE, DOCH_PA2O_GUEST_MODE, guestAccessMode);

	if(guestAccessMode != DOCH_PART_ACCESS_MODE_FULL)
		DOCH_SetBits(&partitionAttr, DOCH_PA2B_PROTECTION_TYPE, DOCH_PA2O_PROTECTION_TYPE, 1);

	/*Fill partPropApi structure*/
	/*--------------------------*/
    pPartitionProtectionAPI->dwProtectionType	=
		((partitionAttr & DOCH_PA2B_PROTECTION_TYPE) >> DOCH_PA2O_PROTECTION_TYPE);
	pPartitionProtectionAPI->dwUserAccessMode	=
		((partitionAttr & DOCH_PA2B_USER_MODE) >> DOCH_PA2O_USER_MODE);
	pPartitionProtectionAPI->dwGuestAccessMode	=
		((partitionAttr & DOCH_PA2B_GUEST_MODE) >> DOCH_PA2O_GUEST_MODE);
	pPartitionProtectionAPI->dwMasterControl	=
		((partitionAttr & DOCH_PA2B_MASTER_CTRL) >> DOCH_PA2O_MASTER_CTRL);
	pPartitionProtectionAPI->dwEncryptionType	=
		((partitionAttr & DOCH_PA2B_ENCRYPT_TYPE) >> DOCH_PA2O_ENCRYPT_TYPE);
	pPartitionProtectionAPI->dwLockControl	=
		((partitionAttr & DOCH_PA2B_LOCK_CTRL) >> DOCH_PA2O_LOCK_CTRL);
	pPartitionProtectionAPI->dwMaxNumOfAuthAttempts	=
		((partitionAttr & DOCH_PA2B_MAX_AUTH_ATTEMPTS) >> DOCH_PA2O_MAX_AUTH_ATTEMPTS);

	if( locked== TRUE )
		pPartitionProtectionAPI->dwLockControl	= DOCH_LOCK_NOT_ACTIVE;

	/*Set new partition info (with new protection type) back to DOCH*/
	/*--------------------------------------------------------------*/
	rc = flDOCHSetParitionProtection(tffsAPISetIoreq(&myIoreq,ioreq->irHandle,DOCH_ATTRIBUTES_VALID,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSChangeProtectionType(): flDOCHSetParitionProtection Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return rc==DOCH_ProtectionFault ? flHWProtection : TFFS_API_RET(rc);
	}

	/*If all is well, disable access to the partition*/
	/* (Is reset needed???? - TBD)*/
	return TFFSRemoveProtectionKey(tffsAPISetIoreq(&ioreq3,ioreq->irHandle,0,0,0,0,0));
}/*TFFSChangeProtectionType()*/

/*----------------------------------------------------------------------*/
/*              f l A p p l y S t i c k y L o c k                       */
/*                                                                      */
/* Enable the sticky lock mode to all relevant partitions               */
/*                                                                      */
/* Parameters:                                                          */
/*        irHandle      : Drive number (0, 1, ...)                      */
/*                        bits 7-4 - Must be set to 0                   */
/*                        bits 3-0 - Socket # (zero based)              */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus TFFSApplyStickyLock(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;

	rc = DOCHConfigHW(tffsAPISetIoreq(&myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), DOCH_SLOCK, 0,0,DOCH_SLOCK_ACTIVE,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSApplyStickyLock(): DOCHConfigHW Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return flBadFunction;
	}

	return flOK;
}/*TFFSApplyStickyLock*/


/*-----------------------------------------*/
/* Function name   : TFFSHwProtectionLock*/
/* Description     : */
/* Return type     : static FLStatus */
/* Argument        : IOreq* ioreq*/
/*-----------------------------------------*/
FLStatus TFFSHwProtectionLock(IOreq* ioreq)
{
	DOCH_Error rc;
	IOreq myIoreq;
    FLDword partitionAttr;
	DOCH_PartitionProtectionAPI * pPartitionProtectionAPI = (DOCH_PartitionProtectionAPI*)dochVol.intermediateBuf;

	/*Retrieve current partition info from DOCH*/
	/*-----------------------------------------*/
	rc = flDOCHPartitionInfo(tffsAPISetIoreq(&myIoreq, ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSHwProtectionLock(): flDOCHPartitionInfo Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}
    partitionAttr = ((DOCH_PartitionInfo*)dochVol.intermediateBuf)->partitionAttributes2;

    memset(dochVol.intermediateBuf, 0, sizeof(DOCH_PartitionProtectionAPI));

	/*Lock signal*/
	/*-----------*/
	if((ioreq->irFlags & LOCK_ENABLED) == LOCK_ENABLED)
		DOCH_SetBits(&partitionAttr, DOCH_PA2B_LOCK_CTRL, DOCH_PA2O_LOCK_CTRL, DOCH_LOCK_ACTIVE);
	else
		DOCH_SetBits(&partitionAttr, DOCH_PA2B_LOCK_CTRL, DOCH_PA2O_LOCK_CTRL, DOCH_LOCK_NOT_ACTIVE);

	/*Fill partPropApi structure*/
	/*--------------------------*/
    pPartitionProtectionAPI->dwProtectionType	=
		((partitionAttr & DOCH_PA2B_PROTECTION_TYPE) >> DOCH_PA2O_PROTECTION_TYPE);
	pPartitionProtectionAPI->dwUserAccessMode	=
		((partitionAttr & DOCH_PA2B_USER_MODE) >> DOCH_PA2O_USER_MODE);
	pPartitionProtectionAPI->dwGuestAccessMode	=
		((partitionAttr & DOCH_PA2B_GUEST_MODE) >> DOCH_PA2O_GUEST_MODE);
	pPartitionProtectionAPI->dwMasterControl	=
		((partitionAttr & DOCH_PA2B_MASTER_CTRL) >> DOCH_PA2O_MASTER_CTRL);
	pPartitionProtectionAPI->dwEncryptionType	=
		((partitionAttr & DOCH_PA2B_ENCRYPT_TYPE) >> DOCH_PA2O_ENCRYPT_TYPE);
	pPartitionProtectionAPI->dwLockControl	=
		((partitionAttr & DOCH_PA2B_LOCK_CTRL) >> DOCH_PA2O_LOCK_CTRL);
	pPartitionProtectionAPI->dwMaxNumOfAuthAttempts	=
		((partitionAttr & DOCH_PA2B_MAX_AUTH_ATTEMPTS) >> DOCH_PA2O_MAX_AUTH_ATTEMPTS);

	/*Set modified partition info*/
	/*---------------------------*/
	rc = flDOCHSetParitionProtection(tffsAPISetIoreq(&myIoreq, ioreq->irHandle,0,0,dochVol.intermediateBuf,0,0));
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "TFFSHwProtectionLock(): flDOCHSetParitionProtection Failed with status : ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return (rc==DOCH_ProtectionFault) ? flHWProtection : TFFS_API_RET(rc) ;
	}
	return flOK;
}/*TFFSHwProtectionLock()*/

#endif /* HW_PROTECTION */


/*----------------------------------------------------------------------*/
/* Function name   : TFFSPassThrough*/
/* Description     : calls to DOCH pass through command with converted  */
/*                    parameters                                        */
/* Return type     : FLStatus */
/* Argument        : IOreq FAR2 *ioreq*/
/*  irHandle         : Socket number ( 0,1,2...  )                      */
/*                        4 LSB - Socket number                         */
/*  irData           : pointer to user buffer (for DATA IN and DATA out */
/*                     commands)										*/
/*  irLength         : number of sectors in buffer, pointed to by irData*/
/*  irCount          :  bits 0..1 - pass through operation flow, where  */
/*                        0 - No Data(CTRL), 1 - Data IN, 2 - Data OUT	*/
/*                      bit  2 - 1, when interrupt should be used,      */
/*                                  0 - otherwise                       */
/*						bits 4..7 - frame size exponent, should be set  */
/*                                  to 0 for now - 1 sector             */
/*  irPath           : pointer to  buffer from type DOCH_Registers*     */
/*                     IN - input registers, OUT - out registers        */
/* Returns:                                                             */
/*        FLStatus   : 0 on success, otherwise failed                   */
/*----------------------------------------------------------------------*/
FLStatus TFFSPassThrough(IOreq FAR2 *ioreq)
{
	DOCH_Error rc;
	/*IOreq myIoreq;*/
	FLSNative  snFlow = (FLSNative)(ioreq->irCount & 0x00000003);
	FLBoolean  fUseInterrupt = (FLBoolean)((ioreq->irCount&0x00000004)>>2);
	/*FLDword	   dwMultSectorFrame = (FLDword)(ioreq->irCount&0x00000f0)>>4);*/
	/*DOCH_Socket*  pDev = DOCH_get_socket(FL_GET_SOCKET_FROM_HANDLE(ioreq));*/

	/* TODO - add retrieve current transfer mode from device */

	rc = DOCHAtaPassThrough( FL_GET_SOCKET_FROM_HANDLE(ioreq), snFlow,
		(DOCH_Registers*)ioreq->irPath,	(DOCH_Registers*)ioreq->irPath,
		(FLNative)ioreq->irLength, (void*)ioreq->irData, fUseInterrupt);

	return (rc==DOCH_ATA_NO_ERROR)?flOK : flGeneralFailure;
}/*TFFSPassThrough()*/


/*----------------------------------------------------------------------*/
/*				b d C a l l B C T o S D K 								*/
/*                                                                      */
/* Performs needed general operations before calling actual function	*/
/* Calls appropriate TFFS function (that will convert to SDK routine(s))*/
/*                                                                      */
/* Parameters:                                                          */
/*        functionNo	: DOCH SDK function to run	                    */
/*        ioreq			: DOCH ioreq structure	                        */
/*                                                                      */
/* Returns:                                                             */
/*        FLStatus        : 0 on success, otherwise failed              */
/*----------------------------------------------------------------------*/
FLStatus bdCallTFFSToDOCH(FLFunctionNo functionNo, IOreq FAR2 *ioreq)
{
	FLStatus rc = flFeatureNotSupported;
	DOCH_Error    dochRc;
	IOreq         myIoreq;
	FLByte        partNum;
	FLByte        partNumTemp = 0;
	FLHandle      origIrHandle = ioreq->irHandle;

#ifdef HW_PROTECTION
	DOCH_Error   rcDoch;
	IOreq        ioreq1;
#endif /*HW_PROTECTION*/

	DOCH_DiskUserAttrWithBinary* pDiskUserAttrWithBinary;

	/*Sanity Check*/
	/*------------*/
	if(ioreq == NULL)
	{
		DBG_PRINT_ERR(FLZONE_BLKDEV,"bdCallTFFSToDOCH: - Ioreq is NULL");
		return flBadParameter;
	}

	/* Actions to take on the first time bdCallTFFSToDOCH is invoked */
	/*---------------------------------------------------------------*/
	if(dochBdCallWasCalled == FALSE)
	{
		checkStatus(flInit());
        tffsset (&dochVol, 0, sizeof(dochVol));
        checkStatus(flCreateMutex(&dochVol.mutex));
		dochBdCallWasCalled = TRUE;
        dochVol.intermediateBuf = (FLByte*)FL_MALLOC(DOCH_SECTOR_SIZE);
        if (dochVol.intermediateBuf == NULL)
        {
			DBG_PRINT_ERR(FLZONE_API, "bdCallTFFSToDOCH(): Can't allocate intermediate buffer.\r\n");
			return flNotEnoughMemory;
        }

		/*Retrieve diskAttributes at least once*/
		/*(numOfBinaryPartitions, iplExists, otpExists will be further updated
		   by TFFSflashFormat if called)
		   ---------------------------*/
		dochRc = flDOCHGetDiskUserAttributes(tffsAPISetIoreq(&myIoreq, 0,0,0,dochVol.intermediateBuf,0,0));
		if(dochRc != DOCH_OK)
		{
			DBG_PRINT_ERR(FLZONE_API, "bdCallTFFSToDOCH(): flDOCHGetDiskUserAttributes failed with status: ");
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
#ifdef CHECK_POWER_ON_EVERY_COMMAND
			if( gDeviceTurnedOff==DOCH_GLOBAL_BOOL_PATTERN )
				return flSuspendModeDetected;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/
			return flBadFunction;
		}

		pDiskUserAttrWithBinary =(DOCH_DiskUserAttrWithBinary*)dochVol.intermediateBuf;

		dochVol.numOfBinaryPartitions	= pDiskUserAttrWithBinary->bNumOfBinaryPartitions;
		dochVol.iplExists				= pDiskUserAttrWithBinary->bIplPresent;
		dochVol.otpExists				= pDiskUserAttrWithBinary->bOtpPresent;
	}/* dochBdCallWasCalled was called */

	/* get partition number and check it up to call type */
	partNum = FL_GET_FLASH_PARTITION_FROM_HANDLE(ioreq);
	if((functionNo >= INDEX_BINARY_START) && (functionNo <= INDEX_BINARY_END))
	{/* binary partition */

		/* check that the number of binary partition not exceeded number of BDK on the device */
		if( partNum >= dochVol.numOfBinaryPartitions )
				return flBadDriveHandle;

		rc = actualPartitionNum(&partNum, PARTITION_TYPE_BINARY, FL_GET_SOCKET_FROM_HANDLE(ioreq));
		if(rc != flOK)
		{
			DBG_PRINT_ERR(FLZONE_API, "bdCallTFFSToDOCH(): actualPartitionNum failed with status: ");
			DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
			return rc;
		}
		ioreq->irHandle &= (0xFFFFFF0F);
		ioreq->irHandle |= (partNum << 4);
	}
	else
	{
		if((functionNo >= INDEX_NEED_PARTITION_0_START) && (functionNo <= INDEX_NEED_PARTITION_0_END))
		{/* calls, which required partition number zero */
			if( partNum!=0 )
				return flBadDriveHandle;
		}
		else
		{
			if(functionNo > INDEX_NEED_PARTITION_0_END)
			{/* BDTL partition */
				rc = actualPartitionNum(&partNum, PARTITION_TYPE_BDTL, FL_GET_SOCKET_FROM_HANDLE(ioreq));
				if(rc != flOK)
				{
					DBG_PRINT_ERR(FLZONE_API, "bdCallTFFSToDOCH(): actualPartitionNum failed with status: ");
					DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
					return rc;
				}
				ioreq->irHandle &= (0xFFFFFF0F);
				ioreq->irHandle |= (partNum << 4);
			}
			/* otherwise -> Files calls - different treatment */
		}
	}

    /*make sure specific function precondition*/
    if (!flTakeMutex(&dochVol.mutex))
        return flDriveNotAvailable;
	switch(functionNo)
	{
        case FL_ABS_READ:
        case FL_ABS_WRITE:
        case FL_ABS_DELETE:
        case FL_ABS_SECURE_DELETE:
        case FL_SECTORS_IN_VOLUME:
            if (dochVol.mountCount[partNum] == 0)
            {
                DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("bdCallTFFSToDOCH(): Media must be mounted before calling 0x%d function\r\n"), functionNo));
                flFreeMutex(&dochVol.mutex);
                return flNotMounted;
            }
            break;
        case BD_ERASE_BD:
            if (dochVol.mountCount[partNum] != 0)
            {
                DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("bdCallTFFSToDOCH(): Media must be unmounted before calling 0x%d function\r\n"), functionNo));
                flFreeMutex(&dochVol.mutex);
                return flNoWriteAccess;
            }
            break;

        case BD_FLASH_FORMAT:
        case BD_UNFORMAT:
            for (partNumTemp = 0; partNumTemp < DOCH_MAX_PARTITIONS; partNumTemp++)
            {
                if (dochVol.mountCount[partNumTemp] != 0)
                {
                    DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("bdCallTFFSToDOCH(): All partitions must be unmounted before calling 0x%d function\n"), functionNo));
                    flFreeMutex(&dochVol.mutex);
                    return flNoWriteAccess;
                }
            }
        default:
            break;
    }

	/*Branch to appropriate TFFS routine according to function#*/
	/*---------------------------------------------------------*/

	switch(functionNo)
	{
#ifdef FL_EXTENDED_DISK_INFO
		case FL_GET_EXTENDED_DISK_INFO:
			rc = TFFSGetExtendedDiskInfo(ioreq);
			break;

#endif	/* FL_EXTENDED_DISK_INFO */
		case FL_VOLUME_INFO:
			rc = TFFSVolumeInfo(ioreq);
			break;

		case FL_COUNT_VOLUMES:
			rc = TFFSCountVolumes(ioreq);
			break;

		case FL_SECTORS_IN_VOLUME:
			rc = TFFSSectorsInVolume(ioreq);
			break;

/*	Quick mount routines	*/
#ifndef FL_NO_QUICK_MOUNT_FEATURE
		case FL_CLEAR_QUICK_MOUNT_INFO:
			rc = TFFSClearQuickMountInfo(ioreq);
			break;

		case FL_WRITE_QUICK_MOUNT_INFO:
			rc = TFFSWriteQuickMountInfo(ioreq);
			break;

		case FL_GET_QUICK_MOUNT_STATUS:
			rc = TFFSGetQuickMountStatus(ioreq);
			break;

#endif	/* FL_NO_QUICK_MOUNT_FEATURE */

/*	Volume mounting routines	*/
		case FL_ABS_MOUNT:
			//rc = TFFSAbsMountVolume(ioreq);
            // not supporting disk volumes for now...
            rc = flBadFunction;
			break;

		case FL_DISMOUNT_VOLUME:
			//rc = TFFSAbsDismountVolume(ioreq);
            // not supporting disk volumes for now...
            rc = flBadFunction;
			break;

		case FL_CHECK_VOLUME:
			rc = TFFSCheckVolume(ioreq);
			break;

/*	Media	*/
#ifndef FL_READ_ONLY
		case FL_DEFRAGMENT_VOLUME:
			rc = TFFSDefragmentVolume(ioreq);
			break;


#ifdef FL_FORMAT_VOLUME
		case BD_FLASH_FORMAT:
            rc = TFFSflashFormat(ioreq);
			break;

		case BD_UNFORMAT:
			rc = TFFSUnFormat(ioreq);
			break;

		case BD_ERASE_BD:
			rc = TFFSEraseBD(ioreq);
			break;


#endif	/* FL_FORMAT_VOLUME */
#endif	/* FL_READ_ONLY */

/*	IO	*/
#ifdef FL_ABS_READ_WRITE
		case FL_ABS_READ:
            ioreq->irFlags = 0;
			rc = TFFSAbsRead(ioreq, &(ioreq->irSectorCount));
			break;

		case FL_ABS_ADDRESS:
			rc = TFFSAbsAddress(ioreq);
			break;


#ifndef FL_READ_ONLY
		case FL_ABS_WRITE:
            ioreq->irFlags = 0;
			rc = TFFSAbsWrite(ioreq);
			break;

		case FL_ABS_DELETE:
			rc = TFFSAbsDelete(ioreq);
			break;

		case FL_ABS_SECURE_DELETE:
			rc = TFFSAbsSecureDelete(ioreq);
			break;

#endif	/* FL_READ_ONLY */
#endif	/* FL_ABS_READ_WRITE */

		case FL_GET_PHYSICAL_INFO:
			rc = TFFSGetPhysicalInfo(ioreq);
			break;

/*	BDK routines (obsolete)	*/
#ifdef BDK_ACCESS
		case FL_BINARY_READ_INIT:
			rc = TFFSbdkReadInit(ioreq);
			break;

		case FL_BINARY_READ_BLOCK:
			rc = TFFSbdkReadBlock(ioreq);
			break;

#ifndef FL_READ_ONLY
		case FL_BINARY_WRITE_INIT:
			rc = TFFSbdkWriteInit(ioreq);
			break;

		case FL_BINARY_WRITE_BLOCK:
			rc = TFFSbdkWriteBlock(ioreq);
			break;

		case FL_BINARY_ERASE:
			rc = TFFSbdkErase(ioreq);
			break;

		case FL_BINARY_CREATE:
			rc = TFFSbdkCreate(ioreq);
			break;
#endif	/* FL_READ_ONLY */

		case FL_BINARY_PARTITION_INFO:
			rc = TFFSbdkPartitionInfo(ioreq);
			break;
#endif /* BDK_ACCESS */

/*	OTP routines	*/
#ifdef HW_OTP
		case FL_OTP_SIZE:
			rc = TFFSOTPSize(ioreq);
			break;

		case FL_OTP_READ:
			rc = TFFSOTPRead(ioreq);
			break;

		case FL_OTP_WRITE:
			rc = TFFSOTPWriteAndLock(ioreq);
			break;

		case FL_UNIQUE_ID:
			rc = TFFSGetUniqueID(ioreq);
			break;

		case FL_CUSTOMER_ID:
			rc = TFFSGetCustomerID(ioreq);
			break;

#endif /* HW_OTP */

		case FL_RECOVER_FROM_POWER_LOSS:
			rc = TFFSRecoverFromPowerLoss(ioreq);
			break;

		case FL_DEEP_POWER_DOWN_MODE:
			rc = TFFSDeepPowerDownMode(ioreq);
			break;

		case FL_HW_CONFIG:
			rc = TFFSHwConfig(ioreq);
			break;


/*	IPL routines	*/
#ifndef NO_IPL_CODE
		case FL_WRITE_IPL:
			rc = TFFSWriteIPL(ioreq);
			break;

		case FL_READ_IPL:
			rc = TFFSReadIPL(ioreq);
			break;
#endif	/*NO_IPL_CODE*/


/*	Protection routines	*/
#ifdef HW_PROTECTION
		case FL_PROTECTION_GET_TYPE:
		case FL_BINARY_PROTECTION_GET_TYPE:
			rc = TFFSIdentifyProtection(ioreq);
			break;

/*		case FL_BINARY_PROTECTION_GET_TYPE:
			rc = TFFSbdkIdentifyProtection(ioreq);
			break;
*/

		case FL_PROTECTION_INSERT_KEY:
		case FL_BINARY_PROTECTION_INSERT_KEY:
			rc = TFFSInsertProtectionKey(ioreq);
			if(rc != flOK)
				break;

			/*DPS Emulation
			  -----------*/
			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace backwards as long as attrSector.bDPSBwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum - 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSBwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSInsertProtectionKey(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), 0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp--;
			}

			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace forward as long as attrSector.bDPSFwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum + 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSFwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSInsertProtectionKey(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), 0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp++;
			}

			break;

/*		case FL_BINARY_PROTECTION_INSERT_KEY:
			rc = TFFSbdkInsertProtectionKey(ioreq);
			break;
*/
		case FL_PROTECTION_REMOVE_KEY:
		case FL_BINARY_PROTECTION_REMOVE_KEY:
			rc = TFFSRemoveProtectionKey(ioreq);
			if(rc != flOK)
				break;

			/*DPS Emulation
			  -----------*/
			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace backwards as long as attrSector.bDPSBwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum - 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSBwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSRemoveProtectionKey(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), 0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp--;
			}

			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace forward as long as attrSector.bDPSFwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum + 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSFwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSRemoveProtectionKey(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), 0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp++;
			}
			break;

/*		case FL_BINARY_PROTECTION_REMOVE_KEY:
			rc = TFFSbdkRemoveProtectionKey(ioreq);
			break;
*/
		case FL_PROTECTION_CHANGE_KEY:
		case FL_BINARY_PROTECTION_CHANGE_KEY:
			rc = TFFSChangeProtectionKey(ioreq);
			if(rc != flOK)
				break;

			/*DPS Emulation
			  -----------*/
			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)

			/*trace backwards as long as attrSector.bDPSBwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum - 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSBwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSChangeProtectionKey(tffsAPISetIoreq(&ioreq1, FL_GET_SOCKET_FROM_HANDLE(ioreq) + (partNumTemp << 4),
					0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp--;
			}

			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace forward as long as attrSector.bDPSFwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum + 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSFwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSChangeProtectionKey(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), 0,0,ioreq->irData,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp++;
			}
			break;

/*		case FL_BINARY_PROTECTION_CHANGE_KEY:
			rc = TFFSbdkChangeProtectionKey(ioreq);
			break;
*/
		case FL_PROTECTION_CHANGE_TYPE:
		case FL_BINARY_PROTECTION_SET_TYPE:
			rc = TFFSChangeProtectionType(ioreq);
			if(rc != flOK)
				break;

			/*DPS Emulation
			  -----------*/
			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace backwards as long as attrSector.bDPSBwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum - 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSBwd)
			{
   			    FLStatus rc2;

				rc2 = TFFSChangeProtectionType(tffsAPISetIoreq(&ioreq1, (partNumTemp << 4), ioreq->irFlags, 0,0,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp--;
			}

			/*Retrieve partition attributes*/
			TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNum, rcDoch)

			/*trace forward as long as attrSector.bDPSFwd == TRUE
			 and apply same key
			 ----------------*/
			partNumTemp = (FLByte)(partNum + 1);
			while(((DOCH_PartitionUserAttrWithBinary*)dochVol.intermediateBuf)->bDPSFwd)
			{
   			    FLStatus rc2;
				rc2 = TFFSChangeProtectionType(tffsAPISetIoreq(&ioreq1,(partNumTemp << 4), ioreq->irFlags,0,0,0,0));
				if(rc2 != flOK)
					break;

				/*Retrieve partition attributes*/
				TFFS_API_BDCALL_GET_PART_USER_ATTR(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), partNumTemp, rcDoch)
				partNumTemp++;
			}
			break;

/*		case FL_BINARY_PROTECTION_SET_TYPE:
			rc = TFFSbdkChangeProtectionType(ioreq);
			break;
*/
		case FL_PROTECTION_STICKY_LOCK:
			rc = TFFSApplyStickyLock(ioreq);
			break;

		case FL_PROTECTION_SET_LOCK:
		case FL_BINARY_PROTECTION_CHANGE_LOCK:
			rc = TFFSHwProtectionLock(ioreq);
			break;

#endif /* HW_PROTECTION */

		case FL_DOCH_PASS_THROUGH:
			rc = TFFSPassThrough(ioreq);
			break;

	default:
		DBG_PRINT_ERR_PRM(FLZONE_BLKDEV,(FLTXT("bdCallTFFSToDOCH: - Undefined Function# %d.\r\n"),functionNo));
		rc = flFeatureNotSupported;
		break;
	}

	/*Reset irHandle to original value*/
	ioreq->irHandle = origIrHandle;
    flFreeMutex(&dochVol.mutex);
#ifdef CHECK_POWER_ON_EVERY_COMMAND
	if( gDeviceTurnedOff==DOCH_GLOBAL_BOOL_PATTERN )
		return flSuspendModeDetected;
#endif /*CHECK_POWER_ON_EVERY_COMMAND*/
	return rc;
}


/*static
FLStatus TFFSCheckBeforeWrite(IOreq* ioreq) { return flFeatureNotSupported;}*/


/*----------------------------------------------------------------------*/
/*                  f l S e t D o c B u s R o u t i n e                 */
/*                                                                      */
/* Set user defined memory access routines for DOCH.		                */
/*                                                                      */
/* Parameters:                                                          */
/*      socket      : Socket number to install routine for.             */
/*      structPtr   : Pointer to function structure.                    */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
TFFS_DLL_API FLStatus NAMING_CONVENTION DochSetDocBusRoutine(FLByte  socket,
															 FLAccessStruct FAR1 * structPtr)
{
	return flOK;
}

/*----------------------------------------------------------------------*/
/*                  f l G e t D o c B u s R o u t i n e                 */
/*                                                                      */
/* Get currently installed memory access routines for DOCH.		        */
/*                                                                      */
/* Parameters:                                                          */
/*      socket      : Socket number to install routine for.             */
/*      structPtr   : Pointer to function structure.                    */
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failed                */
/*----------------------------------------------------------------------*/
TFFS_DLL_API FLStatus NAMING_CONVENTION DochGetDocBusRoutine(FLByte  socket,
															 FLAccessStruct FAR1 * structPtr)
{
	return flOK;
}


/*----------------------------------------------------------------------*/
/*          f l R e g i s t e r D O C H 3 S O C				            */
/*                                                                      */
/* Register DOCH3 socket												*/
/*                                                                      */
/* Parameters:                                                          */
/*      dwAddress		: Address were DOCH socket is located	        */
/*                                                                      */
/* Returns:                                                             */
/*      DOCH_Error      : 0 on success, otherwise failure               */
/*      'noOfSockets' is incremented in case a socket was found        */
/*----------------------------------------------------------------------*/
DOCH_Error flRegisterDOCH3SOC(FLDword dwAddress)
{
	DOCH_Error rc;

#ifndef DOCH_USE_FUNC
    //DOCHFlash->win = (volatile FLByte FAR0*)physicalToPointer(dwAddress, DOCH_MEM_WIN_SIZE, 0);
      DOCHFlash->win = (volatile FLByte FAR0*)dwAddress;
#endif /*DOCH_USE_FUNC*/

	rc = DochRegisterSocket(dwAddress);
	if(rc != DOCH_OK)
		return rc;

	noOfSockets++;
	return DOCH_OK;

}/*flRegisterDOCH3SOC*/

/*----------------------------------------------------------------------*/
/*                  t f f s A p i E x i t				  				*/
/*                                                                      */
/* Exit routine for tffs_api.c layer									*/
/*                                                                      */
/* Parameters:                                                          */
/*      NONE															*/
/*                                                                      */
/* Returns:                                                             */
/*      FLStatus        : 0 on success, otherwise failure               */
/*----------------------------------------------------------------------*/
FLStatus tffsApiExit(void)
{
	DBG_PRINT_FLOW(FLZONE_ABS, "tffsApiExit() Invoked \r\n\n");

	if( dochVol.intermediateBuf!=NULL )
	{
		FL_FREE(dochVol.intermediateBuf);
		dochVol.intermediateBuf = NULL;
	}
	noOfSockets = 0;
	DochSDKExit();
    flDeleteMutex(&dochVol.mutex);
	return flOK;
}


/*----------------------------------------------------------------------*/
/* Function name   : tffsApiSetAutoDpd*/
/* Description     : sets */
/* Return type     : FLStatus */
/* Argument        : FLSDword dwsSocket*/
/* Argument        : FLDword value*/
/* Argument        : FLDword FAR2 *prevValue*/
/*----------------------------------------------------------------------*/
FLStatus tffsApiSetAutoDpd(  FLEnvVars envVarType, FLSDword dwsSocket, FLDword value,  FLDword FAR2 *prevValue )
{
	IOreq myIoreq;

#ifdef DOCH_AUTO_DPD_BY_HOST

	if( envVarType!=TFFS_API_IS_AUTO_DPD_ON )
		return flFeatureNotSupported;

	(*prevValue) = TFFS_API_IS_DPD_ON(dwsSocket) ? TRUE : FALSE;

	tffsAPISetIoreq( &myIoreq, dwsSocket, DOCH_ENV_AUTO_DPD_BY_HOST, 0,0, value, 0);
	if (flDOCHSetEnvVar(&myIoreq) != DOCH_OK)
		return flFeatureNotSupported;

	TFFS_API_SAVE_POWER_MODES(dwsSocket) = 0xFFFFFFFF;
	return flOK;

#else /*DOCH_AUTO_DPD_BY_HOST*/
	FLDword dwMode;
	FLBoolean bAutoDpdOn = TFFS_API_IS_AUTO_DPD_ON(dwsSocket) ? TRUE : FALSE;
	DOCH_Error rc;

	switch( envVarType) /* set IOREQ values */
	{
		case FL_SET_AUTO_DPD_MODE:
			dwMode = gDpdSettings.activeMode;
			if( value == FL_ON )/*DPD is ON, device may be in DPD, idle or Active state */
			{
				/* fix active mode to enable auto DPD */
				if( dwMode == DOCH_WM_NORMAL )
					dwMode = DOCH_WM_NORMAL_AND_AUTO_STBY;
				if( dwMode == DOCH_WM_LOW_FREQ )
					dwMode = DOCH_WM_LOW_FREQ_AND_AUTO_STBY;

				tffsAPISetIoreq( &myIoreq, dwsSocket, (DOCH_PM_SET_BOTH_MODES|DOCH_PM_INACTIVE_MODE),
					0,0, gDpdSettings.timeOut, (dwMode | gDpdSettings.inActiveMode));
			}
			else /* set the device to 'always ON' mode */
			{
				/* fix active mode to disable auto DPD */
				if( dwMode == DOCH_WM_NORMAL_AND_AUTO_STBY )
					dwMode = DOCH_WM_NORMAL;
				if( dwMode == DOCH_WM_LOW_FREQ_AND_AUTO_STBY )
					dwMode = DOCH_WM_LOW_FREQ;

				tffsAPISetIoreq( &myIoreq, dwsSocket, (DOCH_PM_SET_BOTH_MODES|DOCH_PM_INACTIVE_MODE),
					0,0,gDpdSettings.timeOut, (dwMode | gDpdSettings.inActiveMode));
			}

			(*prevValue) = bAutoDpdOn;
			TFFS_API_SAVE_POWER_MODES(dwsSocket);
			break;

		case FL_SET_ACTIVE_DPD_MODE:
			dwMode = value; /* copy value to init this variable */
			if(bAutoDpdOn == FL_ON )
			{
				if( value == DOCH_WM_NORMAL )
					dwMode = DOCH_WM_NORMAL_AND_AUTO_STBY;
				if( value == DOCH_WM_LOW_FREQ )
					dwMode = DOCH_WM_LOW_FREQ_AND_AUTO_STBY;
			}
			else
			{
				if( value == DOCH_WM_NORMAL_AND_AUTO_STBY )
					dwMode = DOCH_WM_NORMAL;
				if( value == DOCH_WM_LOW_FREQ_AND_AUTO_STBY )
					dwMode = DOCH_WM_LOW_FREQ;
			}

			(*prevValue) = gDpdSettings.activeMode;
			tffsAPISetIoreq(&myIoreq, dwsSocket, (DOCH_PM_SET_BOTH_MODES | DOCH_PM_INACTIVE_MODE),
				0,0, gDpdSettings.timeOut, (dwMode|gDpdSettings.inActiveMode) );
			break;

		case FL_SET_INACTIVE_DPD_MODE:
			(*prevValue) = gDpdSettings.inActiveMode;
			/* must leave device in inactive mode */
			tffsAPISetIoreq(&myIoreq, dwsSocket, (DOCH_PM_SET_BOTH_MODES | DOCH_PM_INACTIVE_MODE),
							0,0, gDpdSettings.timeOut, (value|gDpdSettings.activeMode) );
			break;

		case FL_SET_TIMEOUT_DPD:
			/* reset both modes + set timeout */
			(*prevValue) = gDpdSettings.timeOut;
			tffsAPISetIoreq( &myIoreq, dwsSocket, (DOCH_PM_SET_BOTH_MODES|DOCH_PM_INACTIVE_MODE),0,0,
				             value, (gDpdSettings.activeMode|gDpdSettings.inActiveMode) );
			break;

		default:
			return flFeatureNotSupported;
	}/*switch*/

	rc = DOCHSetPowerMode(&myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR(FLZONE_API, "tffsApiSetAutoDpd(): DOCHSetPowerMode failed with status: ");
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("0x%x "), rc));
		return TFFS_API_RET(rc);
	}
	return flOK;
#endif /*DOCH_AUTO_DPD_BY_HOST*/
}/*tffsApiSetAutoDpd()*/


/************************************************************************/
/* internal functions                                                   */
/************************************************************************/

/************************************************************************/
/* Function name   : tffsApiAuthPartition*/
/* Description     : authenticates H3 partition */
/* Return type     : FLStatus - flOK, flWrongKey or flGeneralFailure*/
/* Argument        : IOreq * myIoreq*/
/* Argument        : IOreq * ioreq*/
/* Argument        : FLByte bPartNo - number of partition up to H3 count */
/* Argument        : FLByte * pKey - key */
/* Argument        : FLWord wKeyLen - length of the key pointed to by pKey*/
/************************************************************************/
FLStatus tffsApiAuthPartition(IOreq * myIoreq, IOreq * ioreq, FLByte bPartNo, FLByte * pKey, FLWord wKeyLen)
{
	DOCH_Error rc;
	DOCH_PartitionAcessPassword * pPartitionAcessPassword = (DOCH_PartitionAcessPassword *)(dochVol.intermediateBuf);
	DOCH_PartitionInfo * partInfoPtr = (DOCH_PartitionInfo *)dochVol.intermediateBuf;


	/* non mDOC H3 devices return flOK, when wrong key inserted to partition with CHNAGABLE
	   protection only. So first determine, which protection we have */
	tffsAPISetIoreq(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0, 0, dochVol.intermediateBuf, 0, 0);
	DOCH_SET_PARTITION_TO_IOREQ_HANDLE( myIoreq, bPartNo );
	rc = flDOCHPartitionInfo(myIoreq);
	if( rc != DOCH_OK )
	{
		return (rc==DOCH_ProtectionFault) ? flHWProtection : ((rc==DOCH_PartitionNotFound) ? flPartitionNotFound : TFFS_API_RET(rc));
	}

	if( (partInfoPtr->dwCommandFlagsOrStatuses & DOCH_CFSB_PERM_LOCKED)!=0 ) /* OTW protected partition should return wrong key */
	{
		return flWrongKey;
	}

	if( (partInfoPtr->partitionAttributes2&DOCH_PA2B_PROTECTION_TYPE)==DOCH_PARTITION_NOT_PROTECTED)
	{
		return flNotProtected;
	}

	/* password protected */
	if( ((partInfoPtr->partitionAttributes2&DOCH_PA2B_PROTECTION_TYPE)==DOCH_PARTITION_PWD_PROTECTED) ||
		((partInfoPtr->partitionAttributes2&DOCH_PA2B_LOCK_CTRL)!=0) )
	{
		if( ((partInfoPtr->partitionAttributes2&DOCH_PA2B_GUEST_MODE)==DOCH_PART_ACCESS_MODE_FULL ) &&
			((partInfoPtr->partitionAttributes2&DOCH_PA2B_USER_MODE) ==DOCH_PART_ACCESS_MODE_FULL ) )
		{/* both user and guest have full protection -> write protection not applied */
			return flNotProtected;
		}
	}

	tffsset(dochVol.intermediateBuf, 0, DOCH_SECTOR_SIZE);
	tffscpy(pPartitionAcessPassword->bPassword, pKey, wKeyLen);
	tffsAPISetIoreq( myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq),DOCH_ACCESS_USER_PASSWORD, 0, dochVol.intermediateBuf, 0,0);
	DOCH_SET_PARTITION_TO_IOREQ_HANDLE(myIoreq, bPartNo);
	/*Authenticate the partition*/
	rc = flDOCHAccessPartWithPwd(myIoreq);
	if (rc != DOCH_OK)
	{
		return (rc==DOCH_ProtectionFault) ? flWrongKey : TFFS_API_RET(rc);
	}
	return flOK;
}/* tffsApiAuthPartition() */


/************************************************************************/
/* Function name   : tffsApiAddOtpIPL*/
/* Description     : adds IPL or OTP partition*/
/* Return type     : static FLStatus - flOK, flGeneralFailure, flHWProtection*/
/* Argument        : FLBoolean bIPL - TRUE, when IPL should be added, FALSE, when OTP*/
/* Argument        : IOreq * myIoreq */
/************************************************************************/
FLStatus tffsApiAddOtpIPL(FLBoolean bIPL, IOreq * myIoreq, IOreq * ioreq)
{
	DOCH_Error rc = DOCH_OK;
	FLByte * intBuf = dochVol.intermediateBuf;
	DOCH_PartitionFormatInfoAPI * pPartitionFormatInfoAPI = (DOCH_PartitionFormatInfoAPI *)intBuf;

	tffsset(intBuf, 0, sizeof(DOCH_PartitionFormatInfoAPI));

	TFFS_API_SET_MIG_STD_PART_PRMS(pPartitionFormatInfoAPI,0);/* protection type dont matter */

	/* Protection features */
	pPartitionFormatInfoAPI->dwOtpEnabled		= (bIPL == FALSE) ? TRUE : FALSE;
	pPartitionFormatInfoAPI->dwProtectionType   = DOCH_PARTITION_NOT_PROTECTED;
	pPartitionFormatInfoAPI->dwUserAccessMode   = DOCH_PART_ACCESS_MODE_FULL;
	pPartitionFormatInfoAPI->dwGuestAccessMode  = DOCH_PART_ACCESS_MODE_FULL;
	pPartitionFormatInfoAPI->dwLockControl      = DOCH_LOCK_NOT_ACTIVE;


	/*Partition size (must be FL_LENGTH_IN_BYTES)*/
	pPartitionFormatInfoAPI->nPartitionSize =
		(bIPL==TRUE) ? IPL_PARTITION_SIZE_SECTORS : (TFFS_API_OTP_PART_SIZE >> DOCH_SECTOR_SIZE_BITS);

	/*Add partition*/
	tffsAPISetIoreq(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf, 0,0);
	rc = flDOCHAddPartition(myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHAddPartition (IPL) failed with status: 0x%x "), rc));
		return TFFS_API_RET(rc);
	}

	/*Retrieve current atttributes*/
	tffsset(myIoreq, 0, sizeof(IOreq));
	if( bIPL == TRUE )
		myIoreq->irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq) + (DOCH_IPL_PARTITION_NUM << 4);
	else
		myIoreq->irHandle = FL_GET_SOCKET_FROM_HANDLE(ioreq) + (TFFS_API_OTP_PARTITION_NUM << 4);
	myIoreq->irData = intBuf;
	rc = flDOCHGetParitionUserAttributes(myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetParitionUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection : TFFS_API_RET(rc);
	}

	/*Set type to IPL or OTP*/
	((DOCH_PartitionUserAttrWithBinary*)intBuf)->bType = (bIPL == TRUE) ? PARTITION_TYPE_IPL:PARTITION_TYPE_OTP;
	/*Set attributes back to device*/
	rc = flDOCHSetParitionUserAttributes(myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection : TFFS_API_RET(rc);
	}

	tffsAPISetIoreq(myIoreq, FL_GET_SOCKET_FROM_HANDLE(ioreq), 0,0, intBuf, 0,0);
	rc = flDOCHGetDiskUserAttributes(myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHGetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection : TFFS_API_RET(rc);
	}

	if(bIPL == TRUE)
		((DOCH_DiskUserAttrWithBinary*)intBuf)->bIplPresent = 1;
	else
		((DOCH_DiskUserAttrWithBinary*)intBuf)->bOtpPresent = 1;
	rc = flDOCHSetDiskUserAttributes(myIoreq);
	if(rc != DOCH_OK)
	{
		DBG_PRINT_ERR_PRM(FLZONE_API, (FLTXT("TFFSflashFormat(): flDOCHSetDiskUserAttributes failed with status: 0x%x "), rc));
		return (rc==DOCH_ProtectionFault)? flHWProtection : TFFS_API_RET(rc);
	}
	return flOK;
}/*tffsApiAddOtpIPL*/


/************************************************************************/
/* Function name   : tffsAPISetIoreq */
/* Description     : */
/* Return type     : IOreq * */
/* Argument        : IOreq * pIoreq*/
/* Argument        : FLHandle irHandle*/
/* Argument        : FLDword irFlags*/
/* Argument        : void* irPath*/
/* Argument        : void * irData*/
/* Argument        : FLSDword irLength*/
/* Argument        : FLSDword irCount*/
/************************************************************************/
IOreq * tffsAPISetIoreq(IOreq * pIoreq, FLHandle irHandle, FLDword irFlags, void* irPath, void * irData, FLSDword irLength, FLSDword irCount)
{
	pIoreq->irCount = irCount;
	pIoreq->irData = irData;
	pIoreq->irFlags = irFlags;
	pIoreq->irHandle = irHandle;
	pIoreq->irLength = irLength;
	pIoreq->irPath =  irPath;
	return pIoreq;
}/*tffsAPISetIoreq*/

/* end of file tffs_api.c */


