/******************************************************************************
**  COPYRIGHT  2007 Marvell Inernational Ltd.
**  All Rights Reserved
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*  Copyright (C), 1995-2006, msystems Ltd. All rights reserved.              */
/*                                                                            */
/*  Redistribution and use in source and binary forms, with or without        */
/*  modification, are permitted provided that the following conditions are    */
/*  met:                                                                      */
/*  1. Redistributions of source code must retain the above copyright notice, */
/*     this list of conditions and the following disclaimer.                  */
/*  2. Redistributions in binary form must reproduce the above copyright      */
/*     notice, this list of conditions and the following disclaimer in the    */
/*     documentation and/or other materials provided with the distribution.   */
/*  3. Neither the name of msystems nor the names of its contributors may be  */
/*     used to endorse or promote products derived from this software without */
/*     specific prior written permission.                                     */
/*                                                                            */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED */
/*  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR             */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED  */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR    */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              */
/*                                                                            */
/******************************************************************************/
/*
 * $Log:   V:/PVCSDB/DiskOnChip/archives/Test for 7.x/src/H3/tffs_api.h-arc  $
 *
 *    Rev 1.25   Aug 09 2006 17:26:50   Polina.Marimont
 * initial for DOC Driver 1.0
 *
 *    Rev 1.24.1.0   Aug 08 2006 15:55:34   Polina.Marimont
 * DOC Driver 1.0 initial
 *
 *    Rev 1.23   Jun 18 2006 13:09:16   Polina.Marimont
 * AutoDPD and DPD parameters storage moved to SA SDK
 *
 *    Rev 1.22   Jun 14 2006 18:00:18   Polina.Marimont
 * structures definitions moved to this file
 *
 *    Rev 1.21   May 18 2006 09:48:50   polina.marimont
 * 1. added function for autoDPD support
 * 2. actual partition number API changed
 *
 *    Rev 1.20   Apr 11 2006 13:17:22   tal.heller
 * add DOCH_SECURE_DELETE_DATA_OFFSET define
 *
 *    Rev 1.19   Mar 22 2006 17:35:46   DoronC
 * Bug fix - add signature to disk attributes in order to use only
 * format made by TrueFFS 7.1 and not by host SDK.
 * Other format will force reformating of the media.
 *
 *    Rev 1.18   Mar 15 2006 16:18:18   DoronC
 * Bug fix - normal IPL of 8KB window was wrong.
 *
 *    Rev 1.17   Mar 15 2006 11:28:18   DoronC
 * Bug fix - IPL write was not working properly.
 *
 *    Rev 1.16   Mar 14 2006 09:54:16   DoronC
 * Bug fix - IPL size was limited to 1KB when righting normal node
 * IPL instead of 2KB
 *
 *    Rev 1.15   Mar 02 2006 08:30:54   DoronC
 * Bug fix - IPL was not working since size should be in sectors.
 *
 *    Rev 1.14   Feb 14 2006 10:50:02   DoronC
 * Remove large variables from stack. use one global buffer for
 * all large buffers needs.
 */

/***********************************************************************************/
/*																				   */
/*	Header file for sdk_api module												   */
/*																				   */
/***********************************************************************************/

#ifndef _TFFS_API
#define _TFFS_API

FLStatus bdCallTFFSToDOCH(FLFunctionNo functionNo, IOreq FAR2 *ioreq);

#ifdef BDK_ACCESS
typedef struct {
    FLDword dwStartReadSector;
    FLDword dwCurrentReadByte;
    FLDword dwReadLength;
    FLDword dwStartWriteSector;
    FLDword dwCurrentWriteByte;
    FLDword dwWriteLength;
    FLByte bWriteSubPartitionNum;
} sBdkInitValues;
#endif /*BDK_ACCESS*/

typedef struct __DocHVolume
{
	FLMutex mutex;
	FLByte numOfBinaryPartitions;
	FLByte iplExists;
	FLByte otpExists;
	FLBoolean verifyWrite;
	FLByte *intermediateBuf;
	FLDword mountCount[DOCH_MAX_PARTITIONS];
#ifdef BDK_ACCESS
	sBdkInitValues bdkInitValues;
#endif /*BDK_ACCESS*/
	FLDword dwVirtualUnitSize;
	FLDword dwVirtualUnitSizeInSectors;
	FLDword dwNumOfUnits;
	FLDword dwUnformattedCapacity;

	FLDword dwPowerMode[FL_SOCKETS]; /* saves power modes */
}DocHVolume;

/* MACRO: TFFS_API_IS_DPD_ON - determines whether one of Auto DPD modes defined */
#define TFFS_API_IS_AUTO_DPD_ON(socket) ( ((gDpdSettings.activeMode & DOCH_WM_NORMAL_AND_AUTO_STBY) == DOCH_WM_NORMAL_AND_AUTO_STBY) || \
									 ((gDpdSettings.activeMode & DOCH_WM_LOW_FREQ_AND_AUTO_STBY) == DOCH_WM_LOW_FREQ_AND_AUTO_STBY) || \
									 ((gDpdSettings.inActiveMode & DOCH_IM_IDLE_2_DPD) == DOCH_IM_IDLE_2_DPD) )
/* MACRO: TFFS_API_SAVE_DPD_STATES(socket) - saves the power modes into global variable */
#define TFFS_API_SAVE_POWER_MODES(socket) dochVol.dwPowerMode[socket] = gDpdSettings.inActiveMode | gDpdSettings.activeMode;

/********************/
/*	Defines			*/
/********************/

#define DOCH_SECTORS_IN_UNIT_BITS       9
#define DOCH_SECTORS_IN_UNIT            (1<<DOCH_SECTORS_IN_UNIT_BITS)

#define TFFS_API_MIGRATION_SIGNATURE "Migration1"
#define TFFS_API_OTP_PART_SIZE	0x3C00	/*15KB*/
#define TFFS_API_OTP_PART_SIZE_SECTORS (TFFS_API_OTP_PART_SIZE / DOCH_SECTOR_SIZE)

#define TFFS_API_128K_NORMAL_IPL_SIZE            0x40
#define TFFS_API_8K_NORMAL_IPL_SIZE              0x4
#define TFFS_API_VIRTUAL_RAM_8K_IPL_SIZE    0x10
#define TFFS_API_VIRTUAL_RAM_128K_IPL_SIZE  0x100
#define TFFS_API_PAGED_IPL_SIZE             0x200


/* Protection attributes  - backward compatibility	*/
#define PROTECTABLE           1   /* partition can receive protection */
#define READ_PROTECTED        2   /* partition is read protected      */
#define WRITE_PROTECTED       4   /* partition is write protected     */
#define LOCK_ENABLED          8   /* HW lock signal is enabled        */
#define LOCK_ASSERTED         16  /* HW lock signal is asserted       */
#define KEY_INSERTED          32  /* key is inserted (not currently   */
#define CHANGEABLE_PROTECTION 64  /* changeable protection area type  */
#define OTW_PROTECTED         128 /* partition is locked forever      */
#define STICKY_LOCK_ASSERTED  256 /* Sticky lock is activated         */

#define TFFS_PROTECTION_KEY_LENGTH	8


#define DOCH_IPL_PARTITION_NUM      0
#define TFFS_API_OTP_PARTITION_NUM  1

#define DOCH_MAX_USED_PARTITIONS    16

#define DOCH_SECURE_DELETE_DATA_OFFSET	8

/**********************/
/*	Exported routines */
/**********************/

FLStatus DochSetEnvVolume(FLEnvVars variableType ,
						  FLByte  socket,
						  FLByte  volume,
						  FLDword value,
						  FLDword FAR2 *prevValue);

FLStatus DochSetEnvSocket(FLEnvVars variableType ,
						  FLByte socket ,
						  FLDword value,
						  FLDword FAR2 *prevValue);

FLStatus DochSetEnvAll(FLEnvVars variableType , FLDword value, FLDword FAR2 *prevValue);

TFFS_DLL_API FLStatus NAMING_CONVENTION DochSetDocBusRoutine(FLByte  socket, FLAccessStruct FAR1 * structPtr);
TFFS_DLL_API FLStatus NAMING_CONVENTION DochGetDocBusRoutine(FLByte  socket, FLAccessStruct FAR1 * structPtr);

FLStatus actualPartitionNum(FLByte* partNum, FLByte partitionType, FLSDword sdwSocketNo);

FLStatus tffsApiSetAutoDpd( FLEnvVars envVarType, FLSDword dwsSocket, FLDword value,  FLDword FAR2 *prevValue );

FLStatus tffsApiInit(void);
FLStatus tffsApiExit(void);

#endif /*_TFFS_API*/
