

#include "defines.h" 

 



EXPORT void EXAPI Write_Byte(FLByte val,volatile void* address);
EXPORT void EXAPI Write_Word(FLWord val,volatile void* address);
EXPORT void EXAPI Write_Dword(FLDword val,volatile void* address);
EXPORT FLByte EXAPI Read_Byte(volatile void* address);
EXPORT FLWord EXAPI Read_Word(volatile void* address);
EXPORT FLDword EXAPI Read_Dword(volatile void* address);
EXPORT void EXAPI memcpy_from_io_8bit(FLByte  *dest, volatile FLByte  * src, FLWord count);
EXPORT void EXAPI memcpy_to_io_8bit( volatile FLByte  *dest,FLByte  *src, FLWord count);
EXPORT void EXAPI memset_to_io_8bit( volatile FLByte  * dest,FLByte val, FLWord count);
EXPORT void EXAPI memcpy_from_io_16bit(FLByte  *dest, volatile FLByte  * src, FLWord count);
EXPORT void EXAPI memcpy_to_io_16bit( volatile FLByte  *dest,FLByte  *src, FLWord count);
EXPORT void EXAPI memset_to_io_16bit( volatile FLByte  * dest,FLByte val, FLWord count);
EXPORT void EXAPI Get_Search_Range(FLDword *low_range,FLDword *high_range);
EXPORT void *Map_Memory(unsigned long dwAddress,unsigned long dwLen);


/***********************************************************************
 * Name : Write_Byte  
 *   Write a byte to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI Write_Byte(FLByte val,volatile void* address)  */
/*{                                                         */
/*}                                                         */



/***********************************************************************
 * Name : Write_Word
 *   Write a Word to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/* void EXAPI Write_Word(FLWord val,volatile void* address)      */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : Write_Dword  
 *   Write a Double Word to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI Write_Dword(FLDword val,volatile void* address)      */
/*{                                                               */
/*}                                                               */

/***********************************************************************
 * Name : Read_Byte  
 *   Read a Byte from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read byte
 *	
 ***********************************************************************/
/*FLByte EXAPI Read_Byte(volatile void* address)            */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : Read_Word  
 *   Read a Word from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read word
 *	
 ***********************************************************************/
/*FLWord EXAPI Read_Word(volatile void* address)            */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : Read_Dword  
 *   Read a Double Word from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read Double word
 *	
 ***********************************************************************/
/*FLDword EXAPI Read_Dword(volatile void* address)          */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : memcpy_from_io_8bit  
 *   Copy a block of bytes from flash to destination address
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   src   - source address
 *	 dest  - destiantion address
 *	 count - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_from_io_8bit(FLByte  *dest, volatile FLByte  * src, FLWord count)     */
/*{                                                                                       */
/*}                                                                                       */


/***********************************************************************
 * Name : memcpy_to_io_8bit  
 *   Copy block of bytes from memory address to flash address
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   dest   - flash destination address
 *	 src    - source address
 *	 count  - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_to_io_8bit( volatile FLByte  *dest,FLByte  *src, FLWord count)        */
/*{                                                                                       */
/*}                                                                                       */



/***********************************************************************
 * Name : memset_to_io_8bit  
 *   Set block of memory to a certain value
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   dest   - destination address
 *	 val    - the value to put in dest memory
 *	 count  - number of bytes to set.
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memset_to_io_8bit( volatile FLByte  * dest,FLByte val, FLWord count)     */
/*{                                                                                   */  
/*}                                                                                   */



/***********************************************************************
 * Name : memcpy_from_io_16bit  
 *   Copy a block of bytes from flash (that have 16-bit access) to 
 *   destination address.
 *   
 * 
 * Parameters:   
 *   src   - source address
 *	 dest  - destiantion address
 *	 count - number of words to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_from_io_16bit(FLByte  *dest, volatile FLByte  * src, FLWord count)     */
/*{                                                                                        */
/*}                                                                                        */


/***********************************************************************
 * Name : memcpy_to_io_16bit  
 *   Copy block of bytes from memory address to flash address 
 *   (that have 16-bit access).
 *   
 * 
 * Parameters:   
 *   dest   - flash destination address
 *	 src    - source address
 *	 count  - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_to_io_16bit( volatile FLByte  *dest,FLByte  *src, FLWord count)       */
/*{                                                                                       */
/*}                                                                                       */



/***********************************************************************
 * Name : memset_to_io_16bit  
 *   Set block of flash memory to a certain value
 *   Flash has 16-bit access.
 * 
 * Parameters:   
 *   dest   - destination address in flash
 *	 val    - the value to put in dest memory (this is a byte so in 16
 *            bit access, this val needs to be duplicated)
 *	 count  - number of bytes to set.
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memset_to_io_16bit( volatile FLByte  * dest,FLByte val, FLWord count)    */
/*{                                                                                   */  
/*}                                                                                   */


/***********************************************************************
 * Name : Get_Search_Range  
 *   Get the search range of the DOC 
 *   Enter the low and high addresses of the range in which the DOC
 *   is located.
 * 
 * Parameters:   
 *	
 * Outputs:
 *   low_range  - pointer to low range
 *   high_range - pointer to high range
 *
 * Return : none
 *	
 ***********************************************************************/
/*void EXAPI Get_Search_Range(FLDword *low_range,FLDword *high_range)  */
/*{                                                                    */
/*}                                                                    */



/***********************************************************************
 * Name : Map_Memory  
 *   Map block of memory that software use to the physical memory
 *   in which the DOC is located.
 *   
 * 
 * Parameters:   
 *	 dwAddress - start address of the block
 *   dwLen     - len of block in bytes
 *
 *
 * Return : none
 *	
 ***********************************************************************/
/*void *Map_Memory(unsigned long dwAddress,unsigned long dwLen)       */
/*{                                                                   */
/*}                                                                   */

