#ifndef __DEFINES__H__
#define __DEFINES__H__


#ifdef	__cplusplus
#define EXPORT extern "C" __declspec(dllexport)
#else
#define EXPORT __declspec(dllexport)
#endif


/*---------------------------------------------------------------------------------*/
/* device operation errors */
typedef enum
{

	EX_OK = 0,					          /* no error - must be equal flOK */
	EX_DEV_ERROR = 0x100,					/* wrong/unsupported device type passed to ext function */
	EX_COMMAND_ERROR,							/* wrong command passed to ext function */
	EX_COMMAND_LINE_ERROR,				/* wrong command line passed to ext function */
	EX_MALLOC_ERROR,							/* no enough memory */
	EX_OPEN_ERROR,								/* open device error */
	EX_CLOSE_ERROR,								/* close device error */
	EX_WRITE_ERROR,								/* write error */
	EX_READ_ERROR,								/* read error */
	EX_EOF_ERROR,								  /* No more data, as 'end of file' */
	EX_CMDLINE_PARAM_ERROR,				/* Wrong command line param */
	EX_USER_CUSTOM_ERROR,					/* user custom error */
	EX_TRUEFFS_ERROR,
	EX_HELP_SCREEN_ERROR,
	EX_BINARY_SDK_ERROR,
  EX_LOW_LIMIT_BIGGER_THAN_HIGH_LIMIT_ERROR,
  EX_EXTRA_ERROR = 0x200

}ExStatus;



typedef	unsigned char		EXBOOL;
typedef	char			      EXSBYTE;
typedef	unsigned char		EXBYTE;
typedef short					  EXSWORD;
typedef	unsigned short	EXWORD;
typedef long					  EXSDWORD;
typedef	unsigned long		EXDWORD;
typedef char					  EXTEXT;
typedef	char					  EXCHAR;
typedef	float					  EXFLOAT;
typedef	double					EXBOUBLE;


#define	EXFAR														/* far pointer */
#define	EXAPI							__cdecl				/* function calling convention */


/*---------------------------------------------------------------------------------*/
#define	EXNULL						  ((void*)0)
#define	EXTRUE						  1
#define	EXFALSE						  0

/*---------------------------------------------------------------------------------*/
#define EXDWORD_MAX				  0xffffffffl

/*---------------------------------------------------------------------------------*/
#define EXKBYTE					      (0x400L)
#define EXMBYTE					      (0x100000L)

/*---------------------------------------------------------------------------------*/
#define EX_TEXT(t)                     t


/*---------------------------------------------------------------------------------*/
#define EXMIN(x,y)				  ((x) < (y) ? (x) : (y))
#define EXMAX(x,y)				  ((x) > (y) ? (x) : (y))

/*---------------------------------------------------------------------------------*/
#define MAX_COMMANDS			  100
#define LAST_COMMAND			  "*****"

/*---------------------------------------------------------------------------------*/
#define COPYRIGHT				    "Copyright (C) M-Systems, 1992-2003"


/*--------------------------------------------------------------*/
/* typedefs for a mechanizm of displying set of options         */
/* for user and getting the option he chooses.                  */
/*--------------------------------------------------------------*/
typedef struct
{

	EXCHAR*     pName;   /* name of the option, for example : "Yes" or "No" */
	EXCHAR      cKey;    /* user answer as one char for example  'y' ot 'n' */

}ExChoices;

typedef struct
{

	EXCHAR*     pName;          /* string that will be presented to user */
	EXWORD      wNoOfChoices;   /* number of choises user have   */
	EXWORD      wDefaultChoice; /* default choice                */
	ExChoices*   pChoices;      /* ptr to previous typedef       */
	EXWORD      wResult;	      /* no of choiced or wNoOfChoices */

}ExWaitForCharChoices;


/*--------------------------------------------------------------*/
/* typedef for the function ExGetDiskFreea                      */
/*--------------------------------------------------------------*/
typedef struct
{
  EXDWORD     totalClusters;
  EXDWORD     availClusters;
  EXDWORD     sectorsPerCluster;
  EXDWORD     bytesPerSector;
} ExDiskInfoRecord;




#endif	/* __DEFINES__H__ */
