/*---------------------------------------------------------------------------------*/
/*------------                                                              -------*/
/*------------ FOR WIN32 OPERATING SYSTEM CONSOLE APPLOCATION				-------*/
/*------------                                                              -------*/
/*---------------------------------------------------------------------------------*/
				

/*---------------------------------------------------------------------------------*/

#include "defines.h"

#ifdef __cplusplus
extern "C"{
#endif

EXPORT ExStatus EXAPI ExOsOpenCmdLineDevice( void** data );
EXPORT ExStatus EXAPI ExOsCloseCmdLineDevice( void* data ) ;
EXPORT ExStatus EXAPI ExOsReadCmdLineDevice( void*data, EXWORD argc, void** retCommand ) ;
EXPORT ExStatus EXAPI ExOsOpenMsgDevice( void** data );
EXPORT ExStatus EXAPI ExOsWriteMsgDevice( void* data, EXCHAR* pStr );
EXPORT ExStatus EXAPI ExOsCloseMsgDevice( void* data );
EXPORT ExStatus EXAPI ExOsOpenErrorMsgDevice( void** data );
EXPORT ExStatus EXAPI ExOsCloseErrorMsgDevice( void* data );      
EXPORT ExStatus EXAPI ExOsWriteErrorMsgDevice( void* data, EXCHAR* pStr ) ;
EXPORT ExStatus EXAPI ExOsOpenPrgBarDevice( void** data, EXCHAR* pPrgBarName, EXDWORD dwPrgBarSize ) ;
EXPORT ExStatus EXAPI ExOsClosePrgBarDevice( void* data ) ;
EXPORT ExStatus EXAPI ExOsWritePrgBarDevice( void* data, EXDWORD dwDoneSoFar ) ;
EXPORT ExStatus EXAPI ExOsOpenFile( void** data, EXCHAR* name, EXWORD wMode ) ;
EXPORT ExStatus EXAPI ExOsCloseFile( void* data, EXWORD wMode ) ;
EXPORT ExStatus EXAPI ExOsWriteToFile( void* data, EXDWORD size, void EXFAR* buff ) ;
EXPORT ExStatus EXAPI ExOsReadFromFile( void* data, EXDWORD size, void EXFAR* buff, EXDWORD* byteRead ) ;
EXPORT ExStatus EXAPI ExOsGetLengthOfSerialFileDevice( void* data, EXDWORD* retLen ) ;
EXPORT ExStatus EXAPI ExOsOpenUserInputDevice( void** data ) ;
EXPORT ExStatus EXAPI ExOsCloseUserInputDevice( void* data ) ;
EXPORT ExStatus EXAPI ExOsWaitForCharUserInputDevice( void*data, ExWaitForCharChoices* waitForCharChoices );
EXPORT void* EXAPI ExMemAlloc( EXDWORD size );
EXPORT void EXAPI ExMemFree( void* memBlock );
EXPORT void* EXAPI ExMemSet( void* dest, EXWORD ch, EXDWORD size ) ;
EXPORT EXWORD EXAPI ExMemCmp( void* buf1, void* buf2, EXDWORD count ) ;
EXPORT void* EXAPI ExMemCpy( void* dest, void* src, EXDWORD count );
EXPORT EXSWORD EXAPI ExRand( void );
EXPORT void EXAPI ExSrand( EXWORD seed );
EXPORT EXDWORD EXAPI ExTime( EXSDWORD* timer );
EXPORT EXCHAR* EXAPI ExStrTime( EXCHAR* timestr );
EXPORT EXCHAR* EXAPI ExStrDate( EXCHAR* datestr );
EXPORT EXSDWORD EXAPI ExStrtol( const EXCHAR* nptr, EXCHAR** endptr, EXWORD radix );
EXPORT EXDWORD EXAPI ExStrtoul( const EXCHAR* nptr, EXCHAR** endptr, EXWORD radix );
EXPORT EXSWORD EXAPI ExAtoi( const EXCHAR* string ) ;
EXPORT EXCHAR* EXAPI ExItoa( EXSWORD value, EXCHAR* string, EXSWORD radix ) ;
EXPORT void EXAPI ExClearScreen( void ) ;
EXPORT EXWORD EXAPI ExStrLen( const EXCHAR* string ) ;
EXPORT EXCHAR* EXAPI ExStrCat( EXCHAR* strDestination, const EXCHAR* strSource );
EXPORT EXWORD EXAPI ExCreateDirectory( const EXCHAR* dirName ) ;
EXPORT EXWORD EXAPI ExGetDrive( void ) ;                   
EXPORT EXWORD EXAPI ExChangeDrive( EXWORD drive ) ;
EXPORT EXWORD EXAPI ExGetDiskFree( EXWORD drive, ExDiskInfoRecord* diskInfo ) ;
EXPORT EXCHAR EXAPI ExToupper( EXCHAR ch ) ;


/***********************************************************************
 * Name : ExOsOpenCmdLineDevice  
 *   Do nothing
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsOpenCmdLineDevice( void** data )        */
/*{                                                          */
/*}                                                          */

/***********************************************************************
 * Name : ExOsCloseCmdLineDevice  
 *   Do nothing 
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsCloseCmdLineDevice( void* data ) */
/*{                                                   */
/*}                                                   */


/***********************************************************************
 * Name : ExOsReadCmdLineDevice  
 *   read command line device
 * 
 * 
 * Parameters:   
 *   data         - not used
 *	 argc         - index of the command
 *	 retCommand   - the returned command from user
 * Outputs:
 *   EX_EOF_ERROR - when there is an error in argc
 *   EX_OK		  - when everything is fine
 ***********************************************************************/
/*ExStatus EXAPI ExOsReadCmdLineDevice( void*data, EXWORD argc, void** retCommand ) */
/*{                                                   */
/*}                                                   */




/***********************************************************************
 * Name : ExOsOpenMsgDevice  
 *   open message device
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsOpenMsgDevice( void** data )     */
/*{                                                   */
/*}                                                   */


/***********************************************************************
 * Name : ExOsCloseMsgDevice  
 *   close message device
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsCloseMsgDevice( void* data )     */
/*{                                                   */
/*}                                                   */


/***********************************************************************
 * Name : ExOsWriteMsgDevice  
 *   write to message device
 * 
 * 
 * Parameters:   
 *   pStr  - ptr to string that will be sent to msg device
 *	 data  - not used
 *	
 * Outputs:
 *   EX_WRITE_ERROR  - if we reached end of file
 *   EX_OK - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsWriteMsgDevice( void* data, EXCHAR* pStr )  */
/*{                                                              */
/*}                                                              */



/***********************************************************************
 * Name : ExOsOpenErrorMsgDevice  
 *   open error message device
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsOpenErrorMsgDevice( void** data )           */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsCloseErrorMsgDevice  
 *   close error message device
 * 
 * 
 * Parameters:   
 *   data  - not used
 *	 
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsCloseErrorMsgDevice( void* data )           */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsWriteErrorMsgDevice  
 *   write string to error message device
 * 
 * 
 * Parameters:   
 *   pStr  - string to be sent
 *	 data  - not used
 *	
 * Outputs:
 *   EX_WRITE_ERROR - if we reached EOF
 *   EX_OK - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsWriteErrorMsgDevice( void* data, EXCHAR* pStr ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsOpenPrgBarDevice  
 *   open progress bar device
 * 
 * 
 * Parameters:   
 *	 pPrgBarName  - progress bar name
 *	 dwPrgBarSize - progress bar size
 * Outputs:
 *   data            - ptr to memory allocated for the progress bar
 *   EX_MALLOC_ERROR - if there was allocation error
 *   EX_OK           - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsOpenPrgBarDevice( void** data, EXCHAR* pPrgBarName, EXDWORD dwPrgBarSize ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsClosePrgBarDevice  
 *   close progress bar device
 * 
 * 
 * Parameters:   
 *   data  - ptr to memory allocated for the progress bar, that needs to
 *	         be freed
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsClosePrgBarDevice( void* data )             */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsWritePrgBarDevice  
 *   write item to progress bar device
 * 
 * 
 * Parameters:   
 *   data		     - (casted to) ptr to progress bar
 *	 dwDoneSoFar - number of items that have been handeled so far
 *	
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 * 
 ***********************************************************************/
/*ExStatus EXAPI ExOsWritePrgBarDevice( void* data, EXDWORD dwDoneSoFar ) */
/*{                                                              */
/*}                                                              */



/***********************************************************************
 * Name : ExOsOpenFile  
 *   open a file
 * 
 * 
 * Parameters:   
 *   data  - gets the file pointer
 *	 name  - name of the file to open
 *	 wMode - can be EX_READ_ONLY_FILE
 *               or EX_WRITE_ONLY_FILE
 * Outputs:
 *   EX_OPEN_ERROR - when there is an error
 *   EX_OK         - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsOpenFile( void** data, EXCHAR* name, EXWORD wMode ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsCloseFile  
 *        Close file
 * 
 * 
 * Parameters:   
 *   data  - (casted to) File pointer
 *	 wMode - not used
 *	
 * Outputs:
 *   EX_CLOSE_ERROR - when there was an error while closing the file
 *   EX_OK          - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsCloseFile( void* data, EXWORD wMode )       */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsWriteToFile  
 *   Write data To File
 * 
 * 
 * Parameters:   
 *   data  - (casted to) file pointer
 *	 size  - num of bytes o write 
 *	 buff  - ptr to data to be written
 * Outputs:
 *   EX_WRITE_ERROR - when there was an error while writing to the file
 *   EX_OK - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsWriteToFile( void* data, EXDWORD size, void EXFAR* buff ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsReadFromFile  
 *   Read data From File
 * 
 * 
 * Parameters:   
 *   data  - (casted to) file pointer
 *	 size  - num of bytes to read
 *	 buff  - ptr to area into which data will be read
 *
 * Outputs:
 *   EX_EOF_ERROR - when there we reached EOF 
 *   EX_OK        - otherwise
 *   byteRead     - number of bytes read
 ***********************************************************************/
/*ExStatus EXAPI ExOsReadFromFile( void* data, EXDWORD size, void EXFAR* buff, EXDWORD* byteRead ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsGetLengthOfSerialFileDevice  
 *   Get Length Of Serial File Device 
 *     ( keep current position in a file )
 * 
 * Parameters:   
 *   data   - (casted to) file pointer
 *	
 * Outputs:
 *   retLen - len of the file
 *
 * Returns  : EX_READ_ERROR - when there is an error
 *				    EX_OK         - otherwise
 ***********************************************************************/
/*ExStatus EXAPI ExOsGetLengthOfSerialFileDevice( void* data, EXDWORD* retLen ) */
/*{                                                              */
/*}                                                              */




/***********************************************************************
 * Name : ExOsOpenUserInputDevice  
 *   Open user input Device 
 *     
 * 
 * Parameters:   
 *   data  - not used
 *	
 * Outputs:
 *   
 *
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 ***********************************************************************/
/*EXPORT ExStatus EXAPI ExOsOpenUserInputDevice( void** data )   */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExOsCloseUserInputDevice  
 *   Close User Input Device
 *  
 * 
 * Parameters:   
 *   data  - not used
 *	
 * Outputs:
 *
 * Returns : error (if any) of the type ExStatus 
 *           or EX_OK.
 ***********************************************************************/
/*EXPORT ExStatus EXAPI ExOsCloseUserInputDevice( void* data )   */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExOsWaitForCharUserInputDevice  
 *   Disply the choices that user have, and wait for a char input
 *  
 * Parameters:   
 *   data               - not used
 *	 waitForCharChoices - pointer to the struct that contain user options data
 * Outputs:
 * Returns  error (if any) of the type ExStatus 
 *          or EX_OK.
 ***********************************************************************/
/*EXPORT ExStatus EXAPI ExOsWaitForCharUserInputDevice( void*data, ExWaitForCharChoices* waitForCharChoices ) */
/*{                                                              */
/*}                                                              */




/***********************************************************************
 * Name : ExMemAlloc  
 *   Dinamic allocation of memory
 * 
 * 
 * Parameters:   
 *   size  - number of bytes to alocate
 *	 
 *	
 * Outputs:
 *   returns pointer to memory allocated
 * 
 ***********************************************************************/
/*EXPORT void* EXAPI ExMemAlloc( EXDWORD size )                  */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExMemFree  
 *   free dinamicaly allocated memory
 * 
 * 
 * Parameters:   
 *   memBlock  - ptr to memory allocated
 *	
 * Outputs:
 *   memBlock  - set to EXNULL
 *
 * Return      - none
 *   
 ***********************************************************************/
/*EXPORT void EXAPI ExMemFree( void* memBlock )                  */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExMemSet  
 *   set range of memory with a certain char 
 * 
 * 
 * Parameters:   
 *   dest  -  destination memory
 *	 ch    -  the char to be entered to all memory locations
 *	 size  -  number of bytes to set
 * Outputs:
 *
 * Returns :  the value of dest
 * 
 ***********************************************************************/
/*EXPORT void* EXAPI ExMemSet( void* dest, EXWORD ch, EXDWORD size ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExMemCmp  
 *   Compare characters in two buffers
 * 
 * 
 * Parameters:   
 *   buf1  - first buffer
 *	 buf2  - second buffer
 *	 count - number of characters
 * Outputs:
 *   The return value indicates the relationship between the buffers.
 *     < 0 buf1 less than buf2 
 *       0 buf1 identical to buf2 
 *     > 0 buf1 greater than buf2 
 * 
 ***********************************************************************/
/*EXPORT EXWORD EXAPI ExMemCmp( void* buf1, void* buf2, EXDWORD count ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExMemCpy  
 *   copy characters from src memory to destination memory
 * 
 * 
 * Parameters:   
 *   dest  - destination memory
 *	 src   - source memory
 *	 count - number of characters to copy
 * Outputs:
 *   returns the value of dest
 * 
 ***********************************************************************/
/*EXPORT void* EXAPI ExMemCpy( void* dest, void* src, EXDWORD count ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExRand  
 *   Generates a pseudorandom number
 * 
 * 
 * Parameters:   
 *   none
 *	 
 *	
 * Outputs:
 *   return the pseudorandom number
 * 
 ***********************************************************************/
/*EXSWORD EXAPI ExRand( void )                                   */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExSrand  
 *   Sets a random starting point
 * 
 * 
 * Parameters:   
 *   seed - Seed for random-number generation
 *	 
 *	
 * Outputs:
 *   none
 * 
 ***********************************************************************/
/*void EXAPI ExSrand( EXWORD seed )                              */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExTime  
 *    Gets the system time
 * 
 * Parameters:   
 *   timer - Storage location for time
 *	         if its NULL , return value is not stored
 *	
 * Outputs:
 *   time returns the time in elapsed seconds
 * 
 ***********************************************************************/
/*EXDWORD EXAPI ExTime( EXSDWORD* timer )                        */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExStrTime  
 *   Copy the time to a buffer
 *   The time is formatted as hh:mm:ss
 *   The buffer must be at least 9 bytes long.
 * Parameters:   
 *   timestr - Time string
 *	 
 *	
 * Outputs:
 *   returns a pointer to the resulting character string 
 * 
 ***********************************************************************/
/*EXCHAR* EXAPI ExStrTime( EXCHAR* timestr )                     */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExStrDate  
 *   copies a date to the buffer pointed to by datestr, 
 *   formatted mm/dd/yy
 * 
 * Parameters:   
 *   datestr  - date string
 *	 
 *	
 * Return:
 *   pointer to the resulting character string 
 * 
 ***********************************************************************/
/*EXCHAR* EXAPI ExStrDate( EXCHAR* datestr )                     */
/*{                                                              */
/*}                                                              */



/***********************************************************************
 * Name : ExStrtol  
 *      Convert strings to a long-integer value
 * 
 * 
 * Parameters:   
 *   nptr   - Null-terminated string to convert 
 *	 endptr - Pointer to character that stops scan
 *	 radix  - Number base to use
 * Return:
 *   returns the value represented in the string nptr
 * 
 ***********************************************************************/
/*EXSDWORD EXAPI ExStrtol( const EXCHAR* nptr, EXCHAR** endptr, EXWORD radix ) */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExStrtoul  
 *      Convert string to an unsigned long-integer value
 * 
 * 
 * Parameters:   
 *   nptr   - Null-terminated string to convert 
 *	 endptr - Pointer to character that stops scan
 *	 radix  - Number base to use
 * Outputs:
 *   returns the value represented in the string nptr
 * 
 ***********************************************************************/
/*EXDWORD EXAPI ExStrtoul( const EXCHAR* nptr, EXCHAR** endptr, EXWORD radix ) */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExAtoi  
 *   Convert strings to integer 
 * 
 * 
 * Parameters:   
 *   string  - String to be converted
 *	 
 *	
 * Outputs:
 *   returns the int value produced by interpreting the input characters as a number
 * 
 ***********************************************************************/
/*EXSWORD EXAPI ExAtoi( const EXCHAR* string )                   */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExItoa  
 *   Convert an integer to a string
 * 
 * 
 * Parameters:   
 *   value  - Number to be converted
 *	 string - String result
 *	 radix  - Base of value; must be in the range 2  36
 * Outputs:
 *   returns a pointer to string
 * 
 ***********************************************************************/
/*EXCHAR* EXAPI ExItoa( EXSWORD value, EXCHAR* string, EXSWORD radix ) */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExClearScreen  
 *   Clear the Screen
 * 
 * 
 * Parameters:   
 *   none
 *	 
 *	
 * Outputs:
 *   none
 * 
 ***********************************************************************/
/*void EXAPI ExClearScreen( void )                               */
/*{                                                              */
/*}                                                              */



/***********************************************************************
 * Name : ExStrLen  
 *   calc string length
 * 
 * 
 * Parameters:   
 *   string  - Null-terminated string that we want to know its length
 *	 
 *	
 * Outputs:
 *   returns string len
 * 
 ***********************************************************************/
/*EXWORD EXAPI ExStrLen( const EXCHAR* string )                  */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExStrCat  
 *   The strcat function appends strSource to strDestination 
 *   and terminates the resulting string with a null character
 * 
 * 
 * Parameters:   
 *   strDestination - Null-terminated destination string
 *	 strSource      - Null-terminated source string
 *	
 * Outputs:
 *   returns the destination string 
 * 
 ***********************************************************************/
/*EXCHAR* EXAPI ExStrCat( EXCHAR* strDestination, const EXCHAR* strSource ) */
/*{                                                              */
/*}                                                              */



/***********************************************************************
 * Name : ExCreateDirectory  
 *        Create a new directory.
 * 
 * 
 * Parameters:   
 *   dirName  - Path for new directory
 *	 
 *	
 * Outputs:
 *   returns the value 0 if the new directory was created
 *   returns 1 On an error 
 ***********************************************************************/
/*EXWORD EXAPI ExCreateDirectory( const EXCHAR* dirName )        */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExGetDrive  
 *   Gets the current disk drive.
 * 
 * 
 * Parameters:   
 *   none
 *	 
 *	
 * Outputs:
 *   returns the current (default) drive (1=A, 2=B, and so on)
 * 
 ***********************************************************************/
/*EXWORD EXAPI ExGetDrive( void )                                */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExChangeDrive  
 *   Changes the current working drive.
 * 
 * 
 * Parameters:   
 *   drive  - Number of new working drive
 *	
 *	
 * Outputs:
 *   return  0 if the working drive is successfully changed.
 *   return 1 if there is an error
 * 
 ***********************************************************************/
/*EXWORD EXAPI ExChangeDrive( EXWORD drive )                     */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : ExGetDiskFree  
 *   get information about available sectors and clusters in the disk
 * 
 * 
 * Parameters:   
 *   drive  - drive name
 *	 diskInfo - ptr to ExDiskInfoRecord
 *	
 * Outputs:
 *   If the function succeeds, the return value is nonzero
 * 
 ***********************************************************************/
/*EXWORD EXAPI ExGetDiskFree( EXWORD drive, ExDiskInfoRecord* diskInfo ) */
/*{                                                              */
/*}                                                              */


/***********************************************************************
 * Name : ExToupper  
 *    Convert a char from lower to upper case
 * 
 * 
 * Parameters:   
 *   ch  - char in lower case
 *	 
 *	
 * Outputs:
 *   returns a char in upper case 
 * 
 ***********************************************************************/
/*EXCHAR EXAPI ExToupper( EXCHAR ch )                            */
/*{                                                              */
/*}                                                              */


#ifdef __cplusplus
}
#endif

