

#include "defines.h" 

 



EXPORT void EXAPI Write_Byte(FLByte val,volatile void* address);
EXPORT void EXAPI Write_Word(FLWord val,volatile void* address);
EXPORT void EXAPI Write_Dword(FLDword val,volatile void* address);
EXPORT FLByte EXAPI Read_Byte(volatile void* address);
EXPORT FLWord EXAPI Read_Word(volatile void* address);
EXPORT FLDword EXAPI Read_Dword(volatile void* address);
EXPORT void EXAPI memcpy_from_io_8bit(FLByte  *dest, volatile FLByte  * src, FLWord count);
EXPORT void EXAPI memcpy_to_io_8bit( volatile FLByte  *dest,FLByte  *src, FLWord count);
EXPORT void EXAPI memset_to_io_8bit( volatile FLByte  * dest,FLByte val, FLWord count);
EXPORT void EXAPI memcpy_from_io_16bit(FLByte  *dest, volatile FLByte  * src, FLWord count);
EXPORT void EXAPI memcpy_to_io_16bit( volatile FLByte  *dest,FLByte  *src, FLWord count);
EXPORT void EXAPI memset_to_io_16bit( volatile FLByte  * dest,FLByte val, FLWord count);
EXPORT void EXAPI Get_Search_Range(FLDword *low_range,FLDword *high_range);
EXPORT void *Map_Memory(unsigned long dwAddress,unsigned long dwLen);


EXPORT void PARA_Write8BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte bVal);
EXPORT void PARA_Write16BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLWord wVal);
EXPORT void PARA_Write8BitDifferentDataRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte *bDataArr);
EXPORT void PARA_WriteBufferRoutine (volatile FLByte EXFAR *win, FLWord wOffset,FLByte EXFAR* bBufferArr,FLWord wBufferLength);
EXPORT int PARA_Verify8BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte bCompareByte,FLByte bByteMask,FLBoolean *fCompareArr);
EXPORT int PARA_VerifyBufferRoutine (volatile FLByte EXFAR*win,FLWord wOffset,FLByte EXFAR* bCompareBufferArr,FLWord wBufferLength,FLBoolean *fCompareArr);
EXPORT int PARA_ActivateSocketsRoutine (FLBoolean *fSocketStateArr);
EXPORT int PARA_GetSocketStatusRoutine (FLBoolean *fSocketStateArr);
EXPORT int PARA_AccessLayerInitRoutine (void *flashPtrArr[]);






/***********************************************************************
 * Name : Write_Byte  
 *   Write a byte to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI Write_Byte(FLByte val,volatile void* address)  */
/*{                                                         */
/*}                                                         */



/***********************************************************************
 * Name : Write_Word
 *   Write a Word to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/* void EXAPI Write_Word(FLWord val,volatile void* address)      */
/*{                                                              */
/*}                                                              */

/***********************************************************************
 * Name : Write_Dword  
 *   Write a Double Word to the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 val       - value to write
 *	
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI Write_Dword(FLDword val,volatile void* address)      */
/*{                                                               */
/*}                                                               */

/***********************************************************************
 * Name : Read_Byte  
 *   Read a Byte from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read byte
 *	
 ***********************************************************************/
/*FLByte EXAPI Read_Byte(volatile void* address)            */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : Read_Word  
 *   Read a Word from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read word
 *	
 ***********************************************************************/
/*FLWord EXAPI Read_Word(volatile void* address)            */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : Read_Dword  
 *   Read a Double Word from the address location
 *   
 * 
 * Parameters:   
 *   address   - memory address
 *	 
 *	
 * Outputs:
 *   The read Double word
 *	
 ***********************************************************************/
/*FLDword EXAPI Read_Dword(volatile void* address)          */
/*{                                                         */
/*}                                                         */

/***********************************************************************
 * Name : memcpy_from_io_8bit  
 *   Copy a block of bytes from flash to destination address
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   src   - source address
 *	 dest  - destiantion address
 *	 count - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_from_io_8bit(FLByte  *dest, volatile FLByte  * src, FLWord count)     */
/*{                                                                                       */
/*}                                                                                       */


/***********************************************************************
 * Name : memcpy_to_io_8bit  
 *   Copy block of bytes from memory address to flash address
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   dest   - flash destination address
 *	 src    - source address
 *	 count  - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_to_io_8bit( volatile FLByte  *dest,FLByte  *src, FLWord count)        */
/*{                                                                                       */
/*}                                                                                       */



/***********************************************************************
 * Name : memset_to_io_8bit  
 *   Set block of memory to a certain value
 *   Flash has 8-bit access.
 * 
 * Parameters:   
 *   dest   - destination address
 *	 val    - the value to put in dest memory
 *	 count  - number of bytes to set.
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memset_to_io_8bit( volatile FLByte  * dest,FLByte val, FLWord count)     */
/*{                                                                                   */  
/*}                                                                                   */



/***********************************************************************
 * Name : memcpy_from_io_16bit  
 *   Copy a block of bytes from flash (that have 16-bit access) to 
 *   destination address.
 *   
 * 
 * Parameters:   
 *   src   - source address
 *	 dest  - destiantion address
 *	 count - number of words to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_from_io_16bit(FLByte  *dest, volatile FLByte  * src, FLWord count)     */
/*{                                                                                        */
/*}                                                                                        */


/***********************************************************************
 * Name : memcpy_to_io_16bit  
 *   Copy block of bytes from memory address to flash address 
 *   (that have 16-bit access).
 *   
 * 
 * Parameters:   
 *   dest   - flash destination address
 *	 src    - source address
 *	 count  - number of bytes to copy
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memcpy_to_io_16bit( volatile FLByte  *dest,FLByte  *src, FLWord count)       */
/*{                                                                                       */
/*}                                                                                       */



/***********************************************************************
 * Name : memset_to_io_16bit  
 *   Set block of flash memory to a certain value
 *   Flash has 16-bit access.
 * 
 * Parameters:   
 *   dest   - destination address in flash
 *	 val    - the value to put in dest memory (this is a byte so in 16
 *            bit access, this val needs to be duplicated)
 *	 count  - number of bytes to set.
 * Outputs:
 *   none
 *	
 ***********************************************************************/
/*void EXAPI memset_to_io_16bit( volatile FLByte  * dest,FLByte val, FLWord count)    */
/*{                                                                                   */  
/*}                                                                                   */


/***********************************************************************
 * Name : Get_Search_Range  
 *   Get the search range of the DOC 
 *   Enter the low and high addresses of the range in which the DOC
 *   is located.
 * 
 * Parameters:   
 *	
 * Outputs:
 *   low_range  - pointer to low range
 *   high_range - pointer to high range
 *
 * Return : none
 *	
 ***********************************************************************/
/*void EXAPI Get_Search_Range(FLDword *low_range,FLDword *high_range)  */
/*{                                                                    */
/*}                                                                    */



/***********************************************************************
 * Name : Map_Memory  
 *   Map block of memory that software use to the physical memory
 *   in which the DOC is located.
 *   
 * 
 * Parameters:   
 *	 dwAddress - start address of the block
 *   dwLen     - len of block in bytes
 *
 *
 * Return : none
 *	
 ***********************************************************************/
/*void *Map_Memory(unsigned long dwAddress,unsigned long dwLen)       */
/*{                                                                   */
/*}                                                                   */



/* start of Parallel routines */


/***********************************************************************************
 *  Name: PARA_Write8BitRoutine
 *    Write same data (byte) to same address, in all activated sockets 
 *    in parallel. 
 *                                                                      
 *  Inputs:
 *    win                  : Socket window base address                      
 *    wOffset              : Offset from base address.
 *    bVal                 : Value to be written to all activated 
 *                           sockets.
 ***********************************************************************************/
/*void PARA_Write8BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte bVal)*/
/*{																					*/
/*}																					*/

/***********************************************************************************
 *  Name: PARA_Write16BitRoutine
 *    Write same data (word) to same address, in all activated sockets 
 *    in parallel. 
 *                                                                      
 *  Inputs:
 *    win                  : Socket window base address                      
 *    wOffset              : Offset from base address.
 *    wVal                 : Value to be written to all activated 
 *                           sockets.
 ***********************************************************************************/
/*void PARA_Write16BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLWord wVal)	*/
/*{																						*/ 
/*}																						*/

/***********************************************************************************
 *  Name: PARA_Write8BitDifferentDataRoutine
 *    Write different data (byte) to same address in all activated 
 *    sockets in parallel.
 *                                                                      
 *  Inputs:
 *    win                  : Socket window base address                      
 *    wOffset              : Offset from base address.
 *    bDataArr:            : Data array.Each entry is the data (byte) 
 *                           that should be sent for each socket.  
 ***********************************************************************************/
/*void PARA_Write8BitDifferentDataRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte *bDataArr)	*/
/*{																										*/
/*}																										*/


/***********************************************************************************
 *  Name: PARA_WriteBufferRoutine
 *    Write buffer to same address in all activated sockets in parallel. 
 *
 * Inputs:
 *   Win                   : Socket window Base Address 
 *   wOffset               : Offset from base address.
 *   Buffer                : Written buffer.  
 *   wBufferLength         : Length of buffer.
 ***********************************************************************************/
/*void PARA_WriteBufferRoutine (volatile FLByte EXFAR *win, FLWord wOffset,FLByte EXFAR* bBufferArr,FLWord wBufferLength) */
/*{																														  */
/*}																														  */

  
/***********************************************************************************
 *  Name: PARA_Verify8BitRoutine
 *    Read byte from all sockets and compare it to a predefined value.  
 *
 *  Inputs:
 *   win                   : Socket window Base Address 
 *   wOffset               : Offset from base address.
 *   bCompareByte          : The value to compare against the value read from 
 *                           sockets.
 *   bByteMask             : Byte mask (zero bits would be masked)
 *
 *  Return value:
 *	  TRUE                 : All sockets return data identical to bCompareByte
 * 	  FALSE                : All sockets did not return data which is identical 
 *                           to bCompareByte.
 ***********************************************************************************/
/*FLBoolean PARA_Verify8BitRoutine (volatile FLByte EXFAR *win,FLWord wOffset,FLByte bCompareByte,FLByte bByteMask,FLBoolean *fCompareArr)	*/
/*{																																			*/
/*}																																			*/


/***********************************************************************************
 *  Name: PARA_VerifyBufferRoutine
 *    Read buffer from all sockets and compare it to a predefined value. 
 *
 *  Inputs:
 *    win                   : Socket window Base Address 
 *    wOffset               : Offset from base address.
 *    bCompareBufferArr     : The buffer to compare against the buffer read from sockets 
 *    wBufferLength         :Buffer length.
 *
 *  Return value:
 *	  TRUE                 : All sockets return data identical to bCompareBufferArr
 *	  FALSE                : All sockets did not return data which is identical 
 *                           to bCompareBufferArr.
 ***********************************************************************************/
/* FLBoolean PARA_VerifyBufferRoutine (volatile FLByte EXFAR*win,FLWord wOffset,FLByte EXFAR* bCompareBufferArr,FLWord wBufferLength,FLBoolean *fCompareArr) */
/*{																																							 */
/*}																																							 */

/***********************************************************************************
 *  Name: PARA_ActivateSocketsRoutine
 *    Enable/Disable sockets 
 *
 *  Inputs:
 *    bSocketStateArr: Array which each entry describes the state of its socket.
 *                     The allowed states are:
 *	                   - FL_OFF: Socket disabled..
 *	                   - FL_ON:  Socket enabled.  
 *
 *  Outputs: 
 *    None.
 *
 *  Return value:
 *	  flOK: In case of success.
 *	  flVppFailure : In case that operation failed,in that case bSocketStateArr 
 *                   would be filled in the following way:
 *	                 The entry for socket X would be changed only if the enabling or 
 *                   disabling this socket fails.
 ***********************************************************************************/
/* int PARA_ActivateSocketsRoutine (FLBoolean *fSocketStateArr) */
/*{																*/
/*}																*/

/***********************************************************************************
 *  Name: PARA_GetSocketStatusRoutine
 *    Enable/Disable sockets 
 *
 *  Inputs:
 *    None. 
 *
 *  Outputs: 
 *    bSocketStateArr: Array which each entry describes the current state of its socket.
 *                     - FL_OFF: Socket disabled.
 *	                   - FL_ON:  Socket enabled.  
 *
 *  Return value:
 *	  flOK: In case of success.
 *	  flVppFailure : In case that operation failed.
 ***********************************************************************************/
/*int PARA_GetSocketStatusRoutine (FLBoolean *fSocketStateArr) */
/*{															   */
/*}															   */


/***********************************************************************************
 *  Name: PARA_AccessLayerInitRoutine
 *    Initializion of the access layer 
 *
 *  Inputs:
 *    flashPtrArr          : Flash pointer array of all scockets
 *
 *  Outputs: 
 *    None
 *
 *  Return value:
 *	  flOK: In case of success, otherwise fail status.
 ***********************************************************************************/
/*int PARA_AccessLayerInitRoutine (void *flashPtrArr[]) */
/*{														*/
/*}														*/

/* end of Parallel routines */


