Summary: The boot loader for Linux and other operating systems.
Name: doc-lilo
Version: 0.21
Release: 19
Exclusivearch: i386
Copyright: MIT
Group: System Environment/Base
Source: ftp://lrcftp.epfl.ch/pub/linux/local/lilo/lilo-21.tar.gz
Source2: keytab-lilo.c
Patch0: lilo-0.21-include.patch
Patch1: lilo-0.21-1.1.patch
Patch2: http://www.insync.net/~frantzc/lilo.patch
Patch3: lilo.raid1
Patch4: lilo-0.21-loopdev.patch
Patch5: lilo-0.21-second.patch
Patch6: lilo-0.21-doc.patch
Patch7: lilo-0.21-tbr.patch
Patch8: lilo-0.21-major100
Buildroot: /var/tmp/lilo-root

%description
LILO (LInux LOader) is a basic system program which boots your Linux
system.  LILO loads the Linux kernel from a floppy or a hard drive,
boots the kernel and passes control of the system to the kernel.  LILO
can also boot other operating systems.

This version has been patched to support the M-Systems DOC.

%prep
%setup -q -n lilo
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p0
%patch6 -p0
%patch7 -p1
%patch8 -p1

%build
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr
make install ROOT=$RPM_BUILD_ROOT

%clean

%files
%defattr(-,root,root)
/boot/doc.b
/sbin/doc-lilo

%post
sed 's/install=\/boot\/boot.b/install=\/boot\/doc.b/' < /etc/lilo.conf > /etc/doc-lilo.conf
cat <<-EOF

The M-Systems DOC compatible version of lilo is the following files:

        /sbin/doc-lilo
        /boot/doc.b

Your /etc/lilo.conf has been modified to use and is in:

        /etc/doc-lilo.conf

Please verify and install by doing:

        doc-lilo -v -C /etc/doc-lilo.conf

and then reboot.

EOF

%changelog
* Wed Feb  2 2000 Bill Nottingham <notting@redhat.com>
- add %defattr

* Fri Jan 28 2000 Bill Nottingham <notting@redhat.com>
- keytab-lilo is now a c program

* Thu Jan 20 2000 Cristian Gafton <gafton@redhat.com>
- oot added the loopdev patches
- revert the raid patch

* Mon Jan 17 2000 Cristian Gafton <gafton@redhat.com>
- slightly modify the raid patch so we can check for invalid 
  devices before opening them
- add -second patch to fix parsing the command line args

* Tue Sep 21 1999 Doug Ledford <dledford@redhat.com>
- Remove the EBDA patch from zab and put in the EBDA patch
  from the VA Research RPM.  This fixes the EBDA issues.
- Added ONE_SHOT to the compile options so that the lilo
  prompt won't timeout once you hit a key at the boot prompt

* Sat Sep 11 1999 Cristian Gafton <gafton@redhat.com>
- don't run lilo in the %post (why was that necesary?)

* Tue Apr 13 1999 Matt Wilson <msw@redhat.com>
- added patch to make Compaq SmartArrays bootable

* Wed Mar 24 1999 Bill Nottingham <notting@redhat.com>
- add EBDA patch from zab

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Thu Mar 18 1999 Cristian Gafton <gafton@redhat.com>
- add keytab-lilo.pl to the file list

* Sun Dec  6 1998 Matt Wilson <msw@redhat.com>
- updated to release 0.21
- patched to build on 2.1.x kernels

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sun Oct 19 1997 Erik Troan <ewt@redhat.com>
- updated to release 0.20
- uses a build root

* Tue Jul 08 1997 Erik Troan <ewt@redhat.com>
- built against glibc

