#ifndef IOCTL_H
#define IOCTL_H
    

/* List of status codes */

typedef enum {                          /* Status code for operation.
               A zero value indicates success,
               other codes are the extended
               DOS codes. */
     flOK                      = 0,
     flBadFunction             = 1,
     flFileNotFound            = 2,
     flPathNotFound            = 3,
     flTooManyOpenFiles        = 4,
     flNoWriteAccess           = 5,
     flBadFileHandle           = 6,
     flDriveNotAvailable       = 9,
     flNonFATformat            = 10,
     flFormatNotSupported      = 11,
     flNoMoreFiles             = 18,
     flWriteProtect            = 19,
     flBadDriveHandle          = 20,
     flDriveNotReady           = 21,
     flUnknownCmd              = 22,
     flBadFormat               = 23,
     flBadLength               = 24,
     flDataError               = 25,
     flUnknownMedia            = 26,
     flSectorNotFound          = 27,
     flOutOfPaper              = 28,
     flWriteFault              = 29,
     flReadFault               = 30,
     flGeneralFailure          = 31,
     flDiskChange              = 34,
     flVppFailure              = 50,
     flBadParameter            = 51,
     flNoSpaceInVolume         = 52,
     flInvalidFATchain         = 53,
     flRootDirectoryFull       = 54,
     flNotMounted              = 55,
     flPathIsRootDirectory     = 56,
     flNotADirectory           = 57,
     flDirectoryNotEmpty       = 58,
     flFileIsADirectory        = 59,
     flAdapterNotFound         = 60,
     flFormattingError         = 62,
     flNotEnoughMemory         = 63,
     flVolumeTooSmall          = 64,
     flBufferingError          = 65,
     flFileAlreadyExists       = 80,
     flIncomplete              = 100,
     flTimedOut                = 101,
     flTooManyComponents       = 102,
     flTooManyDrives           = 103,
     flTooManyBinaryPartitions = 104,
     flPartitionNotFound       = 105,
     flFeatureNotSupported     = 106,
     flWrongVersion            = 107,
     flTooManyBadBlocks        = 108,
     flNotProtected            = 109,
     flUnchangeableProtection  = 110,
     flBadDownload             = 111,
     flBadBBT                  = 112,
     flInterlreavError         = 113,
     flWrongKey                = 114,
     flHWProtection            = 115,
     flTimeOut                 = 116

     } FLStatus;

/* List of all IOCTL requests ( IOCTL ID ) */

#define DEEPOWER_MODE_IOCTL         "DEEPOWER"
#define DEFRAG_IOCTL                "DEFRAG"
#define CUSTOMER_ID_IOCTL           "CUSTOMER"
#define UNIQUE_ID_IOCTL             "UNIQUE"
#define BDTL_HW_PROTECTION_IOCTL    "BDTLHW"
#define GET_INFO_IOCTL              "GETINFO"


typedef unsigned char  byte;        /* 8  bit unsigned variable */
typedef unsigned short word;        /* 16 bit unsigned variable */
typedef unsigned long  dword;       /* 32 bit unsigned variable */


/* General IOCTL request structure */
typedef struct    {
  char        id[16];        
  void far* DiskInput;
  void far* DiskOutput;
} DeleteSectorsPacket;


/* PowerDown Input/Output structure */


typedef struct {
FLStatus status;
} flOutputStatusRecord;

#define POWER_DOWN_ON 1
#define POWER_DOWN_OFF 0

typedef struct {
byte state;
} flPowerDownInput;



/* Delete Sectors Input/Output structure */

typedef struct {
  long firstSector;                /* First logical sector to delete */
  long numberOfSectors;                /* Number of sectors to delete */
} flDeleteSectorsInput;

/* GetInfo Input/Output structure */

typedef struct {
  unsigned long  logicalSectors;    /*  number of logical sectors                  */
  unsigned long  bootAreaSize;      /*  boot area size                             */
  unsigned long  baseAddress;       /*  physical base address                      */

  unsigned short flashType;         /*  JEDEC id of the flash                      */
  unsigned long  physicalSize;      /*  physical size of the media                 */
  unsigned short physicalUnitSize;  /*  Erasable block size                        */
  char DOCType;                     /*  DiskOnChip type (MDoc/Doc2000)             */
  char lifeTime;                    /*  Life time indicator for the media (1-10)   */
                    /*  1 - the media is fresh,                    */
                    /*  10 - the media is close to its end of life */

  char driverVer[10];               /*  driver version (NULL terminated string)    */
  char OSAKVer[10];                 /*  OSAK version that driver is based on
                    (NULL terminated string)                   */

  unsigned long cylinders;          /*  Media.....                                 */
  unsigned long heads;              /*            geometry......                   */
  unsigned long sectors;            /*                            parameters.      */

} VolumeInfoRecord;


typedef struct {
  VolumeInfoRecord info;
  FLStatus status;
} flDiskInfoOutput;


/* Defrag Input/Output structures */

typedef struct {
  long requiredNoOfSectors;  /* # of sectors to be freed */
} flDefragInput;

typedef struct {
  long actualNoOfSectors;    /* # of sectors that were freed */
  FLStatus status;
} flDefragOutput;


/* Customer&Unique ID Output structures */

typedef struct {
  byte id[4];             /* customer id */
  FLStatus status;
} flCustomerIdOutput;


typedef struct {
  byte id[16];            /* customer id */
  FLStatus status;
} flUniqueIdOutput;


/* HW-protect Input/OutPut structures and definitions */

#define PROTECTION_INSERT_KEY   0
#define PROTECTION_REMOVE_KEY   1
#define PROTECTION_GET_TYPE     2
#define PROTECTION_DISABLE_LOCK 3
#define PROTECTION_ENABLE_LOCK  4
#define PROTECTION_CHANGE_KEY   5
#define PROTECTION_CHANGE_TYPE  6

#define READ_PROTECTED 2
#define WRITE_PROTECTED 4

/*
typedef struct {
  FLStatus status;
} flOutputStatusRecord;
  */
typedef struct {
   byte protectionType;
   byte key[8];
   byte type;
} flProtectionInput;


#endif