#include "ioctltst.h"


/*****************/
/**             **/
/**  Self Test  **/
/**             **/
/*****************/

void batchTest(unsigned char drive, char* key)
{
	byte type, attr;
	long firstSector, numberOfSectors;
	long sectors = -99;
	IOCTLRequestPacket request;
	FLStatus status = flOK;
	struct REGPACK reg;
	byte buf[10];


	/***************/
	/*  Get Info   */
	/***************/
	if( getInfo(drive) != flOK )
	{
		PRINTF ("ERROR: get info\n");
		return;
	}


	/*****************/
	/* Defrag Volume */
	/*****************/

	sectors = 1000;
	if( defragVolume(drive,sectors) != flOK )
	{
		PRINTF ("ERROR: defrage\n");
		return;
	}
	else if( defragVolume(drive,sectors) != flOK )
	{
		PRINTF ("ERROR: defrage\n");
		return;
	}

	/***************/
	/* HW OTP      */
	/***************/

	memcpy( buf, "ZTAK REMO", 9 );

	strcpy(request.id,HW_OTP_IOCTL);
	request.DiskInput  = (flOtpInput far*)malloc(sizeof(flOtpInput));;
	((flOtpInput far*)(request.DiskInput))->type = OTP_SIZE;
	request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
	executeCommand(drive,&request,&reg);
	status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
	if( reg.r_flags & CF )
	{
		free (request.DiskInput);
		free (request.DiskOutput);
		PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
		PRINTF ("ERROR: Get OTP\n");
		return;
	}
	PRINTF("OTP area information:\n");
	PRINTF("\tOTP size: %ld\n",((flOtpInput far*)(request.DiskInput))->length );
	PRINTF("\tOTP used: %ld\n",((flOtpInput far*)(request.DiskInput))->usedSize );
	if( ((flOtpInput far*)(request.DiskInput))->lockedFlag == 1 )
	PRINTF("\tOTP locked\n\n");

	if( ((flOtpInput far*)(request.DiskInput))->lockedFlag == 1 )
	{
		((flOtpInput far*)(request.DiskInput))->length = 2;
		((flOtpInput far*)(request.DiskInput))->usedSize = 3;
		((flOtpInput far*)(request.DiskInput))->buffer = buf;
		((flOtpInput far*)(request.DiskInput))->type = OTP_READ;
		executeCommand(drive,&request,&reg);
		status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
		if( reg.r_flags & CF )
		{
			free (request.DiskInput);
			free (request.DiskOutput);
			PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
			PRINTF ("ERROR: Read OTP\n");
			return;
		}
	}
	else
	{
		((flOtpInput far*)(request.DiskInput))->length = 9;
		((flOtpInput far*)(request.DiskInput))->buffer = buf;
		((flOtpInput far*)(request.DiskInput))->type = OTP_WRITE_LOCK;
		executeCommand(drive,&request,&reg);
		status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
		if( reg.r_flags & CF )
		{
			free (request.DiskInput);
			free (request.DiskOutput);
			PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
			PRINTF ("ERROR: Write OTP\n");
			return;
		}
	}


	/***************/
	/* Customer ID */
	/***************/
	if( getCustomerID(drive) != flOK )
	{
		PRINTF ("ERROR: customer ID\n");
		return;
	}
  

	/***************/
	/* Unique ID   */
	/***************/
	if( getUniqueID(drive) != flOK )
	{
		PRINTF ("ERROR: unique ID\n");
		return;
	}

	/***************/
	/* Deep Power	 */
	/***************/
	if( deepPowerMode(drive) != flOK )
	{
		PRINTF ("ERROR: deep Power ID\n");
		return;
	}

	/*******************/
	/* BDTL Protection */
	/*******************/

	batchBDTLProtect(drive, "12345678" );


	/***************/
	/* Del sectors */
	/***************/

	// to do: write to sector 150 and verify erase
	firstSector = 100;
	numberOfSectors = 100;
	status = deleteSectors(drive,firstSector,numberOfSectors);

	if(status == flHWProtection)
	{
		PRINTF ("ERROR: Del Sectors failed on Protection\n");
	}
	else if(status != flOK)
	{
		PRINTF ("ERROR: Del Sectors\n");
		return;
	}

	PRINTF("ALL TESTS PASSED!");

}



void batchBDTLProtect(unsigned char drive, char* key)
{

 byte type, attr;
	char 		newkey[8] = "11111111";

 type = PROTECTION_GET_TYPE;						// Check that the protection is changable
 if (protectHWBDTL (drive, 0, NULL, &type))
 {
	PRINTF ("ERROR: get type (try 1) failed\n");
	return;
 }
 if (type & CHANGEABLE_PROTECTION != CHANGEABLE_PROTECTION)
 {
	PRINTF ("ERROR: Media must be changable protected.\n");
	return;
 }
 // Check that the protection is changable.
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, key, &type)!=0) // insert key
 {
	PRINTF ("ERROR - Key insert faild!\n");
	return;
 }

 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 2) failed\n");
	return;
 }
 if (type & KEY_INSERTED != KEY_INSERTED) // check that key inserted
 {
	PRINTF ("ERROR: Key inserted but get type say otherwise.\n");
	return;
 }
 type = PROTECTION_REMOVE_KEY;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)// remove key
 {
	PRINTF ("ERROR: remove key failed\n");
	return;
 }
 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 3) failed\n");
	return;
 }
 if (((type & KEY_INSERTED)&&(!(type&READ_PROTECTED))&&(!(type&READ_PROTECTED))) == KEY_INSERTED) // check that key removed
 {
	PRINTF ("ERROR: Key removed but get type say otherwise.\n");
	return;
 }
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, key, &type)!=0) // insert key
 {
	PRINTF ("ERROR: get type (try 4) failed\n");
	return;
 }
 type = PROTECTION_CHANGE_KEY;
 if (protectHWBDTL (drive, 0, newkey, &type)!=0)  // Change key
 {
	PRINTF ("ERROR: change key failed\n");
	return;
 }
 /*
 type = PROTECTION_REMOVE_KEY;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)// remove key
 {
	PRINTF ("ERROR: remove key (after changing it)\n");
	return;
 }
 */
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, "22222222", &type)==0) // insert wrong key
 {
	PRINTF ("ERROR: insert wrong key recieved status OK\n");
	return;
 }
 else
 {
	PRINTF ("Insert wrong key test - passed\n\n");
 }

 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 5) failed\n");
	return;
 }
 if ((type & KEY_INSERTED) == KEY_INSERTED) // check that key removed
 {
	PRINTF ("ERROR: Key removed but get type say otherwise.\n");
	return;
 }
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, newkey, &type)!=0) // insert right key
 {
	PRINTF ("ERROR: insert wrong key recieved status OK\n");
	return;
 }

 type = PROTECTION_CHANGE_KEY;
 if (protectHWBDTL (drive, 0, key, &type)!=0)  // Change key to original one.
 {
	PRINTF ("ERROR: change key failed\n");
	return;
 }
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, key, &type)!=0) // insert right key
 {
	PRINTF ("ERROR: insert wrong key recieved status OK\n");
	return;
 }
 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 5) failed\n");
	return;
 }
 attr = type;
 type = PROTECTION_CHANGE_TYPE;
 if (protectHWBDTL (drive, PROTECTABLE | READ_PROTECTED | WRITE_PROTECTED, NULL, &type)!=0)  // Change type
 {
	PRINTF ("ERROR: change protection type failed\n");
	return;
 }
 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 6) failed\n");
	return;
 }
 if (type & (PROTECTABLE | READ_PROTECTED | WRITE_PROTECTED) == (attr ^ WRITE_PROTECTED) & (PROTECTABLE | READ_PROTECTED | WRITE_PROTECTED))
 {
	PRINTF ("ERROR: Type changed but read is wrong\n");
	return;
 }
 type = PROTECTION_INSERT_KEY;
 if (protectHWBDTL (drive, 0, key, &type)!=0) // insert right key
 {
	PRINTF ("ERROR: insert wrong key recieved status OK\n");
	return;
 }
 type = PROTECTION_CHANGE_TYPE;
 if (protectHWBDTL (drive, PROTECTABLE, NULL, &type)!=0)  // Change type
 {
	PRINTF ("ERROR: change protection type failed\n");
	return;
 }
 type = PROTECTION_GET_TYPE;
 if (protectHWBDTL (drive, 0, NULL, &type)!=0)
 {
	PRINTF ("ERROR: get type (try 6) failed\n");
	return;
 }
 if ((type & (PROTECTABLE | READ_PROTECTED | WRITE_PROTECTED)) == (attr & (PROTECTABLE | READ_PROTECTED | WRITE_PROTECTED)))
 {
	PRINTF ("ERROR: Type changed but read is wrong\n");
	return;
 }

}

